; Converted from Markdown - Chapter 1
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:1mORMot2 Overview
{}
{\i Meet the m@*ORM@ot}
{}
{\b Synopse mORMot 2} is an Open Source Client-Server ORM/@*SOA@/@*MVC@ framework for {\i Delphi} and {\i Free Pascal}, targeting Windows, Linux, BSD, and macOS for the server, and virtually any platform for clients (including mobile and AJAX).
{}
This is {\b mORMot 2}, a complete rewrite of the original mORMot framework with improved architecture, cleaner code organization, and modern Object Pascal patterns.
{}
: Main Features
{}
The main features of {\i mORMot 2} are:
{}
- {\b ORM/@*ODM@}: Object persistence on almost any database (SQL or NoSQL)
- {\b SOA}: Organize your business logic into @*REST@ful @*JSON@ services
- {\b Clients}: Consume your data or services from any platform, via ORM classes or SOA interfaces
- {\b Web MVC}: Publish your ORM/SOA processes as responsive Web Applications
{}
All features work with local or remote access, via an auto-configuring Client-Server REST design.
{}
$┌────────────────────────────────────────────────────────────────────────┐
$│                         mORMot2 Architecture                           │
$├────────────────────────────────────────────────────────────────────────┤
$│                                                                        │
$│  SQL Databases              NoSQL Databases        Services            │
$│  ─────────────              ────────────────       ────────            │
$│  · SQLite3                  · MongoDB              · Method-based      │
$│  · PostgreSQL               · In-Memory            · Interface-based   │
$│  · MySQL/MariaDB            · Files                · Asynchronous      │
$│  · MS SQL Server                                   · Remote (SaaS)     │
$│  · Oracle                        ↓                                     │
$│  · Firebird                     ODM                      ↓             │
$│  · DB2                           ↓                      SOA            │
$│  · Informix                      │                       │             │
$│        ↓                         │                       │             │
$│       ORM ───────────────────────┴───────────────────────┘             │
$│        │                                                               │
$│        └─────────────────────────┬────────────────────────             │
$│                                  ↓                                     │
$│                            REST Server                                 │
$│                        ┌────────┴────────┐                             │
$│                        │    MVC/MVVM     │                             │
$│                        │   Web Server    │                             │
$│                        └────────┬────────┘                             │
$│                                 ↓                                      │
$│  ┌──────────────────────────────┴───────────────────────────────────┐  │
$│  │                       REST Clients                               │  │
$│  │   · Delphi Desktop/Mobile  · AJAX  · Any HTTP Client             │  │
$│  └──────────────────────────────────────────────────────────────────┘  │
$│                                                                        │
$│  Cross-Cutting Features:                                               │
$│  · User Management & Security   · Sessions & Replication               │
$│  · Unit Testing & Mocks/Stubs   · Logging & Profiling                  │
$│  · http.sys & WebSockets        · Templates (Mustache)                 │
$│  · JSON & Cryptography          · PDF & Reporting                      │
$└────────────────────────────────────────────────────────────────────────┘
{}
{\i mORMot 2} offers all features needed for building any kind of modern software project, with state-of-the-art integrated software components, designed for both completeness and complementarity, offering {\i convention over configuration} solutions, and implemented for speed and efficiency.
{}
: Quick Start Examples
{}
{\b For storing data}, you define a class, and the framework handles everything: routing, JSON marshalling, table creation, SQL generation, validation.
{}
!type
!  TOrmCustomer = class(TOrm)
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Email: RawUtf8 read fEmail write fEmail;
!    property Balance: Currency read fBalance write fBalance;
!  end;
!
!// Create model and server
!Model := TOrmModel.Create([TOrmCustomer]);
!Server := TRestServerDB.Create(Model, 'customers.db3');
!Server.Server.CreateMissingTables;
!
!// Add a customer
!Customer := TOrmCustomer.Create;
!Customer.Name := 'John Doe';
!Customer.Email := 'john@example.com';
!Server.Orm.Add(Customer, true);
{}
{\b For creating a service}, you define an interface and a class:
{}
!type
!  ICalculator = interface(IInvokable)
!    ['{9A60C8ED-CEB2-4E09-87D4-4A16F496E5FE}']
!    function Add(A, B: Integer): Integer;
!    function Multiply(A, B: Integer): Integer;
!  end;
!
!  TCalculator = class(TInjectableObjectRest, ICalculator)
!  public
!    function Add(A, B: Integer): Integer;
!    function Multiply(A, B: Integer): Integer;
!  end;
!
!// Register on server
!Server.ServiceDefine(TCalculator, [ICalculator], sicShared);
!
!// Call from client
!var Calc: ICalculator;
!if Client.Services.Resolve(ICalculator, Calc) then
!  Result := Calc.Add(10, 20);
{}
{\b For building a MVC web site}, write a Controller class in Delphi, then HTML Views using {\i Mustache} templates, leveraging the same ORM/SOA methods as Model.
{}
: What's New in mORMot 2
{}
mORMot 2 is a complete rewrite of the original mORMot framework. Key improvements include:
{}
:  Cleaner Architecture
- {\b Renamed types}: {\f1\fs20 TSQLRecord} → {\f1\fs20 TOrm}, {\f1\fs20 TSQLRest} → {\f1\fs20 TRest}, {\f1\fs20 TSQLModel} → {\f1\fs20 TOrmModel}
- {\b Split units}: Large {\f1\fs20 SynCommons.pas} split into ~24 focused {\f1\fs20 mormot.core.*} units
- {\b @*SOLID@ principles}: Composition over inheritance, interface-based design
{}
:  Unit Organization
!mormot.core.*   - Foundation (text, JSON, RTTI, logging, threading)
!mormot.crypt.*  - Cryptography (AES, SHA, ECC, RSA, JWT, X.509)
!mormot.net.*    - Networking (HTTP, WebSockets, async I/O)
!mormot.db.*     - Database access (SQL and NoSQL)
!mormot.orm.*    - Object-Relational Mapping
!mormot.soa.*    - Service-Oriented Architecture
!mormot.rest.*   - RESTful client/server
!mormot.app.*    - Application utilities (console, daemon)
!mormot.ui.*     - VCL/LCL components
{}
:  New Features in mORMot 2
- {\b Async @*HTTP@ Server} ({\f1\fs20 useHttpAsync}) - Event-driven for massive concurrency
- {\b Factory-based Cryptography} - {\f1\fs20 Hash()}, {\f1\fs20 Sign()}, {\f1\fs20 Cipher()}, {\f1\fs20 Asym()}, {\f1\fs20 Cert()} factories
- {\b ACME/Let's Encrypt} - Automatic {\f1\fs20 TLS} certificate management
- {\b Native X.509/RSA} - Pure Pascal implementation without OpenSSL dependency
- {\b OpenAPI Generator} - Generate Delphi clients from Swagger specs
- {\b QuickJS Engine} - Modern JavaScript scripting (replaces SpiderMonkey)
{}
:  Compiler Support
- {\b Delphi}: 7 through 12.2 (RAD Studio 12 Athens)
- {\b Free Pascal}: 3.2.2+ with fixes
- {\b Platforms}: Windows (32/64-bit), Linux (x64/ARM64), macOS, FreeBSD
{}
:101 Client-Server ORM/SOA Framework
{}
The {\i mORMot 2 framework} implements a Client-Server RESTful architecture, following MVC, N-Tier, ORM, and SOA best-practice patterns.
{}
Multiple clients can access the same remote or local server using diverse communication protocols:
{}
$┌───────────────────────────────────────────────────────────────────┐
$│                     Network Architecture                          │
$├───────────────────────────────────────────────────────────────────┤
$│                                                                   │
$│  ┌─────────┐  ┌─────────┐                      ┌─────────┐        │
$│  │Client 1 │  │Client 2 │    Internet/VPN      │Client n │        │
$│  │ Delphi  │  │  AJAX   │        ║             │ Delphi  │        │
$│  └────┬────┘  └────┬────┘        ║             └────┬────┘        │
$│       │            │             ║                  │             │
$│       └────────────┴─────────────╨──────────────────┘             │
$│                          │                                        │
$│                   JSON + REST                                     │
$│                   over HTTP/HTTPS                                 │
$│                          │                                        │
$│                   ┌──────┴──────┐                                 │
$│                   │   Server    │                                 │
$│                   │ (mORMot 2)  │                                 │
$│                   └─────────────┘                                 │
$└───────────────────────────────────────────────────────────────────┘
{}
Or the application can be stand-alone:
{}
$┌─────────────────────────────────────────┐
$│       Stand-Alone Application           │
$│  ┌──────────┐    ┌──────────┐           │
$│  │  Client  │───►│  Server  │           │
$│  │  Code    │    │  Code    │           │
$│  └──────────┘    └──────────┘           │
$│        direct in-process access         │
$└─────────────────────────────────────────┘
{}
Switching between embedded and client-server architecture is just a matter of how {\i mORMot} classes are initialized. The same executable can run as a stand-alone application, a server, or a client, depending on runtime parameters!
{}
:102 Highlights
{}
Key distinguishing features of mORMot 2:
{}
- {\b Client-Server orientation} with optimized request caching and intelligent updates over a RESTful architecture - but can also be used in stand-alone applications
- {\b No RAD components} - True ORM and SOA approach
- {\b Multi-Tier architecture} with integrated business rules as fast ORM-based classes and {\i Domain-Driven} design
- {\b Service-Oriented-Architecture} model using custom RESTful JSON services - send any {\f1\fs20 TObject}, dynamic array, or record as JSON via interface-based contracts shared on both client and server
- {\b Truly RESTful authentication} with dual security model (session + per-query)
- {\b Very fast JSON} producer and parser with caching at SQL level
- {\b Fast HTTP/@*HTTPS@ server} using {\f1\fs20 http.sys} kernel-mode server (Windows) or async event-driven server (all platforms) - plus named pipes, @*WebSocket@s, or in-process alternatives
- {\b @*SQLite3@ kernel} with ability to connect to any external database (@*PostgreSQL@, @*MySQL@, @*Oracle@, MS SQL, Firebird, etc.) via direct client libraries, ODBC, or OLE DB
- {\b RESTful ORM access to NoSQL} like @*MongoDB@ with the same code base
- {\b Multiple databases at once} via SQLite3 Virtual Tables mechanism
- {\b Full Text Search} engine with Google-like ranking algorithm
- {\b Native cryptography} including AES, SHA, ECC, RSA, @*JWT@, X.509 with optional OpenSSL acceleration
- {\b Direct User Interface generation} with grids and Ribbon layouts
- {\b Integrated Reporting} system serving PDF reports
- {\b Optimized for performance} (assembly when needed, buffered I/O, multi-threaded architecture)
- {\b Cross-platform clients} from Delphi, Free Pascal, mobile, and AJAX
- {\b Full source code} provided under open source license
{}
:103 Benefits
{}
{\i mORMot} provides a comprehensive set of features to manage your crosscutting concerns through a reusable set of components and core functionality.
{}
Benefits include:
{}
- {\b KISS convention over configuration}: All needed features at hand, with one clear way of doing things
- {\b Pascal-oriented}: Implementation leverages Object Pascal's type system rather than mimicking Java/C# patterns
- {\b Integrated}: All crosscutting scenarios are coupled with consistent APIs, extensive code reuse, and JSON/RESTful orientation from the ground up
- {\b Tested}: Most of the framework is test-driven, with comprehensive regression tests including system-wide integration tests
- {\b Don't reinvent the wheel}: Focus on your business logic, not infrastructure
- {\b Open Source and maintained}: Active development community - mORMot won't leave you soon!
{}
:104 Legacy Code and Existing Projects
{}
Even if {\i mORMot} works best in projects designed from scratch, it fits very well for evolving existing {\i Delphi} projects or creating server-side components for AJAX applications.
{}
One key benefit is facilitating the transition from traditional Client-Server architecture to N-Tier layered patterns.
{}
Due to its modular design, you can integrate framework components into existing applications:
{}
- {\b Add logging} to track issues and enable customer-side performance profiling
- {\b Use low-level classes} like record or dynamic array wrappers, or dynamic document storage via {\f1\fs20 TDocVariant}
- {\b Use direct DB layers} including high-performance database access, array binding for fast inserts, or NoSQL databases
- {\b Reports} can use the @!src\ui\mormot.ui.report.pas@ code-based system for server-side PDF generation
- {\b HTTP requests} can be exposed using method-based services, e.g., for rendering HTML with Mustache templates
- {\b Migrate to SOA} by moving logic into server services defined via interfaces, without SOAP/WCF overhead
- {\b RESTful interface} for JSON consumption via AJAX or mobile clients
- {\b New tables via ORM} in your existing SQL server or new storage like MongoDB
- {\b In-memory engine} or SQLite3-based consolidation for performance-critical scenarios
- {\b Support for older Delphi versions} (starting from Delphi 7) for projects that can't easily upgrade
{}
:105 FAQ
{}
Before going further, here are answers to frequently asked questions.
{}
:  Should I use mORMot 1 since mORMot 2 is the maintained version?
{}
{\b mORMot 2} is the way to go for any new project. mORMot 1 is in bug-fix-only mode. For existing mORMot 1 projects, we continue to fix bugs and supply SQLite3 updates, but no new features will appear. Consider migrating to mORMot 2 when you have time - the process is straightforward once you change to the new units.
{}
:  The documentation is too long to read quickly.
{}
You don't need to read everything - most is detailed API reference. But do read the first part covering main concepts and patterns (15-30 minutes). Also see the slides and examples available at @https://github.com/synopse/mORMot2
{}
:  Where should I start?
{}
1. Read the Architecture Principles (Chapter 2)
2. Download and install the sources
3. Compile and run the test programs in {\f1\fs20 /test}
4. Learn about ORM, SOA, and MVC concepts
5. Try the sample projects in {\f1\fs20 /ex} folder
{}
:  I'm not a fan of ORM - I prefer writing SQL.
{}
ORM makes development easier, but you can use interface-based services with "manual" SQL via the {\f1\fs20 mormot.db.*} classes for high performance and direct JSON export.
{}
:  mORMot requires inheriting from TOrm. Can I use any object?
{}
We discuss this in detail in the ORM chapter. Adding attributes to existing classes pollutes your code. The framework provides CQRS services to persist any PODO (Plain Old Delphi Object) without requiring {\f1\fs20 @**TOrm@} inheritance.
{}
:  Why don't you use generics or class attributes?
{}
Our framework uses Object Pascal's type system effectively - specifying a class or interface type as parameter is safe and efficient. Generics tend to bloat executables, reduce performance, and hide implementation details. Attributes pollute code and introduce coupling. These features also reduce compatibility with older Delphi and FPC.
{}
:  What are RawUtf8 and other special types?
{}
The framework uses @*UTF-8@ internally. {\f1\fs20 RawUtf8} is optimized for UTF-8 strings across all Delphi versions. Search the keyword index for {\f1\fs20 RawUtf8} or see the Core Units chapter.
{}
:  My client receives non-standard JSON with unquoted fields.
{}
Internally, the framework uses MongoDB extended JSON syntax (unquoted fields) for better performance. Add a proper {\f1\fs20 User-Agent} HTTP header to receive standard {\f1\fs20 "field":value} JSON.
{}
:  Why is this framework named mORMot?
{}
- Because marmots hibernate, like our precious objects
- Because marmots are highly social and communicate with whistles, like our connected applications
- Because "Manage Object Relational Mapping Over Territory" works as an acronym
- Because we like mountains and those large ground rodents!
{}
:106 Getting Started
{}
:  Installation
{}
Clone from GitHub:
$git clone https://github.com/synopse/mORMot2.git
{}
:  Minimal Project Setup
{}
!program MyFirstMormot;
!
!{$APPTYPE CONSOLE}
!
!uses
!  mormot.core.base,
!  mormot.core.os,
!  mormot.orm.core,
!  mormot.orm.sqlite3,
!  mormot.rest.sqlite3,
!  mormot.rest.http.server;
!
!type
!  TOrmSample = class(TOrm)
!  private
!    fName: RawUtf8;
!    fValue: Integer;
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Value: Integer read fValue write fValue;
!  end;
!
!var
!  Model: TOrmModel;
!  Server: TRestServerDB;
!  HttpServer: TRestHttpServer;
!begin
!  // Create ORM model with our class
!  Model := TOrmModel.Create([TOrmSample]);
!
!  // Create REST server with SQLite3 storage
!  Server := TRestServerDB.Create(Model, 'sample.db3');
!  Server.Server.CreateMissingTables;
!
!  // Wrap in HTTP server
!  HttpServer := TRestHttpServer.Create('8080', [Server], '+', useHttpAsync);
!  try
!    WriteLn('Server running on http://localhost:8080');
!    WriteLn('Press Enter to quit...');
!    ReadLn;
!  finally
!    HttpServer.Free;
!    Server.Free;
!    Model.Free;
!  end;
!end.
{}
:  Required Units by Feature
{}
{\b Core functionality:}
!uses
!  mormot.core.base,      // Foundation types
!  mormot.core.os,        // OS abstraction
!  mormot.core.text,      // Text processing
!  mormot.core.json;      // JSON handling
{}
{\b ORM/Database:}
!uses
!  mormot.orm.core,       // TOrm, TOrmModel
!  mormot.orm.sqlite3,    // SQLite3 ORM
!  mormot.db.sql.sqlite3; // SQLite3 engine (if direct SQL needed)
{}
{\b REST Server/Client:}
!uses
!  mormot.rest.core,        // TRest base
!  mormot.rest.server,      // TRestServer
!  mormot.rest.client,      // TRestClient
!  mormot.rest.http.server, // TRestHttpServer
!  mormot.rest.http.client; // TRestHttpClient
{}
{\b Services (SOA):}
!uses
!  mormot.soa.core,    // Service interfaces
!  mormot.soa.server,  // Server-side services
!  mormot.soa.client;  // Client-side service consumption
{}
{\i Next Chapter: Architecture Principles}
{}