; Converted from Markdown - Chapter 2
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:2Architecture Principles
{}
{\i Adopt a m@*ORM@ot}
{}
This framework implements established "best-practice" patterns:
{}
- {\b Model-View-Controller} (@*MVC@)
- {\b Multi-tier architecture}
- {\b Test-Driven Design}
- {\b Stateless @*CRUD@/@*REST@}
- {\b Object-Relational Mapping} (ORM)
- {\b Object-Document Mapping} (@*ODM@)
- {\b Service-Oriented Architecture} (@*SOA@)
{}
These patterns enable implementing projects up to complex {\i Domain-Driven Design} architectures.
{}
:201 General Design
{}
The mORMot 2 architecture follows a layered design:
{}
$┌────────────────────────────────────────────────────────────────────┐
$│                      mORMot 2 Architecture                         │
$├────────────────────────────────────────────────────────────────────┤
$│                                                                    │
$│  ┌───────────────┐                       ┌───────────────┐         │
$│  │  Web Clients  │                       │ REST Clients  │         │
$│  │ (AJAX/Mobile) │                       │(Delphi/FPC/…) │         │
$│  └───────┬───────┘                       └───────┬───────┘         │
$│          │                                       │                 │
$│          └───────────────┬───────────────────────┘                 │
$│                          │ RESTful JSON                            │
$│                          ▼                                         │
$│  ┌──────────────────────────────────────────────────────────────┐  │
$│  │                      TRestServer                             │  │
$│  │  ┌────────────┐  ┌───────────┐  ┌───────────────────────┐    │  │
$│  │  │ Auth       │  │ MVC/MVVM  │  │ Services              │    │  │
$│  │  │ (Sessions) │  │ WebServer │  │ (Interface-based SOA) │    │  │
$│  │  └────────────┘  └───────────┘  └───────────────────────┘    │  │
$│  │                         │                                    │  │
$│  │                ┌────────┴────────┐                           │  │
$│  │                │    IRestOrm     │                           │  │
$│  │                │    ORM Layer    │                           │  │
$│  │                └────────┬────────┘                           │  │
$│  └─────────────────────────┼────────────────────────────────────┘  │
$│                            │                                       │
$│  ┌─────────────────────────┴────────────────────────────────────┐  │
$│  │                    Storage Backends                          │  │
$│  │  ┌─────────┐  ┌─────────┐  ┌─────────┐  ┌────────────────┐   │  │
$│  │  │ SQLite3 │  │External │  │ MongoDB │  │ In-Memory/File │   │  │
$│  │  │ (native)│  │  SQL    │  │ (NoSQL) │  │  (JSON/Binary) │   │  │
$│  │  └─────────┘  └─────────┘  └─────────┘  └────────────────┘   │  │
$│  └──────────────────────────────────────────────────────────────┘  │
$│                                                                    │
$│  Cross-Cutting Features:                                           │
$│  ┌──────────────────────────────────────────────────────────────┐  │
$│  │ Compression │ Security │ Crypto │ Logging │ Testing │ JSON   │  │
$│  └──────────────────────────────────────────────────────────────┘  │
$└────────────────────────────────────────────────────────────────────┘
{}
Key concepts of mORMot 2:
{}
- {\b Cross-Platform}: Multiple clients and devices supported
- {\b Integration-friendly}: Can integrate with existing codebases
- {\b Client-Server RESTful}: @*JSON@ over @*HTTP@/@*HTTPS@/@*WebSocket@s
- {\b Layered (multi-tier)}: Clear separation of concerns
- {\b Service-Oriented}: Business logic via SOA interfaces
- {\b Shared Model}: Business rules and data model shared by clients and server
- {\b ORM/ODM}: Data mapped to objects for SQL and NoSQL
- {\b Flexible Storage}: @*SQLite3@, external SQL, @*MongoDB@, in-memory, or remote mORMot servers
- {\b Integrated Security}: Authentication and authorization at all layers
- {\b MVC/@*MVVM@}: Build web applications from ORM/SOA methods
- {\b Pattern-based}: REST, JSON, MVC, @*SOLID@ principles
- {\b Testable}: Integrated testing and debugging API
- {\b Optimized}: Built for scaling and stability
{}
:202 Architecture Design Process
{}
Architecture should be driven by actual application needs, not by theoretical patterns. There is no "one architecture fits all" solution. Architecture is about {\i how} you build your software.
{}
$┌─────────────────────────────────────────────────────────────────┐
$│            Iterative Architecture Process                       │
$│                                                                 │
$│  Customer ──► BackLog ──► Design ──► Dev ──► Software           │
$│     │            │          │         │         │               │
$│     │            │          │         │         │               │
$│  Use Cases  Requirements  Architecture Tasks   Definition       │
$│                              │                   of Done        │
$│                              │                                  │
$│                         Risk Assessment                         │
$│                         Technology & Models                     │
$└─────────────────────────────────────────────────────────────────┘
{}
:  Avoiding Weak Design
{}
Common pitfalls to avoid:
{}
- Letting each developer decide implementation without review
- Letting teams work in isolation without system-wide collaboration
- Architecture at such a high level it doesn't affect coding
- Architecture so detailed that code becomes over-engineered
- Blindly following technology trends without evaluation
{}
:  Recommended Practices
{}
- {\b Collaboration}: No one is alone, no team is better, no manager is always right
- {\b Sharing}: Between individuals, teams, and managers
- {\b Customer focus}: Stay content and customer focused
- {\b Long-term thinking}: Today's implementation prepares tomorrow
- {\b Pragmatism}: Make tomorrow's work easier
- {\b Courage}: "They did not know it was impossible, so they did it"
{}
Frameworks like mORMot provide integrated, working sets of classes so you can focus on your product while enjoying collaboration with the Open Source community.
{}
:203 Model-View-Controller (MVC)
{}
The {\i Model-View-Controller} (MVC) pattern isolates domain logic from user interface, permitting independent development, testing, and maintenance.
{}
$┌───────────────────────────────────────────────────────────┐
$│                    MVC Pattern                            │
$│                                                           │
$│  ┌──────────┐    Uses     ┌──────────┐                    │
$│  │Controller│ ──────────► │  Model   │                    │
$│  └──────────┘             └──────────┘                    │
$│       │                         │                         │
$│       │ Command                 │ Notify Updates          │
$│       ▼                         ▼                         │
$│  ┌──────────┐    Refresh  ┌──────────┐                    │
$│  │   View   │ ◄────────── │  Model   │                    │
$│  └──────────┘             └──────────┘                    │
$└───────────────────────────────────────────────────────────┘
{}
{\b Model}: Manages behavior and data of the application domain. Responds to requests for information about its state and instructions to change state. In mORMot, implemented via {\f1\fs20 TOrmModel} class which centralizes all {\f1\fs20 TOrm}-inherited classes.
{}
{\b View}: Renders the model into a form suitable for interaction:
- {\b Desktop clients}: Auto-generated UI using @*RTTI@
- {\b Web clients}: Mustache templates with Delphi controllers
- {\b AJAX clients}: RESTful JSON services
{}
{\b Controller}: Receives user input and initiates responses by making calls on model objects. In mORMot, already implemented within RESTful commands. Custom actions implemented via {\f1\fs20 TOrm} classes or RESTful Services.
{}
:204 Multi-Tier Architecture
{}
Multi-tier architecture separates presentation, application processing, and data management into logically separate processes.
{}
:  Two-Tier (Traditional RAD)
{}
$┌─────────────────────────────────────────────────────────┐
$│  ┌─────────────────────┐    ┌─────────────────────┐     │
$│  │  Application Tier   │    │    Data Tier        │     │
$│  │  (UI + Logic mixed) │───►│    (Database)       │     │
$│  └─────────────────────┘    └─────────────────────┘     │
$└─────────────────────────────────────────────────────────┘
{}
:  Three-Tier (mORMot ORM/SOA)
{}
$┌─────────────────────────────────────────────────────────────────┐
$│  ┌─────────────────┐  ┌─────────────────┐  ┌─────────────────┐  │
$│  │ Presentation    │  │   Logic Tier    │  │   Data Tier     │  │
$│  │     Tier        │─►│  (ORM + SOA)    │─►│  (Database)     │  │
$│  └─────────────────┘  └─────────────────┘  └─────────────────┘  │
$└─────────────────────────────────────────────────────────────────┘
{}
:  Four-Tier (Domain-Driven Design)
{}
$┌───────────────────────────────────────────────────────────────────────┐
$│  ┌──────────────┐  ┌──────────────┐  ┌──────────────┐  ┌──────────┐   │
$│  │ Presentation │  │ Application  │  │Business Logic│  │  Data    │   │
$│  │    Tier      │─►│    Tier      │─►│    Tier      │─►│  Tier    │   │
$│  │(Delphi/AJAX) │  │(JSON Server) │  │  (Domain)    │  │(Storage) │   │
$│  └──────────────┘  └──────────────┘  └──────────────┘  └──────────┘   │
$└───────────────────────────────────────────────────────────────────────┘
{}
In mORMot 2:
{}
- {\b Data Tier}: SQLite3, external databases (@*PostgreSQL@, @*MySQL@, @*Oracle@, MS SQL, etc.), MongoDB, or in-memory storage
- {\b Logic Tier}: ORM and SOA implementation - Delphi classes mapped to database via ORM, business logic as interfaces
- {\b Presentation Tier}: Delphi clients, AJAX applications, or MVC web apps
{}
:205 Service-Oriented Architecture (SOA)
{}
SOA is a design approach where functionality is packaged as inter-operable services that can be used across multiple systems and business domains.
{}
$┌──────────────────────────────────────────────────────────────────┐
$│                    SOA Architecture                              │
$│                                                                  │
$│  Consumers                Service Bus               Publishers   │
$│  ─────────                ───────────               ──────────   │
$│  ┌─────────┐             ┌───────────┐            ┌───────────┐  │
$│  │Client A │◄───────────►│           │◄──────────►│Publisher 1│  │
$│  └─────────┘             │           │            └───────────┘  │
$│  ┌─────────┐             │  Service  │            ┌───────────┐  │
$│  │Client B │◄───────────►│    Bus    │◄──────────►│Publisher 2│  │
$│  └─────────┘             │           │            └───────────┘  │
$│  ┌─────────┐             │           │            ┌───────────┐  │
$│  │Client C │◄───────────►│           │◄──────────►│Publisher 3│  │
$│  └─────────┘             └───────────┘            └───────────┘  │
$└──────────────────────────────────────────────────────────────────┘
{}
:  Key SOA Characteristics
{}
A software {\b service} is a logical representation of a repeatable activity that produces a precise result. Services are:
{}
- {\b Loosely coupled}: No embedded calls to other services
- {\b Stateless}: Each invocation is independent
- {\b Single responsibility}: Each service implements one action
- {\b Protocol-based}: Defined protocols describe how services communicate
{}
:  SOA Benefits: Decoupling
{}
|%13%55%32
|\b Dependency|Desired Decoupling|Technique\b0
|Platform|Hardware/Framework/OS should not constrain choices|Standard protocols (REST/JSON)
|Location|Consumers unaffected by hosting changes|Routing and proxies
|Availability|Maintenance transparent to clients|Server-side support
|Versions|New services without client upgrades|Contract marshalling
|%
{}
:  ORM + SOA Coexistence
{}
ORM and SOA complement each other:
{}
- {\b ORM}: Efficient data access with native objects (CQRS pattern)
- {\b SOA}: High-level business logic with custom parameters, reducing bandwidth
{}
In mORMot 2, interface-based SOA allows the same code to run on both client and server with better server performance and full interoperability.
{}
:206 Object-Relational Mapping (ORM)
{}
ORM provides methods to persist high-level objects into a relational database.
{}
$┌───────────────────────────────────────────────────────────────┐
$│                      ORM Process                              │
$│                                                               │
$│  ┌──────────────┐    ┌─────────────┐    ┌──────────────────┐  │
$│  │    Object    │───►│     ORM     │───►│     RDBMS        │  │
$│  │   Instance   │    │   (CRUD)    │    │   (Database)     │  │
$│  └──────────────┘    └─────────────┘    └──────────────────┘  │
$│                            │                                  │
$│                      SQL Mapping                              │
$└───────────────────────────────────────────────────────────────┘
{}
:  ORM Mapping Sources
{}
$┌────────────────────────────────────────────────────────────────┐
$│  ┌─────────────────┐         ┌─────────────────┐               │
$│  │   Class Type    │         │   Data Model    │               │
$│  │   (via RTTI)    │────────►│   (Database)    │               │
$│  └─────────────────┘         └─────────────────┘               │
$│           │                           │                        │
$│           └───────────┬───────────────┘                        │
$│                       │                                        │
$│                  ┌────┴────┐                                   │
$│                  │   ORM   │                                   │
$│                  └─────────┘                                   │
$└────────────────────────────────────────────────────────────────┘
{}
:  Comparison of Approaches
{}
|%13%44%43
|\b Scheme|Pros|Cons\b0
|{\b RAD DB Components}|SQL is powerful; RAD approach|Business logic limited; SQL binds to engine; Poor multi-tier
|{\b Manual SQL Mapping}|Elaborated business logic|SQL must be hand-coded; Duplication; Engine-specific
|{\b Database ORM}|SQL generated by ORM; Engine-agnostic|More abstraction needed; May retrieve excess data
|{\b Client-Server ORM}|All ORM benefits; Services for precise data; Full multi-tier|More abstraction needed
|%
{}
mORMot implements a {\b Client-Server ORM} that can scale from stand-alone mode to complex Domain-Driven Design.
{}
:207 NoSQL and Object-Document Mapping (ODM)
{}
:  SQL vs NoSQL
{}
{\b SQL (Relational)}:
- Schema-based
- Relational model with JOINs
- @*ACID@ transactions
- Time-proven and efficient
{}
{\b NoSQL}:
- "Not Only SQL"
- Designed for web scale and BigData
- Easy replication and simple APIs
- No standard (diverse implementations)
{}
:  NoSQL Families
{}
1. {\b Graph-oriented}: Store data by relations (e.g., Neo4j)
2. {\b Aggregate-oriented}:
   - Document-based (MongoDB, CouchDB)
   - Key/Value (Redis, Riak)
   - Column family (Cassandra, HBase)
{}
:  Document Model Example
{}
SQL stores data per table (requires JOINs):
$┌─────────────────┐  ┌─────────────────┐  ┌─────────────────┐
$│     Users       │  │    Contacts     │  │     Access      │
$├─────────────────┤  ├─────────────────┤  ├─────────────────┤
$│ ID | UserName   │  │ UserID | Phone  │  │ UserID | Level  │
$└─────────────────┘  └─────────────────┘  └─────────────────┘
{}
NoSQL stores as documents (embedded):
${
$  "ID": 1234,
$  "UserName": "John Smith",
$  "Contact": {
$    "Phone": "123-456-789",
$    "Email": "xyz@abc.com"
$  },
$  "Access": {
$    "Level": 5,
$    "Group": "dev"
$  }
$}
{}
:  SQL vs NoSQL Trade-offs
{}
|%47%53
|\b SQL|NoSQL\b0
|Ubiquitous SQL language|Maps OOP and complex types natively
|Easy vertical scaling|Horizontal scaling (sharding)
|Data normalization|Schema-less evolution
|Data consistency (single source)|Version management
|Complex ACID transactions|Graph/Document native storage
|Aggregation functions|Map/Reduce support
|%
{}
With mORMot, you can switch from SQL to MongoDB with one line of code change, even at runtime.
{}
:208 Domain-Driven Design (DDD)
{}
:  Definition
{}
From domaindrivendesign.org:
{}
{\i "The premise of domain-driven design is two-fold:}
- {\i For most software projects, the primary focus should be on the domain and domain logic;}
- {\i Complex domain designs should be based on a model."}
{}
:  DDD in mORMot
{}
mORMot enables @*DDD@ through:
{}
- {\b Entities}: {\f1\fs20 TOrm} descendants representing persistent domain objects
- {\b Value Objects}: Records and managed types for immutable data
- {\b Aggregates}: Object graphs with clear boundaries
- {\b Repositories}: {\f1\fs20 IRestOrm} interface for data access
- {\b Services}: Interface-based SOA for domain operations
- {\b Domain Events}: Async notifications via WebSockets
{}
:  Implementation Layers
{}
$┌─────────────────────────────────────────────────────────────────────────┐
$│                        DDD with mORMot 2                                │
$│                                                                         │
$│  ┌───────────────────────────────────────────────────────────────────┐  │
$│  │ Domain Layer (Pure Pascal)                                        │  │
$│  │ · TOrm entities with business logic                               │  │
$│  │ · Value Objects as records                                        │  │
$│  │ · Aggregates with clear boundaries                                │  │
$│  └───────────────────────────────────────────────────────────────────┘  │
$│                                  │                                      │
$│  ┌───────────────────────────────┴───────────────────────────────────┐  │
$│  │ Application Layer (Services)                                      │  │
$│  │ · IInvokable interfaces (mormot.soa.*)                            │  │
$│  └───────────────────────────────────────────────────────────────────┘  │
$│                                  │                                      │
$│  ┌───────────────────────────────┴───────────────────────────────────┐  │
$│  │ Infrastructure Layer                                              │  │
$│  │ · IRestOrm repositories (mormot.orm.*)                            │  │
$│  │ · TSqlDBConnection (mormot.db.*)                                  │  │
$│  └───────────────────────────────────────────────────────────────────┘  │
$│                                  │                                      │
$│  ┌───────────────────────────────┴───────────────────────────────────┐  │
$│  │ Presentation Layer                                                │  │
$│  │ · TRestHttpServer (mormot.rest.*)                                 │  │
$│  │ · MVC views (mormot.core.mvc)                                     │  │
$│  └───────────────────────────────────────────────────────────────────┘  │
$└─────────────────────────────────────────────────────────────────────────┘
{}
:209 SOLID Principles in mORMot 2
{}
mORMot 2 embraces SOLID principles:
{}
:  Single Responsibility
- Each unit focuses on one concern
- @!src\core\mormot.core.json.pas@ handles JSON, @!src\core\mormot.core.rtti.pas@ handles RTTI
{}
:  Open/Closed
- Classes open for extension via inheritance
- Core behavior closed to modification
{}
:  Liskov Substitution
- {\f1\fs20 TOrm} descendants can substitute the base class
- Storage backends interchangeable
{}
:  Interface Segregation
- {\f1\fs20 IRestOrm} vs {\f1\fs20 IRestOrmClient} vs {\f1\fs20 IRestOrmServer}
- Clients only depend on what they need
{}
:  Dependency Inversion
- Code against interfaces ({\f1\fs20 IRestOrm}), not implementations
- DI support via {\f1\fs20 TInjectableObjectRest}
{}
:  Composition Over Inheritance (mORMot 2 Key Change)
{}
{\b mORMot 1} used inheritance:
!TSQLRestServer = class(TSQLRest)
!  // ORM methods directly in class
!  function Add(...): TID;
{}
{\b mORMot 2} uses composition:
!TRest = class
!  property Orm: IRestOrm;     // ORM via interface
!  property Services: TServiceContainer;  // SOA via container
!end;
!
!// Access ORM through .Orm property
!Server.Orm.Add(Customer);
{}
This change improves:
- {\b Testability}: Mock individual components
- {\b Flexibility}: Swap implementations
- {\b Clarity}: Clear boundaries between concerns
{}
{\i Next Chapter: Meet mORMot 2 - New Units and Structure}
{}