; Converted from Markdown - Chapter 3
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:3Meet mORMot 2 - Unit Structure
{}
{\i Enter the new territory}
{}
m@*ORM@ot 2 represents a complete restructuring of the original framework. The monolithic units ({\f1\fs20 SynCommons.pas}, {\f1\fs20 mORMot.pas}) have been split into focused, layered units following @*SOLID@ principles.
{}
This chapter introduces the new unit organization and helps you understand which units to include for your specific needs.
{}
:301 Layered Architecture Overview
{}
mORMot 2 organizes its ~130 units into 6 dependency layers:
{}
$┌─────────────────────────────────────────────────────────────────────┐
$│  Layer 5: Application & Tools                                       │
$│  ┌─────┬─────┬────────┬──────┬───────┬─────┐                        │
$│  │ app │ ui  │ script │ misc │ tools │ ddd │                        │
$│  └─────┴─────┴────────┴──────┴───────┴─────┘                        │
$└─────────────────────────────────────────────────────────────────────┘
$                              │
$┌─────────────────────────────────────────────────────────────────────┐
$│  Layer 4: ORM / REST / SOA                                          │
$│  ┌─────┬──────┬─────┐                                               │
$│  │ orm │ rest │ soa │                                               │
$│  └─────┴──────┴─────┘                                               │
$└─────────────────────────────────────────────────────────────────────┘
$                              │
$┌─────────────────────────────────────────────────────────────────────┐
$│  Layer 3: Database Access                                           │
$│  ┌────┐                                                             │
$│  │ db │                                                             │
$│  └────┘                                                             │
$└─────────────────────────────────────────────────────────────────────┘
$                              │
$┌─────────────────────────────────────────────────────────────────────┐
$│  Layer 2: Networking                                                │
$│  ┌─────┐                                                            │
$│  │ net │                                                            │
$│  └─────┘                                                            │
$└─────────────────────────────────────────────────────────────────────┘
$                              │
$┌─────────────────────────────────────────────────────────────────────┐
$│  Layer 1: System Libraries & Cryptography                           │
$│  ┌─────┬────────┐                                                   │
$│  │ lib │ crypt  │                                                   │
$│  └─────┴────────┘                                                   │
$└─────────────────────────────────────────────────────────────────────┘
$                              │
$┌─────────────────────────────────────────────────────────────────────┐
$│  Layer 0: Foundation (RTL-Only)                                     │
$│  ┌──────┐                                                           │
$│  │ core │  (24 units - no mORMot dependencies)                      │
$│  └──────┘                                                           │
$└─────────────────────────────────────────────────────────────────────┘
{}
{\b Key Principle}: Lower layers never depend on higher ones. This ensures:
- Incremental compilation
- Selective deployment
- Modular testing
- Clear separation of concerns
{}
:302 Unit Naming Convention
{}
All units follow a consistent naming pattern:
{}
!mormot.<layer>.<feature>.pas
{}
Examples:
- {\f1\fs20 mormot.core.json.pas} - Core layer, @*JSON@ feature
- {\f1\fs20 mormot.orm.core.pas} - ORM layer, core functionality
- {\f1\fs20 mormot.db.sql.postgres.pas} - Database layer, @*PostgreSQL@ SQL connector
{}
:  Location Rules
{}
Units are located in folders matching their layer:
- {\f1\fs20 src/core/{\f1\fs20 mormot.core.}*.pas}
- {\f1\fs20 src/orm/{\f1\fs20 mormot.orm.}*.pas}
- {\f1\fs20 src/db/{\f1\fs20 mormot.db.}*.pas}
- etc.
{}
:303 Layer 0: Core Foundation (mormot.core.*)
{}
{\b 24 units} providing RTL-level functionality with {\b zero mORMot dependencies}.
{}
:  Dependency Chain
{}
!mormot.core.base (RTL types, ASM stubs, no dependencies)
$  └─► mormot.core.os (OS abstraction, threading)
$      └─► mormot.core.unicode (charset/encoding)
$          └─► mormot.core.text (text parsing, formatting)
$              └─► mormot.core.datetime (ISO-8601, TTimeLog)
$                  └─► mormot.core.rtti (RTTI wrapper)
$                      └─► mormot.core.buffers (compression, base64)
$                          └─► mormot.core.data (TDynArray, serialization)
$                              └─► mormot.core.json (JSON parsing)
$                                  └─► [higher units: variants, log, etc.]
{}
:  Key Core Units
{}
|%9%52%39
|\b Unit|Purpose|Key Types\b0
|@!src\core\mormot.core.base.pas@|Foundation types, ASM|{\f1\fs20 RawUtf8}, {\f1\fs20 PtrInt}, {\f1\fs20 TDynArray} basics
|@!src\core\mormot.core.os.pas@|OS abstraction|{\f1\fs20 TSynLocker}, {\f1\fs20 GetTickCount64}
|@!src\core\mormot.core.unicode.pas@|Charset conversion|{\f1\fs20 Utf8ToWideString}, {\f1\fs20 WinAnsiToUtf8}
|@!src\core\mormot.core.text.pas@|Text processing|{\f1\fs20 FormatUtf8}, CSV parsing
|@!src\core\mormot.core.rtti.pas@|@*RTTI@ abstraction|{\f1\fs20 TRttiCustom}, {\f1\fs20 PRttiInfo}
|@!src\core\mormot.core.json.pas@|JSON handling|{\f1\fs20 TJsonWriter}, {\f1\fs20 GetJsonField}
|@!src\core\mormot.core.data.pas@|Data structures|{\f1\fs20 TDynArray}, {\f1\fs20 TDynArrayHashed}
|@!src\core\mormot.core.variants.pas@|Dynamic documents|{\f1\fs20 TDocVariant}, {\f1\fs20 IDocDict}
|@!src\core\mormot.core.log.pas@|Logging framework|{\f1\fs20 TSynLog}, {\f1\fs20 ISynLog}
|@!src\core\mormot.core.threads.pas@|Threading utilities|{\f1\fs20 TSynBackgroundThread}
|@!src\core\mormot.core.test.pas@|Testing framework|{\f1\fs20 TSynTestCase}
|@!src\core\mormot.core.mustache.pas@|Template engine|{\f1\fs20 TSynMustache}
|@!src\core\mormot.core.interfaces.pas@|Interface support|DI/@*IoC@ container
|%
{}
:  Minimal Core Usage
{}
!uses
!  mormot.core.base,    // Foundation types
!  mormot.core.os,      // OS abstraction
!  mormot.core.text,    // Text utilities
!  mormot.core.json;    // JSON support
!
!var
!  doc: TDocVariantData;
!begin
!  doc.InitJson('{"name":"John","age":30}');
!  WriteLn(doc.U['name']);  // Output: John
!end;
{}
:304 Layer 1: Libraries & Cryptography
{}
:  External Libraries (mormot.lib.*)
{}
{\b 14 units} wrapping external libraries:
{}
|%12%88
|\b Unit|External Library\b0
|@!src\lib\mormot.lib.z.pas@|zlib/libdeflate compression
|{\f1\fs20 mormot.lib.openssl11}|OpenSSL 1.1/3.x
|@!src\lib\mormot.lib.curl.pas@|libcurl @*HTTP@ client
|@!src\lib\mormot.lib.sspi.pas@|Windows SSPI (Kerberos)
|@!src\lib\mormot.lib.gssapi.pas@|POSIX GSSAPI
|@!src\lib\mormot.lib.quickjs.pas@|QuickJS JavaScript engine
|@!src\lib\mormot.lib.winhttp.pas@|Windows WinHTTP
|{\f1\fs20 mormot.lib.pkcs11}|Hardware security modules
|%
{}
:  Cryptography (mormot.crypt.*)
{}
{\b 10 units} for cryptographic operations:
{}
|%9%91
|\b Unit|Purpose\b0
|@!src\crypt\mormot.crypt.core.pas@|AES, SHA-2, SHA-3, HMAC, PBKDF2
|@!src\crypt\mormot.crypt.secure.pas@|High-level factories, password hashing
|@!src\crypt\mormot.crypt.ecc.pas@|Elliptic Curve Cryptography
|{\f1\fs20 mormot.crypt.ecc256r1}|secp256r1 curve implementation
|@!src\crypt\mormot.crypt.rsa.pas@|RSA encryption/signatures
|@!src\crypt\mormot.crypt.jwt.pas@|JSON Web Tokens
|{\f1\fs20 mormot.crypt.x509}|X.509 certificates
|@!src\crypt\mormot.crypt.openssl.pas@|OpenSSL wrapper
|%
{}
:  Cryptography Factory Pattern
{}
!uses
!  mormot.crypt.secure;
!
!// High-level factories (recommended)
!var
!  h: TCryptHasher;
!  c: ICryptCipher;
!begin
!  // Hashing - use Hasher() to get TCryptHasher with Full() method
!  h := Hasher('sha256');
!  digest := h.Full(pointer(data), length(data));
!
!  // Encryption
!  c := Cipher('aes-256-ctr', @key[1], {encrypt:}true);
!  c.Process(plain, encrypted, '');
!end;
{}
:305 Layer 2: Networking (mormot.net.*)
{}
{\b 18 units} for network communication:
{}
:  Socket & HTTP
{}
|%10%90
|\b Unit|Purpose\b0
|@!src\net\mormot.net.sock.pas@|Cross-platform socket abstraction
|@!src\net\mormot.net.http.pas@|HTTP protocol state machine
|@!src\net\mormot.net.client.pas@|HTTP clients (Socket, WinHTTP, curl)
|@!src\net\mormot.net.server.pas@|HTTP servers (threaded, http.sys)
|@!src\net\mormot.net.async.pas@|Event-driven async I/O
|%
{}
:  WebSockets
{}
|%14%86
|\b Unit|Purpose\b0
|@!src\net\mormot.net.ws.core.pas@|@*WebSocket@ protocol core
|@!src\net\mormot.net.ws.client.pas@|WebSocket client
|@!src\net\mormot.net.ws.server.pas@|WebSocket server
|@!src\net\mormot.net.ws.async.pas@|Async WebSocket server
|%
{}
:  Specialized Protocols
{}
|%14%86
|\b Unit|Purpose\b0
|@!src\net\mormot.net.dns.pas@|DNS resolution
|@!src\net\mormot.net.ldap.pas@|@*LDAP@ client
|@!src\net\mormot.net.acme.pas@|ACME/Let's Encrypt
|@!src\net\mormot.net.relay.pas@|Firewall traversal
|@!src\net\mormot.net.openapi.pas@|OpenAPI client generator
|%
{}
:306 Layer 3: Database Access (mormot.db.*)
{}
{\b 27 units} for SQL and NoSQL database access:
{}
:  Core Database
{}
|%16%84
|\b Unit|Purpose\b0
|@!src\db\mormot.db.core.pas@|Shared database types
|@!src\db\mormot.db.sql.pas@|Abstract SQL classes
|@!src\db\mormot.db.proxy.pas@|Remote database proxy
|%
{}
:  Raw Database APIs
{}
|%18%82
|\b Unit|Database\b0
|{\f1\fs20 mormot.db.raw.sqlite3}|@*SQLite3@ native API
|@!src\db\mormot.db.raw.postgres.pas@|PostgreSQL API
|@!src\db\mormot.db.raw.oracle.pas@|@*Oracle@ OCI
|@!src\db\mormot.db.raw.odbc.pas@|ODBC API
|@!src\db\mormot.db.raw.oledb.pas@|OLE DB API
|%
{}
:  SQL Connectors
{}
|%13%87
|\b Unit|Database\b0
|{\f1\fs20 mormot.db.sql.sqlite3}|SQLite3
|@!src\db\mormot.db.sql.postgres.pas@|PostgreSQL
|@!src\db\mormot.db.sql.oracle.pas@|Oracle
|@!src\db\mormot.db.sql.odbc.pas@|Any ODBC source
|@!src\db\mormot.db.sql.oledb.pas@|Any OLE DB source
|@!src\db\mormot.db.sql.zeos.pas@|Via ZDBC (cross-database)
|%
{}
:  NoSQL
{}
|%22%78
|\b Unit|Database\b0
|@!src\db\mormot.db.nosql.bson.pas@|BSON encoding
|@!src\db\mormot.db.nosql.mongodb.pas@|@*MongoDB@ client
|%
{}
:  RAD Adapters
{}
|%17%83
|\b Unit|Purpose\b0
|@!src\db\mormot.db.rad.firedac.pas@|FireDAC integration
|@!src\db\mormot.db.rad.unidac.pas@|UniDAC integration
|@!src\db\mormot.db.rad.ui.orm.pas@|ORM-aware {\f1\fs20 TDataSet}
|%
{}
:307 Layer 4: ORM / REST / SOA
{}
:  ORM Layer (mormot.orm.*)
{}
{\b 9 units} for Object-Relational Mapping:
{}
|%13%87
|\b Unit|Purpose\b0
|@!src\orm\mormot.orm.base.pas@|Low-level ORM types
|@!src\orm\mormot.orm.core.pas@|{\f1\fs20 @**TOrm@}, {\f1\fs20 @**TOrmModel@}, {\f1\fs20 @**IRestOrm@}
|@!src\orm\mormot.orm.rest.pas@|@*REST@-based ORM base
|@!src\orm\mormot.orm.client.pas@|ORM client
|@!src\orm\mormot.orm.server.pas@|ORM server
|@!src\orm\mormot.orm.storage.pas@|Storage engine abstraction
|@!src\orm\mormot.orm.sql.pas@|SQL-based storage
|{\f1\fs20 mormot.orm.sqlite3}|SQLite3 ORM
|@!src\orm\mormot.orm.mongodb.pas@|MongoDB @*ODM@
|%
{}
:  REST Layer (mormot.rest.*)
{}
{\b 8 units} for RESTful services:
{}
|%16%84
|\b Unit|Purpose\b0
|@!src\rest\mormot.rest.core.pas@|{\f1\fs20 @**TRest@} base class
|@!src\rest\mormot.rest.client.pas@|REST client
|@!src\rest\mormot.rest.server.pas@|REST server
|@!src\rest\mormot.rest.http.client.pas@|HTTP REST client
|@!src\rest\mormot.rest.http.server.pas@|HTTP REST server
|@!src\rest\mormot.rest.mvc.pas@|@*MVC@/@*MVVM@ support
|{\f1\fs20 mormot.rest.sqlite3}|SQLite3 REST server
|@!src\rest\mormot.rest.memserver.pas@|In-memory REST server
|%
{}
:  SOA Layer (mormot.soa.*)
{}
{\b 4 units} for Service-Oriented Architecture:
{}
|%12%88
|\b Unit|Purpose\b0
|@!src\soa\mormot.soa.core.pas@|Interface-based @*SOA@ types
|@!src\soa\mormot.soa.client.pas@|Client service stubs
|@!src\soa\mormot.soa.server.pas@|Server service implementation
|@!src\soa\mormot.soa.codegen.pas@|Service code generation
|%
{}
:308 Layer 5: Application & Tools
{}
:  Application (mormot.app.*)
{}
|%12%88
|\b Unit|Purpose\b0
|@!src\app\mormot.app.console.pas@|Console application support
|@!src\app\mormot.app.daemon.pas@|Daemon/service support
|%
{}
:  UI Components (mormot.ui.*)
{}
|%16%84
|\b Unit|Purpose\b0
|@!src\ui\mormot.ui.core.pas@|VCL/LCL compatibility
|@!src\ui\mormot.ui.controls.pas@|Custom controls
|@!src\ui\mormot.ui.grid.orm.pas@|ORM-aware grids
|@!src\ui\mormot.ui.report.pas@|Reporting engine
|@!src\ui\mormot.ui.pdf.pas@|PDF generation
|%
{}
:  Scripting (mormot.script.*)
{}
|%13%87
|\b Unit|Purpose\b0
|@!src\script\mormot.script.quickjs.pas@|QuickJS JavaScript engine
|%
{}
:309 Common Usage Patterns
{}
:  Minimal HTTP Server with ORM
{}
!uses
!  mormot.core.base,
!  mormot.core.os,
!  mormot.orm.core,
!  mormot.orm.sqlite3,
!  mormot.rest.sqlite3,
!  mormot.rest.http.server;
!
!type
!  TOrmPerson = class(TOrm)
!  private
!    fName: RawUtf8;
!    fAge: Integer;
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Age: Integer read fAge write fAge;
!  end;
!
!var
!  Model: TOrmModel;
!  Server: TRestServerDB;
!  HttpServer: TRestHttpServer;
!begin
!  Model := TOrmModel.Create([TOrmPerson]);
!  Server := TRestServerDB.Create(Model, 'data.db3');
!  Server.Server.CreateMissingTables;
!
!  HttpServer := TRestHttpServer.Create('8080', [Server], '+', useHttpAsync);
!  try
!    WriteLn('Server running...');
!    ReadLn;
!  finally
!    HttpServer.Free;
!    Server.Free;
!    Model.Free;
!  end;
!end.
{}
:  Interface-Based Service
{}
!uses
!  mormot.core.base,
!  mormot.core.interfaces,
!  mormot.soa.core,
!  mormot.soa.server,
!  mormot.rest.server;
!
!type
!  ICalculator = interface(IInvokable)
!    ['{...GUID...}']
!    function Add(A, B: Integer): Integer;
!  end;
!
!  TCalculator = class(TInjectableObjectRest, ICalculator)
!  public
!    function Add(A, B: Integer): Integer;
!  end;
!
!function TCalculator.Add(A, B: Integer): Integer;
!begin
!  Result := A + B;
!end;
!
!// Registration
!Server.ServiceDefine(TCalculator, [ICalculator], sicShared);
{}
:  Database-Only (No REST)
{}
!uses
!  mormot.core.base,
!  mormot.db.core,
!  mormot.db.sql,
!  mormot.db.sql.postgres;
!
!var
!  Props: TSqlDBPostgresConnectionProperties;
!  Conn: TSqlDBConnection;
!  Stmt: TSqlDBStatement;
!begin
!  Props := TSqlDBPostgresConnectionProperties.Create(
!    'localhost:5432', 'mydb', 'user', 'pass');
!  Conn := Props.ThreadSafeConnection;
!
!  Stmt := Conn.NewStatementPrepared('SELECT * FROM users WHERE id=?', true);
!  try
!    Stmt.Bind(1, 42);
!    Stmt.ExecutePrepared;
!    while Stmt.Step do
!      WriteLn(Stmt.ColumnUtf8(0));
!  finally
!    Stmt.Free;
!  end;
!end;
{}
:310 Migration from mORMot 1
{}
:  Unit Mapping Summary
{}
|%48%52
|\b mORMot 1 Unit|mORMot 2 Units\b0
|{\f1\fs20 SynCommons.pas}|{\f1\fs20 mormot.core.*} (24 units)
|{\f1\fs20 mORMot.pas}|{\f1\fs20 mormot.orm.{\i } + {\f1\fs20 mormot.rest.}}
|{\f1\fs20 SynDB*.pas}|{\f1\fs20 mormot.db.*}
|{\f1\fs20 SynCrypto.pas}|{\f1\fs20 mormot.crypt.*}
|{\f1\fs20 SynCrtSock.pas}|{\f1\fs20 mormot.net.*}
|{\f1\fs20 SynEcc.pas}|{\f1\fs20 mormot.crypt.ecc*}
|%
{}
:  Type Mapping Summary
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 TSQLRecord}|{\f1\fs20 TOrm}
|{\f1\fs20 TSQLModel}|{\f1\fs20 TOrmModel}
|{\f1\fs20 TSQLRest}|{\f1\fs20 TRest}
|{\f1\fs20 TSQLRestServer}|{\f1\fs20 TRestServer}
|{\f1\fs20 TSQLRestClient}|{\f1\fs20 TRestClient}
|{\f1\fs20 TSQLRestServerDB}|{\f1\fs20 TRestServerDB}
|{\f1\fs20 TSQLHttpServer}|{\f1\fs20 TRestHttpServer}
|{\f1\fs20 RawUTF8}|{\f1\fs20 RawUtf8}
|%
{}
:  Backward Compatibility
{}
By default, mORMot 2 provides type aliases for compatibility:
!type
!  TSQLRecord = TOrm;
!  TSQLModel = TOrmModel;
!  // etc.
{}
Define {\f1\fs20 PUREMORMOT2} to disable these and use only new names:
!{$DEFINE PUREMORMOT2}
{}
{\i Next Chapter: Core Units ({\f1\fs20 mormot.core.}})*
{}