; Converted from Markdown - Chapter 4
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:4Core Units (mormot.core.*)
{}
{\i The Foundation Bricks}
{}
The m@*ORM@ot 2 framework uses custom low-level types, classes, and functions instead of relying solely on the standard Delphi RTL. This design choice provides:
{}
- {\b Cross-platform and cross-compiler support} (Delphi 7 through 12.2, FPC 3.2+)
- {\b @*Unicode@ support} via native @*UTF-8@ encoding for all versions
- {\b Optimized performance} for speed, multi-threading, and memory efficiency
- {\b Consistent KISS design} with shared common features
{}
In mORMot 1, most of this functionality resided in a single 2.3MB {\f1\fs20 SynCommons.pas} file. In mORMot 2, this has been split into {\b 24 focused units} in the {\f1\fs20 mormot.core.*} namespace, following @*SOLID@ principles.
{}
:401 Conditional Defines
{}
A global {\f1\fs20 mormot.defines.inc} include file appears in all framework units:
{}
!{$I mormot.defines.inc}
{}
This defines key conditionals for portable and efficient code:
{}
|%8%92
|\b Define|Purpose\b0
|{\f1\fs20 PUREMORMOT2}|Disable mORMot 1.18 compatibility aliases (recommended for new code)
|{\f1\fs20 FPC_X64MM}|Use custom x64 memory manager (FPC only, Linux/Windows)
|{\f1\fs20 FPCMM_BOOST} / {\f1\fs20 FPCMM_SERVER}|Memory manager threading modes
|{\f1\fs20 NEW@*RTTI@NOTUSED}|Exclude Delphi 2010+ enhanced RTTI (smaller EXE)
|{\f1\fs20 USE_OPENSSL}|Enable OpenSSL integration (required on POSIX)
|%
{}
{\b Best Practice}: Set these in project options, not in unit source.
{}
:402 Unicode and UTF-8
{}
mORMot 2 has 100% Unicode compatibility across all Delphi and FPC versions. From its core to its uppermost features, the framework is {\b natively UTF-8}, which is the de-facto character encoding for @*JSON@, @*SQLite3@, and most supported database engines.
{}
:  String Types
{}
The following string types are used throughout the framework:
{}
|%8%80%12
|\b Type|Purpose|Location\b0
|{\f1\fs20 RawUtf8}|Primary type for all internal data (UTF-8 encoded)|@!src\core\mormot.core.base.pas@
|{\f1\fs20 RawByteString}|Binary byte storage|@!src\core\mormot.core.base.pas@
|{\f1\fs20 WinAnsiString}|WinAnsi-encoded text (code page 1252)|@!src\core\mormot.core.base.pas@
|{\f1\fs20 SynUnicode}|Fastest native Unicode ({\f1\fs20 WideString} pre-2009, {\f1\fs20 UnicodeString} after)|@!src\core\mormot.core.base.pas@
|{\f1\fs20 string}|Generic VCL/UI text (use only at presentation layer)|RTL
|%
{}
{\b Key Recommendation}: Use {\f1\fs20 RawUtf8} for all business logic and data processing. Convert to {\f1\fs20 string} only at the UI layer using {\f1\fs20 Utf8ToString()} / {\f1\fs20 StringToUtf8()} from @!src\core\mormot.core.unicode.pas@:
{}
!uses
!  mormot.core.base,
!  mormot.core.unicode;
!
!var
!  utf8: RawUtf8;
!  display: string;
!begin
!  utf8 := 'Hello UTF-8 World';
!  display := Utf8ToString(utf8);  // Convert for UI display
!  utf8 := StringToUtf8(display);  // Convert back for storage/processing
!end;
{}
:  Why UTF-8?
{}
- {\b JSON native}: All JSON is UTF-8 encoded
- {\b SQLite3 native}: SQLite3 stores text as UTF-8
- {\b Network efficient}: UTF-8 is compact for ASCII-heavy content
- {\b Memory efficient}: No temporary string conversions during parsing
- {\b Consistent}: Same encoding across all Delphi versions
{}
:403 Numeric Types
{}
:  Currency Handling
{}
The {\f1\fs20 currency} type is the standard Delphi type for monetary values, avoiding rounding errors with exact 4-decimal precision. It safely stores numbers in the range -922,337,203,685,477.5808 to 922,337,203,685,477.5807.
{}
mORMot provides fast currency-to-text conversion functions in @!src\core\mormot.core.text.pas@ that avoid FPU rounding issues:
{}
!uses
!  mormot.core.text;
!
!var
!  c: currency;
!  s: RawUtf8;
!begin
!  c := 123.45;
!  s := CurrencyToStr(c);  // Fast, no FPU rounding
!  c := StrToCurrency(s);  // Safe conversion back
!end;
{}
The {\f1\fs20 Int64} binary representation of {\f1\fs20 currency} (i.e., {\f1\fs20 value * 10000}) is used internally for maximum performance and precision.
{}
:  Cross-Platform Integer Types
{}
|%8%92
|\b Type|Purpose\b0
|{\f1\fs20 PtrInt}|Signed pointer-size integer (32 or 64 bit)
|{\f1\fs20 PtrUInt}|Unsigned pointer-size integer
|{\f1\fs20 TID}|64-bit record ID (Int64)
|%
{}
:404 TDynArray: Dynamic Array Wrapper
{}
{\f1\fs20 TDynArray} (in @!src\core\mormot.core.data.pas@) provides {\f1\fs20 TList}-like functionality for any dynamic array:
{}
:  Basic Usage
{}
!uses
!  mormot.core.base,
!  mormot.core.data;
!
!type
!  TIntegerArray = array of Integer;
!
!var
!  arr: TIntegerArray;
!  da: TDynArray;
!  v: Integer;
!begin
!  da.Init(TypeInfo(TIntegerArray), arr);  // Associate wrapper with array
!
!  for v := 1 to 1000 do
!    da.Add(v);  // TList-like Add method
!
!  da.Sort(SortDynArrayInteger);  // In-place sorting
!
!  v := 500;
!  if da.Find(v) >= 0 then  // Binary search (after sorting)
!    WriteLn('Found 500');
!
!  da.Delete(0);  // Delete by index
!  WriteLn('Count: ', da.Count);
!end;
{}
:  External Count for Performance
{}
For high-performance scenarios, use an external count variable to avoid reallocation on every Add/Delete:
{}
!var
!  arr: TIntegerArray;
!  da: TDynArray;
!  count: Integer;
!begin
!  da.Init(TypeInfo(TIntegerArray), arr, @count);  // External count
!  da.Capacity := 10000;  // Pre-allocate memory
!
!  // Now Add/Delete modify 'count' without reallocating 'arr'
!  for i := 1 to 10000 do
!    da.Add(i);  // Much faster with external count
!end;
{}
:  Serialization
{}
{\f1\fs20 TDynArray} supports both binary and JSON serialization:
{}
!var
!  binary: RawByteString;
!  json: RawUtf8;
!begin
!  // Binary (fast, compact)
!  binary := da.SaveTo;
!  da.LoadFromBinary(binary);
!
!  // JSON (interoperable)
!  json := da.SaveToJson;
!  da.LoadFromJson(json);
!end;
{}
:  TDynArrayHashed for Dictionary-Like Access
{}
{\f1\fs20 TDynArrayHashed} adds O(1) hash-based lookup:
{}
!type
!  TNameValue = record
!    Name: RawUtf8;
!    Value: Integer;
!  end;
!  TNameValueArray = array of TNameValue;
!
!var
!  arr: TNameValueArray;
!  hash: TDynArrayHashed;
!  added: Boolean;
!  idx: Integer;
!begin
!  hash.Init(TypeInfo(TNameValueArray), arr);  // Auto-detects RawUtf8 key
!
!  // Add or find existing
!  idx := hash.FindHashedForAdding('MyKey', added);
!  if added then
!  begin
!    arr[idx].Name := 'MyKey';
!    arr[idx].Value := 42;
!  end;
!
!  // Fast lookup
!  idx := hash.FindHashed('MyKey');  // O(1) instead of O(n)
!end;
{}
:  TSynDictionary
{}
{\f1\fs20 TSynDictionary} (in @!src\core\mormot.core.json.pas@) is a {\b thread-safe} dictionary storing key-value pairs as two dynamic arrays:
{}
!uses
!  mormot.core.json;
!
!var
!  dict: TSynDictionary;
!  key: RawUtf8;
!  val, v: Integer;
!begin
!  dict := TSynDictionary.Create(TypeInfo(TRawUtf8DynArray), TypeInfo(TIntegerDynArray));
!  try
!    // Add() takes const parameters, so use variables
!    key := 'key1'; val := 100;
!    dict.Add(key, val);
!    key := 'key2'; val := 200;
!    dict.Add(key, val);
!
!    key := 'key1';
!    if dict.Exists(key) then
!      dict.FindAndCopy(key, v);
!
!    // Thread-safe by default (no external locking needed)
!  finally
!    dict.Free;
!  end;
!end;
{}
:405 TDocVariant: Schema-less Documents
{}
{\f1\fs20 TDocVariant} (in @!src\core\mormot.core.variants.pas@) is a custom {\f1\fs20 variant} type for storing JSON-like documents:
{}
:  Creating Documents
{}
!uses
!  mormot.core.variants;
!
!var
!  doc: Variant;
!begin
!  // Object document
!  doc := _Obj(['name', 'John', 'age', 30]);
!  // or from JSON
!  doc := _Json('{"name":"John","age":30}');
!
!  // Array document
!  doc := _Arr(['apple', 'banana', 'cherry']);
!  // or from JSON
!  doc := _Json('["apple","banana","cherry"]');
!end;
{}
:  Late-Binding Access
{}
!var
!  doc: Variant;
!begin
!  doc := _Json('{"name":"John","address":{"city":"NYC","zip":"10001"}}');
!
!  // Read properties via late-binding
!  WriteLn(doc.name);           // 'John'
!  WriteLn(doc.address.city);   // 'NYC'
!
!  // Modify properties
!  doc.name := 'Jane';
!  doc.address.state := 'NY';   // Add new property
!
!  // Convert to JSON
!  WriteLn(doc);  // '{"name":"Jane","address":{"city":"NYC","zip":"10001","state":"NY"}}'
!end;
{}
:  Direct TDocVariantData Access
{}
For better performance, use direct transtyping:
{}
!var
!  doc: Variant;
!begin
!  doc := _Json('{"a":1,"b":2,"c":3}');
!
!  // Safe access via _Safe()
!  with _Safe(doc)^ do
!  begin
!    WriteLn('Count: ', Count);
!    for i := 0 to Count - 1 do
!      WriteLn(Names[i], '=', Values[i]);
!  end;
!
!  // Typed property access
!  WriteLn(_Safe(doc)^.I['a']);  // Integer access
!  WriteLn(_Safe(doc)^.U['b']);  // RawUtf8 access
!end;
{}
:  Per-Value vs Per-Reference
{}
By default, {\f1\fs20 _Obj()/_Arr()/_Json()} create {\b per-value} documents (deep copy on assignment):
{}
!var
!  v1, v2: Variant;
!begin
!  v1 := _Obj(['name', 'John']);
!  v2 := v1;        // Creates a copy
!  v2.name := 'Jane';
!  WriteLn(v1.name);  // 'John' (unchanged)
!  WriteLn(v2.name);  // 'Jane'
!end;
{}
Use {\f1\fs20 _ObjFast()/_ArrFast()/_JsonFast()} for {\b per-reference} documents (shared):
{}
!var
!  v1, v2: Variant;
!begin
!  v1 := _ObjFast(['name', 'John']);
!  v2 := v1;        // Reference, not copy
!  v2.name := 'Jane';
!  WriteLn(v1.name);  // 'Jane' (both changed!)
!  WriteLn(v2.name);  // 'Jane'
!end;
{}
:406 Date and Time
{}
:  ISO 8601 Encoding
{}
Dates are encoded as {\f1\fs20 ISO} 8601 text ({\f1\fs20 YYYY-MM-DDThh:mm:ss}), which provides:
- Lexicographical ordering equals chronological ordering
- Natural sorting in file systems and databases
- Cross-platform compatibility
{}
:  Time Types
{}
|%8%17%29%46
|\b Type|Resolution|Storage|Use Case\b0
|{\f1\fs20 TDateTime}|Seconds|{\f1\fs20 TEXT} ({\f1\fs20 ISO} 8601)|General purpose
|{\f1\fs20 TDateTimeMS}|Milliseconds|{\f1\fs20 TEXT} ({\f1\fs20 ISO} 8601.sss)|High precision
|{\f1\fs20 TTimeLog}|Seconds|{\f1\fs20 INTEGER} (bit-packed)|Fast comparison, compact storage
|{\f1\fs20 TUnixTime}|Seconds|{\f1\fs20 INTEGER}|Unix timestamp since 1970
|{\f1\fs20 TUnixMSTime}|Milliseconds|{\f1\fs20 INTEGER}|JavaScript-compatible
|%
{}
:  TTimeLog
{}
{\f1\fs20 TTimeLog} (in @!src\core\mormot.core.datetime.pas@) is a proprietary 64-bit format optimized for fast comparison and compact storage:
{}
!uses
!  mormot.core.datetime;
!
!var
!  t, t1, t2: TTimeLog;
!  dt: TDateTime;
!begin
!  t := TimeLogNow;                    // Current time
!  t := TimeLogFromDateTime(Now);      // From TDateTime
!  dt := TimeLogToDateTime(t);         // Back to TDateTime
!
!  t1 := TimeLogNow;
!  t2 := TimeLogNow;
!  // Direct comparison works (chronological order)
!  if t1 > t2 then
!    WriteLn('t1 is later');
!
!  // ISO 8601 conversion via TTimeLogBits
!  WriteLn(PTimeLogBits(@t)^.Text(true, 'T'));  // '2025-01-15T10:30:45'
!end;
{}
:  Time Zones
{}
{\f1\fs20 TSynTimeZone} (in @!src\core\mormot.core.search.pas@) handles time zone conversions:
{}
!uses
!  mormot.core.search;
!
!var
!  local: TDateTime;
!begin
!  // Convert UTC to local time for a specific zone
!  local := TSynTimeZone.Default.UtcToLocal(NowUtc, 'Eastern Standard Time');
!
!  // Get current local time for a zone
!  local := TSynTimeZone.Default.NowToLocal('Pacific Standard Time');
!end;
{}
:407 Thread Safety: TSynLocker
{}
{\f1\fs20 TSynLocker} (in @!src\core\mormot.core.os.pas@) provides CPU cache-friendly critical sections:
{}
:  Basic Usage
{}
!uses
!  mormot.core.os;
!
!var
!  Lock: TSynLocker;
!  Counter: Integer;
!begin
!  Lock.Init;
!  try
!    // In thread code:
!    Lock.Lock;
!    try
!      Inc(Counter);  // Protected access
!    finally
!      Lock.UnLock;
!    end;
!  finally
!    Lock.Done;
!  end;
!end;
{}
:  Automatic Unlocking
{}
Use {\f1\fs20 ProtectMethod} for RAII-style protection:
{}
!procedure TMyClass.ThreadSafeMethod;
!begin
!  fLock.ProtectMethod;  // Returns IUnknown, auto-unlocks at method end
!  // ... protected code ...
!end;  // Automatically unlocks here
{}
:  Built-in Storage
{}
{\f1\fs20 TSynLocker} includes 7 variant slots for thread-safe value storage:
{}
!var
!  Lock: TSynLocker;
!begin
!  Lock.Init;
!  // Thread-safe integer storage
!  Lock.LockedInt64[0] := 100;
!  Lock.LockedInt64Increment(0, 1);  // Atomic increment
!
!  // Thread-safe string storage
!  Lock.LockedUtf8[1] := 'value';
!
!  // Thread-safe variant storage
!  Lock.Locked[2] := _Obj(['count', 42]);
!end;
{}
:  Thread-Safe Base Classes
{}
Inherit from these for built-in {\f1\fs20 TSynLocker}:
{}
|%27%73
|\b Class|Inherits From\b0
|{\f1\fs20 TSynPersistentLock}|{\f1\fs20 TSynPersistent}
|{\f1\fs20 TInterfacedObjectLocked}|{\f1\fs20 TInterfacedObjectWithCustomCreate}
|{\f1\fs20 TObjectListLocked}|{\f1\fs20 TObjectList}
|{\f1\fs20 TRawUtf8ListLocked}|{\f1\fs20 TRawUtf8List}
|%
{}
:408 Core Units Reference
{}
:  Foundation Layer
{}
|%8%50%42
|\b Unit|Purpose|Key Types\b0
|@!src\core\mormot.core.base.pas@|Foundation types, ASM stubs|{\f1\fs20 RawUtf8}, {\f1\fs20 PtrInt}, {\f1\fs20 TDynArray} basics
|@!src\core\mormot.core.os.pas@|OS abstraction|{\f1\fs20 TSynLocker}, {\f1\fs20 GetTickCount64}, file/process APIs
|@!src\core\mormot.core.unicode.pas@|Charset conversion|{\f1\fs20 Utf8ToString}, {\f1\fs20 WinAnsiToUtf8}
|@!src\core\mormot.core.text.pas@|Text processing|{\f1\fs20 FormatUtf8}, CSV parsing, currency
|@!src\core\mormot.core.datetime.pas@|Date/time handling|{\f1\fs20 TTimeLog}, {\f1\fs20 ISO} 8601, {\f1\fs20 TSynTimeZone}
|%
{}
:  Data Layer
{}
|%10%52%38
|\b Unit|Purpose|Key Types\b0
|@!src\core\mormot.core.rtti.pas@|RTTI abstraction|{\f1\fs20 TRttiCustom}, {\f1\fs20 PRttiInfo}
|@!src\core\mormot.core.buffers.pas@|Compression, streams|SynLZ, Base64, {\f1\fs20 TBufferWriter}
|@!src\core\mormot.core.data.pas@|Data structures|{\f1\fs20 TDynArray}, {\f1\fs20 TDynArrayHashed}, {\f1\fs20 TSynDictionary}
|@!src\core\mormot.core.json.pas@|JSON handling|{\f1\fs20 TJsonWriter}, {\f1\fs20 GetJsonField}
|@!src\core\mormot.core.variants.pas@|Dynamic documents|{\f1\fs20 TDocVariant}, {\f1\fs20 IDocDict}, {\f1\fs20 IDocList}
|%
{}
:  Application Layer
{}
|%8%44%48
|\b Unit|Purpose|Key Types\b0
|@!src\core\mormot.core.log.pas@|Logging framework|{\f1\fs20 TSynLog}, {\f1\fs20 ISynLog}
|@!src\core\mormot.core.perf.pas@|Performance monitoring|{\f1\fs20 TSynMonitor}, timing
|@!src\core\mormot.core.threads.pas@|Threading utilities|{\f1\fs20 TSynBackgroundThread}, {\f1\fs20 TSynParallelProcess}
|@!src\core\mormot.core.search.pas@|Search and filtering|Full-text search helpers
|@!src\core\mormot.core.test.pas@|Testing framework|{\f1\fs20 TSynTestCase}
|@!src\core\mormot.core.mustache.pas@|Template engine|{\f1\fs20 TSynMustache}
|@!src\core\mormot.core.interfaces.pas@|Interface support|DI/@*IoC@ container
|@!src\core\mormot.core.zip.pas@|ZIP compression|Archive handling
|%
{}
:409 Dependency Order
{}
Core units have strict dependencies (lower never depends on higher):
{}
!mormot.core.base (RTL types, ASM - no dependencies)
$  └─► mormot.core.os (OS abstraction)
$      └─► mormot.core.unicode (encoding)
$          └─► mormot.core.text (parsing)
$              └─► mormot.core.datetime (dates)
$                  └─► mormot.core.rtti (RTTI)
$                      └─► mormot.core.buffers (compression)
$                          └─► mormot.core.data (TDynArray)
$                              └─► mormot.core.json (JSON)
$                                  └─► [variants, log, threads, etc.]
{}
{\b Critical Rule}: When modifying units, respect this hierarchy. Adding references that create circular dependencies will break compilation.
{}
:410 Migration from SynCommons.pas
{}
:  Type Mapping
{}
|%19%19%62
|\b mORMot 1|mORMot 2|Notes\b0
|{\f1\fs20 RawUTF8}|{\f1\fs20 RawUtf8}|Case change only
|{\f1\fs20 SynCommons.pas}|{\f1\fs20 mormot.core.*}|Split into 24 units
|{\f1\fs20 FormatUTF8()}|{\f1\fs20 FormatUtf8()}|Same function, case change
|{\f1\fs20 TDocVariant}|{\f1\fs20 TDocVariant}|Now in @!src\core\mormot.core.variants.pas@
|{\f1\fs20 TSynLog}|{\f1\fs20 TSynLog}|Now in @!src\core\mormot.core.log.pas@
|{\f1\fs20 TDynArray}|{\f1\fs20 TDynArray}|Now in @!src\core\mormot.core.data.pas@
|%
{}
:  Backward Compatibility
{}
By default, mORMot 2 provides compatibility aliases. Define {\f1\fs20 PUREMORMOT2} to disable them and use only new names.
{}
:  Minimal Uses Clause
{}
!uses
!  mormot.core.base,      // Foundation
!  mormot.core.os,        // OS abstraction
!  mormot.core.text,      // Text utilities
!  mormot.core.json,      // JSON
!  mormot.core.variants;  // TDocVariant
{}
{\i Next Chapter: Object-Relational Mapping ({\f1\fs20 @**TOrm@}, {\f1\fs20 @**TOrmModel@})}
{}