; Converted from Markdown - Chapter 5
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:5Object-Relational Mapping
{}
{\i Persist Your Objects}
{}
The @*ORM@ layer of mORMot 2 is implemented across the {\f1\fs20 mormot.orm.*} units. It provides database-agnostic persistence for Delphi objects, supporting @*SQLite3@, external SQL databases (@*PostgreSQL@, @*Oracle@, MS SQL, @*MySQL@, etc.), @*MongoDB@ (@*ODM@), and in-memory storage.
{}
Generic data access is implemented by defining high-level objects as Delphi classes descending from {\f1\fs20 TOrm}. These classes serve multiple purposes:
{}
- {\b Database persistence}: @*CRUD@ operations (SELECT/{\f1\fs20 INSERT}/UPDATE/DELETE) without writing SQL
- {\b @*REST@ful resources}: Business logic objects accessible via REST/@*JSON@
- {\b UI integration}: Automatic form generation, grid binding, and reporting
{}
:501 TOrm Field Definition
{}
All ORM functionality relies on the {\f1\fs20 TOrm} class (defined in @!src\orm\mormot.orm.core.pas@). This abstract class provides built-in methods for generic ORM processing.
{}
:  Primary Key
{}
{\f1\fs20 TOrm} defines a primary key field as {\f1\fs20 ID: {\f1\fs20 @**TID@}} (where {\f1\fs20 TID = type Int64}):
{}
!type
!  TID = type Int64;
!
!  TOrm = class(TObject)
!    // ...
!    property ID: TID read GetID write fID;
!  end;
{}
The ORM relies on {\f1\fs20 Int64} primary keys, matching SQLite3's {\f1\fs20 RowID}. While you might prefer {\f1\fs20 TEXT} or {\f1\fs20 GUID} primary keys in traditional RDBMS design, integer keys are more efficient for ORM internals. You can always define secondary unique keys using {\f1\fs20 stored AS_UNIQUE}.
{}
:  Defining a Table
{}
All {\f1\fs20 published} properties of {\f1\fs20 TOrm} descendants are automatically mapped to database columns:
{}
!uses
!  mormot.core.base,
!  mormot.orm.core;
!
!type
!  /// Enumeration for gender
!  TSex = (sFemale, sMale);
!
!  /// Table for Baby records
!  TOrmBaby = class(TOrm)
!  private
!    fName: RawUtf8;
!    fAddress: RawUtf8;
!    fBirthDate: TDateTime;
!    fSex: TSex;
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Address: RawUtf8 read fAddress write fAddress;
!    property BirthDate: TDateTime read fBirthDate write fBirthDate;
!    property Sex: TSex read fSex write fSex;
!  end;
{}
By adding {\f1\fs20 TOrmBaby} to a {\f1\fs20 TOrmModel}, the corresponding {\f1\fs20 Baby} table is automatically created. No SQL required.
{}
:  Supported Property Types
{}
|%22%20%58
|\b Delphi Type|SQLite3 Type|Notes\b0
|{\f1\fs20 Byte}, {\f1\fs20 Word}, {\f1\fs20 Integer}, {\f1\fs20 Cardinal}, {\f1\fs20 Int64}|{\f1\fs20 INTEGER}|
|{\f1\fs20 Boolean}|{\f1\fs20 INTEGER}|0 = false, non-zero = true
|Enumeration|{\f1\fs20 INTEGER}|Stored as ordinal value
|Set|{\f1\fs20 INTEGER}|Bit-packed (up to 64 elements)
|{\f1\fs20 Single}, {\f1\fs20 Double}, {\f1\fs20 Extended}|FLOAT|Extended stored as double
|{\f1\fs20 Currency}|FLOAT|Fixed 4 decimals, no rounding errors
|{\f1\fs20 RawUtf8}|{\f1\fs20 TEXT}|{\b Preferred} for text fields
|{\f1\fs20 string}|{\f1\fs20 TEXT}|Use {\f1\fs20 RawUtf8} instead when possible
|{\f1\fs20 TDateTime}|{\f1\fs20 TEXT}|{\f1\fs20 ISO} 8601 with second resolution
|{\f1\fs20 TDateTimeMS}|{\f1\fs20 TEXT}|{\f1\fs20 ISO} 8601 with millisecond resolution
|{\f1\fs20 TTimeLog}|{\f1\fs20 INTEGER}|Compact proprietary format
|{\f1\fs20 TModTime}|{\f1\fs20 INTEGER}|Auto-updated on modification
|{\f1\fs20 TCreateTime}|{\f1\fs20 INTEGER}|Auto-set on creation
|{\f1\fs20 TUnixTime}|{\f1\fs20 INTEGER}|Seconds since 1970-01-01
|{\f1\fs20 TUnixMSTime}|{\f1\fs20 INTEGER}|Milliseconds since 1970-01-01
|{\f1\fs20 TOrm}|{\f1\fs20 INTEGER}|Foreign key (RowID of another table)
|{\f1\fs20 TID}|{\f1\fs20 INTEGER}|64-bit foreign key (no table info)
|{\f1\fs20 TOrmMany}|(pivot table)|Many-to-many relationship
|{\f1\fs20 TRecordReference}|{\f1\fs20 INTEGER}|Reference to any table in model
|{\f1\fs20 TSessionUserID}|{\f1\fs20 INTEGER}|Auto-filled with current user ID
|{\f1\fs20 TPersistent}|{\f1\fs20 TEXT}|JSON object
|{\f1\fs20 TCollection}|{\f1\fs20 TEXT}|JSON array of objects
|{\f1\fs20 TObjectList}|{\f1\fs20 TEXT}|JSON array (requires registration)
|{\f1\fs20 TStrings}|{\f1\fs20 TEXT}|JSON array of strings
|{\f1\fs20 RawBlob}|@*BLOB@|Binary data
|Dynamic arrays|BLOB|Binary format via {\f1\fs20 TDynArray.SaveTo}
|{\f1\fs20 Variant}|{\f1\fs20 TEXT}|JSON (or {\f1\fs20 @**TDocVariant@})
|{\f1\fs20 TNullableInteger}, etc.|varies|Nullable types supporting SQL NULL
|{\f1\fs20 record}|{\f1\fs20 TEXT}|JSON (Delphi XE5+)
|{\f1\fs20 TRecordVersion}|{\f1\fs20 INTEGER}|Monotonic change counter
|%
{}
:  Property Attributes
{}
Use special attributes in property declarations:
{}
!type
!  TOrmDiaper = class(TOrm)
!  private
!    fSerialNumber: RawUtf8;
!    fModel: TOrmDiaperModel;
!    fBaby: TOrmBaby;
!  published
!    property SerialNumber: RawUtf8
!      index 30                    // Max 30 chars for external DB
!      read fSerialNumber write fSerialNumber
!      stored AS_UNIQUE;           // Creates unique index
!    property Model: TOrmDiaperModel read fModel write fModel;
!    property Baby: TOrmBaby read fBaby write fBaby;
!  end;
{}
- {\b {\f1\fs20 stored AS_UNIQUE}}: Creates a unique database index
- {\b {\f1\fs20 index N}}: Maximum character length for external databases
- {\b {\f1\fs20 index N}} (dynamic arrays): Used for {\f1\fs20 TOrm.DynArray(N)} wrapper access
{}
:502 Text Fields
{}
The preferred type for text storage is {\f1\fs20 RawUtf8}. This ensures:
{}
- Consistent @*UTF-8@ encoding across all database engines
- No conversion overhead during JSON serialization
- Compatibility with all Delphi versions
{}
!// Business layer: Use RawUtf8
!property CustomerName: RawUtf8 read fCustomerName write fCustomerName;
!
!// UI layer: Convert for display
!var
!  displayName: string;
!begin
!  displayName := Utf8ToString(Customer.CustomerName);
!  Edit1.Text := displayName;
!end;
{}
{\b Domain-Driven Tip}: Using {\f1\fs20 RawUtf8} in your domain layer prevents accidental coupling between business logic and presentation.
{}
:503 Date and Time Fields
{}
:  TDateTime / TDateTimeMS
{}
Stored as {\f1\fs20 ISO} 8601 text in the database:
{}
!property CreatedAt: TDateTime read fCreatedAt write fCreatedAt;
!property PreciseTime: TDateTimeMS read fPreciseTime write fPreciseTime;  // With milliseconds
{}
:  TTimeLog / TModTime / TCreateTime
{}
Stored as {\f1\fs20 INTEGER} for fast comparison:
{}
!property LastModified: TModTime read fLastModified write fLastModified;  // Auto-updated
!property Created: TCreateTime read fCreated write fCreated;              // Auto-set once
!property Timestamp: TTimeLog read fTimestamp write fTimestamp;           // Manual
{}
{\f1\fs20 TModTime} and {\f1\fs20 TCreateTime} are automatically updated by the server:
- {\f1\fs20 TCreateTime}: Set when the record is first inserted
- {\f1\fs20 TModTime}: Updated on every modification
{}
:  TUnixTime / TUnixMSTime
{}
For interoperability with JavaScript/C#/Java:
{}
!property UnixTs: TUnixTime read fUnixTs write fUnixTs;        // Seconds
!property UnixMsTs: TUnixMSTime read fUnixMsTs write fUnixMsTs; // Milliseconds
{}
:504 TOrm Foreign Key Fields
{}
:  TOrm Published Properties (NOT Instances)
{}
{\b Critical}: {\f1\fs20 TOrm} published properties are {\b NOT} class instances. They store {\f1\fs20 pointer(RowID)}:
{}
!type
!  TOrmOrder = class(TOrm)
!  published
!    property Customer: TOrmCustomer read fCustomer write fCustomer;  // Stores ID, not instance!
!  end;
!
!// WRONG - will cause Access Violation:
!WriteLn(Order.Customer.Name);  // AV! Customer is not an instance
!
!// CORRECT - retrieve separately:
!var
!  cust: TOrmCustomer;
!begin
!  cust := TOrmCustomer.Create(Client, Order.Customer);  // Load by ID
!  try
!    WriteLn(cust.Name);
!  finally
!    cust.Free;
!  end;
!end;
{}
:  Setting Foreign Keys
{}
!var
!  Order: TOrmOrder;
!  Customer: TOrmCustomer;
!begin
!  Customer := TOrmCustomer.Create;
!  Order := TOrmOrder.Create;
!  try
!    Customer.Name := 'ACME Corp';
!    Client.Add(Customer, True);  // Customer.ID is now set
!
!    Order.Customer := Customer.AsTOrm;  // Use AsTOrm for cross-platform
!    // or: Order.Customer := pointer(Customer.ID);  // 32-bit only
!    Client.Add(Order, True);
!  finally
!    Order.Free;
!    Customer.Free;
!  end;
!end;
{}
:  CreateJoined for Automatic Loading
{}
Use {\f1\fs20 CreateJoined} to auto-instantiate and load all {\f1\fs20 TOrm} properties:
{}
!var
!  Order: TOrmOrder;
!begin
!  Order := TOrmOrder.CreateJoined(Client, OrderID);
!  try
!    // Now Order.Customer is a real instance, loaded via JOIN
!    WriteLn(Order.Customer.Name);  // Safe!
!  finally
!    Order.Free;  // Also frees Order.Customer
!  end;
!end;
{}
:  Deletion Tracking
{}
The ORM automatically handles foreign key integrity (emulated, not via SQL constraints):
{}
|%25%14%61
|\b Type|Index|Deletion Behavior\b0
|{\f1\fs20 TOrm} property|Yes|Field reset to 0
|{\f1\fs20 TID}|Yes|None (no table info)
|{\f1\fs20 TOrmClassNameID}|Yes|Field reset to 0
|{\f1\fs20 TOrmClassNameToBeDeletedID}|Yes|Row deleted (cascade)
|{\f1\fs20 TRecordReference}|Yes|Field reset to 0
|{\f1\fs20 TRecordReferenceToBeDeleted}|Yes|Row deleted (cascade)
|%
{}
Define typed {\f1\fs20 IDs} for explicit cascade behavior:
{}
!type
!  TOrmCustomerID = type TID;              // Reset to 0 on delete
!  TOrmCustomerToBeDeletedID = type TID;   // Cascade delete
!
!  TOrmOrder = class(TOrm)
!  published
!    property Customer: TOrmCustomerID read fCustomer write fCustomer;
!    property OwnerCustomer: TOrmCustomerToBeDeletedID read fOwner write fOwner;
!  end;
{}
:505 TRecordReference: Cross-Table References
{}
{\f1\fs20 TRecordReference} stores a reference to {\b any} table in the model:
{}
!type
!  TOrmAuditLog = class(TOrm)
!  published
!    property RelatedRecord: TRecordReference read fRelated write fRelated;
!  end;
!
!// Usage
!var
!  Log: TOrmAuditLog;
!  Ref: RecordRef;  // Helper record
!begin
!  // Store reference to any record (requires Model for table index lookup)
!  Log.RelatedRecord := RecordReference(Model, TOrmCustomer, CustomerID);
!
!  // Retrieve via helper
!  Ref.Value := Log.RelatedRecord;
!  WriteLn('Table: ', Ref.Table(Model).SqlTableName);
!  WriteLn('ID: ', Ref.ID);
!
!  // Load the referenced record directly
!  Rec := Client.Retrieve(Log.RelatedRecord);
!end;
{}
{\b Warning}: {\f1\fs20 TRecordReference} encodes table index in high bits. {\b Never change table order} in {\f1\fs20 TOrmModel} after deployment.
{}
:506 Variant Fields and TDocVariant
{}
{\f1\fs20 Variant} fields are stored as JSON {\f1\fs20 TEXT}:
{}
!type
!  TOrmDocument = class(TOrm)
!  published
!    property Data: Variant read fData write fData;
!  end;
!
!// Usage - schema-less storage
!var
!  Doc: TOrmDocument;
!begin
!  Doc := TOrmDocument.Create;
!  Doc.Data := _ObjFast(['name', 'John', 'tags', _Arr(['admin', 'user'])]);
!  Client.Add(Doc, True);
!
!  // Later retrieval
!  Doc := TOrmDocument.Create(Client, DocID);
!  WriteLn(Doc.Data.name);        // 'John'
!  WriteLn(Doc.Data.tags._Count); // 2
!end;
{}
For MongoDB ODM, variants are stored as native BSON documents with full query support.
{}
:507 Dynamic Array Fields
{}
Dynamic arrays are stored as BLOB in binary format:
{}
!type
!  TIntegerArray = array of Integer;
!
!  TOrmWithArray = class(TOrm)
!  private
!    fScores: TIntegerArray;
!  published
!    property Scores: TIntegerArray index 1 read fScores write fScores;
!  end;
{}
Access via {\f1\fs20 TDynArray} wrapper:
{}
!var
!  Rec: TOrmWithArray;
!  DA: TDynArray;
!  Value: Integer;
!begin
!  DA := Rec.DynArray(1);  // Get wrapper for Scores
!  Value := 100;
!  DA.Add(Value);  // TDynArray.Add takes a reference
!  Value := 200;
!  DA.Add(Value);
!end;
{}
:508 TNullable* Types
{}
For SQL NULL support, use nullable types:
{}
!type
!  TOrmNullableRecord = class(TOrm)
!  published
!    property OptionalInt: TNullableInteger read fOptionalInt write fOptionalInt;
!    property OptionalText: TNullableUtf8Text index 100 read fOptionalText write fOptionalText;
!    property OptionalDate: TNullableDateTime read fOptionalDate write fOptionalDate;
!  end;
!
!// Usage
!var
!  Rec: TOrmNullableRecord;
!begin
!  Rec := TOrmNullableRecord.Create;
!  Rec.OptionalInt := NullableInteger(42);        // Has value
!  Rec.OptionalText := NullableUtf8TextNull;      // Is NULL
!  Rec.OptionalDate := NullableDateTime(Now);     // Has value
!
!  if NullableIntegerIsEmptyOrNull(Rec.OptionalInt) then
!    WriteLn('No value')
!  else
!    WriteLn('Value: ', NullableIntegerToValue(Rec.OptionalInt));
!end;
{}
Available nullable types:
- {\f1\fs20 TNullableInteger} (Int64)
- {\f1\fs20 TNullableBoolean}
- {\f1\fs20 TNullableFloat} (Double)
- {\f1\fs20 TNullableCurrency}
- {\f1\fs20 TNullableDateTime}
- {\f1\fs20 TNullableTimeLog}
- {\f1\fs20 TNullableUtf8Text}
{}
:509 TOrmModel: Schema Definition
{}
{\f1\fs20 TOrmModel} defines which {\f1\fs20 TOrm} classes form your database:
{}
!uses
!  mormot.orm.core;
!
!var
!  Model: TOrmModel;
!begin
!  Model := TOrmModel.Create([
!    TOrmCustomer,
!    TOrmProduct,
!    TOrmOrder,
!    TOrmOrderLine
!  ], 'api');  // 'api' is the root URI
!
!  // Table order matters for TRecordReference - don't change after deployment!
!end;
{}
:  Field Validation and Constraints
{}
!// Add unique validation at runtime (alternative to stored AS_UNIQUE)
!TOrmCustomer.AddFilterOrValidate('Email', TSynValidateUniqueField.Create);
!
!// For multi-field uniqueness
!TOrmOrder.AddFilterOrValidate('OrderNumber',
!  TSynValidateUniqueFields.Create('{"FieldNames":"CustomerID,OrderNumber"}'));
{}
{\b Note}: Prefer using {\f1\fs20 stored AS_UNIQUE} in property declarations for compile-time constraints. Runtime validation is useful for conditional or complex uniqueness rules.
{}
:510 IRestOrm: The ORM Interface
{}
{\b Always code against {\f1\fs20 IRestOrm} interface}, not concrete classes:
{}
!uses
!  mormot.orm.core;
!
!procedure DoWork(const Orm: IRestOrm);  // Interface parameter
!var
!  Customer: TOrmCustomer;
!begin
!  Customer := TOrmCustomer.Create;
!  try
!    Customer.Name := 'ACME Corp';
!    Orm.Add(Customer, True);    // Add via interface
!  finally
!    Customer.Free;
!  end;
!end;
{}
:  CRUD Operations
{}
!var
!  Orm: IRestOrm;
!  Customer: TOrmCustomer;
!  ID: TID;
!begin
!  // CREATE
!  Customer := TOrmCustomer.Create;
!  Customer.Name := 'New Customer';
!  ID := Orm.Add(Customer, True);  // Returns new ID
!
!  // READ
!  Customer := TOrmCustomer.Create(Orm, ID);  // Load by ID
!  // or
!  Orm.Retrieve(ID, Customer);                // Load into existing instance
!
!  // UPDATE
!  Customer.Name := 'Updated Name';
!  Orm.Update(Customer);
!
!  // DELETE
!  Orm.Delete(TOrmCustomer, ID);
!end;
{}
:  Accessing ORM from TRest
{}
In mORMot 2, ORM is accessed via the {\f1\fs20 .Orm} property:
{}
!// mORMot 1 style (deprecated):
!Server.Add(Customer, True);
!
!// mORMot 2 style:
!Server.Orm.Add(Customer, True);
!
!// Or store interface:
!var
!  Orm: IRestOrm;
!begin
!  Orm := Server.Orm;
!  Orm.Add(Customer, True);
!end;
{}
:511 Virtual Tables and Storage Backends
{}
:  In-Memory Storage
{}
!uses
!  mormot.rest.memserver;
!
!// Use TRestServerFullMemory for pure in-memory ORM
!Server := TRestServerFullMemory.Create(Model, '', False, False);
!// Or with file persistence:
!Server := TRestServerFullMemory.Create(Model, 'data.json', False, False);
{}
:  External SQL Database
{}
!uses
!  mormot.orm.sql,
!  mormot.db.sql.postgres;
!
!var
!  Props: TSqlDBPostgresConnectionProperties;
!begin
!  Props := TSqlDBPostgresConnectionProperties.Create(
!    'localhost:5432', 'mydb', 'user', 'pass');
!
!  // Map TOrm to external database
!  OrmMapExternal(Model, TOrmCustomer, Props);
!  OrmMapExternal(Model, TOrmOrder, Props);
!end;
{}
:  MongoDB (ODM)
{}
!uses
!  mormot.orm.mongodb,
!  mormot.db.nosql.mongodb;
!
!var
!  Client: TMongoClient;
!  Server: TRestServer;
!begin
!  Client := TMongoClient.Create('localhost', 27017);
!  // OrmMapMongoDB requires a Server instance, not Model
!  OrmMapMongoDB(TOrmDocument, Server.OrmInstance, Client.Database['mydb']);
!end;
{}
:512 Migration from mORMot 1
{}
:  Class Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 TSQLRecord}|{\f1\fs20 TOrm}
|{\f1\fs20 TSQLRecordClass}|{\f1\fs20 TOrmClass}
|{\f1\fs20 TSQLModel}|{\f1\fs20 TOrmModel}
|{\f1\fs20 TSQLTable}|{\f1\fs20 TOrmTable}
|{\f1\fs20 TSQLTableJSON}|{\f1\fs20 TOrmTableJson}
|{\f1\fs20 TSQLRest}|{\f1\fs20 TRest}
|{\f1\fs20 TSQLRest.Add()}|{\f1\fs20 TRest.Orm.Add()}
|{\f1\fs20 TSQLRecordMany}|{\f1\fs20 TOrmMany}
|{\f1\fs20 TSQLRawBlob}|{\f1\fs20 RawBlob}
|%
{}
:  Unit Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 mORMot.pas}|@!src\orm\mormot.orm.core.pas@ + @!src\rest\mormot.rest.core.pas@
|{\f1\fs20 mORMotSQLite3.pas}|{\f1\fs20 mormot.orm.sqlite3} + {\f1\fs20 mormot.rest.sqlite3}
|{\f1\fs20 mORMotDB.pas}|@!src\orm\mormot.orm.sql.pas@
|{\f1\fs20 mORMotMongoDB.pas}|@!src\orm\mormot.orm.mongodb.pas@
|%
{}
:  Backward Compatibility
{}
By default, type aliases are provided:
!type
!  TSQLRecord = TOrm;
!  TSQLModel = TOrmModel;
!  // etc.
{}
Define {\f1\fs20 PUREMORMOT2} to disable these and use only new names.
{}
{\i Next Chapter: Daily ORM (Working with Objects and Queries)}
{}