; Converted from Markdown - Chapter 7
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:7Database Layer
{}
{\i @*SQLite3@ at the Core}
{}
m@*ORM@ot 2's persistence architecture is centered on SQLite3 but not limited to it. The framework supports multiple database backends, all accessible through a unified interface.
{}
:701 SQLite3-Powered, Not SQLite3-Limited
{}
The core database of the framework uses SQLite3 - a free, secure, zero-configuration, server-less, cross-platform database engine.
{}
:  Persistence Options
{}
$┌─────────────────────────────────────────────────────────────────────┐
$│                        mORMot ORM / REST                            │
$└─────────────────────────────────────────────────────────────────────┘
$                                │
$     ┌──────────────────────────┼──────────────────────────┐
$     │                          │                          │
$     ▼                          ▼                          ▼
$┌─────────────┐          ┌─────────────┐          ┌─────────────┐      
$│  SQLite3    │          │ External DB │          │   NoSQL           │
$│  (native)   │          │  (via SQL)  │          │  (MongoDB)        │
$└─────────────┘          └─────────────┘          └─────────────┘      
$     │                          │                          │
$     ▼                          ▼                          ▼
!   File/Mem             PostgreSQL/Oracle          Document Store
!                        MSSQL/MySQL/etc.
{}
|%30%13%57
|\b Storage Backend|Unit(s)|Use Case\b0
|Internal SQLite3|{\f1\fs20 mormot.orm.sqlite3}|Default, embedded, full SQL
|In-Memory {\f1\fs20 TObjectList}|@!src\orm\mormot.orm.storage.pas@|Fastest, no @*ACID@, limited SQL
|External RDBMS|@!src\orm\mormot.orm.sql.pas@ + {\f1\fs20 mormot.db.sql.*}|Enterprise databases
|@*MongoDB@|@!src\orm\mormot.orm.mongodb.pas@|NoSQL document store
|%
{}
:  SQLite3 as Core
{}
The framework uses compiled SQLite3 code, included natively in Delphi/FPC:
{}
- {\b Static linking} (recommended) or external {\f1\fs20 sqlite3.dll}
- {\b Optimized performance} via {\f1\fs20 FastMM4} / FPC memory manager
- {\b Optional encryption} (AES-256) on disk
- {\b Record-level locking} (SQLite3 only has file-level)
- {\b Client-Server support} (SQLite3 is normally standalone-only)
{}
{\b Compilation options include:}
- {\f1\fs20 ISO} 8601 date/time handling
- R-Tree extension for range queries
- FTS3/FTS4/FTS5 full-text search
- PCRE-based {\f1\fs20 REGEXP} operator
- Custom SQL functions in Delphi
{}
:  Virtual Tables Magic
{}
SQLite3's Virtual Table mechanism allows mORMot to:
{}
- Mix internal SQLite3 tables with external databases in the same query
- JOIN across different database engines
- Use {\f1\fs20 TObjectList} storage with SQL queries
- Present MongoDB collections as SQL tables
{}
!// One model, multiple backends
!Model := TOrmModel.Create([
!  TOrmCustomer,   // Internal SQLite3
!  TOrmProduct,    // External PostgreSQL
!  TOrmOrder,      // External PostgreSQL
!  TOrmAuditLog    // MongoDB
!]);
!
!// Mix in single query (via virtual tables)
!Server.Orm.ExecuteList([TOrmOrder, TOrmCustomer],
!  'SELECT Order.ID, Customer.Name FROM Order, Customer ' +
!  'WHERE Order.CustomerID = Customer.ID');
{}
:702 SQLite3 Implementation
{}
:  Unit Structure
{}
!mormot.db.raw.sqlite3.pas   → Low-level SQLite3 C API wrapper
!        ↓
!mormot.db.sql.sqlite3.pas   → TSqlDB* implementation for SQLite3
!        ↓
!mormot.orm.sqlite3.pas      → ORM integration (TRestServerDB)
{}
:  Static vs Dynamic Linking
{}
|%21%12%67
|\b Mode|Unit|Deployment\b0
|Static|{\f1\fs20 mormot.db.raw.sqlite3.static}|Embedded in EXE (~1MB)
|Dynamic|{\f1\fs20 mormot.db.raw.sqlite3}|External {\f1\fs20 sqlite3.dll}
|%
{}
{\b Static linking} (recommended for Windows):
!uses
!  mormot.db.raw.sqlite3.static,  // Include static .obj
!  mormot.orm.sqlite3;
{}
{\b Dynamic linking} (required for some platforms):
!uses
!  mormot.db.raw.sqlite3,
!  mormot.orm.sqlite3;
!
!// Load external DLL
!sqlite3 := TSqlite3LibraryDynamic.Create;
{}
:  Database Modes
{}
!uses
!  mormot.orm.sqlite3,
!  mormot.rest.sqlite3;
!
!var
!  Server: TRestServerDB;
!begin
!  // File-based (default - ACID, persistent)
!  Server := TRestServerDB.Create(Model, 'data.db3');
!
!  // In-memory (fast, non-persistent)
!  Server := TRestServerDB.Create(Model, ':memory:');
!
!  // Performance tuning
!  Server.DB.Synchronous := smOff;       // Faster writes (less safe)
!  Server.DB.LockingMode := lmExclusive; // Single-process access
!end;
{}
:  Performance Modes
{}
|%15%22%17%46
|\b Mode|Safety|Speed|Use Case\b0
|{\f1\fs20 smFull} (default)|ACID|Slow writes|Production with crash safety
|{\f1\fs20 smOff}|Risk on crash|Fast|Batch imports, dev/test
|{\f1\fs20 lmExclusive}|Single process|Fastest|Embedded applications
|%
{}
{\b Batch write example:}
!Server.DB.Synchronous := smOff;
!Server.DB.LockingMode := lmExclusive;
!try
!  // 100x faster bulk insert
!  for i := 1 to 100000 do
!    Server.Orm.Add(CreateRecord(i), True);
!finally
!  Server.DB.Synchronous := smFull;  // Restore safety
!end;
{}
:703 Prepared Statements
{}
mORMot automatically caches prepared SQL statements for reuse.
{}
:  Parameter Binding
{}
Use {\f1\fs20 ?} placeholders for parameters:
{}
!// Parameters bound safely (no SQL injection)
!Rec := TOrm.CreateAndFillPrepare(Orm,
!  'Name LIKE ? AND Active = ?', ['John%', True]);
!
!// Date parameters
!Rec := TOrm.CreateAndFillPrepare(Orm,
!  'Created >= ?', [DateToSql(EncodeDate(2024, 1, 1))]);
{}
:  Internal Caching
{}
The framework caches prepared statements internally:
{}
!// First call: Parse SQL, prepare statement, execute
!Orm.Retrieve('Name = ?', [], ['John'], Rec);
!
!// Subsequent calls: Reuse prepared statement, rebind parameters
!Orm.Retrieve('Name = ?', [], ['Jane'], Rec);  // Much faster
{}
:  JSON Inlined Parameters
{}
Internally, parameters are encoded as {\f1\fs20 :(value):} in @*JSON@:
{}
!// API call
!Orm.Retrieve('ID = ?', [], [42], Rec);
!
!// Transmitted as JSON
!'{"Where":"ID=:(42):"}'
!
!// Prepared SQL
!'SELECT * FROM TableName WHERE ID = ?'  // With 42 bound
{}
:704 R-Tree Extension
{}
R-Trees provide fast range queries for multi-dimensional data (geospatial, temporal).
{}
:  Defining R-Tree Tables
{}
!type
!  TOrmMapBox = class(TOrmRTree)
!  private
!    fMinX, fMaxX: Double;
!    fMinY, fMaxY: Double;
!  published
!    property MinX: Double read fMinX write fMinX;
!    property MaxX: Double read fMaxX write fMaxX;
!    property MinY: Double read fMinY write fMinY;
!    property MaxY: Double read fMaxY write fMaxY;
!  end;
{}
:  R-Tree Queries
{}
!// Find all boxes containing point (10, 20)
!Boxes := TOrmMapBox.CreateAndFillPrepare(Orm,
!  'MinX <= ? AND MaxX >= ? AND MinY <= ? AND MaxY >= ?',
!  [10, 10, 20, 20]);
!
!// Or use RTreeMatch for complex queries
!Orm.RTreeMatch(TOrmMapData, 'BlobField', TOrmMapBox,
!  MapData.BlobField, ResultIDs);
{}
:705 Full-Text Search (FTS5)
{}
FTS5 provides fast full-text search capabilities.
{}
:  FTS Classes
{}
|%13%36%51
|\b Class|Tokenizer|Use Case\b0
|{\f1\fs20 TOrmFTS5}|Simple|Basic text search
|{\f1\fs20 TOrmFTS5Porter}|Porter stemmer|English text
|{\f1\fs20 TOrmFTS5@*Unicode@61}|Unicode61|Non-Latin languages
|%
{}
:  Defining FTS Tables
{}
!type
!  TOrmArticleFTS = class(TOrmFTS5Porter)
!  private
!    fTitle: RawUtf8;
!    fBody: RawUtf8;
!  published
!    property Title: RawUtf8 read fTitle write fTitle;
!    property Body: RawUtf8 read fBody write fBody;
!  end;
{}
:  Indexing Content
{}
!// Link FTS to main table via DocID
!FTS := TOrmArticleFTS.Create;
!FTS.DocID := Article.ID;  // Link to TOrmArticle
!FTS.Title := Article.Title;
!FTS.Body := Article.Content;
!Orm.Add(FTS, True);
!
!// Optimize after bulk inserts (FTS5 inherits from FTS3)
!TOrmArticleFTS.OptimizeFTS3Index(Server.OrmInstance as IRestOrmServer);
{}
:  Searching
{}
!var
!  IDs: TIDDynArray;
!begin
!  // Basic search
!  Orm.FTSMatch(TOrmArticleFTS, 'database optimization', IDs);
!
!  // With field weighting (Title=2x, Body=1x)
!  Orm.FTSMatch(TOrmArticleFTS, 'database', IDs, [2.0, 1.0]);
!
!  // Complex queries
!  Orm.FTSMatch(TOrmArticleFTS, 'Title:database AND Body:performance', IDs);
!end;
{}
:  FTS Query Syntax
{}
|%22%78
|\b Pattern|Meaning\b0
|{\f1\fs20 word}|Match exact word
|{\f1\fs20 word*}|Prefix match
|{\f1\fs20 "exact phrase"}|Match phrase
|{\f1\fs20 word1 AND word2}|Both required
|{\f1\fs20 word1 OR word2}|Either matches
|{\f1\fs20 word1 NOT word2}|Exclude word2
|{\f1\fs20 NEAR(word1 word2, 5)}|Within 5 tokens
|{\f1\fs20 Title:word}|Match in specific column
|%
{}
:706 In-Memory Storage
{}
:  TRestStorageInMemory
{}
Ultra-fast storage using {\f1\fs20 TObjectList}:
{}
!uses
!  mormot.orm.storage,
!  mormot.orm.server;
!
!// Create in-memory storage and register with ORM server
!var
!  Storage: TRestStorageInMemory;
!  OrmServer: TRestOrmServer;
!  TableIndex: Integer;
!begin
!  OrmServer := Server.OrmInstance as TRestOrmServer;
!  Storage := TRestStorageInMemory.Create(TOrmCache, OrmServer);
!  TableIndex := OrmServer.Model.GetTableIndexExisting(TOrmCache);
!  OrmServer.StaticTableSetup(TableIndex, Storage, sStaticDataTable);
!end;
{}
:  Features and Limitations
{}
|%29%54%17
|\b Feature|In-Memory|SQLite3\b0
|Speed|Fastest|Fast
|ACID|No|Yes
|SQL Joins|Limited|Full
|Max Size|RAM|Disk
|Persistence|Optional (JSON/Binary)|Yes
|Unique Index|O(1) hash|B-Tree
|%
{}
:  Persistence Options
{}
!var
!  Storage: TRestStorageInMemory;
!  Stream: TFileStream;
!  JsonContent: RawUtf8;
!begin
!  Storage := TRestStorageInMemory.Create(TOrmCache, OrmServer);
!
!  // Save to JSON file (via stream)
!  Stream := TFileStream.Create('cache.json', fmCreate);
!  try
!    Storage.SaveToJson(Stream, True);  // True = expand JSON
!  finally
!    Stream.Free;
!  end;
!
!  // Load from JSON file - LoadFromJson takes RawUtf8, not Stream
!  JsonContent := StringFromFile('cache.json');
!  Storage.LoadFromJson(JsonContent);
!
!  // Save binary (via stream)
!  Stream := TFileStream.Create('cache.data', fmCreate);
!  try
!    Storage.SaveToBinary(Stream);
!  finally
!    Stream.Free;
!  end;
!
!  // Load binary (via stream)
!  Stream := TFileStream.Create('cache.data', fmOpenRead);
!  try
!    Storage.LoadFromBinary(Stream);
!  finally
!    Stream.Free;
!  end;
!end;
{}
:  Virtual Table Mode
{}
Register in-memory as virtual table for SQL access:
{}
!// For SQL joins, register as virtual table BEFORE server creation
!Model.VirtualTableRegister(TOrmCache, TOrmVirtualTableJson);
!
!// Then create server - the virtual table will be available
!Server := TRestServerDB.Create(Model, 'main.db3');
{}
:707 Virtual Tables
{}
:  Built-in Virtual Table Classes
{}
|%18%42%40
|\b Class|Storage|Persistence\b0
|{\f1\fs20 TOrmVirtualTableJson}|In-memory|JSON file
|{\f1\fs20 TOrmVirtualTableBinary}|In-memory|Binary file
|{\f1\fs20 TOrmVirtualTableExternal}|External DB|Database
|{\f1\fs20 TOrmVirtualTableMongoDB}|MongoDB|MongoDB
|%
{}
:  Registering Virtual Tables
{}
!// Must register BEFORE creating server
!Model.VirtualTableRegister(TOrmTempData, TOrmVirtualTableJson);
!Model.VirtualTableRegister(TOrmCustomer, TOrmVirtualTableExternal);
!
!// Then create server
!Server := TRestServerDB.Create(Model, 'main.db3');
{}
:  Custom Virtual Tables
{}
!type
!  TMyVirtualTable = class(TOrmVirtualTable)
!  public
!    class function ModuleName: RawUtf8; override;
!    function Prepare(var Prepared: TOrmVirtualTablePrepared): boolean; override;
!    function Search(var Prepared: TOrmVirtualTablePrepared): boolean; override;
!  end;
{}
:708 JSON Functions in SQLite3
{}
mORMot adds JSON manipulation functions to SQLite3:
{}
:  JsonGet
{}
Extract values from JSON columns:
{}
$-- Get property value
$SELECT JsonGet(DataColumn, 'name') FROM Table WHERE ID=1;
$
$-- Get nested property
$SELECT JsonGet(DataColumn, 'address.city') FROM Table;
$
$-- Get multiple properties
$SELECT JsonGet(DataColumn, 'name,email') FROM Table;
$
$-- Wildcard match
$SELECT JsonGet(DataColumn, 'user.*') FROM Table;
{}
:  JsonHas
{}
Check property existence:
{}
$-- Check if property exists
$SELECT * FROM Table WHERE JsonHas(DataColumn, 'premium') = 1;
$
$-- Check nested property
$SELECT * FROM Table WHERE JsonHas(DataColumn, 'settings.darkMode') = 1;
{}
:709 Backup and Recovery
{}
:  Online Backup
{}
!// Hot backup (while server is running)
!Server.DB.BackupBackground('backup.db3', 100, 10,
!  procedure(Sender: TSqlDatabase; Step: integer)
!  begin
!    WriteLn('Backup progress: ', Step);
!  end);
{}
:  Restore
{}
!// Stop server, copy backup file, restart
!Server.Free;
!CopyFile('backup.db3', 'data.db3');
!Server := TRestServerDB.Create(Model, 'data.db3');
{}
:710 Performance Tips
{}
:  General Guidelines
{}
1. {\b Use transactions} for bulk operations
2. {\b Use batch operations} ({\f1\fs20 TRestBatch}) for inserts
3. {\b Use prepared statements} (automatic with {\f1\fs20 ?} parameters)
4. {\b Index foreign keys} and frequently queried columns
5. {\b Use {\f1\fs20 smOff} temporarily} for bulk imports
6. {\b Use {\f1\fs20 lmExclusive}} for single-process applications
{}
:  Benchmark Reference
{}
Typical performance on modern hardware (SSD, Core i7):
{}
|%26%15%24%35
|\b Operation|In-Memory|SQLite3 (File)|External PostgreSQL\b0
|Insert (single)|300,000/s|500/s|5,000/s
|Insert (batch)|500,000/s|200,000/s|50,000/s
|Read (by ID)|900,000/s|130,000/s|10,000/s
|Read (all)|900,000/s|550,000/s|150,000/s
|%
{}
{\i Note: Actual performance varies based on hardware, network, and data complexity.}
{}
:711 Migration from mORMot 1
{}
:  Unit Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 SynSQLite3.pas}|{\f1\fs20 mormot.db.raw.sqlite3.pas}
|{\f1\fs20 SynSQLite3Static.pas}|{\f1\fs20 mormot.db.raw.sqlite3.static.pas}
|{\f1\fs20 mORMotSQLite3.pas}|{\f1\fs20 mormot.orm.sqlite3.pas} + {\f1\fs20 mormot.rest.sqlite3.pas}
|%
{}
:  Class Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 TSQLRestServerDB}|{\f1\fs20 TRestServerDB}
|{\f1\fs20 TSQLDatabase}|{\f1\fs20 TSqlDatabase}
|{\f1\fs20 TSQLRecordFTS3}|{\f1\fs20 TOrmFTS3}
|{\f1\fs20 TSQLRecordFTS5}|{\f1\fs20 TOrmFTS5}
|{\f1\fs20 TSQLRecordRTree}|{\f1\fs20 TOrmRTree}
|{\f1\fs20 TSQLRestStorageInMemory}|{\f1\fs20 TRestStorageInMemory}
|%
{}
{\i Next Chapter: External SQL Database Access}
{}