; Converted from Markdown - Chapter 8
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:8External SQL Database Access
{}
{\i Connect to Any RDBMS}
{}
The m@*ORM@ot framework provides direct access to external SQL databases through the {\f1\fs20 mormot.db.sql.*} units. These databases can be used standalone or integrated with the ORM via virtual tables.
{}
:801 Architecture Overview
{}
:  SynDB Layer (mORMot 2: mormot.db.*)
{}
$┌─────────────────────────────────────────────────────────────────┐ 
$│                     mormot.db.sql.pas                            │
$│              TSqlDBConnectionProperties (abstract)               │
$│              TSqlDBConnection, TSqlDBStatement                   │
$└─────────────────────────────────────────────────────────────────┘ 
$                              │
$      ┌───────────────────────┼───────────────────────┐
$      │                       │                       │
$      ▼                       ▼                       ▼
$┌─────────────┐       ┌─────────────┐       ┌─────────────┐         
$│   Direct    │       │    ODBC     │       │  TDataSet            │
$│   Access    │       │   Access    │       │   Bridge             │
$└─────────────┘       └─────────────┘       └─────────────┘         
$      │                       │                       │
$      ▼                       ▼                       ▼
!  PostgreSQL              Any ODBC              FireDAC
!  Oracle (OCI)            Driver                UniDAC
!  SQLite3                                       NexusDB
{}
:  Provider Units
{}
|%32%12%56
|\b Provider|Unit|Direct Access\b0
|@*PostgreSQL@|@!src\db\mormot.db.sql.postgres.pas@|Yes (libpq)
|@*Oracle@|@!src\db\mormot.db.sql.oracle.pas@|Yes (OCI)
|@*SQLite3@|{\f1\fs20 mormot.db.sql.sqlite3}|Yes
|ODBC|@!src\db\mormot.db.sql.odbc.pas@|Yes
|OleDB|@!src\db\mormot.db.sql.oledb.pas@|Yes
|Zeos/ZDBC|@!src\db\mormot.db.sql.zeos.pas@|Yes (recommended)
|FireDAC|@!src\db\mormot.db.rad.firedac.pas@|Via {\f1\fs20 TDataSet}
|UniDAC|@!src\db\mormot.db.rad.unidac.pas@|Via {\f1\fs20 TDataSet}
|NexusDB|@!src\db\mormot.db.rad.nexusdb.pas@|Via {\f1\fs20 TDataSet}
|%
{}
:  Database Engines Supported
{}
|%33%15%10%12%10%20
|\b Database|Direct|ODBC|OleDB|Zeos|TDataSet\b0
|PostgreSQL|✓|✓|-|✓|✓
|Oracle|✓|✓|✓|✓|✓
|MS SQL Server|-|✓|✓|✓|✓
|@*MySQL@/MariaDB|-|✓|-|✓|✓
|SQLite3|✓|✓|-|✓|✓
|Firebird|-|✓|-|✓|✓
|{\f1\fs20 IBM} DB2|-|✓|✓|✓|✓
|Informix|-|✓|-|-|✓
|%
{}
:802 Connection Properties
{}
:  Creating Connections
{}
!uses
!  mormot.db.sql,
!  mormot.db.sql.postgres;
!
!var
!  Props: TSqlDBPostgresConnectionProperties;
!begin
!  // PostgreSQL direct
!  Props := TSqlDBPostgresConnectionProperties.Create(
!    'localhost:5432', 'mydb', 'user', 'password');
!
!  // Connection string alternative
!  Props := TSqlDBPostgresConnectionProperties.Create(
!    'host=localhost port=5432 dbname=mydb', '', 'user', 'password');
!end;
{}
:  Provider-Specific Examples
{}
{\b Oracle (direct OCI):}
!uses
!  mormot.db.sql.oracle;
!
!Props := TSqlDBOracleConnectionProperties.Create(
!  'myserver/orcl', '', 'scott', 'tiger');
!
!// With TNS alias
!Props := TSqlDBOracleConnectionProperties.Create(
!  'PROD_DB', '', 'user', 'password');
{}
{\b MS SQL Server (ODBC):}
!uses
!  mormot.db.sql.odbc;
!
!Props := TSqlDBOdbcConnectionProperties.Create(
!  'Driver={SQL Server};Server=.\SQLEXPRESS;Database=mydb',
!  '', 'user', 'password');
!
!// Windows authentication
!Props := TSqlDBOdbcConnectionProperties.Create(
!  'Driver={SQL Server};Server=.\SQLEXPRESS;Database=mydb;Trusted_Connection=Yes',
!  '', '', '');
{}
{\b Zeos (recommended for cross-database):}
!uses
!  mormot.db.sql.zeos;
!
!// PostgreSQL via Zeos
!Props := TSqlDBZeosConnectionProperties.Create(
!  'zdbc:postgresql://localhost:5432/mydb', '', 'user', 'password');
!
!// MySQL via Zeos
!Props := TSqlDBZeosConnectionProperties.Create(
!  'zdbc:mysql://localhost:3306/mydb', '', 'user', 'password');
!
!// Firebird via Zeos
!Props := TSqlDBZeosConnectionProperties.Create(
!  'zdbc:firebird://localhost/C:\Data\mydb.fdb', '', 'SYSDBA', 'masterkey');
{}
:  Connection Properties Lifecycle
{}
!var
!  Props: TSqlDBConnectionProperties;
!begin
!  // Create once, use throughout application
!  Props := TSqlDBPostgresConnectionProperties.Create(...);
!  try
!    // Props manages connection pool internally
!    UseDatabase(Props);
!  finally
!    Props.Free;  // Release all connections
!  end;
!end;
{}
{\b Important}: Create {\f1\fs20 TSqlDBConnectionProperties} once per application. It manages connection pooling automatically.
{}
:803 Executing Queries
{}
:  ISqlDBRows Interface
{}
The simplest and safest pattern:
{}
!var
!  Rows: ISqlDBRows;
!begin
!  Rows := Props.Execute(
!    'SELECT * FROM Customer WHERE Country = ?', ['USA']);
!
!  while Rows.Step do
!    WriteLn(Rows['Name'], ' - ', Rows['City']);
!
!  // No try..finally needed - interface auto-releases
!end;
{}
:  Statement-Based Access
{}
For more control:
{}
!var
!  Conn: TSqlDBConnection;
!  Stmt: ISqlDBStatement;  // Interface - auto-released
!begin
!  Conn := Props.ThreadSafeConnection;  // Thread-safe connection
!  Stmt := Conn.NewStatementPrepared(
!    'SELECT * FROM Customer WHERE Country = ?', True);  // True = cache
!
!  Stmt.BindTextU(1, 'USA');  // Use BindTextU for RawUtf8 strings
!  Stmt.ExecutePrepared;
!
!  while Stmt.Step do
!    WriteLn(Stmt.ColumnUtf8(0));
!  // No try..finally needed - interface auto-releases
!end;
{}
:  Late-Binding Access
{}
For convenient (but slower) field access:
{}
!var
!  Row: Variant;
!begin
!  with Props.Execute(
!    'SELECT * FROM Customer WHERE Country = ?',
!    ['USA'], @Row) do
!  while Step do
!    WriteLn(Row.Name, ' - ', Row.City);  // Late-binding!
!end;
{}
:  Direct JSON Output
{}
Export query results directly to @*JSON@:
{}
!var
!  Json: RawUtf8;
!begin
!  Json := Props.Execute(
!    'SELECT ID, Name, Email FROM Customer', []).FetchAllAsJson(True);
!  // Returns: [{"ID":1,"Name":"John","Email":"john@example.com"},...]
!end;
{}
:804 Field Types
{}
:  TSqlDBFieldType
{}
|%12%35%53
|\b Type|Delphi Type|Description\b0
|{\f1\fs20 ftNull}|-|SQL NULL
|{\f1\fs20 ftInt64}|{\f1\fs20 Int64}|Any integer
|{\f1\fs20 ftDouble}|{\f1\fs20 Double}|Floating-point
|{\f1\fs20 ftCurrency}|{\f1\fs20 Currency}|Fixed 4 decimals
|{\f1\fs20 ftDate}|{\f1\fs20 TDateTime}|Date and time
|{\f1\fs20 ftUtf8}|{\f1\fs20 RawUtf8}|@*Unicode@ text
|{\f1\fs20 ftBlob}|{\f1\fs20 RawByteString}|Binary data
|%
{}
:  Column Access Methods
{}
!// Type-safe access
!Value := Stmt.ColumnInt(0);       // Int64
!Value := Stmt.ColumnDouble(1);    // Double
!Value := Stmt.ColumnCurrency(2);  // Currency
!Value := Stmt.ColumnUtf8(3);      // RawUtf8
!Value := Stmt.ColumnDateTime(4);  // TDateTime
!Value := Stmt.ColumnBlob(5);      // RawByteString
!
!// Null checking
!if Stmt.ColumnNull(0) then
!  WriteLn('Value is NULL');
!
!// Variant access (auto-conversion)
!Value := Stmt.Column[0];  // Returns Variant
!Value := Stmt['ColumnName'];  // By name
{}
:805 Parameter Binding
{}
:  Positional Parameters
{}
!// Use ? for positional parameters
!Stmt := Conn.NewStatementPrepared(
!  'INSERT INTO Customer (Name, Email, Age) VALUES (?, ?, ?)', True);
!Stmt.BindTextU(1, 'John Doe');       // Use BindTextU for RawUtf8 strings
!Stmt.BindTextU(2, 'john@example.com');
!Stmt.Bind(3, Int64(30));             // Use Bind with Int64 for integers
!Stmt.ExecutePrepared;
{}
:  Array Binding (Bulk Insert)
{}
High-performance bulk operations:
{}
!// PostgreSQL, Oracle, and MSSQL support array binding
!Stmt := Conn.NewStatementPrepared(
!  'INSERT INTO Log (Timestamp, Message) VALUES (?, ?)', True);
!
!Stmt.BindArray(1, DateTimes);   // TDateTimeDynArray
!Stmt.BindArray(2, Messages);    // TRawUtf8DynArray
!Stmt.ExecutePrepared;           // Single network roundtrip!
{}
:  BLOB Parameters
{}
!var
!  Data: RawByteString;
!begin
!  Data := StringFromFile('image.png');
!  Stmt.Bind(1, ftBlob, Data);  // Explicit type
!  Stmt.ExecutePrepared;
!end;
{}
:806 Transactions
{}
:  Explicit Transactions
{}
!var
!  Conn: TSqlDBConnection;
!begin
!  Conn := Props.ThreadSafeConnection;
!  Conn.StartTransaction;
!  try
!    Conn.Execute('UPDATE Account SET Balance = Balance - 100 WHERE ID = 1');
!    Conn.Execute('UPDATE Account SET Balance = Balance + 100 WHERE ID = 2');
!    Conn.Commit;
!  except
!    Conn.Rollback;
!    raise;
!  end;
!end;
{}
:  Nested Transactions
{}
!// Most databases don't support true nested transactions
!// mORMot uses SAVEPOINTs where available
!Conn.StartTransaction;      // Begin
!try
!  Conn.StartTransaction;    // SAVEPOINT (if supported)
!  try
!    // Operations
!    Conn.Commit;            // RELEASE SAVEPOINT
!  except
!    Conn.Rollback;          // ROLLBACK TO SAVEPOINT
!    raise;
!  end;
!  Conn.Commit;              // COMMIT
!except
!  Conn.Rollback;            // ROLLBACK
!end;
{}
:807 ORM Integration
{}
:  Mapping TOrm to External Database
{}
!uses
!  mormot.orm.sql,
!  mormot.db.sql.postgres;
!
!var
!  Props: TSqlDBPostgresConnectionProperties;
!  Model: TOrmModel;
!  Server: TRestServerDB;
!begin
!  // Create connection properties
!  Props := TSqlDBPostgresConnectionProperties.Create(
!    'localhost:5432', 'mydb', 'user', 'password');
!
!  // Create model
!  Model := TOrmModel.Create([TOrmCustomer, TOrmOrder]);
!
!  // Map ORM classes to external database
!  OrmMapExternal(Model, TOrmCustomer, Props);
!  OrmMapExternal(Model, TOrmOrder, Props);
!
!  // Create server (SQLite3 for other tables)
!  Server := TRestServerDB.Create(Model, ':memory:');
!
!  // Now ORM operations go to PostgreSQL
!  Server.Orm.Add(Customer, True);
!end;
{}
:  Table and Field Name Mapping
{}
!// Custom table name
!OrmMapExternal(Model, TOrmCustomer, Props, 'CUSTOMERS');
!
!// Custom field mapping
!OrmMapExternal(Model, TOrmCustomer, Props, 'CUSTOMERS')
!  .MapField('Name', 'CUSTOMER_NAME')
!  .MapField('Email', 'EMAIL_ADDRESS');
{}
:  Auto-Create Tables
{}
!// mORMot can create tables in external database
!Props.UseFastCreateMissingFields := True;
!Server.CreateMissingTables;  // Creates in PostgreSQL
{}
:808 Multi-Database Scenarios
{}
:  Mixing Storage Backends
{}
!var
!  PostgresProps, OracleProps: TSqlDBConnectionProperties;
!begin
!  // Different databases for different tables
!  PostgresProps := TSqlDBPostgresConnectionProperties.Create(...);
!  OracleProps := TSqlDBOracleConnectionProperties.Create(...);
!
!  Model := TOrmModel.Create([
!    TOrmUser,     // Internal SQLite3
!    TOrmProduct,  // PostgreSQL
!    TOrmLegacy    // Oracle
!  ]);
!
!  OrmMapExternal(Model, TOrmProduct, PostgresProps);
!  OrmMapExternal(Model, TOrmLegacy, OracleProps);
!
!  Server := TRestServerDB.Create(Model, 'users.db3');
!end;
{}
:  Cross-Database Queries
{}
Thanks to SQLite3 virtual tables, you can JOIN across databases:
{}
!// This works even though Product is in PostgreSQL and User is in SQLite3!
!Server.Orm.ExecuteList([TOrmProduct, TOrmUser],
!  'SELECT Product.Name, User.Email ' +
!  'FROM Product, User ' +
!  'WHERE Product.OwnerID = User.ID');
{}
:809 Database-Specific Notes
{}
:  PostgreSQL
{}
!// Direct libpq access (fastest)
!uses mormot.db.sql.postgres;
!
!Props := TSqlDBPostgresConnectionProperties.Create(
!  'localhost:5432', 'dbname', 'user', 'pass');
!
!// Connection string options
!Props := TSqlDBPostgresConnectionProperties.Create(
!  'host=localhost port=5432 dbname=mydb sslmode=require',
!  '', 'user', 'pass');
{}
{\b Tips:}
- Use array binding for bulk inserts
- PostgreSQL handles @*UTF-8@ natively
- JSONB columns work well with {\f1\fs20 TDocVariant}
{}
:  Oracle
{}
!// Direct OCI access (fastest for Oracle)
!uses mormot.db.sql.oracle;
!
!Props := TSqlDBOracleConnectionProperties.Create(
!  'server/service', '', 'user', 'pass');
!
!// Array binding for bulk operations
!Props.ArrayBindingEnabled := True;
{}
{\b Tips:}
- Use array binding (Oracle excels at this)
- Direct OCI is much faster than ODBC/OleDB
- Large @*BLOB@s require special handling
{}
:  MS SQL Server
{}
!// ODBC (recommended)
!uses mormot.db.sql.odbc;
!
!Props := TSqlDBOdbcConnectionProperties.Create(
!  'Driver={ODBC Driver 17 for SQL Server};Server=.\SQLEXPRESS;Database=mydb',
!  '', 'user', 'pass');
!
!// OleDB alternative
!uses mormot.db.sql.oledb;
!
!Props := TSqlDBOleDBConnectionProperties.Create(
!  'Provider=SQLNCLI11;Server=.\SQLEXPRESS;Database=mydb',
!  '', 'user', 'pass');
{}
{\b Tips:}
- Use ODBC Driver 17+ for best performance
- Windows authentication: {\f1\fs20 Trusted_Connection=Yes}
- MARS (Multiple Active Result Sets) may cause issues
{}
:  MySQL/MariaDB
{}
!// Zeos (recommended)
!uses mormot.db.sql.zeos;
!
!Props := TSqlDBZeosConnectionProperties.Create(
!  'zdbc:mysql://localhost:3306/mydb', '', 'user', 'pass');
!
!// ODBC alternative
!Props := TSqlDBOdbcConnectionProperties.Create(
!  'Driver={MySQL ODBC 8.0 Driver};Server=localhost;Database=mydb',
!  '', 'user', 'pass');
{}
{\b Tips:}
- Use UTF-8 character set ({\f1\fs20 SET NAMES utf8mb4})
- InnoDB engine for transactions
- MariaDB is generally faster than MySQL
{}
:810 Performance Tuning
{}
:  Connection Pooling
{}
!// Connection pool is automatic
!Props := TSqlDBPostgresConnectionProperties.Create(...);
!
!// Configure pool size
!Props.ConnectionPoolMaxCount := 20;  // Max connections
!Props.ConnectionPoolTimeout := 60000;  // Timeout in ms
{}
:  Statement Caching
{}
!// Enable statement caching (True = cache)
!Stmt := Conn.NewStatementPrepared(SQL, True);
!
!// Clear cache if needed
!Conn.ClearStatementCache;
{}
:  Batch Operations
{}
!// Use ExecuteNoResult for multiple statements
!Conn.ExecuteNoResult('DELETE FROM TempTable');
!Conn.ExecuteNoResult('INSERT INTO TempTable SELECT * FROM Source');
!
!// Or use batch interface
!Batch := TRestBatch.Create(Server.Orm, TOrmCustomer);
!try
!  for i := 1 to 10000 do
!    Batch.Add(CreateCustomer(i), True);
!  Server.Orm.BatchSend(Batch);  // Single transaction
!finally
!  Batch.Free;
!end;
{}
:811 TDataSet Integration
{}
For VCL/FMX applications that need {\f1\fs20 TDataSet}:
{}
:  Read-Only DataSet
{}
!uses
!  mormot.db.rad.ui.sql;
!
!var
!  DataSet: TSqlDBDataSet;
!begin
!  DataSet := TSqlDBDataSet.Create(Self);
!  DataSet.Connection := Props;
!  DataSet.SQL.Text := 'SELECT * FROM Customer';
!  DataSet.Open;
!
!  DBGrid1.DataSource.DataSet := DataSet;
!end;
{}
:  From ISqlDBRows
{}
!uses
!  mormot.db.rad.ui.sql;
!
!var
!  Rows: ISqlDBRows;
!begin
!  Rows := Props.Execute('SELECT * FROM Customer', []);
!  DBGrid1.DataSource.DataSet := ToDataSet(Self, Rows);
!end;
{}
:812 Migration from mORMot 1
{}
:  Unit Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 SynDB.pas}|{\f1\fs20 mormot.db.sql.pas}
|{\f1\fs20 SynDBOracle.pas}|{\f1\fs20 mormot.db.sql.oracle.pas}
|{\f1\fs20 SynDBODBC.pas}|{\f1\fs20 mormot.db.sql.odbc.pas}
|{\f1\fs20 SynOleDB.pas}|{\f1\fs20 mormot.db.sql.oledb.pas}
|{\f1\fs20 SynDBZeos.pas}|{\f1\fs20 mormot.db.sql.zeos.pas}
|{\f1\fs20 SynDBSQLite3.pas}|{\f1\fs20 mormot.db.sql.sqlite3.pas}
|{\f1\fs20 SynDBDataset.pas}|{\f1\fs20 mormot.db.rad.pas}
|{\f1\fs20 SynDBFireDAC.pas}|{\f1\fs20 mormot.db.rad.firedac.pas}
|{\f1\fs20 mORMotDB.pas}|{\f1\fs20 mormot.orm.sql.pas}
|%
{}
:  Class Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 TSQLDBConnectionProperties}|{\f1\fs20 TSqlDBConnectionProperties}
|{\f1\fs20 TSQLDBConnection}|{\f1\fs20 TSqlDBConnection}
|{\f1\fs20 TSQLDBStatement}|{\f1\fs20 TSqlDBStatement}
|{\f1\fs20 ISQLDBRows}|{\f1\fs20 ISqlDBRows}
|{\f1\fs20 TSQLDBFieldType}|{\f1\fs20 TSqlDBFieldType}
|{\f1\fs20 VirtualTableExternalRegister}|{\f1\fs20 OrmMapExternal}
|%
{}
:  API Changes
{}
!// mORMot 1
!VirtualTableExternalRegister(Model, TSQLCustomer, Props);
!
!// mORMot 2
!OrmMapExternal(Model, TOrmCustomer, Props);
{}
{\i Next Chapter: External NoSQL Database Access (@*MongoDB@)}
{}