; Converted from Markdown - Chapter 9
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:9External NoSQL Database Access
{}
{\i @*MongoDB@ and Object-Document Mapping}
{}
m@*ORM@ot provides native access to NoSQL databases, with MongoDB as the primary supported engine. The ORM seamlessly transforms into an @*ODM@ (Object-Document Mapping) when working with document stores.
{}
:901 NoSQL Overview
{}
:  Supported NoSQL Engines
{}
|%21%9%70
|\b Engine|Unit|Description\b0
|MongoDB|@!src\db\mormot.db.nosql.mongodb.pas@|Full ODM support
|In-Memory|@!src\orm\mormot.orm.storage.pas@|{\f1\fs20 TObjectList} with @*JSON@/binary persistence
|%
{}
:  MongoDB Advantages
{}
- {\b Schema flexibility}: Documents can have varying structures
- {\b Horizontal scaling}: Built-in sharding and replication
- {\b Document model}: Natural fit for mORMot's {\f1\fs20 TDocVariant}
- {\b High performance}: Excellent for write-heavy workloads
- {\b JSON native}: Direct integration with mORMot's JSON handling
{}
:902 MongoDB Client
{}
:  Unit Structure
{}
!mormot.db.nosql.bson.pas     → BSON encoding/decoding
!        ↓
!mormot.db.nosql.mongodb.pas  → MongoDB wire protocol client
!        ↓
!mormot.orm.mongodb.pas       → ORM/ODM integration
{}
:  Connecting to MongoDB
{}
{\b Basic connection:}
!uses
!  mormot.db.nosql.mongodb;
!
!var
!  Client: TMongoClient;
!  DB: TMongoDatabase;
!begin
!  Client := TMongoClient.Create('localhost', 27017);
!  try
!    DB := Client.Database['mydb'];
!    // Use DB...
!  finally
!    Client.Free;
!  end;
!end;
{}
{\b With authentication (SCRAM-SHA-1):}
!var
!  Client: TMongoClient;
!  DB: TMongoDatabase;
!begin
!  Client := TMongoClient.Create('localhost', 27017);
!  try
!    // Authenticate and get database
!    DB := Client.OpenAuth('mydb', 'username', 'password');
!    // Use DB...
!  finally
!    Client.Free;
!  end;
!end;
{}
{\b Replica set connection:}
!Client := TMongoClient.Create(
!  'mongodb://host1:27017,host2:27017,host3:27017/?replicaSet=myReplicaSet');
{}
:  Connection Options
{}
!Client := TMongoClient.Create('localhost', 27017);
!
!// Write concern settings
!Client.WriteConcern := wcAcknowledged;      // Default - wait for ack
!Client.WriteConcern := wcUnacknowledged;    // Fire and forget (fastest)
!Client.WriteConcern := wcMajority;          // Wait for majority
!
!// Read preference
!Client.ReadPreference := rpPrimary;         // Always read from primary
!Client.ReadPreference := rpSecondary;       // Read from secondaries
!Client.ReadPreference := rpNearest;         // Nearest server
{}
:903 BSON and TDocVariant
{}
:  BSON Types
{}
MongoDB uses BSON (Binary JSON), which extends JSON with additional types:
{}
|%32%68
|\b BSON Type|Delphi Representation\b0
|Double|{\f1\fs20 Double}
|String|{\f1\fs20 RawUtf8}
|Document|{\f1\fs20 TDocVariant}
|Array|{\f1\fs20 TDocVariant} (array mode)
|Binary|{\f1\fs20 RawByteString}
|ObjectId|{\f1\fs20 TBsonObjectID}
|Boolean|{\f1\fs20 Boolean}
|DateTime|{\f1\fs20 TDateTime}
|Null|{\f1\fs20 Null} variant
|Int32|{\f1\fs20 Integer}
|Int64|{\f1\fs20 Int64}
|Decimal128|{\f1\fs20 TDecimal128}
|%
{}
:  TDocVariant Integration
{}
{\f1\fs20 TDocVariant} seamlessly maps to MongoDB documents:
{}
!var
!  Doc: Variant;
!begin
!  // Create document with late-binding
!  TDocVariant.New(Doc);
!  Doc.name := 'John Doe';
!  Doc.email := 'john@example.com';
!  Doc.age := 30;
!  Doc.tags := _Arr(['developer', 'delphi', 'mongodb']);
!  Doc.address := _Obj([
!    'street', '123 Main St',
!    'city', 'New York',
!    'zip', '10001'
!  ]);
!
!  // Save to MongoDB
!  Coll.Insert(Doc);
!end;
{}
:  ObjectID Generation
{}
!var
!  ID: TBsonObjectID;
!begin
!  // Generate new ObjectID (client-side)
!  ID.ComputeNew;  // Use ComputeNew method on record
!
!  // ObjectID contains timestamp
!  WriteLn('Created at: ', DateTimeToStr(ID.CreateDateTime));
!
!  // Use in document
!  Doc._id := ID.ToVariant;
!  Coll.Insert(Doc);
!end;
{}
:904 Collection Operations
{}
:  Getting a Collection
{}
!var
!  Coll: TMongoCollection;
!begin
!  // Get or create collection
!  Coll := DB.CollectionOrCreate['customers'];
!
!  // Get existing collection
!  Coll := DB.Collection['customers'];
!end;
{}
:  Insert Operations
{}
{\b Single document:}
!var
!  Doc: Variant;
!begin
!  Doc := _ObjFast([
!    'name', 'John Doe',
!    'email', 'john@example.com',
!    'age', 30
!  ]);
!
!  Coll.Insert(Doc);
!  WriteLn('Inserted with _id: ', Doc._id);  // Auto-generated ObjectID
!end;
{}
{\b Bulk insert (much faster):}
!var
!  Docs: TVariantDynArray;
!  i: Integer;
!begin
!  SetLength(Docs, 10000);
!  for i := 0 to High(Docs) do
!  begin
!    ID.ComputeNew;  // Generate new ObjectID
!    Docs[i] := _ObjFast([
!      '_id', ID.ToVariant,
!      'index', i,
!      'data', FormatUtf8('Record %', [i])
!    ]);
!  end;
!
!  Coll.Insert(Docs);  // Single network roundtrip!
!end;
{}
:  Find Operations
{}
{\b Find one document:}
!var
!  Doc: Variant;
!begin
!  // By _id
!  Doc := Coll.FindOne(ObjectID);
!  Doc := Coll.FindOne(123);  // Integer _id
!
!  // By query
!  Doc := Coll.FindDoc('{name:?}', ['John']);
!  Doc := Coll.FindDoc('{age:{$gt:?}}', [21]);
!end;
{}
{\b Find multiple documents:}
!var
!  Docs: TVariantDynArray;
!  Doc: Variant;
!begin
!  // Get all matching documents
!  Coll.FindDocs('{status:?}', ['active'], Docs);
!
!  for Doc in Docs do
!    WriteLn(Doc.name);
!end;
{}
{\b Find with projection:}
!var
!  Json: RawUtf8;
!begin
!  // Return only specific fields
!  Json := Coll.FindJson(
!    '{status:?}',        // Query
!    ['active'],          // Parameters
!    '{name:1,email:1}'   // Projection (include name and email)
!  );
!end;
{}
{\b Iterating multiple documents:}
!var
!  Docs: TVariantDynArray;
!  Doc: Variant;
!begin
!  // FindDocs fills array with all matching documents
!  Coll.FindDocs('{age:{$gte:?}}', [18], Docs, Null);
!  for Doc in Docs do
!    WriteLn(Doc.name);
!end;
{}
> {\b Note}: mORMot2 MongoDB uses array-based retrieval ({\f1\fs20 FindDocs}) rather than cursor iteration. For large result sets, use pagination with {\f1\fs20 NumberToReturn} and {\f1\fs20 NumberToSkip} parameters.
{}
:  Update Operations
{}
{\b Replace document:}
!var
!  Doc: Variant;
!begin
!  Doc := Coll.FindOne(123);
!  Doc.status := 'updated';
!  Coll.Save(Doc);  // Replace entire document
!end;
{}
{\b Partial update ($set):}
!// Update specific fields only
!Coll.Update(
!  '{_id:?}', [123],           // Query
!  '{$set:{status:?,updated:?}}', ['active', Now]  // Update
!);
{}
{\b Update multiple documents:}
!// Set all inactive users to archived
!Coll.UpdateMany(
!  '{status:?}', ['inactive'],
!  '{$set:{archived:?}}', [True]
!);
{}
{\b Upsert (insert if not exists):}
!Coll.Update(
!  '{email:?}', ['john@example.com'],
!  '{$set:{name:?,lastSeen:?}}', ['John', Now],
!  [mufUpsert]  // Create if not found
!);
{}
:  Delete Operations
{}
{\b Delete one:}
!Coll.Remove('{_id:?}', [ObjectID]);
!Coll.RemoveOne(123);  // By _id
{}
{\b Delete many:}
!Coll.Remove('{status:?}', ['deleted']);  // Delete all matching
{}
{\b Bulk delete:}
!var
!  IDs: TBsonObjectIDDynArray;
!begin
!  // Much faster than individual deletes
!  Coll.Remove('{_id:{$in:?}}', [IDs]);
!end;
{}
:905 MongoDB Query Language
{}
:  Comparison Operators
{}
|%25%53%22
|\b Operator|Description|Example\b0
|{\f1\fs20 $eq}|Equal|{\f1\fs20 {age:{$eq:30}}}
|{\f1\fs20 $ne}|Not equal|{\f1\fs20 {status:{$ne:'deleted'}}}
|{\f1\fs20 $gt}|Greater than|{\f1\fs20 {age:{$gt:21}}}
|{\f1\fs20 $gte}|Greater or equal|{\f1\fs20 {age:{$gte:18}}}
|{\f1\fs20 $lt}|Less than|{\f1\fs20 {price:{$lt:100}}}
|{\f1\fs20 $lte}|Less or equal|{\f1\fs20 {stock:{$lte:10}}}
|{\f1\fs20 $in}|In array|{\f1\fs20 {status:{$in:['active','pending']}}}
|{\f1\fs20 $nin}|Not in array|{\f1\fs20 {role:{$nin:['admin']}}}
|%
{}
:  Logical Operators
{}
!// AND (implicit)
!Coll.FindDocs('{age:{$gte:?},status:?}', [18, 'active'], Docs);
!
!// AND (explicit)
!Coll.FindDocs('{$and:[{age:{$gte:?}},{age:{$lt:?}}]}', [18, 65], Docs);
!
!// OR
!Coll.FindDocs('{$or:[{status:?},{priority:{$gt:?}}]}', ['urgent', 5], Docs);
!
!// NOT
!Coll.FindDocs('{age:{$not:{$lt:?}}}', [18], Docs);
{}
:  Element Operators
{}
!// Field exists
!Coll.FindDocs('{email:{$exists:true}}', [], Docs);
!
!// Type check
!Coll.FindDocs('{age:{$type:"int"}}', [], Docs);
{}
:  Array Operators
{}
!// Element in array
!Coll.FindDocs('{tags:?}', ['mongodb'], Docs);
!
!// All elements match
!Coll.FindDocs('{tags:{$all:?}}', [_Arr(['mongodb','delphi'])], Docs);
!
!// Array size
!Coll.FindDocs('{tags:{$size:?}}', [3], Docs);
!
!// Element match
!Coll.FindDocs('{items:{$elemMatch:{qty:{$gt:?},price:{$lt:?}}}}', [10, 100], Docs);
{}
:  Text Search
{}
!// Create text index first
!Coll.EnsureIndex('{content:"text"}');
!
!// Text search
!Coll.FindDocs('{$text:{$search:?}}', ['mongodb tutorial'], Docs);
{}
:906 ORM/ODM Integration
{}
:  Mapping TOrm to MongoDB
{}
!uses
!  mormot.orm.mongodb,
!  mormot.db.nosql.mongodb;
!
!var
!  Client: TMongoClient;
!  Model: TOrmModel;
!  Server: TRestServerDB;
!begin
!  // Connect to MongoDB
!  Client := TMongoClient.Create('localhost', 27017);
!
!  // Create model
!  Model := TOrmModel.Create([TOrmCustomer, TOrmOrder]);
!
!  // Map classes to MongoDB
!  OrmMapMongoDB(Model, TOrmCustomer, Client.Database['mydb'], 'customers');
!  OrmMapMongoDB(Model, TOrmOrder, Client.Database['mydb'], 'orders');
!
!  // Create server
!  Server := TRestServerDB.Create(Model, ':memory:');
!end;
{}
:  TOrm with MongoDB
{}
!type
!  TOrmArticle = class(TOrm)
!  private
!    fTitle: RawUtf8;
!    fContent: RawUtf8;
!    fTags: TRawUtf8DynArray;
!    fMetadata: Variant;  // TDocVariant for flexible schema
!  published
!    property Title: RawUtf8 read fTitle write fTitle;
!    property Content: RawUtf8 read fContent write fContent;
!    property Tags: TRawUtf8DynArray read fTags write fTags;
!    property Metadata: Variant read fMetadata write fMetadata;
!  end;
{}
:  Using the ORM
{}
Once mapped, use standard ORM methods:
{}
!var
!  Article: TOrmArticle;
!begin
!  // Create
!  Article := TOrmArticle.Create;
!  Article.Title := 'Introduction to MongoDB';
!  Article.Content := 'MongoDB is a document database...';
!  Article.Tags := ['mongodb', 'nosql', 'database'];
!  Article.Metadata := _ObjFast(['author', 'John', 'views', 0]);
!  Server.Orm.Add(Article, True);
!
!  // Read
!  Article := TOrmArticle.Create(Server.Orm, ArticleID);
!
!  // Update
!  Article.Metadata.views := Article.Metadata.views + 1;
!  Server.Orm.Update(Article);
!
!  // Delete
!  Server.Orm.Delete(TOrmArticle, ArticleID);
!
!  // Query
!  Article := TOrmArticle.CreateAndFillPrepare(Server.Orm,
!    'Tags = ?', ['mongodb']);
!  while Article.FillOne do
!    WriteLn(Article.Title);
!end;
{}
:  MongoDB-Specific Queries
{}
For advanced queries, use direct MongoDB access:
{}
!var
!  Coll: TMongoCollection;
!  Docs: TVariantDynArray;
!begin
!  // Get underlying collection
!  Coll := TRestStorageMongoDB(
!    Server.StaticDataServer[TOrmArticle]).Collection;
!
!  // Complex aggregation
!  Coll.AggregateJson([
!    '{$match:{status:"published"}}',
!    '{$group:{_id:"$author",count:{$sum:1}}}',
!    '{$sort:{count:-1}}'
!  ], Docs);
!end;
{}
:907 Aggregation Framework
{}
:  Pipeline Operations
{}
!var
!  Results: TVariantDynArray;
!begin
!  Coll.AggregateDoc([
!    // Stage 1: Filter
!    _ObjFast(['$match', _Obj(['status', 'active'])]),
!
!    // Stage 2: Group and count
!    _ObjFast(['$group', _Obj([
!      '_id', '$category',
!      'total', _Obj(['$sum', 1]),
!      'avgPrice', _Obj(['$avg', '$price'])
!    ])]),
!
!    // Stage 3: Sort
!    _ObjFast(['$sort', _Obj(['total', -1])])
!  ], Results);
!
!  for Doc in Results do
!    WriteLn(Doc._id, ': ', Doc.total, ' items, avg $', Doc.avgPrice);
!end;
{}
:  Common Aggregation Operators
{}
|%30%70
|\b Operator|Description\b0
|{\f1\fs20 $match}|Filter documents
|{\f1\fs20 $group}|Group by field
|{\f1\fs20 $sort}|Sort results
|{\f1\fs20 $project}|Reshape documents
|{\f1\fs20 $limit}|Limit results
|{\f1\fs20 $skip}|Skip documents
|{\f1\fs20 $unwind}|Deconstruct arrays
|{\f1\fs20 $lookup}|Left outer join
|%
{}
:908 Indexes
{}
:  Creating Indexes
{}
!// Single field index
!Coll.EnsureIndex('{email:1}');  // 1 = ascending
!
!// Compound index
!Coll.EnsureIndex('{status:1,created:-1}');
!
!// Unique index
!Coll.EnsureIndex('{email:1}', [ifoUnique]);
!
!// Text index
!Coll.EnsureIndex('{title:"text",content:"text"}');
!
!// TTL index (auto-delete after time)
!Coll.EnsureIndex('{createdAt:1}', [ifoExpireAfterSeconds], 3600);
{}
:  Index Hints
{}
!// Force index usage
!Coll.FindJson('{status:?}', ['active'], '',
!  '{$hint:{status:1}}');  // Use status index
{}
:909 Performance Tips
{}
:  Write Performance
{}
!// 1. Use bulk inserts
!Coll.Insert(DocsArray);  // Single call for many documents
!
!// 2. Use unacknowledged writes for non-critical data
!Client.WriteConcern := wcUnacknowledged;
!try
!  // Fast writes (no server confirmation)
!  Coll.Insert(LogEntries);
!finally
!  Client.WriteConcern := wcAcknowledged;
!end;
!
!// 3. Pre-generate ObjectIDs
!for i := 0 to High(Docs) do
!begin
!  ID.ComputeNew;
!  Docs[i]._id := ID.ToVariant;
!end;
{}
:  Read Performance
{}
!// 1. Use projections to limit returned fields
!Coll.FindJson('{status:?}', ['active'], '{name:1,email:1}');
!
!// 2. Use covered queries (all fields in index)
!Coll.EnsureIndex('{email:1,name:1}');
!Coll.FindJson('{email:?}', ['john@example.com'], '{email:1,name:1,_id:0}');
!
!// 3. Use cursor batching for large result sets
!Cursor := Coll.Find(Query, nil, [mqfNoCursorTimeout]);
!Cursor.BatchSize := 1000;
{}
:  Index Strategies
{}
- Index fields used in {\f1\fs20 $match} stages
- Index fields used in sorts
- Compound indexes for multi-field queries
- Cover queries with indexes when possible
- Monitor with {\f1\fs20 explain()} equivalent
{}
:910 Migration from mORMot 1
{}
:  Unit Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 SynMongoDB.pas}|{\f1\fs20 mormot.db.nosql.mongodb.pas}
|{\f1\fs20 mORMotMongoDB.pas}|{\f1\fs20 mormot.orm.mongodb.pas}
|%
{}
:  Class/Function Renames
{}
|%40%60
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 StaticMongoDBRegister}|{\f1\fs20 OrmMapMongoDB}
|{\f1\fs20 TMongoClient}|{\f1\fs20 TMongoClient} (unchanged)
|{\f1\fs20 TMongoDatabase}|{\f1\fs20 TMongoDatabase} (unchanged)
|{\f1\fs20 TMongoCollection}|{\f1\fs20 TMongoCollection} (unchanged)
|%
{}
:  Protocol Changes
{}
mORMot 2 uses the new MongoDB wire protocol (OP_MSG) introduced in MongoDB 3.6:
{}
!// For older MongoDB versions (< 3.6), define:
!{$DEFINE MONGO_OLDPROTOCOL}
{}
:911 Summary
{}
MongoDB integration in mORMot 2 provides:
{}
- {\b Full ODM support}: Use {\f1\fs20 TOrm} classes with MongoDB
- {\b Direct client access}: Low-level {\f1\fs20 TMongoClient} for advanced operations
- {\b {\f1\fs20 @**TDocVariant@} integration}: Natural document handling
- {\b Query flexibility}: Full MongoDB query language support
- {\b Performance}: Bulk operations, connection pooling, index management
- {\b Mixing backends}: Combine MongoDB with SQL in same application
{}
{\i Next Chapter: JSON @*REST@ful Client-Server}
{}