; Converted from Markdown - Chapter 10
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:10JSON and RESTful Fundamentals
{}
{\i The Language of m@*ORM@ot}
{}
Before exploring the Client-Server architecture, we need to understand the two key standards that mORMot builds upon: @*JSON@ for data interchange and @*REST@ for API design.
{}
:1001 JSON in mORMot
{}
:  Why JSON?
{}
mORMot uses JSON (JavaScript Object Notation) as its primary data format:
{}
|%25%75
|\b Advantage|Description\b0
|Human-readable|Easy to debug and inspect
|Compact|Smaller than XML for most use cases
|Fast parsing|In-place parsing without memory allocation
|Native @*UTF-8@|Matches @*SQLite3@ and web standards
|Universal|Supported by all languages/platforms
|AJAX-ready|Native to JavaScript/browser apps
|%
{}
:  JSON Types
{}
${
$  "string": "Hello UTF-8 World",
$  "number": 42,
$  "float": 3.14159,
$  "boolean": true,
$  "null": null,
$  "array": [1, 2, 3],
$  "object": {"nested": "value"}
$}
{}
:  mORMot JSON Extensions
{}
mORMot follows the JSON standard with some extensions:
{}
- {\b Extended syntax}: Unquoted ASCII property names (@*MongoDB@-style)
- {\b 64-bit integers}: Full {\f1\fs20 Int64} support (no JavaScript 53-bit limit)
- {\b Binary data}: Base64 encoding for @*BLOB@s
- {\b Custom types}: {\f1\fs20 TDateTime}, {\f1\fs20 TTimeLog}, {\f1\fs20 Currency} serialization
{}
!// Extended syntax (valid in mORMot)
!{name: "John", age: 30}
!
!// Standard JSON (always valid)
!{"name": "John", "age": 30}
{}
:1002 JSON Serialization
{}
:  Basic Types
{}
!uses
!  mormot.core.json;
!
!var
!  i: Integer;
!  d: Double;
!  s: RawUtf8;
!  json: RawUtf8;
!begin
!  // To JSON
!  json := FormatJson('{name:?,age:?,score:?}', [], ['John', 30, 95.5]);
!  // Result: {"name":"John","age":30,"score":95.5}
!
!  // From JSON
!  JsonDecode(pointer(json), ['name', 'age', 'score'], @Values);
!end;
{}
:  Record Serialization
{}
Records are automatically serialized via @*RTTI@ (Delphi 2010+):
{}
!type
!  TPerson = record
!    Name: RawUtf8;
!    Age: Integer;
!    Email: RawUtf8;
!  end;
!
!var
!  Person: TPerson;
!  json: RawUtf8;
!begin
!  Person.Name := 'John';
!  Person.Age := 30;
!  Person.Email := 'john@example.com';
!
!  // Record to JSON
!  json := RecordSaveJson(Person, TypeInfo(TPerson));
!  // Result: {"Name":"John","Age":30,"Email":"john@example.com"}
!
!  // JSON to Record
!  RecordLoadJson(Person, pointer(json), TypeInfo(TPerson));
!end;
{}
:  Dynamic Arrays
{}
!type
!  TPersonArray = array of TPerson;
!
!var
!  People: TPersonArray;
!  json: RawUtf8;
!begin
!  SetLength(People, 2);
!  People[0].Name := 'John';
!  People[1].Name := 'Jane';
!
!  // Array to JSON
!  json := DynArraySaveJson(People, TypeInfo(TPersonArray));
!  // Result: [{"Name":"John",...},{"Name":"Jane",...}]
!
!  // JSON to Array
!  DynArrayLoadJson(People, pointer(json), TypeInfo(TPersonArray));
!end;
{}
:  TDocVariant (Schema-less)
{}
For flexible JSON handling:
{}
!var
!  doc: Variant;
!begin
!  // Create from JSON
!  doc := _JsonFast('{"name":"John","tags":["admin","user"]}');
!
!  // Access via late-binding
!  WriteLn(doc.name);           // 'John'
!  WriteLn(doc.tags._Count);    // 2
!
!  // Modify
!  doc.email := 'john@example.com';
!  doc.tags._Add('moderator');
!
!  // Back to JSON
!  WriteLn(doc);  // Full JSON string
!end;
{}
:  Class Serialization
{}
Classes are serialized via {\f1\fs20 published} properties:
{}
!type
!  TMyClass = class(TSynPersistent)
!  private
!    fName: RawUtf8;
!    fValue: Integer;
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Value: Integer read fValue write fValue;
!  end;
!
!var
!  Obj: TMyClass;
!  json: RawUtf8;
!begin
!  Obj := TMyClass.Create;
!  Obj.Name := 'Test';
!  Obj.Value := 42;
!
!  json := ObjectToJson(Obj);
!  // Result: {"Name":"Test","Value":42}
!
!  JsonToObject(Obj, pointer(json), Valid);
!end;
{}
:1003 REST Architecture
{}
:  What is REST?
{}
REST (Representational State Transfer) defines how resources are addressed and manipulated over @*HTTP@:
{}
|%21%11%19%49
|\b HTTP Method|CRUD|ORM Method|Description\b0
|{\f1\fs20 GET}|Read|{\f1\fs20 Retrieve()}|Get resource(s)
|{\f1\fs20 POST}|Create|{\f1\fs20 Add()}|Create new resource
|{\f1\fs20 PUT}|Update|{\f1\fs20 Update()}|Update existing resource
|{\f1\fs20 DELETE}|Delete|{\f1\fs20 Delete()}|Remove resource
|%
{}
:  mORMot URI Structure
{}
!http://server:port/root/TableName/ID
$                   │     │         │
$                   │     │         └── Record ID (optional)
$                   │     └── TOrm class name
$                   └── Model.Root
{}
{\b Examples:}
!GET    /api/Customer          → List all customers
!GET    /api/Customer/123      → Get customer #123
!POST   /api/Customer          → Create new customer (body = JSON)
!PUT    /api/Customer/123      → Update customer #123
!DELETE /api/Customer/123      → Delete customer #123
{}
:  REST vs RPC in mORMot
{}
mORMot is {\b REST-oriented} but supports both paradigms:
{}
|%36%32%32
|\b Feature|REST Style|RPC Style\b0
|ORM operations|URI + HTTP verbs|URI + HTTP verbs
|Method services|{\f1\fs20 GET/POST /root/Method}|{\f1\fs20 POST /root/Method}
|Interface services|{\f1\fs20 /root/Interface.Method}|JSON-RPC body
|%
{}
{\b Important}: mORMot prefers interface-based services (RPC-style) for business logic, using REST primarily for ORM operations.
{}
:1004 JSON in ORM
{}
:  TOrm to JSON
{}
!var
!  Customer: TOrmCustomer;
!  json: RawUtf8;
!begin
!  Customer := TOrmCustomer.Create;
!  Customer.Name := 'ACME Corp';
!  Customer.Email := 'contact@acme.com';
!
!  // Single record
!  json := Customer.GetJsonValues(True, True, ooSelect);
!  // Result: {"ID":0,"Name":"ACME Corp","Email":"contact@acme.com"}
!
!  // Selected fields only
!  json := Customer.GetJsonValues(True, True, ooSelect, 'Name,Email');
!end;
{}
:  JSON to TOrm
{}
!var
!  Customer: TOrmCustomer;
!begin
!  Customer := TOrmCustomer.Create;
!  Customer.FillFrom('{"Name":"ACME Corp","Email":"contact@acme.com"}');
!end;
{}
:  Query Results as JSON
{}
!var
!  json: RawUtf8;
!begin
!  // Direct JSON from query
!  json := Server.Orm.RetrieveListJson(TOrmCustomer,
!    'Country = ?', ['USA'], 'Name,Email');
!  // Result: [{"Name":"John","Email":"john@..."},...]
!end;
{}
:1005 JSON in Services
{}
:  Method-Based Services
{}
!type
!  TMyServer = class(TRestServerDB)
!  published
!    procedure Sum(Ctxt: TRestServerUriContext);
!  end;
!
!procedure TMyServer.Sum(Ctxt: TRestServerUriContext);
!var
!  A, B: Integer;
!begin
!  A := Ctxt.InputInt['a'];
!  B := Ctxt.InputInt['b'];
!  Ctxt.Returns(['result', A + B]);
!end;
!
!// Client call: GET /api/Sum?a=10&b=20
!// Response: {"result":30}
{}
:  Interface-Based Services
{}
!type
!  ICalculator = interface(IInvokable)
!    ['{...}']
!    function Add(A, B: Integer): Integer;
!  end;
!
!// Server registration
!Server.ServiceDefine(TCalculator, [ICalculator], sicShared);
!
!// Client call (automatic JSON marshalling)
!var
!  Calc: ICalculator;
!begin
!  Client.Services.Resolve(ICalculator, Calc);
!  Result := Calc.Add(10, 20);  // JSON: {"result":30}
!end;
{}
:1006 Binary Alternatives
{}
:  When to Use Binary
{}
|%16%47%37
|\b Format|Use Case|Trade-off\b0
|JSON|Interoperability, debugging|Larger, slower parsing
|Binary|Internal, large data|Smaller, faster
|SynLZ+JSON|Compression over network|Best of both
|%
{}
:  SynLZ Compression
{}
mORMot clients automatically negotiate compression:
{}
!// Server enables compression (default)
!HttpServer.Compress := [hcSynLZ, hcDeflate];
!
!// SynLZ is 20x faster than Deflate for compression
!// Delphi clients use SynLZ automatically
!// AJAX clients fall back to Deflate
{}
:  Binary Serialization
{}
!// Binary record save (faster than JSON)
!Binary := RecordSave(Person, TypeInfo(TPerson));
!RecordLoad(Person, pointer(Binary), TypeInfo(TPerson));
!
!// Binary with compression
!Binary := RecordSaveBase64(Person, TypeInfo(TPerson), True);
{}
:1007 JSON Performance Tips
{}
:  Avoid Unnecessary Conversions
{}
!// SLOW: Multiple conversions
!s := Utf8ToString(json);
!json2 := StringToUtf8(s);
!
!// FAST: Stay in UTF-8
!ProcessRawUtf8(json);
{}
:  Use Typed Helpers
{}
!// SLOW: Variant access
!value := doc.field;
!
!// FAST: Direct typed access
!value := _Safe(doc)^.I['field'];  // Integer
!value := _Safe(doc)^.U['field'];  // RawUtf8
{}
:  Reuse Objects
{}
!// SLOW: Create/Free per iteration
!for i := 1 to 1000 do
!begin
!  Obj := TMyClass.Create;
!  try
!    JsonToObject(Obj, pointer(json[i]), Valid);
!    Process(Obj);
!  finally
!    Obj.Free;
!  end;
!end;
!
!// FAST: Reuse single instance
!Obj := TMyClass.Create;
!try
!  for i := 1 to 1000 do
!  begin
!    Obj.ClearProperties;  // Reset fields
!    JsonToObject(Obj, pointer(json[i]), Valid);
!    Process(Obj);
!  end;
!finally
!  Obj.Free;
!end;
{}
:1008 Migration from mORMot 1
{}
:  Function Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 JSONToObject()}|{\f1\fs20 JsonToObject()}
|{\f1\fs20 ObjectToJSON()}|{\f1\fs20 ObjectToJson()}
|{\f1\fs20 RecordSaveJSON()}|{\f1\fs20 RecordSaveJson()}
|{\f1\fs20 RecordLoadJSON()}|{\f1\fs20 RecordLoadJson()}
|{\f1\fs20 DynArraySaveJSON()}|{\f1\fs20 DynArraySaveJson()}
|{\f1\fs20 JSONDecode()}|{\f1\fs20 JsonDecode()}
|%
{}
:  Unit Locations
{}
|%61%39
|\b Feature|mORMot 2 Unit\b0
|JSON parsing|@!src\core\mormot.core.json.pas@
|{\f1\fs20 @**TDocVariant@}|@!src\core\mormot.core.variants.pas@
|Record serialization|@!src\core\mormot.core.rtti.pas@
|HTTP client/server|@!src\net\mormot.net.client.pas@ / @!src\net\mormot.net.server.pas@
|%
{}
{\i Next Chapter: Client-Server Architecture}
{}