; Converted from Markdown - Chapter 11
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:11Client-Server Architecture
{}
{\i Communication Layers and Protocols}
{}
m@*ORM@ot provides a flexible Client-Server architecture supporting multiple communication protocols. This chapter covers the protocol options, class hierarchy, and configuration patterns.
{}
:1101 Architecture Overview
{}
:  Communication Layers
{}
$┌─────────────────────────────────────────────────────────────────┐
$│                       Your Application                          │
$└─────────────────────────────────────────────────────────────────┘
$                               │
$┌─────────────────────────────────────────────────────────────────┐
$│                    TRest (Abstract Parent)                      │
$│    ├── Orm: IRestOrm        (Object-Relational Mapping)         │
$│    ├── Services             (Service-Oriented Architecture)     │
$│    └── Run: TRestRunThreads (Threading)                         │
$└─────────────────────────────────────────────────────────────────┘
$           │                                    │
$┌──────────────────────┐          ┌──────────────────────┐         
$│    TRestClient       │          │    TRestServer                │
$│  (Client-side)       │          │  (Server-side)                │
$└──────────────────────┘          └──────────────────────┘         
$           │                                    │
$┌─────────────────────────────────────────────────────────────────┐
$│                      Transport Layer                            │
$│  ┌──────────┐  ┌─────────┐  ┌──────────┐  ┌────────────────┐    │
$│  │In-Process│  │  HTTP   │  │WebSockets│  │Named Pipes/Msg │    │
$│  └──────────┘  └─────────┘  └──────────┘  └────────────────┘    │
$└─────────────────────────────────────────────────────────────────┘
{}
:  Protocol Comparison
{}
|%18%8%12%20%42
|\b Protocol|Speed|Scaling|Hosting|Use Case\b0
|In-Process|★★★★|★★★★|Same process|Testing, embedded
|@*HTTP@|★★|★★★★|Remote|Production servers
|@*WebSocket@s|★★★|★★★|Remote|Bidirectional callbacks
|Named Pipes|★★★|★|Local|Windows services
|%
{}
:  Access Methods
{}
|%22%36%42
|\b Method|Best For|Considerations\b0
|@*SOA@ Interfaces|Public/private services|Recommended, full features
|SOA Methods|Full @*REST@ control|More verbose
|@*MVC@ Web|Dynamic websites|HTML-oriented
|ORM REST|Testing, internal|Not for public APIs
|%
{}
:1102 Server Classes
{}
:  Class Hierarchy
{}
!TRest (abstract)
$└── TRestServer (abstract)
$    ├── TRestServerDB           → SQLite3 backend
$    ├── TRestServerFullMemory   → In-memory (no SQLite3)
$    └── TRestServerRemoteDB     → Proxy to remote ORM
{}
:  TRestServerDB (SQLite3)
{}
The primary server class with full @*SQLite3@ database:
{}
!uses
!  mormot.orm.core,
!  mormot.rest.sqlite3;
!
!var
!  Model: TOrmModel;
!  Server: TRestServerDB;
!begin
!  Model := TOrmModel.Create([TOrmCustomer, TOrmOrder]);
!  Server := TRestServerDB.Create(Model, 'data.db3');
!  try
!    Server.CreateMissingTables;
!    // Server ready...
!  finally
!    Server.Free;
!    Model.Free;
!  end;
!end;
{}
:  TRestServerFullMemory (No SQLite3)
{}
Lightweight server without SQLite3 dependency:
{}
!uses
!  mormot.rest.memserver;
!
!var
!  Server: TRestServerFullMemory;
!begin
!  Server := TRestServerFullMemory.Create(Model);
!  try
!    // Fast in-memory storage
!    // Can persist to JSON/binary files
!    Server.StaticDataSaveToFile('backup.json');
!  finally
!    Server.Free;
!  end;
!end;
{}
{\b Use cases:}
- Testing without database setup
- Simple @*CRUD@ + authentication
- Services with minimal ORM needs
{}
:  TRestServerRemoteDB (Proxy)
{}
Proxies ORM operations to another server:
{}
!uses
!  mormot.rest.core;
!
!var
!  RemoteClient: TRestHttpClient;
!  ProxyServer: TRestServerRemoteDB;
!begin
!  RemoteClient := TRestHttpClientWinHTTP.Create('dbserver', '8080', Model);
!  ProxyServer := TRestServerRemoteDB.Create(RemoteClient);
!  // ProxyServer forwards ORM to RemoteClient
!end;
{}
{\b Use cases:}
- DMZ deployment (public proxy → internal database)
- Service aggregation
- Load distribution
{}
:1103 Client Classes
{}
:  Class Hierarchy
{}
!TRest (abstract)
$└── TRestClientUri (abstract)
$    ├── TRestClientDB              → Direct SQLite3 access
$    ├── TRestClientLibraryRequest  → In-process DLL
$    └── TRestHttpClientGeneric     → HTTP transport
$        ├── TRestHttpClientWinSock    → Raw sockets
$        ├── TRestHttpClientWinHTTP    → WinHTTP API (recommended)
$        ├── TRestHttpClientWinINet    → WinINet API
$        ├── TRestHttpClientCurl       → libcurl (cross-platform)
$        └── TRestHttpClientWebsockets → WebSocket upgrade
{}
:  In-Process Client (TRestClientDB)
{}
Direct access without network overhead:
{}
!uses
!  mormot.rest.sqlite3;
!
!var
!  Client: TRestClientDB;
!begin
!  // Creates internal TRestServerDB
!  Client := TRestClientDB.Create(Model, nil, 'data.db3', TRestServerDB);
!  try
!    Client.Orm.Add(Customer, True);
!  finally
!    Client.Free;
!  end;
!end;
{}
:  HTTP Clients
{}
!uses
!  mormot.rest.http.client;
!
!var
!  Client: TRestHttpClientWinHTTP;
!begin
!  // Recommended HTTP client for Windows
!  Client := TRestHttpClientWinHTTP.Create('localhost', '8080', Model);
!  try
!    if Client.SetUser('user', 'password') then
!      Client.Orm.Retrieve(123, Customer);
!  finally
!    Client.Free;
!  end;
!end;
{}
{\b Client comparison:}
{}
|%9%27%9%13%42
|\b Class|Platform|HTTPS|Speed|Notes\b0
|{\f1\fs20 TRestHttpClientWinHTTP}|Windows|✓|Fast|{\b Recommended}
|{\f1\fs20 TRestHttpClientWinINet}|Windows|✓|Medium|IE proxy integration
|{\f1\fs20 TRestHttpClientWinSock}|Windows|✗|Fastest|No SSL
|{\f1\fs20 TRestHttpClientCurl}|Cross-platform|✓|Fast|Requires libcurl
|%
{}
:  WebSocket Client
{}
For bidirectional communication:
{}
!uses
!  mormot.rest.http.client;
!
!var
!  Client: TRestHttpClientWebsockets;
!begin
!  Client := TRestHttpClientWebsockets.Create('localhost', '8080', Model);
!  try
!    // Upgrade to WebSocket
!    Client.WebSocketsUpgrade('');
!
!    // Now supports server-to-client callbacks
!    Client.Services.Resolve(IMyCallback, Callback);
!  finally
!    Client.Free;
!  end;
!end;
{}
:1104 HTTP Server
{}
:  TRestHttpServer
{}
Wraps {\f1\fs20 TRestServer} instances for HTTP access:
{}
!uses
!  mormot.rest.http.server;
!
!var
!  HttpServer: TRestHttpServer;
!begin
!  HttpServer := TRestHttpServer.Create(
!    '8080',           // Port
!    [Server],         // TRestServer instances
!    '+',              // Domain ('+' = all)
!    useHttpAsync      // Server mode
!  );
!  try
!    HttpServer.AccessControlAllowOrigin := '*';  // CORS
!    // Server running...
!    ReadLn;
!  finally
!    HttpServer.Free;
!  end;
!end;
{}
:  Server Modes
{}
|%8%52%40
|\b Mode|Description|Use Case\b0
|{\f1\fs20 useHttpApi}|Windows HTTP.SYS (kernel-mode)|Windows production
|{\f1\fs20 useHttpSocket}|Thread-per-connection|Behind reverse proxy
|{\f1\fs20 useHttpAsync}|Event-driven async|{\b Best scaling}
|{\f1\fs20 useBidirSocket}|WebSockets + threads|Callbacks (small scale)
|{\f1\fs20 useBidirAsync}|WebSockets + async|{\b Callbacks at scale}
|%
{}
!// Production server (async, best performance)
!HttpServer := TRestHttpServer.Create('8080', [Server], '+', useHttpAsync);
!
!// WebSocket support
!HttpServer := TRestHttpServer.Create('8080', [Server], '+', useBidirAsync);
{}
:  HTTPS / SSL
{}
!// Enable TLS (Port, Servers, Domain, Use, ThreadPoolCount, Security)
!HttpServer := TRestHttpServer.Create('443', [Server], '+',
!  useHttpAsync, 32, secTLS);
!
!// Self-signed certificate (development only)
!HttpServer := TRestHttpServer.Create('443', [Server], '+',
!  useHttpAsync, 32, secTLSSelfSigned);
{}
For http.sys, certificates must be registered:
$# Register certificate (Windows)
$netsh http add sslcert ipport=0.0.0.0:443 certhash=<thumbprint> appid={<guid>}
{}
:  Multiple REST Servers
{}
One HTTP server can host multiple REST servers:
{}
!var
!  ApiServer, AdminServer: TRestServerDB;
!begin
!  ApiServer := TRestServerDB.Create(ApiModel, 'api.db3');
!  ApiServer.Model.Root := 'api';
!
!  AdminServer := TRestServerDB.Create(AdminModel, 'admin.db3');
!  AdminServer.Model.Root := 'admin';
!
!  HttpServer := TRestHttpServer.Create('8080',
!    [ApiServer, AdminServer], '+', useHttpAsync);
!
!  // Access via:
!  // http://localhost:8080/api/...
!  // http://localhost:8080/admin/...
!end;
{}
:1105 Windows http.sys Server
{}
:  Why http.sys?
{}
Windows kernel-mode HTTP server provides:
{}
- {\b Kernel-mode queuing}: Lower context switching overhead
- {\b Stability}: Worker process failures don't drop requests
- {\b Performance}: Direct kernel-to-process routing
- {\b Embedded SSL}: Kernel-level @*HTTPS@ handling
- {\b URL sharing}: Multiple apps on same port
{}
:  URI Authorization
{}
http.sys requires URI registration (Administrator rights):
{}
!// Option 1: Auto-register (run as Admin once)
!HttpServer := TRestHttpServer.Create('8080', [Server], '+',
!  useHttpApiRegisteringURI);
!
!// Option 2: Manual registration
!THttpApiServer.AddUrlAuthorize('api', '8080', False, '+');
{}
{\b Manual registration via netsh:}
$# List registered URLs
$netsh http show urlacl
$
$# Add URL reservation
$netsh http add urlacl url=http://+:8080/api/ user=Everyone
$
$# Delete URL reservation
$netsh http delete urlacl url=http://+:8080/api/
{}
:  Firewall Configuration
{}
$# Open port in Windows Firewall
$netsh advfirewall firewall add rule name="mORMot Server" ^
$  dir=in action=allow protocol=TCP localport=8080
{}
:1106 Thread Safety
{}
:  Client Thread Safety
{}
{\f1\fs20 TRestClientUri} classes are thread-safe by design:
{}
!// Safe: URI() method is internally locked
!procedure TWorkerThread.Execute;
!begin
!  GlobalClient.Orm.Retrieve(ID, Record);  // Thread-safe
!end;
{}
:  Server Execution Modes
{}
!type
!  TRestServerAcquireMode = (
!    amUnlocked,          // No locking (read-only operations)
!    amLocked,            // Mutex protection (default for writes)
!    amBackgroundThread,  // Queue to background thread
!    amMainThread         // Queue to main thread (GUI)
!  );
!
!// Configure execution modes
!Server.AcquireWriteMode := amLocked;
!Server.AcquireExecutionMode[execSoaByInterface] := amLocked;
{}
:  Execution Contexts
{}
|%16%27%57
|\b Context|Default Mode|Description\b0
|{\f1\fs20 execOrmGet}|{\f1\fs20 amUnlocked}|ORM read operations
|{\f1\fs20 execOrmWrite}|{\f1\fs20 amLocked}|ORM write operations
|{\f1\fs20 execSoaByMethod}|{\f1\fs20 amUnlocked}|Method-based services
|{\f1\fs20 execSoaByInterface}|{\f1\fs20 amLocked}|Interface-based services
|%
{}
:1107 Connection Patterns
{}
:  Single Server, Multiple Protocols
{}
!var
!  Server: TRestServerDB;
!  HttpServer: TRestHttpServer;
!begin
!  Server := TRestServerDB.Create(Model, 'data.db3');
!
!  // HTTP access
!  HttpServer := TRestHttpServer.Create('8080', [Server]);
!
!  // Same server accessible via HTTP and in-process
!end;
{}
:  Load Balancer Setup
{}
$                    ┌─────────────────┐
$                    │  Load Balancer  │
$                    │   (nginx/HAProxy)│
$                    └────────┬────────┘
$           ┌─────────────────┼─────────────────┐
$           ▼                 ▼                 ▼
$    ┌─────────────┐   ┌─────────────┐   ┌─────────────┐
$    │ mORMot Srv 1│   │ mORMot Srv 2│   │ mORMot Srv 3│
$    └─────────────┘   └─────────────┘   └─────────────┘
$           │                 │                 │
$           └─────────────────┼─────────────────┘
$                             ▼
$                    ┌─────────────────┐
$                    │   Database      │
$                    │  (PostgreSQL)   │
$                    └─────────────────┘
{}
:  DMZ Architecture
{}
!       Internet
$           │
$   ┌───────┴───────┐
$   │     DMZ       │  TRestServerRemoteDB (services only)
$   │  ┌─────────┐  │
$   │  │ Proxy   │  │
$   │  │ Server  │  │
$   │  └────┬────┘  │
$   └───────┼───────┘
$           │ (Internal network)
$   ┌───────┴───────┐
$   │   Internal    │  TRestServerDB (full ORM + services)
$   │  ┌─────────┐  │
$   │  │  Main   │  │
$   │  │ Server  │  │
$   │  └─────────┘  │
$   └───────────────┘
{}
:1108 Proper Shutdown
{}
:  Shutdown Order
{}
!// CORRECT shutdown order
!FreeAndNil(HttpServer);  // 1. Stop accepting connections
!FreeAndNil(Server);      // 2. Free REST server
!FreeAndNil(Model);       // 3. Free model last
!
!// WRONG - will cause access violations
!FreeAndNil(Model);       // Model freed while Server uses it!
!FreeAndNil(Server);
!FreeAndNil(HttpServer);
{}
:  Graceful Shutdown
{}
!procedure GracefulShutdown;
!begin
!  // Signal shutdown
!  HttpServer.Shutdown;
!
!  // Wait for pending requests (with timeout)
!  Sleep(1000);
!
!  // Free resources
!  FreeAndNil(HttpServer);
!  FreeAndNil(Server);
!  FreeAndNil(Model);
!end;
{}
:1109 Migration from mORMot 1
{}
:  Class Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 TSQLRest}|{\f1\fs20 TRest}
|{\f1\fs20 TSQLRestServer}|{\f1\fs20 TRestServer}
|{\f1\fs20 TSQLRestServerDB}|{\f1\fs20 TRestServerDB}
|{\f1\fs20 TSQLRestServerFullMemory}|{\f1\fs20 TRestServerFullMemory}
|{\f1\fs20 TSQLRestClient}|{\f1\fs20 TRestClient}
|{\f1\fs20 TSQLRestClientDB}|{\f1\fs20 TRestClientDB}
|{\f1\fs20 TSQLHttpServer}|{\f1\fs20 TRestHttpServer}
|{\f1\fs20 TSQLHttpClient*}|{\f1\fs20 TRestHttpClient*}
|%
{}
:  Unit Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 mORMot.pas}|@!src\rest\mormot.rest.core.pas@ + @!src\orm\mormot.orm.core.pas@
|{\f1\fs20 mORMotSQLite3.pas}|{\f1\fs20 mormot.rest.sqlite3}
|{\f1\fs20 mORMotHttpServer.pas}|@!src\rest\mormot.rest.http.server.pas@
|{\f1\fs20 mORMotHttpClient.pas}|@!src\rest\mormot.rest.http.client.pas@
|%
{}
:  API Changes
{}
!// mORMot 1: Direct ORM access on TRest
!Server.Add(Customer, True);
!
!// mORMot 2: Via Orm interface
!Server.Orm.Add(Customer, True);
{}
{\i Next Chapter: Client-Server ORM Operations}
{}