; Converted from Markdown - Chapter 12
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:12Client-Server ORM Operations
{}
{\i Remote Data Access}
{}
This chapter covers how to perform @*ORM@ operations over the network, including remote @*CRUD@, caching, batch operations, and synchronization.
{}
:1201 Remote ORM Basics
{}
:  Transparent Remote Access
{}
The ORM works identically whether local or remote:
{}
!// Local (in-process)
!Client := TRestClientDB.Create(Model, nil, 'data.db3', TRestServerDB);
!
!// Remote (HTTP)
!Client := TRestHttpClientWinHTTP.Create('server', '8080', Model);
!
!// Same ORM API for both
!Client.Orm.Add(Customer, True);
!Client.Orm.Retrieve(123, Customer);
!Client.Orm.Update(Customer);
!Client.Orm.Delete(TOrmCustomer, 123);
{}
:  Authentication Required
{}
Remote ORM operations require authentication:
{}
!var
!  Client: TRestHttpClient;
!begin
!  Client := TRestHttpClientWinHTTP.Create('localhost', '8080', Model);
!  try
!    // Must authenticate first
!    if not Client.SetUser('username', 'password') then
!      raise Exception.Create('Authentication failed');
!
!    // Now ORM operations work
!    Client.Orm.Add(Customer, True);
!  finally
!    Client.Free;
!  end;
!end;
{}
:1202 CRUD Operations Over Network
{}
:  Create (Add)
{}
!var
!  Customer: TOrmCustomer;
!  ID: TID;
!begin
!  Customer := TOrmCustomer.Create;
!  try
!    Customer.Name := 'ACME Corp';
!    Customer.Email := 'contact@acme.com';
!
!    // Remote add - returns new ID
!    ID := Client.Orm.Add(Customer, True);
!
!    if ID > 0 then
!      WriteLn('Created customer #', ID)
!    else
!      WriteLn('Failed to create customer');
!  finally
!    Customer.Free;
!  end;
!end;
{}
:  Read (Retrieve)
{}
!var
!  Customer: TOrmCustomer;
!begin
!  // By ID
!  Customer := TOrmCustomer.Create(Client.Orm, 123);
!  try
!    WriteLn(Customer.Name);
!  finally
!    Customer.Free;
!  end;
!
!  // Alternative: Retrieve into existing instance
!  Customer := TOrmCustomer.Create;
!  try
!    if Client.Orm.Retrieve(123, Customer) then
!      WriteLn(Customer.Name);
!  finally
!    Customer.Free;
!  end;
!
!  // By unique field
!  Customer := TOrmCustomer.Create;
!  try
!    if Client.Orm.Retrieve('Email = ?', [], ['contact@acme.com'], Customer) then
!      WriteLn(Customer.Name);
!  finally
!    Customer.Free;
!  end;
!end;
{}
:  Update
{}
!var
!  Customer: TOrmCustomer;
!begin
!  Customer := TOrmCustomer.Create(Client.Orm, 123);
!  try
!    Customer.Email := 'new@acme.com';
!
!    if Client.Orm.Update(Customer) then
!      WriteLn('Updated successfully');
!  finally
!    Customer.Free;
!  end;
!
!  // Update specific fields only
!  Customer := TOrmCustomer.Create;
!  try
!    Customer.ID := 123;
!    Customer.Email := 'updated@acme.com';
!
!    // Only update Email field
!    Client.Orm.Update(Customer, 'Email');
!  finally
!    Customer.Free;
!  end;
!end;
{}
:  Delete
{}
!// By ID
!Client.Orm.Delete(TOrmCustomer, 123);
!
!// By condition
!Client.Orm.Delete(TOrmCustomer, 'Status = ?', [Ord(csInactive)]);
{}
:1203 Query Operations
{}
:  FillPrepare Pattern
{}
Efficient iteration over remote results:
{}
!var
!  Customer: TOrmCustomer;
!begin
!  Customer := TOrmCustomer.CreateAndFillPrepare(Client.Orm,
!    'Country = ?', ['USA']);
!  try
!    while Customer.FillOne do
!      WriteLn(Customer.Name, ': ', Customer.Email);
!  finally
!    Customer.Free;
!  end;
!end;
{}
:  Select Specific Fields
{}
Reduce network traffic by requesting only needed fields:
{}
!// Only transfer Name and Email fields
!Customer := TOrmCustomer.CreateAndFillPrepare(Client.Orm,
!  'Country = ?', ['USA'],
!  'Name,Email');  // Fields to retrieve
{}
:  RetrieveList
{}
Get results as object list:
{}
!var
!  List: TObjectList<TOrmCustomer>;
!  Customer: TOrmCustomer;
!begin
!  List := Client.Orm.RetrieveList<TOrmCustomer>(
!    'Country = ?', ['USA']);
!  try
!    for Customer in List do
!      WriteLn(Customer.Name);
!  finally
!    List.Free;
!  end;
!end;
{}
:  Direct JSON Results
{}
!var
!  Json: RawUtf8;
!begin
!  // Get results directly as JSON array
!  Json := Client.Orm.RetrieveListJson(TOrmCustomer,
!    'Country = ?', ['USA'], 'Name,Email');
!  // Result: [{"Name":"ACME","Email":"..."},...]
!end;
{}
:1204 Client-Side Caching
{}
:  Enable Table Caching
{}
!// Cache specific tables on client
!Client.Cache.SetCache(TOrmCustomer);   // Cache all customers
!Client.Cache.SetCache(TOrmProduct);    // Cache all products
!
!// With timeout (milliseconds)
!Client.Cache.SetTimeOut(TOrmCustomer, 60000);  // 1 minute cache
{}
:  How Caching Works
{}
$┌─────────────────────────────────────────────────────────────┐
$│  Client.Orm.Retrieve(123, Customer)                         │
$└─────────────────────────────────────────────────────────────┘
$                            │
$                            ▼
$                  ┌─────────────────┐
$                  │ Check Cache     │
$                  └────────┬────────┘
$                           │
$            ┌──────────────┴──────────────┐
$            │                             │
$            ▼                             ▼
$    ┌───────────────┐            ┌───────────────┐
$    │ Cache Hit     │            │ Cache Miss    │
$    │ Return cached │            │ Fetch from    │
$    │ data          │            │ server        │
$    └───────────────┘            └───────┬───────┘
$                                         │
$                                         ▼
$                                 ┌───────────────┐
$                                 │ Update cache  │
$                                 │ Return data   │
$                                 └───────────────┘
{}
:  Cache Invalidation
{}
!// Clear specific record from cache
!Client.Cache.NotifyDeletion(TOrmCustomer, 123);
!
!// Reset table cache (re-enable caching, which clears existing entries)
!Client.Cache.SetCache(TOrmCustomer);
!
!// Clear all caches and reset settings
!Client.Cache.Clear;
{}
:  Server-Side Cache Notification
{}
The server can track changes via {\f1\fs20 TRestOrmServer.OnUpdateEvent}:
{}
!type
!  TMyServer = class
!    function HandleUpdate(Sender: TRestServer; Event: TOrmEvent;
!      aTable: TOrmClass; const aID: TID;
!      const aSentData: RawUtf8): boolean;
!  end;
!
!// Server-side: Enable change notifications
!// OnUpdateEvent requires a method of object (not anonymous procedure)
!(Server.OrmInstance as TRestOrmServer).OnUpdateEvent := MyServer.HandleUpdate;
{}
:1205 Batch Operations
{}
:  TRestBatch for Bulk Operations
{}
Dramatically improve performance for bulk operations:
{}
!uses
!  mormot.orm.core;
!
!var
!  Batch: TRestBatch;
!  Customer: TOrmCustomer;
!  Results: TIDDynArray;
!  i: Integer;
!begin
!  Batch := TRestBatch.Create(Client.Orm, TOrmCustomer, 1000);
!  try
!    for i := 1 to 10000 do
!    begin
!      Customer := TOrmCustomer.Create;
!      Customer.Name := FormatUtf8('Customer %', [i]);
!      Customer.Email := FormatUtf8('cust%@example.com', [i]);
!      Batch.Add(Customer, True);  // Batch owns Customer
!    end;
!
!    // Single network roundtrip for all 10000 records
!    if Client.Orm.BatchSend(Batch, Results) = HTTP_SUCCESS then
!      WriteLn('Inserted ', Length(Results), ' records');
!  finally
!    Batch.Free;
!  end;
!end;
{}
:  Performance Comparison
{}
|%47%19%13%21
|\b Operation|Individual|Batch|Improvement\b0
|10,000 inserts (local)|10 sec|0.1 sec|100x
|10,000 inserts (network)|100 sec|1 sec|100x
|10,000 updates|15 sec|0.2 sec|75x
|%
{}
:  Batch Updates and Deletes
{}
!var
!  Batch: TRestBatch;
!  Customer: TOrmCustomer;
!begin
!  Batch := TRestBatch.Create(Client.Orm, TOrmCustomer);
!  try
!    // Mix operations in single batch
!    Customer := TOrmCustomer.Create;
!    Customer.Name := 'New Customer';
!    Batch.Add(Customer, True);
!
!    Customer := TOrmCustomer.Create(Client.Orm, 123);
!    Customer.Status := csActive;
!    Batch.Update(Customer);
!
!    Batch.Delete(TOrmCustomer, 456);
!
!    Client.Orm.BatchSend(Batch);
!  finally
!    Batch.Free;
!  end;
!end;
{}
:  Automatic Batching
{}
For transparent batching:
{}
!var
!  Results: TIDDynArray;
!begin
!  // Start automatic batching
!  Client.BatchStart(TOrmCustomer, 1000);
!  try
!    for i := 1 to 10000 do
!    begin
!      Customer := TOrmCustomer.Create;
!      Customer.Name := FormatUtf8('Customer %', [i]);
!      Client.Orm.Add(Customer, True);  // Automatically batched
!      Customer.Free;
!    end;
!  finally
!    Client.BatchSend(Results);  // Send remaining batch
!  end;
!end;
{}
:1206 BLOB Handling
{}
:  BLOB Fields
{}
@*BLOB@s are not included in normal record transfers:
{}
!type
!  TOrmDocument = class(TOrm)
!  private
!    fName: RawUtf8;
!    fContent: RawBlob;  // Not transferred with other fields
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Content: RawBlob read fContent write fContent;
!  end;
{}
:  Upload BLOB
{}
!var
!  Doc: TOrmDocument;
!  Data: RawBlob;
!begin
!  Doc := TOrmDocument.Create;
!  try
!    Doc.Name := 'report.pdf';
!    Client.Orm.Add(Doc, True);
!
!    // Upload BLOB separately
!    Data := StringFromFile('report.pdf');
!    Client.Orm.UpdateBlob(TOrmDocument, Doc.ID, 'Content', Data);
!  finally
!    Doc.Free;
!  end;
!end;
{}
:  Download BLOB
{}
!var
!  Data: RawBlob;
!begin
!  if Client.Orm.RetrieveBlob(TOrmDocument, DocID, 'Content', Data) then
!    FileFromString(Data, 'downloaded.pdf');
!end;
{}
:  Streaming BLOBs
{}
For large files, use streaming:
{}
!var
!  Stream: TStream;
!begin
!  Stream := TFileStream.Create('large_file.zip', fmCreate);
!  try
!    Client.Orm.RetrieveBlobStream(TOrmDocument, DocID, 'Content', Stream);
!  finally
!    Stream.Free;
!  end;
!end;
{}
:1207 Locking and Concurrency
{}
:  Optimistic Locking
{}
Default behavior - last write wins:
{}
!// Two clients modify same record
!Client1.Orm.Retrieve(123, Customer1);
!Client2.Orm.Retrieve(123, Customer2);
!
!Customer1.Email := 'client1@example.com';
!Customer2.Email := 'client2@example.com';
!
!Client1.Orm.Update(Customer1);  // Succeeds
!Client2.Orm.Update(Customer2);  // Overwrites Client1's change
{}
:  TRecordVersion for Change Tracking
{}
!type
!  TOrmCustomer = class(TOrm)
!  private
!    fName: RawUtf8;
!    fVersion: TRecordVersion;  // Auto-incremented on changes
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Version: TRecordVersion read fVersion write fVersion;
!  end;
!
!// Server automatically increments Version on each update
{}
:  Conflict Detection
{}
!var
!  Customer: TOrmCustomer;
!  OriginalVersion: TRecordVersion;
!  CurrentVersion: Int64;
!begin
!  Customer := TOrmCustomer.Create(Client.Orm, 123);
!  try
!    OriginalVersion := Customer.Version;
!
!    // Make changes
!    Customer.Name := 'Updated Name';
!
!    // Re-fetch to check version using OneFieldValueInt64
!!    // Note: takes WhereClause as RawUtf8, not array of const
!    CurrentVersion := Client.Orm.OneFieldValueInt64(TOrmCustomer,
!      'Version', FormatUtf8('ID = %', [Customer.ID]));
!    if CurrentVersion <> Int64(OriginalVersion) then
!      raise Exception.Create('Record modified by another user');
!
!    Client.Orm.Update(Customer);
!  finally
!    Customer.Free;
!  end;
!end;
{}
:1208 Synchronization
{}
:  Master-Slave Replication
{}
!// On slave: Track changes from master
!var
!  MasterClient: TRestHttpClient;
!  SlaveServer: TRestServerDB;
!begin
!  MasterClient := TRestHttpClientWinHTTP.Create('master', '8080', Model);
!  SlaveServer := TRestServerDB.Create(Model, 'slave.db3');
!
!  // Sync tables
!  SlaveServer.RecordVersionSynchronizeSlave(
!    TOrmCustomer, MasterClient.Orm, 1000);  // Check every second
!end;
{}
:  Change Tracking
{}
mORMot2 provides {\f1\fs20 TOrmHistory} in @!src\orm\mormot.orm.core.pas@ for tracking record changes:
{}
!// TOrmHistory is defined in mormot.orm.core with fields for:
!// - ModifiedRecord: TID (reference to modified record)
!// - Event: TOrmHistoryEvent
!// - SentDataJson: RawBlob
!// - Timestamp: TModTime
!
!// Server tracks all changes via TRestOrmServer
!var
!  OrmServer: TRestOrmServer;
!begin
!  OrmServer := Server.OrmInstance as TRestOrmServer;
!  OrmServer.TrackChanges([TOrmCustomer, TOrmOrder]);
!end;
{}
:1209 Error Handling
{}
:  Check Return Values
{}
!var
!  ID: TID;
!begin
!  ID := Client.Orm.Add(Customer, True);
!  if ID = 0 then
!  begin
!    // Check last error
!    WriteLn('Error: ', Client.LastErrorMessage);
!    WriteLn('Code: ', Client.LastErrorCode);
!  end;
!end;
{}
:  HTTP Status Codes
{}
|%12%38%50
|\b Code|Meaning|mORMot Constant\b0
|200|Success|{\f1\fs20 @*HTTP@_SUCCESS}
|201|Created|{\f1\fs20 HTTP_CREATED}
|400|Bad Request|{\f1\fs20 HTTP_BADREQUEST}
|401|Unauthorized|{\f1\fs20 HTTP_UNAUTHORIZED}
|403|Forbidden|{\f1\fs20 HTTP_FORBIDDEN}
|404|Not Found|{\f1\fs20 HTTP_NOTFOUND}
|500|Server Error|{\f1\fs20 HTTP_SERVERERROR}
|%
{}
:  Connection Resilience
{}
!// Auto-reconnect on connection loss
!Client.RetryOnceOnTimeout := True;
!
!// Custom retry logic
!for Attempt := 1 to 3 do
!begin
!  if Client.Orm.Retrieve(ID, Customer) then
!    Break;
!  if Attempt = 3 then
!    raise Exception.Create('Failed after 3 attempts');
!  Sleep(1000 * Attempt);  // Exponential backoff
!end;
{}
:1210 Migration from mORMot 1
{}
:  ORM Access Pattern
{}
!// mORMot 1: Direct on TRest
!Client.Add(Customer, True);
!Client.Retrieve(123, Customer);
!
!// mORMot 2: Via Orm interface
!Client.Orm.Add(Customer, True);
!Client.Orm.Retrieve(123, Customer);
{}
:  Batch Changes
{}
!// mORMot 1
!Client.BatchStart(TOrmCustomer);
!Client.BatchAdd(Customer);
!Client.BatchSend;
!
!// mORMot 2
!Batch := TRestBatch.Create(Client.Orm, TOrmCustomer);
!Batch.Add(Customer, True);
!Client.Orm.BatchSend(Batch);
{}
{\i Next Chapter: Server-Side ORM Processing}
{}