; Converted from Markdown - Chapter 13
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:13Server-Side ORM Processing
{}
{\i Behind the Scenes}
{}
This chapter explores how the server processes @*ORM@ requests, including URI routing, SQL generation, virtual tables, and server-side customization.
{}
:1301 Request Processing Flow
{}
:  URI to SQL Pipeline
{}
$┌─────────────────────────────────────────────────────────────────┐
$│  Client Request: GET /api/Customer/123                          │
$└─────────────────────────────────────────────────────────────────┘
$                              │
$                              ▼
$┌─────────────────────────────────────────────────────────────────┐
$│  1. HTTP Server receives request                                │
$│     TRestHttpServer.Request()                                   │
$└─────────────────────────────────────────────────────────────────┘
$                              │
$                              ▼
$┌─────────────────────────────────────────────────────────────────┐
$│  2. Router matches URI pattern                                  │
$│     TRestRouter → /api/Customer/123 → rnTableID                 │
$└─────────────────────────────────────────────────────────────────┘
$                              │
$                              ▼
$┌─────────────────────────────────────────────────────────────────┐
$│  3. Authentication check                                        │
$│     TRestServer.SessionGetUser()                                │
$└─────────────────────────────────────────────────────────────────┘
$                              │
$                              ▼
$┌─────────────────────────────────────────────────────────────────┐
$│  4. ORM processes request                                       │
$│     IRestOrm.Retrieve() → SQL: SELECT * FROM Customer WHERE ID=1│
$└─────────────────────────────────────────────────────────────────┘
$                              │
$                              ▼
$┌─────────────────────────────────────────────────────────────────┐
$│  5. Response as JSON                                            │
$│     {"ID":123,"Name":"ACME","Email":"..."}                      │
$└─────────────────────────────────────────────────────────────────┘
{}
:  Router Node Types
{}
|%10%27%63
|\b Node|URI Pattern|HTTP Methods\b0
|{\f1\fs20 rnTable}|{\f1\fs20 /root/TableName}|GET (list), POST (create)
|{\f1\fs20 rnTableID}|{\f1\fs20 /root/TableName/<id>}|GET, PUT, DELETE
|{\f1\fs20 rnTableIDBlob}|{\f1\fs20 /root/TableName/<id>/BlobField}|GET, PUT
|{\f1\fs20 rnTableMethod}|{\f1\fs20 /root/TableName/<method>}|GET, POST
|{\f1\fs20 rnMethod}|{\f1\fs20 /root/<method>}|GET, POST
|{\f1\fs20 rnInterface}|{\f1\fs20 /root/Interface.Method}|POST
|%
{}
:1302 SQL Generation
{}
:  Automatic SQL from URI
{}
The ORM translates @*REST@ requests to SQL:
{}
!GET /api/Customer
!→ SELECT ID, Name, Email, ... FROM Customer
!
!GET /api/Customer/123
!→ SELECT ID, Name, Email, ... FROM Customer WHERE ID=123
!
!GET /api/Customer?where=Country%3D%27USA%27
!→ SELECT ID, Name, Email, ... FROM Customer WHERE Country='USA'
!
!POST /api/Customer (body: {"Name":"ACME"})
!→ INSERT INTO Customer (Name) VALUES ('ACME')
!
!PUT /api/Customer/123 (body: {"Name":"Updated"})
!→ UPDATE Customer SET Name='Updated' WHERE ID=123
!
!DELETE /api/Customer/123
!→ DELETE FROM Customer WHERE ID=123
{}
:  Query Parameters
{}
|%28%51%21
|\b Parameter|Description|Example\b0
|{\f1\fs20 where}|WHERE clause|{\f1\fs20 ?where=Country='USA'}
|{\f1\fs20 select}|Fields to return|{\f1\fs20 ?select=Name,Email}
|{\f1\fs20 limit}|Max results|{\f1\fs20 ?limit=100}
|{\f1\fs20 offset}|Skip results|{\f1\fs20 ?offset=50}
|{\f1\fs20 order}|ORDER BY|{\f1\fs20 ?order=Name}
|%
{}
:  Inlined JSON Parameters
{}
Parameters can be embedded in WHERE clause:
{}
!// Client sends
!'Name = :("John"):AND Age > :(30):'
!
!// Server extracts and binds
!SQL: 'SELECT ... WHERE Name = ? AND Age > ?'
!Params: ['John', 30]
{}
:1303 Virtual Tables
{}
:  Storage Backends
{}
The ORM can mix multiple storage backends:
{}
!Model := TOrmModel.Create([
!  TOrmUser,      // Internal SQLite3
!  TOrmProduct,   // External PostgreSQL
!  TOrmLog,       // MongoDB
!  TOrmCache      // In-memory
!]);
!
!// Map to different backends
!OrmMapExternal(Model, TOrmProduct, PostgresProps);
!OrmMapMongoDB(Model, TOrmLog, MongoClient.Database['logs']);
!Model.Props[TOrmCache].SetStorage(TRestStorageInMemory);
{}
:  How Virtual Tables Work
{}
$┌─────────────────────────────────────────────────────────────────┐
$│                      SQLite3 Core                     │
$│  SELECT * FROM Product, User WHERE Product.UserID = Us│
$└─────────────────────────────────────────────────────────────────┘
$        │                                    │
$        │ Virtual Table                      │ Native Table
$        ▼                                    ▼
$┌───────────────────┐               ┌───────────────────┐
$│   PostgreSQL      │               │   SQLite3 File    │
$│   (Product)       │               │   (User)          │
$└───────────────────┘               └───────────────────┘
{}
:  Cross-Database JOINs
{}
!// This works even with mixed backends!
!Server.Orm.ExecuteList([TOrmProduct, TOrmUser],
!  'SELECT Product.Name, User.Email ' +
!  'FROM Product, User ' +
!  'WHERE Product.UserID = User.ID');
{}
:1304 Server-Side Events
{}
:  OnBefore* Events
{}
Execute before ORM operations:
{}
!type
!  TMyServer = class(TRestServerDB)
!  protected
!    function OnBeforeAdd(Table: TOrmClass; const Rec: TOrm): Boolean; override;
!  end;
!
!function TMyServer.OnBeforeAdd(Table: TOrmClass; const Rec: TOrm): Boolean;
!begin
!  // Validate before insert
!  if Table = TOrmCustomer then
!    if TOrmCustomer(Rec).Email = '' then
!    begin
!      Result := False;  // Reject insert
!      Exit;
!    end;
!  Result := True;  // Allow insert
!end;
{}
:  OnAfter* Events
{}
Execute after ORM operations:
{}
!procedure TMyServer.OnAfterDelete(Table: TOrmClass; const aID: TID);
!begin
!  // Audit trail
!  LogEvent(Format('Deleted %s #%d', [Table.ClassName, aID]));
!
!  // Cascade operations
!  if Table = TOrmCustomer then
!    Orm.Delete(TOrmOrder, 'CustomerID = ?', [aID]);
!end;
{}
:  Event Signatures
{}
|%17%32%51
|\b Event|Signature|Return\b0
|{\f1\fs20 OnBeforeAdd}|{\f1\fs20 (Table, Rec): Boolean}|False = reject
|{\f1\fs20 OnAfterAdd}|{\f1\fs20 (Table, aID)}|-
|{\f1\fs20 OnBeforeUpdate}|{\f1\fs20 (Table, Rec): Boolean}|False = reject
|{\f1\fs20 OnAfterUpdate}|{\f1\fs20 (Table, Rec)}|-
|{\f1\fs20 OnBeforeDelete}|{\f1\fs20 (Table, aID): Boolean}|False = reject
|{\f1\fs20 OnAfterDelete}|{\f1\fs20 (Table, aID)}|-
|%
{}
:  TOrm Event Methods
{}
Override in {\f1\fs20 @**TOrm@} class for record-level events:
{}
!type
!  TOrmCustomer = class(TOrm)
!  protected
!    procedure ComputeFieldsBeforeWrite(const aRest: IRestOrm;
!      aOccasion: TOrmEvent; aServerTimeStamp: TTimeLog = 0); override;
!  end;
!
!procedure TOrmCustomer.ComputeFieldsBeforeWrite(const aRest: IRestOrm;
!  aOccasion: TOrmEvent; aServerTimeStamp: TTimeLog);
!begin
!  inherited;
!  // Auto-compute fields before save
!  if aOccasion in [oeAdd, oeUpdate] then
!    fSearchText := LowerCase(fName + ' ' + fEmail);
!end;
{}
:1305 Server-Side Filtering
{}
:  Access Control per Table
{}
!// Restrict access to specific tables
!Server.OnCanExecute := function(Sender: TRest; Context: TRestServerUriContext;
!  Table: TOrmClass; const TableID: TID): Boolean
!begin
!  // Only admins can access TOrmSettings
!  if Table = TOrmSettings then
!    Result := Context.Session.User.GroupRights.HasRight(arAdmin)
!  else
!    Result := True;
!end;
{}
:  Field-Level Security
{}
!type
!  TOrmUser = class(TOrm)
!  private
!    fName: RawUtf8;
!    fPassword: RawUtf8;
!!    fInternalNote: RawUtf8;  // Never expose to clients
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Password: RawUtf8 read fPassword write fPassword;
!!    property InternalNote: RawUtf8 read fInternalNote write fInternalNote
!      stored False;  // Not transmitted over REST
!  end;
{}
:  Dynamic WHERE Injection
{}
Force additional conditions on all queries:
{}
!// All Customer queries filtered by tenant
!Server.OnBeforeUriExecute := procedure(Sender: TRest; var SqlWhere: RawUtf8;
!  Table: TOrmClass)
!begin
!  if Table = TOrmCustomer then
!  begin
!    if SqlWhere <> '' then
!      SqlWhere := SqlWhere + ' AND ';
!    SqlWhere := SqlWhere + FormatUtf8('TenantID = %', [CurrentTenantID]);
!  end;
!end;
{}
:1306 Server-Side Caching
{}
:  Enable Table Caching
{}
!// Cache entire table in memory
!Server.Cache.SetCache(TOrmProduct);
!
!// Cache with timeout
!Server.Cache.SetTimeOut(TOrmProduct, 300000);  // 5 minutes
!
!// Cache frequently accessed records
!Server.Cache.SetCache(TOrmSettings, True);  // Force all records cached
{}
:  Cache Statistics
{}
!WriteLn('Cache hits: ', Server.Cache.CacheHits);
!WriteLn('Cache misses: ', Server.Cache.CacheMisses);
!WriteLn('Hit ratio: ', Server.Cache.CacheHits /
!  (Server.Cache.CacheHits + Server.Cache.CacheMisses) * 100:0:1, '%');
{}
:  Manual Cache Invalidation
{}
!// Clear specific record
!Server.Cache.NotifyDeletion(TOrmProduct, ProductID);
!
!// Clear entire table
!Server.Cache.Clear(TOrmProduct);
!
!// Clear all caches
!Server.Cache.Clear;
{}
:1307 Write Modes
{}
:  Direct vs Batch Mode
{}
!// Direct mode (default): Each write goes to database immediately
!Server.Orm.Add(Customer, True);  // INSERT executed now
!
!// Batch mode on server: Use TRestBatch directly
!var
!  Batch: TRestBatch;
!  Results: TIDDynArray;
!begin
!  Batch := TRestBatch.Create(Server.Orm, TOrmCustomer);
!  try
!    Batch.Add(Customer1, True);  // Queued
!    Batch.Add(Customer2, True);  // Queued
!    Server.Orm.BatchSend(Batch, Results);  // All INSERTs now
!  finally
!    Batch.Free;
!  end;
!end;
{}
{\b Note}: {\f1\fs20 BatchStart}/{\f1\fs20 BatchSend} methods without parameters are on {\f1\fs20 TRestClientUri}. Server-side code should use {\f1\fs20 TRestBatch} directly.
{}
:  Transaction Handling
{}
!const
!  SESSION_ID = 1;  // Current session ID
!begin
!  // Automatic transactions per batch
!  Server.TransactionBegin(TOrmCustomer, SESSION_ID);
!  try
!    Server.Orm.Add(Customer1, True);
!    Server.Orm.Add(Customer2, True);
!    Server.Commit(SESSION_ID, True);  // RaiseException=True
!  except
!    Server.RollBack(SESSION_ID);
!    raise;
!  end;
!end;
{}
{\b Note}: Transaction methods require a {\f1\fs20 SessionID} parameter on the server.
{}
:  Write Acknowledgment
{}
!// Control write confirmation
!Server.AcquireWriteMode := amLocked;       // Wait for write completion
!Server.AcquireWriteMode := amUnlocked;     // Fire and forget (faster)
!Server.AcquireWriteMode := amBackgroundThread;  // Queue to background
{}
:1308 Static Storage
{}
:  In-Memory Tables
{}
!uses
!  mormot.orm.storage;
!
!// Register before server creation
!Model.Props[TOrmCache].SetStorage(TRestStorageInMemory);
!
!// Or add after server creation
!Storage := TRestStorageInMemory.Create(TOrmCache, Server);
!Server.StaticDataAdd(Storage);
{}
:  Persistence Options
{}
!// JSON persistence
!Storage := TRestStorageInMemory.Create(TOrmCache, Server);
!Storage.FileName := 'cache.json';
!
!// Binary persistence (faster, smaller)
!Storage.BinaryFile := True;
!Storage.FileName := 'cache.data';
!
!// Manual save/load
!Storage.SaveToFile('backup.json');
!Storage.LoadFromFile('backup.json');
{}
:  Static vs Virtual
{}
|%23%28%49
|\b Feature|Static|Virtual\b0
|SQL JOINs|No|Yes
|Speed|Faster|Slightly slower
|Memory|Dedicated|Shared with @*SQLite3@
|Use case|Simple @*CRUD@|Complex queries
|%
{}
:1309 Performance Monitoring
{}
:  Server Statistics
{}
!// Enable monitoring
!Server.CreateMissingTables;
!
!// Access statistics
!WriteLn('Total requests: ', Server.Stats.TotalRequestCount);
!WriteLn('Success: ', Server.Stats.SuccessRequestCount);
!WriteLn('Errors: ', Server.Stats.ErrorRequestCount);
!WriteLn('Avg response time: ', Server.Stats.AverageResponseTime, ' ms');
{}
:  Per-Table Statistics
{}
!for i := 0 to Server.Model.TablesMax do
!begin
!  Stats := Server.Stats[i];
!  if Stats <> nil then
!    WriteLn(Server.Model.Tables[i].SqlTableName, ': ',
!      Stats.SelectCount, ' reads, ', Stats.InsertCount, ' inserts');
!end;
{}
:  SQL Execution Logging
{}
!// Enable SQL logging
!TSynLog.Add.Level := [sllSQL, sllDB];
!
!// Or specific callback
!Server.OnSqlExecute := procedure(const SQL: RawUtf8; const TimeMS: Int64)
!begin
!  if TimeMS > 100 then  // Log slow queries
!    WriteLn('SLOW QUERY (', TimeMS, 'ms): ', SQL);
!end;
{}
:1310 Custom ORM Extensions
{}
:  Custom SQL Functions
{}
!// Register custom SQLite3 function
!Server.DB.RegisterSQLFunction(
!  procedure(Context: TSqlite3FunctionContext; argc: Integer;
!    var argv: TSqlite3ValueArray)
!  begin
!    // Custom function implementation
!    sqlite3.result_int64(Context, CalculateHash(argv[0]));
!  end,
!  'MYHASH', 1);
!
!// Use in queries
!Server.Orm.ExecuteList(TOrmCustomer,
!  'SELECT * FROM Customer WHERE MYHASH(Name) = ?', [HashValue]);
{}
:  Computed Fields
{}
!type
!  TOrmOrder = class(TOrm)
!  private
!    fQuantity: Integer;
!    fUnitPrice: Currency;
!    fTotal: Currency;
!  protected
!    procedure ComputeFieldsBeforeWrite(const aRest: IRestOrm;
!      aOccasion: TOrmEvent; aServerTimeStamp: TTimeLog = 0); override;
!  published
!    property Quantity: Integer read fQuantity write fQuantity;
!    property UnitPrice: Currency read fUnitPrice write fUnitPrice;
!    property Total: Currency read fTotal write fTotal stored False;  // Computed
!  end;
!
!procedure TOrmOrder.ComputeFieldsBeforeWrite(const aRest: IRestOrm;
!  aOccasion: TOrmEvent; aServerTimeStamp: TTimeLog);
!begin
!  inherited;
!  fTotal := fQuantity * fUnitPrice;
!end;
{}
:1311 Migration from mORMot 1
{}
:  ORM Access Change
{}
!// mORMot 1: Direct access
!Server.Add(Customer, True);
!Server.Retrieve(123, Customer);
!
!// mORMot 2: Via Orm property
!Server.Orm.Add(Customer, True);
!Server.Orm.Retrieve(123, Customer);
{}
:  Event Method Changes
{}
!// mORMot 1
!procedure TSQLRestServerDB.BeforeAdd;
!procedure TSQLRestServerDB.AfterAdd;
!
!// mORMot 2
!function TRestServerDB.OnBeforeAdd: Boolean;
!procedure TRestServerDB.OnAfterAdd;
{}
:  Static Storage Registration
{}
!// mORMot 1
!Server.StaticDataCreate(TOrmCache, '', False, True);
!
!// mORMot 2
!Model.Props[TOrmCache].SetStorage(TRestStorageInMemory);
{}
{\i Next Chapter: Method-Based Services}
{}