; Converted from Markdown - Chapter 14
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:14Client-Server Services via Methods
{}
{\i The Quick and Powerful Way}
{}
To implement a service in the {\i Synopse m@*ORM@ot 2 framework}, the most direct approach is to define published methods on the server side, then use simple @*JSON@ or URL parameter handling to encode and decode requests on both ends.
{}
This chapter covers {\b method-based services} — a straightforward, low-level mechanism for exposing custom functionality over @*HTTP@. While mORMot 2 also provides interface-based services (covered in chapters 15-16) for more structured @*SOA@, method-based services offer maximum flexibility and control.
{}
:1401 Publishing a Service on the Server
{}
:  Basic Structure
{}
On the server side, we customize a {\f1\fs20 TRestServer} descendant (typically {\f1\fs20 TRestServerDB} with @*SQLite3@, or the lighter {\f1\fs20 TRestServerFullMemory}) by adding a new {\f1\fs20 published} method:
{}
!type
!  TRestServerTest = class(TRestServerFullMemory)
!  published
!    procedure Sum(Ctxt: TRestServerUriContext);
!  end;
{}
The method name ({\f1\fs20 Sum}) determines the URI routing — it will be accessible remotely from {\f1\fs20 ModelRoot/Sum}. The {\f1\fs20 ModelRoot} is the {\f1\fs20 Root} parameter defined when creating the model.
{}
:  Method Signature
{}
All server-side methods {\b MUST} follow the {\f1\fs20 TOnRestServerCallBack} prototype:
{}
!type
!  TOnRestServerCallBack = procedure(Ctxt: TRestServerUriContext) of object;
{}
The single {\f1\fs20 Ctxt} parameter provides full access to the execution context: incoming parameters, HTTP headers, session information, and output facilities.
{}
:  Implementation
{}
!procedure TRestServerTest.Sum(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.Results([Ctxt.InputDouble['a'] + Ctxt.InputDouble['b']]);
!end;
{}
The {\f1\fs20 Ctxt} object exposes typed properties for parameter retrieval:
{}
|%19%26%55
|\b Property|Return Type|Exception on Missing\b0
|{\f1\fs20 InputInt['name']}|{\f1\fs20 Int64}|Yes
|{\f1\fs20 InputDouble['name']}|{\f1\fs20 Double}|Yes
|{\f1\fs20 InputUtf8['name']}|{\f1\fs20 RawUtf8}|Yes
|{\f1\fs20 Input['name']}|{\f1\fs20 Variant}|Yes
|{\f1\fs20 InputIntOrVoid['name']}|{\f1\fs20 Int64}|No (returns 0)
|{\f1\fs20 InputDoubleOrVoid['name']}|{\f1\fs20 Double}|No (returns 0)
|{\f1\fs20 InputUtf8OrVoid['name']}|{\f1\fs20 RawUtf8}|No (returns '')
|{\f1\fs20 InputOrVoid['name']}|{\f1\fs20 Variant}|No (returns Unassigned)
|{\f1\fs20 InputExists['name']}|{\f1\fs20 Boolean}|N/A
|%
{}
The default {\f1\fs20 Input['name']} array property (via {\f1\fs20 variant}) allows the concise syntax {\f1\fs20 Ctxt['name']}.
{}
:  Response Format
{}
{\f1\fs20 Ctxt.Results([])} encodes values as a JSON object with a {\f1\fs20 "Result"} member:
{}
!GET /root/Sum?a=3.12&b=4.2
{}
Returns:
${"Result":7.32}
{}
This is perfectly AJAX-friendly and compatible with any HTTP client.
{}
:  Thread Safety
{}
{\b Important}: Method implementations {\b MUST be thread-safe}. The {\f1\fs20 TRestServer.Uri} method expects callbacks to handle thread safety internally. This design maximizes performance and scalability by allowing fine-grained resource locking.
{}
For read-only operations, no locking may be needed. For shared state modifications:
{}
!procedure TRestServerTest.UpdateCounter(Ctxt: TRestServerUriContext);
!begin
!  fCounterLock.Lock;
!  try
!    Inc(fCounter);
!    Ctxt.Results([fCounter]);
!  finally
!    fCounterLock.UnLock;
!  end;
!end;
{}
:1402 Defining the Client
{}
:  Basic Client Call
{}
The client uses dedicated methods to call services by name with parameters:
{}
!function Sum(aClient: TRestClientUri; a, b: Double): Double;
!var
!  err: Integer;
!begin
!  Val(aClient.CallBackGetResult('sum', ['a', a, 'b', b]), Result, err);
!end;
{}
:  Client Method Pattern
{}
A cleaner approach encapsulates service calls in a dedicated client class:
{}
!type
!  TMyClient = class(TRestHttpClientSocket)  // or TRestHttpClientWebSockets
!  public
!    function Sum(a, b: Double): Double;
!  end;
!
!function TMyClient.Sum(a, b: Double): Double;
!var
!  err: Integer;
!begin
!  Val(CallBackGetResult('sum', ['a', a, 'b', b]), Result, err);
!end;
{}
:  Client API Methods
{}
{\f1\fs20 TRestClientUri} provides several methods for service invocation:
{}
|%10%90
|\b Method|Purpose\b0
|{\f1\fs20 CallBackGetResult}|GET request, returns the JSON {\f1\fs20 "Result"} value as {\f1\fs20 RawUtf8}
|{\f1\fs20 CallBackGet}|GET request, returns full response with HTTP status
|{\f1\fs20 CallBackPut}|PUT request with body data
|{\f1\fs20 CallBack}|Generic request with any HTTP method
|%
{}
#### CallBackGet Signature
{}
!function CallBackGet(const aMethodName: RawUtf8;
!  const aNameValueParameters: array of const;
!  out aResponse: RawUtf8;
!  aTable: TOrmClass = nil;
!  aID: TID = 0;
!  aResponseHead: PRawUtf8 = nil): Integer;
{}
#### CallBackGetResult Signature
{}
!function CallBackGetResult(const aMethodName: RawUtf8;
!  const aNameValueParameters: array of const;
!  aTable: TOrmClass = nil;
!  aID: TID = 0): RawUtf8;
{}
:  Object Parameters
{}
Objects can be serialized to JSON automatically:
{}
!function TMyClient.ProcessPerson(Person: TPerson): RawUtf8;
!begin
!  Result := CallBackGetResult('processperson', ['person', ObjectToJson(Person)]);
!end;
{}
:1403 Direct Parameter Marshalling
{}
:  Low-Level Access
{}
For maximum performance, bypass the high-level {\f1\fs20 Input*[]} properties and parse {\f1\fs20 Ctxt.Parameters} directly:
{}
!procedure TRestServerTest.Sum(Ctxt: TRestServerUriContext);
!var
!  a, b: Double;
!begin
!  if UrlDecodeNeedParameters(Ctxt.Parameters, 'A,B') then
!  begin
!    while Ctxt.Parameters <> nil do
!    begin
!      UrlDecodeDouble(Ctxt.Parameters, 'A=', a);
!      UrlDecodeDouble(Ctxt.Parameters, 'B=', b, @Ctxt.Parameters);
!    end;
!    Ctxt.Results([a + b]);
!  end
!  else
!    Ctxt.Error('Missing Parameter');
!end;
{}
:  URL Decode Functions
{}
Available in @!src\core\mormot.core.text.pas@:
{}
|%20%80
|\b Function|Purpose\b0
|{\f1\fs20 UrlDecodeNeedParameters}|Verify required parameters exist
|{\f1\fs20 UrlDecodeInteger}|Extract integer parameter
|{\f1\fs20 UrlDecodeInt64}|Extract 64-bit integer
|{\f1\fs20 UrlDecodeDouble}|Extract floating-point
|{\f1\fs20 UrlDecodeValue}|Extract string value
|{\f1\fs20 UrlDecodeObject}|Deserialize JSON to object
|%
{}
:  JSON Body Access
{}
For POST/PUT requests, the body is available in {\f1\fs20 Ctxt.Call^.InBody}:
{}
!procedure TRestServerTest.ProcessData(Ctxt: TRestServerUriContext);
!var
!  doc: TDocVariantData;
!begin
!  if doc.InitJson(Ctxt.Call^.InBody, JSON_FAST) then
!  begin
!    // Process doc...
!    Ctxt.Success;
!  end
!  else
!    Ctxt.Error('Invalid JSON body');
!end;
{}
:1404 Returning Non-JSON Content
{}
:  Custom MIME Types
{}
Use {\f1\fs20 Ctxt.Returns()} to return any content type:
{}
!procedure TRestServer.Timestamp(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.Returns(Int64ToUtf8(ServerTimestamp), HTTP_SUCCESS, TEXT_CONTENT_TYPE_HEADER);
!end;
{}
:  Binary File Response
{}
!procedure TRestServer.GetFile(Ctxt: TRestServerUriContext);
!var
!  fileName: TFileName;
!  content: RawByteString;
!begin
!  fileName := 'c:\data\' + ExtractFileName(Utf8ToString(Ctxt.InputUtf8['filename']));
!  content := StringFromFile(fileName);
!  if content = '' then
!    Ctxt.Error('', HTTP_NOTFOUND)
!  else
!    Ctxt.Returns(content, HTTP_SUCCESS,
!      HEADER_CONTENT_TYPE + GetMimeContentType(pointer(content), Length(content), fileName));
!end;
{}
:  Client-Side Handling
{}
!function TMyClient.GetFile(const aFileName: RawUtf8): RawByteString;
!var
!  resp: RawUtf8;
!begin
!  if CallBackGet('GetFile', ['filename', aFileName], resp) <> HTTP_SUCCESS then
!    raise Exception.CreateFmt('Impossible to get file: %s', [resp]);
!  Result := RawByteString(resp);
!end;
{}
Note: For file serving, prefer {\f1\fs20 Ctxt.ReturnFile()} or {\f1\fs20 Ctxt.ReturnFileFromFolder()} (covered in section 14.7).
{}
:1405 Advanced Server-Side Processing
{}
:  RESTful URI with Table Context
{}
Methods can be linked to ORM tables via @*REST@ful URIs like {\f1\fs20 ModelRoot/TableName/TableID/MethodName}:
{}
!procedure TRestServerTest.DataAsHex(Ctxt: TRestServerUriContext);
!var
!  aData: RawBlob;
!begin
!  if (Self = nil) or (Ctxt.Table <> TOrmPeople) or (Ctxt.TableID <= 0) then
!    Ctxt.Error('Need a valid record and its ID')
!  else if (Ctxt.Server.Orm as TRestOrmServer).RetrieveBlob(
!      TOrmPeople, Ctxt.TableID, 'Data', aData) then
!    Ctxt.Results([BinToHex(aData)])
!  else
!    Ctxt.Error('Impossible to retrieve the Data BLOB field');
!end;
{}
Corresponding client call:
{}
!function TOrmPeople.DataAsHex(aClient: TRestClientUri): RawUtf8;
!begin
!  Result := aClient.CallBackGetResult('DataAsHex', [], TOrmPeople, ID);
!end;
{}
:  Context Properties
{}
The {\f1\fs20 TRestServerUriContext} exposes rich information:
{}
|%14%86
|\b Property|Description\b0
|{\f1\fs20 Table}|{\f1\fs20 TOrmClass} decoded from URI
|{\f1\fs20 TableIndex}|Index in Server.Model
|{\f1\fs20 TableID}|Record ID from URI
|{\f1\fs20 Session}|Session ID (0 = not started, 1 = auth disabled)
|{\f1\fs20 SessionUser}|Current user's {\f1\fs20 @**TID@}
|{\f1\fs20 SessionGroup}|Current group's {\f1\fs20 @TID@}
|{\f1\fs20 SessionUserName}|User's logon name
|{\f1\fs20 Method}|HTTP verb ({\f1\fs20 mGET}, {\f1\fs20 mPOST}, etc.)
|{\f1\fs20 Call^.InHead}|Raw incoming HTTP headers
|{\f1\fs20 Call^.InBody}|Raw request body
|{\f1\fs20 RemoteIP}|Client IP address
|{\f1\fs20 UserAgent}|Client user-agent string
|%
{}
:  Session and User Details
{}
!procedure TRestServerTest.WhoAmI(Ctxt: TRestServerUriContext);
!var
!  User: TAuthUser;
!begin
!  if Ctxt.Session = CONST_AUTHENTICATION_NOT_USED then
!    Ctxt.Returns(['message', 'Authentication not enabled'])
!  else if Ctxt.Session = CONST_AUTHENTICATION_SESSION_NOT_STARTED then
!    Ctxt.Returns(['message', 'Not authenticated'])
!  else
!  begin
!    User := Ctxt.Server.SessionGetUser(Ctxt.Session);
!    try
!      if User <> nil then
!        Ctxt.Returns(['user', User.LogonName, 'group', Ctxt.SessionGroup])
!      else
!        Ctxt.Error('Session not found', HTTP_FORBIDDEN);
!    finally
!      User.Free;
!    end;
!  end;
!end;
{}
:1406 Browser Speed-Up for Unmodified Requests
{}
:  HTTP 304 Not Modified
{}
The optional {\f1\fs20 Handle304NotModified} parameter enables browser caching:
{}
!procedure TRestServerTest.GetStaticData(Ctxt: TRestServerUriContext);
!var
!  data: RawUtf8;
!begin
!  data := GetCachedData; // Your cached data source
!  Ctxt.Returns(data, HTTP_SUCCESS, JSON_CONTENT_TYPE_HEADER, true); // Handle304NotModified=true
!end;
{}
When enabled:
- Response content is hashed using {\f1\fs20 crc32c} (with SSE4.2 hardware acceleration if available)
- If unchanged since the last request, returns {\f1\fs20 304 Not Modified} without body
- Significantly reduces bandwidth for periodic polling
{}
:  Caveats
{}
- {\b Authentication conflict}: RESTful authentication uses per-URI signatures that change frequently. Use {\f1\fs20 Server.ServiceMethodByPassAuthentication()} to disable authentication for cached methods.
- {\b Hash collisions}: While extremely rare with {\f1\fs20 crc32c}, false positives are theoretically possible. Don't use for sensitive accounting data.
{}
:  CDN Integration
{}
This stateless REST model enables multiple levels of caching:
- Browser cache
- Proxy servers
- Content Delivery Networks (CDN)
{}
Combined with proper HTTP headers, your mORMot server can scale to thousands of concurrent users worldwide.
{}
:1407 Returning File Content
{}
:  ReturnFile Method
{}
{\f1\fs20 Ctxt.ReturnFile()} efficiently serves files with automatic MIME type detection:
{}
!procedure TRestServerTest.DownloadReport(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.ReturnFile('c:\reports\' + Ctxt.InputUtf8['name'] + '.pdf', true);
!end;
{}
Features:
- Automatic MIME type from file extension
- Optional {\f1\fs20 Handle304NotModified} using file timestamp
- High-performance: HTTP.SYS (Windows) serves files asynchronously from kernel mode
{}
:  ReturnFileFromFolder Method
{}
Serves any file from a folder based on the URI path:
{}
!procedure TRestServerTest.StaticFiles(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.ReturnFileFromFolder('c:\www\static\', true, 'index.html', '/404.html');
!end;
{}
Parameters:
- {\f1\fs20 FolderName}: Base folder path
- {\f1\fs20 Handle304NotModified}: Enable browser caching
- {\f1\fs20 DefaultFileName}: Served for root requests (default: {\f1\fs20 'index.html'})
- {\f1\fs20 Error404Redirect}: Redirect URI for missing files
{}
This is ideal for serving static web content (HTML, CSS, JS, images) alongside your REST API.
{}
:1408 JSON Web Tokens (JWT)
{}
:  Overview
{}
JSON Web Tokens (@*JWT@) provide stateless authentication and secure information exchange. mORMot 2 implements JWT in @!src\crypt\mormot.crypt.jwt.pas@:
{}
{\b Supported Algorithms}:
|%22%78
|\b Algorithm|Description\b0
|{\f1\fs20 HS256/384/512}|HMAC-SHA2 (symmetric)
|{\f1\fs20 ES256}|ECDSA P-256 (asymmetric)
|{\f1\fs20 RS256/384/512}|RSA (asymmetric)
|{\f1\fs20 PS256/384/512}|RSA-PSS (asymmetric)
|{\f1\fs20 S3256/384/512}|SHA-3 (non-standard)
|{\f1\fs20 none}|No signature (use with caution)
|%
{}
{\b Features}:
- All standard JWT claims validated
- Thread-safe with optional caching
- Cross-platform (no external DLLs)
- Immune to algorithm confusion attacks
{}
:  Class Hierarchy
{}
!TJwtAbstract
$├── TJwtNone           (algorithm: "none")
$├── TJwtSynSignerAbstract
$│   ├── TJwtHS256/384/512   (HMAC-SHA2)
$│   └── TJwtS3256/384/512   (SHA-3)   │
$├── TJwtES256          (ECDSA P-256)
$├── TJwtRS256/384/512  (RSA)
$├── TJwtPS256/384/512  (RSA-PSS)
$└── TJwtCrypt          (factory-based, recommended)
{}
:  Verifying JWTs
{}
!uses
!  mormot.crypt.jwt;
!
!var
!  jwt: TJwtAbstract;
!  content: TJwtContent;
!begin
!  jwt := TJwtHS256.Create('secret', 0, [jrcSubject], []);
!  try
!    jwt.Verify(
!      'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.' +
!      'eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWV9.' +
!      'TJVA95OrM7E2cBab30RMHrHDcEfxjoYZgeFONFh7HgQ',
!      content);
!
!    Assert(content.result = jwtValid);
!    Assert(content.reg[jrcSubject] = '1234567890');
!    Assert(content.data.U['name'] = 'John Doe');
!    Assert(content.data.B['admin'] = True);
!  finally
!    jwt.Free;
!  end;
!end;
{}
:  Creating JWTs
{}
!var
!  jwt: TJwtAbstract;
!  token: RawUtf8;
!begin
!  jwt := TJwtHS256.Create('secret', 10000,  // 10000 PBKDF2 rounds
!    [jrcIssuer, jrcExpirationTime, jrcIssuedAt, jrcJWTID], [], 3600);  // 1 hour expiry
!  try
!    token := jwt.Compute(['http://example.com/is_root', True], 'joe');
!    // token payload: {"http://example.com/is_root":true,"iss":"joe","iat":...,"exp":...,"jti":...}
!  finally
!    jwt.Free;
!  end;
!end;
{}
:  JWT in Method-Based Services
{}
Integrate JWT validation using {\f1\fs20 Ctxt.AuthenticationCheck()}:
{}
!type
!  TMyDaemon = class(TRestServerFullMemory)
!  private
!    fJwt: TJwtAbstract;
!  public
!    constructor Create(aModel: TOrmModel);
!  published
!    procedure SecureFiles(Ctxt: TRestServerUriContext);
!  end;
!
!constructor TMyDaemon.Create(aModel: TOrmModel);
!begin
!  inherited Create(aModel);
!  fJwt := TJwtHS256.Create('my-secret-key', 10000, [jrcSubject], [], 3600);
!end;
!
!procedure TMyDaemon.SecureFiles(Ctxt: TRestServerUriContext);
!begin
!  if Ctxt.AuthenticationCheck(fJwt) then  // Returns boolean
!    Ctxt.ReturnFileFromFolder('c:\protected\')
!  else
!    ; // AuthenticationCheck already returned HTTP 401
!end;
{}
:  Server-Wide JWT Authentication
{}
Assign a JWT instance to handle all unauthenticated requests:
{}
!Server.JwtForUnauthenticatedRequest := TJwtHS256.Create('secret', 10000, [], []);
{}
:1409 Handling Errors
{}
:  Automatic Exception Handling
{}
Missing parameters in {\f1\fs20 Input*[]} properties raise {\f1\fs20 EParsingException}, which the server catches and returns as a structured error response:
{}
${
$  "ErrorCode": 400,
$  "ErrorText": "EParsingException: Missing parameter 'name'"
$}
{}
:  Explicit Error Handling
{}
Use {\f1\fs20 Ctxt.Error()} for custom error responses:
{}
!procedure TRestServer.UpdateRecord(Ctxt: TRestServerUriContext);
!begin
!  if not CanUpdate(Ctxt.InputInt['id']) then
!    Ctxt.Error('Record is locked', HTTP_FORBIDDEN)
!  else if DoUpdate(Ctxt.InputInt['id'], Ctxt.InputUtf8['data']) then
!    Ctxt.Success
!  else
!    Ctxt.Error('Update failed', HTTP_SERVERERROR);
!end;
{}
:  Success Without Content
{}
For operations that don't return data:
{}
!procedure TRestServer.DeleteItem(Ctxt: TRestServerUriContext);
!begin
!  if DoDelete(Ctxt.InputInt['id']) then
!    Ctxt.Success  // Returns HTTP 200 with empty body
!  else
!    Ctxt.Error('Delete failed');
!end;
{}
:  HTTP Status Codes
{}
|%16%84
|\b Method|Default Status\b0
|{\f1\fs20 Ctxt.Results()}|200 OK
|{\f1\fs20 Ctxt.Returns()}|200 OK (customizable)
|{\f1\fs20 Ctxt.Success()}|200 OK (customizable)
|{\f1\fs20 Ctxt.Error()}|400 Bad Request (customizable)
|%
{}
Common status codes:
- {\f1\fs20 HTTP_SUCCESS} = 200
- {\f1\fs20 HTTP_CREATED} = 201
- {\f1\fs20 HTTP_NOCONTENT} = 204
- {\f1\fs20 HTTP_BADREQUEST} = 400
- {\f1\fs20 HTTP_FORBIDDEN} = 403
- {\f1\fs20 HTTP_NOTFOUND} = 404
- {\f1\fs20 HTTP_SERVERERROR} = 500
{}
:1410 Bypassing Authentication
{}
:  Per-Method Bypass
{}
Certain methods (like {\f1\fs20 Timestamp} or public API endpoints) should be accessible without authentication:
{}
!Server.ServiceMethodByPassAuthentication('Timestamp');
!Server.ServiceMethodByPassAuthentication('GetPublicData');
{}
:  Allowed HTTP Methods
{}
Restrict which HTTP verbs are allowed for a method:
{}
!// In TRestServerMethod, set during initialization
!Server.PublishedMethods['MyMethod'].Methods := [mGET, mPOST];
{}
:1411 Benefits and Limitations
{}
:  Benefits
{}
Method-based services provide:
{}
|%23%77
|\b Benefit|Description\b0
|{\b Full control}|Direct access to HTTP headers, binary data, custom MIME types
|{\b RESTful integration}|Can be linked to ORM tables via URI routing
|{\b Low overhead}|Minimal abstraction layer, maximum performance
|{\b Flexibility}|Handle any request type (AJAX, SOAP, custom protocols)
|{\b Simple debugging}|Direct mapping between URI and code
|%
{}
:  Security
{}
The mORMot implementation is inherently secure against certain attacks:
- {\b Hash collision attacks}: Not vulnerable (unlike some Apache configurations)
- {\b Parameter injection}: Typed accessors validate input
- {\b Thread safety}: Enforced by design
{}
:  Limitations
{}
|%43%57
|\b Limitation|Solution\b0
|Manual parameter marshalling|Use interface-based services (Chapter 16)
|No automatic client stub generation|Use interface-based services
|Flat service namespace|Organize via naming conventions or interfaces
|No automatic documentation|Generate manually or use OpenAPI export
|%
{}
:  When to Use
{}
{\b Use method-based services when}:
- You need binary data handling or custom MIME types
- You're building a simple REST API
- You need maximum performance
- You're integrating with non-mORMot clients
- You want full HTTP control
{}
{\b Use interface-based services when}:
- Building complex SOA systems
- You want automatic parameter marshalling
- You need client stub generation
- You prefer strongly-typed contracts
{}
:1412 Complete Example
{}
:  Server
{}
!unit RestServerUnit;
!
!interface
!
!uses
!  mormot.core.base,
!  mormot.core.text,
!  mormot.core.json,
!  mormot.orm.core,
!  mormot.rest.core,
!  mormot.rest.server,
!  mormot.rest.memserver;
!
!type
!  TMyRestServer = class(TRestServerFullMemory)
!  published
!    procedure Sum(Ctxt: TRestServerUriContext);
!    procedure Echo(Ctxt: TRestServerUriContext);
!    procedure Time(Ctxt: TRestServerUriContext);
!  end;
!
!implementation
!
!procedure TMyRestServer.Sum(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.Results([Ctxt.InputDouble['a'] + Ctxt.InputDouble['b']]);
!end;
!
!procedure TMyRestServer.Echo(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.Returns(Ctxt.Call^.InBody, HTTP_SUCCESS, TEXT_CONTENT_TYPE_HEADER);
!end;
!
!procedure TMyRestServer.Time(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.Returns(['timestamp', ServerTimestamp, 'utc', DateTimeToIso8601(NowUtc, true)]);
!end;
!
!end.
{}
:  Client
{}
!unit RestClientUnit;
!
!interface
!
!uses
!  mormot.core.base,
!  mormot.rest.client,
!  mormot.rest.http.client;
!
!type
!  TMyRestClient = class(TRestHttpClientSocket)
!  public
!    function Sum(a, b: Double): Double;
!    function Echo(const Text: RawUtf8): RawUtf8;
!    function GetServerTime: TDateTime;
!  end;
!
!implementation
!
!uses
!  mormot.core.json;
!
!function TMyRestClient.Sum(a, b: Double): Double;
!var
!  err: Integer;
!begin
!  Val(CallBackGetResult('sum', ['a', a, 'b', b]), Result, err);
!end;
!
!function TMyRestClient.Echo(const Text: RawUtf8): RawUtf8;
!var
!  resp: RawUtf8;
!begin
!  if CallBack(mPOST, 'echo', Text, resp) = HTTP_SUCCESS then
!    Result := resp
!  else
!    Result := '';
!end;
!
!function TMyRestClient.GetServerTime: TDateTime;
!var
!  doc: TDocVariantData;
!  resp: RawUtf8;
!begin
!  if CallBackGet('time', [], resp) = HTTP_SUCCESS then
!  begin
!    doc.InitJson(resp, JSON_FAST);
!    Result := Iso8601ToDateTime(doc.U['utc']);
!  end
!  else
!    Result := 0;
!end;
!
!end.
{}
:  Main Program
{}
!program MethodServicesDemo;
!
!uses
!  mormot.core.base,
!  mormot.orm.core,
!  mormot.rest.http.server,
!  RestServerUnit,
!  RestClientUnit;
!
!var
!  Model: TOrmModel;
!  Server: TMyRestServer;
!  HttpServer: TRestHttpServer;
!  Client: TMyRestClient;
!begin
!  Model := TOrmModel.Create([], 'root');
!  Server := TMyRestServer.Create(Model);
!  try
!    Server.ServiceMethodByPassAuthentication('Time');
!
!    HttpServer := TRestHttpServer.Create('8080', [Server], '+', useHttpAsync);
!    try
!      // Client demo
!      Client := TMyRestClient.Create('localhost', '8080', TOrmModel.Create([], 'root'));
!      try
!        WriteLn('Sum(3.5, 2.5) = ', Client.Sum(3.5, 2.5):0:2);
!        WriteLn('Echo: ', Client.Echo('Hello mORMot!'));
!        WriteLn('Server time: ', DateTimeToStr(Client.GetServerTime));
!      finally
!        Client.Free;
!      end;
!
!      WriteLn('Press Enter to stop...');
!      ReadLn;
!    finally
!      HttpServer.Free;
!    end;
!  finally
!    Server.Free;
!    Model.Free;
!  end;
!end.
{}
: Summary
{}
Method-based services in mORMot 2 provide:
{}
- {\b Direct HTTP control}: Full access to headers, body, and response formatting
- {\b Simple implementation}: Just add a published method with the right signature
- {\b Flexible responses}: JSON, HTML, binary, any MIME type
- {\b RESTful integration}: Link methods to ORM tables via URI patterns
- {\b JWT support}: Built-in token validation
- {\b Browser caching}: HTTP 304 support for optimized polling
- {\b Thread safety}: By design, with fine-grained locking
{}
While interface-based services (covered in Chapter 16) offer more structure for complex SOA systems, method-based services remain the go-to choice for simple APIs, binary data handling, and maximum control over the HTTP layer.
{}