; Converted from Markdown - Chapter 15
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:15Interfaces and SOLID Design
{}
{\i The Foundation for Robust Architecture}
{}
Before diving into interface-based services, we need to understand the fundamentals of interfaces in Delphi and the @*SOLID@ design principles that guide their effective use. This chapter establishes the theoretical foundation; Chapter 16 covers the practical implementation of @*SOA@ services.
{}
:1501 Delphi and Interfaces
{}
:  Declaring an Interface
{}
In Delphi's OOP model, an {\f1\fs20 interface} defines a type comprising abstract virtual methods. It declares "what" is available, not "how" it's implemented — this is the {\b abstraction} benefit of interfaces.
{}
!type
!  ICalculator = interface(IInvokable)
!    ['{9A60C8ED-CEB2-4E09-87D4-4A16F496E5FE}']
!    /// add two signed 32-bit integers
!    function Add(n1, n2: Integer): Integer;
!  end;
{}
Key characteristics:
- {\b Naming}: {\f1\fs20 ICalculator} starts with {\f1\fs20 I} (convention for interfaces, vs {\f1\fs20 T} for classes)
- {\b No visibility}: All methods are effectively public
- {\b No fields}: Only methods (fields are implementation details)
- {\b GUID}: Unique identifier (press {\f1\fs20 Ctrl+Shift+G} in the {\f1\fs20 IDE} to generate)
- {\b Inheritance}: From {\f1\fs20 IInvokable} for @*RTTI@ support
{}
:  Implementing an Interface
{}
!type
!  TServiceCalculator = class(TInterfacedObject, ICalculator)
!  public
!    function Add(n1, n2: Integer): Integer;
!  end;
!
!function TServiceCalculator.Add(n1, n2: Integer): Integer;
!begin
!  Result := n1 + n2;
!end;
{}
Notes:
- The class inherits from {\f1\fs20 TInterfacedObject} and implements {\f1\fs20 ICalculator}
- Method visibility in the class doesn't affect interface usage
- Additional methods can exist in the class (not part of the interface)
- Multiple interfaces can be implemented: {\f1\fs20 class({\f1\fs20 TInterfacedObject}, {\f1\fs20 ICalculator}, {\f1\fs20 IAnotherInterface})}
{}
:  Using an Interface
{}
{\b Classic way} (explicit class instance):
!function MyAdd(a, b: Integer): Integer;
!var
!  Calculator: TServiceCalculator;
!begin
!  Calculator := TServiceCalculator.Create;
!  try
!    Result := Calculator.Add(a, b);
!  finally
!    Calculator.Free;
!  end;
!end;
{}
{\b Interface way} (reference-counted):
!function MyAdd(a, b: Integer): Integer;
!var
!  Calculator: ICalculator;
!begin
!  Calculator := TServiceCalculator.Create;
!  Result := Calculator.Add(a, b);
!end; // Calculator automatically freed when out of scope
{}
Key benefits:
- {\b Automatic memory management}: Reference counting handles cleanup
- {\b No try..finally needed}: Compiler generates hidden cleanup code
- {\b Minimal overhead}: Similar to virtual method call performance
{}
:  Orthogonality and Polymorphism
{}
Interfaces are orthogonal to class implementations:
{}
!type
!  TOtherCalculator = class(TInterfacedObject, ICalculator)
!  public
!    function Add(n1, n2: Integer): Integer;
!  end;
!
!function TOtherCalculator.Add(n1, n2: Integer): Integer;
!begin
!  Result := n2 + n1; // Different implementation, same interface
!end;
{}
The client code doesn't need to change:
!var
!  Calculator: ICalculator;
!begin
!  Calculator := TOtherCalculator.Create; // Different class, same interface
!  Result := Calculator.Add(a, b);
!end;
{}
:  The mORMot Magic
{}
m@*ORM@ot leverages interfaces for Client-Server communication:
{}
- {\b Same interface} on both client and server
- {\b Client}: "Fake" implementation that serializes calls to @*JSON@
- {\b Server}: Real implementation executes the logic
- {\b Transport}: JSON over @*HTTP@ (or @*WebSocket@s, named pipes, etc.)
{}
This creates a seamless RPC experience with the elegance of local interface calls.
{}
:1502 SOLID Design Principles
{}
The SOLID acronym represents five principles for maintainable OOP design:
{}
|%30%70
|\b Principle|Summary\b0
|{\b S}ingle Responsibility|One reason to change per class
|{\b O}pen/Closed|Open for extension, closed for modification
|{\b L}iskov Substitution|Subtypes must be substitutable for base types
|{\b I}nterface Segregation|Many specific interfaces over one general-purpose
|{\b D}ependency Inversion|Depend on abstractions, not concretions
|%
{}
These principles combat the three main code weaknesses:
- {\b Rigidity}: Hard to change (changes cascade everywhere)
- {\b Fragility}: Changes break unexpected parts
- {\b Immobility}: Hard to reuse in other contexts
{}
:  Single Responsibility Principle
{}
> "A class should have only one reason to change."
{}
{\b Bad} — {\f1\fs20 TBarcodeScanner} handles both protocol and communication:
!type
!  TBarcodeScanner = class
!    function ReadFrame: TProtocolFrame;
!    procedure WriteFrame(const Frame: TProtocolFrame);
!    procedure SetComPort(const Port: string);  // Serial communication
!    procedure SetUsbDevice(DeviceID: Integer);  // USB communication
!  end;
{}
{\b Good} — Separated responsibilities:
!type
!  // Connection abstraction
!  TAbstractBarcodeConnection = class
!    function ReadChar: Byte; virtual; abstract;
!    procedure WriteChar(aChar: Byte); virtual; abstract;
!  end;
!
!  // Protocol abstraction
!  TAbstractBarcodeProtocol = class
!  protected
!    fConnection: TAbstractBarcodeConnection;
!  public
!    function ReadFrame: TProtocolFrame; virtual; abstract;
!    procedure WriteFrame(const Frame: TProtocolFrame); virtual; abstract;
!  end;
!
!  // Composed scanner
!  TBarcodeScanner = class
!  protected
!    fProtocol: TAbstractBarcodeProtocol;
!    fConnection: TAbstractBarcodeConnection;
!  public
!    property Protocol: TAbstractBarcodeProtocol read fProtocol;
!    property Connection: TAbstractBarcodeConnection read fConnection;
!  end;
{}
#### 15.2.1.1. Don't Mix UI and Logic
{}
{\b Smell in uses clause}:
!unit MyDataModel;
!
!uses
!  Vcl.Forms,    // BAD: Couples data to GUI framework
!  Windows,      // BAD: Couples to operating system
!  mormot.orm.core;
{}
Keep business logic units free of:
- GUI frameworks (VCL, FMX, LCL)
- Operating system specifics ({\f1\fs20 Windows}, {\f1\fs20 Posix})
- Any visual form units
{}
mORMot framework units follow this principle — {\f1\fs20 mormot.orm.core.pas} has no GUI dependencies.
{}
:  Open/Closed Principle
{}
> "Software entities should be open for extension, but closed for modification."
{}
{\b Guidelines}:
- Define abstract classes/interfaces, implement via inheritance
- Members should be {\f1\fs20 protected} (for inheritance) or {\f1\fs20 private} (hidden)
- Avoid singletons and global variables
- Use RTTI sparingly and via framework abstractions
{}
{\b Example — Your code extends mORMot without modifying it}:
!type
!  TMyRestServer = class(TRestServerDB)
!  published
!    procedure MyCustomService(Ctxt: TRestServerUriContext);
!  end;
{}
You extend by inheritance, not by editing {\f1\fs20 mormot.rest.server.pas}.
{}
:  Liskov Substitution Principle
{}
> "Objects of a supertype should be replaceable with objects of any subtype."
{}
{\b mORMot Example}:
!var
!  Rest: TRest;  // Abstract parent type
!begin
!  // Either implementation works identically:
!  Rest := TRestServerDB.Create(Model, 'mydata.db3');
!  // OR
!  Rest := TRestHttpClientSocket.Create('server', '8080', Model);
!
!  // Same API regardless of implementation:
!  Rest.Orm.Add(MyRecord);
!end;
{}
{\b Violations to avoid}:
!procedure TAbstractScanner.Process;
!begin
!  // BAD: Type checking breaks substitutability
!  if Self is TSerialScanner then
!    // Serial-specific code
!  else if Self is TUsbScanner then
!    // USB-specific code
!end;
{}
:  Interface Segregation Principle
{}
> "Many client-specific interfaces are better than one general-purpose interface."
{}
{\b Bad} — Fat interface:
!type
!  IEverything = interface
!    procedure DoThis;
!    procedure DoThat;
!    procedure DoSomethingElse;
!    // ... 50 more methods
!  end;
{}
{\b Good} — Segregated interfaces:
!type
!  IDoThis = interface
!    procedure DoThis;
!  end;
!
!  IDoThat = interface
!    procedure DoThat;
!  end;
{}
This is especially important in SOA: define small, focused service interfaces rather than monolithic ones.
{}
:  Dependency Inversion Principle
{}
> "Depend on abstractions, not concretions."
{}
{\b Bad} — Direct dependency on implementation:
!type
!  TOrderService = class
!  private
!    fDatabase: TSQLiteDatabase;  // Concrete class
!  end;
{}
{\b Good} — Dependency on abstraction:
!type
!  TOrderService = class
!  private
!    fRepository: IOrderRepository;  // Interface abstraction
!  public
!    constructor Create(const aRepository: IOrderRepository);
!  end;
{}
This enables:
- {\b Testing}: Inject mock implementations
- {\b Flexibility}: Swap implementations without code changes
- {\b Decoupling}: No compile-time dependency on concrete classes
{}
:1503 Circular References and Weak Pointers
{}
:  The Problem
{}
Interface reference counting can cause memory leaks with circular references:
{}
!type
!  IParent = interface
!    procedure SetChild(const Value: IChild);
!    function GetChild: IChild;
!  end;
!
!  IChild = interface
!    procedure SetParent(const Value: IParent);
!    function GetParent: IParent;
!  end;
{}
If {\f1\fs20 Parent.Child} references {\f1\fs20 Child}, and {\f1\fs20 Child.Parent} references {\f1\fs20 Parent}, neither will ever be freed — both maintain a reference count ≥ 1 indefinitely.
{}
:  Weak Pointers
{}
mORMot provides {\f1\fs20 SetWeak} to bypass reference counting:
{}
!uses
!  mormot.core.interfaces;
!
!procedure TChild.SetParent(const Value: IParent);
!begin
!  SetWeak(@fParent, Value);  // No reference count increment
!end;
{}
The child holds a reference to parent, but doesn't prevent parent's destruction.
{}
:  Zeroing Weak Pointers
{}
For safer weak references that automatically become {\f1\fs20 nil} when the target is freed:
{}
!procedure TChild.SetParent(const Value: IParent);
!begin
!  SetWeakZero(Self, @fParent, Value);  // Auto-nils when parent freed
!end;
{}
When {\f1\fs20 Parent} is destroyed:
- With {\f1\fs20 SetWeak}: {\f1\fs20 fParent} becomes a dangling pointer (dangerous!)
- With {\f1\fs20 SetWeakZero}: {\f1\fs20 fParent} automatically becomes {\f1\fs20 nil} (safe)
{}
:1504 Dependency Injection in Practice
{}
:  Constructor Injection
{}
The simplest and most explicit form:
{}
!type
!  IUserRepository = interface(IInvokable)
!    ['{B21E5B21-28F4-4874-8446-BD0B06DAA07F}']
!    function GetUserByName(const Name: RawUtf8): TUser;
!    procedure Save(const User: TUser);
!  end;
!
!  ISmsSender = interface(IInvokable)
!    ['{8F87CB56-5E2F-437E-B2E6-B3020835DC61}']
!    function Send(const Text, Number: RawUtf8): Boolean;
!  end;
!
!  TLoginController = class(TInterfacedObject, ILoginController)
!  private
!    fUserRepository: IUserRepository;
!    fSmsSender: ISmsSender;
!  public
!    constructor Create(const aUserRepository: IUserRepository;
!      const aSmsSender: ISmsSender);
!    procedure ForgotMyPassword(const UserName: RawUtf8);
!  end;
!
!constructor TLoginController.Create(const aUserRepository: IUserRepository;
!  const aSmsSender: ISmsSender);
!begin
!  fUserRepository := aUserRepository;
!  fSmsSender := aSmsSender;
!end;
{}
:  TInjectableObject
{}
For automatic resolution of dependencies, inherit from {\f1\fs20 TInjectableObject}:
{}
!uses
!  mormot.core.interfaces;
!
!type
!  TMyService = class(TInjectableObject, IMyService)
!  private
!    fCalculator: ICalculator;  // Auto-resolved
!  published
!    property Calculator: ICalculator read fCalculator;
!  public
!    function DoWork: Integer;
!  end;
{}
Published interface properties are automatically resolved when the object is created through the DI container.
{}
:  Lazy Resolution
{}
For on-demand resolution:
{}
!procedure TMyService.DoSomething;
!var
!  Repository: IOrderRepository;
!begin
!  Resolve(IOrderRepository, Repository);  // Resolve when needed
!  Repository.SaveOrder(Order);
!end;
{}
:1505 Stubs and Mocks for Testing
{}
:  Terminology
{}
|%8%92
|\b Type|Purpose\b0
|{\b Stub}|Fake implementation returning pre-arranged responses
|{\b Mock}|Fake that verifies interactions (method calls, parameters)
|%
{}
{\b Rule}: One mock per test, multiple stubs as needed.
{}
:  Creating Stubs
{}
!uses
!  mormot.core.interfaces;
!
!procedure TMyTest.TestForgotPassword;
!var
!  SmsSender: ISmsSender;
!  UserRepository: IUserRepository;
!begin
!  // Create stub that returns true for Send method
!  TInterfaceStub.Create(TypeInfo(ISmsSender), SmsSender)
!    .Returns('Send', [True]);
!
!  // Create mock that expects Save to be called once
!  TInterfaceMock.Create(TypeInfo(IUserRepository), UserRepository, Self)
!    .ExpectsCount('Save', qoEqualTo, 1);
!
!  // Run the test
!  with TLoginController.Create(UserRepository, SmsSender) do
!  try
!    ForgotMyPassword('testuser');
!  finally
!    Free;
!  end;
!  // Verification happens automatically when UserRepository goes out of scope
!end;
{}
:  Stub Return Values
{}
Simple returns:
!TInterfaceStub.Create(TypeInfo(ICalculator), Calc)
!  .Returns('Add', [42]);  // Add always returns 42
{}
Conditional returns:
!TInterfaceStub.Create(TypeInfo(ICalculator), Calc)
!  .Returns('Add', [1, 2], [3])   // Add(1,2) returns 3
!  .Returns('Add', [10, 20], [30]); // Add(10,20) returns 30
{}
:  Stub with Custom Logic
{}
Using a callback for complex behavior:
{}
!procedure TMyTest.SubtractCallback(Ctxt: TOnInterfaceStubExecuteParamsVariant);
!begin
!  Ctxt['Result'] := Ctxt['n1'] - Ctxt['n2'];
!end;
!
!TInterfaceStub.Create(TypeInfo(ICalculator), Calc)
!  .Executes('Subtract', SubtractCallback);
{}
:  Mock Expectations
{}
!TInterfaceMock.Create(TypeInfo(ICalculator), Calc, Self)
!  // Expect Multiply to be called exactly twice
!  .ExpectsCount('Multiply', qoEqualTo, 2)
!  // Expect Add to be called at least once
!  .ExpectsCount('Add', qoGreaterThan, 0)
!  // Expect specific call sequence
!  .ExpectsTrace('Add(10,20)=[30],Multiply(5,6)=[30]');
{}
:  Test Spy Pattern
{}
For "run then verify" testing:
{}
!procedure TMyTest.TestCalculator;
!var
!  Calc: ICalculator;
!  Spy: TInterfaceMockSpy;
!begin
!  Spy := TInterfaceMockSpy.Create(TypeInfo(ICalculator), Calc, Self);
!
!  // Run code under test
!  Calc.Add(10, 20);
!  Calc.Multiply(5, 6);
!
!  // Verify after execution
!  Spy.Verify('Add');
!  Spy.Verify('Multiply', [5, 6]);
!end;
{}
:1506 Interface Registration
{}
:  Global Registration
{}
Register interfaces at initialization for cleaner code:
{}
!unit MyInterfaces;
!
!interface
!
!type
!  ICalculator = interface(IInvokable)
!    ['{9A60C8ED-CEB2-4E09-87D4-4A16F496E5FE}']
!    function Add(n1, n2: Integer): Integer;
!  end;
!
!  IUserRepository = interface(IInvokable)
!    ['{B21E5B21-28F4-4874-8446-BD0B06DAA07F}']
!    function GetUserByName(const Name: RawUtf8): TUser;
!  end;
!
!implementation
!
!uses
!  mormot.core.interfaces;
!
!initialization
!  TInterfaceFactory.RegisterInterfaces([
!    TypeInfo(ICalculator),
!    TypeInfo(IUserRepository)
!  ]);
!end.
{}
:  Using Registered Interfaces
{}
After registration, you can use interface types directly (no {\f1\fs20 TypeInfo()}):
{}
!// Instead of:
!TInterfaceStub.Create(TypeInfo(ICalculator), Calc);
!
!// You can write:
!TInterfaceStub.Create(ICalculator, Calc);
{}
: Summary
{}
This chapter covered the foundations for interface-based development:
{}
- {\b Interfaces} provide abstraction and automatic memory management
- {\b SOLID principles} guide maintainable architecture
- {\b Weak pointers} solve circular reference problems
- {\b Dependency injection} enables loose coupling and testability
- {\b Stubs and mocks} enable isolated unit testing
{}
These concepts are essential for understanding the next chapter, which shows how mORMot uses interfaces to implement powerful SOA services with automatic client stub generation, contract validation, and multiple instance lifetime patterns.
{}