; Converted from Markdown - Chapter 16
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:16Client-Server Services via Interfaces
{}
{\i Service-Oriented Architecture Made Simple}
{}
In Chapter 14, we covered method-based services — a direct approach with full @*HTTP@ control. This chapter introduces {\b interface-based services}, m@*ORM@ot's powerful @*SOA@ implementation that provides automatic client stub generation, contract validation, multiple instance lifetimes, and bidirectional communication via @*WebSocket@s.
{}
:1601 Why Interface-Based Services?
{}
Method-based services have limitations:
- Manual parameter marshalling on both ends
- No automatic client stub generation
- Flat service namespace
- Testing requires manual mocking
- No built-in session/workflow management
- Security checked manually per method
- No callback mechanism
{}
Interface-based services solve these problems:
{}
|%22%78
|\b Feature|Description\b0
|{\b Design by Contract}|Interfaces define the service contract in pure Pascal
|{\b Auto Marshalling}|@*JSON@ serialization handled automatically
|{\b Factory Driven}|Get implementations from interfaces on both client and server
|{\b Multiple Lifetimes}|Per-call, shared, per-session, per-user, per-group, client-driven
|{\b Contract Validation}|Client/server compatibility verified before execution
|{\b Bidirectional}|Callback interfaces for real-time notifications
|{\b Secure}|Per-method authorization via user groups
|{\b Cross-Platform}|Generated client code for Delphi, FPC, JavaScript
|%
{}
:1602 Defining the Service Contract
{}
:  Basic Interface
{}
!type
!  ICalculator = interface(IInvokable)
!    ['{9A60C8ED-CEB2-4E09-87D4-4A16F496E5FE}']
!    /// add two signed 32-bit integers
!    function Add(n1, n2: Integer): Integer;
!    /// multiply two 64-bit integers
!    function Multiply(n1, n2: Int64): Int64;
!  end;
{}
Requirements:
- Must inherit from {\f1\fs20 IInvokable} (ensures @*RTTI@)
- Must have a GUID (for identification)
- ASCII method names only (convention for services)
- {\f1\fs20 register} calling convention (default)
{}
:  Supported Parameter Types
{}
|%22%78
|\b Type|Serialization\b0
|{\f1\fs20 Boolean}|JSON {\f1\fs20 true}/{\f1\fs20 false}
|{\f1\fs20 Integer}, {\f1\fs20 Cardinal}, {\f1\fs20 Int64}, {\f1\fs20 Double}, {\f1\fs20 Currency}|JSON number
|Enumerations|JSON number (ordinal value)
|Sets|JSON number (bitmask, up to 32 elements)
|{\f1\fs20 TDateTime}, {\f1\fs20 TDateTimeMS}|{\f1\fs20 ISO} 8601 JSON string
|{\f1\fs20 RawUtf8}, {\f1\fs20 string}, {\f1\fs20 @*Unicode@String}|JSON string (@*UTF-8@)
|{\f1\fs20 RawJson}|JSON passthrough (no escaping)
|{\f1\fs20 RawByteString}|Base64-encoded JSON string
|{\f1\fs20 TPersistent}, {\f1\fs20 TOrm}|JSON object (published properties)
|{\f1\fs20 TObjectList}|JSON array with {\f1\fs20 "ClassName"} field
|Dynamic arrays|JSON array
|{\f1\fs20 record}|JSON object (with RTTI or custom serialization)
|{\f1\fs20 variant}, {\f1\fs20 TDocVariant}|Native JSON
|{\f1\fs20 TServiceCustomAnswer}|Custom response (binary, HTML, etc.)
|{\f1\fs20 interface}|Callback for bidirectional communication
|%
{}
:  Parameter Direction
{}
!function Process(const Input: RawUtf8;     // Client → Server only
!                 var InOut: Integer;        // Client ↔ Server (both ways)
!                 out Output: RawUtf8        // Server → Client only
!                ): Boolean;                 // Server → Client (result)
{}
:  Complex Interface Example
{}
!type
!  IComplexService = interface(IInvokable)
!    ['{8B5A2B10-7B3C-4A7D-95F3-8C9D7E6A5B4C}']
!    // Simple types
!    function Calculate(n1, n2: Double): Double;
!
!    // Record parameters
!    function ProcessOrder(const Order: TOrderRecord): TOrderResult;
!
!    // Dynamic arrays
!    function FilterItems(const Items: TRawUtf8DynArray;
!                        const Filter: RawUtf8): TRawUtf8DynArray;
!
!    // Object parameters (caller allocates)
!    procedure TransformCustomer(var Customer: TCustomer);
!
!    // Variant/TDocVariant for flexible JSON
!    function QueryData(const Params: Variant): Variant;
!
!    // Custom binary response
!    function GetReport(ReportID: Integer): TServiceCustomAnswer;
!  end;
{}
:  TServiceCustomAnswer
{}
For non-JSON responses (PDF, images, HTML):
{}
!function TMyService.GetReport(ReportID: Integer): TServiceCustomAnswer;
!begin
!  Result.Header := HEADER_CONTENT_TYPE + 'application/pdf';
!  Result.Content := GeneratePDF(ReportID);
!  Result.Status := HTTP_SUCCESS;
!end;
{}
{\b Note}: Methods returning {\f1\fs20 TServiceCustomAnswer} cannot have {\f1\fs20 var} or {\f1\fs20 out} parameters.
{}
:1603 Server-Side Implementation
{}
:  Implementing the Contract
{}
!type
!  TServiceCalculator = class(TInterfacedObject, ICalculator)
!  public
!    function Add(n1, n2: Integer): Integer;
!    function Multiply(n1, n2: Int64): Int64;
!  end;
!
!function TServiceCalculator.Add(n1, n2: Integer): Integer;
!begin
!  Result := n1 + n2;
!end;
!
!function TServiceCalculator.Multiply(n1, n2: Int64): Int64;
!begin
!  Result := n1 * n2;
!end;
{}
:  Registering the Service
{}
!// Using TypeInfo
!Server.ServiceRegister(TServiceCalculator, [TypeInfo(ICalculator)], sicShared);
!
!// Or using registered interface directly
!Server.ServiceDefine(TServiceCalculator, [ICalculator], sicShared);
{}
:  Instance Lifetime Modes
{}
|%8%72%20
|\b Mode|Description|Thread Safety\b0
|{\f1\fs20 sicSingle}|New instance per call (default, safest)|Not required
|{\f1\fs20 sicShared}|One instance for all calls (fastest)|{\b Required}
|{\f1\fs20 sicClientDriven}|Instance lives until client releases interface|Not required
|{\f1\fs20 sicPerSession}|One instance per authentication session|{\b Required}
|{\f1\fs20 sicPerUser}|One instance per user across sessions|{\b Required}
|{\f1\fs20 sicPerGroup}|One instance per user group|{\b Required}
|{\f1\fs20 sicPerThread}|One instance per server thread|Not required
|%
{}
#### Choosing the Right Mode
{}
|%76%24
|\b Use Case|Recommended Mode\b0
|Stateless operations, resource-intensive|{\f1\fs20 sicSingle}
|Simple stateless service, high throughput|{\f1\fs20 sicShared}
|Workflow with state between calls|{\f1\fs20 sicClientDriven}
|Session-specific caching|{\f1\fs20 sicPerSession}
|User preferences/settings|{\f1\fs20 sicPerUser}
|Group-level configuration|{\f1\fs20 sicPerGroup}
|Thread-local resources (e.g., database connection)|{\f1\fs20 sicPerThread}
|%
{}
:  Client-Driven Example
{}
!type
!  IComplexNumber = interface(IInvokable)
!    ['{29D753B2-E7EF-41B3-B7C3-827FEB082DC1}']
!    procedure Assign(aReal, aImaginary: Double);
!    function GetReal: Double;
!    procedure SetReal(const Value: Double);
!    function GetImaginary: Double;
!    procedure SetImaginary(const Value: Double);
!    procedure Add(aReal, aImaginary: Double);
!    property Real: Double read GetReal write SetReal;
!    property Imaginary: Double read GetImaginary write SetImaginary;
!  end;
!
!  TServiceComplexNumber = class(TInterfacedObject, IComplexNumber)
!  private
!    fReal, fImaginary: Double;
!  public
!    procedure Assign(aReal, aImaginary: Double);
!    function GetReal: Double;
!    procedure SetReal(const Value: Double);
!    function GetImaginary: Double;
!    procedure SetImaginary(const Value: Double);
!    procedure Add(aReal, aImaginary: Double);
!  end;
!
!// Registration
!Server.ServiceDefine(TServiceComplexNumber, [IComplexNumber], sicClientDriven);
{}
The server maintains {\f1\fs20 fReal} and {\f1\fs20 fImaginary} between calls until the client releases the interface.
{}
:1604 Accessing Execution Context
{}
:  Using TInjectableObjectRest
{}
The recommended approach — inherit from {\f1\fs20 TInjectableObjectRest}:
{}
!type
!  TMyService = class(TInjectableObjectRest, IMyService)
!  public
!    function GetCurrentUser: RawUtf8;
!    procedure LogActivity(const Action: RawUtf8);
!  end;
!
!function TMyService.GetCurrentUser: RawUtf8;
!begin
!  if Server <> nil then
!    Result := Server.SessionGetUser(Factory.CurrentSession).LogonName
!  else
!    Result := '';
!end;
!
!procedure TMyService.LogActivity(const Action: RawUtf8);
!begin
!  Server.Add(TOrmActivityLog, [
!    'Action', Action,
!    'User', GetCurrentUser,
!    'Timestamp', NowUtc
!  ]);
!end;
{}
Properties available:
- {\f1\fs20 Server: {\f1\fs20 @**TRestServer@}} — Access to ORM and server methods
- {\f1\fs20 Factory: {\f1\fs20 TServiceFactoryServer}} — Service factory instance
{}
:  Using ServiceRunningContext
{}
For services not inheriting from {\f1\fs20 TInjectableObjectRest}:
{}
!function TMyService.ProcessRequest: RawUtf8;
!var
!  Ctxt: PServiceRunningContext;
!begin
!  Ctxt := PerThreadRunningContextAddress;
!  if Ctxt^.Request <> nil then
!    Result := Ctxt^.Request.SessionUserName
!  else
!    Result := 'Unknown';
!end;
{}
{\b Note}: Prefer {\f1\fs20 TInjectableObjectRest} — it's safer and works outside client-server context.
{}
:1605 Client-Side Usage
{}
:  Registering the Interface
{}
!// Must match server-side mode
!Client.ServiceRegister([TypeInfo(ICalculator)], sicShared);
!
!// Or with registered interface
!Client.ServiceDefine([ICalculator], sicShared);
{}
:  Resolving and Using Services
{}
!var
!  Calc: ICalculator;
!begin
!  if Client.Services.Resolve(ICalculator, Calc) then
!    ShowMessage(IntToStr(Calc.Add(10, 20)));
!end;
{}
Generic syntax (Delphi 2010+):
!var
!  Calc: ICalculator;
!begin
!  Calc := Client.Service<ICalculator>;
!  if Calc <> nil then
!    ShowMessage(IntToStr(Calc.Add(10, 20)));
!end;
{}
:  Client-Driven Services
{}
!var
!  CN: IComplexNumber;
!begin
!  if Client.Services.Resolve(IComplexNumber, CN) then
!  begin
!    CN.Assign(0.01, 3.14);
!    CN.Add(100, 200);
!    ShowMessage(Format('%.2f + %.2fi', [CN.Real, CN.Imaginary]));
!  end;
!end; // CN released here → server instance also released
{}
:  Auto-Registration
{}
For {\f1\fs20 sicClientDriven}, explicit registration is optional:
!// This works without prior ServiceRegister call
!var
!  CN: IComplexNumber;
!begin
!  Client.Services.Info(IComplexNumber).Get(CN);  // Auto-registers as sicClientDriven
!end;
{}
:1606 Contract Validation
{}
:  Automatic Contract Hash
{}
By default, mORMot generates an MD5 hash of the interface signature:
- Method names
- Parameter types and directions
- Return types
{}
If client and server contracts don't match, connection fails with a clear error.
{}
:  Custom Contract Strings
{}
For explicit version control:
{}
!// Server
!Server.ServiceRegister(TMyService, [TypeInfo(IMyService)], sicShared)
!  .SetOptions([], 'v2.5');  // Contract = 'v2.5'
!
!// Client must match
!Client.ServiceRegister([TypeInfo(IMyService)], sicShared, 'v2.5');
{}
This allows:
- Semantic versioning
- Gradual client migration
- Clear compatibility rules
{}
:1607 Authorization and Security
{}
:  Per-Method Authorization
{}
!var
!  Factory: TServiceFactoryServer;
!begin
!  Factory := Server.Services.Info(ICalculator) as TServiceFactoryServer;
!
!  // Deny all by default
!  Factory.DenyAll;
!
!  // Allow specific groups by ID
!  Factory.Allow(ICalculator, [ADMIN_GROUP_ID]);
!
!  // Allow specific methods for other groups by name
!!  // Note: AllowByName takes group names (RawUtf8), not IDs
!  Factory.AllowByName(['Add', 'Multiply'], ['User', 'Guest']);
!end;
{}
:  Authentication Bypass
{}
For public methods:
{}
!Server.ServiceMethodByPassAuthentication('Calculator.GetVersion');
{}
:  Execution Options
{}
!Factory.SetOptions([optExecInMainThread]);  // Execute in main VCL thread
!Factory.SetOptions([optFreeInMainThread]);  // Free instance in main thread
!Factory.SetOptions([optExecInPerInterfaceThread]);  // Dedicated thread per interface
{}
:1608 Service Logging
{}
:  Enabling Logging
{}
!Factory.SetServiceLog(Server, TOrmServiceLog);
{}
This logs:
- Method name ({\f1\fs20 Interface.Method})
- Input parameters (JSON)
- Output parameters (JSON)
- Execution time (microseconds)
- Session/User context
{}
:  Custom Log Table
{}
!type
!  TOrmMyServiceLog = class(TOrmServiceLog)
!  published
!    property CustomField: RawUtf8 read fCustomField write fCustomField;
!  end;
!
!Factory.SetServiceLog(Server, TOrmMyServiceLog);
{}
:1609 Bidirectional Communication (Callbacks)
{}
:  Defining Callback Interfaces
{}
!type
!  // Callback interface (client implements this)
!  IProgressCallback = interface(IInvokable)
!    ['{A1B2C3D4-E5F6-7890-ABCD-EF1234567890}']
!    procedure Progress(Percent: Integer; const Status: RawUtf8);
!    procedure Completed(Success: Boolean);
!  end;
!
!  // Service interface
!  ILongRunningTask = interface(IInvokable)
!    ['{12345678-1234-1234-1234-123456789012}']
!    procedure StartTask(const TaskName: RawUtf8; const Callback: IProgressCallback);
!    procedure CancelTask(const TaskID: RawUtf8);
!  end;
{}
:  Server Implementation
{}
!type
!  TLongRunningTask = class(TInjectableObjectRest, ILongRunningTask)
!  public
!    procedure StartTask(const TaskName: RawUtf8; const Callback: IProgressCallback);
!    procedure CancelTask(const TaskID: RawUtf8);
!  end;
!
!procedure TLongRunningTask.StartTask(const TaskName: RawUtf8;
!  const Callback: IProgressCallback);
!begin
!  // Start background work
!  TThread.CreateAnonymousThread(
!    procedure
!    var
!      i: Integer;
!    begin
!      for i := 0 to 100 do
!      begin
!        Sleep(100);
!        Callback.Progress(i, Format('Processing %s...', [TaskName]));
!      end;
!      Callback.Completed(True);
!    end
!  ).Start;
!end;
{}
:  Client Implementation
{}
!type
!  TMyProgressCallback = class(TInterfacedCallback, IProgressCallback)
!  private
!    fForm: TForm;
!  public
!    constructor Create(aForm: TForm; aRest: TRestClientUri);
!    procedure Progress(Percent: Integer; const Status: RawUtf8);
!    procedure Completed(Success: Boolean);
!  end;
!
!constructor TMyProgressCallback.Create(aForm: TForm; aRest: TRestClientUri);
!begin
!  inherited Create(aRest, IProgressCallback);  // Register callback
!  fForm := aForm;
!end;
!
!procedure TMyProgressCallback.Progress(Percent: Integer; const Status: RawUtf8);
!begin
!  TThread.Queue(nil,
!    procedure
!    begin
!      fForm.ProgressBar.Position := Percent;
!      fForm.StatusLabel.Caption := Status;
!    end);
!end;
{}
:  Using WebSockets
{}
Callbacks require WebSocket transport:
{}
!// Server
!HttpServer := TRestHttpServer.Create('8080', [Server], '+', useHttpAsync);
!HttpServer.WebSocketsEnable(Server, 'privatekey');
!
!// Client
!Client := TRestHttpClientWebSockets.Create('localhost', '8080', Model);
!Client.WebSocketsConnect('privatekey');
!Client.ServiceDefine([ILongRunningTask], sicShared);
{}
:1610 Using Services on the Server
{}
:  Resolving Services
{}
!procedure TMyOtherService.DoSomething;
!var
!  Calc: ICalculator;
!begin
!  if Resolve(ICalculator, Calc) then
!    Result := Calc.Add(10, 20);
!end;
{}
:  Generic Syntax
{}
!procedure TMyOtherService.DoSomething;
!var
!  Calc: ICalculator;
!begin
!  Calc := Server.Service<ICalculator>;
!  if Calc <> nil then
!    Result := Calc.Add(10, 20);
!end;
{}
:1611 Complete Example
{}
:  Shared Interface Unit
{}
!unit ProjectInterface;
!
!interface
!
!uses
!  mormot.core.base,
!  mormot.core.interfaces;
!
!type
!  ICalculator = interface(IInvokable)
!    ['{9A60C8ED-CEB2-4E09-87D4-4A16F496E5FE}']
!    function Add(n1, n2: Integer): Integer;
!    function Multiply(n1, n2: Int64): Int64;
!  end;
!
!const
!  ROOT_NAME = 'api';
!  PORT_NAME = '8080';
!
!implementation
!
!initialization
!  TInterfaceFactory.RegisterInterfaces([TypeInfo(ICalculator)]);
!end.
{}
:  Server Application
{}
!program Server;
!
!{$APPTYPE CONSOLE}
!
!uses
!  mormot.core.base,
!  mormot.orm.core,
!  mormot.rest.server,
!  mormot.rest.memserver,
!  mormot.rest.http.server,
!  ProjectInterface;
!
!type
!  TServiceCalculator = class(TInterfacedObject, ICalculator)
!  public
!    function Add(n1, n2: Integer): Integer;
!    function Multiply(n1, n2: Int64): Int64;
!  end;
!
!function TServiceCalculator.Add(n1, n2: Integer): Integer;
!begin
!  Result := n1 + n2;
!end;
!
!function TServiceCalculator.Multiply(n1, n2: Int64): Int64;
!begin
!  Result := n1 * n2;
!end;
!
!var
!  Model: TOrmModel;
!  Server: TRestServerFullMemory;
!  HttpServer: TRestHttpServer;
!begin
!  Model := TOrmModel.Create([], ROOT_NAME);
!  Server := TRestServerFullMemory.Create(Model);
!  try
!    Server.ServiceDefine(TServiceCalculator, [ICalculator], sicShared);
!
!    HttpServer := TRestHttpServer.Create(PORT_NAME, [Server], '+', useHttpAsync);
!    try
!      WriteLn('Server running on http://localhost:', PORT_NAME);
!      WriteLn('Press Enter to stop...');
!      ReadLn;
!    finally
!      HttpServer.Free;
!    end;
!  finally
!    Server.Free;
!    Model.Free;
!  end;
!end.
{}
:  Client Application
{}
!program Client;
!
!{$APPTYPE CONSOLE}
!
!uses
!  mormot.core.base,
!  mormot.orm.core,
!  mormot.rest.client,
!  mormot.rest.http.client,
!  ProjectInterface;
!
!var
!  Model: TOrmModel;
!  Client: TRestHttpClientSocket;
!  Calc: ICalculator;
!begin
!  Model := TOrmModel.Create([], ROOT_NAME);
!  Client := TRestHttpClientSocket.Create('localhost', PORT_NAME, Model);
!  try
!    Client.ServiceDefine([ICalculator], sicShared);
!
!    if Client.Services.Resolve(ICalculator, Calc) then
!    begin
!      WriteLn('10 + 20 = ', Calc.Add(10, 20));
!      WriteLn('10 * 20 = ', Calc.Multiply(10, 20));
!    end
!    else
!      WriteLn('Service not available');
!  finally
!    Client.Free;
!    Model.Free;
!  end;
!end.
{}
: Summary
{}
Interface-based services in mORMot 2 provide:
{}
- {\b Clean contracts} via Pascal interfaces
- {\b Automatic marshalling} of complex types to/from JSON
- {\b Multiple instance modes} for different use cases
- {\b Contract validation} ensuring client/server compatibility
- {\b Per-method authorization} with user groups
- {\b Bidirectional communication} via WebSocket callbacks
- {\b Execution logging} to database
- {\b Dependency injection} via {\f1\fs20 TInjectableObjectRest}
{}
For most applications, interface-based services are the recommended approach. They provide the structure, safety, and features needed for robust SOA while keeping implementation simple and type-safe.
{}