; Converted from Markdown - Chapter 18
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:18The MVC Pattern
{}
{\i Separating Concerns for Better Architecture}
{}
The Model-View-Controller (@*MVC@) pattern separates application concerns into three interconnected components. m@*ORM@ot 2 provides a complete MVC implementation for both desktop and web applications, with the Mustache template engine as its primary view technology.
{}
:1801 MVC Architecture Overview
{}
:  The Three Components
{}
|%15%34%51
|\b Component|Responsibility|mORMot Implementation\b0
|{\b Model}|Data and business logic|{\f1\fs20 TOrm} classes, {\f1\fs20 TOrmModel}, {\f1\fs20 TRest}
|{\b View}|Presentation layer|Mustache templates ({\f1\fs20 .html}), Desktop UI
|{\b Controller}|User input handling|{\f1\fs20 IMvcApplication} interface methods
|%
{}
:  Benefits of MVC
{}
- {\b Separation of concerns}: Each component has a single responsibility
- {\b Testability}: Logic can be tested without UI
- {\b Reusability}: Same model for different views
- {\b Maintainability}: Changes in one layer don't affect others
- {\b Team collaboration}: Designers work on views, developers on logic
{}
:  mORMot's MVC Stack
{}
$┌──────────────────────────────────────────────┐
$│                    View                      │
$│  Mustache templates (.html) or Desktop UI    │
$├──────────────────────────────────────────────┤
$│                 Controller                   │
$│  IMvcApplication interface implementation    │
$├──────────────────────────────────────────────┤
$│                   Model                      │
$│     TOrm classes + TRest ORM/SOA             │
$└──────────────────────────────────────────────┘
{}
:1802 The Model Layer
{}
:  ORM as the Model
{}
In mORMot, the Model is your ORM classes and the {\f1\fs20 TOrmModel}:
{}
!type
!  TOrmAuthor = class(TOrm)
!  private
!    fName: RawUtf8;
!    fEmail: RawUtf8;
!  published
!    property Name: RawUtf8 index 100 read fName write fName;
!    property Email: RawUtf8 index 100 read fEmail write fEmail;
!  end;
!
!  TOrmArticle = class(TOrmTimestamped)
!  private
!    fTitle: RawUtf8;
!    fContent: RawUtf8;
!    fAuthor: TOrmAuthor;
!    fPublished: Boolean;
!  published
!    property Title: RawUtf8 index 200 read fTitle write fTitle;
!    property Content: RawUtf8 read fContent write fContent;
!    property Author: TOrmAuthor read fAuthor write fAuthor;
!    property Published: Boolean read fPublished write fPublished;
!  end;
!
!function CreateBlogModel: TOrmModel;
!begin
!  Result := TOrmModel.Create([TOrmAuthor, TOrmArticle], 'blog');
!end;
{}
:  Model Best Practices
{}
1. {\b Keep models focused}: Each {\f1\fs20 TOrm} class represents one entity
2. {\b Use class hierarchy}: Share common properties via inheritance
3. {\b Define indexes}: Override {\f1\fs20 InitializeTable} for performance
4. {\b Add validation}: Use {\f1\fs20 AddFilterNotVoidText} and similar methods
5. {\b Document relationships}: One-to-many, many-to-many via properties
{}
!class procedure TOrmArticle.InitializeTable(const Server: IRestOrmServer;
!  const FieldName: RawUtf8; Options: TOrmInitializeTableOptions);
!begin
!  inherited;
!  if (FieldName = '') or (FieldName = 'Author') then
!    Server.CreateSqlIndex(TOrmArticle, 'Author', False);
!end;
{}
:1803 The View Layer
{}
mORMot provides two view technologies:
{}
:  Desktop Views (RTTI-based)
{}
For desktop applications, UI can be generated from @*RTTI@:
{}
!type
!  TBlogAction = (
!    baNewArticle,
!    baEditArticle,
!    baDeleteArticle,
!    baQuit
!  );
!
!const
!  ToolbarActions: array[0..1] of set of TBlogAction = (
!    [baNewArticle, baEditArticle, baDeleteArticle],
!    [baQuit]
!  );
{}
Benefits:
- {\b Camel Case to labels}: {\f1\fs20 baNewArticle} becomes "New Article"
- {\b Automatic i18n}: Labels can be translated
- {\b Type safety}: Compiler checks action names
- {\b Code-first}: UI defined in code, not visual designer
{}
:  Web Views (Mustache Templates)
{}
For web applications, Mustache templates provide logic-less rendering:
{}
$<!-- ArticleView.html -->
$<article>
$  <h1>{{Article.Title}}</h1>
$  <p class="meta">By {{Author.Name}} on {{Article.CreatedAt}}</p>
$  <div class="content">
$    {{{Article.Content}}}
$  </div>
$
$  {{#WithComments}}
$  <section class="comments">
$    <h2>Comments</h2>
$    {{#Comments}}
$    <div class="comment">
$      <strong>{{Title}}</strong>
$      <p>{{Content}}</p>
$    </div>
$    {{/Comments}}
$    {{^Comments}}
$    <p>No comments yet.</p>
$    {{/Comments}}
$  </section>
$  {{/WithComments}}
$</article>
{}
:1804 The Mustache Template Engine
{}
:  Why Mustache?
{}
Mustache is a {\b logic-less} template system:
- No {\f1\fs20 if} statements or loops in templates
- Data context determines what renders
- Clean separation of logic and presentation
- Same templates work client-side (JavaScript) and server-side
{}
:  Basic Syntax
{}
|%8%92
|\b Tag|Purpose\b0
|{\f1\fs20 {{variable}}}|HTML-escaped output
|{\f1\fs20 {{{variable}}}}|Unescaped output (raw HTML)
|{\f1\fs20 {{#section}}...{{/section}}}|Section (conditional/loop)
|{\f1\fs20 {{^section}}...{{/section}}}|Inverted section (if false/empty)
|{\f1\fs20 {{! comment }}}|Comment (not rendered)
|{\f1\fs20 {{> partial}}}|Include partial template
|%
{}
:  Variables
{}
$Hello {{name}}!
$You have {{count}} messages.
{}
With context:
${"name": "John", "count": 5}
{}
Renders:
!Hello John!
!You have 5 messages.
{}
:  Sections
{}
Sections render based on the truthiness of the key:
{}
${{#hasMessages}}
$  <ul>
$  {{#messages}}
$    <li>{{subject}}</li>
$  {{/messages}}
$  </ul>
${{/hasMessages}}
$
${{^hasMessages}}
$  <p>No messages.</p>
${{/hasMessages}}
{}
{\b Section behavior:}
- {\f1\fs20 false} or empty array {\f1\fs20 []}: Block not rendered
- Non-false value: Block rendered once (context switches to value)
- Non-empty array: Block rendered for each item
{}
:  mORMot Extensions
{}
mORMot adds useful features to standard Mustache:
{}
|%8%92
|\b Tag|Description\b0
|{\f1\fs20 {{.}}}|Current context value
|{\f1\fs20 {{-index}}}|Current iteration index (1-based)
|{\f1\fs20 {{-index0}}}|Current iteration index (0-based)
|{\f1\fs20 {{#-first}}...{{/-first}}}|First item in loop
|{\f1\fs20 {{#-last}}...{{/-last}}}|Last item in loop
|{\f1\fs20 {{#-odd}}...{{/-odd}}}|Odd items (for zebra striping)
|{\f1\fs20 {{<partial}}...{{/partial}}}|Inline partial definition
|{\f1\fs20 {{"text}}}|Translatable text
|{\f1\fs20 {{helperName value}}}|Expression helpers
|%
{}
:  Expression Helpers
{}
Register helpers for common transformations:
{}
!// Built-in helpers
!{{DateTimeToText Article.CreatedAt}}
!{{TimeLogToText Article.ModifiedAt}}
!{{EnumToCaption Article.Status}}
!{{BlobToBase64 Article.Image}}
!
!// Custom helper registration
!TSynMustache.HelpersGetStandardList.Add(
!  'FormatCurrency',
!  procedure(const Value: variant; out Result: variant)
!  begin
!    Result := FormatFloat('$#,##0.00', Value);
!  end
!);
{}
:  ORM Integration
{}
Register ORM classes as expression helpers:
{}
!RegisterExpressionHelpersForTables(Views, RestServer, [TOrmAuthor, TOrmArticle]);
{}
Then in templates:
${{#TOrmAuthor Article.AuthorID}}
$  Author: {{Name}} ({{Email}})
${{/TOrmAuthor Article.AuthorID}}
{}
The {\f1\fs20 TOrmAuthor} helper automatically loads the record by ID.
{}
:1805 The Controller Layer
{}
:  Defining Commands
{}
The Controller is defined as an interface:
{}
!type
!  IMvcApplication = interface(IInvokable)
!    ['{C48718BF-861B-448A-B593-8012DB51E15D}']
!    procedure Default(var Scope: variant);
!    procedure Error(var Msg: RawUtf8; var Scope: variant);
!  end;
!
!  IBlogApplication = interface(IMvcApplication)
!    ['{12345678-1234-1234-1234-123456789ABC}']
!    procedure ArticleView(ID: Integer; var WithComments: Boolean;
!      out Article: TOrmArticle; out Author: variant; out Comments: TObjectList);
!    procedure AuthorView(var ID: Integer; out Author: TOrmAuthor;
!      out Articles: variant);
!    function Login(const LogonName, Password: RawUtf8): TMvcAction;
!    function Logout: TMvcAction;
!  end;
{}
:  Parameter Directions
{}
|%25%75
|\b Direction|Meaning\b0
|{\f1\fs20 const}|Input only (from URL/form)
|{\f1\fs20 var}|Input and output
|{\f1\fs20 out}|Output only (to view)
|{\f1\fs20 function: {\f1\fs20 TMvcAction}}|Redirect action
|%
{}
:  URI Mapping
{}
Methods map to URIs automatically:
{}
|%67%33
|\b Method|URI\b0
|{\f1\fs20 Default}|{\f1\fs20 /blog/default}
|{\f1\fs20 Error}|{\f1\fs20 /blog/error}
|{\f1\fs20 ArticleView}|{\f1\fs20 /blog/articleView?id=123&withComments=true}
|{\f1\fs20 Login}|{\f1\fs20 /blog/login?logonName=john&password=xxx}
|%
{}
:  Implementing the Controller
{}
!type
!  TBlogApplication = class(TMvcApplicationRest, IBlogApplication)
!  public
!    procedure Start(aRestModel: TRest; aInterface: PRttiInfo); override;
!    procedure Default(var Scope: variant);
!    procedure ArticleView(ID: Integer; var WithComments: Boolean;
!      out Article: TOrmArticle; out Author: variant; out Comments: TObjectList);
!    function Login(const LogonName, Password: RawUtf8): TMvcAction;
!  end;
!
!procedure TBlogApplication.ArticleView(ID: Integer; var WithComments: Boolean;
!  out Article: TOrmArticle; out Author: variant; out Comments: TObjectList);
!begin
!  RestModel.Orm.Retrieve(ID, Article);
!  if Article.ID = 0 then
!    raise EMvcApplication.CreateGotoError(HTTP_NOTFOUND);
!
!  Author := RestModel.Orm.RetrieveDocVariant(
!    TOrmAuthor, 'ID=?', [Article.Author.ID], 'Name,Email');
!
!  if WithComments then
!  begin
!    Comments.Free;
!    Comments := RestModel.Orm.RetrieveList(TOrmComment, 'Article=?', [ID]);
!  end;
!end;
!
!function TBlogApplication.Login(const LogonName, Password: RawUtf8): TMvcAction;
!begin
!  if ValidateCredentials(LogonName, Password) then
!  begin
!    CurrentSession.User := LogonName;
!    Result.RedirectToMethodName := 'Default';
!  end
!  else
!    raise EMvcApplication.CreateGotoError('Invalid credentials');
!end;
{}
:  TMvcAction for Redirects
{}
Methods returning {\f1\fs20 TMvcAction} don't render a view directly:
{}
!type
!  TMvcAction = record
!    RedirectToMethodName: RawUtf8;
!    RedirectToMethodParameters: RawUtf8;
!    ReturnedStatus: Cardinal;
!  end;
!
!function TBlogApplication.Logout: TMvcAction;
!begin
!  CurrentSession.Clear;
!  Result.RedirectToMethodName := 'Default';
!  // or: Result.ReturnedStatus := HTTP_TEMPORARYREDIRECT;
!end;
{}
:  Error Handling
{}
Raise {\f1\fs20 EMvcApplication} to redirect to error page:
{}
!// Redirect to error page with message
!raise EMvcApplication.CreateGotoError('Article not found');
!
!// Redirect to error page with HTTP status
!raise EMvcApplication.CreateGotoError(HTTP_NOTFOUND);
!
!// Redirect to another method
!raise EMvcApplication.CreateGotoMethod('Login');
{}
:1806 View Templates
{}
:  Template Location
{}
By default, templates are in a {\f1\fs20 Views} subfolder:
{}
!MyApp/
$├── MyApp.exe
$└── Views/
$    ├── Default.html
$    ├── Error.html
$    ├── ArticleView.html
$    ├── AuthorView.html
$    └── _partials/
$        ├── header.html
$        └── footer.html
{}
:  Template Structure
{}
$<!-- Default.html -->
${{>header}}
$
$<main>
$  <h1>{{Scope.Title}}</h1>
$
$  {{#Scope.Articles}}
$  <article>
$    <h2><a href="/blog/articleView?id={{ID}}">{{Title}}</a></h2>
$    <p>{{Abstract}}</p>
$    <small>{{DateTimeToText CreatedAt}}</small>
$  </article>
$  {{/Scope.Articles}}
$
$  {{^Scope.Articles}}
$  <p>No articles published yet.</p>
$  {{/Scope.Articles}}
$</main>
$
${{>footer}}
{}
:  Partials
{}
Define reusable template fragments:
{}
$<!-- _partials/header.html -->
$<!DOCTYPE html>
$<html>
$<head>
$  <title>{{Main.Title}} - My Blog</title>
$  <link rel="stylesheet" href="/static/style.css">
$</head>
$<body>
$  <nav>
$    <a href="/blog/default">Home</a>
$    {{#Main.User}}
$    <a href="/blog/logout">Logout ({{.}})</a>
$    {{/Main.User}}
$    {{^Main.User}}
$    <a href="/blog/login">Login</a>
$    {{/Main.User}}
$  </nav>
{}
:  Static Files
{}
Serve static content alongside templates:
{}
!// Enable static file serving
!fMainRunner := TMvcRunOnRestServer.Create(Self, '', Server, 'blog', nil,
!  [publishMvcInfo, publishStatic, bypassAuthentication]);
{}
Static files served from {\f1\fs20 .static} subfolder at {\f1\fs20 /blog/.static/*}.
{}
:1807 Session Management
{}
:  Cookie-Based Sessions
{}
MVC applications use cookie sessions:
{}
!type
!  TMvcSessionWithRestServer = class(TMvcSessionWithCookies)
!  protected
!    function GetCookie(out Value: PUtf8Char): Integer; override;
!    procedure SetCookie(const Value: RawUtf8); override;
!  end;
{}
:  Session Data
{}
Access session data in controllers:
{}
!procedure TBlogApplication.Default(var Scope: variant);
!begin
!  // Read session data
!  if CurrentSession['LoggedIn'] then
!    Scope := _ObjFast(['User', CurrentSession['UserName']]);
!end;
!
!function TBlogApplication.Login(const LogonName, Password: RawUtf8): TMvcAction;
!begin
!  if ValidateUser(LogonName, Password) then
!  begin
!    CurrentSession['LoggedIn'] := True;
!    CurrentSession['UserName'] := LogonName;
!    CurrentSession['UserID'] := GetUserID(LogonName);
!    Result.RedirectToMethodName := 'Default';
!  end;
!end;
{}
:1808 Debugging MVC Applications
{}
:  The mvc-info Page
{}
Access {\f1\fs20 /blog/mvc-info} to see:
- All registered commands
- Parameter types and directions
- View data context structure
{}
!/blog/Default?Scope=..[variant]..
!/blog/Error?Msg=..[string]..&Scope=..[variant]..
!/blog/ArticleView?ID=..[integer]..&WithComments=..[boolean]..
!
!ArticleView context:
!{{WithComments}}: boolean
!{{Article}}: TOrmArticle
!{{Author}}: variant
!{{Comments}}: TObjectList
{}
:  JSON Context View
{}
Append {\f1\fs20 /json} to any URL to see the raw data context:
{}
!/blog/articleView?id=123           → HTML page
!/blog/articleView/json?id=123      → JSON data context
{}
: Summary
{}
The MVC pattern in mORMot 2 provides:
{}
- {\b Model}: {\f1\fs20 TOrm} classes with full ORM capabilities
- {\b View}: Mustache templates for logic-less rendering
- {\b Controller}: Interface methods mapped to URIs
{}
Key features:
- {\b Automatic routing}: Methods become URIs
- {\b Type-safe parameters}: Compile-time checking
- {\b Expression helpers}: Transform data in templates
- {\b Session management}: Cookie-based state
- {\b Debug tools}: mvc-info and @*JSON@ context views
{}
This architecture cleanly separates concerns while providing the power of mORMot's ORM and @*SOA@ capabilities.
{}