; Converted from Markdown - Chapter 21
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:21Security
{}
{\i Authentication, Authorization, and Process Safety}
{}
m@*ORM@ot implements a comprehensive security architecture through three complementary layers: process safety, authentication, and authorization. This chapter covers the security mechanisms built into the framework.
{}
:2101 Security Overview
{}
:  The Three Pillars
{}
$┌─────────────────────────────────────────────────────────────────┐
$│                    Security Architecture                        │
$├─────────────────────────────────────────────────────────────────┤
$│                                                                 │
$│  ┌───────────────┐  ┌───────────────┐  ┌───────────────┐        │
$│  │ Process       │  │ Authentication│  │ Authorization │        │
$│  │ Safety        │  │ (Who?)        │  │ (What?)       │        │
$│  ├───────────────┤  ├───────────────┤  ├───────────────┤        │
$│  │ • Encryption  │  │ • Sessions    │  │ • Per-table   │        │
$│  │ • ACID DB     │  │ • Signatures  │  │ • Per-service │        │
$│  │ • Stateless   │  │ • SSPI/Kerb   │  │ • Per-method  │        │
$│  │ • Type safety │  │ • JWT         │  │ • Groups      │        │
$│  │ • Testing     │  │ • HTTP Basic  │  │ • Access bits │        │
$│  └───────────────┘  └───────────────┘  └───────────────┘        │
$│                                                                 │
$└─────────────────────────────────────────────────────────────────┘
{}
:  Security Principles
{}
|%46%54
|\b Principle|Implementation\b0
|Defense in depth|Multiple security layers
|Least privilege|Group-based access rights
|Fail secure|Reject by default
|No security by obscurity|Published algorithms
|Session management|Server-side session tracking
|%
{}
:2102 Process Safety
{}
:  Built-in Safety Mechanisms
{}
mORMot provides process safety at every architectural level:
{}
{\b Encryption:}
- AES-256 encryption for sensitive data
- @*HTTP@S support for transport security
- Optional AES encryption over HTTP (deprecated, use {\f1\fs20 TLS})
{}
{\b Database Integrity:}
- @*SQLite3@ @*ACID@ transactions
- Atomic operations
- Safe concurrent access
{}
{\b Stateless Architecture:}
- Each request is independent
- Session tokens for state identification
- No server-side state dependency
{}
{\b Type Safety:}
- Strong Pascal typing
- ORM type validation
- @*JSON@ schema enforcement
{}
:2103 Authentication
{}
:  Authentication Concepts
{}
Authentication confirms user identity. mORMot supports multiple authentication schemes:
{}
|%35%12%19%34
|\b Scheme|Class|Security|Use Case\b0
|mORMot Default|{\f1\fs20 TRestServerAuthenticationDefault}|★★★★|Delphi clients
|SSPI/Kerberos|{\f1\fs20 TRestServerAuthenticationSspi}|★★★★|Windows domain
|HTTP Basic|{\f1\fs20 TRestServerAuthenticationHttpBasic}|★★|Browser/legacy
|None|{\f1\fs20 TRestServerAuthenticationNone}|★|Testing only
|@*JWT@|Via {\f1\fs20 JwtForUnauthenticatedRequest}|★★★|Public APIs
|%
{}
:  Enabling Authentication
{}
!uses
!  mormot.rest.sqlite3,
!  mormot.rest.server;
!
!var
!  Server: TRestServerDB;
!begin
!  // Create server WITH authentication enabled
!  Server := TRestServerDB.Create(Model, 'data.db3', True);  // aHandleUserAuthentication = True
!  try
!    Server.CreateMissingTables;  // Creates AuthUser/AuthGroup tables
!    // Server now requires authentication
!  finally
!    Server.Free;
!  end;
!end;
{}
The {\f1\fs20 True} parameter enables:
- {\f1\fs20 TAuthUser} and {\f1\fs20 TAuthGroup} tables
- Session management
- Default authentication schemes
{}
:  Authentication Classes
{}
!TRestServerAuthentication (abstract)
$├── TRestServerAuthenticationSignedUri
$│   ├── TRestServerAuthenticationDefault   → mORMot secure challenge
$│   └── TRestServerAuthenticationSspi      → Windows SSPI/Kerberos │
$├── TRestServerAuthenticationNone          → Weak (username only)
$└── TRestServerAuthenticationHttpAbstract
$    └── TRestServerAuthenticationHttpBasic → HTTP Basic (Base64)
{}
:2104 Default mORMot Authentication
{}
:  Challenge-Response Protocol
{}
The default authentication uses a secure two-pass challenge:
{}
!Client                                    Server
$  │                                         │
$  │  GET /auth?UserName=John               │
$  ├────────────────────────────────────────►│
$  │                                         │
$  │  {"result":"<hex_nonce>"}              │
$  │◄────────────────────────────────────────┤
$  │                                         │
$  │  GET /auth?UserName=John&              │
$  │      Password=<computed>&              │
$  │      ClientNonce=<random>              │
$  ├────────────────────────────────────────►│
$  │                                         │
$  │  {"result":"SessionID+PrivateKey",     │
$  │   "logonname":"John"}                  │
$  │◄────────────────────────────────────────┤
$  │                                         │
$  │  All requests now include:             │
$  │  ?session_signature=XXXX               │
$  ├────────────────────────────────────────►│
{}
:  Password Computation
{}
The password sent is computed as:
{}
!Password = SHA256(ModelRoot + ServerNonce + ClientNonce + UserName +
!                  SHA256('salt' + PlainPassword))
{}
This ensures:
- Password never transmitted in clear
- Replay attacks prevented by nonces
- Server doesn't store plain password
{}
:  Session Signature
{}
Each authenticated request includes a signature:
{}
!session_signature = Hexa8(SessionID) +
!                   Hexa8(Timestamp) +
!                   Hexa8(CRC32(SessionID + PrivateKey +
!                               SHA256('salt' + Password) +
!                               Timestamp + URL))
{}
Example URL:
!root/Customer/123?session_signature=0000004C000F6DD02E24541C
!                                    ^^^^^^^^ ^^^^^^^^ ^^^^^^^^
!                                    SessionID Timestamp Signature
{}
:  Client Authentication
{}
!uses
!  mormot.rest.http.client;
!
!var
!  Client: TRestHttpClientWinHTTP;
!begin
!  Client := TRestHttpClientWinHTTP.Create('localhost', '8080', Model);
!  try
!    // Authenticate with username/password
!    if not Client.SetUser('Admin', 'synopse') then
!      raise Exception.Create('Authentication failed');
!
!    // All subsequent requests are signed automatically
!    Client.Orm.Retrieve(ID, Customer);
!  finally
!    Client.Free;
!  end;
!end;
{}
:  Signature Algorithm Options
{}
!// Configure signature algorithm (server-side)
!(Server.AuthenticationRegister(TRestServerAuthenticationDefault) as
!  TRestServerAuthenticationSignedUri).Algorithm := suaSHA256;
{}
Available algorithms:
{}
|%17%9%15%59
|\b Algorithm|Speed|Security|Notes\b0
|{\f1\fs20 suaCRC32}|★★★★|★★|Default, fast
|{\f1\fs20 suaMD5}|★★★|★★|Legacy
|{\f1\fs20 suaSHA256}|★★|★★★★|Recommended for high security
|{\f1\fs20 suaSHA512}|★|★★★★|Highest security
|{\f1\fs20 suaSHA3}|★★|★★★★|Modern
|%
{}
:  Timestamp Tolerance
{}
!// For AJAX clients with network latency
!(Server.AuthenticationRegister(TRestServerAuthenticationDefault) as
!  TRestServerAuthenticationSignedUri).NoTimestampCoherencyCheck := true;
!
!// Or adjust tolerance (default: 5 seconds)
!(Server.AuthenticationRegister(TRestServerAuthenticationDefault) as
!  TRestServerAuthenticationSignedUri).TimestampCoherencySeconds := 10;
{}
:2105 Windows Authentication (SSPI)
{}
:  SSPI Overview
{}
SSPI allows using Windows credentials without entering username/password:
{}
!uses
!  mormot.rest.http.client;
!
!var
!  Client: TRestHttpClientWinHTTP;
!begin
!  Client := TRestHttpClientWinHTTP.Create('server', '8080', Model);
!  try
!    // Empty username = use Windows credentials
!    Client.SetUser('', '');  // NTLM authentication
!
!    // Or with Kerberos SPN
!    Client.SetUser('', 'mymormotservice/myserver.mydomain.tld');
!  finally
!    Client.Free;
!  end;
!end;
{}
:  Kerberos Setup
{}
For Kerberos authentication, register an SPN:
{}
$rem Register SPN for service running under SYSTEM account
$setspn -a mymormotservice/myserver.mydomain.tld myserver
$
$rem Register SPN for service running under domain account
$setspn -a mymormotservice/myserver.mydomain.tld myserviceaccount
{}
:  User Mapping
{}
SSPI-authenticated users must exist in {\f1\fs20 TAuthUser}:
{}
!// User.LogonName must match 'DOMAIN\Username'
!User := TAuthUser.Create;
!try
!  User.LogonName := 'MYDOMAIN\JohnDoe';
!  User.DisplayName := 'John Doe';
!  User.GroupRights := TAuthGroup(AdminGroupID);
!  Server.Orm.Add(User, true);
!finally
!  User.Free;
!end;
{}
:2106 HTTP Basic Authentication
{}
:  Browser Compatibility
{}
For browser clients or legacy systems:
{}
!// Server: Register HTTP Basic
!Server.AuthenticationRegister(TRestServerAuthenticationHttpBasic);
!
!// Client: Use HTTP Basic
!TRestServerAuthenticationHttpBasic.ClientSetUser(Client, 'User', 'password');
{}
{\b Warning:} HTTP Basic sends credentials as Base64 (not encrypted). Always use @*HTTPS@!
{}
:  Proxy-Only Authentication
{}
For authentication without creating a mORMot session:
{}
!// Client-side only, for proxy authentication
!TRestServerAuthenticationHttpBasic.ClientSetUserHttpOnly(
!  Client, 'proxyUser', 'proxyPass');
{}
:2107 JWT Authentication
{}
:  JWT for Public APIs
{}
JWT provides stateless authentication for public APIs:
{}
!uses
!  mormot.crypt.jwt,
!  mormot.rest.server;
!
!var
!  Server: TRestServerDB;
!  JwtEngine: TJwtHS256;
!begin
!  Server := TRestServerDB.Create(Model, 'data.db3', False);  // No session auth
!
!  // Configure JWT validation
!  JwtEngine := TJwtHS256.Create(
!    'my-secret-key-at-least-32-bytes!',  // Secret
!    60000,                                 // Clock tolerance ms
!    [jrcIssuer, jrcExpirationTime],       // Required claims
!    [],                                    // Audience (optional)
!    60                                     // Expiration minutes
!  );
!  Server.JwtForUnauthenticatedRequest := JwtEngine;  // Server owns it
!
!  // Optionally restrict to specific IPs
!  Server.JwtForUnauthenticatedRequestWhiteIP := '192.168.1.0/24';
!end;
{}
:  Client JWT Usage
{}
!// Obtain JWT from your authentication service
!var Token: RawUtf8 := GetJwtFromAuthService('user', 'pass');
!
!// Set as HTTP header
!Client.SessionHttpHeader := AuthorizationBearer(Token);
!
!// All requests now include: Authorization: Bearer <token>
{}
:  JWT Algorithms
{}
|%17%49%34
|\b Class|Algorithm|Key Type\b0
|{\f1\fs20 TJwtHS256}|HMAC-SHA256|Symmetric
|{\f1\fs20 TJwtHS384}|HMAC-SHA384|Symmetric
|{\f1\fs20 TJwtHS512}|HMAC-SHA512|Symmetric
|{\f1\fs20 TJwtES256}|ECDSA P-256|Asymmetric
|{\f1\fs20 TJwtRS256}|RSA-SHA256|Asymmetric
|{\f1\fs20 TJwtPS256}|RSA-PSS-SHA256|Asymmetric
|%
{}
:2108 TAuthUser and TAuthGroup
{}
:  TAuthGroup Structure
{}
!TAuthGroup = class(TOrm)
!published
!  property Ident: RawUtf8;           // Group name ('Admin', 'User', etc.)
!  property SessionTimeout: integer;   // Session timeout in minutes
!  property AccessRights: RawUtf8;     // CSV-encoded TOrmAccessRights
!end;
{}
:  TAuthUser Structure
{}
!TAuthUser = class(TOrm)
!published
!  property LogonName: RawUtf8;       // Login identifier
!  property DisplayName: RawUtf8;      // Display name
!  property PasswordHashHexa: RawUtf8; // SHA-256 hash of password
!  property GroupRights: TAuthGroup;   // Associated group
!  property Data: RawBlob;            // Custom application data
!end;
{}
:  Default Groups
{}
When authentication is enabled, these groups are created automatically:
{}
|%19%12%15%9%9%12%12%12
|\b Group|POST SQL|SELECT SQL|Auth R|Auth W|Tables R|Tables W|Services\b0
|Admin|✓|✓|✓|✓|✓|✓|✓
|Supervisor|✗|✓|✓|✗|✓|✓|✓
|User|✗|✗|✗|✗|✓|✓|✓
|Guest|✗|✗|✗|✗|✓|✗|✗
|%
{}
{\b Important:} Default password for all users is {\f1\fs20 synopse}. Change immediately in production!
{}
:  Creating Custom Users
{}
!var
!  User: TAuthUser;
!  Group: TAuthGroup;
!begin
!  // Find or create group
!  Group := TAuthGroup.Create;
!  try
!    if not Server.Orm.Retrieve('Ident=?', [], ['CustomGroup'], Group) then
!    begin
!      Group.Ident := 'CustomGroup';
!      Group.SessionTimeout := 30;
!      Group.OrmAccessRights := SUPERVISOR_ACCESS_RIGHTS;
!      Server.Orm.Add(Group, true);
!    end;
!
!    // Create user
!    User := TAuthUser.Create;
!    try
!      User.LogonName := 'newuser';
!      User.DisplayName := 'New User';
!      User.SetPasswordPlain('secure_password');
!      User.GroupRights := TAuthGroup(Group.ID);
!      Server.Orm.Add(User, true);
!    finally
!      User.Free;
!    end;
!  finally
!    Group.Free;
!  end;
!end;
{}
:  Password Hashing
{}
!// Simple SHA-256 (mORMot 1 compatible)
!User.SetPasswordPlain('password');  // Uses SHA256('salt' + password)
!
!// PBKDF2-HMAC-SHA256 (more secure)
!User.SetPassword('password', 'unique-salt', 10000);  // 10000 rounds
{}
:2109 Authorization
{}
:  TOrmAccessRights
{}
Authorization is controlled by {\f1\fs20 TOrmAccessRights}:
{}
!TOrmAccessRights = record
!  AllowRemoteExecute: TOrmAllowRemoteExecute;  // SQL/service flags
!  GET: TOrmTableBits;    // Read access per table
!  POST: TOrmTableBits;   // Create access per table
!  PUT: TOrmTableBits;    // Update access per table
!  DELETE: TOrmTableBits; // Delete access per table
!end;
{}
:  AllowRemoteExecute Flags
{}
!TOrmAllowRemoteExecute = set of (
!  reSQL,                    // Allow POST with SQL statements
!  reSQLSelectWithoutTable,  // Allow complex SELECT (JOINs)
!  reService,                // Allow interface-based services
!  reUrlEncodedSQL,          // Allow SQL in URL parameters
!  reUrlEncodedDelete,       // Allow DELETE with WHERE clause
!  reOneSessionPerUser       // Enforce single session per user
!);
{}
:  Predefined Access Rights
{}
!const
!  // Full access (use only for local/in-process)
!  FULL_ACCESS_RIGHTS: TOrmAccessRights = (
!    AllowRemoteExecute: [reSQL, reSQLSelectWithoutTable,
!                         reService, reUrlEncodedSQL,
!                         reUrlEncodedDelete];
!    GET: ALL_ACCESS_RIGHTS;
!    POST: ALL_ACCESS_RIGHTS;
!    PUT: ALL_ACCESS_RIGHTS;
!    DELETE: ALL_ACCESS_RIGHTS;
!  );
!
!  // Admin access (remote, with SQL)
!  ADMIN_ACCESS_RIGHTS: TOrmAccessRights = (
!    AllowRemoteExecute: [reSQL, reSQLSelectWithoutTable, reService];
!    // ...
!  );
!
!  // Supervisor access (remote, SELECT only)
!  SUPERVISOR_ACCESS_RIGHTS: TOrmAccessRights = (
!    AllowRemoteExecute: [reSQLSelectWithoutTable, reService];
!    // ...
!  );
{}
:  Per-Table Access Control
{}
!var
!  Rights: TOrmAccessRights;
!begin
!  // Start with no access
!  FillChar(Rights, SizeOf(Rights), 0);
!  Rights.AllowRemoteExecute := [reService];
!
!  // Grant full CRUD on Customer table
!  Rights.Edit(Model, TCustomer, True, True, True, True);  // C, R, U, D
!
!  // Grant read-only on Order table
!  Rights.Edit(Model, TOrder, False, True, False, False);  // R only
!
!  // Apply to group
!  Group.OrmAccessRights := Rights;
!end;
{}
:  Service Authorization
{}
For interface-based services:
{}
!// Disable authentication for specific service
!Server.ServiceDefine(TMyPublicService, [IMyPublicService], sicShared)
!      .ByPassAuthentication := True;
!
!// Or restrict to specific groups
!Server.ServiceDefine(TMyAdminService, [IMyAdminService], sicShared)
!      .AllowedGroups := [1];  // Group ID 1 only (Admin)
{}
For method-based services:
{}
!// Bypass authentication for specific method
!Server.ServiceMethodByPassAuthentication('Timestamp');
!Server.ServiceMethodByPassAuthentication('Auth');
{}
:2110 Session Management
{}
:  Session Storage
{}
Sessions are stored in-memory as {\f1\fs20 TAuthSession} instances:
{}
!TAuthSession = class(TSynPersistent)
!  property ID: cardinal;              // Session identifier
!  property User: TAuthUser;           // Associated user (loaded)
!  property TimeOutTix: cardinal;      // Expiration tick
!  property RemoteIP: RawUtf8;         // Client IP address
!  property ConnectionID: TRestConnectionID;
!end;
{}
:  Session Lifecycle
{}
$┌──────────────────────────────────────────────────────────────┐
$│                    Session Lifecycle                          │
$├──────────────────────────────────────────────────────────────┤
$│                                                               │
$│  Client.SetUser()  ──► Auth Request ──► Session Created       │
$│         │                                    │                │
$│         │                                    ▼                │
$│         │                            ┌─────────────┐          │
$│         │                            │ In-Memory   │          │
$│         │                            │ TAuthSession│          │
$│         │                            └─────────────┘          │
$│         │                                    │                │
$│         │                          ┌─────────┴─────────┐      │
$│         │                          ▼                   ▼      │
$│         │                    Session Timeout    Explicit Close│
$│         │                          │                   │      │
$│         │                          └─────────┬─────────┘      │
$│         │                                    ▼                │
$│         │                            Session Destroyed        │
$│         │                                                     │
$└──────────────────────────────────────────────────────────────┘
{}
:  Session Timeout
{}
Configure via {\f1\fs20 TAuthGroup.SessionTimeout}:
{}
!// Set 30-minute timeout for a group
!Group.SessionTimeout := 30;
!Server.Orm.Update(Group);
{}
:  Session Persistence
{}
Sessions can be persisted for server restarts:
{}
!// Save sessions before shutdown
!Server.Shutdown('sessions.bin');
!
!// Restore sessions after restart
!Server.SessionsLoadFromFile('sessions.bin');
{}
{\b Note:} This works for ORM sessions only, not @*SOA@ with stateful services.
{}
:  Accessing Session Information
{}
!// Server-side: Get current session user
!var
!  User: TAuthUser;
!begin
!  User := Server.SessionGetUser(Ctxt.SessionID);
!  if User <> nil then
!    Log('Request from: %s', [User.DisplayName]);
!end;
!
!// In service implementation
!procedure TMyService.DoSomething;
!var
!  Ctxt: TRestServerUriContext;
!begin
!  Ctxt := ServiceRunningContext;
!  if Ctxt <> nil then
!    Log('Session ID: %d, User: %s',
!        [Ctxt.SessionID, Ctxt.SessionUser.LogonName]);
!end;
{}
:2111 Security Best Practices
{}
:  Transport Security
{}
!// Always use HTTPS in production
!HttpServer := TRestHttpServer.Create(
!  '443',
!  [Server],
!  '+',
!  useHttpAsync,
!  secTLS           // Enable TLS
!);
!
!// Configure certificate
!HttpServer.TLS.CertificateFile := 'server.crt';
!HttpServer.TLS.PrivateKeyFile := 'server.key';
{}
:  Password Management
{}
!// ❌ Never store plain passwords
!User.PasswordHashHexa := 'plaintext';
!
!// ✓ Always hash passwords
!User.SetPasswordPlain('password');  // SHA-256
!
!// ✓ Or use PBKDF2 for better security
!User.SetPassword('password', RandomString(16), 10000);
{}
:  SQL Injection Prevention
{}
!// ❌ Dangerous: SQL injection possible
!Server.Orm.ExecuteFmt('SELECT * FROM Customer WHERE Name = ''%s''', [UserInput]);
!
!// ✓ Safe: Use parameterized queries
!Server.Orm.Retrieve('Name = ?', [], [UserInput], Customer);
{}
:  Principle of Least Privilege
{}
!// ❌ Don't give all users admin rights
!User.GroupRights := TAuthGroup(AdminGroupID);
!
!// ✓ Create specific groups with minimal rights
!User.GroupRights := TAuthGroup(ReadOnlyGroupID);
{}
:  Audit Logging
{}
!// Enable detailed logging
!Server.OnAfterUri := procedure(Ctxt: TRestServerUriContext)
!begin
!  if Ctxt.SessionUser <> nil then
!    Log('%s: %s %s from %s', [
!      DateTimeToIso8601(Now, True),
!      Ctxt.SessionUser.LogonName,
!      Ctxt.Uri,
!      Ctxt.RemoteIP
!    ]);
!end;
{}
:2112 Custom Authentication
{}
:  Creating Custom Scheme
{}
!type
!  TRestServerAuthenticationCustom = class(TRestServerAuthentication)
!  public
!    function Auth(Ctxt: TRestServerUriContext;
!      const aUserName: RawUtf8): boolean; override;
!    function RetrieveSession(
!      Ctxt: TRestServerUriContext): TAuthSession; override;
!  end;
!
!function TRestServerAuthenticationCustom.Auth(
!  Ctxt: TRestServerUriContext;
!  const aUserName: RawUtf8): boolean;
!var
!  User: TAuthUser;
!  Token: RawUtf8;
!begin
!  Result := False;
!  Token := Ctxt.InputUtf8['token'];
!
!  // Validate token with your external service
!  if not ValidateExternalToken(Token, aUserName) then
!    Exit;
!
!  // Create session
!  User := GetUser(Ctxt, aUserName);
!  if User <> nil then
!  begin
!    SessionCreate(Ctxt, User);
!    Result := True;
!  end;
!end;
{}
:  Registering Custom Scheme
{}
!Server.AuthenticationRegister(TRestServerAuthenticationCustom);
{}
:  Custom User Retrieval
{}
!// Override user retrieval from external source
!Server.OnAuthenticationUserRetrieve :=
!  function(Sender: TRestServerAuthentication;
!           Ctxt: TRestServerUriContext;
!           const aUserName: RawUtf8): TAuthUser;
!  begin
!    Result := TAuthUser.Create;
!    Result.LogonName := aUserName;
!    Result.ID := GetUserIdFromLDAP(aUserName);
!    Result.GroupRights := TAuthGroup(GetGroupFromLDAP(aUserName));
!  end;
{}
:2113 Summary
{}
:  Authentication Quick Reference
{}
|%72%28
|\b Need|Solution\b0
|Delphi clients|{\f1\fs20 TRestServerAuthenticationDefault}
|Windows domain|{\f1\fs20 TRestServerAuthenticationSspi}
|Browser/@*REST@ API|{\f1\fs20 TRestServerAuthenticationHttpBasic} + HTTPS
|Public stateless API|JWT via {\f1\fs20 JwtForUnauthenticatedRequest}
|Development/testing|{\f1\fs20 TRestServerAuthenticationNone}
|%
{}
:  Authorization Quick Reference
{}
|%67%33
|\b Need|Property\b0
|Per-table @*CRUD@|{\f1\fs20 TOrmAccessRights.GET/POST/PUT/DELETE}
|SQL execution|{\f1\fs20 AllowRemoteExecute} flags
|Service access|{\f1\fs20 ByPassAuthentication}, {\f1\fs20 AllowedGroups}
|Group management|{\f1\fs20 TAuthGroup.AccessRights}
|%
{}
:  Key Units
{}
|%11%89
|\b Unit|Purpose\b0
|@!src\rest\mormot.rest.server.pas@|Authentication classes, sessions
|@!src\rest\mormot.rest.core.pas@|{\f1\fs20 TAuthUser}, {\f1\fs20 TAuthGroup}
|@!src\orm\mormot.orm.core.pas@|{\f1\fs20 TOrmAccessRights}
|@!src\crypt\mormot.crypt.jwt.pas@|JWT classes
|@!src\crypt\mormot.crypt.secure.pas@|Cryptographic primitives
|%
{}
{\i Next: Chapter 22 covers the Scripting Engine (if applicable to your mORMot2 version).}
{}