; Converted from Markdown - Chapter 22
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:22Scripting Engine
{}
{\i JavaScript Integration for Dynamic Applications}
{}
m@*ORM@ot provides JavaScript scripting capabilities for applications that need dynamic behavior, user-defined workflows, or hot-reloadable business logic. This chapter covers the scripting architecture and available engines.
{}
:2201 Why Scripting?
{}
:  Use Cases
{}
|%30%70
|\b Scenario|Benefit\b0
|User-defined workflows|End-users customize behavior without recompilation
|Business rules|Domain experts define evolving logic
|Customization|Single executable serves multiple clients
|Reporting|Dynamic report definitions
|Plugin systems|Third-party extensions
|Rapid prototyping|Quick iteration without compilation
|%
{}
:  Language Choice: JavaScript
{}
mORMot chose JavaScript for scripting because:
{}
- {\b Universal knowledge} - Nearly every programmer knows JavaScript
- {\b Powerful when used well} - Modern ES2020+ features
- {\b Rich ecosystem} - Thousands of libraries available
- {\b Client/server sharing} - Same validation logic on both sides
- {\b Proven engines} - QuickJS and SpiderMonkey are production-ready
{}
:2202 Architecture Overview
{}
:  Two-Layer Design
{}
$┌─────────────────────────────────────────────────────────────────┐
$│                    Application Code                             │
$└─────────────────────────────────────────────────────────────────┘
$                              │
$┌─────────────────────────────────────────────────────────────────┐
$│                   mormot.script.core.pas                        │
$│           (Abstract Engine Management Layer)                    │
$│                                                                 │
$│  ┌─────────────────────┐  ┌──────────────────────────────┐      │
$│  │ TThreadSafeManager  │  │ TThreadSafeEngine (abstract) │      │
$│  │                     │  │                              │      │
$│  │ • Engine pooling    │  │ • Per-thread execution       │      │
$│  │ • Thread safety     │  │ • Context isolation          │      │
$│  │ • Hot reload        │  │ • FPU state protection       │      │
$│  │ • Remote debugging  │  │ • Lifecycle hooks            │      │
$│  └─────────────────────┘  └──────────────────────────────┘      │
$└─────────────────────────────────────────────────────────────────┘
$                              │
$┌─────────────────────────────────────────────────────────────────┐
$│                   Engine Implementations                        │
$│                                                                 │
$│  ┌──────────────────────┐  ┌──────────────────────────┐         │
$│  │ mormot.lib.quickjs   │  │ (SpiderMonkey planned)   │         │
$│  │                      │  │                          │         │
$│  │ • ES2020 support     │  │ • JIT compilation        │         │
$│  │ • Small footprint    │  │ • High performance       │         │
$│  │ • Static linking     │  │ • node.js compatible     │         │
$│  └──────────────────────┘  └──────────────────────────┘         │
$└─────────────────────────────────────────────────────────────────┘
{}
:  Supported Engines
{}
|%21%51%28
|\b Engine|Use Case|Status\b0
|{\b QuickJS}|Client-side, embedded|Available (via @!src\lib\mormot.lib.quickjs.pas@)
|{\b SpiderMonkey}|Server-side, high-performance|Planned
|%
{}
:2203 QuickJS Integration
{}
:  About QuickJS
{}
QuickJS is a small, embeddable JavaScript engine by Fabrice Bellard:
{}
- {\b ES2020 support} - Modules, async/await, BigInt, Proxies
- {\b Small footprint} - ~400KB static library
- {\b No external dependencies} - Fully standalone
- {\b Cross-platform} - Windows, Linux, macOS
{}
:  Low-Level API
{}
The {\f1\fs20 mormot.lib.quickjs.pas} unit provides direct QuickJS bindings:
{}
!uses
!  mormot.lib.quickjs;
!
!var
!  Runtime: JSRuntime;
!  Context: JSContext;
!  Value: JSValue;
!  Script: RawUtf8;
!begin
!  // Create runtime and context
!  Runtime := JS_NewRuntime;
!  Context := JS_NewContext(Runtime);
!  try
!    // Execute JavaScript
!    Script := 'function add(a, b) { return a + b; } add(2, 3);';
!    Value := JS_Eval(Context, pointer(Script), length(Script),
!                     'script.js', JS_EVAL_TYPE_GLOBAL);
!
!    // Check result
!    if JS_IsNumber(Value) then
!      Writeln('Result: ', JS_ToFloat64(Context, Value));
!
!    JS_FreeValue(Context, Value);
!  finally
!    JS_FreeContext(Context);
!    JS_FreeRuntime(Runtime);
!  end;
!end;
{}
:  Enabling QuickJS
{}
QuickJS requires the {\f1\fs20 LIBQUICKJSSTATIC} conditional:
{}
!// In project options or .inc file:
!{$define LIBQUICKJSSTATIC}
{}
Static libraries are located in:
!/mnt/w/mORMot2/static/
!  libquickjs.a        // Linux/macOS
!  libquickjs.obj      // Windows
{}
:2204 Thread-Safe Engine Management
{}
:  TThreadSafeManager
{}
The {\f1\fs20 TThreadSafeManager} class provides thread-safe engine pooling:
{}
!uses
!  mormot.script.core;
!
!type
!  // Your engine implementation (inherits from TThreadSafeEngine)
!  TMyQuickJSEngine = class(TThreadSafeEngine)
!  protected
!    procedure AfterCreate; override;
!    procedure DoBeginRequest; override;
!    procedure DoEndRequest; override;
!  end;
!
!var
!  Manager: TThreadSafeManager;
!begin
!  Manager := TThreadSafeManager.Create(TMyQuickJSEngine);
!  try
!    // Configure expiration (recommended for long-running servers)
!    Manager.EngineExpireTimeOutMinutes := 240;  // 4 hours
!
!    // Use in request handlers...
!  finally
!    Manager.Free;
!  end;
!end;
{}
:  Per-Thread Engine Access
{}
!procedure HandleRequest;
!var
!  Engine: TThreadSafeEngine;
!begin
!  // Get or create engine for current thread
!  Engine := Manager.ThreadSafeEngine;
!
!  // Execute within protected context
!  Engine.ThreadSafeCall(
!    procedure(E: TThreadSafeEngine)
!    begin
!      // FPU state is protected here
!      // Execute JavaScript safely
!    end);
!end;
{}
:  Thread Safety Model
{}
$┌────────────────────────────────────────────────────────────────┐
$│                    Thread Safety Model                          │
$├────────────────────────────────────────────────────────────────┤
$│                                                                 │
$│  Thread 1 ──────► Engine 1 (exclusive)                          │
$│                                                                 │
$│  Thread 2 ──────► Engine 2 (exclusive)                          │
$│                                                                 │
$│  Thread 3 ──────► Engine 3 (exclusive)                          │
$│                                                                 │
$│                   ▲                                             │
$│                   │                                             │
$│  ┌────────────────┴────────────────┐                            │
$│  │     TThreadSafeManager          │                            │
$│  │  (thread-safe pool management)  │                            │
$│  └─────────────────────────────────┘                            │
$│                                                                 │
$│  Key Rules:                                                     │
$│  • One engine per thread (never shared)                         │
$│  • Manager handles allocation/deallocation                      │
$│  • Automatic expiration prevents memory leaks                   │
$│                                                                 │
$└────────────────────────────────────────────────────────────────┘
{}
:2205 Hot Reload Pattern
{}
:  Content Versioning
{}
!// Application detects script changes
!if ScriptFilesModified then
!begin
!  // Increment version - engines will recreate on next access
!  Manager.ContentVersion := Manager.ContentVersion + 1;
!end;
!
!// In request handler
!Engine := Manager.ThreadSafeEngine;
!if Engine.ContentVersion <> Manager.ContentVersion then
!begin
!  // Engine was recreated - reload scripts
!  LoadScriptsIntoEngine(Engine);
!  Engine.ContentVersion := Manager.ContentVersion;
!end;
{}
:  Engine Expiration
{}
For long-running servers, prevent JavaScript memory leaks:
{}
!// Recreate engines every 4 hours
!Manager.EngineExpireTimeOutMinutes := 240;
!
!// Mark critical engines as permanent
!MainEngine.NeverExpire := true;
{}
:2206 Remote Debugging
{}
:  Firefox DevTools Protocol
{}
mORMot implements the Firefox Remote Debugging Protocol:
{}
!// Start debugger on port 6000
!Manager.StartDebugger('6000');
!
!// Optional: Break on first line
!Manager.PauseDebuggerOnFirstStep := true;
{}
:  Connecting Firefox
{}
1. Open Firefox
2. Navigate to {\f1\fs20 about:debugging}
3. Click "This Firefox" → "Settings"
4. Enable Remote Debugging
5. Connect to {\f1\fs20 localhost:6000}
{}
{\b Note:} This uses Firefox DevTools protocol, NOT Chrome DevTools.
{}
:2207 mORMot Integration Patterns
{}
:  Exposing ORM to JavaScript
{}
!// Register native function to access ORM
!procedure RegisterOrmAccess(Engine: TThreadSafeEngine);
!begin
!  // Example: Expose Customer retrieval
!  Engine.RegisterFunction('getCustomer',
!    function(Args: TJSArgs): TJSValue
!    var
!      ID: TID;
!      Customer: TOrmCustomer;
!    begin
!      ID := Args[0].AsInt64;
!      Customer := TOrmCustomer.Create;
!      try
!        if Server.Orm.Retrieve(ID, Customer) then
!          Result := CustomerToJS(Customer)
!        else
!          Result := JS_NULL;
!      finally
!        Customer.Free;
!      end;
!    end);
!end;
{}
:  Calling Services from JavaScript
{}
!// JavaScript can call interface-based services
!Engine.RegisterFunction('callService',
!  function(Args: TJSArgs): TJSValue
!  var
!    ServiceName, MethodName: RawUtf8;
!    Params: TDocVariantData;
!  begin
!    ServiceName := Args[0].AsString;
!    MethodName := Args[1].AsString;
!    Params := Args[2].AsVariant;
!
!    // Execute service and return result as JSON
!    Result := ExecuteServiceMethod(ServiceName, MethodName, Params);
!  end);
{}
:  Business Rules in JavaScript
{}
!// Define validation rules in JavaScript
!const
!  VALIDATION_SCRIPT = '''
!    function validateOrder(order) {
!      if (order.total > 10000 && !order.managerApproval) {
!        return { valid: false, error: "Manager approval required" };
!      }
!      if (order.items.length === 0) {
!        return { valid: false, error: "Order must have items" };
!      }
!      return { valid: true };
!    }
!  ''';
!
!// Use from Delphi
!function ValidateOrder(const Order: TOrder): boolean;
!var
!  Engine: TThreadSafeEngine;
!  Result: Variant;
!begin
!  Engine := Manager.ThreadSafeEngine;
!  Result := Engine.Call('validateOrder', [OrderToVariant(Order)]);
!  ValidateOrder := Result.valid;
!  if not ValidateOrder then
!    raise EValidation.Create(Result.error);
!end;
{}
:2208 Custom Variant Type
{}
:  Late-Binding Access
{}
mORMot provides a custom variant type for seamless JavaScript access:
{}
!var
!  JSObj: Variant;
!begin
!  // Create JavaScript object
!  JSObj := Engine.NewObject;
!
!  // Late-binding property access (like JavaScript)
!  JSObj.name := 'John';
!  JSObj.age := 30;
!  JSObj.greet := Engine.Function('return "Hello, " + this.name');
!
!  // Call method
!  Writeln(JSObj.greet());  // "Hello, John"
!end;
{}
:  Array Handling
{}
!var
!  JSArray: Variant;
!begin
!  JSArray := Engine.NewArray;
!
!  // Push elements
!  JSArray.push(1);
!  JSArray.push(2);
!  JSArray.push(3);
!
!  // Access by index
!  Writeln(JSArray[0]);  // 1
!
!  // Array methods
!  JSArray.sort();
!  JSArray.reverse();
!end;
{}
:2209 Key Units Reference
{}
|%8%92
|\b Unit|Purpose\b0
|@!src\script\mormot.script.core.pas@|Abstract engine management, thread pooling
|@!src\script\mormot.script.quickjs.pas@|QuickJS high-level wrapper (in development)
|@!src\lib\mormot.lib.quickjs.pas@|Low-level QuickJS API bindings
|@!src\lib\mormot.lib.static.pas@|Static library loading infrastructure
|%
{}
:2210 Current Status and Roadmap
{}
:  Implemented
{}
- ✓ Abstract {\f1\fs20 TThreadSafeEngine} and {\f1\fs20 TThreadSafeManager}
- ✓ Thread-safe pooling with expiration
- ✓ Remote debugging infrastructure
- ✓ Low-level QuickJS bindings (@!src\lib\mormot.lib.quickjs.pas@)
{}
:  In Development
{}
- @!src\script\mormot.script.quickjs.pas@ high-level wrapper
- Custom variant type for late-binding
- ORM/@*SOA@ integration helpers
{}
:  Planned
{}
- SpiderMonkey integration (for high-performance server scenarios)
- JIT compilation support
- node.js module compatibility
{}
:2211 Best Practices
{}
:  When to Use Scripting
{}
|%46%54
|\b Use Scripting For|Use Compiled Code For\b0
|User-customizable logic|Performance-critical paths
|Frequently changing rules|Core business logic
|Plugin/extension systems|Security-sensitive operations
|Rapid prototyping|Database access layer
|Report templates|Infrastructure code
|%
{}
:  Security Considerations
{}
!// Limit script capabilities
!Engine.DisableFileAccess := true;
!Engine.DisableNetworkAccess := true;
!Engine.MaxExecutionTimeMs := 5000;  // 5 second timeout
!Engine.MaxMemoryBytes := 64 * 1024 * 1024;  // 64MB limit
{}
:  Error Handling
{}
!try
!  Result := Engine.Eval(Script);
!except
!  on E: EJSException do
!  begin
!    Log.Error('JavaScript error at line %d: %s',
!              [E.LineNumber, E.Message]);
!    // E.StackTrace contains full JS stack
!  end;
!end;
{}
:2212 Summary
{}
:  Quick Reference
{}
|%73%27
|\b Need|Solution\b0
|Embed JavaScript|@!src\lib\mormot.lib.quickjs.pas@ + {\f1\fs20 LIBQUICKJSSTATIC}
|Thread-safe execution|{\f1\fs20 TThreadSafeManager}
|Engine pooling|{\f1\fs20 Manager.ThreadSafeEngine}
|Hot reload|{\f1\fs20 Manager.ContentVersion}
|Remote debugging|{\f1\fs20 Manager.StartDebugger('6000')}
|Memory management|{\f1\fs20 EngineExpireTimeOutMinutes}
|%
{}
:  When to Choose Each Engine
{}
|%45%55
|\b QuickJS|SpiderMonkey (when available)\b0
|Client-side scripts|Server-side heavy processing
|Small footprint needed|JIT performance required
|Static linking preferred|node.js compatibility needed
|ES2020 sufficient|Latest ECMAScript features
|%
{}
{\i Note: The scripting layer in mORMot2 is actively evolving. Check the source code and forum for the latest implementation status.}
{}
{\i Next: Chapter 23 covers Asymmetric Encryption (ECC) for secure communications.}
{}