; Converted from Markdown - Chapter 26
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:Chapter 26: Source Code
{}
{\i Adopt a m@*ORM@ot}
{}
This chapter covers the licensing terms of the {\i mORMot 2} framework, its source code availability, and complete installation instructions for both Delphi and Free Pascal/Lazarus development environments. Understanding how to properly set up your development environment is essential for working effectively with {\i mORMot 2}.
{}
:2601 License
{}
:  Three Licenses Model
{}
The framework source code is licensed under a disjunctive three-license giving the user the choice of one of the three following sets of free software/open source licensing terms:
- {\i Mozilla Public License}, version 1.1 or later (MPL);
- {\i GNU General Public License}, version 2.0 or later (GPL);
- {\i GNU Lesser General Public License}, version 2.1 or later (LGPL), with {\i linking exception} of the {\i FPC modified LGPL}.
{}
{\i FPC modified LGPL} is the {\i Library GNU General Public License} with the following modification:
{}
{\i As a special exception of the LGPL, the copyright holders of this library give you permission to link this library with independent modules to produce an executable, regardless of the license terms of these independent modules, and to copy and distribute the resulting executable under terms of your choice, provided that you also meet, for each linked independent module, the terms and conditions of the license of that module. An independent module is a module which is not derived from or based on this library. If you modify this library, you may extend this exception to your version of the library, but you are not obligated to do so. If you do not wish to do so, delete this exception statement from your version.}
{}
This allows the use of the framework code in a wide variety of software projects, while still maintaining intellectual rights on library code.
{}
In short:
- For GPL projects, use the GPL license - see @http://www.gnu.org/licenses/gpl-2.0.html
- For LGPL projects, use the LGPL license - see @http://www.gnu.org/licenses/lgpl-2.1.html
- For commercial projects, use the MPL License - see @http://www.mozilla.org/MPL/MPL-1.1.html - which is the most permissive, or the FPC modified LGPL license, thanks to its linking exception - see @http://wiki.freepascal.org/modified_LGPL
{}
:  Publish Modifications and Credit for the Library
{}
In all cases, any modification made to this source code {\b should} be published by any mean (e.g. a download link), even in case of MPL. If you need any additional feature, use the forums and we may introduce a patch to the main framework trunk.
{}
You do not have to pay any fee for using our MPL/GPL/LGPL libraries.
{}
But please do not forget to put somewhere in your credit window or documentation, a link to @https://synopse.info if you use any of the units published under this tri-license.
{}
For instance, if you select the MPL license, here are the requirements:
- You accept the license terms with no restriction - see @http://www.mozilla.org/MPL/2.0/FAQ.html for additional information;
- You have to publish any modified unit in a public web site (e.g. {\f1\fs20 @http://YourSoftwareCompany.com/MPL}), with a description of applied modifications, and no removal of the original license header in source code;
- You make appear some notice available in the program (About box, documentation, online help), stating e.g.
{}
{\i This software uses some third-party code of the Synopse mORMot framework (C) 2025 Arnaud Bouchez - @https://synopse.info - under Mozilla Public License 1.1; modified source code is available at @http://SoftwareCompany.com/MPL}
{}
Note that this documentation is under GPL 3.0 license only, as stated in this document front page.
{}
:  Derivate Open Source Works
{}
If you want to include part of the framework source code in your own open-source project, you may publish it with a comment similar to this one:
{}
!{
!  Sample based on official mORMot 2 sample
!
!  Synopse mORMot 2 framework. Copyright (C) 2025 Arnaud Bouchez
!    Synopse Informatique - https://synopse.info
!  Original tri-license: MPL 1.1/GPL 2.0/LGPL 2.1
!}
{}
You need to ensure that your Open Source project licensing is compatible with our Licensing Terms, and, if possible, notify us that you use our code.
{}
:  Legal Notice
{}
There are countries that restrict the use, import, export of cryptographic software. Before keeping, using, or distributing the software, make sure that you comply with these restrictions. If (for any reason) you are unable to do so, you are not allowed to download, use, or distribute the software.
{}
If you are residing in a country that allows software patents you must verify that no part of the software is covered by a patent in your country. If (for any reason) you are unable to do so, you are not allowed to use or distribute the software.
{}
:  Commercial Licenses
{}
Even though our libraries are Open Source with permissive licenses, some users want to obtain a license anyway. For instance, you may want to hold a tangible legal document as evidence that you have the legal right to use and distribute your software containing our library code, or, more likely, your legal department tells you that you have to purchase a license.
{}
If you feel like you really have to purchase a license for our libraries, {\i Synopse}, the company that employs the architect and principal developer of the library, will sell you one. Please contact us directly for a contract proposal.
{}
:2602 Availability
{}
As a true {\i Open Source} project, all source code of the framework is available. The primary location for {\i mORMot 2} source code is:
{}
{\b GitHub Repository}: @https://github.com/synopse/mORMot2
{}
The source has been commented following the scheme used by documentation tools. All interface definitions of the units have special comments which provide inline documentation.
{}
:  Obtaining the Source Code
{}
There are two primary methods to obtain the {\i mORMot 2} source code:
{}
#### Method 1: Clone the Repository (Recommended)
{}
Cloning the Git repository is the preferred method, as it allows you to easily update to the latest version:
{}
$git clone https://github.com/synopse/mORMot2.git
{}
For example, clone into {\f1\fs20 c:\github\mORMot2} on Windows or {\f1\fs20 ~/github/mORMot2} on Linux/macOS.
{}
#### Method 2: Download a Release Archive
{}
For a specific stable version (e.g., for use in a build script):
1. Go to @https://github.com/synopse/mORMot2/releases
2. Download the {\i Source code (zip)} for your desired release
3. Extract it to your chosen location (e.g., {\f1\fs20 d:\mormot2})
{}
:  Static Libraries
{}
After obtaining the source code, you need to download the static libraries for @*SQLite3@ and other compiled C code:
{}
{\b Download Options:}
- @https://synopse.info/files/mormot2static.7z (Windows-friendly, 7-Zip compressed)
- @https://synopse.info/files/mormot2static.tgz (POSIX-friendly, tar/gzip compressed)
- From the matching GitHub release page
{}
{\b Important:} Extract the static files into the {\f1\fs20 static} sub-folder of your {\i mORMot 2} installation.
{}
For example, if you cloned to {\f1\fs20 c:\github\mORMot2}, the static files should be in {\f1\fs20 c:\github\mORMot2\static\}.
{}
For safety, the SHA-256 checksums of the current version of the downloaded binary files are available in the {\f1\fs20 static/dev.sha256} file.
{}
:  Version Synchronization
{}
{\b Important:} Always keep the static binaries in sync with the framework source code. Version mismatches can cause unexpected errors.
{}
The static files are typically updated to match SQLite3 releases, sometimes with a short delay to ensure stability after major SQLite3 releases.
{}
:2603 Repository Structure
{}
The {\i mORMot 2} repository is organized into the following main folders:
{}
|%8%92
|\b Folder|Description\b0
|{\f1\fs20 src/}|Main source code folder containing the framework units
|{\f1\fs20 packages/}|{\f1\fs20 IDE} packages and tools for development environment setup
|{\f1\fs20 static/}|Pre-compiled binary {\f1\fs20 .o}/{\f1\fs20 .obj} files for static linking
|{\f1\fs20 test/}|Regression tests for all framework features
|{\f1\fs20 res/}|Resources used within {\f1\fs20 src/}, including static third-party binaries source
|{\f1\fs20 doc/}|Framework documentation
|{\f1\fs20 ex/}|Example projects and samples
|%
{}
:  Source Code Organization (src/)
{}
The {\f1\fs20 src/} folder contains the framework source code organized into logical layers:
{}
|%10%56%34
|\b Sub-folder|Description|Key Units\b0
|{\f1\fs20 core/}|Core utilities: @*RTTI@, @*JSON@, text, logging, threads|{\f1\fs20 mormot.core.base.pas}, {\f1\fs20 mormot.core.json.pas}, {\f1\fs20 mormot.core.log.pas}
|{\f1\fs20 lib/}|Raw API definitions for external libraries|{\f1\fs20 mormot.lib.openssl11.pas}, {\f1\fs20 mormot.lib.curl.pas}
|{\f1\fs20 crypt/}|Cryptographic primitives and secure protocols|{\f1\fs20 mormot.crypt.core.pas}, {\f1\fs20 mormot.crypt.jwt.pas}, {\f1\fs20 mormot.crypt.openssl.pas}
|{\f1\fs20 net/}|Network layer: @*HTTP@, @*WebSocket@s, async servers|{\f1\fs20 mormot.net.http.pas}, {\f1\fs20 mormot.net.server.pas}, {\f1\fs20 mormot.net.ws.pas}
|{\f1\fs20 db/}|Database access: SynDB, SQLite3, SQL/NoSQL|{\f1\fs20 mormot.db.core.pas}, {\f1\fs20 mormot.db.sql.pas}, {\f1\fs20 mormot.db.nosql.mongodb.pas}
|{\f1\fs20 orm/}|Object-Relational Mapping|{\f1\fs20 mormot.orm.core.pas}, {\f1\fs20 mormot.orm.sql.pas}
|{\f1\fs20 rest/}|@*REST@ client and server|{\f1\fs20 mormot.rest.core.pas}, {\f1\fs20 mormot.rest.server.pas}, {\f1\fs20 mormot.rest.http.server.pas}
|{\f1\fs20 soa/}|Service-Oriented Architecture (interfaces)|{\f1\fs20 mormot.soa.core.pas}, {\f1\fs20 mormot.soa.server.pas}
|{\f1\fs20 app/}|Application layer: daemon, console helpers|{\f1\fs20 mormot.app.daemon.pas}, {\f1\fs20 mormot.app.console.pas}
|{\f1\fs20 script/}|Scripting engine support (QuickJS)|{\f1\fs20 mormot.script.quickjs.pas}
|{\f1\fs20 ui/}|User interface components (VCL/LCL)|{\f1\fs20 mormot.ui.controls.pas}
|{\f1\fs20 ddd/}|Domain-Driven Design support|@*DDD@ infrastructure and patterns
|{\f1\fs20 tools/}|Command-line tools source code|ECC tool, etc.
|{\f1\fs20 misc/}|Miscellaneous utilities|Various helper units
|%
{}
:  Key Include Files
{}
The {\f1\fs20 src/} folder contains important include files:
{}
|%8%92
|\b File|Description\b0
|{\f1\fs20 mormot.defines.inc}|Global compiler conditionals and settings
|{\f1\fs20 mormot.uses.inc}|Common uses clause for console applications
|{\f1\fs20 mormot.commit.inc}|Current commit hash (updated automatically)
|%
{}
:  Static Libraries Structure
{}
The {\f1\fs20 static/} folder contains pre-compiled binaries organized by target platform:
{}
{\b For FPC (cross-platform):}
!static/
$├── i386-win32/          # Windows 32-bit
$├── x86_64-win64/        # Windows 64-bit
$├── i386-linux/          # Linux 32-bit
$├── x86_64-linux/        # Linux 64-bit
$├── aarch64-linux/       # Linux ARM64
$├── arm-linux/           # Linux ARM32
$├── i386-darwin/         # macOS 32-bit (legacy)
$├── x86_64-darwin/       # macOS 64-bit Intel
$├── aarch64-darwin/      # macOS ARM64 (Apple Silicon)
$├── x86_64-freebsd/      # FreeBSD 64-bit
$└── x86_64-openbsd/      # OpenBSD 64-bit
{}
{\b For Delphi:}
!static/
$└── delphi/              # Win32 .obj and Win64 .o files
{}
:2604 Expected Compilation Targets
{}
:  Compiler Support
{}
The framework source code:
- Tries to stay compatible with FPC stable and Delphi 7 and up
- Is currently validated against:
  - {\b FPC}: 3.2.3 (fixes-3_2 branch) and Lazarus 2.2.5 (fixes_2_2 branch)
  - {\b Delphi}: 7, 2007, 2009, 2010, XE4, XE7, XE8, 10.4, 11.1, 12.2 Athenes
{}
{\b Note:} FPC 3.2.2 has a regression with variant late binding. Use the FPC 3.2.3 fixes branch instead.
{}
:  Platform Support
{}
{\b Server-Side (Full Framework):}
{}
|%64%10%26
|\b Platform|FPC|Delphi\b0
|Windows 32-bit|✓|✓
|Windows 64-bit|✓|✓ (XE2+)
|Linux x86_64|✓|-
|Linux i386|✓|-
|Linux ARM64|✓|-
|Linux ARM32|✓|-
|macOS Intel|✓|-
|macOS Apple Silicon|✓|-
|FreeBSD|✓|-
|OpenBSD|✓|-
|%
{}
{\b Client-Side (Cross-Platform Units):}
- All Delphi targets (Windows, iOS, Android, macOS, Linux) can use the cross-platform client units
- FPC provides full server and client support on all listed platforms
{}
:  Pure Pascal Fallbacks
{}
The static {\f1\fs20 .o}/{\f1\fs20 .obj} files are {\b not mandatory} to compile the framework. There is always a "pure Pascal" fallback code available for:
- SQLite3 engine (use external dynamic library instead)
- Cryptographic routines
- Compression algorithms
{}
However, the static-linked versions typically provide better performance and simpler deployment.
{}
:2605 Delphi Installation
{}
:  Step-by-Step Setup
{}
Follow these steps to set up {\i mORMot 2} for Delphi:
{}
{\b Step 1: Get the Source Code}
{}
Clone the repository or download a release:
$cd c:\github
$git clone https://github.com/synopse/mORMot2.git
{}
{\b Step 2: Download Static Libraries}
{}
Download and extract {\f1\fs20 mormot2static.7z} from @https://synopse.info/files/mormot2static.7z into {\f1\fs20 c:\github\mORMot2\static\}.
{}
{\b Step 3: Create Environment Variable}
{}
In Delphi {\f1\fs20 IDE}:
1. Go to {\i Tools} → {\i Options} → {\i {\f1\fs20 IDE}} → {\i Environment Variables}
2. Create a new {\b User System Override} variable:
   - Name: {\f1\fs20 mormot2}
   - Value: {\f1\fs20 c:\github\mORMot2\src} (or your chosen path)
{}
{\b Step 4: Configure Library Paths}
{}
In Delphi {\f1\fs20 IDE}:
1. Go to {\i Tools} → {\i Options} → {\i Language} → {\i Delphi Options} → {\i Library}
2. Add the following to the {\b Library path} for each target platform (Win32, Win64):
{}
!$(mormot2);$(mormot2)\core;$(mormot2)\lib;$(mormot2)\crypt;$(mormot2)\net;$(mormot2)\db;$(mormot2)\rest;$(mormot2)\orm;$(mormot2)\soa;$(mormot2)\app;$(mormot2)\script;$(mormot2)\ui;$(mormot2)\tools;$(mormot2)\misc
{}
{\b Step 5: Verify Installation}
{}
1. Open {\f1\fs20 test/mormot2tests.dpr} in the {\f1\fs20 IDE}
2. Compile and run the regression tests
3. All tests should pass on your machine
{}
:  Quick Path Setup Reference
{}
Here's a condensed version of the library path string to copy:
{}
!$(mormot2);$(mormot2)\core;$(mormot2)\lib;$(mormot2)\crypt;$(mormot2)\net;$(mormot2)\db;$(mormot2)\rest;$(mormot2)\orm;$(mormot2)\soa;$(mormot2)\app;$(mormot2)\script;$(mormot2)\ui;$(mormot2)\tools;$(mormot2)\misc
{}
:  No Packages Required
{}
Unlike some frameworks, {\i mORMot 2} does not require installing {\f1\fs20 IDE} packages for Delphi. Simply configure the library paths and you're ready to go.
{}
The framework uses relative paths in its source code to include the expected {\f1\fs20 .o}/{\f1\fs20 .obj} files from the {\f1\fs20 static\delphi} sub-folder automatically.
{}
:  Testing Your Installation
{}
After setup, compile and run the test project:
{}
1. Open {\f1\fs20 test/mormot2tests.dpr}
2. Select your target platform (Win32 or Win64)
3. Build and run
4. Review the test results
{}
The test suite covers all framework features and serves as both validation and usage examples.
{}
:2606 FreePascal / Lazarus Installation
{}
:  Supported Targets
{}
You can use the {\i FreePascal Compiler} (FPC) to (cross-)compile {\i mORMot 2} for the following platforms:
{}
{\b Windows:}
- i386-win32
- x86_64-win64
{}
{\b Linux:}
- i386-linux
- x86_64-linux
- arm-linux
- aarch64-linux
{}
{\b macOS:}
- x86_64-darwin
- aarch64-darwin (Apple Silicon)
{}
{\b BSD:}
- x86_64-freebsd
- x86_64-openbsd
- i386-freebsd
{}
Linux is a premium target for efficient server hosting. Since {\i mORMot 2} has minimal dependencies, installing a new server is as simple as copying the executable to a blank Linux host. No runtime frameworks or virtual machines needed.
{}
:  Using the Lazarus Package (Recommended)
{}
The easiest way to set up {\i mORMot 2} for Lazarus is to use the provided package:
{}
{\b Step 1: Get Source and Static Files}
{}
$git clone https://github.com/synopse/mORMot2.git
$cd mORMot2
$# Download and extract mormot2static.tgz into the static/ folder
{}
{\b Step 2: Install the Package}
{}
1. Open Lazarus {\f1\fs20 IDE}
2. Go to {\i Package} → {\i Open Package File (.lpk)}
3. Navigate to {\f1\fs20 packages/lazarus/mormot2.lpk}
4. Click {\i Compile} (not {\i Install} - it's a runtime package)
{}
For UI components, also compile {\f1\fs20 packages/lazarus/mormot2ui.lpk}.
{}
{\b Step 3: Configure Your Project}
{}
Add {\f1\fs20 mormot2} package as a dependency to your Lazarus project:
1. Open your project
2. Go to {\i Project} → {\i Project Inspector}
3. Click {\i Add} → {\i New Requirement}
4. Select {\f1\fs20 mormot2}
{}
:  Manual FPC Setup (Without Package)
{}
For command-line compilation or when not using the package:
{}
{\b Project Options:}
{}
Add to {\i Other unit files (-Fu)}:
!/path/to/mORMot2/src;/path/to/mORMot2/src/core;/path/to/mORMot2/src/lib;/path/to/mORMot2/src/crypt;/path/to/mORMot2/src/net;/path/to/mORMot2/src/db;/path/to/mORMot2/src/rest;/path/to/mORMot2/src/orm;/path/to/mORMot2/src/soa;/path/to/mORMot2/src/app
{}
Add to {\i Include files (-Fi)}:
!/path/to/mORMot2/src
{}
Add to {\i Libraries (-Fl)}:
!/path/to/mORMot2/static/$(TargetCPU)-$(TargetOS)
{}
The {\f1\fs20 $(TargetCPU)-$(TargetOS)} macro automatically selects the correct static library folder based on your compilation target.
{}
:  Setting Up FPC with fpcupdeluxe
{}
We recommend using {\i fpcupdeluxe} to set up a stable FPC/Lazarus environment:
{}
1. Download from @https://github.com/LongDirtyAnimAlf/fpcupdeluxe/releases
2. Run the executable
3. Select FPC version {\f1\fs20 3.2} and Lazarus version matching your needs
4. Click "Install/update FPC+Laz"
{}
{\b Cross-Compilation:}
{}
{\i fpcupdeluxe} makes cross-compilation easy:
1. Go to the "Cross" tab
2. Select your target CPU and OS
3. Click "Install compiler"
4. Download cross-compiler binaries when prompted
{}
This allows you to build Linux executables from Windows, or vice versa.
{}
:  FPC Version Considerations
{}
{\b Recommended:} FPC 3.2.3 (fixes-3_2 branch)
{}
{\b Known Issues:}
- FPC 3.2.2 has a regression with variant late binding - avoid using it
- FPC trunk may have breaking changes; stick to stable branches for production
{}
:  Minimal FPC Console Application
{}
Here's a minimal FPC project structure:
{}
!program MyMormotApp;
!
!{$I mormot.defines.inc}
!{$APPTYPE CONSOLE}
!
!uses
!  {$I mormot.uses.inc}  // Includes FPC-specific units for Linux
!  mormot.core.base,
!  mormot.core.text;
!
!begin
!  writeln('Hello from mORMot 2!');
!  writeln('Current UTC: ', DateTimeToIso8601(NowUtc, true));
!end.
{}
The {\f1\fs20 mormot.uses.inc} file automatically includes the necessary units for FPC on various platforms (e.g., {\f1\fs20 cthreads}, {\f1\fs20 cwstring} on Linux).
{}
:2607 Writing Cross-Platform Code
{}
:  Common Include File
{}
In all your source code files, include the {\i mORMot 2} defines file to set all compiler options and conditionals:
{}
!{$I mormot.defines.inc}
{}
This include file defines essential conditionals like {\f1\fs20 HASINLINE}, {\f1\fs20 OSWINDOWS}, {\f1\fs20 OSPOSIX}, CPU architecture flags, and more.
{}
:  Cross-Platform Guidelines
{}
To ensure your code compiles on both Delphi and FPC, and on multiple platforms:
{}
1. {\b Avoid Direct Windows Unit Usage}: Don't directly reference the {\f1\fs20 Windows} unit in cross-platform code. Use @!src\core\mormot.core.os.pas@ instead.
{}
2. {\b Use Framework Types}: Rely on {\i mORMot 2} types like {\f1\fs20 RawUtf8} for string handling in business logic.
{}
3. {\b Conditional Compilation}: When platform-specific code is needed:
{}
!{$ifdef OSWINDOWS}
!  // Windows-specific code
!{$endif OSWINDOWS}
!
!{$ifdef OSPOSIX}
!  // Linux/macOS/BSD code
!{$endif OSPOSIX}
{}
4. {\b Use {\f1\fs20 mormot.uses.inc}}: In your {\f1\fs20 .dpr}/{\f1\fs20 .lpr} files:
{}
!uses
!  {$I mormot.uses.inc}  // Handles platform-specific units
!  mormot.core.base,
!  // ... your units
{}
:  Conditional Defines Reference
{}
Key conditionals defined in {\f1\fs20 mormot.defines.inc}:
{}
|%22%78
|\b Conditional|Description\b0
|{\f1\fs20 OSWINDOWS}|Compiling for Windows
|{\f1\fs20 OSPOSIX}|Compiling for POSIX (Linux, macOS, BSD)
|{\f1\fs20 OSLINUX}|Compiling for Linux specifically
|{\f1\fs20 OSDARWIN}|Compiling for macOS
|{\f1\fs20 CPU32}|32-bit architecture
|{\f1\fs20 CPU64}|64-bit architecture
|{\f1\fs20 CPUINTEL}|x86 or x86_64 architecture
|{\f1\fs20 CPUARM}|ARM architecture
|{\f1\fs20 FPC}|FreePascal Compiler
|{\f1\fs20 ISDELPHI}|Delphi compiler
|{\f1\fs20 HASINLINE}|Inline functions supported
|{\f1\fs20 PUREMORMOT2}|Use only mORMot 2 type names
|%
{}
:  Recommended Project Structure
{}
For cross-platform projects:
{}
!myproject/
$├── src/
$│   ├── myproject.core.pas      # Business logic (cross-platform)
$│   └── myproject.server.pas    # Server components
$├── bin/
$│   ├── win32/                  # Windows 32-bit output
$│   ├── win64/                  # Windows 64-bit output
$│   └── linux64/                # Linux 64-bit output
$├── test/
$│   └── myproject.tests.dpr     # Regression tests
$├── myproject.server.dpr        # Delphi project
$├── myproject.server.lpr        # Lazarus project
$└── myproject.server.lpi        # Lazarus project info
{}
:2608 Server Deployment
{}
:  Linux Deployment
{}
Deploying a {\i mORMot 2} server on Linux is straightforward:
{}
1. {\b Cross-compile} your application for {\f1\fs20 x86_64-linux} (or your target architecture)
2. {\b Copy} the executable to your Linux server
3. {\b Run} it directly - no runtime dependencies needed
{}
The static linking of SQLite3 and other libraries means you don't need to install anything on the server.
{}
{\b Minimal Dependencies:}
{}
A typical {\i mORMot 2} Linux executable only requires:
!libpthread.so.0   # Threading (standard)
!libdl.so.2        # Dynamic loading (standard)
!libc.so.6         # C library (standard)
{}
These are present on every Linux distribution.
{}
:  Docker Deployment
{}
{\i mORMot 2} works well in Docker containers. A minimal Dockerfile:
{}
$FROM scratch
$COPY myserver /
$ENTRYPOINT ["/myserver"]
{}
Since {\i mORMot 2} executables are statically linked, you can even use a {\f1\fs20 scratch} (empty) base image.
{}
:  Windows Services
{}
For Windows service deployment, use @!src\app\mormot.app.daemon.pas@ which provides cross-platform daemon/service functionality. The same code can run as:
- A Windows Service
- A Linux systemd daemon
- A console application (for debugging)
{}
:2609 Upgrading from mORMot 1.18
{}
:  Why a New Version?
{}
{\i mORMot 2} is a complete rewrite of the framework, addressing:
- Better @*SOLID@ principles adherence
- Split of large monolithic units into focused components
- Cleaner type names ({\f1\fs20 TOrm} instead of {\f1\fs20 TSQLRecord})
- Modern features (OpenSSL, async servers, QuickJS)
- Improved performance through optimized kernels
{}
:  Migration Steps
{}
1. {\b Create a New Folder}: Don't replace mORMot 1.18; install mORMot 2 in a separate location
{}
2. {\b Update Unit Names}: All units have been renamed:
   - {\f1\fs20 SynCommons.pas} → {\f1\fs20 mormot.core.*.pas} (split into multiple units)
   - {\f1\fs20 mORMot.pas} → {\f1\fs20 mormot.orm.{\i .pas} + {\f1\fs20 mormot.rest.}.pas}
   - {\f1\fs20 SynDB{\i .pas} → {\f1\fs20 mormot.db.}.pas}
   - See Chapter 3 for complete unit mapping
{}
3. {\b Update Type Names}: In {\f1\fs20 PUREMORMOT2} mode:
   - {\f1\fs20 TSQLRecord} → {\f1\fs20 TOrm}
   - {\f1\fs20 TSQLRest} → {\f1\fs20 TRest}
   - {\f1\fs20 TSQLModel} → {\f1\fs20 TOrmModel}
{}
4. {\b Review Breaking Changes}:
   - Delphi 5-6 and Kylix support removed
   - BigTable, LVCL, RTTI-UI deprecated
   - Some internal APIs changed
{}
5. {\b Consult Examples}: The {\f1\fs20 ex/} folder contains updated examples showing new patterns
{}
:  Parallel Installation
{}
You can maintain both mORMot 1.18 and mORMot 2 on the same system:
- Keep mORMot 1.18 for legacy projects
- Use mORMot 2 for new development
- Unit names don't conflict, allowing gradual migration
{}
:2610 Getting Help
{}
:  Resources
{}
- {\b Official Documentation}: @https://synopse.info/files/doc/mORMot2.html
- {\b GitHub Repository}: @https://github.com/synopse/mORMot2
- {\b Forum}: @https://synopse.info/forum/viewforum.php?id=24
- {\b Blog}: @https://blog.synopse.info
- {\b Telegram Group}: @https://t.me/synopse_mormot
- {\b Discord Server}: @https://discord.gg/BcmcpY6afj
{}
:  Sample Projects
{}
The {\f1\fs20 ex/} folder contains many examples:
- Basic ORM usage
- HTTP client/server
- Interface-based services
- Domain-Driven Design patterns
- Web @*MVC@ applications
{}
The {\i Thomas Tutorials} ({\f1\fs20 ex/ThirdPartyDemos/tbo/}) provide particularly good step-by-step learning resources.
{}
:  Contributing
{}
Contributions are welcome:
- Submit pull requests via GitHub
- Report issues in the GitHub issue tracker
- Share your experiences on the forum
{}
Consider @https://github.com/synopse/mORMot2/blob/master/DONATE.md if you find it valuable for your projects.
{}