; ============================================
; mORMot2 SAD Documentation - Enhanced PRO output
; Features: auto-indexing, unit links, smart tables
; ============================================


; === mORMot2-SAD-Chapter-01.md ===
; Converted from Markdown - Chapter 1
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:1mORMot2 Overview
{}
{\i Meet the m@*ORM@ot}
{}
{\b Synopse mORMot 2} is an Open Source Client-Server ORM/@*SOA@/@*MVC@ framework for {\i Delphi} and {\i Free Pascal}, targeting Windows, Linux, BSD, and macOS for the server, and virtually any platform for clients (including mobile and AJAX).
{}
This is {\b mORMot 2}, a complete rewrite of the original mORMot framework with improved architecture, cleaner code organization, and modern Object Pascal patterns.
{}
: Main Features
{}
The main features of {\i mORMot 2} are:
{}
- {\b ORM/@*ODM@}: Object persistence on almost any database (SQL or NoSQL)
- {\b SOA}: Organize your business logic into @*REST@ful @*JSON@ services
- {\b Clients}: Consume your data or services from any platform, via ORM classes or SOA interfaces
- {\b Web MVC}: Publish your ORM/SOA processes as responsive Web Applications
{}
All features work with local or remote access, via an auto-configuring Client-Server REST design.
{}
$┌────────────────────────────────────────────────────────────────────────┐
$│                         mORMot2 Architecture                           │
$├────────────────────────────────────────────────────────────────────────┤
$│                                                                        │
$│  SQL Databases              NoSQL Databases        Services            │
$│  ─────────────              ────────────────       ────────            │
$│  · SQLite3                  · MongoDB              · Method-based      │
$│  · PostgreSQL               · In-Memory            · Interface-based   │
$│  · MySQL/MariaDB            · Files                · Asynchronous      │
$│  · MS SQL Server                                   · Remote (SaaS)     │
$│  · Oracle                        ↓                                     │
$│  · Firebird                     ODM                      ↓             │
$│  · DB2                           ↓                      SOA            │
$│  · Informix                      │                       │             │
$│        ↓                         │                       │             │
$│       ORM ───────────────────────┴───────────────────────┘             │
$│        │                                                               │
$│        └─────────────────────────┬────────────────────────             │
$│                                  ↓                                     │
$│                            REST Server                                 │
$│                        ┌────────┴────────┐                             │
$│                        │    MVC/MVVM     │                             │
$│                        │   Web Server    │                             │
$│                        └────────┬────────┘                             │
$│                                 ↓                                      │
$│  ┌──────────────────────────────┴───────────────────────────────────┐  │
$│  │                       REST Clients                               │  │
$│  │   · Delphi Desktop/Mobile  · AJAX  · Any HTTP Client             │  │
$│  └──────────────────────────────────────────────────────────────────┘  │
$│                                                                        │
$│  Cross-Cutting Features:                                               │
$│  · User Management & Security   · Sessions & Replication               │
$│  · Unit Testing & Mocks/Stubs   · Logging & Profiling                  │
$│  · http.sys & WebSockets        · Templates (Mustache)                 │
$│  · JSON & Cryptography          · PDF & Reporting                      │
$└────────────────────────────────────────────────────────────────────────┘
{}
{\i mORMot 2} offers all features needed for building any kind of modern software project, with state-of-the-art integrated software components, designed for both completeness and complementarity, offering {\i convention over configuration} solutions, and implemented for speed and efficiency.
{}
: Quick Start Examples
{}
{\b For storing data}, you define a class, and the framework handles everything: routing, JSON marshalling, table creation, SQL generation, validation.
{}
!type
!  TOrmCustomer = class(TOrm)
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Email: RawUtf8 read fEmail write fEmail;
!    property Balance: Currency read fBalance write fBalance;
!  end;
!
!// Create model and server
!Model := TOrmModel.Create([TOrmCustomer]);
!Server := TRestServerDB.Create(Model, 'customers.db3');
!Server.Server.CreateMissingTables;
!
!// Add a customer
!Customer := TOrmCustomer.Create;
!Customer.Name := 'John Doe';
!Customer.Email := 'john@example.com';
!Server.Orm.Add(Customer, true);
{}
{\b For creating a service}, you define an interface and a class:
{}
!type
!  ICalculator = interface(IInvokable)
!    ['{9A60C8ED-CEB2-4E09-87D4-4A16F496E5FE}']
!    function Add(A, B: Integer): Integer;
!    function Multiply(A, B: Integer): Integer;
!  end;
!
!  TCalculator = class(TInjectableObjectRest, ICalculator)
!  public
!    function Add(A, B: Integer): Integer;
!    function Multiply(A, B: Integer): Integer;
!  end;
!
!// Register on server
!Server.ServiceDefine(TCalculator, [ICalculator], sicShared);
!
!// Call from client
!var Calc: ICalculator;
!if Client.Services.Resolve(ICalculator, Calc) then
!  Result := Calc.Add(10, 20);
{}
{\b For building a MVC web site}, write a Controller class in Delphi, then HTML Views using {\i Mustache} templates, leveraging the same ORM/SOA methods as Model.
{}
: What's New in mORMot 2
{}
mORMot 2 is a complete rewrite of the original mORMot framework. Key improvements include:
{}
:  Cleaner Architecture
- {\b Renamed types}: {\f1\fs20 TSQLRecord} → {\f1\fs20 TOrm}, {\f1\fs20 TSQLRest} → {\f1\fs20 TRest}, {\f1\fs20 TSQLModel} → {\f1\fs20 TOrmModel}
- {\b Split units}: Large {\f1\fs20 SynCommons.pas} split into ~24 focused {\f1\fs20 mormot.core.*} units
- {\b @*SOLID@ principles}: Composition over inheritance, interface-based design
{}
:  Unit Organization
!mormot.core.*   - Foundation (text, JSON, RTTI, logging, threading)
!mormot.crypt.*  - Cryptography (AES, SHA, ECC, RSA, JWT, X.509)
!mormot.net.*    - Networking (HTTP, WebSockets, async I/O)
!mormot.db.*     - Database access (SQL and NoSQL)
!mormot.orm.*    - Object-Relational Mapping
!mormot.soa.*    - Service-Oriented Architecture
!mormot.rest.*   - RESTful client/server
!mormot.app.*    - Application utilities (console, daemon)
!mormot.ui.*     - VCL/LCL components
{}
:  New Features in mORMot 2
- {\b Async @*HTTP@ Server} ({\f1\fs20 useHttpAsync}) - Event-driven for massive concurrency
- {\b Factory-based Cryptography} - {\f1\fs20 Hash()}, {\f1\fs20 Sign()}, {\f1\fs20 Cipher()}, {\f1\fs20 Asym()}, {\f1\fs20 Cert()} factories
- {\b ACME/Let's Encrypt} - Automatic {\f1\fs20 TLS} certificate management
- {\b Native X.509/RSA} - Pure Pascal implementation without OpenSSL dependency
- {\b OpenAPI Generator} - Generate Delphi clients from Swagger specs
- {\b QuickJS Engine} - Modern JavaScript scripting (replaces SpiderMonkey)
{}
:  Compiler Support
- {\b Delphi}: 7 through 12.2 (RAD Studio 12 Athens)
- {\b Free Pascal}: 3.2.2+ with fixes
- {\b Platforms}: Windows (32/64-bit), Linux (x64/ARM64), macOS, FreeBSD
{}
:101 Client-Server ORM/SOA Framework
{}
The {\i mORMot 2 framework} implements a Client-Server RESTful architecture, following MVC, N-Tier, ORM, and SOA best-practice patterns.
{}
Multiple clients can access the same remote or local server using diverse communication protocols:
{}
$┌───────────────────────────────────────────────────────────────────┐
$│                     Network Architecture                          │
$├───────────────────────────────────────────────────────────────────┤
$│                                                                   │
$│  ┌─────────┐  ┌─────────┐                      ┌─────────┐        │
$│  │Client 1 │  │Client 2 │    Internet/VPN      │Client n │        │
$│  │ Delphi  │  │  AJAX   │        ║             │ Delphi  │        │
$│  └────┬────┘  └────┬────┘        ║             └────┬────┘        │
$│       │            │             ║                  │             │
$│       └────────────┴─────────────╨──────────────────┘             │
$│                          │                                        │
$│                   JSON + REST                                     │
$│                   over HTTP/HTTPS                                 │
$│                          │                                        │
$│                   ┌──────┴──────┐                                 │
$│                   │   Server    │                                 │
$│                   │ (mORMot 2)  │                                 │
$│                   └─────────────┘                                 │
$└───────────────────────────────────────────────────────────────────┘
{}
Or the application can be stand-alone:
{}
$┌─────────────────────────────────────────┐
$│       Stand-Alone Application           │
$│  ┌──────────┐    ┌──────────┐           │
$│  │  Client  │───►│  Server  │           │
$│  │  Code    │    │  Code    │           │
$│  └──────────┘    └──────────┘           │
$│        direct in-process access         │
$└─────────────────────────────────────────┘
{}
Switching between embedded and client-server architecture is just a matter of how {\i mORMot} classes are initialized. The same executable can run as a stand-alone application, a server, or a client, depending on runtime parameters!
{}
:102 Highlights
{}
Key distinguishing features of mORMot 2:
{}
- {\b Client-Server orientation} with optimized request caching and intelligent updates over a RESTful architecture - but can also be used in stand-alone applications
- {\b No RAD components} - True ORM and SOA approach
- {\b Multi-Tier architecture} with integrated business rules as fast ORM-based classes and {\i Domain-Driven} design
- {\b Service-Oriented-Architecture} model using custom RESTful JSON services - send any {\f1\fs20 TObject}, dynamic array, or record as JSON via interface-based contracts shared on both client and server
- {\b Truly RESTful authentication} with dual security model (session + per-query)
- {\b Very fast JSON} producer and parser with caching at SQL level
- {\b Fast HTTP/@*HTTPS@ server} using {\f1\fs20 http.sys} kernel-mode server (Windows) or async event-driven server (all platforms) - plus named pipes, @*WebSocket@s, or in-process alternatives
- {\b @*SQLite3@ kernel} with ability to connect to any external database (@*PostgreSQL@, @*MySQL@, @*Oracle@, MS SQL, Firebird, etc.) via direct client libraries, ODBC, or OLE DB
- {\b RESTful ORM access to NoSQL} like @*MongoDB@ with the same code base
- {\b Multiple databases at once} via SQLite3 Virtual Tables mechanism
- {\b Full Text Search} engine with Google-like ranking algorithm
- {\b Native cryptography} including AES, SHA, ECC, RSA, @*JWT@, X.509 with optional OpenSSL acceleration
- {\b Direct User Interface generation} with grids and Ribbon layouts
- {\b Integrated Reporting} system serving PDF reports
- {\b Optimized for performance} (assembly when needed, buffered I/O, multi-threaded architecture)
- {\b Cross-platform clients} from Delphi, Free Pascal, mobile, and AJAX
- {\b Full source code} provided under open source license
{}
:103 Benefits
{}
{\i mORMot} provides a comprehensive set of features to manage your crosscutting concerns through a reusable set of components and core functionality.
{}
Benefits include:
{}
- {\b KISS convention over configuration}: All needed features at hand, with one clear way of doing things
- {\b Pascal-oriented}: Implementation leverages Object Pascal's type system rather than mimicking Java/C# patterns
- {\b Integrated}: All crosscutting scenarios are coupled with consistent APIs, extensive code reuse, and JSON/RESTful orientation from the ground up
- {\b Tested}: Most of the framework is test-driven, with comprehensive regression tests including system-wide integration tests
- {\b Don't reinvent the wheel}: Focus on your business logic, not infrastructure
- {\b Open Source and maintained}: Active development community - mORMot won't leave you soon!
{}
:104 Legacy Code and Existing Projects
{}
Even if {\i mORMot} works best in projects designed from scratch, it fits very well for evolving existing {\i Delphi} projects or creating server-side components for AJAX applications.
{}
One key benefit is facilitating the transition from traditional Client-Server architecture to N-Tier layered patterns.
{}
Due to its modular design, you can integrate framework components into existing applications:
{}
- {\b Add logging} to track issues and enable customer-side performance profiling
- {\b Use low-level classes} like record or dynamic array wrappers, or dynamic document storage via {\f1\fs20 TDocVariant}
- {\b Use direct DB layers} including high-performance database access, array binding for fast inserts, or NoSQL databases
- {\b Reports} can use the @!src\ui\mormot.ui.report.pas@ code-based system for server-side PDF generation
- {\b HTTP requests} can be exposed using method-based services, e.g., for rendering HTML with Mustache templates
- {\b Migrate to SOA} by moving logic into server services defined via interfaces, without SOAP/WCF overhead
- {\b RESTful interface} for JSON consumption via AJAX or mobile clients
- {\b New tables via ORM} in your existing SQL server or new storage like MongoDB
- {\b In-memory engine} or SQLite3-based consolidation for performance-critical scenarios
- {\b Support for older Delphi versions} (starting from Delphi 7) for projects that can't easily upgrade
{}
:105 FAQ
{}
Before going further, here are answers to frequently asked questions.
{}
:  Should I use mORMot 1 since mORMot 2 is the maintained version?
{}
{\b mORMot 2} is the way to go for any new project. mORMot 1 is in bug-fix-only mode. For existing mORMot 1 projects, we continue to fix bugs and supply SQLite3 updates, but no new features will appear. Consider migrating to mORMot 2 when you have time - the process is straightforward once you change to the new units.
{}
:  The documentation is too long to read quickly.
{}
You don't need to read everything - most is detailed API reference. But do read the first part covering main concepts and patterns (15-30 minutes). Also see the slides and examples available at @https://github.com/synopse/mORMot2
{}
:  Where should I start?
{}
1. Read the Architecture Principles (Chapter 2)
2. Download and install the sources
3. Compile and run the test programs in {\f1\fs20 /test}
4. Learn about ORM, SOA, and MVC concepts
5. Try the sample projects in {\f1\fs20 /ex} folder
{}
:  I'm not a fan of ORM - I prefer writing SQL.
{}
ORM makes development easier, but you can use interface-based services with "manual" SQL via the {\f1\fs20 mormot.db.*} classes for high performance and direct JSON export.
{}
:  mORMot requires inheriting from TOrm. Can I use any object?
{}
We discuss this in detail in the ORM chapter. Adding attributes to existing classes pollutes your code. The framework provides CQRS services to persist any PODO (Plain Old Delphi Object) without requiring {\f1\fs20 @**TOrm@} inheritance.
{}
:  Why don't you use generics or class attributes?
{}
Our framework uses Object Pascal's type system effectively - specifying a class or interface type as parameter is safe and efficient. Generics tend to bloat executables, reduce performance, and hide implementation details. Attributes pollute code and introduce coupling. These features also reduce compatibility with older Delphi and FPC.
{}
:  What are RawUtf8 and other special types?
{}
The framework uses @*UTF-8@ internally. {\f1\fs20 RawUtf8} is optimized for UTF-8 strings across all Delphi versions. Search the keyword index for {\f1\fs20 RawUtf8} or see the Core Units chapter.
{}
:  My client receives non-standard JSON with unquoted fields.
{}
Internally, the framework uses MongoDB extended JSON syntax (unquoted fields) for better performance. Add a proper {\f1\fs20 User-Agent} HTTP header to receive standard {\f1\fs20 "field":value} JSON.
{}
:  Why is this framework named mORMot?
{}
- Because marmots hibernate, like our precious objects
- Because marmots are highly social and communicate with whistles, like our connected applications
- Because "Manage Object Relational Mapping Over Territory" works as an acronym
- Because we like mountains and those large ground rodents!
{}
:106 Getting Started
{}
:  Installation
{}
Clone from GitHub:
$git clone https://github.com/synopse/mORMot2.git
{}
:  Minimal Project Setup
{}
!program MyFirstMormot;
!
!{$APPTYPE CONSOLE}
!
!uses
!  mormot.core.base,
!  mormot.core.os,
!  mormot.orm.core,
!  mormot.orm.sqlite3,
!  mormot.rest.sqlite3,
!  mormot.rest.http.server;
!
!type
!  TOrmSample = class(TOrm)
!  private
!    fName: RawUtf8;
!    fValue: Integer;
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Value: Integer read fValue write fValue;
!  end;
!
!var
!  Model: TOrmModel;
!  Server: TRestServerDB;
!  HttpServer: TRestHttpServer;
!begin
!  // Create ORM model with our class
!  Model := TOrmModel.Create([TOrmSample]);
!
!  // Create REST server with SQLite3 storage
!  Server := TRestServerDB.Create(Model, 'sample.db3');
!  Server.Server.CreateMissingTables;
!
!  // Wrap in HTTP server
!  HttpServer := TRestHttpServer.Create('8080', [Server], '+', useHttpAsync);
!  try
!    WriteLn('Server running on http://localhost:8080');
!    WriteLn('Press Enter to quit...');
!    ReadLn;
!  finally
!    HttpServer.Free;
!    Server.Free;
!    Model.Free;
!  end;
!end.
{}
:  Required Units by Feature
{}
{\b Core functionality:}
!uses
!  mormot.core.base,      // Foundation types
!  mormot.core.os,        // OS abstraction
!  mormot.core.text,      // Text processing
!  mormot.core.json;      // JSON handling
{}
{\b ORM/Database:}
!uses
!  mormot.orm.core,       // TOrm, TOrmModel
!  mormot.orm.sqlite3,    // SQLite3 ORM
!  mormot.db.sql.sqlite3; // SQLite3 engine (if direct SQL needed)
{}
{\b REST Server/Client:}
!uses
!  mormot.rest.core,        // TRest base
!  mormot.rest.server,      // TRestServer
!  mormot.rest.client,      // TRestClient
!  mormot.rest.http.server, // TRestHttpServer
!  mormot.rest.http.client; // TRestHttpClient
{}
{\b Services (SOA):}
!uses
!  mormot.soa.core,    // Service interfaces
!  mormot.soa.server,  // Server-side services
!  mormot.soa.client;  // Client-side service consumption
{}
{\i Next Chapter: Architecture Principles}
{}

; === mORMot2-SAD-Chapter-02.md ===
; Converted from Markdown - Chapter 2
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:2Architecture Principles
{}
{\i Adopt a m@*ORM@ot}
{}
This framework implements established "best-practice" patterns:
{}
- {\b Model-View-Controller} (@*MVC@)
- {\b Multi-tier architecture}
- {\b Test-Driven Design}
- {\b Stateless @*CRUD@/@*REST@}
- {\b Object-Relational Mapping} (ORM)
- {\b Object-Document Mapping} (@*ODM@)
- {\b Service-Oriented Architecture} (@*SOA@)
{}
These patterns enable implementing projects up to complex {\i Domain-Driven Design} architectures.
{}
:201 General Design
{}
The mORMot 2 architecture follows a layered design:
{}
$┌────────────────────────────────────────────────────────────────────┐
$│                      mORMot 2 Architecture                         │
$├────────────────────────────────────────────────────────────────────┤
$│                                                                    │
$│  ┌───────────────┐                       ┌───────────────┐         │
$│  │  Web Clients  │                       │ REST Clients  │         │
$│  │ (AJAX/Mobile) │                       │(Delphi/FPC/…) │         │
$│  └───────┬───────┘                       └───────┬───────┘         │
$│          │                                       │                 │
$│          └───────────────┬───────────────────────┘                 │
$│                          │ RESTful JSON                            │
$│                          ▼                                         │
$│  ┌──────────────────────────────────────────────────────────────┐  │
$│  │                      TRestServer                             │  │
$│  │  ┌────────────┐  ┌───────────┐  ┌───────────────────────┐    │  │
$│  │  │ Auth       │  │ MVC/MVVM  │  │ Services              │    │  │
$│  │  │ (Sessions) │  │ WebServer │  │ (Interface-based SOA) │    │  │
$│  │  └────────────┘  └───────────┘  └───────────────────────┘    │  │
$│  │                         │                                    │  │
$│  │                ┌────────┴────────┐                           │  │
$│  │                │    IRestOrm     │                           │  │
$│  │                │    ORM Layer    │                           │  │
$│  │                └────────┬────────┘                           │  │
$│  └─────────────────────────┼────────────────────────────────────┘  │
$│                            │                                       │
$│  ┌─────────────────────────┴────────────────────────────────────┐  │
$│  │                    Storage Backends                          │  │
$│  │  ┌─────────┐  ┌─────────┐  ┌─────────┐  ┌────────────────┐   │  │
$│  │  │ SQLite3 │  │External │  │ MongoDB │  │ In-Memory/File │   │  │
$│  │  │ (native)│  │  SQL    │  │ (NoSQL) │  │  (JSON/Binary) │   │  │
$│  │  └─────────┘  └─────────┘  └─────────┘  └────────────────┘   │  │
$│  └──────────────────────────────────────────────────────────────┘  │
$│                                                                    │
$│  Cross-Cutting Features:                                           │
$│  ┌──────────────────────────────────────────────────────────────┐  │
$│  │ Compression │ Security │ Crypto │ Logging │ Testing │ JSON   │  │
$│  └──────────────────────────────────────────────────────────────┘  │
$└────────────────────────────────────────────────────────────────────┘
{}
Key concepts of mORMot 2:
{}
- {\b Cross-Platform}: Multiple clients and devices supported
- {\b Integration-friendly}: Can integrate with existing codebases
- {\b Client-Server RESTful}: @*JSON@ over @*HTTP@/@*HTTPS@/@*WebSocket@s
- {\b Layered (multi-tier)}: Clear separation of concerns
- {\b Service-Oriented}: Business logic via SOA interfaces
- {\b Shared Model}: Business rules and data model shared by clients and server
- {\b ORM/ODM}: Data mapped to objects for SQL and NoSQL
- {\b Flexible Storage}: @*SQLite3@, external SQL, @*MongoDB@, in-memory, or remote mORMot servers
- {\b Integrated Security}: Authentication and authorization at all layers
- {\b MVC/@*MVVM@}: Build web applications from ORM/SOA methods
- {\b Pattern-based}: REST, JSON, MVC, @*SOLID@ principles
- {\b Testable}: Integrated testing and debugging API
- {\b Optimized}: Built for scaling and stability
{}
:202 Architecture Design Process
{}
Architecture should be driven by actual application needs, not by theoretical patterns. There is no "one architecture fits all" solution. Architecture is about {\i how} you build your software.
{}
$┌─────────────────────────────────────────────────────────────────┐
$│            Iterative Architecture Process                       │
$│                                                                 │
$│  Customer ──► BackLog ──► Design ──► Dev ──► Software           │
$│     │            │          │         │         │               │
$│     │            │          │         │         │               │
$│  Use Cases  Requirements  Architecture Tasks   Definition       │
$│                              │                   of Done        │
$│                              │                                  │
$│                         Risk Assessment                         │
$│                         Technology & Models                     │
$└─────────────────────────────────────────────────────────────────┘
{}
:  Avoiding Weak Design
{}
Common pitfalls to avoid:
{}
- Letting each developer decide implementation without review
- Letting teams work in isolation without system-wide collaboration
- Architecture at such a high level it doesn't affect coding
- Architecture so detailed that code becomes over-engineered
- Blindly following technology trends without evaluation
{}
:  Recommended Practices
{}
- {\b Collaboration}: No one is alone, no team is better, no manager is always right
- {\b Sharing}: Between individuals, teams, and managers
- {\b Customer focus}: Stay content and customer focused
- {\b Long-term thinking}: Today's implementation prepares tomorrow
- {\b Pragmatism}: Make tomorrow's work easier
- {\b Courage}: "They did not know it was impossible, so they did it"
{}
Frameworks like mORMot provide integrated, working sets of classes so you can focus on your product while enjoying collaboration with the Open Source community.
{}
:203 Model-View-Controller (MVC)
{}
The {\i Model-View-Controller} (MVC) pattern isolates domain logic from user interface, permitting independent development, testing, and maintenance.
{}
$┌───────────────────────────────────────────────────────────┐
$│                    MVC Pattern                            │
$│                                                           │
$│  ┌──────────┐    Uses     ┌──────────┐                    │
$│  │Controller│ ──────────► │  Model   │                    │
$│  └──────────┘             └──────────┘                    │
$│       │                         │                         │
$│       │ Command                 │ Notify Updates          │
$│       ▼                         ▼                         │
$│  ┌──────────┐    Refresh  ┌──────────┐                    │
$│  │   View   │ ◄────────── │  Model   │                    │
$│  └──────────┘             └──────────┘                    │
$└───────────────────────────────────────────────────────────┘
{}
{\b Model}: Manages behavior and data of the application domain. Responds to requests for information about its state and instructions to change state. In mORMot, implemented via {\f1\fs20 TOrmModel} class which centralizes all {\f1\fs20 TOrm}-inherited classes.
{}
{\b View}: Renders the model into a form suitable for interaction:
- {\b Desktop clients}: Auto-generated UI using @*RTTI@
- {\b Web clients}: Mustache templates with Delphi controllers
- {\b AJAX clients}: RESTful JSON services
{}
{\b Controller}: Receives user input and initiates responses by making calls on model objects. In mORMot, already implemented within RESTful commands. Custom actions implemented via {\f1\fs20 TOrm} classes or RESTful Services.
{}
:204 Multi-Tier Architecture
{}
Multi-tier architecture separates presentation, application processing, and data management into logically separate processes.
{}
:  Two-Tier (Traditional RAD)
{}
$┌─────────────────────────────────────────────────────────┐
$│  ┌─────────────────────┐    ┌─────────────────────┐     │
$│  │  Application Tier   │    │    Data Tier        │     │
$│  │  (UI + Logic mixed) │───►│    (Database)       │     │
$│  └─────────────────────┘    └─────────────────────┘     │
$└─────────────────────────────────────────────────────────┘
{}
:  Three-Tier (mORMot ORM/SOA)
{}
$┌─────────────────────────────────────────────────────────────────┐
$│  ┌─────────────────┐  ┌─────────────────┐  ┌─────────────────┐  │
$│  │ Presentation    │  │   Logic Tier    │  │   Data Tier     │  │
$│  │     Tier        │─►│  (ORM + SOA)    │─►│  (Database)     │  │
$│  └─────────────────┘  └─────────────────┘  └─────────────────┘  │
$└─────────────────────────────────────────────────────────────────┘
{}
:  Four-Tier (Domain-Driven Design)
{}
$┌───────────────────────────────────────────────────────────────────────┐
$│  ┌──────────────┐  ┌──────────────┐  ┌──────────────┐  ┌──────────┐   │
$│  │ Presentation │  │ Application  │  │Business Logic│  │  Data    │   │
$│  │    Tier      │─►│    Tier      │─►│    Tier      │─►│  Tier    │   │
$│  │(Delphi/AJAX) │  │(JSON Server) │  │  (Domain)    │  │(Storage) │   │
$│  └──────────────┘  └──────────────┘  └──────────────┘  └──────────┘   │
$└───────────────────────────────────────────────────────────────────────┘
{}
In mORMot 2:
{}
- {\b Data Tier}: SQLite3, external databases (@*PostgreSQL@, @*MySQL@, @*Oracle@, MS SQL, etc.), MongoDB, or in-memory storage
- {\b Logic Tier}: ORM and SOA implementation - Delphi classes mapped to database via ORM, business logic as interfaces
- {\b Presentation Tier}: Delphi clients, AJAX applications, or MVC web apps
{}
:205 Service-Oriented Architecture (SOA)
{}
SOA is a design approach where functionality is packaged as inter-operable services that can be used across multiple systems and business domains.
{}
$┌──────────────────────────────────────────────────────────────────┐
$│                    SOA Architecture                              │
$│                                                                  │
$│  Consumers                Service Bus               Publishers   │
$│  ─────────                ───────────               ──────────   │
$│  ┌─────────┐             ┌───────────┐            ┌───────────┐  │
$│  │Client A │◄───────────►│           │◄──────────►│Publisher 1│  │
$│  └─────────┘             │           │            └───────────┘  │
$│  ┌─────────┐             │  Service  │            ┌───────────┐  │
$│  │Client B │◄───────────►│    Bus    │◄──────────►│Publisher 2│  │
$│  └─────────┘             │           │            └───────────┘  │
$│  ┌─────────┐             │           │            ┌───────────┐  │
$│  │Client C │◄───────────►│           │◄──────────►│Publisher 3│  │
$│  └─────────┘             └───────────┘            └───────────┘  │
$└──────────────────────────────────────────────────────────────────┘
{}
:  Key SOA Characteristics
{}
A software {\b service} is a logical representation of a repeatable activity that produces a precise result. Services are:
{}
- {\b Loosely coupled}: No embedded calls to other services
- {\b Stateless}: Each invocation is independent
- {\b Single responsibility}: Each service implements one action
- {\b Protocol-based}: Defined protocols describe how services communicate
{}
:  SOA Benefits: Decoupling
{}
|%13%55%32
|\b Dependency|Desired Decoupling|Technique\b0
|Platform|Hardware/Framework/OS should not constrain choices|Standard protocols (REST/JSON)
|Location|Consumers unaffected by hosting changes|Routing and proxies
|Availability|Maintenance transparent to clients|Server-side support
|Versions|New services without client upgrades|Contract marshalling
|%
{}
:  ORM + SOA Coexistence
{}
ORM and SOA complement each other:
{}
- {\b ORM}: Efficient data access with native objects (CQRS pattern)
- {\b SOA}: High-level business logic with custom parameters, reducing bandwidth
{}
In mORMot 2, interface-based SOA allows the same code to run on both client and server with better server performance and full interoperability.
{}
:206 Object-Relational Mapping (ORM)
{}
ORM provides methods to persist high-level objects into a relational database.
{}
$┌───────────────────────────────────────────────────────────────┐
$│                      ORM Process                              │
$│                                                               │
$│  ┌──────────────┐    ┌─────────────┐    ┌──────────────────┐  │
$│  │    Object    │───►│     ORM     │───►│     RDBMS        │  │
$│  │   Instance   │    │   (CRUD)    │    │   (Database)     │  │
$│  └──────────────┘    └─────────────┘    └──────────────────┘  │
$│                            │                                  │
$│                      SQL Mapping                              │
$└───────────────────────────────────────────────────────────────┘
{}
:  ORM Mapping Sources
{}
$┌────────────────────────────────────────────────────────────────┐
$│  ┌─────────────────┐         ┌─────────────────┐               │
$│  │   Class Type    │         │   Data Model    │               │
$│  │   (via RTTI)    │────────►│   (Database)    │               │
$│  └─────────────────┘         └─────────────────┘               │
$│           │                           │                        │
$│           └───────────┬───────────────┘                        │
$│                       │                                        │
$│                  ┌────┴────┐                                   │
$│                  │   ORM   │                                   │
$│                  └─────────┘                                   │
$└────────────────────────────────────────────────────────────────┘
{}
:  Comparison of Approaches
{}
|%13%44%43
|\b Scheme|Pros|Cons\b0
|{\b RAD DB Components}|SQL is powerful; RAD approach|Business logic limited; SQL binds to engine; Poor multi-tier
|{\b Manual SQL Mapping}|Elaborated business logic|SQL must be hand-coded; Duplication; Engine-specific
|{\b Database ORM}|SQL generated by ORM; Engine-agnostic|More abstraction needed; May retrieve excess data
|{\b Client-Server ORM}|All ORM benefits; Services for precise data; Full multi-tier|More abstraction needed
|%
{}
mORMot implements a {\b Client-Server ORM} that can scale from stand-alone mode to complex Domain-Driven Design.
{}
:207 NoSQL and Object-Document Mapping (ODM)
{}
:  SQL vs NoSQL
{}
{\b SQL (Relational)}:
- Schema-based
- Relational model with JOINs
- @*ACID@ transactions
- Time-proven and efficient
{}
{\b NoSQL}:
- "Not Only SQL"
- Designed for web scale and BigData
- Easy replication and simple APIs
- No standard (diverse implementations)
{}
:  NoSQL Families
{}
1. {\b Graph-oriented}: Store data by relations (e.g., Neo4j)
2. {\b Aggregate-oriented}:
   - Document-based (MongoDB, CouchDB)
   - Key/Value (Redis, Riak)
   - Column family (Cassandra, HBase)
{}
:  Document Model Example
{}
SQL stores data per table (requires JOINs):
$┌─────────────────┐  ┌─────────────────┐  ┌─────────────────┐
$│     Users       │  │    Contacts     │  │     Access      │
$├─────────────────┤  ├─────────────────┤  ├─────────────────┤
$│ ID | UserName   │  │ UserID | Phone  │  │ UserID | Level  │
$└─────────────────┘  └─────────────────┘  └─────────────────┘
{}
NoSQL stores as documents (embedded):
${
$  "ID": 1234,
$  "UserName": "John Smith",
$  "Contact": {
$    "Phone": "123-456-789",
$    "Email": "xyz@abc.com"
$  },
$  "Access": {
$    "Level": 5,
$    "Group": "dev"
$  }
$}
{}
:  SQL vs NoSQL Trade-offs
{}
|%47%53
|\b SQL|NoSQL\b0
|Ubiquitous SQL language|Maps OOP and complex types natively
|Easy vertical scaling|Horizontal scaling (sharding)
|Data normalization|Schema-less evolution
|Data consistency (single source)|Version management
|Complex ACID transactions|Graph/Document native storage
|Aggregation functions|Map/Reduce support
|%
{}
With mORMot, you can switch from SQL to MongoDB with one line of code change, even at runtime.
{}
:208 Domain-Driven Design (DDD)
{}
:  Definition
{}
From domaindrivendesign.org:
{}
{\i "The premise of domain-driven design is two-fold:}
- {\i For most software projects, the primary focus should be on the domain and domain logic;}
- {\i Complex domain designs should be based on a model."}
{}
:  DDD in mORMot
{}
mORMot enables @*DDD@ through:
{}
- {\b Entities}: {\f1\fs20 TOrm} descendants representing persistent domain objects
- {\b Value Objects}: Records and managed types for immutable data
- {\b Aggregates}: Object graphs with clear boundaries
- {\b Repositories}: {\f1\fs20 IRestOrm} interface for data access
- {\b Services}: Interface-based SOA for domain operations
- {\b Domain Events}: Async notifications via WebSockets
{}
:  Implementation Layers
{}
$┌─────────────────────────────────────────────────────────────────────────┐
$│                        DDD with mORMot 2                                │
$│                                                                         │
$│  ┌───────────────────────────────────────────────────────────────────┐  │
$│  │ Domain Layer (Pure Pascal)                                        │  │
$│  │ · TOrm entities with business logic                               │  │
$│  │ · Value Objects as records                                        │  │
$│  │ · Aggregates with clear boundaries                                │  │
$│  └───────────────────────────────────────────────────────────────────┘  │
$│                                  │                                      │
$│  ┌───────────────────────────────┴───────────────────────────────────┐  │
$│  │ Application Layer (Services)                                      │  │
$│  │ · IInvokable interfaces (mormot.soa.*)                            │  │
$│  └───────────────────────────────────────────────────────────────────┘  │
$│                                  │                                      │
$│  ┌───────────────────────────────┴───────────────────────────────────┐  │
$│  │ Infrastructure Layer                                              │  │
$│  │ · IRestOrm repositories (mormot.orm.*)                            │  │
$│  │ · TSqlDBConnection (mormot.db.*)                                  │  │
$│  └───────────────────────────────────────────────────────────────────┘  │
$│                                  │                                      │
$│  ┌───────────────────────────────┴───────────────────────────────────┐  │
$│  │ Presentation Layer                                                │  │
$│  │ · TRestHttpServer (mormot.rest.*)                                 │  │
$│  │ · MVC views (mormot.core.mvc)                                     │  │
$│  └───────────────────────────────────────────────────────────────────┘  │
$└─────────────────────────────────────────────────────────────────────────┘
{}
:209 SOLID Principles in mORMot 2
{}
mORMot 2 embraces SOLID principles:
{}
:  Single Responsibility
- Each unit focuses on one concern
- @!src\core\mormot.core.json.pas@ handles JSON, @!src\core\mormot.core.rtti.pas@ handles RTTI
{}
:  Open/Closed
- Classes open for extension via inheritance
- Core behavior closed to modification
{}
:  Liskov Substitution
- {\f1\fs20 TOrm} descendants can substitute the base class
- Storage backends interchangeable
{}
:  Interface Segregation
- {\f1\fs20 IRestOrm} vs {\f1\fs20 IRestOrmClient} vs {\f1\fs20 IRestOrmServer}
- Clients only depend on what they need
{}
:  Dependency Inversion
- Code against interfaces ({\f1\fs20 IRestOrm}), not implementations
- DI support via {\f1\fs20 TInjectableObjectRest}
{}
:  Composition Over Inheritance (mORMot 2 Key Change)
{}
{\b mORMot 1} used inheritance:
!TSQLRestServer = class(TSQLRest)
!  // ORM methods directly in class
!  function Add(...): TID;
{}
{\b mORMot 2} uses composition:
!TRest = class
!  property Orm: IRestOrm;     // ORM via interface
!  property Services: TServiceContainer;  // SOA via container
!end;
!
!// Access ORM through .Orm property
!Server.Orm.Add(Customer);
{}
This change improves:
- {\b Testability}: Mock individual components
- {\b Flexibility}: Swap implementations
- {\b Clarity}: Clear boundaries between concerns
{}
{\i Next Chapter: Meet mORMot 2 - New Units and Structure}
{}

; === mORMot2-SAD-Chapter-03.md ===
; Converted from Markdown - Chapter 3
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:3Meet mORMot 2 - Unit Structure
{}
{\i Enter the new territory}
{}
m@*ORM@ot 2 represents a complete restructuring of the original framework. The monolithic units ({\f1\fs20 SynCommons.pas}, {\f1\fs20 mORMot.pas}) have been split into focused, layered units following @*SOLID@ principles.
{}
This chapter introduces the new unit organization and helps you understand which units to include for your specific needs.
{}
:301 Layered Architecture Overview
{}
mORMot 2 organizes its ~130 units into 6 dependency layers:
{}
$┌─────────────────────────────────────────────────────────────────────┐
$│  Layer 5: Application & Tools                                       │
$│  ┌─────┬─────┬────────┬──────┬───────┬─────┐                        │
$│  │ app │ ui  │ script │ misc │ tools │ ddd │                        │
$│  └─────┴─────┴────────┴──────┴───────┴─────┘                        │
$└─────────────────────────────────────────────────────────────────────┘
$                              │
$┌─────────────────────────────────────────────────────────────────────┐
$│  Layer 4: ORM / REST / SOA                                          │
$│  ┌─────┬──────┬─────┐                                               │
$│  │ orm │ rest │ soa │                                               │
$│  └─────┴──────┴─────┘                                               │
$└─────────────────────────────────────────────────────────────────────┘
$                              │
$┌─────────────────────────────────────────────────────────────────────┐
$│  Layer 3: Database Access                                           │
$│  ┌────┐                                                             │
$│  │ db │                                                             │
$│  └────┘                                                             │
$└─────────────────────────────────────────────────────────────────────┘
$                              │
$┌─────────────────────────────────────────────────────────────────────┐
$│  Layer 2: Networking                                                │
$│  ┌─────┐                                                            │
$│  │ net │                                                            │
$│  └─────┘                                                            │
$└─────────────────────────────────────────────────────────────────────┘
$                              │
$┌─────────────────────────────────────────────────────────────────────┐
$│  Layer 1: System Libraries & Cryptography                           │
$│  ┌─────┬────────┐                                                   │
$│  │ lib │ crypt  │                                                   │
$│  └─────┴────────┘                                                   │
$└─────────────────────────────────────────────────────────────────────┘
$                              │
$┌─────────────────────────────────────────────────────────────────────┐
$│  Layer 0: Foundation (RTL-Only)                                     │
$│  ┌──────┐                                                           │
$│  │ core │  (24 units - no mORMot dependencies)                      │
$│  └──────┘                                                           │
$└─────────────────────────────────────────────────────────────────────┘
{}
{\b Key Principle}: Lower layers never depend on higher ones. This ensures:
- Incremental compilation
- Selective deployment
- Modular testing
- Clear separation of concerns
{}
:302 Unit Naming Convention
{}
All units follow a consistent naming pattern:
{}
!mormot.<layer>.<feature>.pas
{}
Examples:
- {\f1\fs20 mormot.core.json.pas} - Core layer, @*JSON@ feature
- {\f1\fs20 mormot.orm.core.pas} - ORM layer, core functionality
- {\f1\fs20 mormot.db.sql.postgres.pas} - Database layer, @*PostgreSQL@ SQL connector
{}
:  Location Rules
{}
Units are located in folders matching their layer:
- {\f1\fs20 src/core/{\f1\fs20 mormot.core.}*.pas}
- {\f1\fs20 src/orm/{\f1\fs20 mormot.orm.}*.pas}
- {\f1\fs20 src/db/{\f1\fs20 mormot.db.}*.pas}
- etc.
{}
:303 Layer 0: Core Foundation (mormot.core.*)
{}
{\b 24 units} providing RTL-level functionality with {\b zero mORMot dependencies}.
{}
:  Dependency Chain
{}
!mormot.core.base (RTL types, ASM stubs, no dependencies)
$  └─► mormot.core.os (OS abstraction, threading)
$      └─► mormot.core.unicode (charset/encoding)
$          └─► mormot.core.text (text parsing, formatting)
$              └─► mormot.core.datetime (ISO-8601, TTimeLog)
$                  └─► mormot.core.rtti (RTTI wrapper)
$                      └─► mormot.core.buffers (compression, base64)
$                          └─► mormot.core.data (TDynArray, serialization)
$                              └─► mormot.core.json (JSON parsing)
$                                  └─► [higher units: variants, log, etc.]
{}
:  Key Core Units
{}
|%9%52%39
|\b Unit|Purpose|Key Types\b0
|@!src\core\mormot.core.base.pas@|Foundation types, ASM|{\f1\fs20 RawUtf8}, {\f1\fs20 PtrInt}, {\f1\fs20 TDynArray} basics
|@!src\core\mormot.core.os.pas@|OS abstraction|{\f1\fs20 TSynLocker}, {\f1\fs20 GetTickCount64}
|@!src\core\mormot.core.unicode.pas@|Charset conversion|{\f1\fs20 Utf8ToWideString}, {\f1\fs20 WinAnsiToUtf8}
|@!src\core\mormot.core.text.pas@|Text processing|{\f1\fs20 FormatUtf8}, CSV parsing
|@!src\core\mormot.core.rtti.pas@|@*RTTI@ abstraction|{\f1\fs20 TRttiCustom}, {\f1\fs20 PRttiInfo}
|@!src\core\mormot.core.json.pas@|JSON handling|{\f1\fs20 TJsonWriter}, {\f1\fs20 GetJsonField}
|@!src\core\mormot.core.data.pas@|Data structures|{\f1\fs20 TDynArray}, {\f1\fs20 TDynArrayHashed}
|@!src\core\mormot.core.variants.pas@|Dynamic documents|{\f1\fs20 TDocVariant}, {\f1\fs20 IDocDict}
|@!src\core\mormot.core.log.pas@|Logging framework|{\f1\fs20 TSynLog}, {\f1\fs20 ISynLog}
|@!src\core\mormot.core.threads.pas@|Threading utilities|{\f1\fs20 TSynBackgroundThread}
|@!src\core\mormot.core.test.pas@|Testing framework|{\f1\fs20 TSynTestCase}
|@!src\core\mormot.core.mustache.pas@|Template engine|{\f1\fs20 TSynMustache}
|@!src\core\mormot.core.interfaces.pas@|Interface support|DI/@*IoC@ container
|%
{}
:  Minimal Core Usage
{}
!uses
!  mormot.core.base,    // Foundation types
!  mormot.core.os,      // OS abstraction
!  mormot.core.text,    // Text utilities
!  mormot.core.json;    // JSON support
!
!var
!  doc: TDocVariantData;
!begin
!  doc.InitJson('{"name":"John","age":30}');
!  WriteLn(doc.U['name']);  // Output: John
!end;
{}
:304 Layer 1: Libraries & Cryptography
{}
:  External Libraries (mormot.lib.*)
{}
{\b 14 units} wrapping external libraries:
{}
|%12%88
|\b Unit|External Library\b0
|@!src\lib\mormot.lib.z.pas@|zlib/libdeflate compression
|{\f1\fs20 mormot.lib.openssl11}|OpenSSL 1.1/3.x
|@!src\lib\mormot.lib.curl.pas@|libcurl @*HTTP@ client
|@!src\lib\mormot.lib.sspi.pas@|Windows SSPI (Kerberos)
|@!src\lib\mormot.lib.gssapi.pas@|POSIX GSSAPI
|@!src\lib\mormot.lib.quickjs.pas@|QuickJS JavaScript engine
|@!src\lib\mormot.lib.winhttp.pas@|Windows WinHTTP
|{\f1\fs20 mormot.lib.pkcs11}|Hardware security modules
|%
{}
:  Cryptography (mormot.crypt.*)
{}
{\b 10 units} for cryptographic operations:
{}
|%9%91
|\b Unit|Purpose\b0
|@!src\crypt\mormot.crypt.core.pas@|AES, SHA-2, SHA-3, HMAC, PBKDF2
|@!src\crypt\mormot.crypt.secure.pas@|High-level factories, password hashing
|@!src\crypt\mormot.crypt.ecc.pas@|Elliptic Curve Cryptography
|{\f1\fs20 mormot.crypt.ecc256r1}|secp256r1 curve implementation
|@!src\crypt\mormot.crypt.rsa.pas@|RSA encryption/signatures
|@!src\crypt\mormot.crypt.jwt.pas@|JSON Web Tokens
|{\f1\fs20 mormot.crypt.x509}|X.509 certificates
|@!src\crypt\mormot.crypt.openssl.pas@|OpenSSL wrapper
|%
{}
:  Cryptography Factory Pattern
{}
!uses
!  mormot.crypt.secure;
!
!// High-level factories (recommended)
!var
!  h: TCryptHasher;
!  c: ICryptCipher;
!begin
!  // Hashing - use Hasher() to get TCryptHasher with Full() method
!  h := Hasher('sha256');
!  digest := h.Full(pointer(data), length(data));
!
!  // Encryption
!  c := Cipher('aes-256-ctr', @key[1], {encrypt:}true);
!  c.Process(plain, encrypted, '');
!end;
{}
:305 Layer 2: Networking (mormot.net.*)
{}
{\b 18 units} for network communication:
{}
:  Socket & HTTP
{}
|%10%90
|\b Unit|Purpose\b0
|@!src\net\mormot.net.sock.pas@|Cross-platform socket abstraction
|@!src\net\mormot.net.http.pas@|HTTP protocol state machine
|@!src\net\mormot.net.client.pas@|HTTP clients (Socket, WinHTTP, curl)
|@!src\net\mormot.net.server.pas@|HTTP servers (threaded, http.sys)
|@!src\net\mormot.net.async.pas@|Event-driven async I/O
|%
{}
:  WebSockets
{}
|%14%86
|\b Unit|Purpose\b0
|@!src\net\mormot.net.ws.core.pas@|@*WebSocket@ protocol core
|@!src\net\mormot.net.ws.client.pas@|WebSocket client
|@!src\net\mormot.net.ws.server.pas@|WebSocket server
|@!src\net\mormot.net.ws.async.pas@|Async WebSocket server
|%
{}
:  Specialized Protocols
{}
|%14%86
|\b Unit|Purpose\b0
|@!src\net\mormot.net.dns.pas@|DNS resolution
|@!src\net\mormot.net.ldap.pas@|@*LDAP@ client
|@!src\net\mormot.net.acme.pas@|ACME/Let's Encrypt
|@!src\net\mormot.net.relay.pas@|Firewall traversal
|@!src\net\mormot.net.openapi.pas@|OpenAPI client generator
|%
{}
:306 Layer 3: Database Access (mormot.db.*)
{}
{\b 27 units} for SQL and NoSQL database access:
{}
:  Core Database
{}
|%16%84
|\b Unit|Purpose\b0
|@!src\db\mormot.db.core.pas@|Shared database types
|@!src\db\mormot.db.sql.pas@|Abstract SQL classes
|@!src\db\mormot.db.proxy.pas@|Remote database proxy
|%
{}
:  Raw Database APIs
{}
|%18%82
|\b Unit|Database\b0
|{\f1\fs20 mormot.db.raw.sqlite3}|@*SQLite3@ native API
|@!src\db\mormot.db.raw.postgres.pas@|PostgreSQL API
|@!src\db\mormot.db.raw.oracle.pas@|@*Oracle@ OCI
|@!src\db\mormot.db.raw.odbc.pas@|ODBC API
|@!src\db\mormot.db.raw.oledb.pas@|OLE DB API
|%
{}
:  SQL Connectors
{}
|%13%87
|\b Unit|Database\b0
|{\f1\fs20 mormot.db.sql.sqlite3}|SQLite3
|@!src\db\mormot.db.sql.postgres.pas@|PostgreSQL
|@!src\db\mormot.db.sql.oracle.pas@|Oracle
|@!src\db\mormot.db.sql.odbc.pas@|Any ODBC source
|@!src\db\mormot.db.sql.oledb.pas@|Any OLE DB source
|@!src\db\mormot.db.sql.zeos.pas@|Via ZDBC (cross-database)
|%
{}
:  NoSQL
{}
|%22%78
|\b Unit|Database\b0
|@!src\db\mormot.db.nosql.bson.pas@|BSON encoding
|@!src\db\mormot.db.nosql.mongodb.pas@|@*MongoDB@ client
|%
{}
:  RAD Adapters
{}
|%17%83
|\b Unit|Purpose\b0
|@!src\db\mormot.db.rad.firedac.pas@|FireDAC integration
|@!src\db\mormot.db.rad.unidac.pas@|UniDAC integration
|@!src\db\mormot.db.rad.ui.orm.pas@|ORM-aware {\f1\fs20 TDataSet}
|%
{}
:307 Layer 4: ORM / REST / SOA
{}
:  ORM Layer (mormot.orm.*)
{}
{\b 9 units} for Object-Relational Mapping:
{}
|%13%87
|\b Unit|Purpose\b0
|@!src\orm\mormot.orm.base.pas@|Low-level ORM types
|@!src\orm\mormot.orm.core.pas@|{\f1\fs20 @**TOrm@}, {\f1\fs20 @**TOrmModel@}, {\f1\fs20 @**IRestOrm@}
|@!src\orm\mormot.orm.rest.pas@|@*REST@-based ORM base
|@!src\orm\mormot.orm.client.pas@|ORM client
|@!src\orm\mormot.orm.server.pas@|ORM server
|@!src\orm\mormot.orm.storage.pas@|Storage engine abstraction
|@!src\orm\mormot.orm.sql.pas@|SQL-based storage
|{\f1\fs20 mormot.orm.sqlite3}|SQLite3 ORM
|@!src\orm\mormot.orm.mongodb.pas@|MongoDB @*ODM@
|%
{}
:  REST Layer (mormot.rest.*)
{}
{\b 8 units} for RESTful services:
{}
|%16%84
|\b Unit|Purpose\b0
|@!src\rest\mormot.rest.core.pas@|{\f1\fs20 @**TRest@} base class
|@!src\rest\mormot.rest.client.pas@|REST client
|@!src\rest\mormot.rest.server.pas@|REST server
|@!src\rest\mormot.rest.http.client.pas@|HTTP REST client
|@!src\rest\mormot.rest.http.server.pas@|HTTP REST server
|@!src\rest\mormot.rest.mvc.pas@|@*MVC@/@*MVVM@ support
|{\f1\fs20 mormot.rest.sqlite3}|SQLite3 REST server
|@!src\rest\mormot.rest.memserver.pas@|In-memory REST server
|%
{}
:  SOA Layer (mormot.soa.*)
{}
{\b 4 units} for Service-Oriented Architecture:
{}
|%12%88
|\b Unit|Purpose\b0
|@!src\soa\mormot.soa.core.pas@|Interface-based @*SOA@ types
|@!src\soa\mormot.soa.client.pas@|Client service stubs
|@!src\soa\mormot.soa.server.pas@|Server service implementation
|@!src\soa\mormot.soa.codegen.pas@|Service code generation
|%
{}
:308 Layer 5: Application & Tools
{}
:  Application (mormot.app.*)
{}
|%12%88
|\b Unit|Purpose\b0
|@!src\app\mormot.app.console.pas@|Console application support
|@!src\app\mormot.app.daemon.pas@|Daemon/service support
|%
{}
:  UI Components (mormot.ui.*)
{}
|%16%84
|\b Unit|Purpose\b0
|@!src\ui\mormot.ui.core.pas@|VCL/LCL compatibility
|@!src\ui\mormot.ui.controls.pas@|Custom controls
|@!src\ui\mormot.ui.grid.orm.pas@|ORM-aware grids
|@!src\ui\mormot.ui.report.pas@|Reporting engine
|@!src\ui\mormot.ui.pdf.pas@|PDF generation
|%
{}
:  Scripting (mormot.script.*)
{}
|%13%87
|\b Unit|Purpose\b0
|@!src\script\mormot.script.quickjs.pas@|QuickJS JavaScript engine
|%
{}
:309 Common Usage Patterns
{}
:  Minimal HTTP Server with ORM
{}
!uses
!  mormot.core.base,
!  mormot.core.os,
!  mormot.orm.core,
!  mormot.orm.sqlite3,
!  mormot.rest.sqlite3,
!  mormot.rest.http.server;
!
!type
!  TOrmPerson = class(TOrm)
!  private
!    fName: RawUtf8;
!    fAge: Integer;
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Age: Integer read fAge write fAge;
!  end;
!
!var
!  Model: TOrmModel;
!  Server: TRestServerDB;
!  HttpServer: TRestHttpServer;
!begin
!  Model := TOrmModel.Create([TOrmPerson]);
!  Server := TRestServerDB.Create(Model, 'data.db3');
!  Server.Server.CreateMissingTables;
!
!  HttpServer := TRestHttpServer.Create('8080', [Server], '+', useHttpAsync);
!  try
!    WriteLn('Server running...');
!    ReadLn;
!  finally
!    HttpServer.Free;
!    Server.Free;
!    Model.Free;
!  end;
!end.
{}
:  Interface-Based Service
{}
!uses
!  mormot.core.base,
!  mormot.core.interfaces,
!  mormot.soa.core,
!  mormot.soa.server,
!  mormot.rest.server;
!
!type
!  ICalculator = interface(IInvokable)
!    ['{...GUID...}']
!    function Add(A, B: Integer): Integer;
!  end;
!
!  TCalculator = class(TInjectableObjectRest, ICalculator)
!  public
!    function Add(A, B: Integer): Integer;
!  end;
!
!function TCalculator.Add(A, B: Integer): Integer;
!begin
!  Result := A + B;
!end;
!
!// Registration
!Server.ServiceDefine(TCalculator, [ICalculator], sicShared);
{}
:  Database-Only (No REST)
{}
!uses
!  mormot.core.base,
!  mormot.db.core,
!  mormot.db.sql,
!  mormot.db.sql.postgres;
!
!var
!  Props: TSqlDBPostgresConnectionProperties;
!  Conn: TSqlDBConnection;
!  Stmt: TSqlDBStatement;
!begin
!  Props := TSqlDBPostgresConnectionProperties.Create(
!    'localhost:5432', 'mydb', 'user', 'pass');
!  Conn := Props.ThreadSafeConnection;
!
!  Stmt := Conn.NewStatementPrepared('SELECT * FROM users WHERE id=?', true);
!  try
!    Stmt.Bind(1, 42);
!    Stmt.ExecutePrepared;
!    while Stmt.Step do
!      WriteLn(Stmt.ColumnUtf8(0));
!  finally
!    Stmt.Free;
!  end;
!end;
{}
:310 Migration from mORMot 1
{}
:  Unit Mapping Summary
{}
|%48%52
|\b mORMot 1 Unit|mORMot 2 Units\b0
|{\f1\fs20 SynCommons.pas}|{\f1\fs20 mormot.core.*} (24 units)
|{\f1\fs20 mORMot.pas}|{\f1\fs20 mormot.orm.{\i } + {\f1\fs20 mormot.rest.}}
|{\f1\fs20 SynDB*.pas}|{\f1\fs20 mormot.db.*}
|{\f1\fs20 SynCrypto.pas}|{\f1\fs20 mormot.crypt.*}
|{\f1\fs20 SynCrtSock.pas}|{\f1\fs20 mormot.net.*}
|{\f1\fs20 SynEcc.pas}|{\f1\fs20 mormot.crypt.ecc*}
|%
{}
:  Type Mapping Summary
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 TSQLRecord}|{\f1\fs20 TOrm}
|{\f1\fs20 TSQLModel}|{\f1\fs20 TOrmModel}
|{\f1\fs20 TSQLRest}|{\f1\fs20 TRest}
|{\f1\fs20 TSQLRestServer}|{\f1\fs20 TRestServer}
|{\f1\fs20 TSQLRestClient}|{\f1\fs20 TRestClient}
|{\f1\fs20 TSQLRestServerDB}|{\f1\fs20 TRestServerDB}
|{\f1\fs20 TSQLHttpServer}|{\f1\fs20 TRestHttpServer}
|{\f1\fs20 RawUTF8}|{\f1\fs20 RawUtf8}
|%
{}
:  Backward Compatibility
{}
By default, mORMot 2 provides type aliases for compatibility:
!type
!  TSQLRecord = TOrm;
!  TSQLModel = TOrmModel;
!  // etc.
{}
Define {\f1\fs20 PUREMORMOT2} to disable these and use only new names:
!{$DEFINE PUREMORMOT2}
{}
{\i Next Chapter: Core Units ({\f1\fs20 mormot.core.}})*
{}

; === mORMot2-SAD-Chapter-04.md ===
; Converted from Markdown - Chapter 4
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:4Core Units (mormot.core.*)
{}
{\i The Foundation Bricks}
{}
The m@*ORM@ot 2 framework uses custom low-level types, classes, and functions instead of relying solely on the standard Delphi RTL. This design choice provides:
{}
- {\b Cross-platform and cross-compiler support} (Delphi 7 through 12.2, FPC 3.2+)
- {\b @*Unicode@ support} via native @*UTF-8@ encoding for all versions
- {\b Optimized performance} for speed, multi-threading, and memory efficiency
- {\b Consistent KISS design} with shared common features
{}
In mORMot 1, most of this functionality resided in a single 2.3MB {\f1\fs20 SynCommons.pas} file. In mORMot 2, this has been split into {\b 24 focused units} in the {\f1\fs20 mormot.core.*} namespace, following @*SOLID@ principles.
{}
:401 Conditional Defines
{}
A global {\f1\fs20 mormot.defines.inc} include file appears in all framework units:
{}
!{$I mormot.defines.inc}
{}
This defines key conditionals for portable and efficient code:
{}
|%8%92
|\b Define|Purpose\b0
|{\f1\fs20 PUREMORMOT2}|Disable mORMot 1.18 compatibility aliases (recommended for new code)
|{\f1\fs20 FPC_X64MM}|Use custom x64 memory manager (FPC only, Linux/Windows)
|{\f1\fs20 FPCMM_BOOST} / {\f1\fs20 FPCMM_SERVER}|Memory manager threading modes
|{\f1\fs20 NEW@*RTTI@NOTUSED}|Exclude Delphi 2010+ enhanced RTTI (smaller EXE)
|{\f1\fs20 USE_OPENSSL}|Enable OpenSSL integration (required on POSIX)
|%
{}
{\b Best Practice}: Set these in project options, not in unit source.
{}
:402 Unicode and UTF-8
{}
mORMot 2 has 100% Unicode compatibility across all Delphi and FPC versions. From its core to its uppermost features, the framework is {\b natively UTF-8}, which is the de-facto character encoding for @*JSON@, @*SQLite3@, and most supported database engines.
{}
:  String Types
{}
The following string types are used throughout the framework:
{}
|%8%80%12
|\b Type|Purpose|Location\b0
|{\f1\fs20 RawUtf8}|Primary type for all internal data (UTF-8 encoded)|@!src\core\mormot.core.base.pas@
|{\f1\fs20 RawByteString}|Binary byte storage|@!src\core\mormot.core.base.pas@
|{\f1\fs20 WinAnsiString}|WinAnsi-encoded text (code page 1252)|@!src\core\mormot.core.base.pas@
|{\f1\fs20 SynUnicode}|Fastest native Unicode ({\f1\fs20 WideString} pre-2009, {\f1\fs20 UnicodeString} after)|@!src\core\mormot.core.base.pas@
|{\f1\fs20 string}|Generic VCL/UI text (use only at presentation layer)|RTL
|%
{}
{\b Key Recommendation}: Use {\f1\fs20 RawUtf8} for all business logic and data processing. Convert to {\f1\fs20 string} only at the UI layer using {\f1\fs20 Utf8ToString()} / {\f1\fs20 StringToUtf8()} from @!src\core\mormot.core.unicode.pas@:
{}
!uses
!  mormot.core.base,
!  mormot.core.unicode;
!
!var
!  utf8: RawUtf8;
!  display: string;
!begin
!  utf8 := 'Hello UTF-8 World';
!  display := Utf8ToString(utf8);  // Convert for UI display
!  utf8 := StringToUtf8(display);  // Convert back for storage/processing
!end;
{}
:  Why UTF-8?
{}
- {\b JSON native}: All JSON is UTF-8 encoded
- {\b SQLite3 native}: SQLite3 stores text as UTF-8
- {\b Network efficient}: UTF-8 is compact for ASCII-heavy content
- {\b Memory efficient}: No temporary string conversions during parsing
- {\b Consistent}: Same encoding across all Delphi versions
{}
:403 Numeric Types
{}
:  Currency Handling
{}
The {\f1\fs20 currency} type is the standard Delphi type for monetary values, avoiding rounding errors with exact 4-decimal precision. It safely stores numbers in the range -922,337,203,685,477.5808 to 922,337,203,685,477.5807.
{}
mORMot provides fast currency-to-text conversion functions in @!src\core\mormot.core.text.pas@ that avoid FPU rounding issues:
{}
!uses
!  mormot.core.text;
!
!var
!  c: currency;
!  s: RawUtf8;
!begin
!  c := 123.45;
!  s := CurrencyToStr(c);  // Fast, no FPU rounding
!  c := StrToCurrency(s);  // Safe conversion back
!end;
{}
The {\f1\fs20 Int64} binary representation of {\f1\fs20 currency} (i.e., {\f1\fs20 value * 10000}) is used internally for maximum performance and precision.
{}
:  Cross-Platform Integer Types
{}
|%8%92
|\b Type|Purpose\b0
|{\f1\fs20 PtrInt}|Signed pointer-size integer (32 or 64 bit)
|{\f1\fs20 PtrUInt}|Unsigned pointer-size integer
|{\f1\fs20 TID}|64-bit record ID (Int64)
|%
{}
:404 TDynArray: Dynamic Array Wrapper
{}
{\f1\fs20 TDynArray} (in @!src\core\mormot.core.data.pas@) provides {\f1\fs20 TList}-like functionality for any dynamic array:
{}
:  Basic Usage
{}
!uses
!  mormot.core.base,
!  mormot.core.data;
!
!type
!  TIntegerArray = array of Integer;
!
!var
!  arr: TIntegerArray;
!  da: TDynArray;
!  v: Integer;
!begin
!  da.Init(TypeInfo(TIntegerArray), arr);  // Associate wrapper with array
!
!  for v := 1 to 1000 do
!    da.Add(v);  // TList-like Add method
!
!  da.Sort(SortDynArrayInteger);  // In-place sorting
!
!  v := 500;
!  if da.Find(v) >= 0 then  // Binary search (after sorting)
!    WriteLn('Found 500');
!
!  da.Delete(0);  // Delete by index
!  WriteLn('Count: ', da.Count);
!end;
{}
:  External Count for Performance
{}
For high-performance scenarios, use an external count variable to avoid reallocation on every Add/Delete:
{}
!var
!  arr: TIntegerArray;
!  da: TDynArray;
!  count: Integer;
!begin
!  da.Init(TypeInfo(TIntegerArray), arr, @count);  // External count
!  da.Capacity := 10000;  // Pre-allocate memory
!
!  // Now Add/Delete modify 'count' without reallocating 'arr'
!  for i := 1 to 10000 do
!    da.Add(i);  // Much faster with external count
!end;
{}
:  Serialization
{}
{\f1\fs20 TDynArray} supports both binary and JSON serialization:
{}
!var
!  binary: RawByteString;
!  json: RawUtf8;
!begin
!  // Binary (fast, compact)
!  binary := da.SaveTo;
!  da.LoadFromBinary(binary);
!
!  // JSON (interoperable)
!  json := da.SaveToJson;
!  da.LoadFromJson(json);
!end;
{}
:  TDynArrayHashed for Dictionary-Like Access
{}
{\f1\fs20 TDynArrayHashed} adds O(1) hash-based lookup:
{}
!type
!  TNameValue = record
!    Name: RawUtf8;
!    Value: Integer;
!  end;
!  TNameValueArray = array of TNameValue;
!
!var
!  arr: TNameValueArray;
!  hash: TDynArrayHashed;
!  added: Boolean;
!  idx: Integer;
!begin
!  hash.Init(TypeInfo(TNameValueArray), arr);  // Auto-detects RawUtf8 key
!
!  // Add or find existing
!  idx := hash.FindHashedForAdding('MyKey', added);
!  if added then
!  begin
!    arr[idx].Name := 'MyKey';
!    arr[idx].Value := 42;
!  end;
!
!  // Fast lookup
!  idx := hash.FindHashed('MyKey');  // O(1) instead of O(n)
!end;
{}
:  TSynDictionary
{}
{\f1\fs20 TSynDictionary} (in @!src\core\mormot.core.json.pas@) is a {\b thread-safe} dictionary storing key-value pairs as two dynamic arrays:
{}
!uses
!  mormot.core.json;
!
!var
!  dict: TSynDictionary;
!  key: RawUtf8;
!  val, v: Integer;
!begin
!  dict := TSynDictionary.Create(TypeInfo(TRawUtf8DynArray), TypeInfo(TIntegerDynArray));
!  try
!    // Add() takes const parameters, so use variables
!    key := 'key1'; val := 100;
!    dict.Add(key, val);
!    key := 'key2'; val := 200;
!    dict.Add(key, val);
!
!    key := 'key1';
!    if dict.Exists(key) then
!      dict.FindAndCopy(key, v);
!
!    // Thread-safe by default (no external locking needed)
!  finally
!    dict.Free;
!  end;
!end;
{}
:405 TDocVariant: Schema-less Documents
{}
{\f1\fs20 TDocVariant} (in @!src\core\mormot.core.variants.pas@) is a custom {\f1\fs20 variant} type for storing JSON-like documents:
{}
:  Creating Documents
{}
!uses
!  mormot.core.variants;
!
!var
!  doc: Variant;
!begin
!  // Object document
!  doc := _Obj(['name', 'John', 'age', 30]);
!  // or from JSON
!  doc := _Json('{"name":"John","age":30}');
!
!  // Array document
!  doc := _Arr(['apple', 'banana', 'cherry']);
!  // or from JSON
!  doc := _Json('["apple","banana","cherry"]');
!end;
{}
:  Late-Binding Access
{}
!var
!  doc: Variant;
!begin
!  doc := _Json('{"name":"John","address":{"city":"NYC","zip":"10001"}}');
!
!  // Read properties via late-binding
!  WriteLn(doc.name);           // 'John'
!  WriteLn(doc.address.city);   // 'NYC'
!
!  // Modify properties
!  doc.name := 'Jane';
!  doc.address.state := 'NY';   // Add new property
!
!  // Convert to JSON
!  WriteLn(doc);  // '{"name":"Jane","address":{"city":"NYC","zip":"10001","state":"NY"}}'
!end;
{}
:  Direct TDocVariantData Access
{}
For better performance, use direct transtyping:
{}
!var
!  doc: Variant;
!begin
!  doc := _Json('{"a":1,"b":2,"c":3}');
!
!  // Safe access via _Safe()
!  with _Safe(doc)^ do
!  begin
!    WriteLn('Count: ', Count);
!    for i := 0 to Count - 1 do
!      WriteLn(Names[i], '=', Values[i]);
!  end;
!
!  // Typed property access
!  WriteLn(_Safe(doc)^.I['a']);  // Integer access
!  WriteLn(_Safe(doc)^.U['b']);  // RawUtf8 access
!end;
{}
:  Per-Value vs Per-Reference
{}
By default, {\f1\fs20 _Obj()/_Arr()/_Json()} create {\b per-value} documents (deep copy on assignment):
{}
!var
!  v1, v2: Variant;
!begin
!  v1 := _Obj(['name', 'John']);
!  v2 := v1;        // Creates a copy
!  v2.name := 'Jane';
!  WriteLn(v1.name);  // 'John' (unchanged)
!  WriteLn(v2.name);  // 'Jane'
!end;
{}
Use {\f1\fs20 _ObjFast()/_ArrFast()/_JsonFast()} for {\b per-reference} documents (shared):
{}
!var
!  v1, v2: Variant;
!begin
!  v1 := _ObjFast(['name', 'John']);
!  v2 := v1;        // Reference, not copy
!  v2.name := 'Jane';
!  WriteLn(v1.name);  // 'Jane' (both changed!)
!  WriteLn(v2.name);  // 'Jane'
!end;
{}
:406 Date and Time
{}
:  ISO 8601 Encoding
{}
Dates are encoded as {\f1\fs20 ISO} 8601 text ({\f1\fs20 YYYY-MM-DDThh:mm:ss}), which provides:
- Lexicographical ordering equals chronological ordering
- Natural sorting in file systems and databases
- Cross-platform compatibility
{}
:  Time Types
{}
|%8%17%29%46
|\b Type|Resolution|Storage|Use Case\b0
|{\f1\fs20 TDateTime}|Seconds|{\f1\fs20 TEXT} ({\f1\fs20 ISO} 8601)|General purpose
|{\f1\fs20 TDateTimeMS}|Milliseconds|{\f1\fs20 TEXT} ({\f1\fs20 ISO} 8601.sss)|High precision
|{\f1\fs20 TTimeLog}|Seconds|{\f1\fs20 INTEGER} (bit-packed)|Fast comparison, compact storage
|{\f1\fs20 TUnixTime}|Seconds|{\f1\fs20 INTEGER}|Unix timestamp since 1970
|{\f1\fs20 TUnixMSTime}|Milliseconds|{\f1\fs20 INTEGER}|JavaScript-compatible
|%
{}
:  TTimeLog
{}
{\f1\fs20 TTimeLog} (in @!src\core\mormot.core.datetime.pas@) is a proprietary 64-bit format optimized for fast comparison and compact storage:
{}
!uses
!  mormot.core.datetime;
!
!var
!  t, t1, t2: TTimeLog;
!  dt: TDateTime;
!begin
!  t := TimeLogNow;                    // Current time
!  t := TimeLogFromDateTime(Now);      // From TDateTime
!  dt := TimeLogToDateTime(t);         // Back to TDateTime
!
!  t1 := TimeLogNow;
!  t2 := TimeLogNow;
!  // Direct comparison works (chronological order)
!  if t1 > t2 then
!    WriteLn('t1 is later');
!
!  // ISO 8601 conversion via TTimeLogBits
!  WriteLn(PTimeLogBits(@t)^.Text(true, 'T'));  // '2025-01-15T10:30:45'
!end;
{}
:  Time Zones
{}
{\f1\fs20 TSynTimeZone} (in @!src\core\mormot.core.search.pas@) handles time zone conversions:
{}
!uses
!  mormot.core.search;
!
!var
!  local: TDateTime;
!begin
!  // Convert UTC to local time for a specific zone
!  local := TSynTimeZone.Default.UtcToLocal(NowUtc, 'Eastern Standard Time');
!
!  // Get current local time for a zone
!  local := TSynTimeZone.Default.NowToLocal('Pacific Standard Time');
!end;
{}
:407 Thread Safety: TSynLocker
{}
{\f1\fs20 TSynLocker} (in @!src\core\mormot.core.os.pas@) provides CPU cache-friendly critical sections:
{}
:  Basic Usage
{}
!uses
!  mormot.core.os;
!
!var
!  Lock: TSynLocker;
!  Counter: Integer;
!begin
!  Lock.Init;
!  try
!    // In thread code:
!    Lock.Lock;
!    try
!      Inc(Counter);  // Protected access
!    finally
!      Lock.UnLock;
!    end;
!  finally
!    Lock.Done;
!  end;
!end;
{}
:  Automatic Unlocking
{}
Use {\f1\fs20 ProtectMethod} for RAII-style protection:
{}
!procedure TMyClass.ThreadSafeMethod;
!begin
!  fLock.ProtectMethod;  // Returns IUnknown, auto-unlocks at method end
!  // ... protected code ...
!end;  // Automatically unlocks here
{}
:  Built-in Storage
{}
{\f1\fs20 TSynLocker} includes 7 variant slots for thread-safe value storage:
{}
!var
!  Lock: TSynLocker;
!begin
!  Lock.Init;
!  // Thread-safe integer storage
!  Lock.LockedInt64[0] := 100;
!  Lock.LockedInt64Increment(0, 1);  // Atomic increment
!
!  // Thread-safe string storage
!  Lock.LockedUtf8[1] := 'value';
!
!  // Thread-safe variant storage
!  Lock.Locked[2] := _Obj(['count', 42]);
!end;
{}
:  Thread-Safe Base Classes
{}
Inherit from these for built-in {\f1\fs20 TSynLocker}:
{}
|%27%73
|\b Class|Inherits From\b0
|{\f1\fs20 TSynPersistentLock}|{\f1\fs20 TSynPersistent}
|{\f1\fs20 TInterfacedObjectLocked}|{\f1\fs20 TInterfacedObjectWithCustomCreate}
|{\f1\fs20 TObjectListLocked}|{\f1\fs20 TObjectList}
|{\f1\fs20 TRawUtf8ListLocked}|{\f1\fs20 TRawUtf8List}
|%
{}
:408 Core Units Reference
{}
:  Foundation Layer
{}
|%8%50%42
|\b Unit|Purpose|Key Types\b0
|@!src\core\mormot.core.base.pas@|Foundation types, ASM stubs|{\f1\fs20 RawUtf8}, {\f1\fs20 PtrInt}, {\f1\fs20 TDynArray} basics
|@!src\core\mormot.core.os.pas@|OS abstraction|{\f1\fs20 TSynLocker}, {\f1\fs20 GetTickCount64}, file/process APIs
|@!src\core\mormot.core.unicode.pas@|Charset conversion|{\f1\fs20 Utf8ToString}, {\f1\fs20 WinAnsiToUtf8}
|@!src\core\mormot.core.text.pas@|Text processing|{\f1\fs20 FormatUtf8}, CSV parsing, currency
|@!src\core\mormot.core.datetime.pas@|Date/time handling|{\f1\fs20 TTimeLog}, {\f1\fs20 ISO} 8601, {\f1\fs20 TSynTimeZone}
|%
{}
:  Data Layer
{}
|%10%52%38
|\b Unit|Purpose|Key Types\b0
|@!src\core\mormot.core.rtti.pas@|RTTI abstraction|{\f1\fs20 TRttiCustom}, {\f1\fs20 PRttiInfo}
|@!src\core\mormot.core.buffers.pas@|Compression, streams|SynLZ, Base64, {\f1\fs20 TBufferWriter}
|@!src\core\mormot.core.data.pas@|Data structures|{\f1\fs20 TDynArray}, {\f1\fs20 TDynArrayHashed}, {\f1\fs20 TSynDictionary}
|@!src\core\mormot.core.json.pas@|JSON handling|{\f1\fs20 TJsonWriter}, {\f1\fs20 GetJsonField}
|@!src\core\mormot.core.variants.pas@|Dynamic documents|{\f1\fs20 TDocVariant}, {\f1\fs20 IDocDict}, {\f1\fs20 IDocList}
|%
{}
:  Application Layer
{}
|%8%44%48
|\b Unit|Purpose|Key Types\b0
|@!src\core\mormot.core.log.pas@|Logging framework|{\f1\fs20 TSynLog}, {\f1\fs20 ISynLog}
|@!src\core\mormot.core.perf.pas@|Performance monitoring|{\f1\fs20 TSynMonitor}, timing
|@!src\core\mormot.core.threads.pas@|Threading utilities|{\f1\fs20 TSynBackgroundThread}, {\f1\fs20 TSynParallelProcess}
|@!src\core\mormot.core.search.pas@|Search and filtering|Full-text search helpers
|@!src\core\mormot.core.test.pas@|Testing framework|{\f1\fs20 TSynTestCase}
|@!src\core\mormot.core.mustache.pas@|Template engine|{\f1\fs20 TSynMustache}
|@!src\core\mormot.core.interfaces.pas@|Interface support|DI/@*IoC@ container
|@!src\core\mormot.core.zip.pas@|ZIP compression|Archive handling
|%
{}
:409 Dependency Order
{}
Core units have strict dependencies (lower never depends on higher):
{}
!mormot.core.base (RTL types, ASM - no dependencies)
$  └─► mormot.core.os (OS abstraction)
$      └─► mormot.core.unicode (encoding)
$          └─► mormot.core.text (parsing)
$              └─► mormot.core.datetime (dates)
$                  └─► mormot.core.rtti (RTTI)
$                      └─► mormot.core.buffers (compression)
$                          └─► mormot.core.data (TDynArray)
$                              └─► mormot.core.json (JSON)
$                                  └─► [variants, log, threads, etc.]
{}
{\b Critical Rule}: When modifying units, respect this hierarchy. Adding references that create circular dependencies will break compilation.
{}
:410 Migration from SynCommons.pas
{}
:  Type Mapping
{}
|%19%19%62
|\b mORMot 1|mORMot 2|Notes\b0
|{\f1\fs20 RawUTF8}|{\f1\fs20 RawUtf8}|Case change only
|{\f1\fs20 SynCommons.pas}|{\f1\fs20 mormot.core.*}|Split into 24 units
|{\f1\fs20 FormatUTF8()}|{\f1\fs20 FormatUtf8()}|Same function, case change
|{\f1\fs20 TDocVariant}|{\f1\fs20 TDocVariant}|Now in @!src\core\mormot.core.variants.pas@
|{\f1\fs20 TSynLog}|{\f1\fs20 TSynLog}|Now in @!src\core\mormot.core.log.pas@
|{\f1\fs20 TDynArray}|{\f1\fs20 TDynArray}|Now in @!src\core\mormot.core.data.pas@
|%
{}
:  Backward Compatibility
{}
By default, mORMot 2 provides compatibility aliases. Define {\f1\fs20 PUREMORMOT2} to disable them and use only new names.
{}
:  Minimal Uses Clause
{}
!uses
!  mormot.core.base,      // Foundation
!  mormot.core.os,        // OS abstraction
!  mormot.core.text,      // Text utilities
!  mormot.core.json,      // JSON
!  mormot.core.variants;  // TDocVariant
{}
{\i Next Chapter: Object-Relational Mapping ({\f1\fs20 @**TOrm@}, {\f1\fs20 @**TOrmModel@})}
{}

; === mORMot2-SAD-Chapter-05.md ===
; Converted from Markdown - Chapter 5
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:5Object-Relational Mapping
{}
{\i Persist Your Objects}
{}
The @*ORM@ layer of mORMot 2 is implemented across the {\f1\fs20 mormot.orm.*} units. It provides database-agnostic persistence for Delphi objects, supporting @*SQLite3@, external SQL databases (@*PostgreSQL@, @*Oracle@, MS SQL, @*MySQL@, etc.), @*MongoDB@ (@*ODM@), and in-memory storage.
{}
Generic data access is implemented by defining high-level objects as Delphi classes descending from {\f1\fs20 TOrm}. These classes serve multiple purposes:
{}
- {\b Database persistence}: @*CRUD@ operations (SELECT/{\f1\fs20 INSERT}/UPDATE/DELETE) without writing SQL
- {\b @*REST@ful resources}: Business logic objects accessible via REST/@*JSON@
- {\b UI integration}: Automatic form generation, grid binding, and reporting
{}
:501 TOrm Field Definition
{}
All ORM functionality relies on the {\f1\fs20 TOrm} class (defined in @!src\orm\mormot.orm.core.pas@). This abstract class provides built-in methods for generic ORM processing.
{}
:  Primary Key
{}
{\f1\fs20 TOrm} defines a primary key field as {\f1\fs20 ID: {\f1\fs20 @**TID@}} (where {\f1\fs20 TID = type Int64}):
{}
!type
!  TID = type Int64;
!
!  TOrm = class(TObject)
!    // ...
!    property ID: TID read GetID write fID;
!  end;
{}
The ORM relies on {\f1\fs20 Int64} primary keys, matching SQLite3's {\f1\fs20 RowID}. While you might prefer {\f1\fs20 TEXT} or {\f1\fs20 GUID} primary keys in traditional RDBMS design, integer keys are more efficient for ORM internals. You can always define secondary unique keys using {\f1\fs20 stored AS_UNIQUE}.
{}
:  Defining a Table
{}
All {\f1\fs20 published} properties of {\f1\fs20 TOrm} descendants are automatically mapped to database columns:
{}
!uses
!  mormot.core.base,
!  mormot.orm.core;
!
!type
!  /// Enumeration for gender
!  TSex = (sFemale, sMale);
!
!  /// Table for Baby records
!  TOrmBaby = class(TOrm)
!  private
!    fName: RawUtf8;
!    fAddress: RawUtf8;
!    fBirthDate: TDateTime;
!    fSex: TSex;
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Address: RawUtf8 read fAddress write fAddress;
!    property BirthDate: TDateTime read fBirthDate write fBirthDate;
!    property Sex: TSex read fSex write fSex;
!  end;
{}
By adding {\f1\fs20 TOrmBaby} to a {\f1\fs20 TOrmModel}, the corresponding {\f1\fs20 Baby} table is automatically created. No SQL required.
{}
:  Supported Property Types
{}
|%22%20%58
|\b Delphi Type|SQLite3 Type|Notes\b0
|{\f1\fs20 Byte}, {\f1\fs20 Word}, {\f1\fs20 Integer}, {\f1\fs20 Cardinal}, {\f1\fs20 Int64}|{\f1\fs20 INTEGER}|
|{\f1\fs20 Boolean}|{\f1\fs20 INTEGER}|0 = false, non-zero = true
|Enumeration|{\f1\fs20 INTEGER}|Stored as ordinal value
|Set|{\f1\fs20 INTEGER}|Bit-packed (up to 64 elements)
|{\f1\fs20 Single}, {\f1\fs20 Double}, {\f1\fs20 Extended}|FLOAT|Extended stored as double
|{\f1\fs20 Currency}|FLOAT|Fixed 4 decimals, no rounding errors
|{\f1\fs20 RawUtf8}|{\f1\fs20 TEXT}|{\b Preferred} for text fields
|{\f1\fs20 string}|{\f1\fs20 TEXT}|Use {\f1\fs20 RawUtf8} instead when possible
|{\f1\fs20 TDateTime}|{\f1\fs20 TEXT}|{\f1\fs20 ISO} 8601 with second resolution
|{\f1\fs20 TDateTimeMS}|{\f1\fs20 TEXT}|{\f1\fs20 ISO} 8601 with millisecond resolution
|{\f1\fs20 TTimeLog}|{\f1\fs20 INTEGER}|Compact proprietary format
|{\f1\fs20 TModTime}|{\f1\fs20 INTEGER}|Auto-updated on modification
|{\f1\fs20 TCreateTime}|{\f1\fs20 INTEGER}|Auto-set on creation
|{\f1\fs20 TUnixTime}|{\f1\fs20 INTEGER}|Seconds since 1970-01-01
|{\f1\fs20 TUnixMSTime}|{\f1\fs20 INTEGER}|Milliseconds since 1970-01-01
|{\f1\fs20 TOrm}|{\f1\fs20 INTEGER}|Foreign key (RowID of another table)
|{\f1\fs20 TID}|{\f1\fs20 INTEGER}|64-bit foreign key (no table info)
|{\f1\fs20 TOrmMany}|(pivot table)|Many-to-many relationship
|{\f1\fs20 TRecordReference}|{\f1\fs20 INTEGER}|Reference to any table in model
|{\f1\fs20 TSessionUserID}|{\f1\fs20 INTEGER}|Auto-filled with current user ID
|{\f1\fs20 TPersistent}|{\f1\fs20 TEXT}|JSON object
|{\f1\fs20 TCollection}|{\f1\fs20 TEXT}|JSON array of objects
|{\f1\fs20 TObjectList}|{\f1\fs20 TEXT}|JSON array (requires registration)
|{\f1\fs20 TStrings}|{\f1\fs20 TEXT}|JSON array of strings
|{\f1\fs20 RawBlob}|@*BLOB@|Binary data
|Dynamic arrays|BLOB|Binary format via {\f1\fs20 TDynArray.SaveTo}
|{\f1\fs20 Variant}|{\f1\fs20 TEXT}|JSON (or {\f1\fs20 @**TDocVariant@})
|{\f1\fs20 TNullableInteger}, etc.|varies|Nullable types supporting SQL NULL
|{\f1\fs20 record}|{\f1\fs20 TEXT}|JSON (Delphi XE5+)
|{\f1\fs20 TRecordVersion}|{\f1\fs20 INTEGER}|Monotonic change counter
|%
{}
:  Property Attributes
{}
Use special attributes in property declarations:
{}
!type
!  TOrmDiaper = class(TOrm)
!  private
!    fSerialNumber: RawUtf8;
!    fModel: TOrmDiaperModel;
!    fBaby: TOrmBaby;
!  published
!    property SerialNumber: RawUtf8
!      index 30                    // Max 30 chars for external DB
!      read fSerialNumber write fSerialNumber
!      stored AS_UNIQUE;           // Creates unique index
!    property Model: TOrmDiaperModel read fModel write fModel;
!    property Baby: TOrmBaby read fBaby write fBaby;
!  end;
{}
- {\b {\f1\fs20 stored AS_UNIQUE}}: Creates a unique database index
- {\b {\f1\fs20 index N}}: Maximum character length for external databases
- {\b {\f1\fs20 index N}} (dynamic arrays): Used for {\f1\fs20 TOrm.DynArray(N)} wrapper access
{}
:502 Text Fields
{}
The preferred type for text storage is {\f1\fs20 RawUtf8}. This ensures:
{}
- Consistent @*UTF-8@ encoding across all database engines
- No conversion overhead during JSON serialization
- Compatibility with all Delphi versions
{}
!// Business layer: Use RawUtf8
!property CustomerName: RawUtf8 read fCustomerName write fCustomerName;
!
!// UI layer: Convert for display
!var
!  displayName: string;
!begin
!  displayName := Utf8ToString(Customer.CustomerName);
!  Edit1.Text := displayName;
!end;
{}
{\b Domain-Driven Tip}: Using {\f1\fs20 RawUtf8} in your domain layer prevents accidental coupling between business logic and presentation.
{}
:503 Date and Time Fields
{}
:  TDateTime / TDateTimeMS
{}
Stored as {\f1\fs20 ISO} 8601 text in the database:
{}
!property CreatedAt: TDateTime read fCreatedAt write fCreatedAt;
!property PreciseTime: TDateTimeMS read fPreciseTime write fPreciseTime;  // With milliseconds
{}
:  TTimeLog / TModTime / TCreateTime
{}
Stored as {\f1\fs20 INTEGER} for fast comparison:
{}
!property LastModified: TModTime read fLastModified write fLastModified;  // Auto-updated
!property Created: TCreateTime read fCreated write fCreated;              // Auto-set once
!property Timestamp: TTimeLog read fTimestamp write fTimestamp;           // Manual
{}
{\f1\fs20 TModTime} and {\f1\fs20 TCreateTime} are automatically updated by the server:
- {\f1\fs20 TCreateTime}: Set when the record is first inserted
- {\f1\fs20 TModTime}: Updated on every modification
{}
:  TUnixTime / TUnixMSTime
{}
For interoperability with JavaScript/C#/Java:
{}
!property UnixTs: TUnixTime read fUnixTs write fUnixTs;        // Seconds
!property UnixMsTs: TUnixMSTime read fUnixMsTs write fUnixMsTs; // Milliseconds
{}
:504 TOrm Foreign Key Fields
{}
:  TOrm Published Properties (NOT Instances)
{}
{\b Critical}: {\f1\fs20 TOrm} published properties are {\b NOT} class instances. They store {\f1\fs20 pointer(RowID)}:
{}
!type
!  TOrmOrder = class(TOrm)
!  published
!    property Customer: TOrmCustomer read fCustomer write fCustomer;  // Stores ID, not instance!
!  end;
!
!// WRONG - will cause Access Violation:
!WriteLn(Order.Customer.Name);  // AV! Customer is not an instance
!
!// CORRECT - retrieve separately:
!var
!  cust: TOrmCustomer;
!begin
!  cust := TOrmCustomer.Create(Client, Order.Customer);  // Load by ID
!  try
!    WriteLn(cust.Name);
!  finally
!    cust.Free;
!  end;
!end;
{}
:  Setting Foreign Keys
{}
!var
!  Order: TOrmOrder;
!  Customer: TOrmCustomer;
!begin
!  Customer := TOrmCustomer.Create;
!  Order := TOrmOrder.Create;
!  try
!    Customer.Name := 'ACME Corp';
!    Client.Add(Customer, True);  // Customer.ID is now set
!
!    Order.Customer := Customer.AsTOrm;  // Use AsTOrm for cross-platform
!    // or: Order.Customer := pointer(Customer.ID);  // 32-bit only
!    Client.Add(Order, True);
!  finally
!    Order.Free;
!    Customer.Free;
!  end;
!end;
{}
:  CreateJoined for Automatic Loading
{}
Use {\f1\fs20 CreateJoined} to auto-instantiate and load all {\f1\fs20 TOrm} properties:
{}
!var
!  Order: TOrmOrder;
!begin
!  Order := TOrmOrder.CreateJoined(Client, OrderID);
!  try
!    // Now Order.Customer is a real instance, loaded via JOIN
!    WriteLn(Order.Customer.Name);  // Safe!
!  finally
!    Order.Free;  // Also frees Order.Customer
!  end;
!end;
{}
:  Deletion Tracking
{}
The ORM automatically handles foreign key integrity (emulated, not via SQL constraints):
{}
|%25%14%61
|\b Type|Index|Deletion Behavior\b0
|{\f1\fs20 TOrm} property|Yes|Field reset to 0
|{\f1\fs20 TID}|Yes|None (no table info)
|{\f1\fs20 TOrmClassNameID}|Yes|Field reset to 0
|{\f1\fs20 TOrmClassNameToBeDeletedID}|Yes|Row deleted (cascade)
|{\f1\fs20 TRecordReference}|Yes|Field reset to 0
|{\f1\fs20 TRecordReferenceToBeDeleted}|Yes|Row deleted (cascade)
|%
{}
Define typed {\f1\fs20 IDs} for explicit cascade behavior:
{}
!type
!  TOrmCustomerID = type TID;              // Reset to 0 on delete
!  TOrmCustomerToBeDeletedID = type TID;   // Cascade delete
!
!  TOrmOrder = class(TOrm)
!  published
!    property Customer: TOrmCustomerID read fCustomer write fCustomer;
!    property OwnerCustomer: TOrmCustomerToBeDeletedID read fOwner write fOwner;
!  end;
{}
:505 TRecordReference: Cross-Table References
{}
{\f1\fs20 TRecordReference} stores a reference to {\b any} table in the model:
{}
!type
!  TOrmAuditLog = class(TOrm)
!  published
!    property RelatedRecord: TRecordReference read fRelated write fRelated;
!  end;
!
!// Usage
!var
!  Log: TOrmAuditLog;
!  Ref: RecordRef;  // Helper record
!begin
!  // Store reference to any record (requires Model for table index lookup)
!  Log.RelatedRecord := RecordReference(Model, TOrmCustomer, CustomerID);
!
!  // Retrieve via helper
!  Ref.Value := Log.RelatedRecord;
!  WriteLn('Table: ', Ref.Table(Model).SqlTableName);
!  WriteLn('ID: ', Ref.ID);
!
!  // Load the referenced record directly
!  Rec := Client.Retrieve(Log.RelatedRecord);
!end;
{}
{\b Warning}: {\f1\fs20 TRecordReference} encodes table index in high bits. {\b Never change table order} in {\f1\fs20 TOrmModel} after deployment.
{}
:506 Variant Fields and TDocVariant
{}
{\f1\fs20 Variant} fields are stored as JSON {\f1\fs20 TEXT}:
{}
!type
!  TOrmDocument = class(TOrm)
!  published
!    property Data: Variant read fData write fData;
!  end;
!
!// Usage - schema-less storage
!var
!  Doc: TOrmDocument;
!begin
!  Doc := TOrmDocument.Create;
!  Doc.Data := _ObjFast(['name', 'John', 'tags', _Arr(['admin', 'user'])]);
!  Client.Add(Doc, True);
!
!  // Later retrieval
!  Doc := TOrmDocument.Create(Client, DocID);
!  WriteLn(Doc.Data.name);        // 'John'
!  WriteLn(Doc.Data.tags._Count); // 2
!end;
{}
For MongoDB ODM, variants are stored as native BSON documents with full query support.
{}
:507 Dynamic Array Fields
{}
Dynamic arrays are stored as BLOB in binary format:
{}
!type
!  TIntegerArray = array of Integer;
!
!  TOrmWithArray = class(TOrm)
!  private
!    fScores: TIntegerArray;
!  published
!    property Scores: TIntegerArray index 1 read fScores write fScores;
!  end;
{}
Access via {\f1\fs20 TDynArray} wrapper:
{}
!var
!  Rec: TOrmWithArray;
!  DA: TDynArray;
!  Value: Integer;
!begin
!  DA := Rec.DynArray(1);  // Get wrapper for Scores
!  Value := 100;
!  DA.Add(Value);  // TDynArray.Add takes a reference
!  Value := 200;
!  DA.Add(Value);
!end;
{}
:508 TNullable* Types
{}
For SQL NULL support, use nullable types:
{}
!type
!  TOrmNullableRecord = class(TOrm)
!  published
!    property OptionalInt: TNullableInteger read fOptionalInt write fOptionalInt;
!    property OptionalText: TNullableUtf8Text index 100 read fOptionalText write fOptionalText;
!    property OptionalDate: TNullableDateTime read fOptionalDate write fOptionalDate;
!  end;
!
!// Usage
!var
!  Rec: TOrmNullableRecord;
!begin
!  Rec := TOrmNullableRecord.Create;
!  Rec.OptionalInt := NullableInteger(42);        // Has value
!  Rec.OptionalText := NullableUtf8TextNull;      // Is NULL
!  Rec.OptionalDate := NullableDateTime(Now);     // Has value
!
!  if NullableIntegerIsEmptyOrNull(Rec.OptionalInt) then
!    WriteLn('No value')
!  else
!    WriteLn('Value: ', NullableIntegerToValue(Rec.OptionalInt));
!end;
{}
Available nullable types:
- {\f1\fs20 TNullableInteger} (Int64)
- {\f1\fs20 TNullableBoolean}
- {\f1\fs20 TNullableFloat} (Double)
- {\f1\fs20 TNullableCurrency}
- {\f1\fs20 TNullableDateTime}
- {\f1\fs20 TNullableTimeLog}
- {\f1\fs20 TNullableUtf8Text}
{}
:509 TOrmModel: Schema Definition
{}
{\f1\fs20 TOrmModel} defines which {\f1\fs20 TOrm} classes form your database:
{}
!uses
!  mormot.orm.core;
!
!var
!  Model: TOrmModel;
!begin
!  Model := TOrmModel.Create([
!    TOrmCustomer,
!    TOrmProduct,
!    TOrmOrder,
!    TOrmOrderLine
!  ], 'api');  // 'api' is the root URI
!
!  // Table order matters for TRecordReference - don't change after deployment!
!end;
{}
:  Field Validation and Constraints
{}
!// Add unique validation at runtime (alternative to stored AS_UNIQUE)
!TOrmCustomer.AddFilterOrValidate('Email', TSynValidateUniqueField.Create);
!
!// For multi-field uniqueness
!TOrmOrder.AddFilterOrValidate('OrderNumber',
!  TSynValidateUniqueFields.Create('{"FieldNames":"CustomerID,OrderNumber"}'));
{}
{\b Note}: Prefer using {\f1\fs20 stored AS_UNIQUE} in property declarations for compile-time constraints. Runtime validation is useful for conditional or complex uniqueness rules.
{}
:510 IRestOrm: The ORM Interface
{}
{\b Always code against {\f1\fs20 IRestOrm} interface}, not concrete classes:
{}
!uses
!  mormot.orm.core;
!
!procedure DoWork(const Orm: IRestOrm);  // Interface parameter
!var
!  Customer: TOrmCustomer;
!begin
!  Customer := TOrmCustomer.Create;
!  try
!    Customer.Name := 'ACME Corp';
!    Orm.Add(Customer, True);    // Add via interface
!  finally
!    Customer.Free;
!  end;
!end;
{}
:  CRUD Operations
{}
!var
!  Orm: IRestOrm;
!  Customer: TOrmCustomer;
!  ID: TID;
!begin
!  // CREATE
!  Customer := TOrmCustomer.Create;
!  Customer.Name := 'New Customer';
!  ID := Orm.Add(Customer, True);  // Returns new ID
!
!  // READ
!  Customer := TOrmCustomer.Create(Orm, ID);  // Load by ID
!  // or
!  Orm.Retrieve(ID, Customer);                // Load into existing instance
!
!  // UPDATE
!  Customer.Name := 'Updated Name';
!  Orm.Update(Customer);
!
!  // DELETE
!  Orm.Delete(TOrmCustomer, ID);
!end;
{}
:  Accessing ORM from TRest
{}
In mORMot 2, ORM is accessed via the {\f1\fs20 .Orm} property:
{}
!// mORMot 1 style (deprecated):
!Server.Add(Customer, True);
!
!// mORMot 2 style:
!Server.Orm.Add(Customer, True);
!
!// Or store interface:
!var
!  Orm: IRestOrm;
!begin
!  Orm := Server.Orm;
!  Orm.Add(Customer, True);
!end;
{}
:511 Virtual Tables and Storage Backends
{}
:  In-Memory Storage
{}
!uses
!  mormot.rest.memserver;
!
!// Use TRestServerFullMemory for pure in-memory ORM
!Server := TRestServerFullMemory.Create(Model, '', False, False);
!// Or with file persistence:
!Server := TRestServerFullMemory.Create(Model, 'data.json', False, False);
{}
:  External SQL Database
{}
!uses
!  mormot.orm.sql,
!  mormot.db.sql.postgres;
!
!var
!  Props: TSqlDBPostgresConnectionProperties;
!begin
!  Props := TSqlDBPostgresConnectionProperties.Create(
!    'localhost:5432', 'mydb', 'user', 'pass');
!
!  // Map TOrm to external database
!  OrmMapExternal(Model, TOrmCustomer, Props);
!  OrmMapExternal(Model, TOrmOrder, Props);
!end;
{}
:  MongoDB (ODM)
{}
!uses
!  mormot.orm.mongodb,
!  mormot.db.nosql.mongodb;
!
!var
!  Client: TMongoClient;
!  Server: TRestServer;
!begin
!  Client := TMongoClient.Create('localhost', 27017);
!  // OrmMapMongoDB requires a Server instance, not Model
!  OrmMapMongoDB(TOrmDocument, Server.OrmInstance, Client.Database['mydb']);
!end;
{}
:512 Migration from mORMot 1
{}
:  Class Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 TSQLRecord}|{\f1\fs20 TOrm}
|{\f1\fs20 TSQLRecordClass}|{\f1\fs20 TOrmClass}
|{\f1\fs20 TSQLModel}|{\f1\fs20 TOrmModel}
|{\f1\fs20 TSQLTable}|{\f1\fs20 TOrmTable}
|{\f1\fs20 TSQLTableJSON}|{\f1\fs20 TOrmTableJson}
|{\f1\fs20 TSQLRest}|{\f1\fs20 TRest}
|{\f1\fs20 TSQLRest.Add()}|{\f1\fs20 TRest.Orm.Add()}
|{\f1\fs20 TSQLRecordMany}|{\f1\fs20 TOrmMany}
|{\f1\fs20 TSQLRawBlob}|{\f1\fs20 RawBlob}
|%
{}
:  Unit Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 mORMot.pas}|@!src\orm\mormot.orm.core.pas@ + @!src\rest\mormot.rest.core.pas@
|{\f1\fs20 mORMotSQLite3.pas}|{\f1\fs20 mormot.orm.sqlite3} + {\f1\fs20 mormot.rest.sqlite3}
|{\f1\fs20 mORMotDB.pas}|@!src\orm\mormot.orm.sql.pas@
|{\f1\fs20 mORMotMongoDB.pas}|@!src\orm\mormot.orm.mongodb.pas@
|%
{}
:  Backward Compatibility
{}
By default, type aliases are provided:
!type
!  TSQLRecord = TOrm;
!  TSQLModel = TOrmModel;
!  // etc.
{}
Define {\f1\fs20 PUREMORMOT2} to disable these and use only new names.
{}
{\i Next Chapter: Daily ORM (Working with Objects and Queries)}
{}

; === mORMot2-SAD-Chapter-06.md ===
; Converted from Markdown - Chapter 6
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:6Daily ORM
{}
{\i Practical Patterns for Everyday Use}
{}
When comparing @*ORM@ to raw SQL, several advantages stand out:
{}
- {\b No field order concerns}: Access properties directly with {\f1\fs20 IDE} completion
- {\b Readable code}: No context-switching between Pascal and SQL syntax
- {\b Naming consistency}: Refactoring table/field names is handled by the compiler
- {\b Type safety}: Compile-time checking prevents runtime type mismatches
- {\b Database agnostic}: Same code works across @*SQLite3@, @*PostgreSQL@, @*MongoDB@, etc.
{}
This chapter covers practical patterns for daily ORM usage in mORMot 2.
{}
:601 ORM is Not Just Database
{}
The ORM should not be thought of as simply mapping an existing database schema. Instead:
{}
- {\b Think objects, not tables}: Use high-level types, not just text/numbers
- {\b Think logical units, not Master/Detail}: Group related data in single records
- {\b Think classes, not SQL}: Design your domain first
- {\b Think "What data do I need?", not "How will I store it?"}
{}
:  Objects, Not Tables
{}
With an ORM, you often define {\b fewer tables} than in traditional RDBMS design. Use {\f1\fs20 TDocVariant}, dynamic arrays, {\f1\fs20 TCollection}, or {\f1\fs20 TPersistent} properties to store nested data within a single record:
{}
!type
!  TOrmInvoice = class(TOrm)
!  private
!    fCustomerName: RawUtf8;
!    fLines: Variant;  // TDocVariant array of line items
!    fMetadata: Variant;  // TDocVariant object for flexible data
!  published
!    property CustomerName: RawUtf8 read fCustomerName write fCustomerName;
!    property Lines: Variant read fLines write fLines;
!    property Metadata: Variant read fMetadata write fMetadata;
!  end;
!
!// Usage - no separate InvoiceLine table needed
!Invoice.Lines := _JsonFast('[
!  {"product":"Widget","qty":10,"price":9.99},
!  {"product":"Gadget","qty":5,"price":19.99}
!]');
!Invoice.Metadata := _ObjFast(['region', 'US', 'priority', 'high']);
{}
:  Methods, Not SQL
{}
{\b Anti-pattern} (direct SQL):
{}
!// DON'T do this
!Server.DB.Execute('CREATE TABLE IF NOT EXISTS drives...');
!Server.DB.Execute('INSERT OR IGNORE INTO drives (drive) VALUES ("A:")');
{}
{\b Correct ORM approach}:
{}
!// DO this
!Server.Server.CreateMissingTables;  // Creates tables from model
!
!if Server.Orm.TableRowCount(TOrmDrive) = 0 then
!begin
!  Drive := TOrmDrive.Create;
!  try
!    for C := 'A' to 'Z' do
!    begin
!      Drive.Letter := C;
!      Server.Orm.Add(Drive, True);
!    end;
!  finally
!    Drive.Free;
!  end;
!end;
{}
:602 Working with Objects
{}
:  CRUD Operations
{}
The fundamental pattern uses {\f1\fs20 Add/Retrieve/Update/Delete} methods:
{}
!uses
!  mormot.orm.core;
!
!procedure CrudExample(const Orm: IRestOrm);
!var
!  Baby: TOrmBaby;
!  ID: TID;
!begin
!  // CREATE - Add a new record
!  Baby := TOrmBaby.Create;
!  try
!    Baby.Name := 'Smith';
!    Baby.Address := 'New York City';
!    Baby.BirthDate := Date;
!    Baby.Sex := sMale;
!    ID := Orm.Add(Baby, True);  // True = include all fields
!  finally
!    Baby.Free;
!  end;
!
!  // RETRIEVE - Load by ID
!  Baby := TOrmBaby.Create(Orm, ID);  // Constructor loads the record
!  try
!    Assert(Baby.Name = 'Smith');
!
!    // UPDATE - Modify and save
!    Baby.Name := 'Smythe';
!    Orm.Update(Baby);
!  finally
!    Baby.Free;
!  end;
!
!  // Alternative RETRIEVE into existing instance
!  Baby := TOrmBaby.Create;
!  try
!    if Orm.Retrieve(ID, Baby) then
!      WriteLn('Found: ', Baby.Name);
!  finally
!    Baby.Free;
!  end;
!
!  // DELETE - Remove by ID
!  Orm.Delete(TOrmBaby, ID);
!end;
{}
:  Reusing Instances
{}
A single {\f1\fs20 TOrm} instance can be reused for multiple operations:
{}
!var
!  Baby: TOrmBaby;
!begin
!  Baby := TOrmBaby.Create;
!  try
!    // Add first record
!    Baby.Name := 'Alice';
!    Orm.Add(Baby, True);
!
!    // Reuse for second record
!    Baby.ClearProperties;  // Reset fields
!    Baby.Name := 'Bob';
!    Orm.Add(Baby, True);
!  finally
!    Baby.Free;
!  end;
!end;
{}
:603 Queries
{}
:  FillPrepare / FillOne Pattern
{}
The most efficient way to iterate through query results:
{}
!var
!  Baby: TOrmBaby;
!begin
!  Baby := TOrmBaby.CreateAndFillPrepare(Orm,
!    'Name LIKE ? AND Sex = ?', ['A%', Ord(sMale)]);
!  try
!    while Baby.FillOne do
!      DoSomethingWith(Baby);  // Process each matching record
!  finally
!    Baby.Free;
!  end;
!end;
{}
{\b Key benefits}:
- Single instance reused for all rows
- No separate {\f1\fs20 TOrmTable} handling needed
- Minimal memory allocation
{}
:  Selecting Specific Fields
{}
Save bandwidth by specifying only needed fields:
{}
!// Load only Name and BirthDate fields
!Baby := TOrmBaby.CreateAndFillPrepare(Orm,
!  'Sex = ?', [Ord(sFemale)],
!  'Name,BirthDate');  // aCustomFieldsCSV parameter
!try
!  while Baby.FillOne do
!    WriteLn(Baby.Name, ': ', DateToStr(Baby.BirthDate));
!finally
!  Baby.Free;
!end;
{}
{\b Warning}: After partial field retrieval, calling {\f1\fs20 Orm.Update(Baby)} will only update the retrieved fields, not the entire record.
{}
:  Query Parameters
{}
Parameters are bound using {\f1\fs20 ?} placeholders:
{}
!// String and integer parameters
!Baby.CreateAndFillPrepare(Orm,
!  'Name LIKE ? AND Sex = ?',
!  ['A%', Ord(sMale)]);
!
!// Date parameters - use DateToSql/DateTimeToSql
!Baby.CreateAndFillPrepare(Orm,
!  'BirthDate >= ?',
!  [DateToSql(EncodeDate(2020, 1, 1))]);
!
!// Building complex WHERE clauses
!var
!  Where: RawUtf8;
!begin
!  Where := FormatUtf8('ID >= ?', [], [MinID]);
!  if OnlyActive then
!    Where := FormatUtf8('% AND Active = ?', [Where], [True]);
!  if not Category.IsEmpty then
!    Where := FormatUtf8('% AND Category = ?', [Where], [Category]);
!
!  Baby := TOrmBaby.CreateAndFillPrepare(Orm, Where);
!end;
{}
:  IList<T> Alternative
{}
For simpler code using mORMot2's generic interface (from @!src\core\mormot.core.collections.pas@):
{}
!var
!  List: IList<TOrmBaby>;
!  Baby: TOrmBaby;
!begin
!  if Orm.RetrieveIList(TOrmBaby, List, 'Name,Sex,BirthDate') then
!    for Baby in List do
!      DoSomethingWith(Baby);
!  // IList is reference-counted, no Free needed
!end;
{}
{\b Trade-off}: Creates all instances at once vs. {\f1\fs20 FillPrepare}'s single-instance reuse.
{}
> {\b Note}: mORMot2 also provides {\f1\fs20 RetrieveList()} returning a non-generic {\f1\fs20 TObjectList} if you prefer that pattern.
{}
:  TOrmTable for Raw Results
{}
Direct access to query results as a table:
{}
!var
!  Table: TOrmTable;
!  Row: Integer;
!begin
!  // ExecuteList takes SQL only (no bounds parameter) - use FormatUtf8 for parameters
!  Table := Orm.ExecuteList([TOrmBaby],
!    FormatUtf8('SELECT ID, Name, BirthDate FROM Baby WHERE Sex = ?', [], [Ord(sMale)]));
!  try
!    for Row := 1 to Table.RowCount do
!      WriteLn(
!        'ID=', Table.GetAsInteger(Row, 0),
!        ' Name=', Table.GetU(Row, 1),
!        ' Born=', Table.GetU(Row, 2));
!  finally
!    Table.Free;
!  end;
!end;
{}
Or using cursor-style {\f1\fs20 Step}:
{}
!Table := Orm.MultiFieldValues(TOrmBaby, 'ID,Name',
!  'Sex = ?', [Ord(sMale)]);
!try
!  while Table.Step do
!    WriteLn('ID=', Table.Field(0), ' Name=', Table.Field(1));
!finally
!  Table.Free;
!end;
{}
:  Late-Binding Variant Access
{}
For convenient but slower access:
{}
!var
!  Baby: Variant;
!begin
!  with Orm.MultiFieldValues(TOrmBaby, 'ID,Name,BirthDate', 'Sex = ?', [Ord(sMale)]) do
!  try
!    while Step(False, @Baby) do
!      WriteLn('ID=', Baby.ID, ' Name=', Baby.Name);
!  finally
!    Free;
!  end;
!end;
{}
:604 Helper Methods
{}
:  Single-Value Retrieval
{}
!// Get one field value (returns RawUtf8)
!var
!  Name: RawUtf8;
!begin
!  Name := Orm.OneFieldValue(TOrmBaby, 'Name', 'ID = ?', [], [123]);
!  if Name <> '' then
!    WriteLn('Found: ', Name);
!end;
!
!// Get count - use OneFieldValueInt64 for integer results
!var
!  Count: Int64;
!begin
!  Count := Orm.TableRowCount(TOrmBaby);
!  WriteLn('Total babies: ', Count);
!
!  // OneFieldValueInt64 takes WhereClause without bounds - use FormatUtf8
!  Count := Orm.OneFieldValueInt64(TOrmBaby, 'COUNT(*)',
!    FormatUtf8('Sex = ?', [], [Ord(sMale)]));
!  WriteLn('Male babies: ', Count);
!end;
!
!// Alternative: OneFieldValue with out parameter for Int64
!var
!  Count: Int64;
!begin
!  if Orm.OneFieldValue(TOrmBaby, 'COUNT(*)', 'Sex = ?', [], [Ord(sMale)], Count) then
!    WriteLn('Male babies: ', Count);
!end;
{}
:  Multiple Values to Dynamic Array
{}
!var
!!  IDs: TInt64DynArray;  // Note: mORMot2 uses TInt64DynArray for integer fields
!  Names: TRawUtf8DynArray;
!  i: Integer;
!begin
!  // Get all IDs matching criteria
!  // OneFieldValues takes WhereClause directly - use FormatUtf8 for parameters
!  Orm.OneFieldValues(TOrmBaby, 'ID',
!    FormatUtf8('Sex = ?', [], [Ord(sFemale)]), IDs);
!
!  // Get names into array
!  Orm.OneFieldValues(TOrmBaby, 'Name', '', Names);
!  for i := 0 to High(Names) do
!    WriteLn(Names[i]);
!end;
{}
:  Existence Check
{}
!if Orm.Retrieve('Email = ?', [], [Email], Customer) then
!  WriteLn('Customer exists: ', Customer.Name)
!else
!  WriteLn('Not found');
{}
:605 Automatic Memory Management
{}
:  AutoFree Pattern
{}
Avoid manual {\f1\fs20 try..finally} blocks:
{}
!function CreateNewBaby(const Orm: IRestOrm; const Name: RawUtf8): TID;
!var
!  Baby: TOrmBaby;
!begin
!  TOrmBaby.AutoFree(Baby);  // Auto-releases at end of function
!  Baby.Name := Name;
!  Baby.BirthDate := Date;
!  Result := Orm.Add(Baby, True);
!end;  // Baby automatically freed here
{}
:  AutoFree with Query
{}
!var
!  Baby: TOrmBaby;
!begin
!  TOrmBaby.AutoFree(Baby, Orm, 'Name LIKE ?', ['A%']);
!  while Baby.FillOne do
!    ProcessBaby(Baby);
!end;  // Baby automatically freed
{}
:  FPC Compatibility
{}
With FPC, assign the result to a local {\f1\fs20 IAutoFree} variable:
{}
!var
!  Baby: TOrmBaby;
!  Auto: IAutoFree;  // Required for FPC
!begin
!  Auto := TOrmBaby.AutoFree(Baby, Orm, 'Name LIKE ?', ['A%']);
!  while Baby.FillOne do
!    ProcessBaby(Baby);
!end;
{}
:606 Object Relationships
{}
:  One-to-One / One-to-Many
{}
Use {\f1\fs20 TOrm} published properties (storing {\f1\fs20 IDs}, not instances):
{}
!type
!  TOrmFileInfo = class(TOrm)
!  published
!    property FileDate: TDateTime read fFileDate write fFileDate;
!    property FileSize: Int64 read fFileSize write fFileSize;
!  end;
!
!  TOrmFile = class(TOrm)
!  published
!    property FileName: RawUtf8 read fFileName write fFileName;
!    property Info: TOrmFileInfo read fInfo write fInfo;  // Foreign key
!  end;
!
!// Creating linked records
!Info := TOrmFileInfo.Create;
!MyFile := TOrmFile.Create;
!try
!  Info.FileDate := Now;
!  Info.FileSize := 12345;
!  Orm.Add(Info, True);
!
!  MyFile.FileName := 'document.pdf';
!  MyFile.Info := Info.AsTOrm;  // Store the ID
!  Orm.Add(MyFile, True);
!finally
!  MyFile.Free;
!  Info.Free;
!end;
!
!// Retrieving - use CreateJoined for automatic loading
!MyFile := TOrmFile.CreateJoined(Orm, FileID);
!try
!  WriteLn(MyFile.Info.FileSize);  // Info is now a real instance
!finally
!  MyFile.Free;  // Also frees MyFile.Info
!end;
{}
:  Many-to-Many with TOrmMany
{}
For pivot tables (e.g., Authors ↔ Books):
{}
!type
!  TOrmAuthor = class(TOrm)
!  published
!    property Name: RawUtf8 read fName write fName;
!  end;
!
!  TOrmBook = class(TOrm)
!  published
!    property Title: RawUtf8 read fTitle write fTitle;
!    property Authors: TOrmAuthorBookLink read fAuthors;  // Auto-instantiated
!  end;
!
!  TOrmAuthorBookLink = class(TOrmMany)
!  published
!    property Source: TOrmBook read fSource;     // Book side
!    property Dest: TOrmAuthor read fDest;       // Author side
!    property Contribution: RawUtf8 read fContribution write fContribution;
!  end;
!
!// Adding a many-to-many relationship
!Book.Authors.ManyAdd(Orm, Book.ID, AuthorID);
!
!// Query all authors for a book
!if Book.Authors.FillMany(Orm, Book.ID) then
!  while Book.Authors.FillOne do
!    WriteLn('Author: ', TOrmAuthor(Book.Authors.Dest).Name);
!
!// Query all books for an author
!if Book.Authors.FillManyFromDest(Orm, AuthorID) then
!  while Book.Authors.FillOne do
!    WriteLn('Book: ', TOrmBook(Book.Authors.Source).Title);
{}
:  Data Sharding (Embedded Documents)
{}
Instead of pivot tables, embed data using {\f1\fs20 Variant} or dynamic arrays:
{}
!type
!  TOrmOrder = class(TOrm)
!  private
!    fCustomerName: RawUtf8;
!    fLines: Variant;  // Embedded array of line items
!  published
!    property CustomerName: RawUtf8 read fCustomerName write fCustomerName;
!    property Lines: Variant read fLines write fLines;  // JSON array
!  end;
!
!// Usage
!Order.Lines := _JsonFast('[
!  {"sku":"ABC123","qty":2,"price":29.99},
!  {"sku":"XYZ789","qty":1,"price":49.99}
!]');
!
!// Query line items
!for i := 0 to _Safe(Order.Lines)^._Count - 1 do
!  WriteLn('SKU: ', _Safe(Order.Lines)^.Value[i].sku);
{}
{\b Benefits}:
- Self-contained records (no joins)
- Better for MongoDB/NoSQL
- Simpler schema
- Natural for domain modeling
{}
:607 Batch Operations
{}
:  TRestBatch for Bulk Inserts
{}
High-performance bulk operations with single network roundtrip:
{}
!uses
!  mormot.orm.core;
!
!var
!  Batch: TRestBatch;
!  Results: TIDDynArray;
!  Baby: TOrmBaby;
!  i: Integer;
!begin
!  Batch := TRestBatch.Create(Orm, TOrmBaby, 1000);  // Auto-flush every 1000
!  try
!    for i := 1 to 10000 do
!    begin
!      Baby := TOrmBaby.Create;
!      Baby.Name := FormatUtf8('Baby %', [i]);
!      Baby.BirthDate := Date - Random(365);
!      Batch.Add(Baby, True);  // True = Batch owns Baby, auto-frees
!    end;
!    Orm.BatchSend(Batch, Results);  // Single network call
!    WriteLn('Inserted ', Length(Results), ' records');
!  finally
!    Batch.Free;
!  end;
!end;
{}
:  Batch Updates and Deletes
{}
!Batch := TRestBatch.Create(Orm, TOrmBaby, 100, [boExtendedJson]);
!try
!  // Update multiple records
!  Baby := TOrmBaby.CreateAndFillPrepare(Orm, 'Active = ?', [False]);
!  try
!    while Baby.FillOne do
!    begin
!      Baby.Status := sArchived;
!      Batch.Update(Baby);
!    end;
!  finally
!    Baby.Free;
!  end;
!
!  // Delete multiple records
!  for ID in ObsoleteIDs do
!    Batch.Delete(TOrmBaby, ID);
!
!  Orm.BatchSend(Batch, Results);
!finally
!  Batch.Free;
!end;
{}
:608 The Best ORM is the One You Need
{}
mORMot offers multiple persistence patterns:
{}
|%40%60
|\b Pattern|Use Case\b0
|{\b Native ORM} ({\f1\fs20 TOrm} → SQLite3)|Embedded apps, single-server
|{\b External SQL} ({\f1\fs20 OrmMapExternal})|Enterprise databases
|{\b MongoDB @*ODM@} ({\f1\fs20 OrmMapMongoDB})|Document store, horizontal scaling
|{\b In-Memory} ({\f1\fs20 TRestStorageInMemory})|Caching, temporary data
|{\b Repository Services}|@*DDD@, clean architecture
|%
{}
:  Mix and Match
{}
Different tables can use different backends:
{}
!// SQLite3 for local data
!// (default - no mapping needed)
!
!// PostgreSQL for shared data
!OrmMapExternal(Model, TOrmCustomer, PostgresProps);
!OrmMapExternal(Model, TOrmOrder, PostgresProps);
!
!// MongoDB for logs
!OrmMapMongoDB(Model, TOrmAuditLog, MongoClient.Database['logs']);
!
!// In-memory for cache
!Model.Props[TOrmSessionCache].SetStorage(TRestStorageInMemory);
{}
:  Think Multi-Tier
{}
Design your architecture with layers:
{}
$┌────────────────────────────────────┐
$│  Presentation Layer                │
$│  (VCL/FMX Forms, Web UI)           │
$│  string, TDataSet, JSON            │
$└────────────────────────────────────┘
$                │
$┌────────────────────────────────────┐
$│  Application Layer                 │
$│  (Services, Controllers)           │
$│  RawUtf8, TOrm, IRestOrm           │
$└────────────────────────────────────┘
$                │
$┌────────────────────────────────────┐
$│  Domain Layer                      │
$│  (Business Logic, Entities)        │
$│  RawUtf8, Domain Objects           │
$└────────────────────────────────────┘
$                │
$┌────────────────────────────────────┐
$│  Infrastructure Layer              │
$│  (Repositories, DB Access)         │
$│  TOrm, IRestOrm, External DB       │
$└────────────────────────────────────┘
{}
:609 Summary of Best Practices
{}
1. {\b Use {\f1\fs20 IRestOrm} interface}, not concrete classes
2. {\b Use {\f1\fs20 RawUtf8}} for all text properties
3. {\b Use {\f1\fs20 FillPrepare/FillOne}} for memory-efficient queries
4. {\b Use {\f1\fs20 AutoFree}} to reduce boilerplate
5. {\b Use {\f1\fs20 TDocVariant}} for schema-less embedded data
6. {\b Use {\f1\fs20 TRestBatch}} for bulk operations
7. {\b Use {\f1\fs20 CreateJoined}} when you need nested objects
8. {\b Specify fields} in queries when you don't need all columns
9. {\b Design domain-first}, let the ORM handle persistence
10. {\b Test with {\f1\fs20 TRestStorageInMemory}} for fast unit tests
{}
{\i Next Chapter: Database Layer (SQLite3, Virtual Tables)}
{}

; === mORMot2-SAD-Chapter-07.md ===
; Converted from Markdown - Chapter 7
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:7Database Layer
{}
{\i @*SQLite3@ at the Core}
{}
m@*ORM@ot 2's persistence architecture is centered on SQLite3 but not limited to it. The framework supports multiple database backends, all accessible through a unified interface.
{}
:701 SQLite3-Powered, Not SQLite3-Limited
{}
The core database of the framework uses SQLite3 - a free, secure, zero-configuration, server-less, cross-platform database engine.
{}
:  Persistence Options
{}
$┌─────────────────────────────────────────────────────────────────────┐
$│                        mORMot ORM / REST                            │
$└─────────────────────────────────────────────────────────────────────┘
$                                │
$     ┌──────────────────────────┼──────────────────────────┐
$     │                          │                          │
$     ▼                          ▼                          ▼
$┌─────────────┐          ┌─────────────┐          ┌─────────────┐      
$│  SQLite3    │          │ External DB │          │   NoSQL           │
$│  (native)   │          │  (via SQL)  │          │  (MongoDB)        │
$└─────────────┘          └─────────────┘          └─────────────┘      
$     │                          │                          │
$     ▼                          ▼                          ▼
!   File/Mem             PostgreSQL/Oracle          Document Store
!                        MSSQL/MySQL/etc.
{}
|%30%13%57
|\b Storage Backend|Unit(s)|Use Case\b0
|Internal SQLite3|{\f1\fs20 mormot.orm.sqlite3}|Default, embedded, full SQL
|In-Memory {\f1\fs20 TObjectList}|@!src\orm\mormot.orm.storage.pas@|Fastest, no @*ACID@, limited SQL
|External RDBMS|@!src\orm\mormot.orm.sql.pas@ + {\f1\fs20 mormot.db.sql.*}|Enterprise databases
|@*MongoDB@|@!src\orm\mormot.orm.mongodb.pas@|NoSQL document store
|%
{}
:  SQLite3 as Core
{}
The framework uses compiled SQLite3 code, included natively in Delphi/FPC:
{}
- {\b Static linking} (recommended) or external {\f1\fs20 sqlite3.dll}
- {\b Optimized performance} via {\f1\fs20 FastMM4} / FPC memory manager
- {\b Optional encryption} (AES-256) on disk
- {\b Record-level locking} (SQLite3 only has file-level)
- {\b Client-Server support} (SQLite3 is normally standalone-only)
{}
{\b Compilation options include:}
- {\f1\fs20 ISO} 8601 date/time handling
- R-Tree extension for range queries
- FTS3/FTS4/FTS5 full-text search
- PCRE-based {\f1\fs20 REGEXP} operator
- Custom SQL functions in Delphi
{}
:  Virtual Tables Magic
{}
SQLite3's Virtual Table mechanism allows mORMot to:
{}
- Mix internal SQLite3 tables with external databases in the same query
- JOIN across different database engines
- Use {\f1\fs20 TObjectList} storage with SQL queries
- Present MongoDB collections as SQL tables
{}
!// One model, multiple backends
!Model := TOrmModel.Create([
!  TOrmCustomer,   // Internal SQLite3
!  TOrmProduct,    // External PostgreSQL
!  TOrmOrder,      // External PostgreSQL
!  TOrmAuditLog    // MongoDB
!]);
!
!// Mix in single query (via virtual tables)
!Server.Orm.ExecuteList([TOrmOrder, TOrmCustomer],
!  'SELECT Order.ID, Customer.Name FROM Order, Customer ' +
!  'WHERE Order.CustomerID = Customer.ID');
{}
:702 SQLite3 Implementation
{}
:  Unit Structure
{}
!mormot.db.raw.sqlite3.pas   → Low-level SQLite3 C API wrapper
!        ↓
!mormot.db.sql.sqlite3.pas   → TSqlDB* implementation for SQLite3
!        ↓
!mormot.orm.sqlite3.pas      → ORM integration (TRestServerDB)
{}
:  Static vs Dynamic Linking
{}
|%21%12%67
|\b Mode|Unit|Deployment\b0
|Static|{\f1\fs20 mormot.db.raw.sqlite3.static}|Embedded in EXE (~1MB)
|Dynamic|{\f1\fs20 mormot.db.raw.sqlite3}|External {\f1\fs20 sqlite3.dll}
|%
{}
{\b Static linking} (recommended for Windows):
!uses
!  mormot.db.raw.sqlite3.static,  // Include static .obj
!  mormot.orm.sqlite3;
{}
{\b Dynamic linking} (required for some platforms):
!uses
!  mormot.db.raw.sqlite3,
!  mormot.orm.sqlite3;
!
!// Load external DLL
!sqlite3 := TSqlite3LibraryDynamic.Create;
{}
:  Database Modes
{}
!uses
!  mormot.orm.sqlite3,
!  mormot.rest.sqlite3;
!
!var
!  Server: TRestServerDB;
!begin
!  // File-based (default - ACID, persistent)
!  Server := TRestServerDB.Create(Model, 'data.db3');
!
!  // In-memory (fast, non-persistent)
!  Server := TRestServerDB.Create(Model, ':memory:');
!
!  // Performance tuning
!  Server.DB.Synchronous := smOff;       // Faster writes (less safe)
!  Server.DB.LockingMode := lmExclusive; // Single-process access
!end;
{}
:  Performance Modes
{}
|%15%22%17%46
|\b Mode|Safety|Speed|Use Case\b0
|{\f1\fs20 smFull} (default)|ACID|Slow writes|Production with crash safety
|{\f1\fs20 smOff}|Risk on crash|Fast|Batch imports, dev/test
|{\f1\fs20 lmExclusive}|Single process|Fastest|Embedded applications
|%
{}
{\b Batch write example:}
!Server.DB.Synchronous := smOff;
!Server.DB.LockingMode := lmExclusive;
!try
!  // 100x faster bulk insert
!  for i := 1 to 100000 do
!    Server.Orm.Add(CreateRecord(i), True);
!finally
!  Server.DB.Synchronous := smFull;  // Restore safety
!end;
{}
:703 Prepared Statements
{}
mORMot automatically caches prepared SQL statements for reuse.
{}
:  Parameter Binding
{}
Use {\f1\fs20 ?} placeholders for parameters:
{}
!// Parameters bound safely (no SQL injection)
!Rec := TOrm.CreateAndFillPrepare(Orm,
!  'Name LIKE ? AND Active = ?', ['John%', True]);
!
!// Date parameters
!Rec := TOrm.CreateAndFillPrepare(Orm,
!  'Created >= ?', [DateToSql(EncodeDate(2024, 1, 1))]);
{}
:  Internal Caching
{}
The framework caches prepared statements internally:
{}
!// First call: Parse SQL, prepare statement, execute
!Orm.Retrieve('Name = ?', [], ['John'], Rec);
!
!// Subsequent calls: Reuse prepared statement, rebind parameters
!Orm.Retrieve('Name = ?', [], ['Jane'], Rec);  // Much faster
{}
:  JSON Inlined Parameters
{}
Internally, parameters are encoded as {\f1\fs20 :(value):} in @*JSON@:
{}
!// API call
!Orm.Retrieve('ID = ?', [], [42], Rec);
!
!// Transmitted as JSON
!'{"Where":"ID=:(42):"}'
!
!// Prepared SQL
!'SELECT * FROM TableName WHERE ID = ?'  // With 42 bound
{}
:704 R-Tree Extension
{}
R-Trees provide fast range queries for multi-dimensional data (geospatial, temporal).
{}
:  Defining R-Tree Tables
{}
!type
!  TOrmMapBox = class(TOrmRTree)
!  private
!    fMinX, fMaxX: Double;
!    fMinY, fMaxY: Double;
!  published
!    property MinX: Double read fMinX write fMinX;
!    property MaxX: Double read fMaxX write fMaxX;
!    property MinY: Double read fMinY write fMinY;
!    property MaxY: Double read fMaxY write fMaxY;
!  end;
{}
:  R-Tree Queries
{}
!// Find all boxes containing point (10, 20)
!Boxes := TOrmMapBox.CreateAndFillPrepare(Orm,
!  'MinX <= ? AND MaxX >= ? AND MinY <= ? AND MaxY >= ?',
!  [10, 10, 20, 20]);
!
!// Or use RTreeMatch for complex queries
!Orm.RTreeMatch(TOrmMapData, 'BlobField', TOrmMapBox,
!  MapData.BlobField, ResultIDs);
{}
:705 Full-Text Search (FTS5)
{}
FTS5 provides fast full-text search capabilities.
{}
:  FTS Classes
{}
|%13%36%51
|\b Class|Tokenizer|Use Case\b0
|{\f1\fs20 TOrmFTS5}|Simple|Basic text search
|{\f1\fs20 TOrmFTS5Porter}|Porter stemmer|English text
|{\f1\fs20 TOrmFTS5@*Unicode@61}|Unicode61|Non-Latin languages
|%
{}
:  Defining FTS Tables
{}
!type
!  TOrmArticleFTS = class(TOrmFTS5Porter)
!  private
!    fTitle: RawUtf8;
!    fBody: RawUtf8;
!  published
!    property Title: RawUtf8 read fTitle write fTitle;
!    property Body: RawUtf8 read fBody write fBody;
!  end;
{}
:  Indexing Content
{}
!// Link FTS to main table via DocID
!FTS := TOrmArticleFTS.Create;
!FTS.DocID := Article.ID;  // Link to TOrmArticle
!FTS.Title := Article.Title;
!FTS.Body := Article.Content;
!Orm.Add(FTS, True);
!
!// Optimize after bulk inserts (FTS5 inherits from FTS3)
!TOrmArticleFTS.OptimizeFTS3Index(Server.OrmInstance as IRestOrmServer);
{}
:  Searching
{}
!var
!  IDs: TIDDynArray;
!begin
!  // Basic search
!  Orm.FTSMatch(TOrmArticleFTS, 'database optimization', IDs);
!
!  // With field weighting (Title=2x, Body=1x)
!  Orm.FTSMatch(TOrmArticleFTS, 'database', IDs, [2.0, 1.0]);
!
!  // Complex queries
!  Orm.FTSMatch(TOrmArticleFTS, 'Title:database AND Body:performance', IDs);
!end;
{}
:  FTS Query Syntax
{}
|%22%78
|\b Pattern|Meaning\b0
|{\f1\fs20 word}|Match exact word
|{\f1\fs20 word*}|Prefix match
|{\f1\fs20 "exact phrase"}|Match phrase
|{\f1\fs20 word1 AND word2}|Both required
|{\f1\fs20 word1 OR word2}|Either matches
|{\f1\fs20 word1 NOT word2}|Exclude word2
|{\f1\fs20 NEAR(word1 word2, 5)}|Within 5 tokens
|{\f1\fs20 Title:word}|Match in specific column
|%
{}
:706 In-Memory Storage
{}
:  TRestStorageInMemory
{}
Ultra-fast storage using {\f1\fs20 TObjectList}:
{}
!uses
!  mormot.orm.storage,
!  mormot.orm.server;
!
!// Create in-memory storage and register with ORM server
!var
!  Storage: TRestStorageInMemory;
!  OrmServer: TRestOrmServer;
!  TableIndex: Integer;
!begin
!  OrmServer := Server.OrmInstance as TRestOrmServer;
!  Storage := TRestStorageInMemory.Create(TOrmCache, OrmServer);
!  TableIndex := OrmServer.Model.GetTableIndexExisting(TOrmCache);
!  OrmServer.StaticTableSetup(TableIndex, Storage, sStaticDataTable);
!end;
{}
:  Features and Limitations
{}
|%29%54%17
|\b Feature|In-Memory|SQLite3\b0
|Speed|Fastest|Fast
|ACID|No|Yes
|SQL Joins|Limited|Full
|Max Size|RAM|Disk
|Persistence|Optional (JSON/Binary)|Yes
|Unique Index|O(1) hash|B-Tree
|%
{}
:  Persistence Options
{}
!var
!  Storage: TRestStorageInMemory;
!  Stream: TFileStream;
!  JsonContent: RawUtf8;
!begin
!  Storage := TRestStorageInMemory.Create(TOrmCache, OrmServer);
!
!  // Save to JSON file (via stream)
!  Stream := TFileStream.Create('cache.json', fmCreate);
!  try
!    Storage.SaveToJson(Stream, True);  // True = expand JSON
!  finally
!    Stream.Free;
!  end;
!
!  // Load from JSON file - LoadFromJson takes RawUtf8, not Stream
!  JsonContent := StringFromFile('cache.json');
!  Storage.LoadFromJson(JsonContent);
!
!  // Save binary (via stream)
!  Stream := TFileStream.Create('cache.data', fmCreate);
!  try
!    Storage.SaveToBinary(Stream);
!  finally
!    Stream.Free;
!  end;
!
!  // Load binary (via stream)
!  Stream := TFileStream.Create('cache.data', fmOpenRead);
!  try
!    Storage.LoadFromBinary(Stream);
!  finally
!    Stream.Free;
!  end;
!end;
{}
:  Virtual Table Mode
{}
Register in-memory as virtual table for SQL access:
{}
!// For SQL joins, register as virtual table BEFORE server creation
!Model.VirtualTableRegister(TOrmCache, TOrmVirtualTableJson);
!
!// Then create server - the virtual table will be available
!Server := TRestServerDB.Create(Model, 'main.db3');
{}
:707 Virtual Tables
{}
:  Built-in Virtual Table Classes
{}
|%18%42%40
|\b Class|Storage|Persistence\b0
|{\f1\fs20 TOrmVirtualTableJson}|In-memory|JSON file
|{\f1\fs20 TOrmVirtualTableBinary}|In-memory|Binary file
|{\f1\fs20 TOrmVirtualTableExternal}|External DB|Database
|{\f1\fs20 TOrmVirtualTableMongoDB}|MongoDB|MongoDB
|%
{}
:  Registering Virtual Tables
{}
!// Must register BEFORE creating server
!Model.VirtualTableRegister(TOrmTempData, TOrmVirtualTableJson);
!Model.VirtualTableRegister(TOrmCustomer, TOrmVirtualTableExternal);
!
!// Then create server
!Server := TRestServerDB.Create(Model, 'main.db3');
{}
:  Custom Virtual Tables
{}
!type
!  TMyVirtualTable = class(TOrmVirtualTable)
!  public
!    class function ModuleName: RawUtf8; override;
!    function Prepare(var Prepared: TOrmVirtualTablePrepared): boolean; override;
!    function Search(var Prepared: TOrmVirtualTablePrepared): boolean; override;
!  end;
{}
:708 JSON Functions in SQLite3
{}
mORMot adds JSON manipulation functions to SQLite3:
{}
:  JsonGet
{}
Extract values from JSON columns:
{}
$-- Get property value
$SELECT JsonGet(DataColumn, 'name') FROM Table WHERE ID=1;
$
$-- Get nested property
$SELECT JsonGet(DataColumn, 'address.city') FROM Table;
$
$-- Get multiple properties
$SELECT JsonGet(DataColumn, 'name,email') FROM Table;
$
$-- Wildcard match
$SELECT JsonGet(DataColumn, 'user.*') FROM Table;
{}
:  JsonHas
{}
Check property existence:
{}
$-- Check if property exists
$SELECT * FROM Table WHERE JsonHas(DataColumn, 'premium') = 1;
$
$-- Check nested property
$SELECT * FROM Table WHERE JsonHas(DataColumn, 'settings.darkMode') = 1;
{}
:709 Backup and Recovery
{}
:  Online Backup
{}
!// Hot backup (while server is running)
!Server.DB.BackupBackground('backup.db3', 100, 10,
!  procedure(Sender: TSqlDatabase; Step: integer)
!  begin
!    WriteLn('Backup progress: ', Step);
!  end);
{}
:  Restore
{}
!// Stop server, copy backup file, restart
!Server.Free;
!CopyFile('backup.db3', 'data.db3');
!Server := TRestServerDB.Create(Model, 'data.db3');
{}
:710 Performance Tips
{}
:  General Guidelines
{}
1. {\b Use transactions} for bulk operations
2. {\b Use batch operations} ({\f1\fs20 TRestBatch}) for inserts
3. {\b Use prepared statements} (automatic with {\f1\fs20 ?} parameters)
4. {\b Index foreign keys} and frequently queried columns
5. {\b Use {\f1\fs20 smOff} temporarily} for bulk imports
6. {\b Use {\f1\fs20 lmExclusive}} for single-process applications
{}
:  Benchmark Reference
{}
Typical performance on modern hardware (SSD, Core i7):
{}
|%26%15%24%35
|\b Operation|In-Memory|SQLite3 (File)|External PostgreSQL\b0
|Insert (single)|300,000/s|500/s|5,000/s
|Insert (batch)|500,000/s|200,000/s|50,000/s
|Read (by ID)|900,000/s|130,000/s|10,000/s
|Read (all)|900,000/s|550,000/s|150,000/s
|%
{}
{\i Note: Actual performance varies based on hardware, network, and data complexity.}
{}
:711 Migration from mORMot 1
{}
:  Unit Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 SynSQLite3.pas}|{\f1\fs20 mormot.db.raw.sqlite3.pas}
|{\f1\fs20 SynSQLite3Static.pas}|{\f1\fs20 mormot.db.raw.sqlite3.static.pas}
|{\f1\fs20 mORMotSQLite3.pas}|{\f1\fs20 mormot.orm.sqlite3.pas} + {\f1\fs20 mormot.rest.sqlite3.pas}
|%
{}
:  Class Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 TSQLRestServerDB}|{\f1\fs20 TRestServerDB}
|{\f1\fs20 TSQLDatabase}|{\f1\fs20 TSqlDatabase}
|{\f1\fs20 TSQLRecordFTS3}|{\f1\fs20 TOrmFTS3}
|{\f1\fs20 TSQLRecordFTS5}|{\f1\fs20 TOrmFTS5}
|{\f1\fs20 TSQLRecordRTree}|{\f1\fs20 TOrmRTree}
|{\f1\fs20 TSQLRestStorageInMemory}|{\f1\fs20 TRestStorageInMemory}
|%
{}
{\i Next Chapter: External SQL Database Access}
{}

; === mORMot2-SAD-Chapter-08.md ===
; Converted from Markdown - Chapter 8
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:8External SQL Database Access
{}
{\i Connect to Any RDBMS}
{}
The m@*ORM@ot framework provides direct access to external SQL databases through the {\f1\fs20 mormot.db.sql.*} units. These databases can be used standalone or integrated with the ORM via virtual tables.
{}
:801 Architecture Overview
{}
:  SynDB Layer (mORMot 2: mormot.db.*)
{}
$┌─────────────────────────────────────────────────────────────────┐ 
$│                     mormot.db.sql.pas                            │
$│              TSqlDBConnectionProperties (abstract)               │
$│              TSqlDBConnection, TSqlDBStatement                   │
$└─────────────────────────────────────────────────────────────────┘ 
$                              │
$      ┌───────────────────────┼───────────────────────┐
$      │                       │                       │
$      ▼                       ▼                       ▼
$┌─────────────┐       ┌─────────────┐       ┌─────────────┐         
$│   Direct    │       │    ODBC     │       │  TDataSet            │
$│   Access    │       │   Access    │       │   Bridge             │
$└─────────────┘       └─────────────┘       └─────────────┘         
$      │                       │                       │
$      ▼                       ▼                       ▼
!  PostgreSQL              Any ODBC              FireDAC
!  Oracle (OCI)            Driver                UniDAC
!  SQLite3                                       NexusDB
{}
:  Provider Units
{}
|%32%12%56
|\b Provider|Unit|Direct Access\b0
|@*PostgreSQL@|@!src\db\mormot.db.sql.postgres.pas@|Yes (libpq)
|@*Oracle@|@!src\db\mormot.db.sql.oracle.pas@|Yes (OCI)
|@*SQLite3@|{\f1\fs20 mormot.db.sql.sqlite3}|Yes
|ODBC|@!src\db\mormot.db.sql.odbc.pas@|Yes
|OleDB|@!src\db\mormot.db.sql.oledb.pas@|Yes
|Zeos/ZDBC|@!src\db\mormot.db.sql.zeos.pas@|Yes (recommended)
|FireDAC|@!src\db\mormot.db.rad.firedac.pas@|Via {\f1\fs20 TDataSet}
|UniDAC|@!src\db\mormot.db.rad.unidac.pas@|Via {\f1\fs20 TDataSet}
|NexusDB|@!src\db\mormot.db.rad.nexusdb.pas@|Via {\f1\fs20 TDataSet}
|%
{}
:  Database Engines Supported
{}
|%33%15%10%12%10%20
|\b Database|Direct|ODBC|OleDB|Zeos|TDataSet\b0
|PostgreSQL|✓|✓|-|✓|✓
|Oracle|✓|✓|✓|✓|✓
|MS SQL Server|-|✓|✓|✓|✓
|@*MySQL@/MariaDB|-|✓|-|✓|✓
|SQLite3|✓|✓|-|✓|✓
|Firebird|-|✓|-|✓|✓
|{\f1\fs20 IBM} DB2|-|✓|✓|✓|✓
|Informix|-|✓|-|-|✓
|%
{}
:802 Connection Properties
{}
:  Creating Connections
{}
!uses
!  mormot.db.sql,
!  mormot.db.sql.postgres;
!
!var
!  Props: TSqlDBPostgresConnectionProperties;
!begin
!  // PostgreSQL direct
!  Props := TSqlDBPostgresConnectionProperties.Create(
!    'localhost:5432', 'mydb', 'user', 'password');
!
!  // Connection string alternative
!  Props := TSqlDBPostgresConnectionProperties.Create(
!    'host=localhost port=5432 dbname=mydb', '', 'user', 'password');
!end;
{}
:  Provider-Specific Examples
{}
{\b Oracle (direct OCI):}
!uses
!  mormot.db.sql.oracle;
!
!Props := TSqlDBOracleConnectionProperties.Create(
!  'myserver/orcl', '', 'scott', 'tiger');
!
!// With TNS alias
!Props := TSqlDBOracleConnectionProperties.Create(
!  'PROD_DB', '', 'user', 'password');
{}
{\b MS SQL Server (ODBC):}
!uses
!  mormot.db.sql.odbc;
!
!Props := TSqlDBOdbcConnectionProperties.Create(
!  'Driver={SQL Server};Server=.\SQLEXPRESS;Database=mydb',
!  '', 'user', 'password');
!
!// Windows authentication
!Props := TSqlDBOdbcConnectionProperties.Create(
!  'Driver={SQL Server};Server=.\SQLEXPRESS;Database=mydb;Trusted_Connection=Yes',
!  '', '', '');
{}
{\b Zeos (recommended for cross-database):}
!uses
!  mormot.db.sql.zeos;
!
!// PostgreSQL via Zeos
!Props := TSqlDBZeosConnectionProperties.Create(
!  'zdbc:postgresql://localhost:5432/mydb', '', 'user', 'password');
!
!// MySQL via Zeos
!Props := TSqlDBZeosConnectionProperties.Create(
!  'zdbc:mysql://localhost:3306/mydb', '', 'user', 'password');
!
!// Firebird via Zeos
!Props := TSqlDBZeosConnectionProperties.Create(
!  'zdbc:firebird://localhost/C:\Data\mydb.fdb', '', 'SYSDBA', 'masterkey');
{}
:  Connection Properties Lifecycle
{}
!var
!  Props: TSqlDBConnectionProperties;
!begin
!  // Create once, use throughout application
!  Props := TSqlDBPostgresConnectionProperties.Create(...);
!  try
!    // Props manages connection pool internally
!    UseDatabase(Props);
!  finally
!    Props.Free;  // Release all connections
!  end;
!end;
{}
{\b Important}: Create {\f1\fs20 TSqlDBConnectionProperties} once per application. It manages connection pooling automatically.
{}
:803 Executing Queries
{}
:  ISqlDBRows Interface
{}
The simplest and safest pattern:
{}
!var
!  Rows: ISqlDBRows;
!begin
!  Rows := Props.Execute(
!    'SELECT * FROM Customer WHERE Country = ?', ['USA']);
!
!  while Rows.Step do
!    WriteLn(Rows['Name'], ' - ', Rows['City']);
!
!  // No try..finally needed - interface auto-releases
!end;
{}
:  Statement-Based Access
{}
For more control:
{}
!var
!  Conn: TSqlDBConnection;
!  Stmt: ISqlDBStatement;  // Interface - auto-released
!begin
!  Conn := Props.ThreadSafeConnection;  // Thread-safe connection
!  Stmt := Conn.NewStatementPrepared(
!    'SELECT * FROM Customer WHERE Country = ?', True);  // True = cache
!
!  Stmt.BindTextU(1, 'USA');  // Use BindTextU for RawUtf8 strings
!  Stmt.ExecutePrepared;
!
!  while Stmt.Step do
!    WriteLn(Stmt.ColumnUtf8(0));
!  // No try..finally needed - interface auto-releases
!end;
{}
:  Late-Binding Access
{}
For convenient (but slower) field access:
{}
!var
!  Row: Variant;
!begin
!  with Props.Execute(
!    'SELECT * FROM Customer WHERE Country = ?',
!    ['USA'], @Row) do
!  while Step do
!    WriteLn(Row.Name, ' - ', Row.City);  // Late-binding!
!end;
{}
:  Direct JSON Output
{}
Export query results directly to @*JSON@:
{}
!var
!  Json: RawUtf8;
!begin
!  Json := Props.Execute(
!    'SELECT ID, Name, Email FROM Customer', []).FetchAllAsJson(True);
!  // Returns: [{"ID":1,"Name":"John","Email":"john@example.com"},...]
!end;
{}
:804 Field Types
{}
:  TSqlDBFieldType
{}
|%12%35%53
|\b Type|Delphi Type|Description\b0
|{\f1\fs20 ftNull}|-|SQL NULL
|{\f1\fs20 ftInt64}|{\f1\fs20 Int64}|Any integer
|{\f1\fs20 ftDouble}|{\f1\fs20 Double}|Floating-point
|{\f1\fs20 ftCurrency}|{\f1\fs20 Currency}|Fixed 4 decimals
|{\f1\fs20 ftDate}|{\f1\fs20 TDateTime}|Date and time
|{\f1\fs20 ftUtf8}|{\f1\fs20 RawUtf8}|@*Unicode@ text
|{\f1\fs20 ftBlob}|{\f1\fs20 RawByteString}|Binary data
|%
{}
:  Column Access Methods
{}
!// Type-safe access
!Value := Stmt.ColumnInt(0);       // Int64
!Value := Stmt.ColumnDouble(1);    // Double
!Value := Stmt.ColumnCurrency(2);  // Currency
!Value := Stmt.ColumnUtf8(3);      // RawUtf8
!Value := Stmt.ColumnDateTime(4);  // TDateTime
!Value := Stmt.ColumnBlob(5);      // RawByteString
!
!// Null checking
!if Stmt.ColumnNull(0) then
!  WriteLn('Value is NULL');
!
!// Variant access (auto-conversion)
!Value := Stmt.Column[0];  // Returns Variant
!Value := Stmt['ColumnName'];  // By name
{}
:805 Parameter Binding
{}
:  Positional Parameters
{}
!// Use ? for positional parameters
!Stmt := Conn.NewStatementPrepared(
!  'INSERT INTO Customer (Name, Email, Age) VALUES (?, ?, ?)', True);
!Stmt.BindTextU(1, 'John Doe');       // Use BindTextU for RawUtf8 strings
!Stmt.BindTextU(2, 'john@example.com');
!Stmt.Bind(3, Int64(30));             // Use Bind with Int64 for integers
!Stmt.ExecutePrepared;
{}
:  Array Binding (Bulk Insert)
{}
High-performance bulk operations:
{}
!// PostgreSQL, Oracle, and MSSQL support array binding
!Stmt := Conn.NewStatementPrepared(
!  'INSERT INTO Log (Timestamp, Message) VALUES (?, ?)', True);
!
!Stmt.BindArray(1, DateTimes);   // TDateTimeDynArray
!Stmt.BindArray(2, Messages);    // TRawUtf8DynArray
!Stmt.ExecutePrepared;           // Single network roundtrip!
{}
:  BLOB Parameters
{}
!var
!  Data: RawByteString;
!begin
!  Data := StringFromFile('image.png');
!  Stmt.Bind(1, ftBlob, Data);  // Explicit type
!  Stmt.ExecutePrepared;
!end;
{}
:806 Transactions
{}
:  Explicit Transactions
{}
!var
!  Conn: TSqlDBConnection;
!begin
!  Conn := Props.ThreadSafeConnection;
!  Conn.StartTransaction;
!  try
!    Conn.Execute('UPDATE Account SET Balance = Balance - 100 WHERE ID = 1');
!    Conn.Execute('UPDATE Account SET Balance = Balance + 100 WHERE ID = 2');
!    Conn.Commit;
!  except
!    Conn.Rollback;
!    raise;
!  end;
!end;
{}
:  Nested Transactions
{}
!// Most databases don't support true nested transactions
!// mORMot uses SAVEPOINTs where available
!Conn.StartTransaction;      // Begin
!try
!  Conn.StartTransaction;    // SAVEPOINT (if supported)
!  try
!    // Operations
!    Conn.Commit;            // RELEASE SAVEPOINT
!  except
!    Conn.Rollback;          // ROLLBACK TO SAVEPOINT
!    raise;
!  end;
!  Conn.Commit;              // COMMIT
!except
!  Conn.Rollback;            // ROLLBACK
!end;
{}
:807 ORM Integration
{}
:  Mapping TOrm to External Database
{}
!uses
!  mormot.orm.sql,
!  mormot.db.sql.postgres;
!
!var
!  Props: TSqlDBPostgresConnectionProperties;
!  Model: TOrmModel;
!  Server: TRestServerDB;
!begin
!  // Create connection properties
!  Props := TSqlDBPostgresConnectionProperties.Create(
!    'localhost:5432', 'mydb', 'user', 'password');
!
!  // Create model
!  Model := TOrmModel.Create([TOrmCustomer, TOrmOrder]);
!
!  // Map ORM classes to external database
!  OrmMapExternal(Model, TOrmCustomer, Props);
!  OrmMapExternal(Model, TOrmOrder, Props);
!
!  // Create server (SQLite3 for other tables)
!  Server := TRestServerDB.Create(Model, ':memory:');
!
!  // Now ORM operations go to PostgreSQL
!  Server.Orm.Add(Customer, True);
!end;
{}
:  Table and Field Name Mapping
{}
!// Custom table name
!OrmMapExternal(Model, TOrmCustomer, Props, 'CUSTOMERS');
!
!// Custom field mapping
!OrmMapExternal(Model, TOrmCustomer, Props, 'CUSTOMERS')
!  .MapField('Name', 'CUSTOMER_NAME')
!  .MapField('Email', 'EMAIL_ADDRESS');
{}
:  Auto-Create Tables
{}
!// mORMot can create tables in external database
!Props.UseFastCreateMissingFields := True;
!Server.CreateMissingTables;  // Creates in PostgreSQL
{}
:808 Multi-Database Scenarios
{}
:  Mixing Storage Backends
{}
!var
!  PostgresProps, OracleProps: TSqlDBConnectionProperties;
!begin
!  // Different databases for different tables
!  PostgresProps := TSqlDBPostgresConnectionProperties.Create(...);
!  OracleProps := TSqlDBOracleConnectionProperties.Create(...);
!
!  Model := TOrmModel.Create([
!    TOrmUser,     // Internal SQLite3
!    TOrmProduct,  // PostgreSQL
!    TOrmLegacy    // Oracle
!  ]);
!
!  OrmMapExternal(Model, TOrmProduct, PostgresProps);
!  OrmMapExternal(Model, TOrmLegacy, OracleProps);
!
!  Server := TRestServerDB.Create(Model, 'users.db3');
!end;
{}
:  Cross-Database Queries
{}
Thanks to SQLite3 virtual tables, you can JOIN across databases:
{}
!// This works even though Product is in PostgreSQL and User is in SQLite3!
!Server.Orm.ExecuteList([TOrmProduct, TOrmUser],
!  'SELECT Product.Name, User.Email ' +
!  'FROM Product, User ' +
!  'WHERE Product.OwnerID = User.ID');
{}
:809 Database-Specific Notes
{}
:  PostgreSQL
{}
!// Direct libpq access (fastest)
!uses mormot.db.sql.postgres;
!
!Props := TSqlDBPostgresConnectionProperties.Create(
!  'localhost:5432', 'dbname', 'user', 'pass');
!
!// Connection string options
!Props := TSqlDBPostgresConnectionProperties.Create(
!  'host=localhost port=5432 dbname=mydb sslmode=require',
!  '', 'user', 'pass');
{}
{\b Tips:}
- Use array binding for bulk inserts
- PostgreSQL handles @*UTF-8@ natively
- JSONB columns work well with {\f1\fs20 TDocVariant}
{}
:  Oracle
{}
!// Direct OCI access (fastest for Oracle)
!uses mormot.db.sql.oracle;
!
!Props := TSqlDBOracleConnectionProperties.Create(
!  'server/service', '', 'user', 'pass');
!
!// Array binding for bulk operations
!Props.ArrayBindingEnabled := True;
{}
{\b Tips:}
- Use array binding (Oracle excels at this)
- Direct OCI is much faster than ODBC/OleDB
- Large @*BLOB@s require special handling
{}
:  MS SQL Server
{}
!// ODBC (recommended)
!uses mormot.db.sql.odbc;
!
!Props := TSqlDBOdbcConnectionProperties.Create(
!  'Driver={ODBC Driver 17 for SQL Server};Server=.\SQLEXPRESS;Database=mydb',
!  '', 'user', 'pass');
!
!// OleDB alternative
!uses mormot.db.sql.oledb;
!
!Props := TSqlDBOleDBConnectionProperties.Create(
!  'Provider=SQLNCLI11;Server=.\SQLEXPRESS;Database=mydb',
!  '', 'user', 'pass');
{}
{\b Tips:}
- Use ODBC Driver 17+ for best performance
- Windows authentication: {\f1\fs20 Trusted_Connection=Yes}
- MARS (Multiple Active Result Sets) may cause issues
{}
:  MySQL/MariaDB
{}
!// Zeos (recommended)
!uses mormot.db.sql.zeos;
!
!Props := TSqlDBZeosConnectionProperties.Create(
!  'zdbc:mysql://localhost:3306/mydb', '', 'user', 'pass');
!
!// ODBC alternative
!Props := TSqlDBOdbcConnectionProperties.Create(
!  'Driver={MySQL ODBC 8.0 Driver};Server=localhost;Database=mydb',
!  '', 'user', 'pass');
{}
{\b Tips:}
- Use UTF-8 character set ({\f1\fs20 SET NAMES utf8mb4})
- InnoDB engine for transactions
- MariaDB is generally faster than MySQL
{}
:810 Performance Tuning
{}
:  Connection Pooling
{}
!// Connection pool is automatic
!Props := TSqlDBPostgresConnectionProperties.Create(...);
!
!// Configure pool size
!Props.ConnectionPoolMaxCount := 20;  // Max connections
!Props.ConnectionPoolTimeout := 60000;  // Timeout in ms
{}
:  Statement Caching
{}
!// Enable statement caching (True = cache)
!Stmt := Conn.NewStatementPrepared(SQL, True);
!
!// Clear cache if needed
!Conn.ClearStatementCache;
{}
:  Batch Operations
{}
!// Use ExecuteNoResult for multiple statements
!Conn.ExecuteNoResult('DELETE FROM TempTable');
!Conn.ExecuteNoResult('INSERT INTO TempTable SELECT * FROM Source');
!
!// Or use batch interface
!Batch := TRestBatch.Create(Server.Orm, TOrmCustomer);
!try
!  for i := 1 to 10000 do
!    Batch.Add(CreateCustomer(i), True);
!  Server.Orm.BatchSend(Batch);  // Single transaction
!finally
!  Batch.Free;
!end;
{}
:811 TDataSet Integration
{}
For VCL/FMX applications that need {\f1\fs20 TDataSet}:
{}
:  Read-Only DataSet
{}
!uses
!  mormot.db.rad.ui.sql;
!
!var
!  DataSet: TSqlDBDataSet;
!begin
!  DataSet := TSqlDBDataSet.Create(Self);
!  DataSet.Connection := Props;
!  DataSet.SQL.Text := 'SELECT * FROM Customer';
!  DataSet.Open;
!
!  DBGrid1.DataSource.DataSet := DataSet;
!end;
{}
:  From ISqlDBRows
{}
!uses
!  mormot.db.rad.ui.sql;
!
!var
!  Rows: ISqlDBRows;
!begin
!  Rows := Props.Execute('SELECT * FROM Customer', []);
!  DBGrid1.DataSource.DataSet := ToDataSet(Self, Rows);
!end;
{}
:812 Migration from mORMot 1
{}
:  Unit Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 SynDB.pas}|{\f1\fs20 mormot.db.sql.pas}
|{\f1\fs20 SynDBOracle.pas}|{\f1\fs20 mormot.db.sql.oracle.pas}
|{\f1\fs20 SynDBODBC.pas}|{\f1\fs20 mormot.db.sql.odbc.pas}
|{\f1\fs20 SynOleDB.pas}|{\f1\fs20 mormot.db.sql.oledb.pas}
|{\f1\fs20 SynDBZeos.pas}|{\f1\fs20 mormot.db.sql.zeos.pas}
|{\f1\fs20 SynDBSQLite3.pas}|{\f1\fs20 mormot.db.sql.sqlite3.pas}
|{\f1\fs20 SynDBDataset.pas}|{\f1\fs20 mormot.db.rad.pas}
|{\f1\fs20 SynDBFireDAC.pas}|{\f1\fs20 mormot.db.rad.firedac.pas}
|{\f1\fs20 mORMotDB.pas}|{\f1\fs20 mormot.orm.sql.pas}
|%
{}
:  Class Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 TSQLDBConnectionProperties}|{\f1\fs20 TSqlDBConnectionProperties}
|{\f1\fs20 TSQLDBConnection}|{\f1\fs20 TSqlDBConnection}
|{\f1\fs20 TSQLDBStatement}|{\f1\fs20 TSqlDBStatement}
|{\f1\fs20 ISQLDBRows}|{\f1\fs20 ISqlDBRows}
|{\f1\fs20 TSQLDBFieldType}|{\f1\fs20 TSqlDBFieldType}
|{\f1\fs20 VirtualTableExternalRegister}|{\f1\fs20 OrmMapExternal}
|%
{}
:  API Changes
{}
!// mORMot 1
!VirtualTableExternalRegister(Model, TSQLCustomer, Props);
!
!// mORMot 2
!OrmMapExternal(Model, TOrmCustomer, Props);
{}
{\i Next Chapter: External NoSQL Database Access (@*MongoDB@)}
{}

; === mORMot2-SAD-Chapter-09.md ===
; Converted from Markdown - Chapter 9
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:9External NoSQL Database Access
{}
{\i @*MongoDB@ and Object-Document Mapping}
{}
m@*ORM@ot provides native access to NoSQL databases, with MongoDB as the primary supported engine. The ORM seamlessly transforms into an @*ODM@ (Object-Document Mapping) when working with document stores.
{}
:901 NoSQL Overview
{}
:  Supported NoSQL Engines
{}
|%21%9%70
|\b Engine|Unit|Description\b0
|MongoDB|@!src\db\mormot.db.nosql.mongodb.pas@|Full ODM support
|In-Memory|@!src\orm\mormot.orm.storage.pas@|{\f1\fs20 TObjectList} with @*JSON@/binary persistence
|%
{}
:  MongoDB Advantages
{}
- {\b Schema flexibility}: Documents can have varying structures
- {\b Horizontal scaling}: Built-in sharding and replication
- {\b Document model}: Natural fit for mORMot's {\f1\fs20 TDocVariant}
- {\b High performance}: Excellent for write-heavy workloads
- {\b JSON native}: Direct integration with mORMot's JSON handling
{}
:902 MongoDB Client
{}
:  Unit Structure
{}
!mormot.db.nosql.bson.pas     → BSON encoding/decoding
!        ↓
!mormot.db.nosql.mongodb.pas  → MongoDB wire protocol client
!        ↓
!mormot.orm.mongodb.pas       → ORM/ODM integration
{}
:  Connecting to MongoDB
{}
{\b Basic connection:}
!uses
!  mormot.db.nosql.mongodb;
!
!var
!  Client: TMongoClient;
!  DB: TMongoDatabase;
!begin
!  Client := TMongoClient.Create('localhost', 27017);
!  try
!    DB := Client.Database['mydb'];
!    // Use DB...
!  finally
!    Client.Free;
!  end;
!end;
{}
{\b With authentication (SCRAM-SHA-1):}
!var
!  Client: TMongoClient;
!  DB: TMongoDatabase;
!begin
!  Client := TMongoClient.Create('localhost', 27017);
!  try
!    // Authenticate and get database
!    DB := Client.OpenAuth('mydb', 'username', 'password');
!    // Use DB...
!  finally
!    Client.Free;
!  end;
!end;
{}
{\b Replica set connection:}
!Client := TMongoClient.Create(
!  'mongodb://host1:27017,host2:27017,host3:27017/?replicaSet=myReplicaSet');
{}
:  Connection Options
{}
!Client := TMongoClient.Create('localhost', 27017);
!
!// Write concern settings
!Client.WriteConcern := wcAcknowledged;      // Default - wait for ack
!Client.WriteConcern := wcUnacknowledged;    // Fire and forget (fastest)
!Client.WriteConcern := wcMajority;          // Wait for majority
!
!// Read preference
!Client.ReadPreference := rpPrimary;         // Always read from primary
!Client.ReadPreference := rpSecondary;       // Read from secondaries
!Client.ReadPreference := rpNearest;         // Nearest server
{}
:903 BSON and TDocVariant
{}
:  BSON Types
{}
MongoDB uses BSON (Binary JSON), which extends JSON with additional types:
{}
|%32%68
|\b BSON Type|Delphi Representation\b0
|Double|{\f1\fs20 Double}
|String|{\f1\fs20 RawUtf8}
|Document|{\f1\fs20 TDocVariant}
|Array|{\f1\fs20 TDocVariant} (array mode)
|Binary|{\f1\fs20 RawByteString}
|ObjectId|{\f1\fs20 TBsonObjectID}
|Boolean|{\f1\fs20 Boolean}
|DateTime|{\f1\fs20 TDateTime}
|Null|{\f1\fs20 Null} variant
|Int32|{\f1\fs20 Integer}
|Int64|{\f1\fs20 Int64}
|Decimal128|{\f1\fs20 TDecimal128}
|%
{}
:  TDocVariant Integration
{}
{\f1\fs20 TDocVariant} seamlessly maps to MongoDB documents:
{}
!var
!  Doc: Variant;
!begin
!  // Create document with late-binding
!  TDocVariant.New(Doc);
!  Doc.name := 'John Doe';
!  Doc.email := 'john@example.com';
!  Doc.age := 30;
!  Doc.tags := _Arr(['developer', 'delphi', 'mongodb']);
!  Doc.address := _Obj([
!    'street', '123 Main St',
!    'city', 'New York',
!    'zip', '10001'
!  ]);
!
!  // Save to MongoDB
!  Coll.Insert(Doc);
!end;
{}
:  ObjectID Generation
{}
!var
!  ID: TBsonObjectID;
!begin
!  // Generate new ObjectID (client-side)
!  ID.ComputeNew;  // Use ComputeNew method on record
!
!  // ObjectID contains timestamp
!  WriteLn('Created at: ', DateTimeToStr(ID.CreateDateTime));
!
!  // Use in document
!  Doc._id := ID.ToVariant;
!  Coll.Insert(Doc);
!end;
{}
:904 Collection Operations
{}
:  Getting a Collection
{}
!var
!  Coll: TMongoCollection;
!begin
!  // Get or create collection
!  Coll := DB.CollectionOrCreate['customers'];
!
!  // Get existing collection
!  Coll := DB.Collection['customers'];
!end;
{}
:  Insert Operations
{}
{\b Single document:}
!var
!  Doc: Variant;
!begin
!  Doc := _ObjFast([
!    'name', 'John Doe',
!    'email', 'john@example.com',
!    'age', 30
!  ]);
!
!  Coll.Insert(Doc);
!  WriteLn('Inserted with _id: ', Doc._id);  // Auto-generated ObjectID
!end;
{}
{\b Bulk insert (much faster):}
!var
!  Docs: TVariantDynArray;
!  i: Integer;
!begin
!  SetLength(Docs, 10000);
!  for i := 0 to High(Docs) do
!  begin
!    ID.ComputeNew;  // Generate new ObjectID
!    Docs[i] := _ObjFast([
!      '_id', ID.ToVariant,
!      'index', i,
!      'data', FormatUtf8('Record %', [i])
!    ]);
!  end;
!
!  Coll.Insert(Docs);  // Single network roundtrip!
!end;
{}
:  Find Operations
{}
{\b Find one document:}
!var
!  Doc: Variant;
!begin
!  // By _id
!  Doc := Coll.FindOne(ObjectID);
!  Doc := Coll.FindOne(123);  // Integer _id
!
!  // By query
!  Doc := Coll.FindDoc('{name:?}', ['John']);
!  Doc := Coll.FindDoc('{age:{$gt:?}}', [21]);
!end;
{}
{\b Find multiple documents:}
!var
!  Docs: TVariantDynArray;
!  Doc: Variant;
!begin
!  // Get all matching documents
!  Coll.FindDocs('{status:?}', ['active'], Docs);
!
!  for Doc in Docs do
!    WriteLn(Doc.name);
!end;
{}
{\b Find with projection:}
!var
!  Json: RawUtf8;
!begin
!  // Return only specific fields
!  Json := Coll.FindJson(
!    '{status:?}',        // Query
!    ['active'],          // Parameters
!    '{name:1,email:1}'   // Projection (include name and email)
!  );
!end;
{}
{\b Iterating multiple documents:}
!var
!  Docs: TVariantDynArray;
!  Doc: Variant;
!begin
!  // FindDocs fills array with all matching documents
!  Coll.FindDocs('{age:{$gte:?}}', [18], Docs, Null);
!  for Doc in Docs do
!    WriteLn(Doc.name);
!end;
{}
> {\b Note}: mORMot2 MongoDB uses array-based retrieval ({\f1\fs20 FindDocs}) rather than cursor iteration. For large result sets, use pagination with {\f1\fs20 NumberToReturn} and {\f1\fs20 NumberToSkip} parameters.
{}
:  Update Operations
{}
{\b Replace document:}
!var
!  Doc: Variant;
!begin
!  Doc := Coll.FindOne(123);
!  Doc.status := 'updated';
!  Coll.Save(Doc);  // Replace entire document
!end;
{}
{\b Partial update ($set):}
!// Update specific fields only
!Coll.Update(
!  '{_id:?}', [123],           // Query
!  '{$set:{status:?,updated:?}}', ['active', Now]  // Update
!);
{}
{\b Update multiple documents:}
!// Set all inactive users to archived
!Coll.UpdateMany(
!  '{status:?}', ['inactive'],
!  '{$set:{archived:?}}', [True]
!);
{}
{\b Upsert (insert if not exists):}
!Coll.Update(
!  '{email:?}', ['john@example.com'],
!  '{$set:{name:?,lastSeen:?}}', ['John', Now],
!  [mufUpsert]  // Create if not found
!);
{}
:  Delete Operations
{}
{\b Delete one:}
!Coll.Remove('{_id:?}', [ObjectID]);
!Coll.RemoveOne(123);  // By _id
{}
{\b Delete many:}
!Coll.Remove('{status:?}', ['deleted']);  // Delete all matching
{}
{\b Bulk delete:}
!var
!  IDs: TBsonObjectIDDynArray;
!begin
!  // Much faster than individual deletes
!  Coll.Remove('{_id:{$in:?}}', [IDs]);
!end;
{}
:905 MongoDB Query Language
{}
:  Comparison Operators
{}
|%25%53%22
|\b Operator|Description|Example\b0
|{\f1\fs20 $eq}|Equal|{\f1\fs20 {age:{$eq:30}}}
|{\f1\fs20 $ne}|Not equal|{\f1\fs20 {status:{$ne:'deleted'}}}
|{\f1\fs20 $gt}|Greater than|{\f1\fs20 {age:{$gt:21}}}
|{\f1\fs20 $gte}|Greater or equal|{\f1\fs20 {age:{$gte:18}}}
|{\f1\fs20 $lt}|Less than|{\f1\fs20 {price:{$lt:100}}}
|{\f1\fs20 $lte}|Less or equal|{\f1\fs20 {stock:{$lte:10}}}
|{\f1\fs20 $in}|In array|{\f1\fs20 {status:{$in:['active','pending']}}}
|{\f1\fs20 $nin}|Not in array|{\f1\fs20 {role:{$nin:['admin']}}}
|%
{}
:  Logical Operators
{}
!// AND (implicit)
!Coll.FindDocs('{age:{$gte:?},status:?}', [18, 'active'], Docs);
!
!// AND (explicit)
!Coll.FindDocs('{$and:[{age:{$gte:?}},{age:{$lt:?}}]}', [18, 65], Docs);
!
!// OR
!Coll.FindDocs('{$or:[{status:?},{priority:{$gt:?}}]}', ['urgent', 5], Docs);
!
!// NOT
!Coll.FindDocs('{age:{$not:{$lt:?}}}', [18], Docs);
{}
:  Element Operators
{}
!// Field exists
!Coll.FindDocs('{email:{$exists:true}}', [], Docs);
!
!// Type check
!Coll.FindDocs('{age:{$type:"int"}}', [], Docs);
{}
:  Array Operators
{}
!// Element in array
!Coll.FindDocs('{tags:?}', ['mongodb'], Docs);
!
!// All elements match
!Coll.FindDocs('{tags:{$all:?}}', [_Arr(['mongodb','delphi'])], Docs);
!
!// Array size
!Coll.FindDocs('{tags:{$size:?}}', [3], Docs);
!
!// Element match
!Coll.FindDocs('{items:{$elemMatch:{qty:{$gt:?},price:{$lt:?}}}}', [10, 100], Docs);
{}
:  Text Search
{}
!// Create text index first
!Coll.EnsureIndex('{content:"text"}');
!
!// Text search
!Coll.FindDocs('{$text:{$search:?}}', ['mongodb tutorial'], Docs);
{}
:906 ORM/ODM Integration
{}
:  Mapping TOrm to MongoDB
{}
!uses
!  mormot.orm.mongodb,
!  mormot.db.nosql.mongodb;
!
!var
!  Client: TMongoClient;
!  Model: TOrmModel;
!  Server: TRestServerDB;
!begin
!  // Connect to MongoDB
!  Client := TMongoClient.Create('localhost', 27017);
!
!  // Create model
!  Model := TOrmModel.Create([TOrmCustomer, TOrmOrder]);
!
!  // Map classes to MongoDB
!  OrmMapMongoDB(Model, TOrmCustomer, Client.Database['mydb'], 'customers');
!  OrmMapMongoDB(Model, TOrmOrder, Client.Database['mydb'], 'orders');
!
!  // Create server
!  Server := TRestServerDB.Create(Model, ':memory:');
!end;
{}
:  TOrm with MongoDB
{}
!type
!  TOrmArticle = class(TOrm)
!  private
!    fTitle: RawUtf8;
!    fContent: RawUtf8;
!    fTags: TRawUtf8DynArray;
!    fMetadata: Variant;  // TDocVariant for flexible schema
!  published
!    property Title: RawUtf8 read fTitle write fTitle;
!    property Content: RawUtf8 read fContent write fContent;
!    property Tags: TRawUtf8DynArray read fTags write fTags;
!    property Metadata: Variant read fMetadata write fMetadata;
!  end;
{}
:  Using the ORM
{}
Once mapped, use standard ORM methods:
{}
!var
!  Article: TOrmArticle;
!begin
!  // Create
!  Article := TOrmArticle.Create;
!  Article.Title := 'Introduction to MongoDB';
!  Article.Content := 'MongoDB is a document database...';
!  Article.Tags := ['mongodb', 'nosql', 'database'];
!  Article.Metadata := _ObjFast(['author', 'John', 'views', 0]);
!  Server.Orm.Add(Article, True);
!
!  // Read
!  Article := TOrmArticle.Create(Server.Orm, ArticleID);
!
!  // Update
!  Article.Metadata.views := Article.Metadata.views + 1;
!  Server.Orm.Update(Article);
!
!  // Delete
!  Server.Orm.Delete(TOrmArticle, ArticleID);
!
!  // Query
!  Article := TOrmArticle.CreateAndFillPrepare(Server.Orm,
!    'Tags = ?', ['mongodb']);
!  while Article.FillOne do
!    WriteLn(Article.Title);
!end;
{}
:  MongoDB-Specific Queries
{}
For advanced queries, use direct MongoDB access:
{}
!var
!  Coll: TMongoCollection;
!  Docs: TVariantDynArray;
!begin
!  // Get underlying collection
!  Coll := TRestStorageMongoDB(
!    Server.StaticDataServer[TOrmArticle]).Collection;
!
!  // Complex aggregation
!  Coll.AggregateJson([
!    '{$match:{status:"published"}}',
!    '{$group:{_id:"$author",count:{$sum:1}}}',
!    '{$sort:{count:-1}}'
!  ], Docs);
!end;
{}
:907 Aggregation Framework
{}
:  Pipeline Operations
{}
!var
!  Results: TVariantDynArray;
!begin
!  Coll.AggregateDoc([
!    // Stage 1: Filter
!    _ObjFast(['$match', _Obj(['status', 'active'])]),
!
!    // Stage 2: Group and count
!    _ObjFast(['$group', _Obj([
!      '_id', '$category',
!      'total', _Obj(['$sum', 1]),
!      'avgPrice', _Obj(['$avg', '$price'])
!    ])]),
!
!    // Stage 3: Sort
!    _ObjFast(['$sort', _Obj(['total', -1])])
!  ], Results);
!
!  for Doc in Results do
!    WriteLn(Doc._id, ': ', Doc.total, ' items, avg $', Doc.avgPrice);
!end;
{}
:  Common Aggregation Operators
{}
|%30%70
|\b Operator|Description\b0
|{\f1\fs20 $match}|Filter documents
|{\f1\fs20 $group}|Group by field
|{\f1\fs20 $sort}|Sort results
|{\f1\fs20 $project}|Reshape documents
|{\f1\fs20 $limit}|Limit results
|{\f1\fs20 $skip}|Skip documents
|{\f1\fs20 $unwind}|Deconstruct arrays
|{\f1\fs20 $lookup}|Left outer join
|%
{}
:908 Indexes
{}
:  Creating Indexes
{}
!// Single field index
!Coll.EnsureIndex('{email:1}');  // 1 = ascending
!
!// Compound index
!Coll.EnsureIndex('{status:1,created:-1}');
!
!// Unique index
!Coll.EnsureIndex('{email:1}', [ifoUnique]);
!
!// Text index
!Coll.EnsureIndex('{title:"text",content:"text"}');
!
!// TTL index (auto-delete after time)
!Coll.EnsureIndex('{createdAt:1}', [ifoExpireAfterSeconds], 3600);
{}
:  Index Hints
{}
!// Force index usage
!Coll.FindJson('{status:?}', ['active'], '',
!  '{$hint:{status:1}}');  // Use status index
{}
:909 Performance Tips
{}
:  Write Performance
{}
!// 1. Use bulk inserts
!Coll.Insert(DocsArray);  // Single call for many documents
!
!// 2. Use unacknowledged writes for non-critical data
!Client.WriteConcern := wcUnacknowledged;
!try
!  // Fast writes (no server confirmation)
!  Coll.Insert(LogEntries);
!finally
!  Client.WriteConcern := wcAcknowledged;
!end;
!
!// 3. Pre-generate ObjectIDs
!for i := 0 to High(Docs) do
!begin
!  ID.ComputeNew;
!  Docs[i]._id := ID.ToVariant;
!end;
{}
:  Read Performance
{}
!// 1. Use projections to limit returned fields
!Coll.FindJson('{status:?}', ['active'], '{name:1,email:1}');
!
!// 2. Use covered queries (all fields in index)
!Coll.EnsureIndex('{email:1,name:1}');
!Coll.FindJson('{email:?}', ['john@example.com'], '{email:1,name:1,_id:0}');
!
!// 3. Use cursor batching for large result sets
!Cursor := Coll.Find(Query, nil, [mqfNoCursorTimeout]);
!Cursor.BatchSize := 1000;
{}
:  Index Strategies
{}
- Index fields used in {\f1\fs20 $match} stages
- Index fields used in sorts
- Compound indexes for multi-field queries
- Cover queries with indexes when possible
- Monitor with {\f1\fs20 explain()} equivalent
{}
:910 Migration from mORMot 1
{}
:  Unit Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 SynMongoDB.pas}|{\f1\fs20 mormot.db.nosql.mongodb.pas}
|{\f1\fs20 mORMotMongoDB.pas}|{\f1\fs20 mormot.orm.mongodb.pas}
|%
{}
:  Class/Function Renames
{}
|%40%60
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 StaticMongoDBRegister}|{\f1\fs20 OrmMapMongoDB}
|{\f1\fs20 TMongoClient}|{\f1\fs20 TMongoClient} (unchanged)
|{\f1\fs20 TMongoDatabase}|{\f1\fs20 TMongoDatabase} (unchanged)
|{\f1\fs20 TMongoCollection}|{\f1\fs20 TMongoCollection} (unchanged)
|%
{}
:  Protocol Changes
{}
mORMot 2 uses the new MongoDB wire protocol (OP_MSG) introduced in MongoDB 3.6:
{}
!// For older MongoDB versions (< 3.6), define:
!{$DEFINE MONGO_OLDPROTOCOL}
{}
:911 Summary
{}
MongoDB integration in mORMot 2 provides:
{}
- {\b Full ODM support}: Use {\f1\fs20 TOrm} classes with MongoDB
- {\b Direct client access}: Low-level {\f1\fs20 TMongoClient} for advanced operations
- {\b {\f1\fs20 @**TDocVariant@} integration}: Natural document handling
- {\b Query flexibility}: Full MongoDB query language support
- {\b Performance}: Bulk operations, connection pooling, index management
- {\b Mixing backends}: Combine MongoDB with SQL in same application
{}
{\i Next Chapter: JSON @*REST@ful Client-Server}
{}

; === mORMot2-SAD-Chapter-10.md ===
; Converted from Markdown - Chapter 10
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:10JSON and RESTful Fundamentals
{}
{\i The Language of m@*ORM@ot}
{}
Before exploring the Client-Server architecture, we need to understand the two key standards that mORMot builds upon: @*JSON@ for data interchange and @*REST@ for API design.
{}
:1001 JSON in mORMot
{}
:  Why JSON?
{}
mORMot uses JSON (JavaScript Object Notation) as its primary data format:
{}
|%25%75
|\b Advantage|Description\b0
|Human-readable|Easy to debug and inspect
|Compact|Smaller than XML for most use cases
|Fast parsing|In-place parsing without memory allocation
|Native @*UTF-8@|Matches @*SQLite3@ and web standards
|Universal|Supported by all languages/platforms
|AJAX-ready|Native to JavaScript/browser apps
|%
{}
:  JSON Types
{}
${
$  "string": "Hello UTF-8 World",
$  "number": 42,
$  "float": 3.14159,
$  "boolean": true,
$  "null": null,
$  "array": [1, 2, 3],
$  "object": {"nested": "value"}
$}
{}
:  mORMot JSON Extensions
{}
mORMot follows the JSON standard with some extensions:
{}
- {\b Extended syntax}: Unquoted ASCII property names (@*MongoDB@-style)
- {\b 64-bit integers}: Full {\f1\fs20 Int64} support (no JavaScript 53-bit limit)
- {\b Binary data}: Base64 encoding for @*BLOB@s
- {\b Custom types}: {\f1\fs20 TDateTime}, {\f1\fs20 TTimeLog}, {\f1\fs20 Currency} serialization
{}
!// Extended syntax (valid in mORMot)
!{name: "John", age: 30}
!
!// Standard JSON (always valid)
!{"name": "John", "age": 30}
{}
:1002 JSON Serialization
{}
:  Basic Types
{}
!uses
!  mormot.core.json;
!
!var
!  i: Integer;
!  d: Double;
!  s: RawUtf8;
!  json: RawUtf8;
!begin
!  // To JSON
!  json := FormatJson('{name:?,age:?,score:?}', [], ['John', 30, 95.5]);
!  // Result: {"name":"John","age":30,"score":95.5}
!
!  // From JSON
!  JsonDecode(pointer(json), ['name', 'age', 'score'], @Values);
!end;
{}
:  Record Serialization
{}
Records are automatically serialized via @*RTTI@ (Delphi 2010+):
{}
!type
!  TPerson = record
!    Name: RawUtf8;
!    Age: Integer;
!    Email: RawUtf8;
!  end;
!
!var
!  Person: TPerson;
!  json: RawUtf8;
!begin
!  Person.Name := 'John';
!  Person.Age := 30;
!  Person.Email := 'john@example.com';
!
!  // Record to JSON
!  json := RecordSaveJson(Person, TypeInfo(TPerson));
!  // Result: {"Name":"John","Age":30,"Email":"john@example.com"}
!
!  // JSON to Record
!  RecordLoadJson(Person, pointer(json), TypeInfo(TPerson));
!end;
{}
:  Dynamic Arrays
{}
!type
!  TPersonArray = array of TPerson;
!
!var
!  People: TPersonArray;
!  json: RawUtf8;
!begin
!  SetLength(People, 2);
!  People[0].Name := 'John';
!  People[1].Name := 'Jane';
!
!  // Array to JSON
!  json := DynArraySaveJson(People, TypeInfo(TPersonArray));
!  // Result: [{"Name":"John",...},{"Name":"Jane",...}]
!
!  // JSON to Array
!  DynArrayLoadJson(People, pointer(json), TypeInfo(TPersonArray));
!end;
{}
:  TDocVariant (Schema-less)
{}
For flexible JSON handling:
{}
!var
!  doc: Variant;
!begin
!  // Create from JSON
!  doc := _JsonFast('{"name":"John","tags":["admin","user"]}');
!
!  // Access via late-binding
!  WriteLn(doc.name);           // 'John'
!  WriteLn(doc.tags._Count);    // 2
!
!  // Modify
!  doc.email := 'john@example.com';
!  doc.tags._Add('moderator');
!
!  // Back to JSON
!  WriteLn(doc);  // Full JSON string
!end;
{}
:  Class Serialization
{}
Classes are serialized via {\f1\fs20 published} properties:
{}
!type
!  TMyClass = class(TSynPersistent)
!  private
!    fName: RawUtf8;
!    fValue: Integer;
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Value: Integer read fValue write fValue;
!  end;
!
!var
!  Obj: TMyClass;
!  json: RawUtf8;
!begin
!  Obj := TMyClass.Create;
!  Obj.Name := 'Test';
!  Obj.Value := 42;
!
!  json := ObjectToJson(Obj);
!  // Result: {"Name":"Test","Value":42}
!
!  JsonToObject(Obj, pointer(json), Valid);
!end;
{}
:1003 REST Architecture
{}
:  What is REST?
{}
REST (Representational State Transfer) defines how resources are addressed and manipulated over @*HTTP@:
{}
|%21%11%19%49
|\b HTTP Method|CRUD|ORM Method|Description\b0
|{\f1\fs20 GET}|Read|{\f1\fs20 Retrieve()}|Get resource(s)
|{\f1\fs20 POST}|Create|{\f1\fs20 Add()}|Create new resource
|{\f1\fs20 PUT}|Update|{\f1\fs20 Update()}|Update existing resource
|{\f1\fs20 DELETE}|Delete|{\f1\fs20 Delete()}|Remove resource
|%
{}
:  mORMot URI Structure
{}
!http://server:port/root/TableName/ID
$                   │     │         │
$                   │     │         └── Record ID (optional)
$                   │     └── TOrm class name
$                   └── Model.Root
{}
{\b Examples:}
!GET    /api/Customer          → List all customers
!GET    /api/Customer/123      → Get customer #123
!POST   /api/Customer          → Create new customer (body = JSON)
!PUT    /api/Customer/123      → Update customer #123
!DELETE /api/Customer/123      → Delete customer #123
{}
:  REST vs RPC in mORMot
{}
mORMot is {\b REST-oriented} but supports both paradigms:
{}
|%36%32%32
|\b Feature|REST Style|RPC Style\b0
|ORM operations|URI + HTTP verbs|URI + HTTP verbs
|Method services|{\f1\fs20 GET/POST /root/Method}|{\f1\fs20 POST /root/Method}
|Interface services|{\f1\fs20 /root/Interface.Method}|JSON-RPC body
|%
{}
{\b Important}: mORMot prefers interface-based services (RPC-style) for business logic, using REST primarily for ORM operations.
{}
:1004 JSON in ORM
{}
:  TOrm to JSON
{}
!var
!  Customer: TOrmCustomer;
!  json: RawUtf8;
!begin
!  Customer := TOrmCustomer.Create;
!  Customer.Name := 'ACME Corp';
!  Customer.Email := 'contact@acme.com';
!
!  // Single record
!  json := Customer.GetJsonValues(True, True, ooSelect);
!  // Result: {"ID":0,"Name":"ACME Corp","Email":"contact@acme.com"}
!
!  // Selected fields only
!  json := Customer.GetJsonValues(True, True, ooSelect, 'Name,Email');
!end;
{}
:  JSON to TOrm
{}
!var
!  Customer: TOrmCustomer;
!begin
!  Customer := TOrmCustomer.Create;
!  Customer.FillFrom('{"Name":"ACME Corp","Email":"contact@acme.com"}');
!end;
{}
:  Query Results as JSON
{}
!var
!  json: RawUtf8;
!begin
!  // Direct JSON from query
!  json := Server.Orm.RetrieveListJson(TOrmCustomer,
!    'Country = ?', ['USA'], 'Name,Email');
!  // Result: [{"Name":"John","Email":"john@..."},...]
!end;
{}
:1005 JSON in Services
{}
:  Method-Based Services
{}
!type
!  TMyServer = class(TRestServerDB)
!  published
!    procedure Sum(Ctxt: TRestServerUriContext);
!  end;
!
!procedure TMyServer.Sum(Ctxt: TRestServerUriContext);
!var
!  A, B: Integer;
!begin
!  A := Ctxt.InputInt['a'];
!  B := Ctxt.InputInt['b'];
!  Ctxt.Returns(['result', A + B]);
!end;
!
!// Client call: GET /api/Sum?a=10&b=20
!// Response: {"result":30}
{}
:  Interface-Based Services
{}
!type
!  ICalculator = interface(IInvokable)
!    ['{...}']
!    function Add(A, B: Integer): Integer;
!  end;
!
!// Server registration
!Server.ServiceDefine(TCalculator, [ICalculator], sicShared);
!
!// Client call (automatic JSON marshalling)
!var
!  Calc: ICalculator;
!begin
!  Client.Services.Resolve(ICalculator, Calc);
!  Result := Calc.Add(10, 20);  // JSON: {"result":30}
!end;
{}
:1006 Binary Alternatives
{}
:  When to Use Binary
{}
|%16%47%37
|\b Format|Use Case|Trade-off\b0
|JSON|Interoperability, debugging|Larger, slower parsing
|Binary|Internal, large data|Smaller, faster
|SynLZ+JSON|Compression over network|Best of both
|%
{}
:  SynLZ Compression
{}
mORMot clients automatically negotiate compression:
{}
!// Server enables compression (default)
!HttpServer.Compress := [hcSynLZ, hcDeflate];
!
!// SynLZ is 20x faster than Deflate for compression
!// Delphi clients use SynLZ automatically
!// AJAX clients fall back to Deflate
{}
:  Binary Serialization
{}
!// Binary record save (faster than JSON)
!Binary := RecordSave(Person, TypeInfo(TPerson));
!RecordLoad(Person, pointer(Binary), TypeInfo(TPerson));
!
!// Binary with compression
!Binary := RecordSaveBase64(Person, TypeInfo(TPerson), True);
{}
:1007 JSON Performance Tips
{}
:  Avoid Unnecessary Conversions
{}
!// SLOW: Multiple conversions
!s := Utf8ToString(json);
!json2 := StringToUtf8(s);
!
!// FAST: Stay in UTF-8
!ProcessRawUtf8(json);
{}
:  Use Typed Helpers
{}
!// SLOW: Variant access
!value := doc.field;
!
!// FAST: Direct typed access
!value := _Safe(doc)^.I['field'];  // Integer
!value := _Safe(doc)^.U['field'];  // RawUtf8
{}
:  Reuse Objects
{}
!// SLOW: Create/Free per iteration
!for i := 1 to 1000 do
!begin
!  Obj := TMyClass.Create;
!  try
!    JsonToObject(Obj, pointer(json[i]), Valid);
!    Process(Obj);
!  finally
!    Obj.Free;
!  end;
!end;
!
!// FAST: Reuse single instance
!Obj := TMyClass.Create;
!try
!  for i := 1 to 1000 do
!  begin
!    Obj.ClearProperties;  // Reset fields
!    JsonToObject(Obj, pointer(json[i]), Valid);
!    Process(Obj);
!  end;
!finally
!  Obj.Free;
!end;
{}
:1008 Migration from mORMot 1
{}
:  Function Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 JSONToObject()}|{\f1\fs20 JsonToObject()}
|{\f1\fs20 ObjectToJSON()}|{\f1\fs20 ObjectToJson()}
|{\f1\fs20 RecordSaveJSON()}|{\f1\fs20 RecordSaveJson()}
|{\f1\fs20 RecordLoadJSON()}|{\f1\fs20 RecordLoadJson()}
|{\f1\fs20 DynArraySaveJSON()}|{\f1\fs20 DynArraySaveJson()}
|{\f1\fs20 JSONDecode()}|{\f1\fs20 JsonDecode()}
|%
{}
:  Unit Locations
{}
|%61%39
|\b Feature|mORMot 2 Unit\b0
|JSON parsing|@!src\core\mormot.core.json.pas@
|{\f1\fs20 @**TDocVariant@}|@!src\core\mormot.core.variants.pas@
|Record serialization|@!src\core\mormot.core.rtti.pas@
|HTTP client/server|@!src\net\mormot.net.client.pas@ / @!src\net\mormot.net.server.pas@
|%
{}
{\i Next Chapter: Client-Server Architecture}
{}

; === mORMot2-SAD-Chapter-11.md ===
; Converted from Markdown - Chapter 11
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:11Client-Server Architecture
{}
{\i Communication Layers and Protocols}
{}
m@*ORM@ot provides a flexible Client-Server architecture supporting multiple communication protocols. This chapter covers the protocol options, class hierarchy, and configuration patterns.
{}
:1101 Architecture Overview
{}
:  Communication Layers
{}
$┌─────────────────────────────────────────────────────────────────┐
$│                       Your Application                          │
$└─────────────────────────────────────────────────────────────────┘
$                               │
$┌─────────────────────────────────────────────────────────────────┐
$│                    TRest (Abstract Parent)                      │
$│    ├── Orm: IRestOrm        (Object-Relational Mapping)         │
$│    ├── Services             (Service-Oriented Architecture)     │
$│    └── Run: TRestRunThreads (Threading)                         │
$└─────────────────────────────────────────────────────────────────┘
$           │                                    │
$┌──────────────────────┐          ┌──────────────────────┐         
$│    TRestClient       │          │    TRestServer                │
$│  (Client-side)       │          │  (Server-side)                │
$└──────────────────────┘          └──────────────────────┘         
$           │                                    │
$┌─────────────────────────────────────────────────────────────────┐
$│                      Transport Layer                            │
$│  ┌──────────┐  ┌─────────┐  ┌──────────┐  ┌────────────────┐    │
$│  │In-Process│  │  HTTP   │  │WebSockets│  │Named Pipes/Msg │    │
$│  └──────────┘  └─────────┘  └──────────┘  └────────────────┘    │
$└─────────────────────────────────────────────────────────────────┘
{}
:  Protocol Comparison
{}
|%18%8%12%20%42
|\b Protocol|Speed|Scaling|Hosting|Use Case\b0
|In-Process|★★★★|★★★★|Same process|Testing, embedded
|@*HTTP@|★★|★★★★|Remote|Production servers
|@*WebSocket@s|★★★|★★★|Remote|Bidirectional callbacks
|Named Pipes|★★★|★|Local|Windows services
|%
{}
:  Access Methods
{}
|%22%36%42
|\b Method|Best For|Considerations\b0
|@*SOA@ Interfaces|Public/private services|Recommended, full features
|SOA Methods|Full @*REST@ control|More verbose
|@*MVC@ Web|Dynamic websites|HTML-oriented
|ORM REST|Testing, internal|Not for public APIs
|%
{}
:1102 Server Classes
{}
:  Class Hierarchy
{}
!TRest (abstract)
$└── TRestServer (abstract)
$    ├── TRestServerDB           → SQLite3 backend
$    ├── TRestServerFullMemory   → In-memory (no SQLite3)
$    └── TRestServerRemoteDB     → Proxy to remote ORM
{}
:  TRestServerDB (SQLite3)
{}
The primary server class with full @*SQLite3@ database:
{}
!uses
!  mormot.orm.core,
!  mormot.rest.sqlite3;
!
!var
!  Model: TOrmModel;
!  Server: TRestServerDB;
!begin
!  Model := TOrmModel.Create([TOrmCustomer, TOrmOrder]);
!  Server := TRestServerDB.Create(Model, 'data.db3');
!  try
!    Server.CreateMissingTables;
!    // Server ready...
!  finally
!    Server.Free;
!    Model.Free;
!  end;
!end;
{}
:  TRestServerFullMemory (No SQLite3)
{}
Lightweight server without SQLite3 dependency:
{}
!uses
!  mormot.rest.memserver;
!
!var
!  Server: TRestServerFullMemory;
!begin
!  Server := TRestServerFullMemory.Create(Model);
!  try
!    // Fast in-memory storage
!    // Can persist to JSON/binary files
!    Server.StaticDataSaveToFile('backup.json');
!  finally
!    Server.Free;
!  end;
!end;
{}
{\b Use cases:}
- Testing without database setup
- Simple @*CRUD@ + authentication
- Services with minimal ORM needs
{}
:  TRestServerRemoteDB (Proxy)
{}
Proxies ORM operations to another server:
{}
!uses
!  mormot.rest.core;
!
!var
!  RemoteClient: TRestHttpClient;
!  ProxyServer: TRestServerRemoteDB;
!begin
!  RemoteClient := TRestHttpClientWinHTTP.Create('dbserver', '8080', Model);
!  ProxyServer := TRestServerRemoteDB.Create(RemoteClient);
!  // ProxyServer forwards ORM to RemoteClient
!end;
{}
{\b Use cases:}
- DMZ deployment (public proxy → internal database)
- Service aggregation
- Load distribution
{}
:1103 Client Classes
{}
:  Class Hierarchy
{}
!TRest (abstract)
$└── TRestClientUri (abstract)
$    ├── TRestClientDB              → Direct SQLite3 access
$    ├── TRestClientLibraryRequest  → In-process DLL
$    └── TRestHttpClientGeneric     → HTTP transport
$        ├── TRestHttpClientWinSock    → Raw sockets
$        ├── TRestHttpClientWinHTTP    → WinHTTP API (recommended)
$        ├── TRestHttpClientWinINet    → WinINet API
$        ├── TRestHttpClientCurl       → libcurl (cross-platform)
$        └── TRestHttpClientWebsockets → WebSocket upgrade
{}
:  In-Process Client (TRestClientDB)
{}
Direct access without network overhead:
{}
!uses
!  mormot.rest.sqlite3;
!
!var
!  Client: TRestClientDB;
!begin
!  // Creates internal TRestServerDB
!  Client := TRestClientDB.Create(Model, nil, 'data.db3', TRestServerDB);
!  try
!    Client.Orm.Add(Customer, True);
!  finally
!    Client.Free;
!  end;
!end;
{}
:  HTTP Clients
{}
!uses
!  mormot.rest.http.client;
!
!var
!  Client: TRestHttpClientWinHTTP;
!begin
!  // Recommended HTTP client for Windows
!  Client := TRestHttpClientWinHTTP.Create('localhost', '8080', Model);
!  try
!    if Client.SetUser('user', 'password') then
!      Client.Orm.Retrieve(123, Customer);
!  finally
!    Client.Free;
!  end;
!end;
{}
{\b Client comparison:}
{}
|%9%27%9%13%42
|\b Class|Platform|HTTPS|Speed|Notes\b0
|{\f1\fs20 TRestHttpClientWinHTTP}|Windows|✓|Fast|{\b Recommended}
|{\f1\fs20 TRestHttpClientWinINet}|Windows|✓|Medium|IE proxy integration
|{\f1\fs20 TRestHttpClientWinSock}|Windows|✗|Fastest|No SSL
|{\f1\fs20 TRestHttpClientCurl}|Cross-platform|✓|Fast|Requires libcurl
|%
{}
:  WebSocket Client
{}
For bidirectional communication:
{}
!uses
!  mormot.rest.http.client;
!
!var
!  Client: TRestHttpClientWebsockets;
!begin
!  Client := TRestHttpClientWebsockets.Create('localhost', '8080', Model);
!  try
!    // Upgrade to WebSocket
!    Client.WebSocketsUpgrade('');
!
!    // Now supports server-to-client callbacks
!    Client.Services.Resolve(IMyCallback, Callback);
!  finally
!    Client.Free;
!  end;
!end;
{}
:1104 HTTP Server
{}
:  TRestHttpServer
{}
Wraps {\f1\fs20 TRestServer} instances for HTTP access:
{}
!uses
!  mormot.rest.http.server;
!
!var
!  HttpServer: TRestHttpServer;
!begin
!  HttpServer := TRestHttpServer.Create(
!    '8080',           // Port
!    [Server],         // TRestServer instances
!    '+',              // Domain ('+' = all)
!    useHttpAsync      // Server mode
!  );
!  try
!    HttpServer.AccessControlAllowOrigin := '*';  // CORS
!    // Server running...
!    ReadLn;
!  finally
!    HttpServer.Free;
!  end;
!end;
{}
:  Server Modes
{}
|%8%52%40
|\b Mode|Description|Use Case\b0
|{\f1\fs20 useHttpApi}|Windows HTTP.SYS (kernel-mode)|Windows production
|{\f1\fs20 useHttpSocket}|Thread-per-connection|Behind reverse proxy
|{\f1\fs20 useHttpAsync}|Event-driven async|{\b Best scaling}
|{\f1\fs20 useBidirSocket}|WebSockets + threads|Callbacks (small scale)
|{\f1\fs20 useBidirAsync}|WebSockets + async|{\b Callbacks at scale}
|%
{}
!// Production server (async, best performance)
!HttpServer := TRestHttpServer.Create('8080', [Server], '+', useHttpAsync);
!
!// WebSocket support
!HttpServer := TRestHttpServer.Create('8080', [Server], '+', useBidirAsync);
{}
:  HTTPS / SSL
{}
!// Enable TLS (Port, Servers, Domain, Use, ThreadPoolCount, Security)
!HttpServer := TRestHttpServer.Create('443', [Server], '+',
!  useHttpAsync, 32, secTLS);
!
!// Self-signed certificate (development only)
!HttpServer := TRestHttpServer.Create('443', [Server], '+',
!  useHttpAsync, 32, secTLSSelfSigned);
{}
For http.sys, certificates must be registered:
$# Register certificate (Windows)
$netsh http add sslcert ipport=0.0.0.0:443 certhash=<thumbprint> appid={<guid>}
{}
:  Multiple REST Servers
{}
One HTTP server can host multiple REST servers:
{}
!var
!  ApiServer, AdminServer: TRestServerDB;
!begin
!  ApiServer := TRestServerDB.Create(ApiModel, 'api.db3');
!  ApiServer.Model.Root := 'api';
!
!  AdminServer := TRestServerDB.Create(AdminModel, 'admin.db3');
!  AdminServer.Model.Root := 'admin';
!
!  HttpServer := TRestHttpServer.Create('8080',
!    [ApiServer, AdminServer], '+', useHttpAsync);
!
!  // Access via:
!  // http://localhost:8080/api/...
!  // http://localhost:8080/admin/...
!end;
{}
:1105 Windows http.sys Server
{}
:  Why http.sys?
{}
Windows kernel-mode HTTP server provides:
{}
- {\b Kernel-mode queuing}: Lower context switching overhead
- {\b Stability}: Worker process failures don't drop requests
- {\b Performance}: Direct kernel-to-process routing
- {\b Embedded SSL}: Kernel-level @*HTTPS@ handling
- {\b URL sharing}: Multiple apps on same port
{}
:  URI Authorization
{}
http.sys requires URI registration (Administrator rights):
{}
!// Option 1: Auto-register (run as Admin once)
!HttpServer := TRestHttpServer.Create('8080', [Server], '+',
!  useHttpApiRegisteringURI);
!
!// Option 2: Manual registration
!THttpApiServer.AddUrlAuthorize('api', '8080', False, '+');
{}
{\b Manual registration via netsh:}
$# List registered URLs
$netsh http show urlacl
$
$# Add URL reservation
$netsh http add urlacl url=http://+:8080/api/ user=Everyone
$
$# Delete URL reservation
$netsh http delete urlacl url=http://+:8080/api/
{}
:  Firewall Configuration
{}
$# Open port in Windows Firewall
$netsh advfirewall firewall add rule name="mORMot Server" ^
$  dir=in action=allow protocol=TCP localport=8080
{}
:1106 Thread Safety
{}
:  Client Thread Safety
{}
{\f1\fs20 TRestClientUri} classes are thread-safe by design:
{}
!// Safe: URI() method is internally locked
!procedure TWorkerThread.Execute;
!begin
!  GlobalClient.Orm.Retrieve(ID, Record);  // Thread-safe
!end;
{}
:  Server Execution Modes
{}
!type
!  TRestServerAcquireMode = (
!    amUnlocked,          // No locking (read-only operations)
!    amLocked,            // Mutex protection (default for writes)
!    amBackgroundThread,  // Queue to background thread
!    amMainThread         // Queue to main thread (GUI)
!  );
!
!// Configure execution modes
!Server.AcquireWriteMode := amLocked;
!Server.AcquireExecutionMode[execSoaByInterface] := amLocked;
{}
:  Execution Contexts
{}
|%16%27%57
|\b Context|Default Mode|Description\b0
|{\f1\fs20 execOrmGet}|{\f1\fs20 amUnlocked}|ORM read operations
|{\f1\fs20 execOrmWrite}|{\f1\fs20 amLocked}|ORM write operations
|{\f1\fs20 execSoaByMethod}|{\f1\fs20 amUnlocked}|Method-based services
|{\f1\fs20 execSoaByInterface}|{\f1\fs20 amLocked}|Interface-based services
|%
{}
:1107 Connection Patterns
{}
:  Single Server, Multiple Protocols
{}
!var
!  Server: TRestServerDB;
!  HttpServer: TRestHttpServer;
!begin
!  Server := TRestServerDB.Create(Model, 'data.db3');
!
!  // HTTP access
!  HttpServer := TRestHttpServer.Create('8080', [Server]);
!
!  // Same server accessible via HTTP and in-process
!end;
{}
:  Load Balancer Setup
{}
$                    ┌─────────────────┐
$                    │  Load Balancer  │
$                    │   (nginx/HAProxy)│
$                    └────────┬────────┘
$           ┌─────────────────┼─────────────────┐
$           ▼                 ▼                 ▼
$    ┌─────────────┐   ┌─────────────┐   ┌─────────────┐
$    │ mORMot Srv 1│   │ mORMot Srv 2│   │ mORMot Srv 3│
$    └─────────────┘   └─────────────┘   └─────────────┘
$           │                 │                 │
$           └─────────────────┼─────────────────┘
$                             ▼
$                    ┌─────────────────┐
$                    │   Database      │
$                    │  (PostgreSQL)   │
$                    └─────────────────┘
{}
:  DMZ Architecture
{}
!       Internet
$           │
$   ┌───────┴───────┐
$   │     DMZ       │  TRestServerRemoteDB (services only)
$   │  ┌─────────┐  │
$   │  │ Proxy   │  │
$   │  │ Server  │  │
$   │  └────┬────┘  │
$   └───────┼───────┘
$           │ (Internal network)
$   ┌───────┴───────┐
$   │   Internal    │  TRestServerDB (full ORM + services)
$   │  ┌─────────┐  │
$   │  │  Main   │  │
$   │  │ Server  │  │
$   │  └─────────┘  │
$   └───────────────┘
{}
:1108 Proper Shutdown
{}
:  Shutdown Order
{}
!// CORRECT shutdown order
!FreeAndNil(HttpServer);  // 1. Stop accepting connections
!FreeAndNil(Server);      // 2. Free REST server
!FreeAndNil(Model);       // 3. Free model last
!
!// WRONG - will cause access violations
!FreeAndNil(Model);       // Model freed while Server uses it!
!FreeAndNil(Server);
!FreeAndNil(HttpServer);
{}
:  Graceful Shutdown
{}
!procedure GracefulShutdown;
!begin
!  // Signal shutdown
!  HttpServer.Shutdown;
!
!  // Wait for pending requests (with timeout)
!  Sleep(1000);
!
!  // Free resources
!  FreeAndNil(HttpServer);
!  FreeAndNil(Server);
!  FreeAndNil(Model);
!end;
{}
:1109 Migration from mORMot 1
{}
:  Class Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 TSQLRest}|{\f1\fs20 TRest}
|{\f1\fs20 TSQLRestServer}|{\f1\fs20 TRestServer}
|{\f1\fs20 TSQLRestServerDB}|{\f1\fs20 TRestServerDB}
|{\f1\fs20 TSQLRestServerFullMemory}|{\f1\fs20 TRestServerFullMemory}
|{\f1\fs20 TSQLRestClient}|{\f1\fs20 TRestClient}
|{\f1\fs20 TSQLRestClientDB}|{\f1\fs20 TRestClientDB}
|{\f1\fs20 TSQLHttpServer}|{\f1\fs20 TRestHttpServer}
|{\f1\fs20 TSQLHttpClient*}|{\f1\fs20 TRestHttpClient*}
|%
{}
:  Unit Renames
{}
|%50%50
|\b mORMot 1|mORMot 2\b0
|{\f1\fs20 mORMot.pas}|@!src\rest\mormot.rest.core.pas@ + @!src\orm\mormot.orm.core.pas@
|{\f1\fs20 mORMotSQLite3.pas}|{\f1\fs20 mormot.rest.sqlite3}
|{\f1\fs20 mORMotHttpServer.pas}|@!src\rest\mormot.rest.http.server.pas@
|{\f1\fs20 mORMotHttpClient.pas}|@!src\rest\mormot.rest.http.client.pas@
|%
{}
:  API Changes
{}
!// mORMot 1: Direct ORM access on TRest
!Server.Add(Customer, True);
!
!// mORMot 2: Via Orm interface
!Server.Orm.Add(Customer, True);
{}
{\i Next Chapter: Client-Server ORM Operations}
{}

; === mORMot2-SAD-Chapter-12.md ===
; Converted from Markdown - Chapter 12
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:12Client-Server ORM Operations
{}
{\i Remote Data Access}
{}
This chapter covers how to perform @*ORM@ operations over the network, including remote @*CRUD@, caching, batch operations, and synchronization.
{}
:1201 Remote ORM Basics
{}
:  Transparent Remote Access
{}
The ORM works identically whether local or remote:
{}
!// Local (in-process)
!Client := TRestClientDB.Create(Model, nil, 'data.db3', TRestServerDB);
!
!// Remote (HTTP)
!Client := TRestHttpClientWinHTTP.Create('server', '8080', Model);
!
!// Same ORM API for both
!Client.Orm.Add(Customer, True);
!Client.Orm.Retrieve(123, Customer);
!Client.Orm.Update(Customer);
!Client.Orm.Delete(TOrmCustomer, 123);
{}
:  Authentication Required
{}
Remote ORM operations require authentication:
{}
!var
!  Client: TRestHttpClient;
!begin
!  Client := TRestHttpClientWinHTTP.Create('localhost', '8080', Model);
!  try
!    // Must authenticate first
!    if not Client.SetUser('username', 'password') then
!      raise Exception.Create('Authentication failed');
!
!    // Now ORM operations work
!    Client.Orm.Add(Customer, True);
!  finally
!    Client.Free;
!  end;
!end;
{}
:1202 CRUD Operations Over Network
{}
:  Create (Add)
{}
!var
!  Customer: TOrmCustomer;
!  ID: TID;
!begin
!  Customer := TOrmCustomer.Create;
!  try
!    Customer.Name := 'ACME Corp';
!    Customer.Email := 'contact@acme.com';
!
!    // Remote add - returns new ID
!    ID := Client.Orm.Add(Customer, True);
!
!    if ID > 0 then
!      WriteLn('Created customer #', ID)
!    else
!      WriteLn('Failed to create customer');
!  finally
!    Customer.Free;
!  end;
!end;
{}
:  Read (Retrieve)
{}
!var
!  Customer: TOrmCustomer;
!begin
!  // By ID
!  Customer := TOrmCustomer.Create(Client.Orm, 123);
!  try
!    WriteLn(Customer.Name);
!  finally
!    Customer.Free;
!  end;
!
!  // Alternative: Retrieve into existing instance
!  Customer := TOrmCustomer.Create;
!  try
!    if Client.Orm.Retrieve(123, Customer) then
!      WriteLn(Customer.Name);
!  finally
!    Customer.Free;
!  end;
!
!  // By unique field
!  Customer := TOrmCustomer.Create;
!  try
!    if Client.Orm.Retrieve('Email = ?', [], ['contact@acme.com'], Customer) then
!      WriteLn(Customer.Name);
!  finally
!    Customer.Free;
!  end;
!end;
{}
:  Update
{}
!var
!  Customer: TOrmCustomer;
!begin
!  Customer := TOrmCustomer.Create(Client.Orm, 123);
!  try
!    Customer.Email := 'new@acme.com';
!
!    if Client.Orm.Update(Customer) then
!      WriteLn('Updated successfully');
!  finally
!    Customer.Free;
!  end;
!
!  // Update specific fields only
!  Customer := TOrmCustomer.Create;
!  try
!    Customer.ID := 123;
!    Customer.Email := 'updated@acme.com';
!
!    // Only update Email field
!    Client.Orm.Update(Customer, 'Email');
!  finally
!    Customer.Free;
!  end;
!end;
{}
:  Delete
{}
!// By ID
!Client.Orm.Delete(TOrmCustomer, 123);
!
!// By condition
!Client.Orm.Delete(TOrmCustomer, 'Status = ?', [Ord(csInactive)]);
{}
:1203 Query Operations
{}
:  FillPrepare Pattern
{}
Efficient iteration over remote results:
{}
!var
!  Customer: TOrmCustomer;
!begin
!  Customer := TOrmCustomer.CreateAndFillPrepare(Client.Orm,
!    'Country = ?', ['USA']);
!  try
!    while Customer.FillOne do
!      WriteLn(Customer.Name, ': ', Customer.Email);
!  finally
!    Customer.Free;
!  end;
!end;
{}
:  Select Specific Fields
{}
Reduce network traffic by requesting only needed fields:
{}
!// Only transfer Name and Email fields
!Customer := TOrmCustomer.CreateAndFillPrepare(Client.Orm,
!  'Country = ?', ['USA'],
!  'Name,Email');  // Fields to retrieve
{}
:  RetrieveList
{}
Get results as object list:
{}
!var
!  List: TObjectList<TOrmCustomer>;
!  Customer: TOrmCustomer;
!begin
!  List := Client.Orm.RetrieveList<TOrmCustomer>(
!    'Country = ?', ['USA']);
!  try
!    for Customer in List do
!      WriteLn(Customer.Name);
!  finally
!    List.Free;
!  end;
!end;
{}
:  Direct JSON Results
{}
!var
!  Json: RawUtf8;
!begin
!  // Get results directly as JSON array
!  Json := Client.Orm.RetrieveListJson(TOrmCustomer,
!    'Country = ?', ['USA'], 'Name,Email');
!  // Result: [{"Name":"ACME","Email":"..."},...]
!end;
{}
:1204 Client-Side Caching
{}
:  Enable Table Caching
{}
!// Cache specific tables on client
!Client.Cache.SetCache(TOrmCustomer);   // Cache all customers
!Client.Cache.SetCache(TOrmProduct);    // Cache all products
!
!// With timeout (milliseconds)
!Client.Cache.SetTimeOut(TOrmCustomer, 60000);  // 1 minute cache
{}
:  How Caching Works
{}
$┌─────────────────────────────────────────────────────────────┐
$│  Client.Orm.Retrieve(123, Customer)                         │
$└─────────────────────────────────────────────────────────────┘
$                            │
$                            ▼
$                  ┌─────────────────┐
$                  │ Check Cache     │
$                  └────────┬────────┘
$                           │
$            ┌──────────────┴──────────────┐
$            │                             │
$            ▼                             ▼
$    ┌───────────────┐            ┌───────────────┐
$    │ Cache Hit     │            │ Cache Miss    │
$    │ Return cached │            │ Fetch from    │
$    │ data          │            │ server        │
$    └───────────────┘            └───────┬───────┘
$                                         │
$                                         ▼
$                                 ┌───────────────┐
$                                 │ Update cache  │
$                                 │ Return data   │
$                                 └───────────────┘
{}
:  Cache Invalidation
{}
!// Clear specific record from cache
!Client.Cache.NotifyDeletion(TOrmCustomer, 123);
!
!// Reset table cache (re-enable caching, which clears existing entries)
!Client.Cache.SetCache(TOrmCustomer);
!
!// Clear all caches and reset settings
!Client.Cache.Clear;
{}
:  Server-Side Cache Notification
{}
The server can track changes via {\f1\fs20 TRestOrmServer.OnUpdateEvent}:
{}
!type
!  TMyServer = class
!    function HandleUpdate(Sender: TRestServer; Event: TOrmEvent;
!      aTable: TOrmClass; const aID: TID;
!      const aSentData: RawUtf8): boolean;
!  end;
!
!// Server-side: Enable change notifications
!// OnUpdateEvent requires a method of object (not anonymous procedure)
!(Server.OrmInstance as TRestOrmServer).OnUpdateEvent := MyServer.HandleUpdate;
{}
:1205 Batch Operations
{}
:  TRestBatch for Bulk Operations
{}
Dramatically improve performance for bulk operations:
{}
!uses
!  mormot.orm.core;
!
!var
!  Batch: TRestBatch;
!  Customer: TOrmCustomer;
!  Results: TIDDynArray;
!  i: Integer;
!begin
!  Batch := TRestBatch.Create(Client.Orm, TOrmCustomer, 1000);
!  try
!    for i := 1 to 10000 do
!    begin
!      Customer := TOrmCustomer.Create;
!      Customer.Name := FormatUtf8('Customer %', [i]);
!      Customer.Email := FormatUtf8('cust%@example.com', [i]);
!      Batch.Add(Customer, True);  // Batch owns Customer
!    end;
!
!    // Single network roundtrip for all 10000 records
!    if Client.Orm.BatchSend(Batch, Results) = HTTP_SUCCESS then
!      WriteLn('Inserted ', Length(Results), ' records');
!  finally
!    Batch.Free;
!  end;
!end;
{}
:  Performance Comparison
{}
|%47%19%13%21
|\b Operation|Individual|Batch|Improvement\b0
|10,000 inserts (local)|10 sec|0.1 sec|100x
|10,000 inserts (network)|100 sec|1 sec|100x
|10,000 updates|15 sec|0.2 sec|75x
|%
{}
:  Batch Updates and Deletes
{}
!var
!  Batch: TRestBatch;
!  Customer: TOrmCustomer;
!begin
!  Batch := TRestBatch.Create(Client.Orm, TOrmCustomer);
!  try
!    // Mix operations in single batch
!    Customer := TOrmCustomer.Create;
!    Customer.Name := 'New Customer';
!    Batch.Add(Customer, True);
!
!    Customer := TOrmCustomer.Create(Client.Orm, 123);
!    Customer.Status := csActive;
!    Batch.Update(Customer);
!
!    Batch.Delete(TOrmCustomer, 456);
!
!    Client.Orm.BatchSend(Batch);
!  finally
!    Batch.Free;
!  end;
!end;
{}
:  Automatic Batching
{}
For transparent batching:
{}
!var
!  Results: TIDDynArray;
!begin
!  // Start automatic batching
!  Client.BatchStart(TOrmCustomer, 1000);
!  try
!    for i := 1 to 10000 do
!    begin
!      Customer := TOrmCustomer.Create;
!      Customer.Name := FormatUtf8('Customer %', [i]);
!      Client.Orm.Add(Customer, True);  // Automatically batched
!      Customer.Free;
!    end;
!  finally
!    Client.BatchSend(Results);  // Send remaining batch
!  end;
!end;
{}
:1206 BLOB Handling
{}
:  BLOB Fields
{}
@*BLOB@s are not included in normal record transfers:
{}
!type
!  TOrmDocument = class(TOrm)
!  private
!    fName: RawUtf8;
!    fContent: RawBlob;  // Not transferred with other fields
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Content: RawBlob read fContent write fContent;
!  end;
{}
:  Upload BLOB
{}
!var
!  Doc: TOrmDocument;
!  Data: RawBlob;
!begin
!  Doc := TOrmDocument.Create;
!  try
!    Doc.Name := 'report.pdf';
!    Client.Orm.Add(Doc, True);
!
!    // Upload BLOB separately
!    Data := StringFromFile('report.pdf');
!    Client.Orm.UpdateBlob(TOrmDocument, Doc.ID, 'Content', Data);
!  finally
!    Doc.Free;
!  end;
!end;
{}
:  Download BLOB
{}
!var
!  Data: RawBlob;
!begin
!  if Client.Orm.RetrieveBlob(TOrmDocument, DocID, 'Content', Data) then
!    FileFromString(Data, 'downloaded.pdf');
!end;
{}
:  Streaming BLOBs
{}
For large files, use streaming:
{}
!var
!  Stream: TStream;
!begin
!  Stream := TFileStream.Create('large_file.zip', fmCreate);
!  try
!    Client.Orm.RetrieveBlobStream(TOrmDocument, DocID, 'Content', Stream);
!  finally
!    Stream.Free;
!  end;
!end;
{}
:1207 Locking and Concurrency
{}
:  Optimistic Locking
{}
Default behavior - last write wins:
{}
!// Two clients modify same record
!Client1.Orm.Retrieve(123, Customer1);
!Client2.Orm.Retrieve(123, Customer2);
!
!Customer1.Email := 'client1@example.com';
!Customer2.Email := 'client2@example.com';
!
!Client1.Orm.Update(Customer1);  // Succeeds
!Client2.Orm.Update(Customer2);  // Overwrites Client1's change
{}
:  TRecordVersion for Change Tracking
{}
!type
!  TOrmCustomer = class(TOrm)
!  private
!    fName: RawUtf8;
!    fVersion: TRecordVersion;  // Auto-incremented on changes
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Version: TRecordVersion read fVersion write fVersion;
!  end;
!
!// Server automatically increments Version on each update
{}
:  Conflict Detection
{}
!var
!  Customer: TOrmCustomer;
!  OriginalVersion: TRecordVersion;
!  CurrentVersion: Int64;
!begin
!  Customer := TOrmCustomer.Create(Client.Orm, 123);
!  try
!    OriginalVersion := Customer.Version;
!
!    // Make changes
!    Customer.Name := 'Updated Name';
!
!    // Re-fetch to check version using OneFieldValueInt64
!!    // Note: takes WhereClause as RawUtf8, not array of const
!    CurrentVersion := Client.Orm.OneFieldValueInt64(TOrmCustomer,
!      'Version', FormatUtf8('ID = %', [Customer.ID]));
!    if CurrentVersion <> Int64(OriginalVersion) then
!      raise Exception.Create('Record modified by another user');
!
!    Client.Orm.Update(Customer);
!  finally
!    Customer.Free;
!  end;
!end;
{}
:1208 Synchronization
{}
:  Master-Slave Replication
{}
!// On slave: Track changes from master
!var
!  MasterClient: TRestHttpClient;
!  SlaveServer: TRestServerDB;
!begin
!  MasterClient := TRestHttpClientWinHTTP.Create('master', '8080', Model);
!  SlaveServer := TRestServerDB.Create(Model, 'slave.db3');
!
!  // Sync tables
!  SlaveServer.RecordVersionSynchronizeSlave(
!    TOrmCustomer, MasterClient.Orm, 1000);  // Check every second
!end;
{}
:  Change Tracking
{}
mORMot2 provides {\f1\fs20 TOrmHistory} in @!src\orm\mormot.orm.core.pas@ for tracking record changes:
{}
!// TOrmHistory is defined in mormot.orm.core with fields for:
!// - ModifiedRecord: TID (reference to modified record)
!// - Event: TOrmHistoryEvent
!// - SentDataJson: RawBlob
!// - Timestamp: TModTime
!
!// Server tracks all changes via TRestOrmServer
!var
!  OrmServer: TRestOrmServer;
!begin
!  OrmServer := Server.OrmInstance as TRestOrmServer;
!  OrmServer.TrackChanges([TOrmCustomer, TOrmOrder]);
!end;
{}
:1209 Error Handling
{}
:  Check Return Values
{}
!var
!  ID: TID;
!begin
!  ID := Client.Orm.Add(Customer, True);
!  if ID = 0 then
!  begin
!    // Check last error
!    WriteLn('Error: ', Client.LastErrorMessage);
!    WriteLn('Code: ', Client.LastErrorCode);
!  end;
!end;
{}
:  HTTP Status Codes
{}
|%12%38%50
|\b Code|Meaning|mORMot Constant\b0
|200|Success|{\f1\fs20 @*HTTP@_SUCCESS}
|201|Created|{\f1\fs20 HTTP_CREATED}
|400|Bad Request|{\f1\fs20 HTTP_BADREQUEST}
|401|Unauthorized|{\f1\fs20 HTTP_UNAUTHORIZED}
|403|Forbidden|{\f1\fs20 HTTP_FORBIDDEN}
|404|Not Found|{\f1\fs20 HTTP_NOTFOUND}
|500|Server Error|{\f1\fs20 HTTP_SERVERERROR}
|%
{}
:  Connection Resilience
{}
!// Auto-reconnect on connection loss
!Client.RetryOnceOnTimeout := True;
!
!// Custom retry logic
!for Attempt := 1 to 3 do
!begin
!  if Client.Orm.Retrieve(ID, Customer) then
!    Break;
!  if Attempt = 3 then
!    raise Exception.Create('Failed after 3 attempts');
!  Sleep(1000 * Attempt);  // Exponential backoff
!end;
{}
:1210 Migration from mORMot 1
{}
:  ORM Access Pattern
{}
!// mORMot 1: Direct on TRest
!Client.Add(Customer, True);
!Client.Retrieve(123, Customer);
!
!// mORMot 2: Via Orm interface
!Client.Orm.Add(Customer, True);
!Client.Orm.Retrieve(123, Customer);
{}
:  Batch Changes
{}
!// mORMot 1
!Client.BatchStart(TOrmCustomer);
!Client.BatchAdd(Customer);
!Client.BatchSend;
!
!// mORMot 2
!Batch := TRestBatch.Create(Client.Orm, TOrmCustomer);
!Batch.Add(Customer, True);
!Client.Orm.BatchSend(Batch);
{}
{\i Next Chapter: Server-Side ORM Processing}
{}

; === mORMot2-SAD-Chapter-13.md ===
; Converted from Markdown - Chapter 13
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:13Server-Side ORM Processing
{}
{\i Behind the Scenes}
{}
This chapter explores how the server processes @*ORM@ requests, including URI routing, SQL generation, virtual tables, and server-side customization.
{}
:1301 Request Processing Flow
{}
:  URI to SQL Pipeline
{}
$┌─────────────────────────────────────────────────────────────────┐
$│  Client Request: GET /api/Customer/123                          │
$└─────────────────────────────────────────────────────────────────┘
$                              │
$                              ▼
$┌─────────────────────────────────────────────────────────────────┐
$│  1. HTTP Server receives request                                │
$│     TRestHttpServer.Request()                                   │
$└─────────────────────────────────────────────────────────────────┘
$                              │
$                              ▼
$┌─────────────────────────────────────────────────────────────────┐
$│  2. Router matches URI pattern                                  │
$│     TRestRouter → /api/Customer/123 → rnTableID                 │
$└─────────────────────────────────────────────────────────────────┘
$                              │
$                              ▼
$┌─────────────────────────────────────────────────────────────────┐
$│  3. Authentication check                                        │
$│     TRestServer.SessionGetUser()                                │
$└─────────────────────────────────────────────────────────────────┘
$                              │
$                              ▼
$┌─────────────────────────────────────────────────────────────────┐
$│  4. ORM processes request                                       │
$│     IRestOrm.Retrieve() → SQL: SELECT * FROM Customer WHERE ID=1│
$└─────────────────────────────────────────────────────────────────┘
$                              │
$                              ▼
$┌─────────────────────────────────────────────────────────────────┐
$│  5. Response as JSON                                            │
$│     {"ID":123,"Name":"ACME","Email":"..."}                      │
$└─────────────────────────────────────────────────────────────────┘
{}
:  Router Node Types
{}
|%10%27%63
|\b Node|URI Pattern|HTTP Methods\b0
|{\f1\fs20 rnTable}|{\f1\fs20 /root/TableName}|GET (list), POST (create)
|{\f1\fs20 rnTableID}|{\f1\fs20 /root/TableName/<id>}|GET, PUT, DELETE
|{\f1\fs20 rnTableIDBlob}|{\f1\fs20 /root/TableName/<id>/BlobField}|GET, PUT
|{\f1\fs20 rnTableMethod}|{\f1\fs20 /root/TableName/<method>}|GET, POST
|{\f1\fs20 rnMethod}|{\f1\fs20 /root/<method>}|GET, POST
|{\f1\fs20 rnInterface}|{\f1\fs20 /root/Interface.Method}|POST
|%
{}
:1302 SQL Generation
{}
:  Automatic SQL from URI
{}
The ORM translates @*REST@ requests to SQL:
{}
!GET /api/Customer
!→ SELECT ID, Name, Email, ... FROM Customer
!
!GET /api/Customer/123
!→ SELECT ID, Name, Email, ... FROM Customer WHERE ID=123
!
!GET /api/Customer?where=Country%3D%27USA%27
!→ SELECT ID, Name, Email, ... FROM Customer WHERE Country='USA'
!
!POST /api/Customer (body: {"Name":"ACME"})
!→ INSERT INTO Customer (Name) VALUES ('ACME')
!
!PUT /api/Customer/123 (body: {"Name":"Updated"})
!→ UPDATE Customer SET Name='Updated' WHERE ID=123
!
!DELETE /api/Customer/123
!→ DELETE FROM Customer WHERE ID=123
{}
:  Query Parameters
{}
|%28%51%21
|\b Parameter|Description|Example\b0
|{\f1\fs20 where}|WHERE clause|{\f1\fs20 ?where=Country='USA'}
|{\f1\fs20 select}|Fields to return|{\f1\fs20 ?select=Name,Email}
|{\f1\fs20 limit}|Max results|{\f1\fs20 ?limit=100}
|{\f1\fs20 offset}|Skip results|{\f1\fs20 ?offset=50}
|{\f1\fs20 order}|ORDER BY|{\f1\fs20 ?order=Name}
|%
{}
:  Inlined JSON Parameters
{}
Parameters can be embedded in WHERE clause:
{}
!// Client sends
!'Name = :("John"):AND Age > :(30):'
!
!// Server extracts and binds
!SQL: 'SELECT ... WHERE Name = ? AND Age > ?'
!Params: ['John', 30]
{}
:1303 Virtual Tables
{}
:  Storage Backends
{}
The ORM can mix multiple storage backends:
{}
!Model := TOrmModel.Create([
!  TOrmUser,      // Internal SQLite3
!  TOrmProduct,   // External PostgreSQL
!  TOrmLog,       // MongoDB
!  TOrmCache      // In-memory
!]);
!
!// Map to different backends
!OrmMapExternal(Model, TOrmProduct, PostgresProps);
!OrmMapMongoDB(Model, TOrmLog, MongoClient.Database['logs']);
!Model.Props[TOrmCache].SetStorage(TRestStorageInMemory);
{}
:  How Virtual Tables Work
{}
$┌─────────────────────────────────────────────────────────────────┐
$│                      SQLite3 Core                     │
$│  SELECT * FROM Product, User WHERE Product.UserID = Us│
$└─────────────────────────────────────────────────────────────────┘
$        │                                    │
$        │ Virtual Table                      │ Native Table
$        ▼                                    ▼
$┌───────────────────┐               ┌───────────────────┐
$│   PostgreSQL      │               │   SQLite3 File    │
$│   (Product)       │               │   (User)          │
$└───────────────────┘               └───────────────────┘
{}
:  Cross-Database JOINs
{}
!// This works even with mixed backends!
!Server.Orm.ExecuteList([TOrmProduct, TOrmUser],
!  'SELECT Product.Name, User.Email ' +
!  'FROM Product, User ' +
!  'WHERE Product.UserID = User.ID');
{}
:1304 Server-Side Events
{}
:  OnBefore* Events
{}
Execute before ORM operations:
{}
!type
!  TMyServer = class(TRestServerDB)
!  protected
!    function OnBeforeAdd(Table: TOrmClass; const Rec: TOrm): Boolean; override;
!  end;
!
!function TMyServer.OnBeforeAdd(Table: TOrmClass; const Rec: TOrm): Boolean;
!begin
!  // Validate before insert
!  if Table = TOrmCustomer then
!    if TOrmCustomer(Rec).Email = '' then
!    begin
!      Result := False;  // Reject insert
!      Exit;
!    end;
!  Result := True;  // Allow insert
!end;
{}
:  OnAfter* Events
{}
Execute after ORM operations:
{}
!procedure TMyServer.OnAfterDelete(Table: TOrmClass; const aID: TID);
!begin
!  // Audit trail
!  LogEvent(Format('Deleted %s #%d', [Table.ClassName, aID]));
!
!  // Cascade operations
!  if Table = TOrmCustomer then
!    Orm.Delete(TOrmOrder, 'CustomerID = ?', [aID]);
!end;
{}
:  Event Signatures
{}
|%17%32%51
|\b Event|Signature|Return\b0
|{\f1\fs20 OnBeforeAdd}|{\f1\fs20 (Table, Rec): Boolean}|False = reject
|{\f1\fs20 OnAfterAdd}|{\f1\fs20 (Table, aID)}|-
|{\f1\fs20 OnBeforeUpdate}|{\f1\fs20 (Table, Rec): Boolean}|False = reject
|{\f1\fs20 OnAfterUpdate}|{\f1\fs20 (Table, Rec)}|-
|{\f1\fs20 OnBeforeDelete}|{\f1\fs20 (Table, aID): Boolean}|False = reject
|{\f1\fs20 OnAfterDelete}|{\f1\fs20 (Table, aID)}|-
|%
{}
:  TOrm Event Methods
{}
Override in {\f1\fs20 @**TOrm@} class for record-level events:
{}
!type
!  TOrmCustomer = class(TOrm)
!  protected
!    procedure ComputeFieldsBeforeWrite(const aRest: IRestOrm;
!      aOccasion: TOrmEvent; aServerTimeStamp: TTimeLog = 0); override;
!  end;
!
!procedure TOrmCustomer.ComputeFieldsBeforeWrite(const aRest: IRestOrm;
!  aOccasion: TOrmEvent; aServerTimeStamp: TTimeLog);
!begin
!  inherited;
!  // Auto-compute fields before save
!  if aOccasion in [oeAdd, oeUpdate] then
!    fSearchText := LowerCase(fName + ' ' + fEmail);
!end;
{}
:1305 Server-Side Filtering
{}
:  Access Control per Table
{}
!// Restrict access to specific tables
!Server.OnCanExecute := function(Sender: TRest; Context: TRestServerUriContext;
!  Table: TOrmClass; const TableID: TID): Boolean
!begin
!  // Only admins can access TOrmSettings
!  if Table = TOrmSettings then
!    Result := Context.Session.User.GroupRights.HasRight(arAdmin)
!  else
!    Result := True;
!end;
{}
:  Field-Level Security
{}
!type
!  TOrmUser = class(TOrm)
!  private
!    fName: RawUtf8;
!    fPassword: RawUtf8;
!!    fInternalNote: RawUtf8;  // Never expose to clients
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Password: RawUtf8 read fPassword write fPassword;
!!    property InternalNote: RawUtf8 read fInternalNote write fInternalNote
!      stored False;  // Not transmitted over REST
!  end;
{}
:  Dynamic WHERE Injection
{}
Force additional conditions on all queries:
{}
!// All Customer queries filtered by tenant
!Server.OnBeforeUriExecute := procedure(Sender: TRest; var SqlWhere: RawUtf8;
!  Table: TOrmClass)
!begin
!  if Table = TOrmCustomer then
!  begin
!    if SqlWhere <> '' then
!      SqlWhere := SqlWhere + ' AND ';
!    SqlWhere := SqlWhere + FormatUtf8('TenantID = %', [CurrentTenantID]);
!  end;
!end;
{}
:1306 Server-Side Caching
{}
:  Enable Table Caching
{}
!// Cache entire table in memory
!Server.Cache.SetCache(TOrmProduct);
!
!// Cache with timeout
!Server.Cache.SetTimeOut(TOrmProduct, 300000);  // 5 minutes
!
!// Cache frequently accessed records
!Server.Cache.SetCache(TOrmSettings, True);  // Force all records cached
{}
:  Cache Statistics
{}
!WriteLn('Cache hits: ', Server.Cache.CacheHits);
!WriteLn('Cache misses: ', Server.Cache.CacheMisses);
!WriteLn('Hit ratio: ', Server.Cache.CacheHits /
!  (Server.Cache.CacheHits + Server.Cache.CacheMisses) * 100:0:1, '%');
{}
:  Manual Cache Invalidation
{}
!// Clear specific record
!Server.Cache.NotifyDeletion(TOrmProduct, ProductID);
!
!// Clear entire table
!Server.Cache.Clear(TOrmProduct);
!
!// Clear all caches
!Server.Cache.Clear;
{}
:1307 Write Modes
{}
:  Direct vs Batch Mode
{}
!// Direct mode (default): Each write goes to database immediately
!Server.Orm.Add(Customer, True);  // INSERT executed now
!
!// Batch mode on server: Use TRestBatch directly
!var
!  Batch: TRestBatch;
!  Results: TIDDynArray;
!begin
!  Batch := TRestBatch.Create(Server.Orm, TOrmCustomer);
!  try
!    Batch.Add(Customer1, True);  // Queued
!    Batch.Add(Customer2, True);  // Queued
!    Server.Orm.BatchSend(Batch, Results);  // All INSERTs now
!  finally
!    Batch.Free;
!  end;
!end;
{}
{\b Note}: {\f1\fs20 BatchStart}/{\f1\fs20 BatchSend} methods without parameters are on {\f1\fs20 TRestClientUri}. Server-side code should use {\f1\fs20 TRestBatch} directly.
{}
:  Transaction Handling
{}
!const
!  SESSION_ID = 1;  // Current session ID
!begin
!  // Automatic transactions per batch
!  Server.TransactionBegin(TOrmCustomer, SESSION_ID);
!  try
!    Server.Orm.Add(Customer1, True);
!    Server.Orm.Add(Customer2, True);
!    Server.Commit(SESSION_ID, True);  // RaiseException=True
!  except
!    Server.RollBack(SESSION_ID);
!    raise;
!  end;
!end;
{}
{\b Note}: Transaction methods require a {\f1\fs20 SessionID} parameter on the server.
{}
:  Write Acknowledgment
{}
!// Control write confirmation
!Server.AcquireWriteMode := amLocked;       // Wait for write completion
!Server.AcquireWriteMode := amUnlocked;     // Fire and forget (faster)
!Server.AcquireWriteMode := amBackgroundThread;  // Queue to background
{}
:1308 Static Storage
{}
:  In-Memory Tables
{}
!uses
!  mormot.orm.storage;
!
!// Register before server creation
!Model.Props[TOrmCache].SetStorage(TRestStorageInMemory);
!
!// Or add after server creation
!Storage := TRestStorageInMemory.Create(TOrmCache, Server);
!Server.StaticDataAdd(Storage);
{}
:  Persistence Options
{}
!// JSON persistence
!Storage := TRestStorageInMemory.Create(TOrmCache, Server);
!Storage.FileName := 'cache.json';
!
!// Binary persistence (faster, smaller)
!Storage.BinaryFile := True;
!Storage.FileName := 'cache.data';
!
!// Manual save/load
!Storage.SaveToFile('backup.json');
!Storage.LoadFromFile('backup.json');
{}
:  Static vs Virtual
{}
|%23%28%49
|\b Feature|Static|Virtual\b0
|SQL JOINs|No|Yes
|Speed|Faster|Slightly slower
|Memory|Dedicated|Shared with @*SQLite3@
|Use case|Simple @*CRUD@|Complex queries
|%
{}
:1309 Performance Monitoring
{}
:  Server Statistics
{}
!// Enable monitoring
!Server.CreateMissingTables;
!
!// Access statistics
!WriteLn('Total requests: ', Server.Stats.TotalRequestCount);
!WriteLn('Success: ', Server.Stats.SuccessRequestCount);
!WriteLn('Errors: ', Server.Stats.ErrorRequestCount);
!WriteLn('Avg response time: ', Server.Stats.AverageResponseTime, ' ms');
{}
:  Per-Table Statistics
{}
!for i := 0 to Server.Model.TablesMax do
!begin
!  Stats := Server.Stats[i];
!  if Stats <> nil then
!    WriteLn(Server.Model.Tables[i].SqlTableName, ': ',
!      Stats.SelectCount, ' reads, ', Stats.InsertCount, ' inserts');
!end;
{}
:  SQL Execution Logging
{}
!// Enable SQL logging
!TSynLog.Add.Level := [sllSQL, sllDB];
!
!// Or specific callback
!Server.OnSqlExecute := procedure(const SQL: RawUtf8; const TimeMS: Int64)
!begin
!  if TimeMS > 100 then  // Log slow queries
!    WriteLn('SLOW QUERY (', TimeMS, 'ms): ', SQL);
!end;
{}
:1310 Custom ORM Extensions
{}
:  Custom SQL Functions
{}
!// Register custom SQLite3 function
!Server.DB.RegisterSQLFunction(
!  procedure(Context: TSqlite3FunctionContext; argc: Integer;
!    var argv: TSqlite3ValueArray)
!  begin
!    // Custom function implementation
!    sqlite3.result_int64(Context, CalculateHash(argv[0]));
!  end,
!  'MYHASH', 1);
!
!// Use in queries
!Server.Orm.ExecuteList(TOrmCustomer,
!  'SELECT * FROM Customer WHERE MYHASH(Name) = ?', [HashValue]);
{}
:  Computed Fields
{}
!type
!  TOrmOrder = class(TOrm)
!  private
!    fQuantity: Integer;
!    fUnitPrice: Currency;
!    fTotal: Currency;
!  protected
!    procedure ComputeFieldsBeforeWrite(const aRest: IRestOrm;
!      aOccasion: TOrmEvent; aServerTimeStamp: TTimeLog = 0); override;
!  published
!    property Quantity: Integer read fQuantity write fQuantity;
!    property UnitPrice: Currency read fUnitPrice write fUnitPrice;
!    property Total: Currency read fTotal write fTotal stored False;  // Computed
!  end;
!
!procedure TOrmOrder.ComputeFieldsBeforeWrite(const aRest: IRestOrm;
!  aOccasion: TOrmEvent; aServerTimeStamp: TTimeLog);
!begin
!  inherited;
!  fTotal := fQuantity * fUnitPrice;
!end;
{}
:1311 Migration from mORMot 1
{}
:  ORM Access Change
{}
!// mORMot 1: Direct access
!Server.Add(Customer, True);
!Server.Retrieve(123, Customer);
!
!// mORMot 2: Via Orm property
!Server.Orm.Add(Customer, True);
!Server.Orm.Retrieve(123, Customer);
{}
:  Event Method Changes
{}
!// mORMot 1
!procedure TSQLRestServerDB.BeforeAdd;
!procedure TSQLRestServerDB.AfterAdd;
!
!// mORMot 2
!function TRestServerDB.OnBeforeAdd: Boolean;
!procedure TRestServerDB.OnAfterAdd;
{}
:  Static Storage Registration
{}
!// mORMot 1
!Server.StaticDataCreate(TOrmCache, '', False, True);
!
!// mORMot 2
!Model.Props[TOrmCache].SetStorage(TRestStorageInMemory);
{}
{\i Next Chapter: Method-Based Services}
{}

; === mORMot2-SAD-Chapter-14.md ===
; Converted from Markdown - Chapter 14
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:14Client-Server Services via Methods
{}
{\i The Quick and Powerful Way}
{}
To implement a service in the {\i Synopse m@*ORM@ot 2 framework}, the most direct approach is to define published methods on the server side, then use simple @*JSON@ or URL parameter handling to encode and decode requests on both ends.
{}
This chapter covers {\b method-based services} — a straightforward, low-level mechanism for exposing custom functionality over @*HTTP@. While mORMot 2 also provides interface-based services (covered in chapters 15-16) for more structured @*SOA@, method-based services offer maximum flexibility and control.
{}
:1401 Publishing a Service on the Server
{}
:  Basic Structure
{}
On the server side, we customize a {\f1\fs20 TRestServer} descendant (typically {\f1\fs20 TRestServerDB} with @*SQLite3@, or the lighter {\f1\fs20 TRestServerFullMemory}) by adding a new {\f1\fs20 published} method:
{}
!type
!  TRestServerTest = class(TRestServerFullMemory)
!  published
!    procedure Sum(Ctxt: TRestServerUriContext);
!  end;
{}
The method name ({\f1\fs20 Sum}) determines the URI routing — it will be accessible remotely from {\f1\fs20 ModelRoot/Sum}. The {\f1\fs20 ModelRoot} is the {\f1\fs20 Root} parameter defined when creating the model.
{}
:  Method Signature
{}
All server-side methods {\b MUST} follow the {\f1\fs20 TOnRestServerCallBack} prototype:
{}
!type
!  TOnRestServerCallBack = procedure(Ctxt: TRestServerUriContext) of object;
{}
The single {\f1\fs20 Ctxt} parameter provides full access to the execution context: incoming parameters, HTTP headers, session information, and output facilities.
{}
:  Implementation
{}
!procedure TRestServerTest.Sum(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.Results([Ctxt.InputDouble['a'] + Ctxt.InputDouble['b']]);
!end;
{}
The {\f1\fs20 Ctxt} object exposes typed properties for parameter retrieval:
{}
|%19%26%55
|\b Property|Return Type|Exception on Missing\b0
|{\f1\fs20 InputInt['name']}|{\f1\fs20 Int64}|Yes
|{\f1\fs20 InputDouble['name']}|{\f1\fs20 Double}|Yes
|{\f1\fs20 InputUtf8['name']}|{\f1\fs20 RawUtf8}|Yes
|{\f1\fs20 Input['name']}|{\f1\fs20 Variant}|Yes
|{\f1\fs20 InputIntOrVoid['name']}|{\f1\fs20 Int64}|No (returns 0)
|{\f1\fs20 InputDoubleOrVoid['name']}|{\f1\fs20 Double}|No (returns 0)
|{\f1\fs20 InputUtf8OrVoid['name']}|{\f1\fs20 RawUtf8}|No (returns '')
|{\f1\fs20 InputOrVoid['name']}|{\f1\fs20 Variant}|No (returns Unassigned)
|{\f1\fs20 InputExists['name']}|{\f1\fs20 Boolean}|N/A
|%
{}
The default {\f1\fs20 Input['name']} array property (via {\f1\fs20 variant}) allows the concise syntax {\f1\fs20 Ctxt['name']}.
{}
:  Response Format
{}
{\f1\fs20 Ctxt.Results([])} encodes values as a JSON object with a {\f1\fs20 "Result"} member:
{}
!GET /root/Sum?a=3.12&b=4.2
{}
Returns:
${"Result":7.32}
{}
This is perfectly AJAX-friendly and compatible with any HTTP client.
{}
:  Thread Safety
{}
{\b Important}: Method implementations {\b MUST be thread-safe}. The {\f1\fs20 TRestServer.Uri} method expects callbacks to handle thread safety internally. This design maximizes performance and scalability by allowing fine-grained resource locking.
{}
For read-only operations, no locking may be needed. For shared state modifications:
{}
!procedure TRestServerTest.UpdateCounter(Ctxt: TRestServerUriContext);
!begin
!  fCounterLock.Lock;
!  try
!    Inc(fCounter);
!    Ctxt.Results([fCounter]);
!  finally
!    fCounterLock.UnLock;
!  end;
!end;
{}
:1402 Defining the Client
{}
:  Basic Client Call
{}
The client uses dedicated methods to call services by name with parameters:
{}
!function Sum(aClient: TRestClientUri; a, b: Double): Double;
!var
!  err: Integer;
!begin
!  Val(aClient.CallBackGetResult('sum', ['a', a, 'b', b]), Result, err);
!end;
{}
:  Client Method Pattern
{}
A cleaner approach encapsulates service calls in a dedicated client class:
{}
!type
!  TMyClient = class(TRestHttpClientSocket)  // or TRestHttpClientWebSockets
!  public
!    function Sum(a, b: Double): Double;
!  end;
!
!function TMyClient.Sum(a, b: Double): Double;
!var
!  err: Integer;
!begin
!  Val(CallBackGetResult('sum', ['a', a, 'b', b]), Result, err);
!end;
{}
:  Client API Methods
{}
{\f1\fs20 TRestClientUri} provides several methods for service invocation:
{}
|%10%90
|\b Method|Purpose\b0
|{\f1\fs20 CallBackGetResult}|GET request, returns the JSON {\f1\fs20 "Result"} value as {\f1\fs20 RawUtf8}
|{\f1\fs20 CallBackGet}|GET request, returns full response with HTTP status
|{\f1\fs20 CallBackPut}|PUT request with body data
|{\f1\fs20 CallBack}|Generic request with any HTTP method
|%
{}
#### CallBackGet Signature
{}
!function CallBackGet(const aMethodName: RawUtf8;
!  const aNameValueParameters: array of const;
!  out aResponse: RawUtf8;
!  aTable: TOrmClass = nil;
!  aID: TID = 0;
!  aResponseHead: PRawUtf8 = nil): Integer;
{}
#### CallBackGetResult Signature
{}
!function CallBackGetResult(const aMethodName: RawUtf8;
!  const aNameValueParameters: array of const;
!  aTable: TOrmClass = nil;
!  aID: TID = 0): RawUtf8;
{}
:  Object Parameters
{}
Objects can be serialized to JSON automatically:
{}
!function TMyClient.ProcessPerson(Person: TPerson): RawUtf8;
!begin
!  Result := CallBackGetResult('processperson', ['person', ObjectToJson(Person)]);
!end;
{}
:1403 Direct Parameter Marshalling
{}
:  Low-Level Access
{}
For maximum performance, bypass the high-level {\f1\fs20 Input*[]} properties and parse {\f1\fs20 Ctxt.Parameters} directly:
{}
!procedure TRestServerTest.Sum(Ctxt: TRestServerUriContext);
!var
!  a, b: Double;
!begin
!  if UrlDecodeNeedParameters(Ctxt.Parameters, 'A,B') then
!  begin
!    while Ctxt.Parameters <> nil do
!    begin
!      UrlDecodeDouble(Ctxt.Parameters, 'A=', a);
!      UrlDecodeDouble(Ctxt.Parameters, 'B=', b, @Ctxt.Parameters);
!    end;
!    Ctxt.Results([a + b]);
!  end
!  else
!    Ctxt.Error('Missing Parameter');
!end;
{}
:  URL Decode Functions
{}
Available in @!src\core\mormot.core.text.pas@:
{}
|%20%80
|\b Function|Purpose\b0
|{\f1\fs20 UrlDecodeNeedParameters}|Verify required parameters exist
|{\f1\fs20 UrlDecodeInteger}|Extract integer parameter
|{\f1\fs20 UrlDecodeInt64}|Extract 64-bit integer
|{\f1\fs20 UrlDecodeDouble}|Extract floating-point
|{\f1\fs20 UrlDecodeValue}|Extract string value
|{\f1\fs20 UrlDecodeObject}|Deserialize JSON to object
|%
{}
:  JSON Body Access
{}
For POST/PUT requests, the body is available in {\f1\fs20 Ctxt.Call^.InBody}:
{}
!procedure TRestServerTest.ProcessData(Ctxt: TRestServerUriContext);
!var
!  doc: TDocVariantData;
!begin
!  if doc.InitJson(Ctxt.Call^.InBody, JSON_FAST) then
!  begin
!    // Process doc...
!    Ctxt.Success;
!  end
!  else
!    Ctxt.Error('Invalid JSON body');
!end;
{}
:1404 Returning Non-JSON Content
{}
:  Custom MIME Types
{}
Use {\f1\fs20 Ctxt.Returns()} to return any content type:
{}
!procedure TRestServer.Timestamp(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.Returns(Int64ToUtf8(ServerTimestamp), HTTP_SUCCESS, TEXT_CONTENT_TYPE_HEADER);
!end;
{}
:  Binary File Response
{}
!procedure TRestServer.GetFile(Ctxt: TRestServerUriContext);
!var
!  fileName: TFileName;
!  content: RawByteString;
!begin
!  fileName := 'c:\data\' + ExtractFileName(Utf8ToString(Ctxt.InputUtf8['filename']));
!  content := StringFromFile(fileName);
!  if content = '' then
!    Ctxt.Error('', HTTP_NOTFOUND)
!  else
!    Ctxt.Returns(content, HTTP_SUCCESS,
!      HEADER_CONTENT_TYPE + GetMimeContentType(pointer(content), Length(content), fileName));
!end;
{}
:  Client-Side Handling
{}
!function TMyClient.GetFile(const aFileName: RawUtf8): RawByteString;
!var
!  resp: RawUtf8;
!begin
!  if CallBackGet('GetFile', ['filename', aFileName], resp) <> HTTP_SUCCESS then
!    raise Exception.CreateFmt('Impossible to get file: %s', [resp]);
!  Result := RawByteString(resp);
!end;
{}
Note: For file serving, prefer {\f1\fs20 Ctxt.ReturnFile()} or {\f1\fs20 Ctxt.ReturnFileFromFolder()} (covered in section 14.7).
{}
:1405 Advanced Server-Side Processing
{}
:  RESTful URI with Table Context
{}
Methods can be linked to ORM tables via @*REST@ful URIs like {\f1\fs20 ModelRoot/TableName/TableID/MethodName}:
{}
!procedure TRestServerTest.DataAsHex(Ctxt: TRestServerUriContext);
!var
!  aData: RawBlob;
!begin
!  if (Self = nil) or (Ctxt.Table <> TOrmPeople) or (Ctxt.TableID <= 0) then
!    Ctxt.Error('Need a valid record and its ID')
!  else if (Ctxt.Server.Orm as TRestOrmServer).RetrieveBlob(
!      TOrmPeople, Ctxt.TableID, 'Data', aData) then
!    Ctxt.Results([BinToHex(aData)])
!  else
!    Ctxt.Error('Impossible to retrieve the Data BLOB field');
!end;
{}
Corresponding client call:
{}
!function TOrmPeople.DataAsHex(aClient: TRestClientUri): RawUtf8;
!begin
!  Result := aClient.CallBackGetResult('DataAsHex', [], TOrmPeople, ID);
!end;
{}
:  Context Properties
{}
The {\f1\fs20 TRestServerUriContext} exposes rich information:
{}
|%14%86
|\b Property|Description\b0
|{\f1\fs20 Table}|{\f1\fs20 TOrmClass} decoded from URI
|{\f1\fs20 TableIndex}|Index in Server.Model
|{\f1\fs20 TableID}|Record ID from URI
|{\f1\fs20 Session}|Session ID (0 = not started, 1 = auth disabled)
|{\f1\fs20 SessionUser}|Current user's {\f1\fs20 @**TID@}
|{\f1\fs20 SessionGroup}|Current group's {\f1\fs20 @TID@}
|{\f1\fs20 SessionUserName}|User's logon name
|{\f1\fs20 Method}|HTTP verb ({\f1\fs20 mGET}, {\f1\fs20 mPOST}, etc.)
|{\f1\fs20 Call^.InHead}|Raw incoming HTTP headers
|{\f1\fs20 Call^.InBody}|Raw request body
|{\f1\fs20 RemoteIP}|Client IP address
|{\f1\fs20 UserAgent}|Client user-agent string
|%
{}
:  Session and User Details
{}
!procedure TRestServerTest.WhoAmI(Ctxt: TRestServerUriContext);
!var
!  User: TAuthUser;
!begin
!  if Ctxt.Session = CONST_AUTHENTICATION_NOT_USED then
!    Ctxt.Returns(['message', 'Authentication not enabled'])
!  else if Ctxt.Session = CONST_AUTHENTICATION_SESSION_NOT_STARTED then
!    Ctxt.Returns(['message', 'Not authenticated'])
!  else
!  begin
!    User := Ctxt.Server.SessionGetUser(Ctxt.Session);
!    try
!      if User <> nil then
!        Ctxt.Returns(['user', User.LogonName, 'group', Ctxt.SessionGroup])
!      else
!        Ctxt.Error('Session not found', HTTP_FORBIDDEN);
!    finally
!      User.Free;
!    end;
!  end;
!end;
{}
:1406 Browser Speed-Up for Unmodified Requests
{}
:  HTTP 304 Not Modified
{}
The optional {\f1\fs20 Handle304NotModified} parameter enables browser caching:
{}
!procedure TRestServerTest.GetStaticData(Ctxt: TRestServerUriContext);
!var
!  data: RawUtf8;
!begin
!  data := GetCachedData; // Your cached data source
!  Ctxt.Returns(data, HTTP_SUCCESS, JSON_CONTENT_TYPE_HEADER, true); // Handle304NotModified=true
!end;
{}
When enabled:
- Response content is hashed using {\f1\fs20 crc32c} (with SSE4.2 hardware acceleration if available)
- If unchanged since the last request, returns {\f1\fs20 304 Not Modified} without body
- Significantly reduces bandwidth for periodic polling
{}
:  Caveats
{}
- {\b Authentication conflict}: RESTful authentication uses per-URI signatures that change frequently. Use {\f1\fs20 Server.ServiceMethodByPassAuthentication()} to disable authentication for cached methods.
- {\b Hash collisions}: While extremely rare with {\f1\fs20 crc32c}, false positives are theoretically possible. Don't use for sensitive accounting data.
{}
:  CDN Integration
{}
This stateless REST model enables multiple levels of caching:
- Browser cache
- Proxy servers
- Content Delivery Networks (CDN)
{}
Combined with proper HTTP headers, your mORMot server can scale to thousands of concurrent users worldwide.
{}
:1407 Returning File Content
{}
:  ReturnFile Method
{}
{\f1\fs20 Ctxt.ReturnFile()} efficiently serves files with automatic MIME type detection:
{}
!procedure TRestServerTest.DownloadReport(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.ReturnFile('c:\reports\' + Ctxt.InputUtf8['name'] + '.pdf', true);
!end;
{}
Features:
- Automatic MIME type from file extension
- Optional {\f1\fs20 Handle304NotModified} using file timestamp
- High-performance: HTTP.SYS (Windows) serves files asynchronously from kernel mode
{}
:  ReturnFileFromFolder Method
{}
Serves any file from a folder based on the URI path:
{}
!procedure TRestServerTest.StaticFiles(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.ReturnFileFromFolder('c:\www\static\', true, 'index.html', '/404.html');
!end;
{}
Parameters:
- {\f1\fs20 FolderName}: Base folder path
- {\f1\fs20 Handle304NotModified}: Enable browser caching
- {\f1\fs20 DefaultFileName}: Served for root requests (default: {\f1\fs20 'index.html'})
- {\f1\fs20 Error404Redirect}: Redirect URI for missing files
{}
This is ideal for serving static web content (HTML, CSS, JS, images) alongside your REST API.
{}
:1408 JSON Web Tokens (JWT)
{}
:  Overview
{}
JSON Web Tokens (@*JWT@) provide stateless authentication and secure information exchange. mORMot 2 implements JWT in @!src\crypt\mormot.crypt.jwt.pas@:
{}
{\b Supported Algorithms}:
|%22%78
|\b Algorithm|Description\b0
|{\f1\fs20 HS256/384/512}|HMAC-SHA2 (symmetric)
|{\f1\fs20 ES256}|ECDSA P-256 (asymmetric)
|{\f1\fs20 RS256/384/512}|RSA (asymmetric)
|{\f1\fs20 PS256/384/512}|RSA-PSS (asymmetric)
|{\f1\fs20 S3256/384/512}|SHA-3 (non-standard)
|{\f1\fs20 none}|No signature (use with caution)
|%
{}
{\b Features}:
- All standard JWT claims validated
- Thread-safe with optional caching
- Cross-platform (no external DLLs)
- Immune to algorithm confusion attacks
{}
:  Class Hierarchy
{}
!TJwtAbstract
$├── TJwtNone           (algorithm: "none")
$├── TJwtSynSignerAbstract
$│   ├── TJwtHS256/384/512   (HMAC-SHA2)
$│   └── TJwtS3256/384/512   (SHA-3)   │
$├── TJwtES256          (ECDSA P-256)
$├── TJwtRS256/384/512  (RSA)
$├── TJwtPS256/384/512  (RSA-PSS)
$└── TJwtCrypt          (factory-based, recommended)
{}
:  Verifying JWTs
{}
!uses
!  mormot.crypt.jwt;
!
!var
!  jwt: TJwtAbstract;
!  content: TJwtContent;
!begin
!  jwt := TJwtHS256.Create('secret', 0, [jrcSubject], []);
!  try
!    jwt.Verify(
!      'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.' +
!      'eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWV9.' +
!      'TJVA95OrM7E2cBab30RMHrHDcEfxjoYZgeFONFh7HgQ',
!      content);
!
!    Assert(content.result = jwtValid);
!    Assert(content.reg[jrcSubject] = '1234567890');
!    Assert(content.data.U['name'] = 'John Doe');
!    Assert(content.data.B['admin'] = True);
!  finally
!    jwt.Free;
!  end;
!end;
{}
:  Creating JWTs
{}
!var
!  jwt: TJwtAbstract;
!  token: RawUtf8;
!begin
!  jwt := TJwtHS256.Create('secret', 10000,  // 10000 PBKDF2 rounds
!    [jrcIssuer, jrcExpirationTime, jrcIssuedAt, jrcJWTID], [], 3600);  // 1 hour expiry
!  try
!    token := jwt.Compute(['http://example.com/is_root', True], 'joe');
!    // token payload: {"http://example.com/is_root":true,"iss":"joe","iat":...,"exp":...,"jti":...}
!  finally
!    jwt.Free;
!  end;
!end;
{}
:  JWT in Method-Based Services
{}
Integrate JWT validation using {\f1\fs20 Ctxt.AuthenticationCheck()}:
{}
!type
!  TMyDaemon = class(TRestServerFullMemory)
!  private
!    fJwt: TJwtAbstract;
!  public
!    constructor Create(aModel: TOrmModel);
!  published
!    procedure SecureFiles(Ctxt: TRestServerUriContext);
!  end;
!
!constructor TMyDaemon.Create(aModel: TOrmModel);
!begin
!  inherited Create(aModel);
!  fJwt := TJwtHS256.Create('my-secret-key', 10000, [jrcSubject], [], 3600);
!end;
!
!procedure TMyDaemon.SecureFiles(Ctxt: TRestServerUriContext);
!begin
!  if Ctxt.AuthenticationCheck(fJwt) then  // Returns boolean
!    Ctxt.ReturnFileFromFolder('c:\protected\')
!  else
!    ; // AuthenticationCheck already returned HTTP 401
!end;
{}
:  Server-Wide JWT Authentication
{}
Assign a JWT instance to handle all unauthenticated requests:
{}
!Server.JwtForUnauthenticatedRequest := TJwtHS256.Create('secret', 10000, [], []);
{}
:1409 Handling Errors
{}
:  Automatic Exception Handling
{}
Missing parameters in {\f1\fs20 Input*[]} properties raise {\f1\fs20 EParsingException}, which the server catches and returns as a structured error response:
{}
${
$  "ErrorCode": 400,
$  "ErrorText": "EParsingException: Missing parameter 'name'"
$}
{}
:  Explicit Error Handling
{}
Use {\f1\fs20 Ctxt.Error()} for custom error responses:
{}
!procedure TRestServer.UpdateRecord(Ctxt: TRestServerUriContext);
!begin
!  if not CanUpdate(Ctxt.InputInt['id']) then
!    Ctxt.Error('Record is locked', HTTP_FORBIDDEN)
!  else if DoUpdate(Ctxt.InputInt['id'], Ctxt.InputUtf8['data']) then
!    Ctxt.Success
!  else
!    Ctxt.Error('Update failed', HTTP_SERVERERROR);
!end;
{}
:  Success Without Content
{}
For operations that don't return data:
{}
!procedure TRestServer.DeleteItem(Ctxt: TRestServerUriContext);
!begin
!  if DoDelete(Ctxt.InputInt['id']) then
!    Ctxt.Success  // Returns HTTP 200 with empty body
!  else
!    Ctxt.Error('Delete failed');
!end;
{}
:  HTTP Status Codes
{}
|%16%84
|\b Method|Default Status\b0
|{\f1\fs20 Ctxt.Results()}|200 OK
|{\f1\fs20 Ctxt.Returns()}|200 OK (customizable)
|{\f1\fs20 Ctxt.Success()}|200 OK (customizable)
|{\f1\fs20 Ctxt.Error()}|400 Bad Request (customizable)
|%
{}
Common status codes:
- {\f1\fs20 HTTP_SUCCESS} = 200
- {\f1\fs20 HTTP_CREATED} = 201
- {\f1\fs20 HTTP_NOCONTENT} = 204
- {\f1\fs20 HTTP_BADREQUEST} = 400
- {\f1\fs20 HTTP_FORBIDDEN} = 403
- {\f1\fs20 HTTP_NOTFOUND} = 404
- {\f1\fs20 HTTP_SERVERERROR} = 500
{}
:1410 Bypassing Authentication
{}
:  Per-Method Bypass
{}
Certain methods (like {\f1\fs20 Timestamp} or public API endpoints) should be accessible without authentication:
{}
!Server.ServiceMethodByPassAuthentication('Timestamp');
!Server.ServiceMethodByPassAuthentication('GetPublicData');
{}
:  Allowed HTTP Methods
{}
Restrict which HTTP verbs are allowed for a method:
{}
!// In TRestServerMethod, set during initialization
!Server.PublishedMethods['MyMethod'].Methods := [mGET, mPOST];
{}
:1411 Benefits and Limitations
{}
:  Benefits
{}
Method-based services provide:
{}
|%23%77
|\b Benefit|Description\b0
|{\b Full control}|Direct access to HTTP headers, binary data, custom MIME types
|{\b RESTful integration}|Can be linked to ORM tables via URI routing
|{\b Low overhead}|Minimal abstraction layer, maximum performance
|{\b Flexibility}|Handle any request type (AJAX, SOAP, custom protocols)
|{\b Simple debugging}|Direct mapping between URI and code
|%
{}
:  Security
{}
The mORMot implementation is inherently secure against certain attacks:
- {\b Hash collision attacks}: Not vulnerable (unlike some Apache configurations)
- {\b Parameter injection}: Typed accessors validate input
- {\b Thread safety}: Enforced by design
{}
:  Limitations
{}
|%43%57
|\b Limitation|Solution\b0
|Manual parameter marshalling|Use interface-based services (Chapter 16)
|No automatic client stub generation|Use interface-based services
|Flat service namespace|Organize via naming conventions or interfaces
|No automatic documentation|Generate manually or use OpenAPI export
|%
{}
:  When to Use
{}
{\b Use method-based services when}:
- You need binary data handling or custom MIME types
- You're building a simple REST API
- You need maximum performance
- You're integrating with non-mORMot clients
- You want full HTTP control
{}
{\b Use interface-based services when}:
- Building complex SOA systems
- You want automatic parameter marshalling
- You need client stub generation
- You prefer strongly-typed contracts
{}
:1412 Complete Example
{}
:  Server
{}
!unit RestServerUnit;
!
!interface
!
!uses
!  mormot.core.base,
!  mormot.core.text,
!  mormot.core.json,
!  mormot.orm.core,
!  mormot.rest.core,
!  mormot.rest.server,
!  mormot.rest.memserver;
!
!type
!  TMyRestServer = class(TRestServerFullMemory)
!  published
!    procedure Sum(Ctxt: TRestServerUriContext);
!    procedure Echo(Ctxt: TRestServerUriContext);
!    procedure Time(Ctxt: TRestServerUriContext);
!  end;
!
!implementation
!
!procedure TMyRestServer.Sum(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.Results([Ctxt.InputDouble['a'] + Ctxt.InputDouble['b']]);
!end;
!
!procedure TMyRestServer.Echo(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.Returns(Ctxt.Call^.InBody, HTTP_SUCCESS, TEXT_CONTENT_TYPE_HEADER);
!end;
!
!procedure TMyRestServer.Time(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.Returns(['timestamp', ServerTimestamp, 'utc', DateTimeToIso8601(NowUtc, true)]);
!end;
!
!end.
{}
:  Client
{}
!unit RestClientUnit;
!
!interface
!
!uses
!  mormot.core.base,
!  mormot.rest.client,
!  mormot.rest.http.client;
!
!type
!  TMyRestClient = class(TRestHttpClientSocket)
!  public
!    function Sum(a, b: Double): Double;
!    function Echo(const Text: RawUtf8): RawUtf8;
!    function GetServerTime: TDateTime;
!  end;
!
!implementation
!
!uses
!  mormot.core.json;
!
!function TMyRestClient.Sum(a, b: Double): Double;
!var
!  err: Integer;
!begin
!  Val(CallBackGetResult('sum', ['a', a, 'b', b]), Result, err);
!end;
!
!function TMyRestClient.Echo(const Text: RawUtf8): RawUtf8;
!var
!  resp: RawUtf8;
!begin
!  if CallBack(mPOST, 'echo', Text, resp) = HTTP_SUCCESS then
!    Result := resp
!  else
!    Result := '';
!end;
!
!function TMyRestClient.GetServerTime: TDateTime;
!var
!  doc: TDocVariantData;
!  resp: RawUtf8;
!begin
!  if CallBackGet('time', [], resp) = HTTP_SUCCESS then
!  begin
!    doc.InitJson(resp, JSON_FAST);
!    Result := Iso8601ToDateTime(doc.U['utc']);
!  end
!  else
!    Result := 0;
!end;
!
!end.
{}
:  Main Program
{}
!program MethodServicesDemo;
!
!uses
!  mormot.core.base,
!  mormot.orm.core,
!  mormot.rest.http.server,
!  RestServerUnit,
!  RestClientUnit;
!
!var
!  Model: TOrmModel;
!  Server: TMyRestServer;
!  HttpServer: TRestHttpServer;
!  Client: TMyRestClient;
!begin
!  Model := TOrmModel.Create([], 'root');
!  Server := TMyRestServer.Create(Model);
!  try
!    Server.ServiceMethodByPassAuthentication('Time');
!
!    HttpServer := TRestHttpServer.Create('8080', [Server], '+', useHttpAsync);
!    try
!      // Client demo
!      Client := TMyRestClient.Create('localhost', '8080', TOrmModel.Create([], 'root'));
!      try
!        WriteLn('Sum(3.5, 2.5) = ', Client.Sum(3.5, 2.5):0:2);
!        WriteLn('Echo: ', Client.Echo('Hello mORMot!'));
!        WriteLn('Server time: ', DateTimeToStr(Client.GetServerTime));
!      finally
!        Client.Free;
!      end;
!
!      WriteLn('Press Enter to stop...');
!      ReadLn;
!    finally
!      HttpServer.Free;
!    end;
!  finally
!    Server.Free;
!    Model.Free;
!  end;
!end.
{}
: Summary
{}
Method-based services in mORMot 2 provide:
{}
- {\b Direct HTTP control}: Full access to headers, body, and response formatting
- {\b Simple implementation}: Just add a published method with the right signature
- {\b Flexible responses}: JSON, HTML, binary, any MIME type
- {\b RESTful integration}: Link methods to ORM tables via URI patterns
- {\b JWT support}: Built-in token validation
- {\b Browser caching}: HTTP 304 support for optimized polling
- {\b Thread safety}: By design, with fine-grained locking
{}
While interface-based services (covered in Chapter 16) offer more structure for complex SOA systems, method-based services remain the go-to choice for simple APIs, binary data handling, and maximum control over the HTTP layer.
{}

; === mORMot2-SAD-Chapter-15.md ===
; Converted from Markdown - Chapter 15
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:15Interfaces and SOLID Design
{}
{\i The Foundation for Robust Architecture}
{}
Before diving into interface-based services, we need to understand the fundamentals of interfaces in Delphi and the @*SOLID@ design principles that guide their effective use. This chapter establishes the theoretical foundation; Chapter 16 covers the practical implementation of @*SOA@ services.
{}
:1501 Delphi and Interfaces
{}
:  Declaring an Interface
{}
In Delphi's OOP model, an {\f1\fs20 interface} defines a type comprising abstract virtual methods. It declares "what" is available, not "how" it's implemented — this is the {\b abstraction} benefit of interfaces.
{}
!type
!  ICalculator = interface(IInvokable)
!    ['{9A60C8ED-CEB2-4E09-87D4-4A16F496E5FE}']
!    /// add two signed 32-bit integers
!    function Add(n1, n2: Integer): Integer;
!  end;
{}
Key characteristics:
- {\b Naming}: {\f1\fs20 ICalculator} starts with {\f1\fs20 I} (convention for interfaces, vs {\f1\fs20 T} for classes)
- {\b No visibility}: All methods are effectively public
- {\b No fields}: Only methods (fields are implementation details)
- {\b GUID}: Unique identifier (press {\f1\fs20 Ctrl+Shift+G} in the {\f1\fs20 IDE} to generate)
- {\b Inheritance}: From {\f1\fs20 IInvokable} for @*RTTI@ support
{}
:  Implementing an Interface
{}
!type
!  TServiceCalculator = class(TInterfacedObject, ICalculator)
!  public
!    function Add(n1, n2: Integer): Integer;
!  end;
!
!function TServiceCalculator.Add(n1, n2: Integer): Integer;
!begin
!  Result := n1 + n2;
!end;
{}
Notes:
- The class inherits from {\f1\fs20 TInterfacedObject} and implements {\f1\fs20 ICalculator}
- Method visibility in the class doesn't affect interface usage
- Additional methods can exist in the class (not part of the interface)
- Multiple interfaces can be implemented: {\f1\fs20 class({\f1\fs20 TInterfacedObject}, {\f1\fs20 ICalculator}, {\f1\fs20 IAnotherInterface})}
{}
:  Using an Interface
{}
{\b Classic way} (explicit class instance):
!function MyAdd(a, b: Integer): Integer;
!var
!  Calculator: TServiceCalculator;
!begin
!  Calculator := TServiceCalculator.Create;
!  try
!    Result := Calculator.Add(a, b);
!  finally
!    Calculator.Free;
!  end;
!end;
{}
{\b Interface way} (reference-counted):
!function MyAdd(a, b: Integer): Integer;
!var
!  Calculator: ICalculator;
!begin
!  Calculator := TServiceCalculator.Create;
!  Result := Calculator.Add(a, b);
!end; // Calculator automatically freed when out of scope
{}
Key benefits:
- {\b Automatic memory management}: Reference counting handles cleanup
- {\b No try..finally needed}: Compiler generates hidden cleanup code
- {\b Minimal overhead}: Similar to virtual method call performance
{}
:  Orthogonality and Polymorphism
{}
Interfaces are orthogonal to class implementations:
{}
!type
!  TOtherCalculator = class(TInterfacedObject, ICalculator)
!  public
!    function Add(n1, n2: Integer): Integer;
!  end;
!
!function TOtherCalculator.Add(n1, n2: Integer): Integer;
!begin
!  Result := n2 + n1; // Different implementation, same interface
!end;
{}
The client code doesn't need to change:
!var
!  Calculator: ICalculator;
!begin
!  Calculator := TOtherCalculator.Create; // Different class, same interface
!  Result := Calculator.Add(a, b);
!end;
{}
:  The mORMot Magic
{}
m@*ORM@ot leverages interfaces for Client-Server communication:
{}
- {\b Same interface} on both client and server
- {\b Client}: "Fake" implementation that serializes calls to @*JSON@
- {\b Server}: Real implementation executes the logic
- {\b Transport}: JSON over @*HTTP@ (or @*WebSocket@s, named pipes, etc.)
{}
This creates a seamless RPC experience with the elegance of local interface calls.
{}
:1502 SOLID Design Principles
{}
The SOLID acronym represents five principles for maintainable OOP design:
{}
|%30%70
|\b Principle|Summary\b0
|{\b S}ingle Responsibility|One reason to change per class
|{\b O}pen/Closed|Open for extension, closed for modification
|{\b L}iskov Substitution|Subtypes must be substitutable for base types
|{\b I}nterface Segregation|Many specific interfaces over one general-purpose
|{\b D}ependency Inversion|Depend on abstractions, not concretions
|%
{}
These principles combat the three main code weaknesses:
- {\b Rigidity}: Hard to change (changes cascade everywhere)
- {\b Fragility}: Changes break unexpected parts
- {\b Immobility}: Hard to reuse in other contexts
{}
:  Single Responsibility Principle
{}
> "A class should have only one reason to change."
{}
{\b Bad} — {\f1\fs20 TBarcodeScanner} handles both protocol and communication:
!type
!  TBarcodeScanner = class
!    function ReadFrame: TProtocolFrame;
!    procedure WriteFrame(const Frame: TProtocolFrame);
!    procedure SetComPort(const Port: string);  // Serial communication
!    procedure SetUsbDevice(DeviceID: Integer);  // USB communication
!  end;
{}
{\b Good} — Separated responsibilities:
!type
!  // Connection abstraction
!  TAbstractBarcodeConnection = class
!    function ReadChar: Byte; virtual; abstract;
!    procedure WriteChar(aChar: Byte); virtual; abstract;
!  end;
!
!  // Protocol abstraction
!  TAbstractBarcodeProtocol = class
!  protected
!    fConnection: TAbstractBarcodeConnection;
!  public
!    function ReadFrame: TProtocolFrame; virtual; abstract;
!    procedure WriteFrame(const Frame: TProtocolFrame); virtual; abstract;
!  end;
!
!  // Composed scanner
!  TBarcodeScanner = class
!  protected
!    fProtocol: TAbstractBarcodeProtocol;
!    fConnection: TAbstractBarcodeConnection;
!  public
!    property Protocol: TAbstractBarcodeProtocol read fProtocol;
!    property Connection: TAbstractBarcodeConnection read fConnection;
!  end;
{}
#### 15.2.1.1. Don't Mix UI and Logic
{}
{\b Smell in uses clause}:
!unit MyDataModel;
!
!uses
!  Vcl.Forms,    // BAD: Couples data to GUI framework
!  Windows,      // BAD: Couples to operating system
!  mormot.orm.core;
{}
Keep business logic units free of:
- GUI frameworks (VCL, FMX, LCL)
- Operating system specifics ({\f1\fs20 Windows}, {\f1\fs20 Posix})
- Any visual form units
{}
mORMot framework units follow this principle — {\f1\fs20 mormot.orm.core.pas} has no GUI dependencies.
{}
:  Open/Closed Principle
{}
> "Software entities should be open for extension, but closed for modification."
{}
{\b Guidelines}:
- Define abstract classes/interfaces, implement via inheritance
- Members should be {\f1\fs20 protected} (for inheritance) or {\f1\fs20 private} (hidden)
- Avoid singletons and global variables
- Use RTTI sparingly and via framework abstractions
{}
{\b Example — Your code extends mORMot without modifying it}:
!type
!  TMyRestServer = class(TRestServerDB)
!  published
!    procedure MyCustomService(Ctxt: TRestServerUriContext);
!  end;
{}
You extend by inheritance, not by editing {\f1\fs20 mormot.rest.server.pas}.
{}
:  Liskov Substitution Principle
{}
> "Objects of a supertype should be replaceable with objects of any subtype."
{}
{\b mORMot Example}:
!var
!  Rest: TRest;  // Abstract parent type
!begin
!  // Either implementation works identically:
!  Rest := TRestServerDB.Create(Model, 'mydata.db3');
!  // OR
!  Rest := TRestHttpClientSocket.Create('server', '8080', Model);
!
!  // Same API regardless of implementation:
!  Rest.Orm.Add(MyRecord);
!end;
{}
{\b Violations to avoid}:
!procedure TAbstractScanner.Process;
!begin
!  // BAD: Type checking breaks substitutability
!  if Self is TSerialScanner then
!    // Serial-specific code
!  else if Self is TUsbScanner then
!    // USB-specific code
!end;
{}
:  Interface Segregation Principle
{}
> "Many client-specific interfaces are better than one general-purpose interface."
{}
{\b Bad} — Fat interface:
!type
!  IEverything = interface
!    procedure DoThis;
!    procedure DoThat;
!    procedure DoSomethingElse;
!    // ... 50 more methods
!  end;
{}
{\b Good} — Segregated interfaces:
!type
!  IDoThis = interface
!    procedure DoThis;
!  end;
!
!  IDoThat = interface
!    procedure DoThat;
!  end;
{}
This is especially important in SOA: define small, focused service interfaces rather than monolithic ones.
{}
:  Dependency Inversion Principle
{}
> "Depend on abstractions, not concretions."
{}
{\b Bad} — Direct dependency on implementation:
!type
!  TOrderService = class
!  private
!    fDatabase: TSQLiteDatabase;  // Concrete class
!  end;
{}
{\b Good} — Dependency on abstraction:
!type
!  TOrderService = class
!  private
!    fRepository: IOrderRepository;  // Interface abstraction
!  public
!    constructor Create(const aRepository: IOrderRepository);
!  end;
{}
This enables:
- {\b Testing}: Inject mock implementations
- {\b Flexibility}: Swap implementations without code changes
- {\b Decoupling}: No compile-time dependency on concrete classes
{}
:1503 Circular References and Weak Pointers
{}
:  The Problem
{}
Interface reference counting can cause memory leaks with circular references:
{}
!type
!  IParent = interface
!    procedure SetChild(const Value: IChild);
!    function GetChild: IChild;
!  end;
!
!  IChild = interface
!    procedure SetParent(const Value: IParent);
!    function GetParent: IParent;
!  end;
{}
If {\f1\fs20 Parent.Child} references {\f1\fs20 Child}, and {\f1\fs20 Child.Parent} references {\f1\fs20 Parent}, neither will ever be freed — both maintain a reference count ≥ 1 indefinitely.
{}
:  Weak Pointers
{}
mORMot provides {\f1\fs20 SetWeak} to bypass reference counting:
{}
!uses
!  mormot.core.interfaces;
!
!procedure TChild.SetParent(const Value: IParent);
!begin
!  SetWeak(@fParent, Value);  // No reference count increment
!end;
{}
The child holds a reference to parent, but doesn't prevent parent's destruction.
{}
:  Zeroing Weak Pointers
{}
For safer weak references that automatically become {\f1\fs20 nil} when the target is freed:
{}
!procedure TChild.SetParent(const Value: IParent);
!begin
!  SetWeakZero(Self, @fParent, Value);  // Auto-nils when parent freed
!end;
{}
When {\f1\fs20 Parent} is destroyed:
- With {\f1\fs20 SetWeak}: {\f1\fs20 fParent} becomes a dangling pointer (dangerous!)
- With {\f1\fs20 SetWeakZero}: {\f1\fs20 fParent} automatically becomes {\f1\fs20 nil} (safe)
{}
:1504 Dependency Injection in Practice
{}
:  Constructor Injection
{}
The simplest and most explicit form:
{}
!type
!  IUserRepository = interface(IInvokable)
!    ['{B21E5B21-28F4-4874-8446-BD0B06DAA07F}']
!    function GetUserByName(const Name: RawUtf8): TUser;
!    procedure Save(const User: TUser);
!  end;
!
!  ISmsSender = interface(IInvokable)
!    ['{8F87CB56-5E2F-437E-B2E6-B3020835DC61}']
!    function Send(const Text, Number: RawUtf8): Boolean;
!  end;
!
!  TLoginController = class(TInterfacedObject, ILoginController)
!  private
!    fUserRepository: IUserRepository;
!    fSmsSender: ISmsSender;
!  public
!    constructor Create(const aUserRepository: IUserRepository;
!      const aSmsSender: ISmsSender);
!    procedure ForgotMyPassword(const UserName: RawUtf8);
!  end;
!
!constructor TLoginController.Create(const aUserRepository: IUserRepository;
!  const aSmsSender: ISmsSender);
!begin
!  fUserRepository := aUserRepository;
!  fSmsSender := aSmsSender;
!end;
{}
:  TInjectableObject
{}
For automatic resolution of dependencies, inherit from {\f1\fs20 TInjectableObject}:
{}
!uses
!  mormot.core.interfaces;
!
!type
!  TMyService = class(TInjectableObject, IMyService)
!  private
!    fCalculator: ICalculator;  // Auto-resolved
!  published
!    property Calculator: ICalculator read fCalculator;
!  public
!    function DoWork: Integer;
!  end;
{}
Published interface properties are automatically resolved when the object is created through the DI container.
{}
:  Lazy Resolution
{}
For on-demand resolution:
{}
!procedure TMyService.DoSomething;
!var
!  Repository: IOrderRepository;
!begin
!  Resolve(IOrderRepository, Repository);  // Resolve when needed
!  Repository.SaveOrder(Order);
!end;
{}
:1505 Stubs and Mocks for Testing
{}
:  Terminology
{}
|%8%92
|\b Type|Purpose\b0
|{\b Stub}|Fake implementation returning pre-arranged responses
|{\b Mock}|Fake that verifies interactions (method calls, parameters)
|%
{}
{\b Rule}: One mock per test, multiple stubs as needed.
{}
:  Creating Stubs
{}
!uses
!  mormot.core.interfaces;
!
!procedure TMyTest.TestForgotPassword;
!var
!  SmsSender: ISmsSender;
!  UserRepository: IUserRepository;
!begin
!  // Create stub that returns true for Send method
!  TInterfaceStub.Create(TypeInfo(ISmsSender), SmsSender)
!    .Returns('Send', [True]);
!
!  // Create mock that expects Save to be called once
!  TInterfaceMock.Create(TypeInfo(IUserRepository), UserRepository, Self)
!    .ExpectsCount('Save', qoEqualTo, 1);
!
!  // Run the test
!  with TLoginController.Create(UserRepository, SmsSender) do
!  try
!    ForgotMyPassword('testuser');
!  finally
!    Free;
!  end;
!  // Verification happens automatically when UserRepository goes out of scope
!end;
{}
:  Stub Return Values
{}
Simple returns:
!TInterfaceStub.Create(TypeInfo(ICalculator), Calc)
!  .Returns('Add', [42]);  // Add always returns 42
{}
Conditional returns:
!TInterfaceStub.Create(TypeInfo(ICalculator), Calc)
!  .Returns('Add', [1, 2], [3])   // Add(1,2) returns 3
!  .Returns('Add', [10, 20], [30]); // Add(10,20) returns 30
{}
:  Stub with Custom Logic
{}
Using a callback for complex behavior:
{}
!procedure TMyTest.SubtractCallback(Ctxt: TOnInterfaceStubExecuteParamsVariant);
!begin
!  Ctxt['Result'] := Ctxt['n1'] - Ctxt['n2'];
!end;
!
!TInterfaceStub.Create(TypeInfo(ICalculator), Calc)
!  .Executes('Subtract', SubtractCallback);
{}
:  Mock Expectations
{}
!TInterfaceMock.Create(TypeInfo(ICalculator), Calc, Self)
!  // Expect Multiply to be called exactly twice
!  .ExpectsCount('Multiply', qoEqualTo, 2)
!  // Expect Add to be called at least once
!  .ExpectsCount('Add', qoGreaterThan, 0)
!  // Expect specific call sequence
!  .ExpectsTrace('Add(10,20)=[30],Multiply(5,6)=[30]');
{}
:  Test Spy Pattern
{}
For "run then verify" testing:
{}
!procedure TMyTest.TestCalculator;
!var
!  Calc: ICalculator;
!  Spy: TInterfaceMockSpy;
!begin
!  Spy := TInterfaceMockSpy.Create(TypeInfo(ICalculator), Calc, Self);
!
!  // Run code under test
!  Calc.Add(10, 20);
!  Calc.Multiply(5, 6);
!
!  // Verify after execution
!  Spy.Verify('Add');
!  Spy.Verify('Multiply', [5, 6]);
!end;
{}
:1506 Interface Registration
{}
:  Global Registration
{}
Register interfaces at initialization for cleaner code:
{}
!unit MyInterfaces;
!
!interface
!
!type
!  ICalculator = interface(IInvokable)
!    ['{9A60C8ED-CEB2-4E09-87D4-4A16F496E5FE}']
!    function Add(n1, n2: Integer): Integer;
!  end;
!
!  IUserRepository = interface(IInvokable)
!    ['{B21E5B21-28F4-4874-8446-BD0B06DAA07F}']
!    function GetUserByName(const Name: RawUtf8): TUser;
!  end;
!
!implementation
!
!uses
!  mormot.core.interfaces;
!
!initialization
!  TInterfaceFactory.RegisterInterfaces([
!    TypeInfo(ICalculator),
!    TypeInfo(IUserRepository)
!  ]);
!end.
{}
:  Using Registered Interfaces
{}
After registration, you can use interface types directly (no {\f1\fs20 TypeInfo()}):
{}
!// Instead of:
!TInterfaceStub.Create(TypeInfo(ICalculator), Calc);
!
!// You can write:
!TInterfaceStub.Create(ICalculator, Calc);
{}
: Summary
{}
This chapter covered the foundations for interface-based development:
{}
- {\b Interfaces} provide abstraction and automatic memory management
- {\b SOLID principles} guide maintainable architecture
- {\b Weak pointers} solve circular reference problems
- {\b Dependency injection} enables loose coupling and testability
- {\b Stubs and mocks} enable isolated unit testing
{}
These concepts are essential for understanding the next chapter, which shows how mORMot uses interfaces to implement powerful SOA services with automatic client stub generation, contract validation, and multiple instance lifetime patterns.
{}

; === mORMot2-SAD-Chapter-16.md ===
; Converted from Markdown - Chapter 16
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:16Client-Server Services via Interfaces
{}
{\i Service-Oriented Architecture Made Simple}
{}
In Chapter 14, we covered method-based services — a direct approach with full @*HTTP@ control. This chapter introduces {\b interface-based services}, m@*ORM@ot's powerful @*SOA@ implementation that provides automatic client stub generation, contract validation, multiple instance lifetimes, and bidirectional communication via @*WebSocket@s.
{}
:1601 Why Interface-Based Services?
{}
Method-based services have limitations:
- Manual parameter marshalling on both ends
- No automatic client stub generation
- Flat service namespace
- Testing requires manual mocking
- No built-in session/workflow management
- Security checked manually per method
- No callback mechanism
{}
Interface-based services solve these problems:
{}
|%22%78
|\b Feature|Description\b0
|{\b Design by Contract}|Interfaces define the service contract in pure Pascal
|{\b Auto Marshalling}|@*JSON@ serialization handled automatically
|{\b Factory Driven}|Get implementations from interfaces on both client and server
|{\b Multiple Lifetimes}|Per-call, shared, per-session, per-user, per-group, client-driven
|{\b Contract Validation}|Client/server compatibility verified before execution
|{\b Bidirectional}|Callback interfaces for real-time notifications
|{\b Secure}|Per-method authorization via user groups
|{\b Cross-Platform}|Generated client code for Delphi, FPC, JavaScript
|%
{}
:1602 Defining the Service Contract
{}
:  Basic Interface
{}
!type
!  ICalculator = interface(IInvokable)
!    ['{9A60C8ED-CEB2-4E09-87D4-4A16F496E5FE}']
!    /// add two signed 32-bit integers
!    function Add(n1, n2: Integer): Integer;
!    /// multiply two 64-bit integers
!    function Multiply(n1, n2: Int64): Int64;
!  end;
{}
Requirements:
- Must inherit from {\f1\fs20 IInvokable} (ensures @*RTTI@)
- Must have a GUID (for identification)
- ASCII method names only (convention for services)
- {\f1\fs20 register} calling convention (default)
{}
:  Supported Parameter Types
{}
|%22%78
|\b Type|Serialization\b0
|{\f1\fs20 Boolean}|JSON {\f1\fs20 true}/{\f1\fs20 false}
|{\f1\fs20 Integer}, {\f1\fs20 Cardinal}, {\f1\fs20 Int64}, {\f1\fs20 Double}, {\f1\fs20 Currency}|JSON number
|Enumerations|JSON number (ordinal value)
|Sets|JSON number (bitmask, up to 32 elements)
|{\f1\fs20 TDateTime}, {\f1\fs20 TDateTimeMS}|{\f1\fs20 ISO} 8601 JSON string
|{\f1\fs20 RawUtf8}, {\f1\fs20 string}, {\f1\fs20 @*Unicode@String}|JSON string (@*UTF-8@)
|{\f1\fs20 RawJson}|JSON passthrough (no escaping)
|{\f1\fs20 RawByteString}|Base64-encoded JSON string
|{\f1\fs20 TPersistent}, {\f1\fs20 TOrm}|JSON object (published properties)
|{\f1\fs20 TObjectList}|JSON array with {\f1\fs20 "ClassName"} field
|Dynamic arrays|JSON array
|{\f1\fs20 record}|JSON object (with RTTI or custom serialization)
|{\f1\fs20 variant}, {\f1\fs20 TDocVariant}|Native JSON
|{\f1\fs20 TServiceCustomAnswer}|Custom response (binary, HTML, etc.)
|{\f1\fs20 interface}|Callback for bidirectional communication
|%
{}
:  Parameter Direction
{}
!function Process(const Input: RawUtf8;     // Client → Server only
!                 var InOut: Integer;        // Client ↔ Server (both ways)
!                 out Output: RawUtf8        // Server → Client only
!                ): Boolean;                 // Server → Client (result)
{}
:  Complex Interface Example
{}
!type
!  IComplexService = interface(IInvokable)
!    ['{8B5A2B10-7B3C-4A7D-95F3-8C9D7E6A5B4C}']
!    // Simple types
!    function Calculate(n1, n2: Double): Double;
!
!    // Record parameters
!    function ProcessOrder(const Order: TOrderRecord): TOrderResult;
!
!    // Dynamic arrays
!    function FilterItems(const Items: TRawUtf8DynArray;
!                        const Filter: RawUtf8): TRawUtf8DynArray;
!
!    // Object parameters (caller allocates)
!    procedure TransformCustomer(var Customer: TCustomer);
!
!    // Variant/TDocVariant for flexible JSON
!    function QueryData(const Params: Variant): Variant;
!
!    // Custom binary response
!    function GetReport(ReportID: Integer): TServiceCustomAnswer;
!  end;
{}
:  TServiceCustomAnswer
{}
For non-JSON responses (PDF, images, HTML):
{}
!function TMyService.GetReport(ReportID: Integer): TServiceCustomAnswer;
!begin
!  Result.Header := HEADER_CONTENT_TYPE + 'application/pdf';
!  Result.Content := GeneratePDF(ReportID);
!  Result.Status := HTTP_SUCCESS;
!end;
{}
{\b Note}: Methods returning {\f1\fs20 TServiceCustomAnswer} cannot have {\f1\fs20 var} or {\f1\fs20 out} parameters.
{}
:1603 Server-Side Implementation
{}
:  Implementing the Contract
{}
!type
!  TServiceCalculator = class(TInterfacedObject, ICalculator)
!  public
!    function Add(n1, n2: Integer): Integer;
!    function Multiply(n1, n2: Int64): Int64;
!  end;
!
!function TServiceCalculator.Add(n1, n2: Integer): Integer;
!begin
!  Result := n1 + n2;
!end;
!
!function TServiceCalculator.Multiply(n1, n2: Int64): Int64;
!begin
!  Result := n1 * n2;
!end;
{}
:  Registering the Service
{}
!// Using TypeInfo
!Server.ServiceRegister(TServiceCalculator, [TypeInfo(ICalculator)], sicShared);
!
!// Or using registered interface directly
!Server.ServiceDefine(TServiceCalculator, [ICalculator], sicShared);
{}
:  Instance Lifetime Modes
{}
|%8%72%20
|\b Mode|Description|Thread Safety\b0
|{\f1\fs20 sicSingle}|New instance per call (default, safest)|Not required
|{\f1\fs20 sicShared}|One instance for all calls (fastest)|{\b Required}
|{\f1\fs20 sicClientDriven}|Instance lives until client releases interface|Not required
|{\f1\fs20 sicPerSession}|One instance per authentication session|{\b Required}
|{\f1\fs20 sicPerUser}|One instance per user across sessions|{\b Required}
|{\f1\fs20 sicPerGroup}|One instance per user group|{\b Required}
|{\f1\fs20 sicPerThread}|One instance per server thread|Not required
|%
{}
#### Choosing the Right Mode
{}
|%76%24
|\b Use Case|Recommended Mode\b0
|Stateless operations, resource-intensive|{\f1\fs20 sicSingle}
|Simple stateless service, high throughput|{\f1\fs20 sicShared}
|Workflow with state between calls|{\f1\fs20 sicClientDriven}
|Session-specific caching|{\f1\fs20 sicPerSession}
|User preferences/settings|{\f1\fs20 sicPerUser}
|Group-level configuration|{\f1\fs20 sicPerGroup}
|Thread-local resources (e.g., database connection)|{\f1\fs20 sicPerThread}
|%
{}
:  Client-Driven Example
{}
!type
!  IComplexNumber = interface(IInvokable)
!    ['{29D753B2-E7EF-41B3-B7C3-827FEB082DC1}']
!    procedure Assign(aReal, aImaginary: Double);
!    function GetReal: Double;
!    procedure SetReal(const Value: Double);
!    function GetImaginary: Double;
!    procedure SetImaginary(const Value: Double);
!    procedure Add(aReal, aImaginary: Double);
!    property Real: Double read GetReal write SetReal;
!    property Imaginary: Double read GetImaginary write SetImaginary;
!  end;
!
!  TServiceComplexNumber = class(TInterfacedObject, IComplexNumber)
!  private
!    fReal, fImaginary: Double;
!  public
!    procedure Assign(aReal, aImaginary: Double);
!    function GetReal: Double;
!    procedure SetReal(const Value: Double);
!    function GetImaginary: Double;
!    procedure SetImaginary(const Value: Double);
!    procedure Add(aReal, aImaginary: Double);
!  end;
!
!// Registration
!Server.ServiceDefine(TServiceComplexNumber, [IComplexNumber], sicClientDriven);
{}
The server maintains {\f1\fs20 fReal} and {\f1\fs20 fImaginary} between calls until the client releases the interface.
{}
:1604 Accessing Execution Context
{}
:  Using TInjectableObjectRest
{}
The recommended approach — inherit from {\f1\fs20 TInjectableObjectRest}:
{}
!type
!  TMyService = class(TInjectableObjectRest, IMyService)
!  public
!    function GetCurrentUser: RawUtf8;
!    procedure LogActivity(const Action: RawUtf8);
!  end;
!
!function TMyService.GetCurrentUser: RawUtf8;
!begin
!  if Server <> nil then
!    Result := Server.SessionGetUser(Factory.CurrentSession).LogonName
!  else
!    Result := '';
!end;
!
!procedure TMyService.LogActivity(const Action: RawUtf8);
!begin
!  Server.Add(TOrmActivityLog, [
!    'Action', Action,
!    'User', GetCurrentUser,
!    'Timestamp', NowUtc
!  ]);
!end;
{}
Properties available:
- {\f1\fs20 Server: {\f1\fs20 @**TRestServer@}} — Access to ORM and server methods
- {\f1\fs20 Factory: {\f1\fs20 TServiceFactoryServer}} — Service factory instance
{}
:  Using ServiceRunningContext
{}
For services not inheriting from {\f1\fs20 TInjectableObjectRest}:
{}
!function TMyService.ProcessRequest: RawUtf8;
!var
!  Ctxt: PServiceRunningContext;
!begin
!  Ctxt := PerThreadRunningContextAddress;
!  if Ctxt^.Request <> nil then
!    Result := Ctxt^.Request.SessionUserName
!  else
!    Result := 'Unknown';
!end;
{}
{\b Note}: Prefer {\f1\fs20 TInjectableObjectRest} — it's safer and works outside client-server context.
{}
:1605 Client-Side Usage
{}
:  Registering the Interface
{}
!// Must match server-side mode
!Client.ServiceRegister([TypeInfo(ICalculator)], sicShared);
!
!// Or with registered interface
!Client.ServiceDefine([ICalculator], sicShared);
{}
:  Resolving and Using Services
{}
!var
!  Calc: ICalculator;
!begin
!  if Client.Services.Resolve(ICalculator, Calc) then
!    ShowMessage(IntToStr(Calc.Add(10, 20)));
!end;
{}
Generic syntax (Delphi 2010+):
!var
!  Calc: ICalculator;
!begin
!  Calc := Client.Service<ICalculator>;
!  if Calc <> nil then
!    ShowMessage(IntToStr(Calc.Add(10, 20)));
!end;
{}
:  Client-Driven Services
{}
!var
!  CN: IComplexNumber;
!begin
!  if Client.Services.Resolve(IComplexNumber, CN) then
!  begin
!    CN.Assign(0.01, 3.14);
!    CN.Add(100, 200);
!    ShowMessage(Format('%.2f + %.2fi', [CN.Real, CN.Imaginary]));
!  end;
!end; // CN released here → server instance also released
{}
:  Auto-Registration
{}
For {\f1\fs20 sicClientDriven}, explicit registration is optional:
!// This works without prior ServiceRegister call
!var
!  CN: IComplexNumber;
!begin
!  Client.Services.Info(IComplexNumber).Get(CN);  // Auto-registers as sicClientDriven
!end;
{}
:1606 Contract Validation
{}
:  Automatic Contract Hash
{}
By default, mORMot generates an MD5 hash of the interface signature:
- Method names
- Parameter types and directions
- Return types
{}
If client and server contracts don't match, connection fails with a clear error.
{}
:  Custom Contract Strings
{}
For explicit version control:
{}
!// Server
!Server.ServiceRegister(TMyService, [TypeInfo(IMyService)], sicShared)
!  .SetOptions([], 'v2.5');  // Contract = 'v2.5'
!
!// Client must match
!Client.ServiceRegister([TypeInfo(IMyService)], sicShared, 'v2.5');
{}
This allows:
- Semantic versioning
- Gradual client migration
- Clear compatibility rules
{}
:1607 Authorization and Security
{}
:  Per-Method Authorization
{}
!var
!  Factory: TServiceFactoryServer;
!begin
!  Factory := Server.Services.Info(ICalculator) as TServiceFactoryServer;
!
!  // Deny all by default
!  Factory.DenyAll;
!
!  // Allow specific groups by ID
!  Factory.Allow(ICalculator, [ADMIN_GROUP_ID]);
!
!  // Allow specific methods for other groups by name
!!  // Note: AllowByName takes group names (RawUtf8), not IDs
!  Factory.AllowByName(['Add', 'Multiply'], ['User', 'Guest']);
!end;
{}
:  Authentication Bypass
{}
For public methods:
{}
!Server.ServiceMethodByPassAuthentication('Calculator.GetVersion');
{}
:  Execution Options
{}
!Factory.SetOptions([optExecInMainThread]);  // Execute in main VCL thread
!Factory.SetOptions([optFreeInMainThread]);  // Free instance in main thread
!Factory.SetOptions([optExecInPerInterfaceThread]);  // Dedicated thread per interface
{}
:1608 Service Logging
{}
:  Enabling Logging
{}
!Factory.SetServiceLog(Server, TOrmServiceLog);
{}
This logs:
- Method name ({\f1\fs20 Interface.Method})
- Input parameters (JSON)
- Output parameters (JSON)
- Execution time (microseconds)
- Session/User context
{}
:  Custom Log Table
{}
!type
!  TOrmMyServiceLog = class(TOrmServiceLog)
!  published
!    property CustomField: RawUtf8 read fCustomField write fCustomField;
!  end;
!
!Factory.SetServiceLog(Server, TOrmMyServiceLog);
{}
:1609 Bidirectional Communication (Callbacks)
{}
:  Defining Callback Interfaces
{}
!type
!  // Callback interface (client implements this)
!  IProgressCallback = interface(IInvokable)
!    ['{A1B2C3D4-E5F6-7890-ABCD-EF1234567890}']
!    procedure Progress(Percent: Integer; const Status: RawUtf8);
!    procedure Completed(Success: Boolean);
!  end;
!
!  // Service interface
!  ILongRunningTask = interface(IInvokable)
!    ['{12345678-1234-1234-1234-123456789012}']
!    procedure StartTask(const TaskName: RawUtf8; const Callback: IProgressCallback);
!    procedure CancelTask(const TaskID: RawUtf8);
!  end;
{}
:  Server Implementation
{}
!type
!  TLongRunningTask = class(TInjectableObjectRest, ILongRunningTask)
!  public
!    procedure StartTask(const TaskName: RawUtf8; const Callback: IProgressCallback);
!    procedure CancelTask(const TaskID: RawUtf8);
!  end;
!
!procedure TLongRunningTask.StartTask(const TaskName: RawUtf8;
!  const Callback: IProgressCallback);
!begin
!  // Start background work
!  TThread.CreateAnonymousThread(
!    procedure
!    var
!      i: Integer;
!    begin
!      for i := 0 to 100 do
!      begin
!        Sleep(100);
!        Callback.Progress(i, Format('Processing %s...', [TaskName]));
!      end;
!      Callback.Completed(True);
!    end
!  ).Start;
!end;
{}
:  Client Implementation
{}
!type
!  TMyProgressCallback = class(TInterfacedCallback, IProgressCallback)
!  private
!    fForm: TForm;
!  public
!    constructor Create(aForm: TForm; aRest: TRestClientUri);
!    procedure Progress(Percent: Integer; const Status: RawUtf8);
!    procedure Completed(Success: Boolean);
!  end;
!
!constructor TMyProgressCallback.Create(aForm: TForm; aRest: TRestClientUri);
!begin
!  inherited Create(aRest, IProgressCallback);  // Register callback
!  fForm := aForm;
!end;
!
!procedure TMyProgressCallback.Progress(Percent: Integer; const Status: RawUtf8);
!begin
!  TThread.Queue(nil,
!    procedure
!    begin
!      fForm.ProgressBar.Position := Percent;
!      fForm.StatusLabel.Caption := Status;
!    end);
!end;
{}
:  Using WebSockets
{}
Callbacks require WebSocket transport:
{}
!// Server
!HttpServer := TRestHttpServer.Create('8080', [Server], '+', useHttpAsync);
!HttpServer.WebSocketsEnable(Server, 'privatekey');
!
!// Client
!Client := TRestHttpClientWebSockets.Create('localhost', '8080', Model);
!Client.WebSocketsConnect('privatekey');
!Client.ServiceDefine([ILongRunningTask], sicShared);
{}
:1610 Using Services on the Server
{}
:  Resolving Services
{}
!procedure TMyOtherService.DoSomething;
!var
!  Calc: ICalculator;
!begin
!  if Resolve(ICalculator, Calc) then
!    Result := Calc.Add(10, 20);
!end;
{}
:  Generic Syntax
{}
!procedure TMyOtherService.DoSomething;
!var
!  Calc: ICalculator;
!begin
!  Calc := Server.Service<ICalculator>;
!  if Calc <> nil then
!    Result := Calc.Add(10, 20);
!end;
{}
:1611 Complete Example
{}
:  Shared Interface Unit
{}
!unit ProjectInterface;
!
!interface
!
!uses
!  mormot.core.base,
!  mormot.core.interfaces;
!
!type
!  ICalculator = interface(IInvokable)
!    ['{9A60C8ED-CEB2-4E09-87D4-4A16F496E5FE}']
!    function Add(n1, n2: Integer): Integer;
!    function Multiply(n1, n2: Int64): Int64;
!  end;
!
!const
!  ROOT_NAME = 'api';
!  PORT_NAME = '8080';
!
!implementation
!
!initialization
!  TInterfaceFactory.RegisterInterfaces([TypeInfo(ICalculator)]);
!end.
{}
:  Server Application
{}
!program Server;
!
!{$APPTYPE CONSOLE}
!
!uses
!  mormot.core.base,
!  mormot.orm.core,
!  mormot.rest.server,
!  mormot.rest.memserver,
!  mormot.rest.http.server,
!  ProjectInterface;
!
!type
!  TServiceCalculator = class(TInterfacedObject, ICalculator)
!  public
!    function Add(n1, n2: Integer): Integer;
!    function Multiply(n1, n2: Int64): Int64;
!  end;
!
!function TServiceCalculator.Add(n1, n2: Integer): Integer;
!begin
!  Result := n1 + n2;
!end;
!
!function TServiceCalculator.Multiply(n1, n2: Int64): Int64;
!begin
!  Result := n1 * n2;
!end;
!
!var
!  Model: TOrmModel;
!  Server: TRestServerFullMemory;
!  HttpServer: TRestHttpServer;
!begin
!  Model := TOrmModel.Create([], ROOT_NAME);
!  Server := TRestServerFullMemory.Create(Model);
!  try
!    Server.ServiceDefine(TServiceCalculator, [ICalculator], sicShared);
!
!    HttpServer := TRestHttpServer.Create(PORT_NAME, [Server], '+', useHttpAsync);
!    try
!      WriteLn('Server running on http://localhost:', PORT_NAME);
!      WriteLn('Press Enter to stop...');
!      ReadLn;
!    finally
!      HttpServer.Free;
!    end;
!  finally
!    Server.Free;
!    Model.Free;
!  end;
!end.
{}
:  Client Application
{}
!program Client;
!
!{$APPTYPE CONSOLE}
!
!uses
!  mormot.core.base,
!  mormot.orm.core,
!  mormot.rest.client,
!  mormot.rest.http.client,
!  ProjectInterface;
!
!var
!  Model: TOrmModel;
!  Client: TRestHttpClientSocket;
!  Calc: ICalculator;
!begin
!  Model := TOrmModel.Create([], ROOT_NAME);
!  Client := TRestHttpClientSocket.Create('localhost', PORT_NAME, Model);
!  try
!    Client.ServiceDefine([ICalculator], sicShared);
!
!    if Client.Services.Resolve(ICalculator, Calc) then
!    begin
!      WriteLn('10 + 20 = ', Calc.Add(10, 20));
!      WriteLn('10 * 20 = ', Calc.Multiply(10, 20));
!    end
!    else
!      WriteLn('Service not available');
!  finally
!    Client.Free;
!    Model.Free;
!  end;
!end.
{}
: Summary
{}
Interface-based services in mORMot 2 provide:
{}
- {\b Clean contracts} via Pascal interfaces
- {\b Automatic marshalling} of complex types to/from JSON
- {\b Multiple instance modes} for different use cases
- {\b Contract validation} ensuring client/server compatibility
- {\b Per-method authorization} with user groups
- {\b Bidirectional communication} via WebSocket callbacks
- {\b Execution logging} to database
- {\b Dependency injection} via {\f1\fs20 TInjectableObjectRest}
{}
For most applications, interface-based services are the recommended approach. They provide the structure, safety, and features needed for robust SOA while keeping implementation simple and type-safe.
{}

; === mORMot2-SAD-Chapter-17.md ===
; Converted from Markdown - Chapter 17
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:17Cross-Platform Clients
{}
{\i Reaching Beyond Windows}
{}
m@*ORM@ot 2 is designed from the ground up as a {\b cross-platform framework}. The core libraries compile natively on Windows, Linux, macOS, FreeBSD, and Android using either Delphi or Free Pascal. This chapter covers strategies for consuming mORMot services from various platforms and generating client code.
{}
:1701 Native Cross-Platform Support
{}
:  mORMot 2 Platform Coverage
{}
Unlike mORMot 1 (which required separate {\f1\fs20 SynCrossPlatform*} units), mORMot 2's main units are inherently cross-platform:
{}
|%49%29%22
|\b Platform|Delphi|Free Pascal\b0
|Windows (32/64-bit)|✅|✅
|Linux (x86_64, aarch64)|✅ (Delphi 12+)|✅
|macOS (x86_64, aarch64)|✅|✅
|FreeBSD|—|✅
|Android|✅ (FireMonkey)|✅
|iOS|✅ (FireMonkey)|—
|%
{}
:  Core Cross-Platform Units
{}
The {\f1\fs20 mormot.core.*} units provide the foundation:
{}
|%8%92
|\b Unit|Purpose\b0
|@!src\core\mormot.core.base.pas@|Base types, memory management
|@!src\core\mormot.core.os.pas@|OS abstraction (files, threads, processes)
|@!src\core\mormot.core.unicode.pas@|@*UTF-8@/UTF-16 handling
|@!src\core\mormot.core.text.pas@|Text processing, formatting
|@!src\core\mormot.core.buffers.pas@|Binary data handling
|@!src\core\mormot.core.data.pas@|Collections, dynamic arrays
|@!src\core\mormot.core.json.pas@|@*JSON@ parsing and generation
|@!src\core\mormot.core.variants.pas@|{\f1\fs20 @**TDocVariant@} for flexible JSON
|@!src\core\mormot.core.rtti.pas@|Cross-platform @*RTTI@
|@!src\core\mormot.core.interfaces.pas@|Interface invocation, stubs, mocks
|%
{}
These units have {\b zero GUI dependencies} and work identically across all supported platforms.
{}
:  Network Layer
{}
@*HTTP@ client support via {\f1\fs20 mormot.net.*}:
{}
!uses
!  mormot.net.client,
!  mormot.rest.http.client;
!
!var
!  Client: TRestHttpClientSocket;
!begin
!  // Works on Windows, Linux, macOS, etc.
!  Client := TRestHttpClientSocket.Create('api.example.com', '443', Model, True);
!  try
!    Client.ServiceDefine([IMyService], sicShared);
!    // Use services...
!  finally
!    Client.Free;
!  end;
!end;
{}
Available HTTP client classes:
{}
|%18%42%40
|\b Class|Transport|Platform\b0
|{\f1\fs20 TRestHttpClientSocket}|Raw sockets|All
|{\f1\fs20 TRestHttpClient@*WebSocket@s}|WebSocket|All
|{\f1\fs20 TRestHttpClientWinHttp}|WinHTTP API|Windows
|{\f1\fs20 TRestHttpClientCurl}|libcurl|Linux/macOS
|%
{}
:1702 Generating Client Wrappers
{}
:  The Code Generation Framework
{}
mORMot 2 includes a powerful code generation system in {\f1\fs20 mormot.soa.codegen.pas} that creates client wrappers from server definitions using Mustache templates.
{}
Key functions:
{}
|%16%84
|\b Function|Purpose\b0
|{\f1\fs20 ContextFromModel()}|Extract ORM/@*SOA@ metadata as JSON
|{\f1\fs20 WrapperFromModel()}|Generate code from Mustache template
|{\f1\fs20 WrapperMethod()}|HTTP handler for browser-based generation
|{\f1\fs20 AddToServerWrapperMethod()}|Add wrapper endpoint to server
|%
{}
:  Publishing the Wrapper Endpoint
{}
!program MyServer;
!
!uses
!  mormot.rest.server,
!  mormot.rest.http.server,
!  mormot.soa.codegen;
!
!var
!  Server: TRestServerDB;
!  HttpServer: TRestHttpServer;
!begin
!  Server := TRestServerDB.Create(Model, 'data.db3');
!  try
!    Server.ServiceDefine(TMyService, [IMyService], sicShared);
!
!    // Add wrapper generation endpoint
!    AddToServerWrapperMethod(Server, ['./templates', '../templates']);
!
!    HttpServer := TRestHttpServer.Create('8080', [Server]);
!    try
!      WriteLn('Wrapper available at http://localhost:8080/root/wrapper');
!      ReadLn;
!    finally
!      HttpServer.Free;
!    end;
!  finally
!    Server.Free;
!  end;
!end.
{}
:  Using the Web Interface
{}
Navigate to {\f1\fs20 @http://localhost:8080/root/wrapper} in your browser:
{}
!Client Wrappers
!===============
!
!Available Templates:
!- Delphi
!  mORMotClient.pas - download as file | see as text | see template
!
!- TypeScript
!  mORMotClient.ts - download as file | see as text | see template
!
!- OpenAPI
!  openapi.json - download as file | see as text | see template
!
!Template context (JSON)
{}
:  Mustache Template System
{}
Templates use the Mustache logic-less syntax:
{}
$// Generated client for {{root}} API
$unit {{filename}};
$
$interface
$
$uses
$  mormot.core.base,
$  mormot.rest.client;
$
$type
${{#services}}
$  {{interfaceName}} = interface(IInvokable)
$    ['{{{guid}}}']
$  {{#methods}}
$    {{declaration}};
$  {{/methods}}
$  end;
$
${{/services}}
$
$implementation
$
${{#services}}
$// {{interfaceName}} implementation
${{#methods}}
$function T{{serviceName}}.{{methodName}}({{args}}): {{resultType}};
$begin
$  // Generated stub code
$end;
$
${{/methods}}
${{/services}}
$
$end.
{}
:  Available Template Variables
{}
The context includes:
{}
|%22%78
|\b Variable|Description\b0
|{\f1\fs20 {{root}}}|API root URI
|{\f1\fs20 {{port}}}|Server port
|{\f1\fs20 {{filename}}}|Output filename
|{\f1\fs20 {{orm}}}|Array of ORM classes
|{\f1\fs20 {{services}}}|Array of service interfaces
|{\f1\fs20 {{#service.methods}}}|Methods within service
|{\f1\fs20 {{typeDelphi}}}|Delphi type name
|{\f1\fs20 {{typeTS}}}|TypeScript type name
|{\f1\fs20 {{typeCS}}}|C# type name
|{\f1\fs20 {{typeJava}}}|Java type name
|%
{}
:1703 Delphi/FPC Native Clients
{}
:  Direct mORMot Usage
{}
The simplest approach — use mORMot directly on any supported platform:
{}
!program CrossPlatformClient;
!
!{$APPTYPE CONSOLE}
!
!uses
!  mormot.core.base,
!  mormot.core.os,
!  mormot.orm.core,
!  mormot.rest.http.client,
!  MyServiceInterface;
!
!var
!  Client: TRestHttpClientSocket;
!  Service: IMyService;
!begin
!  Client := TRestHttpClientSocket.Create('server.example.com', '8080',
!    TOrmModel.Create([], 'api'));
!  try
!    Client.ServiceDefine([IMyService], sicShared);
!
!    if Client.Services.Resolve(IMyService, Service) then
!      WriteLn('Result: ', Service.Calculate(10, 20));
!  finally
!    Client.Free;
!  end;
!end.
{}
This compiles and runs identically on Windows, Linux, and macOS.
{}
:  Generated Client Wrapper
{}
For projects that can't include full mORMot dependencies, use generated wrappers:
{}
!// Generated mORMotClient.pas
!unit mORMotClient;
!
!interface
!
!uses
!  mormot.core.base,
!  mormot.rest.client;
!
!type
!  ICalculator = interface(IInvokable)
!    ['{9A60C8ED-CEB2-4E09-87D4-4A16F496E5FE}']
!    function Add(n1, n2: Integer): Integer;
!    function Multiply(n1, n2: Int64): Int64;
!  end;
!
!/// Create a connected client instance
!function GetClient(const aServer: RawUtf8;
!  const aPort: RawUtf8 = '8080'): TRestHttpClientSocket;
!
!implementation
!
!function GetClient(const aServer, aPort: RawUtf8): TRestHttpClientSocket;
!begin
!  Result := TRestHttpClientSocket.Create(aServer, aPort,
!    TOrmModel.Create([], 'api'));
!  Result.ServiceDefine([ICalculator], sicShared);
!end;
!
!end.
{}
:  FPC-Specific Generation
{}
For Free Pascal, additional RTTI registration may be needed:
{}
!procedure ComputeFPCInterfacesUnit(const Path: array of TFileName;
!  DestFileName: TFileName = '');
{}
This generates a unit with explicit interface registration to work around FPC RTTI limitations.
{}
:1704 REST/JSON Clients (Any Language)
{}
:  Protocol Overview
{}
mORMot services use standard HTTP with JSON:
{}
{\b Request Format:}
!GET /api/Calculator/Add?n1=10&n2=20 HTTP/1.1
!Host: server.example.com
{}
{\b Response Format:}
${"result": 30}
{}
For POST requests with complex parameters:
!POST /api/Calculator.Add HTTP/1.1
!Content-Type: application/json
!
![10, 20]
{}
:  Authentication
{}
mORMot's default authentication uses a challenge-response protocol:
{}
1. Client requests timestamp: {\f1\fs20 GET /api/auth}
2. Server returns: {\f1\fs20 {"result": "1234567890"}}
3. Client computes: {\f1\fs20 HMAC-SHA256(password, timestamp + username)}
4. Client authenticates: {\f1\fs20 GET /api/auth?UserName=xxx&PasswordHashHexa=yyy&ClientNonce=zzz}
5. Server returns session info
{}
For simpler integration, consider:
- {\b Basic Auth}: {\f1\fs20 Authorization: Basic base64(user:pass)}
- {\b Bearer Token}: {\f1\fs20 Authorization: Bearer jwt_token}
- {\b No Auth}: {\f1\fs20 Server.AuthenticationRegister({\f1\fs20 TRestServerAuthenticationNone})}
{}
:  TypeScript/JavaScript Client
{}
Example generated TypeScript client:
{}
$// mORMotClient.ts
$export interface ICalculator {
$  add(n1: number, n2: number): Promise<number>;
$  multiply(n1: number, n2: number): Promise<number>;
$}
$
$export class CalculatorClient implements ICalculator {
$  constructor(private baseUrl: string) {}
$
$  async add(n1: number, n2: number): Promise<number> {
$    const response = await fetch(
$      `${this.baseUrl}/Calculator/Add?n1=${n1}&n2=${n2}`
$    );
$    const data = await response.json();
$    return data.result;
$  }
$
$  async multiply(n1: number, n2: number): Promise<number> {
$    const response = await fetch(
$      `${this.baseUrl}/Calculator/Multiply?n1=${n1}&n2=${n2}`
$    );
$    const data = await response.json();
$    return data.result;
$  }
$}
$
$// Usage
$const calc = new CalculatorClient('http://localhost:8080/api');
$const sum = await calc.add(10, 20);
{}
:  Python Client
{}
$import requests
$
$class CalculatorClient:
$    def __init__(self, base_url: str):
$        self.base_url = base_url.rstrip('/')
$
$    def add(self, n1: int, n2: int) -> int:
$        response = requests.get(
$            f"{self.base_url}/Calculator/Add",
$            params={"n1": n1, "n2": n2}
$        )
$        return response.json()["result"]
$
$    def multiply(self, n1: int, n2: int) -> int:
$        response = requests.get(
$            f"{self.base_url}/Calculator/Multiply",
$            params={"n1": n1, "n2": n2}
$        )
$        return response.json()["result"]
$
$# Usage
$calc = CalculatorClient("http://localhost:8080/api")
$print(calc.add(10, 20))  # 30
{}
:  C# Client
{}
$using System.Net.Http.Json;
$
$public interface ICalculator
${
$    Task<int> Add(int n1, int n2);
$    Task<long> Multiply(long n1, long n2);
$}
$
$public class CalculatorClient : ICalculator
${
$    private readonly HttpClient _client;
$    private readonly string _baseUrl;
$
$    public CalculatorClient(string baseUrl)
$    {
$        _client = new HttpClient();
$        _baseUrl = baseUrl.TrimEnd('/');
$    }
$
$    public async Task<int> Add(int n1, int n2)
$    {
$        var response = await _client.GetFromJsonAsync<ResultWrapper<int>>(
$            $"{_baseUrl}/Calculator/Add?n1={n1}&n2={n2}");
$        return response.Result;
$    }
$
$    public async Task<long> Multiply(long n1, long n2)
$    {
$        var response = await _client.GetFromJsonAsync<ResultWrapper<long>>(
$            $"{_baseUrl}/Calculator/Multiply?n1={n1}&n2={n2}");
$        return response.Result;
$    }
$
$    private record ResultWrapper<T>(T Result);
$}
{}
:1705 OpenAPI/Swagger Integration
{}
:  Generating OpenAPI Specification
{}
Create a Mustache template for OpenAPI 3.0:
{}
${
$  "openapi": "3.0.0",
$  "info": {
$    "title": "{{root}} API",
$    "version": "1.0.0"
$  },
$  "servers": [
$    {"url": "http://localhost:{{port}}/{{root}}"}
$  ],
$  "paths": {
${{#services}}
${{#methods}}
$    "/{{../serviceName}}/{{methodName}}": {
$      "get": {
$        "operationId": "{{../serviceName}}_{{methodName}}",
$        "parameters": [
${{#args}}
$          {
$            "name": "{{argName}}",
$            "in": "query",
$            "schema": {"type": "{{openApiType}}"}
$          }{{^last}},{{/last}}
${{/args}}
$        ],
$        "responses": {
$          "200": {
$            "description": "Success",
$            "content": {
$              "application/json": {
$                "schema": {
$                  "type": "object",
$                  "properties": {
$                    "result": {"type": "{{openApiResultType}}"}
$                  }
$                }
$              }
$            }
$          }
$        }
$      }
$    }{{^last}},{{/last}}
${{/methods}}
${{/services}}
$  }
$}
{}
:  Using with Swagger UI
{}
Once you have the OpenAPI spec, integrate with Swagger UI:
{}
!// Add static file serving for Swagger UI
!procedure TMyServer.SwaggerUI(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.ReturnFileFromFolder('./swagger-ui/', True, 'index.html');
!end;
{}
:1706 WebSocket Clients
{}
:  JavaScript WebSocket Client
{}
For bidirectional communication:
{}
$class MorMotWebSocket {
$  constructor(url) {
$    this.ws = new WebSocket(url);
$    this.callbacks = new Map();
$    this.callId = 0;
$
$    this.ws.onmessage = (event) => {
$      const response = JSON.parse(event.data);
$      const callback = this.callbacks.get(response.id);
$      if (callback) {
$        callback(response.result);
$        this.callbacks.delete(response.id);
$      }
$    };
$  }
$
$  call(service, method, params) {
$    return new Promise((resolve) => {
$      const id = ++this.callId;
$      this.callbacks.set(id, resolve);
$      this.ws.send(JSON.stringify({
$        id,
$        method: `${service}.${method}`,
$        params
$      }));
$    });
$  }
$}
$
$// Usage
$const ws = new MorMotWebSocket('ws://localhost:8080/api');
$const result = await ws.call('Calculator', 'Add', [10, 20]);
{}
:  Handling Callbacks
{}
For server-to-client callbacks:
{}
$ws.onmessage = (event) => {
$  const msg = JSON.parse(event.data);
$
$  if (msg.callback) {
$    // Server-initiated callback
$    handleCallback(msg.callback, msg.params);
$  } else if (msg.id) {
$    // Response to our request
$    resolveRequest(msg.id, msg.result);
$  }
$};
$
$function handleCallback(name, params) {
$  switch (name) {
$    case 'IProgress.Update':
$      updateProgressBar(params.percent);
$      break;
$    case 'IProgress.Completed':
$      showComplete(params.success);
$      break;
$  }
$}
{}
:1707 Mobile Considerations
{}
:  Network Connectivity
{}
Mobile apps must handle:
- Intermittent connectivity
- High latency
- Battery constraints
{}
!// Retry logic with exponential backoff
!function CallWithRetry(Client: TRestHttpClientSocket;
!  const Method: RawUtf8; MaxRetries: Integer = 3): RawJson;
!var
!  Attempt: Integer;
!  Delay: Integer;
!begin
!  Delay := 100; // Initial delay in ms
!  for Attempt := 1 to MaxRetries do
!  try
!    Result := Client.CallBackGetResult(Method, []);
!    Exit;
!  except
!    on E: Exception do
!    begin
!      if Attempt = MaxRetries then
!        raise;
!      Sleep(Delay);
!      Delay := Delay * 2; // Exponential backoff
!    end;
!  end;
!end;
{}
:  Data Caching
{}
For offline support:
{}
!type
!  TCachedClient = class
!  private
!    fClient: TRestHttpClientSocket;
!    fCache: TDocVariantData;
!  public
!    function GetData(const Key: RawUtf8): Variant;
!  end;
!
!function TCachedClient.GetData(const Key: RawUtf8): Variant;
!begin
!  // Try cache first
!  if fCache.GetValueByPath(Key, Result) then
!    Exit;
!
!  // Fetch from server
!  try
!    Result := fClient.CallBackGetResult('GetData', ['key', Key]);
!    fCache.AddValue(Key, Result);
!  except
!    // Return cached data even if stale
!    Result := fCache.Value[Key];
!  end;
!end;
{}
:  Delphi FireMonkey
{}
mORMot works with FireMonkey for iOS/Android:
{}
!uses
!  mormot.rest.http.client,
!  FMX.Forms;
!
!procedure TMainForm.ConnectButtonClick(Sender: TObject);
!begin
!  // Same code works on mobile
!  fClient := TRestHttpClientSocket.Create(
!    EditServer.Text,
!    EditPort.Text,
!    fModel
!  );
!  fClient.ServiceDefine([IMyService], sicShared);
!end;
{}
{\b Note}: Ensure you're using {\f1\fs20 TRestHttpClientSocket} or {\f1\fs20 TRestHttpClientCurl} on mobile, not Windows-specific classes.
{}
:1708 Best Practices
{}
:  API Versioning
{}
Include version in your API root:
{}
!// Server
!Server := TRestServerDB.Create(Model, 'data.db3');
!Server.Model.Root := 'api/v1';
!
!// Client
!Client := TRestHttpClientSocket.Create('server', '8080',
!  TOrmModel.Create([], 'api/v1'));
{}
:  Error Handling
{}
Standardize error responses:
{}
${
$  "errorCode": 400,
$  "errorText": "Invalid parameter: n1 must be positive"
$}
{}
Handle on client:
$async function callService(method: string, params: any): Promise<any> {
$  const response = await fetch(`${baseUrl}/${method}?${new URLSearchParams(params)}`);
$  const data = await response.json();
$
$  if (data.errorCode) {
$    throw new Error(`${data.errorCode}: ${data.errorText}`);
$  }
$
$  return data.result;
$}
{}
:  Security
{}
1. {\b Always use @*HTTPS@} in production
2. {\b Validate input} on server side
3. {\b Use authentication} for sensitive operations
4. {\b Rate limiting} to prevent abuse
5. {\b CORS headers} for browser clients:
{}
!HttpServer.AccessControlAllowOrigin := '*'; // Or specific origins
{}
: Summary
{}
mORMot 2's cross-platform capabilities:
{}
- {\b Native support}: Same code compiles on Windows, Linux, macOS, Android
- {\b Code generation}: Mustache-based templates for any target language
- {\b Standard protocols}: HTTP/JSON for universal compatibility
- {\b OpenAPI integration}: Generate documentation and client SDKs
- {\b WebSocket support}: Bidirectional communication across platforms
- {\b Mobile-ready}: Works with Delphi FireMonkey and FPC
{}
The framework's clean @*REST@/JSON protocol means any HTTP client can consume mORMot services, while native Pascal clients get the full type-safe experience with automatic stub generation.
{}

; === mORMot2-SAD-Chapter-18.md ===
; Converted from Markdown - Chapter 18
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:18The MVC Pattern
{}
{\i Separating Concerns for Better Architecture}
{}
The Model-View-Controller (@*MVC@) pattern separates application concerns into three interconnected components. m@*ORM@ot 2 provides a complete MVC implementation for both desktop and web applications, with the Mustache template engine as its primary view technology.
{}
:1801 MVC Architecture Overview
{}
:  The Three Components
{}
|%15%34%51
|\b Component|Responsibility|mORMot Implementation\b0
|{\b Model}|Data and business logic|{\f1\fs20 TOrm} classes, {\f1\fs20 TOrmModel}, {\f1\fs20 TRest}
|{\b View}|Presentation layer|Mustache templates ({\f1\fs20 .html}), Desktop UI
|{\b Controller}|User input handling|{\f1\fs20 IMvcApplication} interface methods
|%
{}
:  Benefits of MVC
{}
- {\b Separation of concerns}: Each component has a single responsibility
- {\b Testability}: Logic can be tested without UI
- {\b Reusability}: Same model for different views
- {\b Maintainability}: Changes in one layer don't affect others
- {\b Team collaboration}: Designers work on views, developers on logic
{}
:  mORMot's MVC Stack
{}
$┌──────────────────────────────────────────────┐
$│                    View                      │
$│  Mustache templates (.html) or Desktop UI    │
$├──────────────────────────────────────────────┤
$│                 Controller                   │
$│  IMvcApplication interface implementation    │
$├──────────────────────────────────────────────┤
$│                   Model                      │
$│     TOrm classes + TRest ORM/SOA             │
$└──────────────────────────────────────────────┘
{}
:1802 The Model Layer
{}
:  ORM as the Model
{}
In mORMot, the Model is your ORM classes and the {\f1\fs20 TOrmModel}:
{}
!type
!  TOrmAuthor = class(TOrm)
!  private
!    fName: RawUtf8;
!    fEmail: RawUtf8;
!  published
!    property Name: RawUtf8 index 100 read fName write fName;
!    property Email: RawUtf8 index 100 read fEmail write fEmail;
!  end;
!
!  TOrmArticle = class(TOrmTimestamped)
!  private
!    fTitle: RawUtf8;
!    fContent: RawUtf8;
!    fAuthor: TOrmAuthor;
!    fPublished: Boolean;
!  published
!    property Title: RawUtf8 index 200 read fTitle write fTitle;
!    property Content: RawUtf8 read fContent write fContent;
!    property Author: TOrmAuthor read fAuthor write fAuthor;
!    property Published: Boolean read fPublished write fPublished;
!  end;
!
!function CreateBlogModel: TOrmModel;
!begin
!  Result := TOrmModel.Create([TOrmAuthor, TOrmArticle], 'blog');
!end;
{}
:  Model Best Practices
{}
1. {\b Keep models focused}: Each {\f1\fs20 TOrm} class represents one entity
2. {\b Use class hierarchy}: Share common properties via inheritance
3. {\b Define indexes}: Override {\f1\fs20 InitializeTable} for performance
4. {\b Add validation}: Use {\f1\fs20 AddFilterNotVoidText} and similar methods
5. {\b Document relationships}: One-to-many, many-to-many via properties
{}
!class procedure TOrmArticle.InitializeTable(const Server: IRestOrmServer;
!  const FieldName: RawUtf8; Options: TOrmInitializeTableOptions);
!begin
!  inherited;
!  if (FieldName = '') or (FieldName = 'Author') then
!    Server.CreateSqlIndex(TOrmArticle, 'Author', False);
!end;
{}
:1803 The View Layer
{}
mORMot provides two view technologies:
{}
:  Desktop Views (RTTI-based)
{}
For desktop applications, UI can be generated from @*RTTI@:
{}
!type
!  TBlogAction = (
!    baNewArticle,
!    baEditArticle,
!    baDeleteArticle,
!    baQuit
!  );
!
!const
!  ToolbarActions: array[0..1] of set of TBlogAction = (
!    [baNewArticle, baEditArticle, baDeleteArticle],
!    [baQuit]
!  );
{}
Benefits:
- {\b Camel Case to labels}: {\f1\fs20 baNewArticle} becomes "New Article"
- {\b Automatic i18n}: Labels can be translated
- {\b Type safety}: Compiler checks action names
- {\b Code-first}: UI defined in code, not visual designer
{}
:  Web Views (Mustache Templates)
{}
For web applications, Mustache templates provide logic-less rendering:
{}
$<!-- ArticleView.html -->
$<article>
$  <h1>{{Article.Title}}</h1>
$  <p class="meta">By {{Author.Name}} on {{Article.CreatedAt}}</p>
$  <div class="content">
$    {{{Article.Content}}}
$  </div>
$
$  {{#WithComments}}
$  <section class="comments">
$    <h2>Comments</h2>
$    {{#Comments}}
$    <div class="comment">
$      <strong>{{Title}}</strong>
$      <p>{{Content}}</p>
$    </div>
$    {{/Comments}}
$    {{^Comments}}
$    <p>No comments yet.</p>
$    {{/Comments}}
$  </section>
$  {{/WithComments}}
$</article>
{}
:1804 The Mustache Template Engine
{}
:  Why Mustache?
{}
Mustache is a {\b logic-less} template system:
- No {\f1\fs20 if} statements or loops in templates
- Data context determines what renders
- Clean separation of logic and presentation
- Same templates work client-side (JavaScript) and server-side
{}
:  Basic Syntax
{}
|%8%92
|\b Tag|Purpose\b0
|{\f1\fs20 {{variable}}}|HTML-escaped output
|{\f1\fs20 {{{variable}}}}|Unescaped output (raw HTML)
|{\f1\fs20 {{#section}}...{{/section}}}|Section (conditional/loop)
|{\f1\fs20 {{^section}}...{{/section}}}|Inverted section (if false/empty)
|{\f1\fs20 {{! comment }}}|Comment (not rendered)
|{\f1\fs20 {{> partial}}}|Include partial template
|%
{}
:  Variables
{}
$Hello {{name}}!
$You have {{count}} messages.
{}
With context:
${"name": "John", "count": 5}
{}
Renders:
!Hello John!
!You have 5 messages.
{}
:  Sections
{}
Sections render based on the truthiness of the key:
{}
${{#hasMessages}}
$  <ul>
$  {{#messages}}
$    <li>{{subject}}</li>
$  {{/messages}}
$  </ul>
${{/hasMessages}}
$
${{^hasMessages}}
$  <p>No messages.</p>
${{/hasMessages}}
{}
{\b Section behavior:}
- {\f1\fs20 false} or empty array {\f1\fs20 []}: Block not rendered
- Non-false value: Block rendered once (context switches to value)
- Non-empty array: Block rendered for each item
{}
:  mORMot Extensions
{}
mORMot adds useful features to standard Mustache:
{}
|%8%92
|\b Tag|Description\b0
|{\f1\fs20 {{.}}}|Current context value
|{\f1\fs20 {{-index}}}|Current iteration index (1-based)
|{\f1\fs20 {{-index0}}}|Current iteration index (0-based)
|{\f1\fs20 {{#-first}}...{{/-first}}}|First item in loop
|{\f1\fs20 {{#-last}}...{{/-last}}}|Last item in loop
|{\f1\fs20 {{#-odd}}...{{/-odd}}}|Odd items (for zebra striping)
|{\f1\fs20 {{<partial}}...{{/partial}}}|Inline partial definition
|{\f1\fs20 {{"text}}}|Translatable text
|{\f1\fs20 {{helperName value}}}|Expression helpers
|%
{}
:  Expression Helpers
{}
Register helpers for common transformations:
{}
!// Built-in helpers
!{{DateTimeToText Article.CreatedAt}}
!{{TimeLogToText Article.ModifiedAt}}
!{{EnumToCaption Article.Status}}
!{{BlobToBase64 Article.Image}}
!
!// Custom helper registration
!TSynMustache.HelpersGetStandardList.Add(
!  'FormatCurrency',
!  procedure(const Value: variant; out Result: variant)
!  begin
!    Result := FormatFloat('$#,##0.00', Value);
!  end
!);
{}
:  ORM Integration
{}
Register ORM classes as expression helpers:
{}
!RegisterExpressionHelpersForTables(Views, RestServer, [TOrmAuthor, TOrmArticle]);
{}
Then in templates:
${{#TOrmAuthor Article.AuthorID}}
$  Author: {{Name}} ({{Email}})
${{/TOrmAuthor Article.AuthorID}}
{}
The {\f1\fs20 TOrmAuthor} helper automatically loads the record by ID.
{}
:1805 The Controller Layer
{}
:  Defining Commands
{}
The Controller is defined as an interface:
{}
!type
!  IMvcApplication = interface(IInvokable)
!    ['{C48718BF-861B-448A-B593-8012DB51E15D}']
!    procedure Default(var Scope: variant);
!    procedure Error(var Msg: RawUtf8; var Scope: variant);
!  end;
!
!  IBlogApplication = interface(IMvcApplication)
!    ['{12345678-1234-1234-1234-123456789ABC}']
!    procedure ArticleView(ID: Integer; var WithComments: Boolean;
!      out Article: TOrmArticle; out Author: variant; out Comments: TObjectList);
!    procedure AuthorView(var ID: Integer; out Author: TOrmAuthor;
!      out Articles: variant);
!    function Login(const LogonName, Password: RawUtf8): TMvcAction;
!    function Logout: TMvcAction;
!  end;
{}
:  Parameter Directions
{}
|%25%75
|\b Direction|Meaning\b0
|{\f1\fs20 const}|Input only (from URL/form)
|{\f1\fs20 var}|Input and output
|{\f1\fs20 out}|Output only (to view)
|{\f1\fs20 function: {\f1\fs20 TMvcAction}}|Redirect action
|%
{}
:  URI Mapping
{}
Methods map to URIs automatically:
{}
|%67%33
|\b Method|URI\b0
|{\f1\fs20 Default}|{\f1\fs20 /blog/default}
|{\f1\fs20 Error}|{\f1\fs20 /blog/error}
|{\f1\fs20 ArticleView}|{\f1\fs20 /blog/articleView?id=123&withComments=true}
|{\f1\fs20 Login}|{\f1\fs20 /blog/login?logonName=john&password=xxx}
|%
{}
:  Implementing the Controller
{}
!type
!  TBlogApplication = class(TMvcApplicationRest, IBlogApplication)
!  public
!    procedure Start(aRestModel: TRest; aInterface: PRttiInfo); override;
!    procedure Default(var Scope: variant);
!    procedure ArticleView(ID: Integer; var WithComments: Boolean;
!      out Article: TOrmArticle; out Author: variant; out Comments: TObjectList);
!    function Login(const LogonName, Password: RawUtf8): TMvcAction;
!  end;
!
!procedure TBlogApplication.ArticleView(ID: Integer; var WithComments: Boolean;
!  out Article: TOrmArticle; out Author: variant; out Comments: TObjectList);
!begin
!  RestModel.Orm.Retrieve(ID, Article);
!  if Article.ID = 0 then
!    raise EMvcApplication.CreateGotoError(HTTP_NOTFOUND);
!
!  Author := RestModel.Orm.RetrieveDocVariant(
!    TOrmAuthor, 'ID=?', [Article.Author.ID], 'Name,Email');
!
!  if WithComments then
!  begin
!    Comments.Free;
!    Comments := RestModel.Orm.RetrieveList(TOrmComment, 'Article=?', [ID]);
!  end;
!end;
!
!function TBlogApplication.Login(const LogonName, Password: RawUtf8): TMvcAction;
!begin
!  if ValidateCredentials(LogonName, Password) then
!  begin
!    CurrentSession.User := LogonName;
!    Result.RedirectToMethodName := 'Default';
!  end
!  else
!    raise EMvcApplication.CreateGotoError('Invalid credentials');
!end;
{}
:  TMvcAction for Redirects
{}
Methods returning {\f1\fs20 TMvcAction} don't render a view directly:
{}
!type
!  TMvcAction = record
!    RedirectToMethodName: RawUtf8;
!    RedirectToMethodParameters: RawUtf8;
!    ReturnedStatus: Cardinal;
!  end;
!
!function TBlogApplication.Logout: TMvcAction;
!begin
!  CurrentSession.Clear;
!  Result.RedirectToMethodName := 'Default';
!  // or: Result.ReturnedStatus := HTTP_TEMPORARYREDIRECT;
!end;
{}
:  Error Handling
{}
Raise {\f1\fs20 EMvcApplication} to redirect to error page:
{}
!// Redirect to error page with message
!raise EMvcApplication.CreateGotoError('Article not found');
!
!// Redirect to error page with HTTP status
!raise EMvcApplication.CreateGotoError(HTTP_NOTFOUND);
!
!// Redirect to another method
!raise EMvcApplication.CreateGotoMethod('Login');
{}
:1806 View Templates
{}
:  Template Location
{}
By default, templates are in a {\f1\fs20 Views} subfolder:
{}
!MyApp/
$├── MyApp.exe
$└── Views/
$    ├── Default.html
$    ├── Error.html
$    ├── ArticleView.html
$    ├── AuthorView.html
$    └── _partials/
$        ├── header.html
$        └── footer.html
{}
:  Template Structure
{}
$<!-- Default.html -->
${{>header}}
$
$<main>
$  <h1>{{Scope.Title}}</h1>
$
$  {{#Scope.Articles}}
$  <article>
$    <h2><a href="/blog/articleView?id={{ID}}">{{Title}}</a></h2>
$    <p>{{Abstract}}</p>
$    <small>{{DateTimeToText CreatedAt}}</small>
$  </article>
$  {{/Scope.Articles}}
$
$  {{^Scope.Articles}}
$  <p>No articles published yet.</p>
$  {{/Scope.Articles}}
$</main>
$
${{>footer}}
{}
:  Partials
{}
Define reusable template fragments:
{}
$<!-- _partials/header.html -->
$<!DOCTYPE html>
$<html>
$<head>
$  <title>{{Main.Title}} - My Blog</title>
$  <link rel="stylesheet" href="/static/style.css">
$</head>
$<body>
$  <nav>
$    <a href="/blog/default">Home</a>
$    {{#Main.User}}
$    <a href="/blog/logout">Logout ({{.}})</a>
$    {{/Main.User}}
$    {{^Main.User}}
$    <a href="/blog/login">Login</a>
$    {{/Main.User}}
$  </nav>
{}
:  Static Files
{}
Serve static content alongside templates:
{}
!// Enable static file serving
!fMainRunner := TMvcRunOnRestServer.Create(Self, '', Server, 'blog', nil,
!  [publishMvcInfo, publishStatic, bypassAuthentication]);
{}
Static files served from {\f1\fs20 .static} subfolder at {\f1\fs20 /blog/.static/*}.
{}
:1807 Session Management
{}
:  Cookie-Based Sessions
{}
MVC applications use cookie sessions:
{}
!type
!  TMvcSessionWithRestServer = class(TMvcSessionWithCookies)
!  protected
!    function GetCookie(out Value: PUtf8Char): Integer; override;
!    procedure SetCookie(const Value: RawUtf8); override;
!  end;
{}
:  Session Data
{}
Access session data in controllers:
{}
!procedure TBlogApplication.Default(var Scope: variant);
!begin
!  // Read session data
!  if CurrentSession['LoggedIn'] then
!    Scope := _ObjFast(['User', CurrentSession['UserName']]);
!end;
!
!function TBlogApplication.Login(const LogonName, Password: RawUtf8): TMvcAction;
!begin
!  if ValidateUser(LogonName, Password) then
!  begin
!    CurrentSession['LoggedIn'] := True;
!    CurrentSession['UserName'] := LogonName;
!    CurrentSession['UserID'] := GetUserID(LogonName);
!    Result.RedirectToMethodName := 'Default';
!  end;
!end;
{}
:1808 Debugging MVC Applications
{}
:  The mvc-info Page
{}
Access {\f1\fs20 /blog/mvc-info} to see:
- All registered commands
- Parameter types and directions
- View data context structure
{}
!/blog/Default?Scope=..[variant]..
!/blog/Error?Msg=..[string]..&Scope=..[variant]..
!/blog/ArticleView?ID=..[integer]..&WithComments=..[boolean]..
!
!ArticleView context:
!{{WithComments}}: boolean
!{{Article}}: TOrmArticle
!{{Author}}: variant
!{{Comments}}: TObjectList
{}
:  JSON Context View
{}
Append {\f1\fs20 /json} to any URL to see the raw data context:
{}
!/blog/articleView?id=123           → HTML page
!/blog/articleView/json?id=123      → JSON data context
{}
: Summary
{}
The MVC pattern in mORMot 2 provides:
{}
- {\b Model}: {\f1\fs20 TOrm} classes with full ORM capabilities
- {\b View}: Mustache templates for logic-less rendering
- {\b Controller}: Interface methods mapped to URIs
{}
Key features:
- {\b Automatic routing}: Methods become URIs
- {\b Type-safe parameters}: Compile-time checking
- {\b Expression helpers}: Transform data in templates
- {\b Session management}: Cookie-based state
- {\b Debug tools}: mvc-info and @*JSON@ context views
{}
This architecture cleanly separates concerns while providing the power of mORMot's ORM and @*SOA@ capabilities.
{}

; === mORMot2-SAD-Chapter-19.md ===
; Converted from Markdown - Chapter 19
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:19MVC/MVVM Web Applications
{}
{\i Building Complete Web Applications with m@*ORM@ot}
{}
This chapter provides a practical guide to building @*MVC@/@*MVVM@ web applications using mORMot 2. We'll walk through the blog sample application structure, demonstrating patterns you can apply to your own projects.
{}
:1901 Application Architecture
{}
:  MVVM in mORMot
{}
mORMot uses a hybrid MVC/MVVM pattern:
{}
|%29%12%59
|\b Component|File|mORMot Class\b0
|{\b Model}|{\f1\fs20 MVCModel.pas}|{\f1\fs20 TOrm} classes, {\f1\fs20 TOrmModel}
|{\b View}|{\f1\fs20 *.html}|Mustache templates
|{\b ViewModel}|{\f1\fs20 MVCViewModel.pas}|{\f1\fs20 IMvcApplication} interface
|%
{}
The ViewModel acts as both Controller (handling requests) and ViewModel (preparing data for views).
{}
:  Project Structure
{}
!BlogServer/
$├── BlogServer.dpr          # Main program
$├── MVCModel.pas            # ORM Model definitions
$├── MVCViewModel.pas        # Controller/ViewModel
$└── Views/
$    ├── Default.html        # Home page
$    ├── Error.html          # Error page
$    ├── ArticleView.html    # Single article
$    ├── AuthorView.html     # Author profile
$    ├── Login.html          # Login form
$    └── .static/
$        ├── blog.css        # Stylesheets
$        └── script.js       # Client scripts
{}
:1902 Defining the Model
{}
:  Entity Classes
{}
!unit MVCModel;
!
!interface
!
!uses
!  mormot.core.base,
!  mormot.orm.core;
!
!type
!  /// Base class with common content fields
!  TOrmContent = class(TOrmTimestamped)
!  private
!    fTitle: RawUtf8;
!    fContent: RawUtf8;
!    fAuthor: TOrmAuthor;
!    fAuthorName: RawUtf8;  // Denormalized for performance
!  published
!    property Title: RawUtf8 index 80 read fTitle write fTitle;
!    property Content: RawUtf8 read fContent write fContent;
!    property Author: TOrmAuthor read fAuthor write fAuthor;
!    property AuthorName: RawUtf8 index 50 read fAuthorName write fAuthorName;
!  end;
!
!  /// Blog article
!  TOrmArticle = class(TOrmContent)
!  private
!    fAbstract: RawUtf8;
!    fPublishedMonth: Integer;
!    fTags: TIntegerDynArray;
!  public
!    class function CurrentPublishedMonth: Integer;
!    class procedure InitializeTable(const Server: IRestOrmServer;
!      const FieldName: RawUtf8; Options: TOrmInitializeTableOptions); override;
!  published
!    property Abstract: RawUtf8 index 1024 read fAbstract write fAbstract;
!    property PublishedMonth: Integer read fPublishedMonth write fPublishedMonth;
!    property Tags: TIntegerDynArray index 1 read fTags write fTags;
!  end;
!
!  /// Comment on an article
!  TOrmComment = class(TOrmContent)
!  private
!    fArticle: TOrmArticle;
!  published
!    property Article: TOrmArticle read fArticle write fArticle;
!  end;
!
!  /// Blog author
!  TOrmAuthor = class(TOrm)
!  private
!    fLogonName: RawUtf8;
!    fPasswordHash: RawUtf8;
!    fFirstName: RawUtf8;
!    fFamilyName: RawUtf8;
!    fEmail: RawUtf8;
!  published
!    property LogonName: RawUtf8 index 30 read fLogonName write fLogonName;
!    property PasswordHash: RawUtf8 index 64 read fPasswordHash write fPasswordHash;
!    property FirstName: RawUtf8 index 50 read fFirstName write fFirstName;
!    property FamilyName: RawUtf8 index 50 read fFamilyName write fFamilyName;
!    property Email: RawUtf8 index 100 read fEmail write fEmail;
!  end;
!
!  /// Tag for categorizing articles
!  TOrmTag = class(TOrm)
!  private
!    fIdent: RawUtf8;
!  published
!    property Ident: RawUtf8 index 30 read fIdent write fIdent;
!  end;
!
!  /// Full-text search index
!  TOrmArticleSearch = class(TOrmFts5)
!  private
!    fTitle: RawUtf8;
!    fAbstract: RawUtf8;
!    fContent: RawUtf8;
!  published
!    property Title: RawUtf8 read fTitle write fTitle;
!    property Abstract: RawUtf8 read fAbstract write fAbstract;
!    property Content: RawUtf8 read fContent write fContent;
!  end;
!
!function CreateBlogModel: TOrmModel;
!
!implementation
!
!class procedure TOrmArticle.InitializeTable(const Server: IRestOrmServer;
!  const FieldName: RawUtf8; Options: TOrmInitializeTableOptions);
!begin
!  inherited;
!  if (FieldName = '') or (FieldName = 'PublishedMonth') then
!    Server.CreateSqlIndex(TOrmArticle, 'PublishedMonth', False);
!end;
!
!class function TOrmArticle.CurrentPublishedMonth: Integer;
!var
!  Y, M, D: Word;
!begin
!  DecodeDate(Date, Y, M, D);
!  Result := Y * 12 + M;
!end;
!
!function CreateBlogModel: TOrmModel;
!begin
!  Result := TOrmModel.Create(
!    [TOrmAuthor, TOrmTag, TOrmArticle, TOrmComment, TOrmArticleSearch],
!    'blog');
!  // Validation filters
!  TOrmArticle.AddFilterNotVoidText(['Title', 'Content']);
!  TOrmComment.AddFilterNotVoidText(['Title', 'Content']);
!  TOrmTag.AddFilterNotVoidText(['Ident']);
!  // FTS without content (external content table)
!  Result.Props[TOrmArticleSearch].Fts5WithoutContent(TOrmArticle);
!end;
!
!end.
{}
:  Model Design Decisions
{}
Key patterns demonstrated:
{}
|%38%25%37
|\b Pattern|Example|Benefit\b0
|{\b Inheritance}|{\f1\fs20 TOrmContent} base class|Shared fields
|{\b Denormalization}|{\f1\fs20 AuthorName} in content|Avoid joins
|{\b Indexed fields}|{\f1\fs20 PublishedMonth}|Fast queries
|{\b Dynamic arrays}|{\f1\fs20 Tags: {\f1\fs20 TIntegerDynArray}}|No pivot table
|{\b FTS5 integration}|{\f1\fs20 TOrmArticleSearch}|Full-text search
|%
{}
:1903 Defining the ViewModel/Controller
{}
:  Interface Definition
{}
!unit MVCViewModel;
!
!interface
!
!uses
!  mormot.core.base,
!  mormot.core.variants,
!  mormot.core.mvc,
!  mormot.rest.mvc,
!  mormot.orm.core,
!  contnrs,
!  MVCModel;
!
!type
!  IBlogApplication = interface(IMvcApplication)
!    ['{73B27C06-9DB9-45A0-BFCD-D23E5C62C113}']
!    /// View single article with optional comments
!    procedure ArticleView(ID: Integer; var WithComments: Boolean;
!      Direction: Integer; out Article: TOrmArticle; out Author: variant;
!      out Comments: TObjectList);
!    /// View author profile
!    procedure AuthorView(var ID: Integer; out Author: TOrmAuthor;
!      out Articles: variant);
!    /// Login page
!    procedure LoginForm(out Msg: RawUtf8);
!    /// Process login
!    function Login(const LogonName, PlainPassword: RawUtf8): TMvcAction;
!    /// Logout
!    function Logout: TMvcAction;
!    /// Article editor
!    procedure ArticleEdit(var ID: Integer; const Title, Content: RawUtf8;
!      const ValidationError: variant; out Article: TOrmArticle);
!    /// Save article
!    function ArticleCommit(ID: Integer;
!      const Title, Content: RawUtf8): TMvcAction;
!  end;
{}
:  Controller Implementation
{}
!type
!  TBlogApplication = class(TMvcApplicationRest, IBlogApplication)
!  protected
!    fBlogInfo: variant;
!    fTagsLookup: variant;
!    procedure FlushCache;
!    function GetLoggedAuthor: TOrmAuthor;
!  public
!    procedure Start(aRestModel: TRest; aInterface: PRttiInfo); override;
!    // IMvcApplication
!    procedure Default(var Scope: variant);
!    procedure Error(var Msg: RawUtf8; var Scope: variant);
!    // IBlogApplication
!    procedure ArticleView(ID: Integer; var WithComments: Boolean;
!      Direction: Integer; out Article: TOrmArticle; out Author: variant;
!      out Comments: TObjectList);
!    procedure AuthorView(var ID: Integer; out Author: TOrmAuthor;
!      out Articles: variant);
!    procedure LoginForm(out Msg: RawUtf8);
!    function Login(const LogonName, PlainPassword: RawUtf8): TMvcAction;
!    function Logout: TMvcAction;
!    procedure ArticleEdit(var ID: Integer; const Title, Content: RawUtf8;
!      const ValidationError: variant; out Article: TOrmArticle);
!    function ArticleCommit(ID: Integer;
!      const Title, Content: RawUtf8): TMvcAction;
!  end;
{}
:  Method Implementations
{}
!procedure TBlogApplication.Start(aRestModel: TRest; aInterface: PRttiInfo);
!begin
!  inherited Start(aRestModel, TypeInfo(IBlogApplication));
!  FlushCache;
!end;
!
!procedure TBlogApplication.Default(var Scope: variant);
!var
!  lastID: TID;
!begin
!  // Cache blog info
!  if VarIsEmpty(fBlogInfo) then
!    fBlogInfo := RestModel.Orm.RetrieveDocVariant(
!      TOrmBlogInfo, 'ID=?', [1], 'Title,Language,Description');
!
!  // Get recent articles
!  lastID := RestModel.Orm.TableMaxID(TOrmArticle);
!  Scope := _ObjFast([
!    'Info', fBlogInfo,
!    'Articles', RestModel.Orm.RetrieveDocVariantArray(
!      TOrmArticle, '', 'ID>? order by ID desc limit 20',
!      [lastID - 100], 'ID,Title,Abstract,AuthorName,CreatedAt')
!  ]);
!end;
!
!procedure TBlogApplication.ArticleView(ID: Integer; var WithComments: Boolean;
!  Direction: Integer; out Article: TOrmArticle; out Author: variant;
!  out Comments: TObjectList);
!var
!  newID: TID;
!const
!  WHERE: array[1..2] of RawUtf8 = (
!    'ID<? order by ID desc',
!    'ID>? order by ID'
!  );
!begin
!  // Navigate to previous/next article
!  if Direction in [1, 2] then
!    if RestModel.Orm.OneFieldValue(TOrmArticle, 'ID', WHERE[Direction],
!         [], [ID], newID) and (newID <> 0) then
!      ID := newID;
!
!  // Load article
!  RestModel.Orm.Retrieve(ID, Article);
!  if Article.ID = 0 then
!    raise EMvcApplication.CreateGotoError(HTTP_NOTFOUND);
!
!  // Load author (as variant for flexibility)
!  Author := RestModel.Orm.RetrieveDocVariant(
!    TOrmAuthor, 'ID=?', [Article.Author.ID], 'FirstName,FamilyName');
!
!  // Optionally load comments
!  if WithComments then
!  begin
!    Comments.Free;
!    Comments := RestModel.Orm.RetrieveList(
!      TOrmComment, 'Article=? order by ID', [Article.ID]);
!  end;
!end;
!
!function TBlogApplication.Login(const LogonName, PlainPassword: RawUtf8): TMvcAction;
!var
!  Author: TOrmAuthor;
!begin
!  Author := TOrmAuthor.Create(RestModel.Orm, 'LogonName=?', [LogonName]);
!  try
!    if (Author.ID = 0) or
!       not PasswordHashMatch(PlainPassword, Author.PasswordHash) then
!      raise EMvcApplication.CreateGotoError('Invalid credentials');
!
!    // Store in session
!    CurrentSession['AuthorID'] := Author.ID;
!    CurrentSession['LogonName'] := Author.LogonName;
!
!    Result.RedirectToMethodName := 'Default';
!  finally
!    Author.Free;
!  end;
!end;
!
!function TBlogApplication.Logout: TMvcAction;
!begin
!  CurrentSession.Clear;
!  Result.RedirectToMethodName := 'Default';
!end;
{}
:1904 View Templates
{}
:  Main Layout
{}
$<!-- Default.html -->
$<!DOCTYPE html>
$<html lang="{{Info.Language}}">
$<head>
$  <meta charset="utf-8">
$  <meta name="viewport" content="width=device-width, initial-scale=1">
$  <title>{{Info.Title}}</title>
$  <link rel="stylesheet" href="/.static/blog.css">
$</head>
$<body>
$  <header>
$    <h1><a href="/blog/default">{{Info.Title}}</a></h1>
$    <nav>
$      {{#Main.LogonName}}
$      <span>Welcome, {{.}}</span>
$      <a href="/blog/articleEdit">New Article</a>
$      <a href="/blog/logout">Logout</a>
$      {{/Main.LogonName}}
$      {{^Main.LogonName}}
$      <a href="/blog/loginForm">Login</a>
$      {{/Main.LogonName}}
$    </nav>
$  </header>
$
$  <main>
$    <p>{{Info.Description}}</p>
$
$    {{#Articles}}
$    <article class="summary">
$      <h2><a href="/blog/articleView?id={{ID}}">{{Title}}</a></h2>
$      <p class="meta">By {{AuthorName}} on {{DateTimeToText CreatedAt}}</p>
$      <p>{{Abstract}}</p>
$    </article>
$    {{/Articles}}
$
$    {{^Articles}}
$    <p>No articles published yet.</p>
$    {{/Articles}}
$  </main>
$
$  <footer>
$    <p>&copy; {{Info.Title}}</p>
$  </footer>
$</body>
$</html>
{}
:  Article View
{}
$<!-- ArticleView.html -->
$<!DOCTYPE html>
$<html>
$<head>
$  <title>{{Article.Title}}</title>
$  <link rel="stylesheet" href="/.static/blog.css">
$</head>
$<body>
$  <header>
$    <nav>
$      <a href="/blog/default">&larr; Back to Home</a>
$    </nav>
$  </header>
$
$  <main>
$    <article>
$      <h1>{{Article.Title}}</h1>
$      <p class="meta">
$        By <a href="/blog/authorView?id={{Article.Author}}">
$          {{Author.FirstName}} {{Author.FamilyName}}
$        </a>
$        on {{DateTimeToText Article.CreatedAt}}
$      </p>
$
$      <div class="content">
$        {{{Article.Content}}}
$      </div>
$
$      <nav class="pagination">
$        <a href="/blog/articleView?id={{Article.ID}}&direction=1&withComments={{WithComments}}">
$          &larr; Previous
$        </a>
$        <a href="/blog/articleView?id={{Article.ID}}&direction=2&withComments={{WithComments}}">
$          Next &rarr;
$        </a>
$      </nav>
$    </article>
$
$    <section class="comments">
$      {{#WithComments}}
$      <h2>Comments</h2>
$      {{#Comments}}
$      <div class="comment {{#-odd}}odd{{/-odd}}">
$        <h3>{{Title}}</h3>
$        <p class="meta">By {{AuthorName}} on {{DateTimeToText CreatedAt}}</p>
$        <p>{{Content}}</p>
$      </div>
$      {{/Comments}}
$      {{^Comments}}
$      <p>No comments yet.</p>
$      {{/Comments}}
$      <a href="/blog/articleView?id={{Article.ID}}&withComments=false" class="btn">
$        Hide Comments
$      </a>
$      {{/WithComments}}
$
$      {{^WithComments}}
$      <a href="/blog/articleView?id={{Article.ID}}&withComments=true#comments"
$         class="btn">
$        Show Comments
$      </a>
$      {{/WithComments}}
$    </section>
$  </main>
$</body>
$</html>
{}
:  Login Form
{}
$<!-- LoginForm.html -->
$<!DOCTYPE html>
$<html>
$<head>
$  <title>Login</title>
$  <link rel="stylesheet" href="/.static/blog.css">
$</head>
$<body>
$  <main class="login-page">
$    <h1>Login</h1>
$
$    {{#Msg}}
$    <div class="error">{{.}}</div>
$    {{/Msg}}
$
$    <form method="post" action="/blog/login">
$      <div class="field">
$        <label for="logonName">Username</label>
$        <input type="text" id="logonName" name="logonName" required autofocus>
$      </div>
$      <div class="field">
$        <label for="plainPassword">Password</label>
$        <input type="password" id="plainPassword" name="plainPassword" required>
$      </div>
$      <button type="submit">Login</button>
$    </form>
$
$    <p><a href="/blog/default">Back to Home</a></p>
$  </main>
$</body>
$</html>
{}
:1905 Hosting the Application
{}
:  Main Server Program
{}
!program BlogServer;
!
!{$APPTYPE CONSOLE}
!
!uses
!  mormot.core.base,
!  mormot.core.os,
!  mormot.orm.core,
!  mormot.rest.sqlite3,
!  mormot.rest.http.server,
!  mormot.rest.mvc,
!  MVCModel,
!  MVCViewModel;
!
!var
!  Model: TOrmModel;
!  Server: TRestServerDB;
!  Application: TBlogApplication;
!  HttpServer: TRestHttpServer;
!begin
!  Model := CreateBlogModel;
!  try
!    Server := TRestServerDB.Create(Model,
!      Executable.ProgramFilePath + 'blog.db3');
!    try
!      Server.DB.Synchronous := smNormal;
!      Server.DB.LockingMode := lmExclusive;
!      Server.CreateMissingTables;
!
!      Application := TBlogApplication.Create;
!      try
!        Application.Start(Server, TypeInfo(IBlogApplication));
!
!        // Publish MVC on /blog/*
!        TMvcRunOnRestServer.Create(Application,
!          Executable.ProgramFilePath + 'Views', Server, '',
!          nil, [publishMvcInfo, publishStatic, bypassAuthentication]);
!
!        HttpServer := TRestHttpServer.Create('8092', [Server], '+', useHttpAsync);
!        try
!          HttpServer.RootRedirectToUri('blog/default');
!
!          WriteLn('Blog server running on http://localhost:8092');
!          WriteLn('Press Enter to stop...');
!          ReadLn;
!        finally
!          HttpServer.Free;
!        end;
!      finally
!        Application.Free;
!      end;
!    finally
!      Server.Free;
!    end;
!  finally
!    Model.Free;
!  end;
!end.
{}
:  Integration Options
{}
|%28%72
|\b Option|Configuration\b0
|{\b Same server}|MVC + @*REST@ API on same port
|{\b Sub-URI}|{\f1\fs20 /api/{\i } for REST, {\f1\fs20 /blog/}} for MVC
|{\b Sub-domain}|{\f1\fs20 api.example.com}, {\f1\fs20 www.example.com}
|%
{}
Sub-domain configuration:
!HttpServer.DomainHostRedirect('api.example.com', 'root');
!HttpServer.DomainHostRedirect('www.example.com', 'root/blog');
!HttpServer.DomainHostRedirect('example.com', 'root/blog');
{}
:1906 Advanced Features
{}
:  CSRF Protection
{}
mORMot includes built-in CSRF protection:
{}
$<form method="post" action="/blog/articleCommit">
$  <input type="hidden" name="__csrf" value="{{Main.CsrfToken}}">
$  <!-- form fields -->
$</form>
{}
:  Full-Text Search
{}
!procedure TBlogApplication.Search(const Query: RawUtf8;
!  out Results: variant);
!begin
!  Results := RestModel.Orm.FtsMatch(
!    TOrmArticleSearch, 'Title,Abstract,Content', Query,
!    'ID,Title,Abstract', 20);
!end;
{}
:  Caching
{}
!procedure TBlogApplication.Default(var Scope: variant);
!begin
!  // Cache expensive queries
!  if VarIsEmpty(fCachedInfo) then
!  begin
!    fCachedInfo := RestModel.Orm.RetrieveDocVariant(...);
!    fCacheTime := GetTickCount64;
!  end
!  else if GetTickCount64 - fCacheTime > 60000 then  // 1 minute
!    FlushCache;
!
!  Scope := fCachedInfo;
!end;
{}
:  Responsive Design
{}
Use Bootstrap or similar in templates:
{}
$<link rel="stylesheet"
$      href="https://cdn.jsdelivr.net/npm/bootstrap@5/dist/css/bootstrap.min.css">
$
$<div class="container">
$  <div class="row">
$    <main class="col-md-8">
$      {{#Articles}}...{{/Articles}}
$    </main>
$    <aside class="col-md-4">
$      {{#Tags}}...{{/Tags}}
$    </aside>
$  </div>
$</div>
{}
:1907 Testing MVC Applications
{}
:  Unit Testing Controllers
{}
!procedure TBlogTest.TestArticleView;
!var
!  App: TBlogApplication;
!  Article: TOrmArticle;
!  Author: variant;
!  Comments: TObjectList;
!  WithComments: Boolean;
!begin
!  App := TBlogApplication.Create;
!  try
!    App.Start(TestServer, TypeInfo(IBlogApplication));
!
!    Article := nil;
!    Comments := TObjectList.Create;
!    try
!      WithComments := True;
!      App.ArticleView(1, WithComments, 0, Article, Author, Comments);
!
!      Check(Article.ID = 1);
!      Check(Article.Title <> '');
!      Check(not VarIsEmpty(Author));
!    finally
!      Article.Free;
!      Comments.Free;
!    end;
!  finally
!    App.Free;
!  end;
!end;
{}
:  Integration Testing
{}
!procedure TBlogTest.TestWebPages;
!var
!  Client: THttpClientSocket;
!  Response: RawUtf8;
!begin
!  Client := THttpClientSocket.Create('localhost', '8092');
!  try
!    Check(Client.Get('/blog/default', Response) = HTTP_SUCCESS);
!    Check(PosEx('<article', Response) > 0);
!
!    Check(Client.Get('/blog/articleView?id=1', Response) = HTTP_SUCCESS);
!    Check(PosEx('</article>', Response) > 0);
!  finally
!    Client.Free;
!  end;
!end;
{}
: Summary
{}
Building MVC web applications with mORMot 2:
{}
1. {\b Model}: Define {\f1\fs20 TOrm} classes with proper relationships and indexes
2. {\b ViewModel}: Create interface with methods for each page/action
3. {\b Views}: Write Mustache templates with proper data binding
4. {\b Hosting}: Use {\f1\fs20 TMvcRunOnRestServer} to publish on @*HTTP@
{}
Key benefits:
- {\b Type safety}: Interface parameters checked at compile time
- {\b Separation}: Clean split between data, logic, and presentation
- {\b Performance}: Efficient ORM queries, caching support
- {\b Testability}: Controllers testable without HTTP
- {\b Flexibility}: Same data model for MVC and REST API
{}

; === mORMot2-SAD-Chapter-20.md ===
; Converted from Markdown - Chapter 20
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:20Hosting and Deployment
{}
{\i From Development to Production}
{}
This chapter covers deployment patterns for m@*ORM@ot 2 applications, from simple stand-alone executables to complex multi-server architectures with CDN integration.
{}
:2001 Platform Support
{}
:  Operating Systems
{}
mORMot 2 natively supports:
{}
|%33%21%46
|\b Platform|Compiler|Notes\b0
|Windows (32/64-bit)|Delphi, FPC|Full support including http.sys
|Linux (x86_64, aarch64)|Delphi 12+, FPC|Recommended for servers
|macOS (x86_64, aarch64)|Delphi, FPC|Development and servers
|FreeBSD|FPC|Server deployments
|Android|Delphi, FPC|Client applications
|%
{}
:  Resource Requirements
{}
mORMot applications are extremely efficient:
{}
|%15%85
|\b Component|Typical Requirement\b0
|{\b RAM}|50-200 MB for typical server
|{\b CPU}|Minimal; single-core sufficient for most workloads
|{\b Storage}|@*SQLite3@ database + application (~5-50 MB)
|{\b Network}|Standard @*HTTP@/@*HTTPS@ ports
|%
{}
Compared to traditional stacks ({\f1\fs20 IIS} + .NET + SQL Server), mORMot requires:
- {\b 10x less RAM}
- {\b Simpler configuration}
- {\b No additional dependencies}
{}
:2002 Deployment Patterns
{}
:  Stand-Alone Application
{}
The simplest deployment — a single executable:
{}
$┌─────────────────────────────────────┐
$│           Application               │
$│  ┌─────────┐  ┌─────────────────┐   │
$│  │ Client  │──│  Server (HTTP)  │   │
$│  │  Code   │  │  + ORM + SOA    │   │
$│  └─────────┘  └─────────────────┘   │
$│                     │               │
$│              ┌──────┴──────┐        │
$│              │  SQLite3    │        │
$│              │  Database   │        │
$│              └─────────────┘        │
$└─────────────────────────────────────┘
{}
Perfect for:
- Desktop applications with local data
- Development and testing
- Single-user scenarios
{}
!// In-process server access
!var
!  Server: TRestServerDB;
!  Client: TRestClientDB;
!begin
!  Server := TRestServerDB.Create(Model, 'data.db3');
!  Client := TRestClientDB.Create(Server);
!  // Client and server in same process
!end;
{}
:  Shared Server
{}
One server handling both ORM and @*SOA@:
{}
$┌──────────┐        ┌──────────┐
$│ Client 1 │───┐    │ Client 2 │
$│ (Delphi) │   │    │  (AJAX)  │
$└──────────┘   │    └──────────┘
$               │         │
$               ▼         ▼
$         ┌─────────────────────┐
$         │    HTTP Server      │
$         │  ┌───────────────┐  │
$         │  │   ORM + SOA   │  │
$         │  └───────┬───────┘  │
$         │          │          │
$         │    ┌─────┴─────┐    │
$         │    │  SQLite3  │    │
$         │    └───────────┘    │
$         └─────────────────────┘
{}
Suitable for:
- Small to medium applications
- Corporate intranets
- Single-location deployments
{}
:  Separated Services (DMZ)
{}
For security-sensitive deployments:
{}
!    Internet                    DMZ                    Internal Network
$       │                         │                           │
$┌──────┴──────┐           ┌──────┴──────┐            ┌───────┴───────┐
$│  AJAX/Web   │           │  Services   │            │     ORM       │
$│   Clients   │─────────▶ │   Server    │──────────▶ │    Server     │
$└─────────────┘           │  (Stateless)│            │  + Database   │
$                          └─────────────┘            └───────────────┘
$                                │
$                          ┌─────┴─────┐
$                          │  Firewall │
$                          └───────────┘
{}
Benefits:
- Database never exposed to Internet
- Services can be stateless (scalable)
- Clear security boundaries
{}
Implementation:
{}
!// Services server (in DMZ)
!Server := TRestServerFullMemory.Create(Model);
!Server.ServiceDefine(TMyService, [IMyService], sicShared);
!// Connect to internal ORM server
!Server.RemoteDataCreate(InternalOrmClient, TOrmArticle);
!
!// Internal ORM server
!OrmServer := TRestServerDB.Create(Model, 'data.db3');
{}
:  Microservices
{}
Multiple specialized servers:
{}
$┌─────────┐   ┌─────────┐   ┌─────────┐
$│ Client  │   │ Client  │   │ C│
$└────┬────┘   └────┬────┘   └────┬────┘
$     │             │             │
$     └──────┬──────┴──────┬──────┘
$            ▼             │
$     ┌──────────────┐     │
$     │   Gateway    │     │
$     │   Server     │     │
$     └──────┬───────┘     │
$            │             │
$     ┌──────┼──────┬──────┼──────┐
$     ▼      ▼      ▼      ▼      ▼
$┌────────┐ ┌────────┐ ┌────────┐
$│ Auth   │ │ Orders │ │ Reports│
$│ Service│ │ Service│ │ Service│
$└────────┘ └────────┘ └────────┘
{}
Each service:
- Has its own database
- Independently deployable
- Communicates via @*REST@/@*JSON@
{}
:2003 Windows Deployment
{}
:  Console Application
{}
Simplest deployment for development:
{}
!program MyServer;
!{$APPTYPE CONSOLE}
!begin
!  // Server initialization
!  WriteLn('Server running on http://localhost:8080');
!  ReadLn;  // Wait for Enter to stop
!end.
{}
:  Windows Service
{}
For production deployment:
{}
!program MyServerService;
!
!uses
!  mormot.app.daemon;
!
!type
!  TMyDaemon = class(TDaemon)
!  protected
!    fServer: TRestServerDB;
!    fHttp: TRestHttpServer;
!    procedure DoStart; override;
!    procedure DoStop; override;
!  end;
!
!procedure TMyDaemon.DoStart;
!begin
!  fServer := TRestServerDB.Create(Model, 'data.db3');
!  fHttp := TRestHttpServer.Create('8080', [fServer]);
!end;
!
!procedure TMyDaemon.DoStop;
!begin
!  fHttp.Free;
!  fServer.Free;
!end;
!
!begin
!  TDaemonService.Create(TMyDaemon, 'MyServer', 'My mORMot Server');
!  TDaemonService.RunAsService;
!end.
{}
Service management:
$:: Install service
$MyServerService.exe /install
$
$:: Start service
$net start MyServer
$
$:: Stop service
$net stop MyServer
$
$:: Uninstall service
$MyServerService.exe /uninstall
{}
:  HTTP.SYS Configuration
{}
For best Windows performance, use http.sys:
{}
!HttpServer := TRestHttpServer.Create('8080', [Server], '+',
!  useHttpApiRegisteringUri);  // Uses http.sys
{}
URL reservation (run as Administrator):
$netsh http add urlacl url=http://+:8080/ user=Everyone
{}
SSL certificate binding:
$netsh http add sslcert ipport=0.0.0.0:443 ^
$  certhash=YOUR_CERT_THUMBPRINT ^
$  appid={YOUR_APP_GUID}
{}
:2004 Linux Deployment
{}
:  Systemd Service
{}
Create {\f1\fs20 /etc/systemd/system/mormot-server.service}:
{}
$[Unit]
$Description=mORMot Server
$After=network.target
$
$[Service]
$Type=simple
$User=mormot
$Group=mormot
$WorkingDirectory=/opt/mormot
$ExecStart=/opt/mormot/myserver
$Restart=always
$RestartSec=5
$StandardOutput=journal
$StandardError=journal
$
$[Install]
$WantedBy=multi-user.target
{}
Management:
$# Enable and start
$sudo systemctl enable mormot-server
$sudo systemctl start mormot-server
$
$# Check status
$sudo systemctl status mormot-server
$
$# View logs
$sudo journalctl -u mormot-server -f
{}
:  Docker Deployment
{}
{\f1\fs20 Dockerfile}:
$FROM debian:bookworm-slim
$
$RUN apt-get update && apt-get install -y \
$    libsqlite3-0 \
$    && rm -rf /var/lib/apt/lists/*
$
$WORKDIR /app
$COPY myserver /app/
$COPY Views/ /app/Views/
$
$EXPOSE 8080
$USER nobody:nogroup
$
$CMD ["/app/myserver"]
{}
{\f1\fs20 docker-compose.yml}:
$version: '3.8'
$services:
$  mormot-server:
$    build: .
$    ports:
$      - "8080:8080"
$    volumes:
$      - ./data:/app/data
$    restart: unless-stopped
$    environment:
$      - MORMOT_LOG_LEVEL=debug
{}
:  Performance Tuning
{}
System limits ({\f1\fs20 /etc/security/limits.conf}):
!mormot soft nofile 65535
!mormot hard nofile 65535
{}
Kernel parameters ({\f1\fs20 /etc/sysctl.conf}):
!net.core.somaxconn = 65535
!net.ipv4.tcp_max_syn_backlog = 65535
!net.ipv4.ip_local_port_range = 1024 65535
{}
:2005 Reverse Proxy Configuration
{}
:  Nginx
{}
$upstream mormot {
$    server 127.0.0.1:8080;
$    keepalive 32;
$}
$
$server {
$    listen 80;
$    server_name api.example.com;
$
$    location / {
$        proxy_pass http://mormot;
$        proxy_http_version 1.1;
$        proxy_set_header Host $host;
$        proxy_set_header X-Real-IP $remote_addr;
$        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
$        proxy_set_header Connection "";
$
$        # WebSocket support
$        proxy_set_header Upgrade $http_upgrade;
$        proxy_set_header Connection "upgrade";
$    }
$
$    # Static files served by Nginx
$    location /.static/ {
$        alias /opt/mormot/static/;
$        expires 30d;
$    }
$}
{}
:  Apache
{}
$<VirtualHost *:80>
$    ServerName api.example.com
$
$    ProxyPreserveHost On
$    ProxyPass / http://127.0.0.1:8080/
$    ProxyPassReverse / http://127.0.0.1:8080/
$
$    # WebSocket support
$    RewriteEngine On
$    RewriteCond %{HTTP:Upgrade} =websocket [NC]
$    RewriteRule /(.*) ws://127.0.0.1:8080/$1 [P,L]
$</VirtualHost>
{}
:  SSL Termination
{}
With Let's Encrypt (certbot):
$sudo certbot --nginx -d api.example.com
{}
Or manually in Nginx:
$server {
$    listen 443 ssl http2;
$    server_name api.example.com;
$
$    ssl_certificate /etc/letsencrypt/live/api.example.com/fullchain.pem;
$    ssl_certificate_key /etc/letsencrypt/live/api.example.com/privkey.pem;
$
$    # Modern SSL configuration
$    ssl_protocols TLSv1.2 TLSv1.3;
$    ssl_ciphers ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-RSA-AES128-GCM-SHA256;
$    ssl_prefer_server_ciphers off;
$
$    location / {
$        proxy_pass http://127.0.0.1:8080;
$        # ... proxy settings
$    }
$}
{}
:2006 CDN Integration
{}
:  Architecture
{}
$┌─────────┐     ┌─────────┐     ┌─────────┐
$│ Client  │     │ Client  │     │ Client  │
$│  (US)   │     │  (EU)   │     │ (Asia)  │
$└────┬────┘     └────┬────┘     └────┬────┘
$     │               │               │
$     ▼               ▼               ▼
$┌─────────┐     ┌─────────┐     ┌─────────┐
$│ CDN     │     │ CDN     │     │ CDN     │
$│ Edge US │     │ Edge EU │     │Edge Asia│
$└────┬────┘     └────┬────┘     └────┬────┘
$     │               │               │
$     └───────────────┼───────────────┘
$                     │
$                     ▼
$              ┌─────────────┐
$              │   Origin    │
$              │   Server    │
$              │  (mORMot)   │
$              └─────────────┘
{}
:  Cache Headers
{}
Enable caching for appropriate endpoints:
{}
!procedure TMyServer.GetPublicData(Ctxt: TRestServerUriContext);
!begin
!  Ctxt.Returns(Data, HTTP_SUCCESS,
!    'Content-Type: application/json'#13#10 +
!    'Cache-Control: public, max-age=300',  // 5 minutes
!    True);  // Handle304NotModified
!end;
{}
:  Cloudflare Configuration
{}
Page Rules:
- {\f1\fs20 api.example.com/public/*} → Cache Everything, Edge {\f1\fs20 TTL}: 5 minutes
- {\f1\fs20 api.example.com/auth/*} → Bypass Cache
- {\f1\fs20 api.example.com/api/*} → Bypass Cache (authenticated)
{}
Important: Authenticated endpoints must bypass cache:
{}
!// Disable authentication for cacheable endpoints
!Server.ServiceMethodByPassAuthentication('GetPublicData');
{}
:2007 Monitoring and Logging
{}
:  Built-in Logging
{}
!// Configure logging
!with TSynLog.Family do
!begin
!  Level := LOG_VERBOSE;
!  DestinationPath := '/var/log/mormot/';
!  RotateFileCount := 10;
!  RotateFileSizeKB := 10240;  // 10 MB per file
!end;
{}
:  Health Checks
{}
!procedure TMyServer.Health(Ctxt: TRestServerUriContext);
!var
!  Status: TDocVariantData;
!begin
!  Status.InitObject([
!    'status', 'ok',
!    'timestamp', NowUtc,
!    'uptime', GetTickCount64 - fStartTime,
!    'connections', fActiveConnections
!  ]);
!  Ctxt.Returns(Status.ToJson);
!end;
!
!// Register without authentication
!Server.ServiceMethodByPassAuthentication('Health');
{}
:  Metrics Endpoint
{}
!procedure TMyServer.Metrics(Ctxt: TRestServerUriContext);
!var
!  Info: TDocVariantData;
!begin
!  Info.InitObject([
!    'requests_total', fRequestCount,
!    'requests_per_second', fRequestsPerSecond,
!    'memory_mb', GetHeapStatus.TotalAllocated div (1024*1024),
!    'db_connections', Server.DB.ConnectionCount,
!    'active_sessions', Server.Sessions.Count
!  ]);
!  Ctxt.Returns(Info.ToJson);
!end;
{}
:2008 High Availability
{}
:  Load Balancing
{}
Multiple mORMot instances behind a load balancer:
{}
$upstream mormot_cluster {
$    least_conn;
$    server 10.0.0.1:8080 weight=5;
$    server 10.0.0.2:8080 weight=5;
$    server 10.0.0.3:8080 backup;
$    keepalive 32;
$}
{}
:  Session Affinity
{}
For stateful services, use sticky sessions:
{}
$upstream mormot_cluster {
$    ip_hash;  # Same client always goes to same server
$    server 10.0.0.1:8080;
$    server 10.0.0.2:8080;
$}
{}
Or use external session storage (Redis):
{}
!// Store sessions externally
!Server.SessionClass := TAuthSessionRedis;
{}
:  Database Replication
{}
For high availability with SQLite3:
{}
!// Master server
!MasterServer := TRestServerDB.Create(Model, 'master.db3');
!
!// Replica servers (read-only)
!ReplicaServer := TRestServerDB.Create(Model, 'replica.db3');
!ReplicaServer.DB.OpenV2('replica.db3', SQLITE_OPEN_READONLY);
{}
Or use external databases with built-in replication (@*PostgreSQL@, @*MySQL@).
{}
:2009 Security Checklist
{}
:  Network Security
{}
- [ ] Use HTTPS in production
- [ ] Configure firewall (only expose needed ports)
- [ ] Use reverse proxy for SSL termination
- [ ] Enable rate limiting
- [ ] Configure CORS properly
{}
:  Application Security
{}
- [ ] Enable authentication for sensitive endpoints
- [ ] Use strong password hashing (SHA-256 + salt)
- [ ] Implement proper authorization (per-method)
- [ ] Validate all input
- [ ] Sanitize output (automatic with Mustache)
{}
:  Server Hardening
{}
- [ ] Run as non-root user
- [ ] Minimize installed packages
- [ ] Keep system updated
- [ ] Configure log rotation
- [ ] Set up monitoring/alerting
{}
: Summary
{}
mORMot 2 deployment options:
{}
|%40%60
|\b Scenario|Recommended Setup\b0
|Development|Console application
|Windows Production|Windows Service + http.sys
|Linux Production|systemd + Nginx
|Containers|Docker with Alpine/Debian
|High Traffic|Load balancer + CDN
|High Availability|Cluster + session sharing
|%
{}
Key takeaways:
- mORMot requires minimal resources
- Single executable deployment
- Native cross-platform support
- Easy integration with standard infrastructure
- Built-in logging and monitoring support
{}

; === mORMot2-SAD-Chapter-21.md ===
; Converted from Markdown - Chapter 21
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:21Security
{}
{\i Authentication, Authorization, and Process Safety}
{}
m@*ORM@ot implements a comprehensive security architecture through three complementary layers: process safety, authentication, and authorization. This chapter covers the security mechanisms built into the framework.
{}
:2101 Security Overview
{}
:  The Three Pillars
{}
$┌─────────────────────────────────────────────────────────────────┐
$│                    Security Architecture                        │
$├─────────────────────────────────────────────────────────────────┤
$│                                                                 │
$│  ┌───────────────┐  ┌───────────────┐  ┌───────────────┐        │
$│  │ Process       │  │ Authentication│  │ Authorization │        │
$│  │ Safety        │  │ (Who?)        │  │ (What?)       │        │
$│  ├───────────────┤  ├───────────────┤  ├───────────────┤        │
$│  │ • Encryption  │  │ • Sessions    │  │ • Per-table   │        │
$│  │ • ACID DB     │  │ • Signatures  │  │ • Per-service │        │
$│  │ • Stateless   │  │ • SSPI/Kerb   │  │ • Per-method  │        │
$│  │ • Type safety │  │ • JWT         │  │ • Groups      │        │
$│  │ • Testing     │  │ • HTTP Basic  │  │ • Access bits │        │
$│  └───────────────┘  └───────────────┘  └───────────────┘        │
$│                                                                 │
$└─────────────────────────────────────────────────────────────────┘
{}
:  Security Principles
{}
|%46%54
|\b Principle|Implementation\b0
|Defense in depth|Multiple security layers
|Least privilege|Group-based access rights
|Fail secure|Reject by default
|No security by obscurity|Published algorithms
|Session management|Server-side session tracking
|%
{}
:2102 Process Safety
{}
:  Built-in Safety Mechanisms
{}
mORMot provides process safety at every architectural level:
{}
{\b Encryption:}
- AES-256 encryption for sensitive data
- @*HTTP@S support for transport security
- Optional AES encryption over HTTP (deprecated, use {\f1\fs20 TLS})
{}
{\b Database Integrity:}
- @*SQLite3@ @*ACID@ transactions
- Atomic operations
- Safe concurrent access
{}
{\b Stateless Architecture:}
- Each request is independent
- Session tokens for state identification
- No server-side state dependency
{}
{\b Type Safety:}
- Strong Pascal typing
- ORM type validation
- @*JSON@ schema enforcement
{}
:2103 Authentication
{}
:  Authentication Concepts
{}
Authentication confirms user identity. mORMot supports multiple authentication schemes:
{}
|%35%12%19%34
|\b Scheme|Class|Security|Use Case\b0
|mORMot Default|{\f1\fs20 TRestServerAuthenticationDefault}|★★★★|Delphi clients
|SSPI/Kerberos|{\f1\fs20 TRestServerAuthenticationSspi}|★★★★|Windows domain
|HTTP Basic|{\f1\fs20 TRestServerAuthenticationHttpBasic}|★★|Browser/legacy
|None|{\f1\fs20 TRestServerAuthenticationNone}|★|Testing only
|@*JWT@|Via {\f1\fs20 JwtForUnauthenticatedRequest}|★★★|Public APIs
|%
{}
:  Enabling Authentication
{}
!uses
!  mormot.rest.sqlite3,
!  mormot.rest.server;
!
!var
!  Server: TRestServerDB;
!begin
!  // Create server WITH authentication enabled
!  Server := TRestServerDB.Create(Model, 'data.db3', True);  // aHandleUserAuthentication = True
!  try
!    Server.CreateMissingTables;  // Creates AuthUser/AuthGroup tables
!    // Server now requires authentication
!  finally
!    Server.Free;
!  end;
!end;
{}
The {\f1\fs20 True} parameter enables:
- {\f1\fs20 TAuthUser} and {\f1\fs20 TAuthGroup} tables
- Session management
- Default authentication schemes
{}
:  Authentication Classes
{}
!TRestServerAuthentication (abstract)
$├── TRestServerAuthenticationSignedUri
$│   ├── TRestServerAuthenticationDefault   → mORMot secure challenge
$│   └── TRestServerAuthenticationSspi      → Windows SSPI/Kerberos │
$├── TRestServerAuthenticationNone          → Weak (username only)
$└── TRestServerAuthenticationHttpAbstract
$    └── TRestServerAuthenticationHttpBasic → HTTP Basic (Base64)
{}
:2104 Default mORMot Authentication
{}
:  Challenge-Response Protocol
{}
The default authentication uses a secure two-pass challenge:
{}
!Client                                    Server
$  │                                         │
$  │  GET /auth?UserName=John               │
$  ├────────────────────────────────────────►│
$  │                                         │
$  │  {"result":"<hex_nonce>"}              │
$  │◄────────────────────────────────────────┤
$  │                                         │
$  │  GET /auth?UserName=John&              │
$  │      Password=<computed>&              │
$  │      ClientNonce=<random>              │
$  ├────────────────────────────────────────►│
$  │                                         │
$  │  {"result":"SessionID+PrivateKey",     │
$  │   "logonname":"John"}                  │
$  │◄────────────────────────────────────────┤
$  │                                         │
$  │  All requests now include:             │
$  │  ?session_signature=XXXX               │
$  ├────────────────────────────────────────►│
{}
:  Password Computation
{}
The password sent is computed as:
{}
!Password = SHA256(ModelRoot + ServerNonce + ClientNonce + UserName +
!                  SHA256('salt' + PlainPassword))
{}
This ensures:
- Password never transmitted in clear
- Replay attacks prevented by nonces
- Server doesn't store plain password
{}
:  Session Signature
{}
Each authenticated request includes a signature:
{}
!session_signature = Hexa8(SessionID) +
!                   Hexa8(Timestamp) +
!                   Hexa8(CRC32(SessionID + PrivateKey +
!                               SHA256('salt' + Password) +
!                               Timestamp + URL))
{}
Example URL:
!root/Customer/123?session_signature=0000004C000F6DD02E24541C
!                                    ^^^^^^^^ ^^^^^^^^ ^^^^^^^^
!                                    SessionID Timestamp Signature
{}
:  Client Authentication
{}
!uses
!  mormot.rest.http.client;
!
!var
!  Client: TRestHttpClientWinHTTP;
!begin
!  Client := TRestHttpClientWinHTTP.Create('localhost', '8080', Model);
!  try
!    // Authenticate with username/password
!    if not Client.SetUser('Admin', 'synopse') then
!      raise Exception.Create('Authentication failed');
!
!    // All subsequent requests are signed automatically
!    Client.Orm.Retrieve(ID, Customer);
!  finally
!    Client.Free;
!  end;
!end;
{}
:  Signature Algorithm Options
{}
!// Configure signature algorithm (server-side)
!(Server.AuthenticationRegister(TRestServerAuthenticationDefault) as
!  TRestServerAuthenticationSignedUri).Algorithm := suaSHA256;
{}
Available algorithms:
{}
|%17%9%15%59
|\b Algorithm|Speed|Security|Notes\b0
|{\f1\fs20 suaCRC32}|★★★★|★★|Default, fast
|{\f1\fs20 suaMD5}|★★★|★★|Legacy
|{\f1\fs20 suaSHA256}|★★|★★★★|Recommended for high security
|{\f1\fs20 suaSHA512}|★|★★★★|Highest security
|{\f1\fs20 suaSHA3}|★★|★★★★|Modern
|%
{}
:  Timestamp Tolerance
{}
!// For AJAX clients with network latency
!(Server.AuthenticationRegister(TRestServerAuthenticationDefault) as
!  TRestServerAuthenticationSignedUri).NoTimestampCoherencyCheck := true;
!
!// Or adjust tolerance (default: 5 seconds)
!(Server.AuthenticationRegister(TRestServerAuthenticationDefault) as
!  TRestServerAuthenticationSignedUri).TimestampCoherencySeconds := 10;
{}
:2105 Windows Authentication (SSPI)
{}
:  SSPI Overview
{}
SSPI allows using Windows credentials without entering username/password:
{}
!uses
!  mormot.rest.http.client;
!
!var
!  Client: TRestHttpClientWinHTTP;
!begin
!  Client := TRestHttpClientWinHTTP.Create('server', '8080', Model);
!  try
!    // Empty username = use Windows credentials
!    Client.SetUser('', '');  // NTLM authentication
!
!    // Or with Kerberos SPN
!    Client.SetUser('', 'mymormotservice/myserver.mydomain.tld');
!  finally
!    Client.Free;
!  end;
!end;
{}
:  Kerberos Setup
{}
For Kerberos authentication, register an SPN:
{}
$rem Register SPN for service running under SYSTEM account
$setspn -a mymormotservice/myserver.mydomain.tld myserver
$
$rem Register SPN for service running under domain account
$setspn -a mymormotservice/myserver.mydomain.tld myserviceaccount
{}
:  User Mapping
{}
SSPI-authenticated users must exist in {\f1\fs20 TAuthUser}:
{}
!// User.LogonName must match 'DOMAIN\Username'
!User := TAuthUser.Create;
!try
!  User.LogonName := 'MYDOMAIN\JohnDoe';
!  User.DisplayName := 'John Doe';
!  User.GroupRights := TAuthGroup(AdminGroupID);
!  Server.Orm.Add(User, true);
!finally
!  User.Free;
!end;
{}
:2106 HTTP Basic Authentication
{}
:  Browser Compatibility
{}
For browser clients or legacy systems:
{}
!// Server: Register HTTP Basic
!Server.AuthenticationRegister(TRestServerAuthenticationHttpBasic);
!
!// Client: Use HTTP Basic
!TRestServerAuthenticationHttpBasic.ClientSetUser(Client, 'User', 'password');
{}
{\b Warning:} HTTP Basic sends credentials as Base64 (not encrypted). Always use @*HTTPS@!
{}
:  Proxy-Only Authentication
{}
For authentication without creating a mORMot session:
{}
!// Client-side only, for proxy authentication
!TRestServerAuthenticationHttpBasic.ClientSetUserHttpOnly(
!  Client, 'proxyUser', 'proxyPass');
{}
:2107 JWT Authentication
{}
:  JWT for Public APIs
{}
JWT provides stateless authentication for public APIs:
{}
!uses
!  mormot.crypt.jwt,
!  mormot.rest.server;
!
!var
!  Server: TRestServerDB;
!  JwtEngine: TJwtHS256;
!begin
!  Server := TRestServerDB.Create(Model, 'data.db3', False);  // No session auth
!
!  // Configure JWT validation
!  JwtEngine := TJwtHS256.Create(
!    'my-secret-key-at-least-32-bytes!',  // Secret
!    60000,                                 // Clock tolerance ms
!    [jrcIssuer, jrcExpirationTime],       // Required claims
!    [],                                    // Audience (optional)
!    60                                     // Expiration minutes
!  );
!  Server.JwtForUnauthenticatedRequest := JwtEngine;  // Server owns it
!
!  // Optionally restrict to specific IPs
!  Server.JwtForUnauthenticatedRequestWhiteIP := '192.168.1.0/24';
!end;
{}
:  Client JWT Usage
{}
!// Obtain JWT from your authentication service
!var Token: RawUtf8 := GetJwtFromAuthService('user', 'pass');
!
!// Set as HTTP header
!Client.SessionHttpHeader := AuthorizationBearer(Token);
!
!// All requests now include: Authorization: Bearer <token>
{}
:  JWT Algorithms
{}
|%17%49%34
|\b Class|Algorithm|Key Type\b0
|{\f1\fs20 TJwtHS256}|HMAC-SHA256|Symmetric
|{\f1\fs20 TJwtHS384}|HMAC-SHA384|Symmetric
|{\f1\fs20 TJwtHS512}|HMAC-SHA512|Symmetric
|{\f1\fs20 TJwtES256}|ECDSA P-256|Asymmetric
|{\f1\fs20 TJwtRS256}|RSA-SHA256|Asymmetric
|{\f1\fs20 TJwtPS256}|RSA-PSS-SHA256|Asymmetric
|%
{}
:2108 TAuthUser and TAuthGroup
{}
:  TAuthGroup Structure
{}
!TAuthGroup = class(TOrm)
!published
!  property Ident: RawUtf8;           // Group name ('Admin', 'User', etc.)
!  property SessionTimeout: integer;   // Session timeout in minutes
!  property AccessRights: RawUtf8;     // CSV-encoded TOrmAccessRights
!end;
{}
:  TAuthUser Structure
{}
!TAuthUser = class(TOrm)
!published
!  property LogonName: RawUtf8;       // Login identifier
!  property DisplayName: RawUtf8;      // Display name
!  property PasswordHashHexa: RawUtf8; // SHA-256 hash of password
!  property GroupRights: TAuthGroup;   // Associated group
!  property Data: RawBlob;            // Custom application data
!end;
{}
:  Default Groups
{}
When authentication is enabled, these groups are created automatically:
{}
|%19%12%15%9%9%12%12%12
|\b Group|POST SQL|SELECT SQL|Auth R|Auth W|Tables R|Tables W|Services\b0
|Admin|✓|✓|✓|✓|✓|✓|✓
|Supervisor|✗|✓|✓|✗|✓|✓|✓
|User|✗|✗|✗|✗|✓|✓|✓
|Guest|✗|✗|✗|✗|✓|✗|✗
|%
{}
{\b Important:} Default password for all users is {\f1\fs20 synopse}. Change immediately in production!
{}
:  Creating Custom Users
{}
!var
!  User: TAuthUser;
!  Group: TAuthGroup;
!begin
!  // Find or create group
!  Group := TAuthGroup.Create;
!  try
!    if not Server.Orm.Retrieve('Ident=?', [], ['CustomGroup'], Group) then
!    begin
!      Group.Ident := 'CustomGroup';
!      Group.SessionTimeout := 30;
!      Group.OrmAccessRights := SUPERVISOR_ACCESS_RIGHTS;
!      Server.Orm.Add(Group, true);
!    end;
!
!    // Create user
!    User := TAuthUser.Create;
!    try
!      User.LogonName := 'newuser';
!      User.DisplayName := 'New User';
!      User.SetPasswordPlain('secure_password');
!      User.GroupRights := TAuthGroup(Group.ID);
!      Server.Orm.Add(User, true);
!    finally
!      User.Free;
!    end;
!  finally
!    Group.Free;
!  end;
!end;
{}
:  Password Hashing
{}
!// Simple SHA-256 (mORMot 1 compatible)
!User.SetPasswordPlain('password');  // Uses SHA256('salt' + password)
!
!// PBKDF2-HMAC-SHA256 (more secure)
!User.SetPassword('password', 'unique-salt', 10000);  // 10000 rounds
{}
:2109 Authorization
{}
:  TOrmAccessRights
{}
Authorization is controlled by {\f1\fs20 TOrmAccessRights}:
{}
!TOrmAccessRights = record
!  AllowRemoteExecute: TOrmAllowRemoteExecute;  // SQL/service flags
!  GET: TOrmTableBits;    // Read access per table
!  POST: TOrmTableBits;   // Create access per table
!  PUT: TOrmTableBits;    // Update access per table
!  DELETE: TOrmTableBits; // Delete access per table
!end;
{}
:  AllowRemoteExecute Flags
{}
!TOrmAllowRemoteExecute = set of (
!  reSQL,                    // Allow POST with SQL statements
!  reSQLSelectWithoutTable,  // Allow complex SELECT (JOINs)
!  reService,                // Allow interface-based services
!  reUrlEncodedSQL,          // Allow SQL in URL parameters
!  reUrlEncodedDelete,       // Allow DELETE with WHERE clause
!  reOneSessionPerUser       // Enforce single session per user
!);
{}
:  Predefined Access Rights
{}
!const
!  // Full access (use only for local/in-process)
!  FULL_ACCESS_RIGHTS: TOrmAccessRights = (
!    AllowRemoteExecute: [reSQL, reSQLSelectWithoutTable,
!                         reService, reUrlEncodedSQL,
!                         reUrlEncodedDelete];
!    GET: ALL_ACCESS_RIGHTS;
!    POST: ALL_ACCESS_RIGHTS;
!    PUT: ALL_ACCESS_RIGHTS;
!    DELETE: ALL_ACCESS_RIGHTS;
!  );
!
!  // Admin access (remote, with SQL)
!  ADMIN_ACCESS_RIGHTS: TOrmAccessRights = (
!    AllowRemoteExecute: [reSQL, reSQLSelectWithoutTable, reService];
!    // ...
!  );
!
!  // Supervisor access (remote, SELECT only)
!  SUPERVISOR_ACCESS_RIGHTS: TOrmAccessRights = (
!    AllowRemoteExecute: [reSQLSelectWithoutTable, reService];
!    // ...
!  );
{}
:  Per-Table Access Control
{}
!var
!  Rights: TOrmAccessRights;
!begin
!  // Start with no access
!  FillChar(Rights, SizeOf(Rights), 0);
!  Rights.AllowRemoteExecute := [reService];
!
!  // Grant full CRUD on Customer table
!  Rights.Edit(Model, TCustomer, True, True, True, True);  // C, R, U, D
!
!  // Grant read-only on Order table
!  Rights.Edit(Model, TOrder, False, True, False, False);  // R only
!
!  // Apply to group
!  Group.OrmAccessRights := Rights;
!end;
{}
:  Service Authorization
{}
For interface-based services:
{}
!// Disable authentication for specific service
!Server.ServiceDefine(TMyPublicService, [IMyPublicService], sicShared)
!      .ByPassAuthentication := True;
!
!// Or restrict to specific groups
!Server.ServiceDefine(TMyAdminService, [IMyAdminService], sicShared)
!      .AllowedGroups := [1];  // Group ID 1 only (Admin)
{}
For method-based services:
{}
!// Bypass authentication for specific method
!Server.ServiceMethodByPassAuthentication('Timestamp');
!Server.ServiceMethodByPassAuthentication('Auth');
{}
:2110 Session Management
{}
:  Session Storage
{}
Sessions are stored in-memory as {\f1\fs20 TAuthSession} instances:
{}
!TAuthSession = class(TSynPersistent)
!  property ID: cardinal;              // Session identifier
!  property User: TAuthUser;           // Associated user (loaded)
!  property TimeOutTix: cardinal;      // Expiration tick
!  property RemoteIP: RawUtf8;         // Client IP address
!  property ConnectionID: TRestConnectionID;
!end;
{}
:  Session Lifecycle
{}
$┌──────────────────────────────────────────────────────────────┐
$│                    Session Lifecycle                          │
$├──────────────────────────────────────────────────────────────┤
$│                                                               │
$│  Client.SetUser()  ──► Auth Request ──► Session Created       │
$│         │                                    │                │
$│         │                                    ▼                │
$│         │                            ┌─────────────┐          │
$│         │                            │ In-Memory   │          │
$│         │                            │ TAuthSession│          │
$│         │                            └─────────────┘          │
$│         │                                    │                │
$│         │                          ┌─────────┴─────────┐      │
$│         │                          ▼                   ▼      │
$│         │                    Session Timeout    Explicit Close│
$│         │                          │                   │      │
$│         │                          └─────────┬─────────┘      │
$│         │                                    ▼                │
$│         │                            Session Destroyed        │
$│         │                                                     │
$└──────────────────────────────────────────────────────────────┘
{}
:  Session Timeout
{}
Configure via {\f1\fs20 TAuthGroup.SessionTimeout}:
{}
!// Set 30-minute timeout for a group
!Group.SessionTimeout := 30;
!Server.Orm.Update(Group);
{}
:  Session Persistence
{}
Sessions can be persisted for server restarts:
{}
!// Save sessions before shutdown
!Server.Shutdown('sessions.bin');
!
!// Restore sessions after restart
!Server.SessionsLoadFromFile('sessions.bin');
{}
{\b Note:} This works for ORM sessions only, not @*SOA@ with stateful services.
{}
:  Accessing Session Information
{}
!// Server-side: Get current session user
!var
!  User: TAuthUser;
!begin
!  User := Server.SessionGetUser(Ctxt.SessionID);
!  if User <> nil then
!    Log('Request from: %s', [User.DisplayName]);
!end;
!
!// In service implementation
!procedure TMyService.DoSomething;
!var
!  Ctxt: TRestServerUriContext;
!begin
!  Ctxt := ServiceRunningContext;
!  if Ctxt <> nil then
!    Log('Session ID: %d, User: %s',
!        [Ctxt.SessionID, Ctxt.SessionUser.LogonName]);
!end;
{}
:2111 Security Best Practices
{}
:  Transport Security
{}
!// Always use HTTPS in production
!HttpServer := TRestHttpServer.Create(
!  '443',
!  [Server],
!  '+',
!  useHttpAsync,
!  secTLS           // Enable TLS
!);
!
!// Configure certificate
!HttpServer.TLS.CertificateFile := 'server.crt';
!HttpServer.TLS.PrivateKeyFile := 'server.key';
{}
:  Password Management
{}
!// ❌ Never store plain passwords
!User.PasswordHashHexa := 'plaintext';
!
!// ✓ Always hash passwords
!User.SetPasswordPlain('password');  // SHA-256
!
!// ✓ Or use PBKDF2 for better security
!User.SetPassword('password', RandomString(16), 10000);
{}
:  SQL Injection Prevention
{}
!// ❌ Dangerous: SQL injection possible
!Server.Orm.ExecuteFmt('SELECT * FROM Customer WHERE Name = ''%s''', [UserInput]);
!
!// ✓ Safe: Use parameterized queries
!Server.Orm.Retrieve('Name = ?', [], [UserInput], Customer);
{}
:  Principle of Least Privilege
{}
!// ❌ Don't give all users admin rights
!User.GroupRights := TAuthGroup(AdminGroupID);
!
!// ✓ Create specific groups with minimal rights
!User.GroupRights := TAuthGroup(ReadOnlyGroupID);
{}
:  Audit Logging
{}
!// Enable detailed logging
!Server.OnAfterUri := procedure(Ctxt: TRestServerUriContext)
!begin
!  if Ctxt.SessionUser <> nil then
!    Log('%s: %s %s from %s', [
!      DateTimeToIso8601(Now, True),
!      Ctxt.SessionUser.LogonName,
!      Ctxt.Uri,
!      Ctxt.RemoteIP
!    ]);
!end;
{}
:2112 Custom Authentication
{}
:  Creating Custom Scheme
{}
!type
!  TRestServerAuthenticationCustom = class(TRestServerAuthentication)
!  public
!    function Auth(Ctxt: TRestServerUriContext;
!      const aUserName: RawUtf8): boolean; override;
!    function RetrieveSession(
!      Ctxt: TRestServerUriContext): TAuthSession; override;
!  end;
!
!function TRestServerAuthenticationCustom.Auth(
!  Ctxt: TRestServerUriContext;
!  const aUserName: RawUtf8): boolean;
!var
!  User: TAuthUser;
!  Token: RawUtf8;
!begin
!  Result := False;
!  Token := Ctxt.InputUtf8['token'];
!
!  // Validate token with your external service
!  if not ValidateExternalToken(Token, aUserName) then
!    Exit;
!
!  // Create session
!  User := GetUser(Ctxt, aUserName);
!  if User <> nil then
!  begin
!    SessionCreate(Ctxt, User);
!    Result := True;
!  end;
!end;
{}
:  Registering Custom Scheme
{}
!Server.AuthenticationRegister(TRestServerAuthenticationCustom);
{}
:  Custom User Retrieval
{}
!// Override user retrieval from external source
!Server.OnAuthenticationUserRetrieve :=
!  function(Sender: TRestServerAuthentication;
!           Ctxt: TRestServerUriContext;
!           const aUserName: RawUtf8): TAuthUser;
!  begin
!    Result := TAuthUser.Create;
!    Result.LogonName := aUserName;
!    Result.ID := GetUserIdFromLDAP(aUserName);
!    Result.GroupRights := TAuthGroup(GetGroupFromLDAP(aUserName));
!  end;
{}
:2113 Summary
{}
:  Authentication Quick Reference
{}
|%72%28
|\b Need|Solution\b0
|Delphi clients|{\f1\fs20 TRestServerAuthenticationDefault}
|Windows domain|{\f1\fs20 TRestServerAuthenticationSspi}
|Browser/@*REST@ API|{\f1\fs20 TRestServerAuthenticationHttpBasic} + HTTPS
|Public stateless API|JWT via {\f1\fs20 JwtForUnauthenticatedRequest}
|Development/testing|{\f1\fs20 TRestServerAuthenticationNone}
|%
{}
:  Authorization Quick Reference
{}
|%67%33
|\b Need|Property\b0
|Per-table @*CRUD@|{\f1\fs20 TOrmAccessRights.GET/POST/PUT/DELETE}
|SQL execution|{\f1\fs20 AllowRemoteExecute} flags
|Service access|{\f1\fs20 ByPassAuthentication}, {\f1\fs20 AllowedGroups}
|Group management|{\f1\fs20 TAuthGroup.AccessRights}
|%
{}
:  Key Units
{}
|%11%89
|\b Unit|Purpose\b0
|@!src\rest\mormot.rest.server.pas@|Authentication classes, sessions
|@!src\rest\mormot.rest.core.pas@|{\f1\fs20 TAuthUser}, {\f1\fs20 TAuthGroup}
|@!src\orm\mormot.orm.core.pas@|{\f1\fs20 TOrmAccessRights}
|@!src\crypt\mormot.crypt.jwt.pas@|JWT classes
|@!src\crypt\mormot.crypt.secure.pas@|Cryptographic primitives
|%
{}
{\i Next: Chapter 22 covers the Scripting Engine (if applicable to your mORMot2 version).}
{}

; === mORMot2-SAD-Chapter-22.md ===
; Converted from Markdown - Chapter 22
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:22Scripting Engine
{}
{\i JavaScript Integration for Dynamic Applications}
{}
m@*ORM@ot provides JavaScript scripting capabilities for applications that need dynamic behavior, user-defined workflows, or hot-reloadable business logic. This chapter covers the scripting architecture and available engines.
{}
:2201 Why Scripting?
{}
:  Use Cases
{}
|%30%70
|\b Scenario|Benefit\b0
|User-defined workflows|End-users customize behavior without recompilation
|Business rules|Domain experts define evolving logic
|Customization|Single executable serves multiple clients
|Reporting|Dynamic report definitions
|Plugin systems|Third-party extensions
|Rapid prototyping|Quick iteration without compilation
|%
{}
:  Language Choice: JavaScript
{}
mORMot chose JavaScript for scripting because:
{}
- {\b Universal knowledge} - Nearly every programmer knows JavaScript
- {\b Powerful when used well} - Modern ES2020+ features
- {\b Rich ecosystem} - Thousands of libraries available
- {\b Client/server sharing} - Same validation logic on both sides
- {\b Proven engines} - QuickJS and SpiderMonkey are production-ready
{}
:2202 Architecture Overview
{}
:  Two-Layer Design
{}
$┌─────────────────────────────────────────────────────────────────┐
$│                    Application Code                             │
$└─────────────────────────────────────────────────────────────────┘
$                              │
$┌─────────────────────────────────────────────────────────────────┐
$│                   mormot.script.core.pas                        │
$│           (Abstract Engine Management Layer)                    │
$│                                                                 │
$│  ┌─────────────────────┐  ┌──────────────────────────────┐      │
$│  │ TThreadSafeManager  │  │ TThreadSafeEngine (abstract) │      │
$│  │                     │  │                              │      │
$│  │ • Engine pooling    │  │ • Per-thread execution       │      │
$│  │ • Thread safety     │  │ • Context isolation          │      │
$│  │ • Hot reload        │  │ • FPU state protection       │      │
$│  │ • Remote debugging  │  │ • Lifecycle hooks            │      │
$│  └─────────────────────┘  └──────────────────────────────┘      │
$└─────────────────────────────────────────────────────────────────┘
$                              │
$┌─────────────────────────────────────────────────────────────────┐
$│                   Engine Implementations                        │
$│                                                                 │
$│  ┌──────────────────────┐  ┌──────────────────────────┐         │
$│  │ mormot.lib.quickjs   │  │ (SpiderMonkey planned)   │         │
$│  │                      │  │                          │         │
$│  │ • ES2020 support     │  │ • JIT compilation        │         │
$│  │ • Small footprint    │  │ • High performance       │         │
$│  │ • Static linking     │  │ • node.js compatible     │         │
$│  └──────────────────────┘  └──────────────────────────┘         │
$└─────────────────────────────────────────────────────────────────┘
{}
:  Supported Engines
{}
|%21%51%28
|\b Engine|Use Case|Status\b0
|{\b QuickJS}|Client-side, embedded|Available (via @!src\lib\mormot.lib.quickjs.pas@)
|{\b SpiderMonkey}|Server-side, high-performance|Planned
|%
{}
:2203 QuickJS Integration
{}
:  About QuickJS
{}
QuickJS is a small, embeddable JavaScript engine by Fabrice Bellard:
{}
- {\b ES2020 support} - Modules, async/await, BigInt, Proxies
- {\b Small footprint} - ~400KB static library
- {\b No external dependencies} - Fully standalone
- {\b Cross-platform} - Windows, Linux, macOS
{}
:  Low-Level API
{}
The {\f1\fs20 mormot.lib.quickjs.pas} unit provides direct QuickJS bindings:
{}
!uses
!  mormot.lib.quickjs;
!
!var
!  Runtime: JSRuntime;
!  Context: JSContext;
!  Value: JSValue;
!  Script: RawUtf8;
!begin
!  // Create runtime and context
!  Runtime := JS_NewRuntime;
!  Context := JS_NewContext(Runtime);
!  try
!    // Execute JavaScript
!    Script := 'function add(a, b) { return a + b; } add(2, 3);';
!    Value := JS_Eval(Context, pointer(Script), length(Script),
!                     'script.js', JS_EVAL_TYPE_GLOBAL);
!
!    // Check result
!    if JS_IsNumber(Value) then
!      Writeln('Result: ', JS_ToFloat64(Context, Value));
!
!    JS_FreeValue(Context, Value);
!  finally
!    JS_FreeContext(Context);
!    JS_FreeRuntime(Runtime);
!  end;
!end;
{}
:  Enabling QuickJS
{}
QuickJS requires the {\f1\fs20 LIBQUICKJSSTATIC} conditional:
{}
!// In project options or .inc file:
!{$define LIBQUICKJSSTATIC}
{}
Static libraries are located in:
!/mnt/w/mORMot2/static/
!  libquickjs.a        // Linux/macOS
!  libquickjs.obj      // Windows
{}
:2204 Thread-Safe Engine Management
{}
:  TThreadSafeManager
{}
The {\f1\fs20 TThreadSafeManager} class provides thread-safe engine pooling:
{}
!uses
!  mormot.script.core;
!
!type
!  // Your engine implementation (inherits from TThreadSafeEngine)
!  TMyQuickJSEngine = class(TThreadSafeEngine)
!  protected
!    procedure AfterCreate; override;
!    procedure DoBeginRequest; override;
!    procedure DoEndRequest; override;
!  end;
!
!var
!  Manager: TThreadSafeManager;
!begin
!  Manager := TThreadSafeManager.Create(TMyQuickJSEngine);
!  try
!    // Configure expiration (recommended for long-running servers)
!    Manager.EngineExpireTimeOutMinutes := 240;  // 4 hours
!
!    // Use in request handlers...
!  finally
!    Manager.Free;
!  end;
!end;
{}
:  Per-Thread Engine Access
{}
!procedure HandleRequest;
!var
!  Engine: TThreadSafeEngine;
!begin
!  // Get or create engine for current thread
!  Engine := Manager.ThreadSafeEngine;
!
!  // Execute within protected context
!  Engine.ThreadSafeCall(
!    procedure(E: TThreadSafeEngine)
!    begin
!      // FPU state is protected here
!      // Execute JavaScript safely
!    end);
!end;
{}
:  Thread Safety Model
{}
$┌────────────────────────────────────────────────────────────────┐
$│                    Thread Safety Model                          │
$├────────────────────────────────────────────────────────────────┤
$│                                                                 │
$│  Thread 1 ──────► Engine 1 (exclusive)                          │
$│                                                                 │
$│  Thread 2 ──────► Engine 2 (exclusive)                          │
$│                                                                 │
$│  Thread 3 ──────► Engine 3 (exclusive)                          │
$│                                                                 │
$│                   ▲                                             │
$│                   │                                             │
$│  ┌────────────────┴────────────────┐                            │
$│  │     TThreadSafeManager          │                            │
$│  │  (thread-safe pool management)  │                            │
$│  └─────────────────────────────────┘                            │
$│                                                                 │
$│  Key Rules:                                                     │
$│  • One engine per thread (never shared)                         │
$│  • Manager handles allocation/deallocation                      │
$│  • Automatic expiration prevents memory leaks                   │
$│                                                                 │
$└────────────────────────────────────────────────────────────────┘
{}
:2205 Hot Reload Pattern
{}
:  Content Versioning
{}
!// Application detects script changes
!if ScriptFilesModified then
!begin
!  // Increment version - engines will recreate on next access
!  Manager.ContentVersion := Manager.ContentVersion + 1;
!end;
!
!// In request handler
!Engine := Manager.ThreadSafeEngine;
!if Engine.ContentVersion <> Manager.ContentVersion then
!begin
!  // Engine was recreated - reload scripts
!  LoadScriptsIntoEngine(Engine);
!  Engine.ContentVersion := Manager.ContentVersion;
!end;
{}
:  Engine Expiration
{}
For long-running servers, prevent JavaScript memory leaks:
{}
!// Recreate engines every 4 hours
!Manager.EngineExpireTimeOutMinutes := 240;
!
!// Mark critical engines as permanent
!MainEngine.NeverExpire := true;
{}
:2206 Remote Debugging
{}
:  Firefox DevTools Protocol
{}
mORMot implements the Firefox Remote Debugging Protocol:
{}
!// Start debugger on port 6000
!Manager.StartDebugger('6000');
!
!// Optional: Break on first line
!Manager.PauseDebuggerOnFirstStep := true;
{}
:  Connecting Firefox
{}
1. Open Firefox
2. Navigate to {\f1\fs20 about:debugging}
3. Click "This Firefox" → "Settings"
4. Enable Remote Debugging
5. Connect to {\f1\fs20 localhost:6000}
{}
{\b Note:} This uses Firefox DevTools protocol, NOT Chrome DevTools.
{}
:2207 mORMot Integration Patterns
{}
:  Exposing ORM to JavaScript
{}
!// Register native function to access ORM
!procedure RegisterOrmAccess(Engine: TThreadSafeEngine);
!begin
!  // Example: Expose Customer retrieval
!  Engine.RegisterFunction('getCustomer',
!    function(Args: TJSArgs): TJSValue
!    var
!      ID: TID;
!      Customer: TOrmCustomer;
!    begin
!      ID := Args[0].AsInt64;
!      Customer := TOrmCustomer.Create;
!      try
!        if Server.Orm.Retrieve(ID, Customer) then
!          Result := CustomerToJS(Customer)
!        else
!          Result := JS_NULL;
!      finally
!        Customer.Free;
!      end;
!    end);
!end;
{}
:  Calling Services from JavaScript
{}
!// JavaScript can call interface-based services
!Engine.RegisterFunction('callService',
!  function(Args: TJSArgs): TJSValue
!  var
!    ServiceName, MethodName: RawUtf8;
!    Params: TDocVariantData;
!  begin
!    ServiceName := Args[0].AsString;
!    MethodName := Args[1].AsString;
!    Params := Args[2].AsVariant;
!
!    // Execute service and return result as JSON
!    Result := ExecuteServiceMethod(ServiceName, MethodName, Params);
!  end);
{}
:  Business Rules in JavaScript
{}
!// Define validation rules in JavaScript
!const
!  VALIDATION_SCRIPT = '''
!    function validateOrder(order) {
!      if (order.total > 10000 && !order.managerApproval) {
!        return { valid: false, error: "Manager approval required" };
!      }
!      if (order.items.length === 0) {
!        return { valid: false, error: "Order must have items" };
!      }
!      return { valid: true };
!    }
!  ''';
!
!// Use from Delphi
!function ValidateOrder(const Order: TOrder): boolean;
!var
!  Engine: TThreadSafeEngine;
!  Result: Variant;
!begin
!  Engine := Manager.ThreadSafeEngine;
!  Result := Engine.Call('validateOrder', [OrderToVariant(Order)]);
!  ValidateOrder := Result.valid;
!  if not ValidateOrder then
!    raise EValidation.Create(Result.error);
!end;
{}
:2208 Custom Variant Type
{}
:  Late-Binding Access
{}
mORMot provides a custom variant type for seamless JavaScript access:
{}
!var
!  JSObj: Variant;
!begin
!  // Create JavaScript object
!  JSObj := Engine.NewObject;
!
!  // Late-binding property access (like JavaScript)
!  JSObj.name := 'John';
!  JSObj.age := 30;
!  JSObj.greet := Engine.Function('return "Hello, " + this.name');
!
!  // Call method
!  Writeln(JSObj.greet());  // "Hello, John"
!end;
{}
:  Array Handling
{}
!var
!  JSArray: Variant;
!begin
!  JSArray := Engine.NewArray;
!
!  // Push elements
!  JSArray.push(1);
!  JSArray.push(2);
!  JSArray.push(3);
!
!  // Access by index
!  Writeln(JSArray[0]);  // 1
!
!  // Array methods
!  JSArray.sort();
!  JSArray.reverse();
!end;
{}
:2209 Key Units Reference
{}
|%8%92
|\b Unit|Purpose\b0
|@!src\script\mormot.script.core.pas@|Abstract engine management, thread pooling
|@!src\script\mormot.script.quickjs.pas@|QuickJS high-level wrapper (in development)
|@!src\lib\mormot.lib.quickjs.pas@|Low-level QuickJS API bindings
|@!src\lib\mormot.lib.static.pas@|Static library loading infrastructure
|%
{}
:2210 Current Status and Roadmap
{}
:  Implemented
{}
- ✓ Abstract {\f1\fs20 TThreadSafeEngine} and {\f1\fs20 TThreadSafeManager}
- ✓ Thread-safe pooling with expiration
- ✓ Remote debugging infrastructure
- ✓ Low-level QuickJS bindings (@!src\lib\mormot.lib.quickjs.pas@)
{}
:  In Development
{}
- @!src\script\mormot.script.quickjs.pas@ high-level wrapper
- Custom variant type for late-binding
- ORM/@*SOA@ integration helpers
{}
:  Planned
{}
- SpiderMonkey integration (for high-performance server scenarios)
- JIT compilation support
- node.js module compatibility
{}
:2211 Best Practices
{}
:  When to Use Scripting
{}
|%46%54
|\b Use Scripting For|Use Compiled Code For\b0
|User-customizable logic|Performance-critical paths
|Frequently changing rules|Core business logic
|Plugin/extension systems|Security-sensitive operations
|Rapid prototyping|Database access layer
|Report templates|Infrastructure code
|%
{}
:  Security Considerations
{}
!// Limit script capabilities
!Engine.DisableFileAccess := true;
!Engine.DisableNetworkAccess := true;
!Engine.MaxExecutionTimeMs := 5000;  // 5 second timeout
!Engine.MaxMemoryBytes := 64 * 1024 * 1024;  // 64MB limit
{}
:  Error Handling
{}
!try
!  Result := Engine.Eval(Script);
!except
!  on E: EJSException do
!  begin
!    Log.Error('JavaScript error at line %d: %s',
!              [E.LineNumber, E.Message]);
!    // E.StackTrace contains full JS stack
!  end;
!end;
{}
:2212 Summary
{}
:  Quick Reference
{}
|%73%27
|\b Need|Solution\b0
|Embed JavaScript|@!src\lib\mormot.lib.quickjs.pas@ + {\f1\fs20 LIBQUICKJSSTATIC}
|Thread-safe execution|{\f1\fs20 TThreadSafeManager}
|Engine pooling|{\f1\fs20 Manager.ThreadSafeEngine}
|Hot reload|{\f1\fs20 Manager.ContentVersion}
|Remote debugging|{\f1\fs20 Manager.StartDebugger('6000')}
|Memory management|{\f1\fs20 EngineExpireTimeOutMinutes}
|%
{}
:  When to Choose Each Engine
{}
|%45%55
|\b QuickJS|SpiderMonkey (when available)\b0
|Client-side scripts|Server-side heavy processing
|Small footprint needed|JIT performance required
|Static linking preferred|node.js compatibility needed
|ES2020 sufficient|Latest ECMAScript features
|%
{}
{\i Note: The scripting layer in mORMot2 is actively evolving. Check the source code and forum for the latest implementation status.}
{}
{\i Next: Chapter 23 covers Asymmetric Encryption (ECC) for secure communications.}
{}

; === mORMot2-SAD-Chapter-23.md ===
; Converted from Markdown - Chapter 23
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:23Asymmetric Encryption
{}
{\i Elliptic Curve Cryptography and Public Key Infrastructure}
{}
m@*ORM@ot provides a complete asymmetric cryptography stack based on Elliptic Curve Cryptography (ECC), enabling digital signatures, secure encryption, and certificate management without external dependencies.
{}
:2301 Public-Key Cryptography Fundamentals
{}
:  Asymmetric vs Symmetric Encryption
{}
|%23%29%48
|\b Aspect|Symmetric|Asymmetric\b0
|Keys|Single shared secret|Public/private pair
|Speed|Fast|Slower
|Key distribution|Challenging|Easy (public keys shared freely)
|Use case|Bulk data encryption|Key exchange, signatures
|%
{}
:  Public Key Operations
{}
With a public/private key pair, you can:
{}
1. {\b Sign} - Create a digital signature with your private key
2. {\b Verify} - Confirm a signature with the signer's public key
3. {\b Encrypt} - Encrypt data with recipient's public key
4. {\b Decrypt} - Decrypt data with your private key
{}
$┌──────────────────────────────────────────────────────────────────┐
$│                     Key Pair Operations                          │
$├──────────────────────────────────────────────────────────────────┤
$│                                                                  │
$│  SIGNING (Authentication)           ENCRYPTION (Confidentiality) │
$│  ─────────────────────────          ──────────────────────────── │
$│                                                                  │
$│  Alice → Private Key → Sign         Bob → Alice's Public Key     │
$│          ↓                                   ↓                   │
$│      Signature                          Encrypted Message        │
$│          ↓                                   ↓                   │
$│  Bob ← Alice's Public Key ← Verify  Alice ← Private Key ← Decrypt│
$│                                                                  │
$└──────────────────────────────────────────────────────────────────┘
{}
:2302 Elliptic Curve Cryptography (ECC)
{}
:  Why ECC?
{}
mORMot uses ECC (specifically secp256r1/NIST P-256) for several advantages:
{}
|%40%60
|\b Advantage|Explanation\b0
|{\b Smaller keys}|256-bit ECC ≈ 3072-bit RSA security
|{\b Faster operations}|Lower CPU usage per operation
|{\b Perfect forward secrecy}|Fresh key per encryption
|{\b No external dependencies}|Stand-alone implementation
|{\b Future-proof}|Endorsed by NIST/NSA
|%
{}
:  Key Units
{}
|%8%92
|\b Unit|Purpose\b0
|{\f1\fs20 mormot.crypt.ecc256r1}|Low-level ECC primitives (secp256r1)
|@!src\crypt\mormot.crypt.ecc.pas@|High-level certificates, encryption, signing
|@!src\crypt\mormot.crypt.secure.pas@|Factory functions ({\f1\fs20 Asym()}, {\f1\fs20 Cert()})
|{\f1\fs20 mormot.crypt.x509}|X.509 certificate support
|%
{}
:2303 High-Level Factory API
{}
:  Using the Asym() Factory
{}
The recommended approach uses the factory pattern:
{}
!uses
!  mormot.crypt.secure,
!  mormot.crypt.ecc;
!
!var
!  Asym: TCryptAsym;
!  PublicKey, PrivateKey: RawByteString;
!  Message, Signature: RawByteString;
!begin
!  // Get ECC asymmetric instance
!  Asym := mormot.crypt.secure.Asym('es256');  // secp256r1 ECDSA
!
!  // Generate key pair
!  Asym.GeneratePem(PublicKey, PrivateKey, '');
!
!  // Sign a message
!  Message := 'Hello, World!';
!  Asym.Sign(Message, PrivateKey, Signature);
!
!  // Verify signature
!  if Asym.Verify(Message, PublicKey, Signature) then
!    Writeln('Signature valid!')
!  else
!    Writeln('Signature INVALID!');
!end;
{}
:  Using the Cert() Factory
{}
For certificate-based operations:
{}
!uses
!  mormot.crypt.secure;
!
!var
!  Cert: ICryptCert;
!  PublicPem, PrivatePem: RawUtf8;
!begin
!  // Create certificate (mORMot's proprietary format)
!  Cert := mormot.crypt.secure.Cert('syn-es256');
!
!  // Generate with subject info
!  Cert.Generate([
!    cuDigitalSignature,
!    cuKeyEncipherment
!  ], 365, nil, nil, 'CN=My Certificate');
!
!  // Export
!  PublicPem := Cert.Save(cccCertOnly, '', ccfPem);
!  PrivatePem := Cert.Save(cccCertWithPrivateKey, 'password', ccfPem);
!end;
{}
:2304 TEccCertificate Classes
{}
:  Class Hierarchy
{}
!TEccCertificate (public certificate)
$└── TEccCertificateSecret (public + private key)
!
!TEccCertificateChain (PKI trust chain)
{}
:  Creating a Self-Signed Certificate
{}
!uses
!  mormot.crypt.ecc;
!
!var
!  Secret: TEccCertificateSecret;
!begin
!  // Create new self-signed certificate
!  Secret := TEccCertificateSecret.CreateNew(
!    nil,              // No authority (self-signed)
!    'MyApp',          // Issuer identifier
!    365               // Valid for 365 days
!  );
!  try
!    // Save public certificate
!    Secret.SaveToFile('myapp.public');
!
!    // Save private key (password protected)
!    Secret.SaveToSecureFile('myapp.private', 'MySecretPassword');
!  finally
!    Secret.Free;
!  end;
!end;
{}
:  Loading Certificates
{}
!var
!  PublicCert: TEccCertificate;
!  SecretCert: TEccCertificateSecret;
!begin
!  // Load public certificate
!  PublicCert := TEccCertificate.Create;
!  PublicCert.LoadFromFile('myapp.public');
!
!  // Load private certificate
!  SecretCert := TEccCertificateSecret.Create;
!  SecretCert.LoadFromSecureFile('myapp.private', 'MySecretPassword');
!end;
{}
:2305 Digital Signatures
{}
:  Signing Data
{}
!uses
!  mormot.crypt.ecc;
!
!var
!  Secret: TEccCertificateSecret;
!  Data: RawByteString;
!  Signature: TEccSignature;
!begin
!  Secret := TEccCertificateSecret.Create;
!  Secret.LoadFromSecureFile('signer.private', 'password');
!  try
!!    Data := 'Important document content';
!
!    // Sign the data
!    if Secret.Sign(Data, Signature) then
!      Writeln('Data signed successfully');
!  finally
!    Secret.Free;
!  end;
!end;
{}
:  Verifying Signatures
{}
!var
!  PublicCert: TEccCertificate;
!  Data: RawByteString;
!  Signature: TEccSignature;
!begin
!  PublicCert := TEccCertificate.Create;
!  PublicCert.LoadFromFile('signer.public');
!  try
!    // Verify signature
!    if PublicCert.Verify(Data, Signature) then
!      Writeln('Signature is VALID')
!    else
!      Writeln('Signature is INVALID!');
!  finally
!    PublicCert.Free;
!  end;
!end;
{}
:  Signing Files
{}
!var
!  Secret: TEccCertificateSecret;
!begin
!  Secret := TEccCertificateSecret.Create;
!  Secret.LoadFromSecureFile('signer.private', 'password');
!  try
!    // Creates document.pdf.sign file
!    Secret.SignFile('document.pdf');
!  finally
!    Secret.Free;
!  end;
!end;
{}
:2306 Encryption
{}
:  ECIES Encryption
{}
mORMot uses ECIES (Elliptic Curve Integrated Encryption Scheme):
{}
$┌─────────────────────────────────────────────────────────────────┐
$│                    ECIES Encryption Flow                        │
$├─────────────────────────────────────────────────────────────────┤
$│                                                                 │
$│  1. Generate ephemeral ECC key pair                             │
$│  2. Derive shared secret via ECDH                               │
$│  3. Use PBKDF2 to derive AES key from shared secret             │
$│  4. Encrypt data with AES-256                                   │
$│  5. Include ephemeral public key with ciphertext                │
$│                                                                 │
$│  Benefits:                                                      │
$│  • Perfect forward secrecy (new key per encryption)             │
$│  • Combines ECC efficiency with AES speed                       │
$│  • Authenticated encryption                                     │
$│                                                                 │
$└─────────────────────────────────────────────────────────────────┘
{}
:  Encrypting Data
{}
!uses
!  mormot.crypt.ecc;
!
!var
!  RecipientCert: TEccCertificate;
!  PlainText, Encrypted: RawByteString;
!begin
!  // Load recipient's public certificate
!  RecipientCert := TEccCertificate.Create;
!  RecipientCert.LoadFromFile('recipient.public');
!  try
!    PlainText := 'Secret message for recipient only';
!
!    // Encrypt (only recipient can decrypt with their private key)
!    Encrypted := RecipientCert.Encrypt(PlainText);
!  finally
!    RecipientCert.Free;
!  end;
!end;
{}
:  Decrypting Data
{}
!var
!  SecretCert: TEccCertificateSecret;
!  Encrypted, Decrypted: RawByteString;
!begin
!  // Load your private certificate
!  SecretCert := TEccCertificateSecret.Create;
!  SecretCert.LoadFromSecureFile('recipient.private', 'password');
!  try
!    // Decrypt
!    Decrypted := SecretCert.Decrypt(Encrypted);
!  finally
!    SecretCert.Free;
!  end;
!end;
{}
:  ECIES Algorithm Options
{}
!type
!  TEciesAlgo = (
!    ecaPBKDF2_HMAC_SHA256_AES256_CFB,     // Default
!    ecaPBKDF2_HMAC_SHA256_AES256_CBC,
!    ecaPBKDF2_HMAC_SHA256_AES256_CTR,
!    ecaPBKDF2_HMAC_SHA256_AES256_CFB_SYNLZ,  // With compression
!    ecaPBKDF2_AES256_GCM,                  // Authenticated encryption
!    // ... more options
!  );
{}
:  File Encryption
{}
!var
!  RecipientCert: TEccCertificate;
!begin
!  RecipientCert := TEccCertificate.Create;
!  RecipientCert.LoadFromFile('recipient.public');
!  try
!    // Creates document.pdf.synecc encrypted file
!    RecipientCert.EncryptFile('document.pdf');
!  finally
!    RecipientCert.Free;
!  end;
!end;
{}
:2307 Certificate Chain (PKI)
{}
:  Creating a Certificate Authority
{}
!uses
!  mormot.crypt.ecc;
!
!var
!  CA: TEccCertificateSecret;
!begin
!  // Create root CA
!  CA := TEccCertificateSecret.CreateNew(
!    nil,                          // Self-signed (root)
!    'MyCompany Root CA',          // Issuer
!    3650,                         // 10 years validity
!    365,                          // 1 year signature validity
!    [cuCA, cuDigitalSignature]    // CA usage
!  );
!  try
!    CA.SaveToFile('ca.public');
!    CA.SaveToSecureFile('ca.private', 'CaSecretPassword', 10000);
!  finally
!    CA.Free;
!  end;
!end;
{}
:  Issuing Certificates
{}
!var
!  CA: TEccCertificateSecret;
!  UserCert: TEccCertificateSecret;
!begin
!  // Load CA
!  CA := TEccCertificateSecret.Create;
!  CA.LoadFromSecureFile('ca.private', 'CaSecretPassword');
!  try
!    // Create user certificate signed by CA
!    UserCert := TEccCertificateSecret.CreateNew(
!      CA,                           // Signed by CA
!      'John Doe',                   // Issuer/subject
!      365,                          // 1 year validity
!      0,                            // Default signature validity
!      [cuDigitalSignature, cuKeyEncipherment]
!    );
!    try
!      UserCert.SaveToFile('john.public');
!      UserCert.SaveToSecureFile('john.private', 'JohnPassword');
!    finally
!      UserCert.Free;
!    end;
!  finally
!    CA.Free;
!  end;
!end;
{}
:  Validating Certificate Chain
{}
!var
!  Chain: TEccCertificateChain;
!  UserCert: TEccCertificate;
!  ValidationResult: TEccValidity;
!begin
!  // Build trust chain
!  Chain := TEccCertificateChain.Create;
!  try
!    // Add trusted CA
!    Chain.Add(TEccCertificate.CreateFromFile('ca.public'));
!
!    // Load certificate to validate
!    UserCert := TEccCertificate.Create;
!    UserCert.LoadFromFile('john.public');
!    try
!      // Validate
!      ValidationResult := Chain.IsValid(UserCert);
!      case ValidationResult of
!        ecvValidSigned:
!          Writeln('Certificate is valid and signed by trusted CA');
!        ecvValidSelfSigned:
!          Writeln('Certificate is self-signed (not in chain)');
!        ecvNotValidYet:
!          Writeln('Certificate not yet valid');
!        ecvExpired:
!          Writeln('Certificate has expired');
!        ecvRevoked:
!          Writeln('Certificate has been revoked');
!        ecvUnknownAuthority:
!          Writeln('Unknown signing authority');
!      else
!        Writeln('Certificate validation failed');
!      end;
!    finally
!      UserCert.Free;
!    end;
!  finally
!    Chain.Free;
!  end;
!end;
{}
:2308 Secure Communication Protocol
{}
:  IProtocol Interface
{}
mORMot provides {\f1\fs20 IProtocol} for encrypted communication:
{}
!uses
!  mormot.crypt.secure;
!
!type
!  IProtocol = interface
!    function ProcessHandshake(const Input: RawUtf8;
!      out Output: RawUtf8): TProtocolResult;
!    procedure Encrypt(const Plain: RawByteString;
!      out Encrypted: RawByteString);
!    procedure Decrypt(const Encrypted: RawByteString;
!      out Plain: RawByteString);
!  end;
{}
:  Using TProtocolEcc
{}
!uses
!  mormot.crypt.ecc;
!
!var
!  ServerProtocol, ClientProtocol: IProtocol;
!  ServerCert: TEccCertificateSecret;
!  ClientCert: TEccCertificateSecret;
!  Handshake1, Handshake2, Handshake3: RawUtf8;
!begin
!  // Server setup
!  ServerCert := TEccCertificateSecret.CreateFromFile('server.private', 'pwd');
!  ServerProtocol := TProtocolEcc.Create(ServerCert, nil);
!
!  // Client setup
!  ClientCert := TEccCertificateSecret.CreateFromFile('client.private', 'pwd');
!  ClientProtocol := TProtocolEcc.Create(ClientCert,
!    TEccCertificate.CreateFromFile('server.public'));
!
!  // Three-way handshake
!  ClientProtocol.ProcessHandshake('', Handshake1);       // Client hello
!  ServerProtocol.ProcessHandshake(Handshake1, Handshake2); // Server response
!  ClientProtocol.ProcessHandshake(Handshake2, Handshake3); // Client finish
!
!  // Now encrypted communication is possible
!  var Plain := 'Secret message';
!  var Encrypted: RawByteString;
!
!  ClientProtocol.Encrypt(Plain, Encrypted);
!  ServerProtocol.Decrypt(Encrypted, Plain);
!end;
{}
:2309 X.509 Certificates
{}
:  X.509 Support
{}
mORMot also supports standard X.509 certificates:
{}
!uses
!  mormot.crypt.x509;
!
!var
!  Cert: ICryptCert;
!begin
!  // Create X.509 certificate with ECC
!  Cert := Cert('x509-es256');
!  Cert.Generate([cuDigitalSignature], 365, nil, nil,
!    'CN=My Server,O=My Company,C=US');
!
!  // Save in standard formats
!  Cert.Save(cccCertOnly, '', ccfPem);          // PEM format
!  Cert.Save(cccCertWithPrivateKey, 'pwd', ccfBinary);  // DER/PKCS12
!end;
{}
:  Loading X.509 from PEM/DER
{}
!var
!  Cert: ICryptCert;
!  PemContent: RawUtf8;
!begin
!  // Load PEM certificate
!  PemContent := StringFromFile('server.crt');
!  Cert := Cert('x509-es256');
!  Cert.LoadFromPem(PemContent, '');
!end;
{}
:2310 Command-Line ECC Tool
{}
:  Overview
{}
mORMot includes an {\f1\fs20 ecc} command-line tool for certificate operations:
{}
$# Key generation
$ecc new -auth "My Authority" -pass "secret" -days 3650
$
$# Sign a certificate
$ecc sign user.public -auth authority.private -pass "secret"
$
$# Encrypt a file
$ecc crypt document.pdf -pub recipient.public
$
$# Decrypt a file
$ecc decrypt document.pdf.synecc -priv recipient.private -pass "secret"
$
$# Verify signature
$ecc verify document.pdf.sign -pub signer.public
{}
:  Sample Location
{}
The ECC tool source is at:
!/mnt/w/mORMot2/ex/ecc/
{}
:2311 Integration with REST Services
{}
:  Signing Service Requests
{}
!uses
!  mormot.crypt.ecc,
!  mormot.rest.client;
!
!procedure SignRequest(Client: TRestHttpClient; const Body: RawUtf8);
!var
!  Secret: TEccCertificateSecret;
!  Signature: RawByteString;
!begin
!  Secret := TEccCertificateSecret.CreateFromFile('client.private', 'pwd');
!  try
!    Secret.Sign(Body, Signature);
!    Client.SessionHttpHeader := 'X-Signature: ' + BinToBase64(Signature);
!  finally
!    Secret.Free;
!  end;
!end;
{}
:  Server-Side Verification
{}
!procedure VerifyRequest(Ctxt: TRestServerUriContext);
!var
!  PublicCert: TEccCertificate;
!  SignatureB64: RawUtf8;
!  Signature: RawByteString;
!begin
!  SignatureB64 := Ctxt.InHeader['X-Signature'];
!  Signature := Base64ToBin(SignatureB64);
!
!  PublicCert := TEccCertificate.CreateFromFile('client.public');
!  try
!    if not PublicCert.Verify(Ctxt.Call^.InBody, Signature) then
!      Ctxt.Error('Invalid signature', HTTP_FORBIDDEN);
!  finally
!    PublicCert.Free;
!  end;
!end;
{}
:2312 Performance Considerations
{}
:  Stand-Alone vs OpenSSL
{}
|%45%34%21
|\b Operation|Stand-alone|OpenSSL\b0
|Key generation|Slower|Faster
|ECDSA sign|Comparable|Faster
|ECDSA verify|Comparable|Faster
|ECDH|Comparable|Faster
|%
{}
For production with heavy ECC workloads:
{}
!uses
!  mormot.crypt.openssl;
!
!initialization
!  RegisterOpenSsl;  // Use OpenSSL for ECC operations
{}
:  Caching Keys
{}
!var
!  CachedCert: TEccCertificateSecret;
!
!procedure InitializeCrypto;
!begin
!  // Load once at startup
!  CachedCert := TEccCertificateSecret.CreateFromFile('server.private', 'pwd');
!end;
!
!procedure FinalizeCrypto;
!begin
!  CachedCert.Free;
!end;
{}
:2313 Security Best Practices
{}
:  Private Key Protection
{}
!// ✓ Use password-protected storage
!Secret.SaveToSecureFile('key.private', 'StrongPassword', 100000);  // High PBKDF2 rounds
!
!// ✓ Clear sensitive data after use
!Secret.Free;  // Securely clears memory
!
!// ❌ Never log or display private keys
!Writeln(Secret.PrivateKey);  // NEVER DO THIS!
{}
:  Certificate Validation
{}
!// ✓ Always validate certificates
!if Chain.IsValid(Cert) <> ecvValidSigned then
!  raise Exception.Create('Invalid certificate');
!
!// ✓ Check expiration
!if Cert.IsExpired then
!  raise Exception.Create('Certificate expired');
!
!// ❌ Don't skip validation
!// ProcessData(Cert);  // Without validation - DANGEROUS
{}
:  Secure Random Generation
{}
mORMot uses {\f1\fs20 TAesPrng} for cryptographically secure random numbers:
{}
!uses
!  mormot.crypt.core;
!
!var
!  Random: TAesPrng;
!  Entropy: THash256;
!begin
!  Random := TAesPrng.Main;  // Thread-safe singleton
!  Random.FillRandom(Entropy);  // Cryptographically secure
!end;
{}
:2314 Summary
{}
:  Quick Reference
{}
|%68%32
|\b Need|Solution\b0
|Generate keys|{\f1\fs20 TEccCertificateSecret.CreateNew()}
|Sign data|{\f1\fs20 Secret.Sign()}
|Verify signature|{\f1\fs20 PublicCert.Verify()}
|Encrypt data|{\f1\fs20 PublicCert.Encrypt()}
|Decrypt data|{\f1\fs20 Secret.Decrypt()}
|Certificate chain|{\f1\fs20 TEccCertificateChain}
|X.509 support|{\f1\fs20 mormot.crypt.x509}
|Secure protocol|{\f1\fs20 TProtocolEcc}
|%
{}
:  Key Units
{}
|%12%88
|\b Unit|Purpose\b0
|{\f1\fs20 mormot.crypt.ecc256r1}|Low-level ECC (secp256r1)
|@!src\crypt\mormot.crypt.ecc.pas@|High-level ECC certificates
|{\f1\fs20 mormot.crypt.x509}|X.509 certificate support
|@!src\crypt\mormot.crypt.secure.pas@|Factory functions
|@!src\crypt\mormot.crypt.openssl.pas@|OpenSSL acceleration
|%
{}
{\i Next: Chapter 24 covers Domain-Driven Design patterns with mORMot.}
{}

; === mORMot2-SAD-Chapter-24.md ===
; Converted from Markdown - Chapter 24
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:24Domain-Driven Design
{}
{\i Building Maintainable Business Applications}
{}
Domain-Driven Design (@*DDD@) provides a set of patterns and practices for building complex business applications. m@*ORM@ot's architecture aligns naturally with DDD principles through its ORM, @*SOA@, and @*REST@ layers.
{}
:2401 Introduction to DDD
{}
:  What is DDD?
{}
Domain-Driven Design is a software development approach that:
{}
- Focuses on the {\b core domain} and domain logic
- Bases complex designs on a {\b model} of the domain
- Initiates creative collaboration between technical and domain experts
{}
:  Why DDD with mORMot?
{}
|%52%48
|\b mORMot Feature|DDD Concept\b0
|{\f1\fs20 TOrm} classes|Entities, Value Objects
|{\f1\fs20 IInvokable} interfaces|Domain Services
|{\f1\fs20 IRestOrm}|Repository Pattern
|{\f1\fs20 TRestBatch}|Unit of Work
|@*JSON@ serialization|DTOs
|Interface-based services|Application Services
|%
{}
:2402 DDD Building Blocks
{}
:  Core Concepts
{}
$┌─────────────────────────────────────────────────────────────────┐
$│                    DDD Building Blocks                          │
$├─────────────────────────────────────────────────────────────────┤
$│                                                                 │
$│  ┌─────────────────┐  ┌─────────────────┐                       │
$│  │ Value Objects   │  │ Entities        │                       │
$│  │                 │  │                 │                       │
$│  │ • Immutable     │  │ • Identity      │                       │
$│  │ • No identity   │  │ • Lifecycle     │                       │
$│  │ • Equality by   │  │ • Equality by   │                       │
$│  │   value         │  │   ID            │                       │
$│  └─────────────────┘  └─────────────────┘                       │
$│                              │                                  │
$│                              ▼                                  │
$│                    ┌─────────────────┐                          │
$│                    │ Aggregates      │                          │
$│                    │                 │                          │
$│                    │ • Root Entity   │                          │
$│                    │ • Consistency   │                          │
$│                    │   boundary      │                          │
$│                    │ • Transactional │                          │
$│                    └─────────────────┘                          │
$│                              │                                  │
$│              ┌───────────────┼───────────────┐                  │
$│              ▼               ▼               ▼                  │
$│     ┌──────────────┐ ┌──────────────┐ ┌──────────────┐          │
$│     │ Repository   │ │ Factory      │ │ Services     │          │
$│     │ (IRestOrm)   │ │ (Create)     │ │ (IInvokable) │          │
$│     └──────────────┘ └──────────────┘ └──────────────┘          │
$│                                                                 │
$└─────────────────────────────────────────────────────────────────┘
{}
:2403 Ubiquitous Language
{}
:  The Foundation of DDD
{}
The {\b Ubiquitous Language} is a shared vocabulary between developers and domain experts:
{}
!// ❌ Technical naming (unclear domain meaning)
!type
!  TData = class(TOrm)
!    property S: RawUtf8;      // What is S?
!    property N: Integer;       // What is N?
!    property F: Boolean;       // What is F?
!  end;
!
!// ✓ Ubiquitous Language (domain-clear)
!type
!  TCustomerOrder = class(TOrm)
!    property CustomerName: RawUtf8;
!    property OrderNumber: Integer;
!    property IsFulfilled: Boolean;
!  end;
{}
:  Specialized Types
{}
Use type aliases to express domain concepts:
{}
!type
!  // Make implicit explicit
!  TCustomerName = type RawUtf8;
!  TEmailAddress = type RawUtf8;
!  TOrderNumber = type Integer;
!  TCurrency = type Currency;
!
!  TCustomer = class(TOrm)
!  published
!    property Name: TCustomerName read fName write fName;
!    property Email: TEmailAddress read fEmail write fEmail;
!  end;
{}
Benefits:
- Compiler catches type mismatches
- Self-documenting code
- Domain concepts explicit in code
{}
:2404 Value Objects
{}
:  Characteristics
{}
Value Objects:
- Are {\b immutable} (no setters after creation)
- Have {\b no identity} (compared by value)
- Represent domain concepts (Money, Address, DateRange)
{}
:  Implementation with Records
{}
!type
!  /// Money value object - immutable
!  TMoney = packed record
!  private
!    fAmount: Currency;
!    fCurrency: RawUtf8;
!  public
!    class function Create(aAmount: Currency; const aCurrency: RawUtf8): TMoney; static;
!    function Add(const Other: TMoney): TMoney;
!    function Equals(const Other: TMoney): Boolean;
!    property Amount: Currency read fAmount;
!    property CurrencyCode: RawUtf8 read fCurrency;
!  end;
!
!class function TMoney.Create(aAmount: Currency; const aCurrency: RawUtf8): TMoney;
!begin
!  Result.fAmount := aAmount;
!  Result.fCurrency := aCurrency;
!end;
!
!function TMoney.Add(const Other: TMoney): TMoney;
!begin
!  if fCurrency <> Other.fCurrency then
!    raise EDomainError.Create('Cannot add different currencies');
!  Result := TMoney.Create(fAmount + Other.fAmount, fCurrency);
!end;
{}
:  Implementation with Classes
{}
!type
!  TAddress = class(TSynPersistent)
!  private
!    fStreet: RawUtf8;
!    fCity: RawUtf8;
!    fPostalCode: RawUtf8;
!    fCountry: RawUtf8;
!  public
!    constructor Create(const aStreet, aCity, aPostalCode, aCountry: RawUtf8);
!    function Equals(Other: TAddress): Boolean;
!  published
!    property Street: RawUtf8 read fStreet;      // No setter = immutable
!    property City: RawUtf8 read fCity;
!    property PostalCode: RawUtf8 read fPostalCode;
!    property Country: RawUtf8 read fCountry;
!  end;
{}
:2405 Entities
{}
:  Characteristics
{}
Entities:
- Have {\b identity} (unique ID)
- Have a {\b lifecycle} (created, modified, deleted)
- Are compared by {\b ID}, not values
{}
:  Implementation with TOrm
{}
!type
!  TCustomer = class(TOrm)
!  private
!    fName: RawUtf8;
!    fEmail: RawUtf8;
!    fRegistrationDate: TDateTime;
!    fStatus: TCustomerStatus;
!  public
!    // Domain behavior
!    procedure Activate;
!    procedure Deactivate;
!    function CanPlaceOrder: Boolean;
!  published
!    property Name: RawUtf8 read fName write fName;
!    property Email: RawUtf8 read fEmail write fEmail;
!    property RegistrationDate: TDateTime read fRegistrationDate write fRegistrationDate;
!    property Status: TCustomerStatus read fStatus write fStatus;
!  end;
!
!procedure TCustomer.Activate;
!begin
!  if fStatus = csDeactivated then
!    fStatus := csActive;
!end;
!
!function TCustomer.CanPlaceOrder: Boolean;
!begin
!  Result := (fStatus = csActive) and (fEmail <> '');
!end;
{}
:2406 Aggregates
{}
:  Concept
{}
An {\b Aggregate} is a cluster of domain objects treated as a single unit:
{}
- Has a {\b Root Entity} (the only entry point)
- Defines a {\b consistency boundary}
- External objects can only reference the root
{}
:  Order Aggregate Example
{}
!type
!  // Aggregate Root
!  TOrder = class(TOrm)
!  private
!    fCustomerID: TID;
!    fOrderDate: TDateTime;
!    fStatus: TOrderStatus;
!    fItems: TOrmMany;  // Nested entities
!    fTotalAmount: Currency;
!  public
!    // Only aggregate root exposes behavior
!    procedure AddItem(ProductID: TID; Quantity: Integer; UnitPrice: Currency);
!    procedure RemoveItem(ItemID: TID);
!    procedure Submit;
!    procedure Cancel;
!    function CalculateTotal: Currency;
!  published
!    property CustomerID: TID read fCustomerID write fCustomerID;
!    property OrderDate: TDateTime read fOrderDate write fOrderDate;
!    property Status: TOrderStatus read fStatus;
!    property Items: TOrmMany read fItems;  // Read-only access
!    property TotalAmount: Currency read fTotalAmount;
!  end;
!
!  // Nested entity (only accessible via TOrder)
!  TOrderItem = class(TOrm)
!  private
!    fOrderID: TID;
!    fProductID: TID;
!    fQuantity: Integer;
!    fUnitPrice: Currency;
!  published
!    property OrderID: TID read fOrderID write fOrderID;
!    property ProductID: TID read fProductID write fProductID;
!    property Quantity: Integer read fQuantity write fQuantity;
!    property UnitPrice: Currency read fUnitPrice write fUnitPrice;
!  end;
!
!procedure TOrder.AddItem(ProductID: TID; Quantity: Integer; UnitPrice: Currency);
!begin
!  if fStatus <> osCreated then
!    raise EDomainError.Create('Cannot modify submitted order');
!  // Add item logic...
!  fTotalAmount := CalculateTotal;
!end;
!
!procedure TOrder.Submit;
!begin
!  if Items.Count = 0 then
!    raise EDomainError.Create('Cannot submit empty order');
!  fStatus := osSubmitted;
!end;
{}
:2407 Repository Pattern
{}
:  Concept
{}
Repositories provide an abstraction over data access:
{}
$┌───────────────────┐     ┌───────────────────┐
$│   Domain Layer    │     │ Infrastructure    │
$├───────────────────┤     ├───────────────────┤
$│                   │     │                   │
$│  IOrderRepository │────►│ TOrmOrderRepo     │
$│  (interface)      │     │ (implementation)  │
$│                   │     │                   │
$└───────────────────┘     └───────────────────┘
{}
:  Repository Interface
{}
!type
!  IOrderRepository = interface(IInvokable)
!    ['{A1B2C3D4-...}']
!    function GetByID(ID: TID): TOrder;
!    function GetByCustomer(CustomerID: TID): TOrderObjArray;
!    procedure Save(Order: TOrder);
!    procedure Delete(Order: TOrder);
!  end;
{}
:  Implementation with IRestOrm
{}
!type
!  TOrmOrderRepository = class(TInterfacedObject, IOrderRepository)
!  private
!    fOrm: IRestOrm;
!  public
!    constructor Create(const aOrm: IRestOrm);
!    function GetByID(ID: TID): TOrder;
!    function GetByCustomer(CustomerID: TID): TOrderObjArray;
!    procedure Save(Order: TOrder);
!    procedure Delete(Order: TOrder);
!  end;
!
!function TOrmOrderRepository.GetByID(ID: TID): TOrder;
!begin
!  Result := TOrder.Create;
!  if not fOrm.Retrieve(ID, Result) then
!    FreeAndNil(Result);
!end;
!
!procedure TOrmOrderRepository.Save(Order: TOrder);
!begin
!  if Order.ID = 0 then
!    fOrm.Add(Order, True)
!  else
!    fOrm.Update(Order);
!end;
{}
:2408 Domain Services
{}
:  When to Use
{}
Domain Services handle operations that:
- Don't belong to any single Entity
- Involve multiple Aggregates
- Represent domain concepts (not @*CRUD@)
{}
:  Service Interface
{}
!type
!  IOrderProcessingService = interface(IInvokable)
!    ['{E5F6G7H8-...}']
!    function PlaceOrder(CustomerID: TID; const Items: TOrderItemArray): TID;
!    function CancelOrder(OrderID: TID): Boolean;
!    function CalculateShipping(OrderID: TID): Currency;
!  end;
!
!  IPricingService = interface(IInvokable)
!    ['{I9J0K1L2-...}']
!    function CalculateDiscount(CustomerID: TID; Amount: Currency): Currency;
!    function ApplyPromotion(const Code: RawUtf8; Amount: Currency): Currency;
!  end;
{}
:  Service Implementation
{}
!type
!  TOrderProcessingService = class(TInjectableObject, IOrderProcessingService)
!  private
!    fOrders: IOrderRepository;
!    fCustomers: ICustomerRepository;
!    fPricing: IPricingService;
!  public
!    constructor Create(const aOrders: IOrderRepository;
!                       const aCustomers: ICustomerRepository;
!                       const aPricing: IPricingService);
!    function PlaceOrder(CustomerID: TID; const Items: TOrderItemArray): TID;
!  end;
!
!function TOrderProcessingService.PlaceOrder(CustomerID: TID;
!  const Items: TOrderItemArray): TID;
!var
!  Customer: TCustomer;
!  Order: TOrder;
!  i: Integer;
!begin
!  // Domain validation
!  Customer := fCustomers.GetByID(CustomerID);
!  if Customer = nil then
!    raise EDomainError.Create('Customer not found');
!  if not Customer.CanPlaceOrder then
!    raise EDomainError.Create('Customer cannot place orders');
!
!  // Create aggregate
!  Order := TOrder.Create;
!  try
!    Order.CustomerID := CustomerID;
!    Order.OrderDate := Now;
!
!    for i := 0 to High(Items) do
!      Order.AddItem(Items[i].ProductID, Items[i].Quantity, Items[i].UnitPrice);
!
!    // Apply domain rules
!    Order.TotalAmount := fPricing.CalculateDiscount(CustomerID, Order.CalculateTotal);
!
!    Order.Submit;
!    fOrders.Save(Order);
!    Result := Order.ID;
!  finally
!    Order.Free;
!  end;
!end;
{}
:2409 Application Services
{}
:  Role
{}
Application Services:
- Orchestrate domain objects and services
- Handle transactions (Unit of Work)
- Don't contain business logic
- Convert between DTOs and domain objects
{}
:  Implementation
{}
!type
!  IOrderApplicationService = interface(IInvokable)
!    ['{M3N4O5P6-...}']
!    function CreateOrder(const Request: TCreateOrderRequest): TCreateOrderResponse;
!    function GetOrderStatus(OrderID: TID): TOrderStatusResponse;
!  end;
!
!  TOrderApplicationService = class(TInjectableObject, IOrderApplicationService)
!  private
!    fOrderService: IOrderProcessingService;
!    fOrders: IOrderRepository;
!  public
!    function CreateOrder(const Request: TCreateOrderRequest): TCreateOrderResponse;
!  end;
!
!function TOrderApplicationService.CreateOrder(
!  const Request: TCreateOrderRequest): TCreateOrderResponse;
!begin
!  try
!    Result.OrderID := fOrderService.PlaceOrder(Request.CustomerID, Request.Items);
!    Result.Success := True;
!    Result.Message := 'Order created successfully';
!  except
!    on E: EDomainError do
!    begin
!      Result.Success := False;
!      Result.Message := E.Message;
!    end;
!  end;
!end;
{}
:2410 Data Transfer Objects (DTOs)
{}
:  Purpose
{}
DTOs:
- Separate domain from external interfaces
- Define API contracts
- Allow domain to evolve independently
{}
:  Implementation
{}
!type
!  // Request DTO
!  TCreateOrderRequest = packed record
!    CustomerID: TID;
!    Items: TOrderItemDtoArray;
!  end;
!
!  TOrderItemDto = packed record
!    ProductID: TID;
!    Quantity: Integer;
!    UnitPrice: Currency;
!  end;
!
!  // Response DTO
!  TCreateOrderResponse = packed record
!    Success: Boolean;
!    OrderID: TID;
!    Message: RawUtf8;
!  end;
!
!  TOrderStatusResponse = packed record
!    OrderID: TID;
!    Status: RawUtf8;
!    TotalAmount: Currency;
!    ItemCount: Integer;
!  end;
{}
:2411 Clean Architecture
{}
:  Layer Structure
{}
$┌─────────────────────────────────────────────────────────────────┐
$│                     Infrastructure Layer                         │
$│     (Database, External Services, UI, HTTP Server)               │
$├─────────────────────────────────────────────────────────────────┤
$│                     Application Layer                            │
$│           (Use Cases, DTOs, Application Services)                │
$├─────────────────────────────────────────────────────────────────┤
$│                      Domain Layer                                │
$│   (Entities, Value Objects, Aggregates, Domain Services)         │
$└─────────────────────────────────────────────────────────────────┘
!
!Dependencies point inward → Domain has NO external dependencies
{}
:  mORMot Architecture Mapping
{}
|%35%65
|\b Layer|mORMot Components\b0
|Domain|{\f1\fs20 TOrm} entities, {\f1\fs20 TSynPersistent} value objects
|Application|{\f1\fs20 IInvokable} service interfaces
|Infrastructure|{\f1\fs20 TRestServer}, {\f1\fs20 TRestHttpServer}, SQL/NoSQL
|%
{}
:  Dependency Injection
{}
!var
!  Server: TRestServer;
!begin
!  Server := TRestServerDB.Create(Model, 'data.db3', True);
!
!  // Register services with DI
!  Server.ServiceDefine(TOrderProcessingService, [IOrderProcessingService], sicShared);
!  Server.ServiceDefine(TPricingService, [IPricingService], sicShared);
!  Server.ServiceDefine(TOrderApplicationService, [IOrderApplicationService], sicShared);
!
!  // Dependency resolution is automatic for constructor injection
!end;
{}
:2412 Unit of Work Pattern
{}
:  Using TRestBatch
{}
!procedure SaveOrderWithItems(Server: TRestServer; Order: TOrder);
!var
!  Batch: TRestBatch;
!  i: Integer;
!begin
!  Batch := TRestBatch.Create(Server, nil, 1000);
!  try
!    // Add order (will get ID after send)
!    Batch.Add(Order, True);
!
!    // Add all items
!    for i := 0 to Order.Items.Count - 1 do
!      Batch.Add(Order.Items[i], True);
!
!    // Atomic commit
!    if Server.BatchSend(Batch) <> HTTP_SUCCESS then
!      raise EDomainError.Create('Failed to save order');
!  finally
!    Batch.Free;
!  end;
!end;
{}
:2413 Event-Driven Design
{}
:  Domain Events
{}
!type
!  TDomainEvent = class(TSynPersistent)
!  private
!    fTimestamp: TDateTime;
!    fAggregateID: TID;
!  public
!    constructor Create(AggregateID: TID);
!  published
!    property Timestamp: TDateTime read fTimestamp;
!    property AggregateID: TID read fAggregateID;
!  end;
!
!  TOrderPlacedEvent = class(TDomainEvent)
!  private
!    fCustomerID: TID;
!    fTotalAmount: Currency;
!  published
!    property CustomerID: TID read fCustomerID write fCustomerID;
!    property TotalAmount: Currency read fTotalAmount write fTotalAmount;
!  end;
{}
:  Event Handling
{}
!type
!  IDomainEventHandler = interface
!    procedure Handle(Event: TDomainEvent);
!  end;
!
!  TOrderPlacedHandler = class(TInterfacedObject, IDomainEventHandler)
!  public
!    procedure Handle(Event: TDomainEvent);
!  end;
!
!procedure TOrderPlacedHandler.Handle(Event: TDomainEvent);
!var
!  OrderEvent: TOrderPlacedEvent;
!begin
!  if Event is TOrderPlacedEvent then
!  begin
!    OrderEvent := TOrderPlacedEvent(Event);
!    // Send notification, update inventory, etc.
!    SendOrderConfirmationEmail(OrderEvent.CustomerID, OrderEvent.AggregateID);
!  end;
!end;
{}
:2414 Testing DDD Code
{}
:  Domain Unit Tests
{}
!procedure TTestOrder.TestCannotAddItemToSubmittedOrder;
!var
!  Order: TOrder;
!begin
!  Order := TOrder.Create;
!  try
!    Order.AddItem(1, 2, 10.00);
!    Order.Submit;
!
!    // Should raise exception
!    CheckException(
!      procedure begin Order.AddItem(2, 1, 5.00); end,
!      EDomainError,
!      'Cannot modify submitted order'
!    );
!  finally
!    Order.Free;
!  end;
!end;
{}
:  Service Tests with Mocks
{}
!procedure TTestOrderService.TestPlaceOrderWithDiscount;
!var
!  MockOrders: IOrderRepository;
!  MockCustomers: ICustomerRepository;
!  MockPricing: IPricingService;
!  Service: IOrderProcessingService;
!begin
!  // Setup mocks
!  MockOrders := TMockOrderRepository.Create;
!  MockCustomers := TMockCustomerRepository.Create;
!  MockPricing := TMockPricingService.Create;
!
!  Service := TOrderProcessingService.Create(MockOrders, MockCustomers, MockPricing);
!
!  // Test
!  // ...
!end;
{}
:2415 Summary
{}
:  Key Patterns
{}
|%40%60
|\b Pattern|mORMot Implementation\b0
|Entity|{\f1\fs20 TOrm} class with business methods
|Value Object|{\f1\fs20 record} or immutable {\f1\fs20 TSynPersistent}
|Aggregate|{\f1\fs20 TOrm} with {\f1\fs20 TOrmMany} relations
|Repository|{\f1\fs20 IRestOrm} or custom interface
|Domain Service|{\f1\fs20 IInvokable} interface
|Application Service|{\f1\fs20 IInvokable} with DTO I/O
|Unit of Work|{\f1\fs20 TRestBatch}
|%
{}
:  Best Practices
{}
1. {\b Start with the domain} - Define entities and value objects first
2. {\b Use ubiquitous language} - Name types after domain concepts
3. {\b Keep domain pure} - No infrastructure dependencies
4. {\b Define clear boundaries} - One aggregate per transaction
5. {\b Test domain logic} - Unit tests for business rules
6. {\b Use interfaces} - Enable dependency injection and testing
{}
{\i Next: Chapter 25 covers Testing and Logging.}
{}

; === mORMot2-SAD-Chapter-25.md ===
; Converted from Markdown - Chapter 25
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:25Testing and Logging
{}
{\i Quality Assurance and Diagnostics}
{}
m@*ORM@ot provides comprehensive testing and logging capabilities through @!src\core\mormot.core.test.pas@ and @!src\core\mormot.core.log.pas@ units. These tools are essential for building reliable, maintainable applications.
{}
:2501 Automated Testing
{}
:  Why Test?
{}
Testing ensures:
- Code correctness
- Regression prevention
- Documentation through examples
- Refactoring confidence
- Design quality (testable code is better code)
{}
:  Test-Driven Development
{}
The recommended approach:
{}
1. Write a void implementation (interface only)
2. Write a test
3. Run test - it must {\b fail}
4. Implement the feature
5. Run test - it must {\b pass}
6. Refactor and repeat
{}
:2502 Testing Classes
{}
:  Class Hierarchy
{}
!TSynTest (abstract)
$├── TSynTestCase    → Individual test case
$└── TSynTests       → Test suite (runs multiple cases)
{}
:  TSynTestCase
{}
Defines individual tests in published methods:
{}
!uses
!  mormot.core.test;
!
!type
!  TTestMathOperations = class(TSynTestCase)
!  published
!    procedure TestAddition;
!    procedure TestMultiplication;
!    procedure TestDivision;
!  end;
!
!procedure TTestMathOperations.TestAddition;
!begin
!  Check(1 + 1 = 2, '1+1 should equal 2');
!  Check(Add(10, 20) = 30, 'Add function failed');
!  CheckEqual(Add(-5, 5), 0, 'Adding opposites');
!end;
{}
:  TSynTests
{}
Runs a suite of test cases:
{}
!type
!  TMyTestSuite = class(TSynTests)
!  published
!    procedure AllTests;
!  end;
!
!procedure TMyTestSuite.AllTests;
!begin
!  AddCase([
!    TTestMathOperations,
!    TTestStringOperations,
!    TTestDatabaseOperations
!  ]);
!end;
!
!// Main program
!begin
!  with TMyTestSuite.Create('My Application Tests') do
!  try
!    Run;
!    Readln;
!  finally
!    Free;
!  end;
!end.
{}
:2503 Check Methods
{}
:  Basic Assertions
{}
!// Boolean check
!Check(Value = Expected, 'Error message');
!
!// Equality checks
!CheckEqual(Actual, Expected, 'Error message');
!!CheckNotEqual(Actual, Unexpected, 'Error message');
!
!// Floating-point comparison (with tolerance)
!CheckSame(FloatValue, ExpectedFloat, 'Floating point error');
!
!// UTF-8 string comparison
!CheckUtf8(ActualStr, ExpectedStr, 'String mismatch');
!
!// Hash comparison
!CheckHash(ActualHash, ExpectedHash, 'Hash mismatch');
{}
:  Exception Testing
{}
!procedure TTestErrors.TestExceptionRaised;
!begin
!  // Verify exception is raised
!  CheckRaised(
!    procedure begin
!      raise EInvalidOperation.Create('Test');
!    end,
!    EInvalidOperation,
!    'Expected exception not raised'
!  );
!end;
{}
:  Custom Checks
{}
!procedure TTestCustomer.TestOrderValidation;
!var
!  Order: TOrder;
!begin
!  Order := TOrder.Create;
!  try
!    // Multiple checks
!    Check(Order.Items.Count = 0, 'New order should be empty');
!    Order.AddItem(1, 2, 10.00);
!    CheckEqual(Order.Items.Count, 1, 'Should have one item');
!    CheckSame(Order.TotalAmount, 20.00, 'Total should be 20.00');
!  finally
!    Order.Free;
!  end;
!end;
{}
:2504 Test Output
{}
:  Console Output
{}
!var
!  Suite: TMyTestSuite;
!begin
!  Suite := TMyTestSuite.Create('Test Suite');
!  try
!    Suite.Run;
!  finally
!    Suite.Free;
!  end;
!end;
{}
Output example:
!Test Suite
!
!1. Math Operations
!  - Addition: 3 assertions passed  12.5 us
!  - Multiplication: 5 assertions passed  8.2 us
!  - Division: 4 assertions passed  6.1 us
!
!2. String Operations
!  - Concatenation: 10 assertions passed  25.3 us
!  - Parsing: 8 assertions passed  18.7 us
!
!Total: 30 assertions passed in 2 test cases
{}
:  Test Options
{}
!type
!  TSynTestOptions = set of (
!    tcoLogEachCheck,        // Log each Check() call
!    tcoLogInSubFolder,      // Put logs in ./log subfolder
!    tcoLogVerboseRotate,    // Rotate large log files
!    tcoLogNotHighResolution // Use plain ISO-8601 timestamps
!  );
!
!// Configure
!Suite.Options := [tcoLogEachCheck, tcoLogInSubFolder];
{}
:2505 Testing with Logging
{}
:  TSynTestsLogged
{}
Combines testing with logging:
{}
!type
!  TMyLoggedTests = class(TSynTestsLogged)
!  published
!    procedure AllTests;
!  end;
!
!begin
!  with TMyLoggedTests.Create('Logged Tests') do
!  try
!    Run;
!  finally
!    Free;
!  end;
!end;
{}
:  Log Levels in Tests
{}
!procedure TTestWithLogging.TestDatabaseConnection;
!begin
!  TSynLog.Enter(self, 'TestDatabaseConnection');
!
!  Log.Log(sllInfo, 'Connecting to database...');
!  // Test code...
!  Log.Log(sllDebug, 'Connection established');
!
!  Check(Connected, 'Should be connected');
!end;
{}
:2506 Mocking and Stubbing
{}
:  Interface Mocking
{}
!uses
!  mormot.core.interfaces;
!
!type
!  ICalculator = interface(IInvokable)
!    ['{...}']
!    function Add(A, B: Integer): Integer;
!    function Multiply(A, B: Integer): Integer;
!  end;
!
!procedure TTestWithMocks.TestServiceWithMockedDependency;
!var
!  Mock: TInterfaceMock;
!  Calculator: ICalculator;
!begin
!  // Create mock
!  Mock := TInterfaceMock.Create(TypeInfo(ICalculator), Calculator, self);
!
!  // Define behavior
!  Mock.ExpectsCount('Add', qoEqualTo, 2);         // Expect 2 calls
!  Mock.Returns('Add', [10, 20], 30);              // Return 30 for Add(10,20)
!  Mock.Returns('Multiply', [], 100);              // Return 100 for any Multiply
!
!  // Use mock
!  CheckEqual(Calculator.Add(10, 20), 30);
!  CheckEqual(Calculator.Multiply(5, 5), 100);
!
!  // Verify expectations
!  Mock.Verify;
!end;
{}
:  Stubbing
{}
!procedure TTestStubs.TestWithStub;
!var
!  Stub: TInterfaceStub;
!  Service: IMyService;
!begin
!  // Create stub (no verification)
!  Stub := TInterfaceStub.Create(TypeInfo(IMyService), Service);
!
!  // Define returns
!  Stub.Returns('GetValue', [], 'stubbed value');
!
!  // Use stub
!  CheckEqual(Service.GetValue, 'stubbed value');
!end;
{}
:  Mock Options
{}
!type
!  TInterfaceMockOptions = set of (
!    imoMockFailsWillPassTestCase,  // Failures don't fail test
!    imoFakeInstanceCreation,       // Create fake objects
!    imoLogMethodCallsAndResults    // Log all calls
!  );
!
!Mock.Options := [imoLogMethodCallsAndResults];
{}
:2507 Logging with TSynLog
{}
:  Logging Architecture
{}
$┌─────────────────────────────────────────────────────────────────┐
$│                    Logging Architecture                         │
$├─────────────────────────────────────────────────────────────────┤
$│                                                                 │
$│  ┌─────────────────┐                                            │
$│  │ TSynLogFamily   │  Configuration (levels, rotation, etc.)    │
$│  │ (per-class)     │                                            │
$│  └────────┬────────┘                                            │
$│           │                                                     │
$│           ▼                                                     │
$│  ┌─────────────────┐                                            │
$│  │ TSynLog         │  Logger instance (per-thread)              │
$│  │ (per-thread)    │                                            │
$│  └────────┬────────┘                                            │
$│           │                                                     │
$│           ▼                                                     │
$│  ┌─────────────────────────────────────────┐                    │
$│  │              Log File                    │                   │
$│  │  • Automatic rotation                    │                   │
$│  │  • Stack traces on errors               │                    │
$│  │  • Thread-safe writes                   │                    │
$│  └─────────────────────────────────────────┘                    │
$│                                                                 │
$└─────────────────────────────────────────────────────────────────┘
{}
:  Basic Logging
{}
!uses
!  mormot.core.log;
!
!// Simple logging
!TSynLog.Add.Log(sllInfo, 'Application started');
!TSynLog.Add.Log(sllDebug, 'Processing item %', [ItemID]);
!TSynLog.Add.Log(sllError, 'Failed to connect: %', [ErrorMessage]);
{}
:  Log Levels
{}
!type
!  TSynLogLevel = (
!    sllNone,          // No logging
!    sllInfo,          // Informational messages
!    sllDebug,         // Debug information
!    sllTrace,         // Detailed tracing
!    sllWarning,       // Warnings
!    sllError,         // Errors
!    sllEnter,         // Method entry
!    sllLeave,         // Method exit
!    sllLastError,     // OS last error
!    sllException,     // Exception caught
!    sllExceptionOS,   // OS exception
!    sllMemory,        // Memory allocation
!    sllStackTrace,    // Stack trace
!    sllFail,          // Test failure
!    sllSQL,           // SQL statements
!    sllCache,         // Cache operations
!    sllResult,        // Method results
!    sllDB,            // Database operations
!    sllHTTP,          // HTTP traffic
!    sllClient,        // Client operations
!    sllServer,        // Server operations
!    sllServiceCall,   // Service invocations
!    sllServiceReturn, // Service returns
!    sllUserAuth,      // User authentication
!    sllCustom1..4,    // Custom levels
!    sllNewRun,        // New run marker
!    sllDDDError,      // DDD errors
!    sllDDDInfo,       // DDD info
!    sllMonitoring     // Monitoring data
!  );
{}
:2508 TSynLogFamily Configuration
{}
:  Basic Configuration
{}
!var
!  LogFamily: TSynLogFamily;
!begin
!  LogFamily := TSynLog.Family;
!
!  // Set log levels
!  LogFamily.Level := LOG_VERBOSE;  // All levels
!
!  // Or specific levels
!  LogFamily.Level := [sllInfo, sllWarning, sllError, sllException];
!
!  // File settings
!  LogFamily.PerThreadLog := ptIdentifiedInOneFile;  // One file, thread IDs
!  LogFamily.DestinationPath := 'C:\Logs\';
!  LogFamily.FileExistsAction := acAppend;
!end;
{}
:  Log Rotation
{}
!// Rotate by size
!LogFamily.RotateFileCount := 5;           // Keep 5 files
!LogFamily.RotateFileSizeKB := 10240;      // 10MB per file
!
!// Rotate by time
!LogFamily.RotateFileDailyAtHour := 0;     // Rotate at midnight
!
!// Archive rotated logs
!LogFamily.RotateFileArchiveCompression := acSynLz;  // Compress with SynLZ
{}
:  Stack Traces
{}
!// Enable stack traces for errors
!LogFamily.LevelStackTrace := [sllError, sllException, sllExceptionOS];
!
!// Requires .map or .mab file for readable stack traces
!// Generate .mab from .map:
!// mormot2tests.map -> mormot2tests.mab (much smaller)
{}
:2509 Structured Logging
{}
:  Method Enter/Leave
{}
!procedure TMyClass.ProcessData(const Data: TData);
!begin
!  TSynLog.Enter(self, 'ProcessData');  // Logs entry with timestamp
!
!  // Processing...
!  TSynLog.Add.Log(sllDebug, 'Processing % bytes', [Length(Data)]);
!
!  // Automatic leave logging on scope exit
!end;
{}
Output:
!20230615 14:32:15.123  +    TMyClass.ProcessData
!20230615 14:32:15.125       Processing 1024 bytes
!20230615 14:32:15.130  -    00.007
{}
:  Logging Objects
{}
!// Log object as JSON
!TSynLog.Add.Log(sllDebug, Customer);  // Serializes to JSON
!
!// Log with context
!TSynLog.Add.Log(sllInfo, 'Customer loaded: %', [Customer], TypeInfo(TCustomer));
{}
:  SQL Logging
{}
!// Enable SQL logging
!LogFamily.Level := LogFamily.Level + [sllSQL, sllDB];
!
!// SQL statements are automatically logged by ORM
!// Output:
!// 20230615 14:35:22.456  SQL   SELECT * FROM Customer WHERE ID=?
{}
:2510 ISynLog Interface
{}
:  Interface-Based Logging
{}
!uses
!  mormot.core.log;
!
!procedure ProcessWithLogging;
!var
!  Log: ISynLog;
!begin
!  Log := TSynLog.Enter(nil, 'ProcessWithLogging');
!
!  Log.Log(sllInfo, 'Starting process');
!
!  try
!    // Work...
!    Log.Log(sllDebug, 'Step 1 complete');
!  except
!    on E: Exception do
!    begin
!      Log.Log(sllException, E);
!      raise;
!    end;
!  end;
!end;  // Automatic leave logged
{}
:  Dependency Injection with Logging
{}
!type
!  IMyService = interface
!    procedure DoWork;
!  end;
!
!  TMyService = class(TInterfacedObject, IMyService)
!  private
!    fLog: ISynLog;
!  public
!    constructor Create(const aLog: ISynLog);
!    procedure DoWork;
!  end;
!
!procedure TMyService.DoWork;
!begin
!  fLog.Log(sllInfo, 'Starting work');
!  // ...
!end;
{}
:2511 Debug Symbols
{}
:  TDebugFile
{}
For readable stack traces, provide debug symbols:
{}
!// Delphi: Generate .map file (Project Options > Linker > Map File = Detailed)
!// FPC: Compile with -gl flag, or use external .dbg file
!
!// Convert .map to .mab (optimized format)
!TDebugFile.Create('myapp.map', true);  // Creates myapp.mab
{}
:  .mab File Benefits
{}
|%20%49%31
|\b Format|Size (typical)|Load Time\b0
|.map|4-15 MB|Slow
|.dbg|10-50 MB|Slow
|.mab|200-500 KB|Fast
|%
{}
:2512 Exception Logging
{}
:  Global Exception Handler
{}
!uses
!  mormot.core.log;
!
!begin
!  // Install global exception handler
!  TSynLog.Family.Level := LOG_VERBOSE + [sllExceptionOS];
!
!  // All unhandled exceptions are logged with stack trace
!end;
{}
:  Manual Exception Logging
{}
!procedure SafeProcess;
!begin
!  try
!    RiskyOperation;
!  except
!    on E: Exception do
!    begin
!      TSynLog.Add.Log(sllException, E);
!      // Or with additional context
!      TSynLog.Add.Log(sllException, '% during % processing',
!        [E.ClassName, OperationName], E);
!      raise;
!    end;
!  end;
!end;
{}
:2513 Remote Logging
{}
:  Log to Remote Server
{}
!uses
!  mormot.core.log,
!  mormot.net.client;
!
!var
!  LogFamily: TSynLogFamily;
!begin
!  LogFamily := TSynLog.Family;
!
!  // Enable remote logging
!  LogFamily.EchoRemoteClient := THttpClientSocket.Create('logserver', '8080');
!  LogFamily.EchoRemoteClientOwned := True;
!end;
{}
:  SysLog Support
{}
!// Send to SysLog server (RFC 5424)
!LogFamily.EchoToSysLog := True;
!LogFamily.SysLogFacility := sfLocal0;
{}
:2514 Log File Analysis
{}
:  TSynLogFile
{}
Read and analyze log files:
{}
!uses
!  mormot.core.log;
!
!var
!  LogFile: TSynLogFile;
!  i: Integer;
!begin
!  LogFile := TSynLogFile.Create('app.log');
!  try
!    // Iterate events
!    for i := 0 to LogFile.EventCount - 1 do
!    begin
!      Writeln(LogFile.EventDateTime[i], ': ',
!              LogFile.EventLevel[i], ' - ',
!              LogFile.EventText[i]);
!    end;
!
!    // Get specific level events
!    Writeln('Errors: ', LogFile.EventCount(sllError));
!  finally
!    LogFile.Free;
!  end;
!end;
{}
:  LogView Tool
{}
mORMot provides a visual log viewer:
- Located in {\f1\fs20 ex/logview/}
- Features: filtering, search, statistics
- Supports all log formats
{}
:2515 Performance Considerations
{}
:  Conditional Logging
{}
!// Use conditional to avoid string formatting overhead
!if sllDebug in TSynLog.Family.Level then
!  TSynLog.Add.Log(sllDebug, 'Complex: % + %', [ExpensiveCall1, ExpensiveCall2]);
{}
:  Async Logging
{}
!// Enable async writes (background thread)
!LogFamily.BufferSize := 32768;  // 32KB buffer
!LogFamily.NoFile := False;
{}
:  Production Settings
{}
!// Production: minimal overhead
!LogFamily.Level := [sllWarning, sllError, sllException];
!LogFamily.LevelStackTrace := [sllException];
!LogFamily.RotateFileCount := 10;
!LogFamily.RotateFileSizeKB := 20480;  // 20MB
!
!// Development: verbose
!LogFamily.Level := LOG_VERBOSE;
!LogFamily.LevelStackTrace := [sllError, sllException, sllExceptionOS];
{}
:2516 Summary
{}
:  Testing Quick Reference
{}
|%20%80
|\b Class|Purpose\b0
|{\f1\fs20 TSynTestCase}|Individual test case
|{\f1\fs20 TSynTests}|Test suite runner
|{\f1\fs20 TSynTestsLogged}|Suite with logging
|{\f1\fs20 TInterfaceMock}|Interface mocking
|{\f1\fs20 TInterfaceStub}|Interface stubbing
|%
{}
|%25%75
|\b Method|Purpose\b0
|{\f1\fs20 Check()}|Boolean assertion
|{\f1\fs20 CheckEqual()}|Equality assertion
|{\f1\fs20 CheckSame()}|Float comparison
|{\f1\fs20 CheckRaised()}|Exception testing
|%
{}
:  Logging Quick Reference
{}
|%20%80
|\b Class|Purpose\b0
|{\f1\fs20 TSynLog}|Logger instance
|{\f1\fs20 TSynLogFamily}|Logger configuration
|{\f1\fs20 ISynLog}|Logger interface
|{\f1\fs20 TSynLogFile}|Log file reader
|{\f1\fs20 TDebugFile}|Debug symbols
|%
{}
|%18%82
|\b Level|Use For\b0
|{\f1\fs20 sllInfo}|Informational messages
|{\f1\fs20 sllDebug}|Debug output
|{\f1\fs20 sllWarning}|Warnings
|{\f1\fs20 sllError}|Errors
|{\f1\fs20 sllException}|Exceptions
|{\f1\fs20 sllSQL}|SQL statements
|{\f1\fs20 sll@*HTTP@}|HTTP traffic
|%
{}
:  Key Units
{}
|%19%81
|\b Unit|Purpose\b0
|@!src\core\mormot.core.test.pas@|Testing framework
|@!src\core\mormot.core.log.pas@|Logging framework
|@!src\core\mormot.core.interfaces.pas@|Mocking support
|%
{}
{\i This concludes the mORMot2 SAD Guide. For additional information, consult the source code documentation and the official mORMot forum.}
{}

; === mORMot2-SAD-Chapter-26.md ===
; Converted from Markdown - Chapter 26
; Auto-generated by md_to_pro_enhanced.py
; Includes: keyword indexing, unit links, smart column widths

:Chapter 26: Source Code
{}
{\i Adopt a m@*ORM@ot}
{}
This chapter covers the licensing terms of the {\i mORMot 2} framework, its source code availability, and complete installation instructions for both Delphi and Free Pascal/Lazarus development environments. Understanding how to properly set up your development environment is essential for working effectively with {\i mORMot 2}.
{}
:2601 License
{}
:  Three Licenses Model
{}
The framework source code is licensed under a disjunctive three-license giving the user the choice of one of the three following sets of free software/open source licensing terms:
- {\i Mozilla Public License}, version 1.1 or later (MPL);
- {\i GNU General Public License}, version 2.0 or later (GPL);
- {\i GNU Lesser General Public License}, version 2.1 or later (LGPL), with {\i linking exception} of the {\i FPC modified LGPL}.
{}
{\i FPC modified LGPL} is the {\i Library GNU General Public License} with the following modification:
{}
{\i As a special exception of the LGPL, the copyright holders of this library give you permission to link this library with independent modules to produce an executable, regardless of the license terms of these independent modules, and to copy and distribute the resulting executable under terms of your choice, provided that you also meet, for each linked independent module, the terms and conditions of the license of that module. An independent module is a module which is not derived from or based on this library. If you modify this library, you may extend this exception to your version of the library, but you are not obligated to do so. If you do not wish to do so, delete this exception statement from your version.}
{}
This allows the use of the framework code in a wide variety of software projects, while still maintaining intellectual rights on library code.
{}
In short:
- For GPL projects, use the GPL license - see @http://www.gnu.org/licenses/gpl-2.0.html
- For LGPL projects, use the LGPL license - see @http://www.gnu.org/licenses/lgpl-2.1.html
- For commercial projects, use the MPL License - see @http://www.mozilla.org/MPL/MPL-1.1.html - which is the most permissive, or the FPC modified LGPL license, thanks to its linking exception - see @http://wiki.freepascal.org/modified_LGPL
{}
:  Publish Modifications and Credit for the Library
{}
In all cases, any modification made to this source code {\b should} be published by any mean (e.g. a download link), even in case of MPL. If you need any additional feature, use the forums and we may introduce a patch to the main framework trunk.
{}
You do not have to pay any fee for using our MPL/GPL/LGPL libraries.
{}
But please do not forget to put somewhere in your credit window or documentation, a link to @https://synopse.info if you use any of the units published under this tri-license.
{}
For instance, if you select the MPL license, here are the requirements:
- You accept the license terms with no restriction - see @http://www.mozilla.org/MPL/2.0/FAQ.html for additional information;
- You have to publish any modified unit in a public web site (e.g. {\f1\fs20 @http://YourSoftwareCompany.com/MPL}), with a description of applied modifications, and no removal of the original license header in source code;
- You make appear some notice available in the program (About box, documentation, online help), stating e.g.
{}
{\i This software uses some third-party code of the Synopse mORMot framework (C) 2025 Arnaud Bouchez - @https://synopse.info - under Mozilla Public License 1.1; modified source code is available at @http://SoftwareCompany.com/MPL}
{}
Note that this documentation is under GPL 3.0 license only, as stated in this document front page.
{}
:  Derivate Open Source Works
{}
If you want to include part of the framework source code in your own open-source project, you may publish it with a comment similar to this one:
{}
!{
!  Sample based on official mORMot 2 sample
!
!  Synopse mORMot 2 framework. Copyright (C) 2025 Arnaud Bouchez
!    Synopse Informatique - https://synopse.info
!  Original tri-license: MPL 1.1/GPL 2.0/LGPL 2.1
!}
{}
You need to ensure that your Open Source project licensing is compatible with our Licensing Terms, and, if possible, notify us that you use our code.
{}
:  Legal Notice
{}
There are countries that restrict the use, import, export of cryptographic software. Before keeping, using, or distributing the software, make sure that you comply with these restrictions. If (for any reason) you are unable to do so, you are not allowed to download, use, or distribute the software.
{}
If you are residing in a country that allows software patents you must verify that no part of the software is covered by a patent in your country. If (for any reason) you are unable to do so, you are not allowed to use or distribute the software.
{}
:  Commercial Licenses
{}
Even though our libraries are Open Source with permissive licenses, some users want to obtain a license anyway. For instance, you may want to hold a tangible legal document as evidence that you have the legal right to use and distribute your software containing our library code, or, more likely, your legal department tells you that you have to purchase a license.
{}
If you feel like you really have to purchase a license for our libraries, {\i Synopse}, the company that employs the architect and principal developer of the library, will sell you one. Please contact us directly for a contract proposal.
{}
:2602 Availability
{}
As a true {\i Open Source} project, all source code of the framework is available. The primary location for {\i mORMot 2} source code is:
{}
{\b GitHub Repository}: @https://github.com/synopse/mORMot2
{}
The source has been commented following the scheme used by documentation tools. All interface definitions of the units have special comments which provide inline documentation.
{}
:  Obtaining the Source Code
{}
There are two primary methods to obtain the {\i mORMot 2} source code:
{}
#### Method 1: Clone the Repository (Recommended)
{}
Cloning the Git repository is the preferred method, as it allows you to easily update to the latest version:
{}
$git clone https://github.com/synopse/mORMot2.git
{}
For example, clone into {\f1\fs20 c:\github\mORMot2} on Windows or {\f1\fs20 ~/github/mORMot2} on Linux/macOS.
{}
#### Method 2: Download a Release Archive
{}
For a specific stable version (e.g., for use in a build script):
1. Go to @https://github.com/synopse/mORMot2/releases
2. Download the {\i Source code (zip)} for your desired release
3. Extract it to your chosen location (e.g., {\f1\fs20 d:\mormot2})
{}
:  Static Libraries
{}
After obtaining the source code, you need to download the static libraries for @*SQLite3@ and other compiled C code:
{}
{\b Download Options:}
- @https://synopse.info/files/mormot2static.7z (Windows-friendly, 7-Zip compressed)
- @https://synopse.info/files/mormot2static.tgz (POSIX-friendly, tar/gzip compressed)
- From the matching GitHub release page
{}
{\b Important:} Extract the static files into the {\f1\fs20 static} sub-folder of your {\i mORMot 2} installation.
{}
For example, if you cloned to {\f1\fs20 c:\github\mORMot2}, the static files should be in {\f1\fs20 c:\github\mORMot2\static\}.
{}
For safety, the SHA-256 checksums of the current version of the downloaded binary files are available in the {\f1\fs20 static/dev.sha256} file.
{}
:  Version Synchronization
{}
{\b Important:} Always keep the static binaries in sync with the framework source code. Version mismatches can cause unexpected errors.
{}
The static files are typically updated to match SQLite3 releases, sometimes with a short delay to ensure stability after major SQLite3 releases.
{}
:2603 Repository Structure
{}
The {\i mORMot 2} repository is organized into the following main folders:
{}
|%8%92
|\b Folder|Description\b0
|{\f1\fs20 src/}|Main source code folder containing the framework units
|{\f1\fs20 packages/}|{\f1\fs20 IDE} packages and tools for development environment setup
|{\f1\fs20 static/}|Pre-compiled binary {\f1\fs20 .o}/{\f1\fs20 .obj} files for static linking
|{\f1\fs20 test/}|Regression tests for all framework features
|{\f1\fs20 res/}|Resources used within {\f1\fs20 src/}, including static third-party binaries source
|{\f1\fs20 doc/}|Framework documentation
|{\f1\fs20 ex/}|Example projects and samples
|%
{}
:  Source Code Organization (src/)
{}
The {\f1\fs20 src/} folder contains the framework source code organized into logical layers:
{}
|%10%56%34
|\b Sub-folder|Description|Key Units\b0
|{\f1\fs20 core/}|Core utilities: @*RTTI@, @*JSON@, text, logging, threads|{\f1\fs20 mormot.core.base.pas}, {\f1\fs20 mormot.core.json.pas}, {\f1\fs20 mormot.core.log.pas}
|{\f1\fs20 lib/}|Raw API definitions for external libraries|{\f1\fs20 mormot.lib.openssl11.pas}, {\f1\fs20 mormot.lib.curl.pas}
|{\f1\fs20 crypt/}|Cryptographic primitives and secure protocols|{\f1\fs20 mormot.crypt.core.pas}, {\f1\fs20 mormot.crypt.jwt.pas}, {\f1\fs20 mormot.crypt.openssl.pas}
|{\f1\fs20 net/}|Network layer: @*HTTP@, @*WebSocket@s, async servers|{\f1\fs20 mormot.net.http.pas}, {\f1\fs20 mormot.net.server.pas}, {\f1\fs20 mormot.net.ws.pas}
|{\f1\fs20 db/}|Database access: SynDB, SQLite3, SQL/NoSQL|{\f1\fs20 mormot.db.core.pas}, {\f1\fs20 mormot.db.sql.pas}, {\f1\fs20 mormot.db.nosql.mongodb.pas}
|{\f1\fs20 orm/}|Object-Relational Mapping|{\f1\fs20 mormot.orm.core.pas}, {\f1\fs20 mormot.orm.sql.pas}
|{\f1\fs20 rest/}|@*REST@ client and server|{\f1\fs20 mormot.rest.core.pas}, {\f1\fs20 mormot.rest.server.pas}, {\f1\fs20 mormot.rest.http.server.pas}
|{\f1\fs20 soa/}|Service-Oriented Architecture (interfaces)|{\f1\fs20 mormot.soa.core.pas}, {\f1\fs20 mormot.soa.server.pas}
|{\f1\fs20 app/}|Application layer: daemon, console helpers|{\f1\fs20 mormot.app.daemon.pas}, {\f1\fs20 mormot.app.console.pas}
|{\f1\fs20 script/}|Scripting engine support (QuickJS)|{\f1\fs20 mormot.script.quickjs.pas}
|{\f1\fs20 ui/}|User interface components (VCL/LCL)|{\f1\fs20 mormot.ui.controls.pas}
|{\f1\fs20 ddd/}|Domain-Driven Design support|@*DDD@ infrastructure and patterns
|{\f1\fs20 tools/}|Command-line tools source code|ECC tool, etc.
|{\f1\fs20 misc/}|Miscellaneous utilities|Various helper units
|%
{}
:  Key Include Files
{}
The {\f1\fs20 src/} folder contains important include files:
{}
|%8%92
|\b File|Description\b0
|{\f1\fs20 mormot.defines.inc}|Global compiler conditionals and settings
|{\f1\fs20 mormot.uses.inc}|Common uses clause for console applications
|{\f1\fs20 mormot.commit.inc}|Current commit hash (updated automatically)
|%
{}
:  Static Libraries Structure
{}
The {\f1\fs20 static/} folder contains pre-compiled binaries organized by target platform:
{}
{\b For FPC (cross-platform):}
!static/
$├── i386-win32/          # Windows 32-bit
$├── x86_64-win64/        # Windows 64-bit
$├── i386-linux/          # Linux 32-bit
$├── x86_64-linux/        # Linux 64-bit
$├── aarch64-linux/       # Linux ARM64
$├── arm-linux/           # Linux ARM32
$├── i386-darwin/         # macOS 32-bit (legacy)
$├── x86_64-darwin/       # macOS 64-bit Intel
$├── aarch64-darwin/      # macOS ARM64 (Apple Silicon)
$├── x86_64-freebsd/      # FreeBSD 64-bit
$└── x86_64-openbsd/      # OpenBSD 64-bit
{}
{\b For Delphi:}
!static/
$└── delphi/              # Win32 .obj and Win64 .o files
{}
:2604 Expected Compilation Targets
{}
:  Compiler Support
{}
The framework source code:
- Tries to stay compatible with FPC stable and Delphi 7 and up
- Is currently validated against:
  - {\b FPC}: 3.2.3 (fixes-3_2 branch) and Lazarus 2.2.5 (fixes_2_2 branch)
  - {\b Delphi}: 7, 2007, 2009, 2010, XE4, XE7, XE8, 10.4, 11.1, 12.2 Athenes
{}
{\b Note:} FPC 3.2.2 has a regression with variant late binding. Use the FPC 3.2.3 fixes branch instead.
{}
:  Platform Support
{}
{\b Server-Side (Full Framework):}
{}
|%64%10%26
|\b Platform|FPC|Delphi\b0
|Windows 32-bit|✓|✓
|Windows 64-bit|✓|✓ (XE2+)
|Linux x86_64|✓|-
|Linux i386|✓|-
|Linux ARM64|✓|-
|Linux ARM32|✓|-
|macOS Intel|✓|-
|macOS Apple Silicon|✓|-
|FreeBSD|✓|-
|OpenBSD|✓|-
|%
{}
{\b Client-Side (Cross-Platform Units):}
- All Delphi targets (Windows, iOS, Android, macOS, Linux) can use the cross-platform client units
- FPC provides full server and client support on all listed platforms
{}
:  Pure Pascal Fallbacks
{}
The static {\f1\fs20 .o}/{\f1\fs20 .obj} files are {\b not mandatory} to compile the framework. There is always a "pure Pascal" fallback code available for:
- SQLite3 engine (use external dynamic library instead)
- Cryptographic routines
- Compression algorithms
{}
However, the static-linked versions typically provide better performance and simpler deployment.
{}
:2605 Delphi Installation
{}
:  Step-by-Step Setup
{}
Follow these steps to set up {\i mORMot 2} for Delphi:
{}
{\b Step 1: Get the Source Code}
{}
Clone the repository or download a release:
$cd c:\github
$git clone https://github.com/synopse/mORMot2.git
{}
{\b Step 2: Download Static Libraries}
{}
Download and extract {\f1\fs20 mormot2static.7z} from @https://synopse.info/files/mormot2static.7z into {\f1\fs20 c:\github\mORMot2\static\}.
{}
{\b Step 3: Create Environment Variable}
{}
In Delphi {\f1\fs20 IDE}:
1. Go to {\i Tools} → {\i Options} → {\i {\f1\fs20 IDE}} → {\i Environment Variables}
2. Create a new {\b User System Override} variable:
   - Name: {\f1\fs20 mormot2}
   - Value: {\f1\fs20 c:\github\mORMot2\src} (or your chosen path)
{}
{\b Step 4: Configure Library Paths}
{}
In Delphi {\f1\fs20 IDE}:
1. Go to {\i Tools} → {\i Options} → {\i Language} → {\i Delphi Options} → {\i Library}
2. Add the following to the {\b Library path} for each target platform (Win32, Win64):
{}
!$(mormot2);$(mormot2)\core;$(mormot2)\lib;$(mormot2)\crypt;$(mormot2)\net;$(mormot2)\db;$(mormot2)\rest;$(mormot2)\orm;$(mormot2)\soa;$(mormot2)\app;$(mormot2)\script;$(mormot2)\ui;$(mormot2)\tools;$(mormot2)\misc
{}
{\b Step 5: Verify Installation}
{}
1. Open {\f1\fs20 test/mormot2tests.dpr} in the {\f1\fs20 IDE}
2. Compile and run the regression tests
3. All tests should pass on your machine
{}
:  Quick Path Setup Reference
{}
Here's a condensed version of the library path string to copy:
{}
!$(mormot2);$(mormot2)\core;$(mormot2)\lib;$(mormot2)\crypt;$(mormot2)\net;$(mormot2)\db;$(mormot2)\rest;$(mormot2)\orm;$(mormot2)\soa;$(mormot2)\app;$(mormot2)\script;$(mormot2)\ui;$(mormot2)\tools;$(mormot2)\misc
{}
:  No Packages Required
{}
Unlike some frameworks, {\i mORMot 2} does not require installing {\f1\fs20 IDE} packages for Delphi. Simply configure the library paths and you're ready to go.
{}
The framework uses relative paths in its source code to include the expected {\f1\fs20 .o}/{\f1\fs20 .obj} files from the {\f1\fs20 static\delphi} sub-folder automatically.
{}
:  Testing Your Installation
{}
After setup, compile and run the test project:
{}
1. Open {\f1\fs20 test/mormot2tests.dpr}
2. Select your target platform (Win32 or Win64)
3. Build and run
4. Review the test results
{}
The test suite covers all framework features and serves as both validation and usage examples.
{}
:2606 FreePascal / Lazarus Installation
{}
:  Supported Targets
{}
You can use the {\i FreePascal Compiler} (FPC) to (cross-)compile {\i mORMot 2} for the following platforms:
{}
{\b Windows:}
- i386-win32
- x86_64-win64
{}
{\b Linux:}
- i386-linux
- x86_64-linux
- arm-linux
- aarch64-linux
{}
{\b macOS:}
- x86_64-darwin
- aarch64-darwin (Apple Silicon)
{}
{\b BSD:}
- x86_64-freebsd
- x86_64-openbsd
- i386-freebsd
{}
Linux is a premium target for efficient server hosting. Since {\i mORMot 2} has minimal dependencies, installing a new server is as simple as copying the executable to a blank Linux host. No runtime frameworks or virtual machines needed.
{}
:  Using the Lazarus Package (Recommended)
{}
The easiest way to set up {\i mORMot 2} for Lazarus is to use the provided package:
{}
{\b Step 1: Get Source and Static Files}
{}
$git clone https://github.com/synopse/mORMot2.git
$cd mORMot2
$# Download and extract mormot2static.tgz into the static/ folder
{}
{\b Step 2: Install the Package}
{}
1. Open Lazarus {\f1\fs20 IDE}
2. Go to {\i Package} → {\i Open Package File (.lpk)}
3. Navigate to {\f1\fs20 packages/lazarus/mormot2.lpk}
4. Click {\i Compile} (not {\i Install} - it's a runtime package)
{}
For UI components, also compile {\f1\fs20 packages/lazarus/mormot2ui.lpk}.
{}
{\b Step 3: Configure Your Project}
{}
Add {\f1\fs20 mormot2} package as a dependency to your Lazarus project:
1. Open your project
2. Go to {\i Project} → {\i Project Inspector}
3. Click {\i Add} → {\i New Requirement}
4. Select {\f1\fs20 mormot2}
{}
:  Manual FPC Setup (Without Package)
{}
For command-line compilation or when not using the package:
{}
{\b Project Options:}
{}
Add to {\i Other unit files (-Fu)}:
!/path/to/mORMot2/src;/path/to/mORMot2/src/core;/path/to/mORMot2/src/lib;/path/to/mORMot2/src/crypt;/path/to/mORMot2/src/net;/path/to/mORMot2/src/db;/path/to/mORMot2/src/rest;/path/to/mORMot2/src/orm;/path/to/mORMot2/src/soa;/path/to/mORMot2/src/app
{}
Add to {\i Include files (-Fi)}:
!/path/to/mORMot2/src
{}
Add to {\i Libraries (-Fl)}:
!/path/to/mORMot2/static/$(TargetCPU)-$(TargetOS)
{}
The {\f1\fs20 $(TargetCPU)-$(TargetOS)} macro automatically selects the correct static library folder based on your compilation target.
{}
:  Setting Up FPC with fpcupdeluxe
{}
We recommend using {\i fpcupdeluxe} to set up a stable FPC/Lazarus environment:
{}
1. Download from @https://github.com/LongDirtyAnimAlf/fpcupdeluxe/releases
2. Run the executable
3. Select FPC version {\f1\fs20 3.2} and Lazarus version matching your needs
4. Click "Install/update FPC+Laz"
{}
{\b Cross-Compilation:}
{}
{\i fpcupdeluxe} makes cross-compilation easy:
1. Go to the "Cross" tab
2. Select your target CPU and OS
3. Click "Install compiler"
4. Download cross-compiler binaries when prompted
{}
This allows you to build Linux executables from Windows, or vice versa.
{}
:  FPC Version Considerations
{}
{\b Recommended:} FPC 3.2.3 (fixes-3_2 branch)
{}
{\b Known Issues:}
- FPC 3.2.2 has a regression with variant late binding - avoid using it
- FPC trunk may have breaking changes; stick to stable branches for production
{}
:  Minimal FPC Console Application
{}
Here's a minimal FPC project structure:
{}
!program MyMormotApp;
!
!{$I mormot.defines.inc}
!{$APPTYPE CONSOLE}
!
!uses
!  {$I mormot.uses.inc}  // Includes FPC-specific units for Linux
!  mormot.core.base,
!  mormot.core.text;
!
!begin
!  writeln('Hello from mORMot 2!');
!  writeln('Current UTC: ', DateTimeToIso8601(NowUtc, true));
!end.
{}
The {\f1\fs20 mormot.uses.inc} file automatically includes the necessary units for FPC on various platforms (e.g., {\f1\fs20 cthreads}, {\f1\fs20 cwstring} on Linux).
{}
:2607 Writing Cross-Platform Code
{}
:  Common Include File
{}
In all your source code files, include the {\i mORMot 2} defines file to set all compiler options and conditionals:
{}
!{$I mormot.defines.inc}
{}
This include file defines essential conditionals like {\f1\fs20 HASINLINE}, {\f1\fs20 OSWINDOWS}, {\f1\fs20 OSPOSIX}, CPU architecture flags, and more.
{}
:  Cross-Platform Guidelines
{}
To ensure your code compiles on both Delphi and FPC, and on multiple platforms:
{}
1. {\b Avoid Direct Windows Unit Usage}: Don't directly reference the {\f1\fs20 Windows} unit in cross-platform code. Use @!src\core\mormot.core.os.pas@ instead.
{}
2. {\b Use Framework Types}: Rely on {\i mORMot 2} types like {\f1\fs20 RawUtf8} for string handling in business logic.
{}
3. {\b Conditional Compilation}: When platform-specific code is needed:
{}
!{$ifdef OSWINDOWS}
!  // Windows-specific code
!{$endif OSWINDOWS}
!
!{$ifdef OSPOSIX}
!  // Linux/macOS/BSD code
!{$endif OSPOSIX}
{}
4. {\b Use {\f1\fs20 mormot.uses.inc}}: In your {\f1\fs20 .dpr}/{\f1\fs20 .lpr} files:
{}
!uses
!  {$I mormot.uses.inc}  // Handles platform-specific units
!  mormot.core.base,
!  // ... your units
{}
:  Conditional Defines Reference
{}
Key conditionals defined in {\f1\fs20 mormot.defines.inc}:
{}
|%22%78
|\b Conditional|Description\b0
|{\f1\fs20 OSWINDOWS}|Compiling for Windows
|{\f1\fs20 OSPOSIX}|Compiling for POSIX (Linux, macOS, BSD)
|{\f1\fs20 OSLINUX}|Compiling for Linux specifically
|{\f1\fs20 OSDARWIN}|Compiling for macOS
|{\f1\fs20 CPU32}|32-bit architecture
|{\f1\fs20 CPU64}|64-bit architecture
|{\f1\fs20 CPUINTEL}|x86 or x86_64 architecture
|{\f1\fs20 CPUARM}|ARM architecture
|{\f1\fs20 FPC}|FreePascal Compiler
|{\f1\fs20 ISDELPHI}|Delphi compiler
|{\f1\fs20 HASINLINE}|Inline functions supported
|{\f1\fs20 PUREMORMOT2}|Use only mORMot 2 type names
|%
{}
:  Recommended Project Structure
{}
For cross-platform projects:
{}
!myproject/
$├── src/
$│   ├── myproject.core.pas      # Business logic (cross-platform)
$│   └── myproject.server.pas    # Server components
$├── bin/
$│   ├── win32/                  # Windows 32-bit output
$│   ├── win64/                  # Windows 64-bit output
$│   └── linux64/                # Linux 64-bit output
$├── test/
$│   └── myproject.tests.dpr     # Regression tests
$├── myproject.server.dpr        # Delphi project
$├── myproject.server.lpr        # Lazarus project
$└── myproject.server.lpi        # Lazarus project info
{}
:2608 Server Deployment
{}
:  Linux Deployment
{}
Deploying a {\i mORMot 2} server on Linux is straightforward:
{}
1. {\b Cross-compile} your application for {\f1\fs20 x86_64-linux} (or your target architecture)
2. {\b Copy} the executable to your Linux server
3. {\b Run} it directly - no runtime dependencies needed
{}
The static linking of SQLite3 and other libraries means you don't need to install anything on the server.
{}
{\b Minimal Dependencies:}
{}
A typical {\i mORMot 2} Linux executable only requires:
!libpthread.so.0   # Threading (standard)
!libdl.so.2        # Dynamic loading (standard)
!libc.so.6         # C library (standard)
{}
These are present on every Linux distribution.
{}
:  Docker Deployment
{}
{\i mORMot 2} works well in Docker containers. A minimal Dockerfile:
{}
$FROM scratch
$COPY myserver /
$ENTRYPOINT ["/myserver"]
{}
Since {\i mORMot 2} executables are statically linked, you can even use a {\f1\fs20 scratch} (empty) base image.
{}
:  Windows Services
{}
For Windows service deployment, use @!src\app\mormot.app.daemon.pas@ which provides cross-platform daemon/service functionality. The same code can run as:
- A Windows Service
- A Linux systemd daemon
- A console application (for debugging)
{}
:2609 Upgrading from mORMot 1.18
{}
:  Why a New Version?
{}
{\i mORMot 2} is a complete rewrite of the framework, addressing:
- Better @*SOLID@ principles adherence
- Split of large monolithic units into focused components
- Cleaner type names ({\f1\fs20 TOrm} instead of {\f1\fs20 TSQLRecord})
- Modern features (OpenSSL, async servers, QuickJS)
- Improved performance through optimized kernels
{}
:  Migration Steps
{}
1. {\b Create a New Folder}: Don't replace mORMot 1.18; install mORMot 2 in a separate location
{}
2. {\b Update Unit Names}: All units have been renamed:
   - {\f1\fs20 SynCommons.pas} → {\f1\fs20 mormot.core.*.pas} (split into multiple units)
   - {\f1\fs20 mORMot.pas} → {\f1\fs20 mormot.orm.{\i .pas} + {\f1\fs20 mormot.rest.}.pas}
   - {\f1\fs20 SynDB{\i .pas} → {\f1\fs20 mormot.db.}.pas}
   - See Chapter 3 for complete unit mapping
{}
3. {\b Update Type Names}: In {\f1\fs20 PUREMORMOT2} mode:
   - {\f1\fs20 TSQLRecord} → {\f1\fs20 TOrm}
   - {\f1\fs20 TSQLRest} → {\f1\fs20 TRest}
   - {\f1\fs20 TSQLModel} → {\f1\fs20 TOrmModel}
{}
4. {\b Review Breaking Changes}:
   - Delphi 5-6 and Kylix support removed
   - BigTable, LVCL, RTTI-UI deprecated
   - Some internal APIs changed
{}
5. {\b Consult Examples}: The {\f1\fs20 ex/} folder contains updated examples showing new patterns
{}
:  Parallel Installation
{}
You can maintain both mORMot 1.18 and mORMot 2 on the same system:
- Keep mORMot 1.18 for legacy projects
- Use mORMot 2 for new development
- Unit names don't conflict, allowing gradual migration
{}
:2610 Getting Help
{}
:  Resources
{}
- {\b Official Documentation}: @https://synopse.info/files/doc/mORMot2.html
- {\b GitHub Repository}: @https://github.com/synopse/mORMot2
- {\b Forum}: @https://synopse.info/forum/viewforum.php?id=24
- {\b Blog}: @https://blog.synopse.info
- {\b Telegram Group}: @https://t.me/synopse_mormot
- {\b Discord Server}: @https://discord.gg/BcmcpY6afj
{}
:  Sample Projects
{}
The {\f1\fs20 ex/} folder contains many examples:
- Basic ORM usage
- HTTP client/server
- Interface-based services
- Domain-Driven Design patterns
- Web @*MVC@ applications
{}
The {\i Thomas Tutorials} ({\f1\fs20 ex/ThirdPartyDemos/tbo/}) provide particularly good step-by-step learning resources.
{}
:  Contributing
{}
Contributions are welcome:
- Submit pull requests via GitHub
- Report issues in the GitHub issue tracker
- Share your experiences on the forum
{}
Consider @https://github.com/synopse/mORMot2/blob/master/DONATE.md if you find it valuable for your projects.
{}